import * as iam from 'aws-cdk-lib/aws-iam';
import * as oss from 'aws-cdk-lib/aws-opensearchserverless';
import { Construct } from 'constructs';
/**
 * Deploys an OpenSearch Serverless Collection to be used as a vector store.
 *
 * It includes all policies.
 */
export declare class VectorCollection extends Construct {
    /**
     * The name of the collection.
     */
    collectionName: string;
    /**
     * The ID of the collection.
     */
    collectionId: string;
    /**
     * The ARN of the collection.
     */
    collectionArn: string;
    /**
     * An IAM policy that allows API access to the collection.
     */
    aossPolicy: iam.ManagedPolicy;
    /**
     * An OpenSearch Access Policy that allows access to the index.
     */
    dataAccessPolicy: oss.CfnAccessPolicy;
    /**
     * An OpenSearch Access Policy document that will become `dataAccessPolicy`.
     * @private
     */
    private dataAccessPolicyDocument;
    constructor(scope: Construct, id: string);
    /**
     * Grants the specified role access to data in the collection.
     * @param grantee The role to grant access to.
     */
    grantDataAccess(grantee: iam.IRole): void;
}
