"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckEventBridgeProps = exports.buildEventBus = void 0;
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const events = require("aws-cdk-lib/aws-events");
function buildEventBus(scope, props) {
    if (props.existingEventBusInterface) {
        return props.existingEventBusInterface;
    }
    else {
        const eventBusName = props.eventBusProps?.eventBusName || 'customEventBus';
        return new events.EventBus(scope, eventBusName, props.eventBusProps);
    }
}
exports.buildEventBus = buildEventBus;
function CheckEventBridgeProps(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    if (propsObject.existingEventBusInterface && propsObject.eventBusProps) {
        errorMessages += 'Error - Either provide existingEventBusInterface or eventBusProps, but not both.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckEventBridgeProps = CheckEventBridgeProps;
//# sourceMappingURL=data:application/json;base64,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