"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDockerLambdaFunction = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
function buildDockerLambdaFunction(scope, id, constructprops, userprops) {
    if (userprops) { // user provided his own custom lambda function, merge his props with the construct ones
        return new lambda.DockerImageFunction(scope, id, {
            // we force some values to be used from the construct
            functionName: constructprops.functionName,
            description: constructprops.description,
            vpc: constructprops.vpc,
            tracing: constructprops.tracing,
            vpcSubnets: constructprops.vpcSubnets,
            securityGroups: constructprops.securityGroups,
            role: constructprops.role,
            memorySize: constructprops.memorySize,
            timeout: constructprops.timeout,
            // add user props
            ...userprops,
            // merge construct env variables with the ones from the construct
            environment: { ...constructprops.environment, ...userprops.environment },
        });
    }
    else { // use values provided by the construct
        return new lambda.DockerImageFunction(scope, id, constructprops);
    }
}
exports.buildDockerLambdaFunction = buildDockerLambdaFunction;
//# sourceMappingURL=data:application/json;base64,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