"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOpenSearchEndpoint = exports.getOpenSearchApiName = exports.CheckOpenSearchProps = void 0;
function CheckOpenSearchProps(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    if (propsObject.existingOpenSearchDomain && propsObject.existingOpenSearchServerlessCollection) {
        errorMessages += 'Error - Either provide existingOpenSearchDomain or existingOpenSearchServerlessCollection, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingOpenSearchDomain === null && propsObject.existingOpenSearchServerlessCollection === null) {
        errorMessages += 'Error - existingOpenSearchDomain and existingOpenSearchServerlessCollection cannot both be null. Please provide one.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckOpenSearchProps = CheckOpenSearchProps;
function getOpenSearchApiName(propsObject) {
    if (propsObject.existingOpensearchDomain) {
        return 'es';
    }
    else if (propsObject.existingOpensearchServerlessCollection) {
        return 'aoss';
    }
    throw new Error('OpenSearch resouce not defined.');
}
exports.getOpenSearchApiName = getOpenSearchApiName;
function getOpenSearchEndpoint(propsObject) {
    if (propsObject.existingOpensearchDomain) {
        return propsObject.existingOpensearchDomain.domainEndpoint;
    }
    else if (propsObject.existingOpensearchServerlessCollection) {
        return propsObject.existingOpensearchServerlessCollection.attrCollectionEndpoint;
    }
    throw new Error('OpenSearch resouce not defined.');
}
exports.getOpenSearchEndpoint = getOpenSearchEndpoint;
//# sourceMappingURL=data:application/json;base64,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