"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckS3Props = void 0;
function CheckS3Props(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    if ((propsObject.existingBucketObj || propsObject.existingBucketInterface) && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingLoggingBucketObj && propsObject.loggingBucketProps) {
        errorMessages += 'Error - Either provide existingLoggingBucketObj or loggingBucketProps, but not both.\n';
        errorFound = true;
    }
    if ((propsObject?.logS3AccessLogs === false) && (propsObject.loggingBucketProps || propsObject.existingLoggingBucketObj)) {
        errorMessages += 'Error - If logS3AccessLogs is false, supplying loggingBucketProps or existingLoggingBucketObj is invalid.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketObj && (propsObject.loggingBucketProps || propsObject.logS3AccessLogs)) {
        errorMessages += 'Error - If existingBucketObj is provided, supplying loggingBucketProps or logS3AccessLogs is an error.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckS3Props = CheckS3Props;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiczMtYnVja2V0LWhlbHBlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21tb24vaGVscGVycy9zMy1idWNrZXQtaGVscGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBY0gsU0FBZ0IsWUFBWSxDQUFDLFdBQTBCO0lBQ3JELElBQUksYUFBYSxHQUFHLEVBQUUsQ0FBQztJQUN2QixJQUFJLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFFdkIsSUFBSSxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsSUFBSSxXQUFXLENBQUMsdUJBQXVCLENBQUMsSUFBSSxXQUFXLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDdEcsYUFBYSxJQUFJLDBFQUEwRSxDQUFDO1FBQzVGLFVBQVUsR0FBRyxJQUFJLENBQUM7SUFDcEIsQ0FBQztJQUVELElBQUksV0FBVyxDQUFDLHdCQUF3QixJQUFJLFdBQVcsQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1FBQzNFLGFBQWEsSUFBSSx3RkFBd0YsQ0FBQztRQUMxRyxVQUFVLEdBQUcsSUFBSSxDQUFDO0lBQ3BCLENBQUM7SUFFRCxJQUFJLENBQUMsV0FBVyxFQUFFLGVBQWUsS0FBSyxLQUFLLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxrQkFBa0IsSUFBSSxXQUFXLENBQUMsd0JBQXdCLENBQUMsRUFBRSxDQUFDO1FBQ3pILGFBQWEsSUFBSSw2R0FBNkcsQ0FBQztRQUMvSCxVQUFVLEdBQUcsSUFBSSxDQUFDO0lBQ3BCLENBQUM7SUFFRCxJQUFJLFdBQVcsQ0FBQyxpQkFBaUIsSUFBSSxDQUFDLFdBQVcsQ0FBQyxrQkFBa0IsSUFBSSxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUUsQ0FBQztRQUNyRyxhQUFhLElBQUksMEdBQTBHLENBQUM7UUFDNUgsVUFBVSxHQUFHLElBQUksQ0FBQztJQUNwQixDQUFDO0lBRUQsSUFBSSxVQUFVLEVBQUUsQ0FBQztRQUNmLE1BQU0sSUFBSSxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDakMsQ0FBQztBQUNILENBQUM7QUEzQkQsb0NBMkJDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgczMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXMzJztcblxuXG5leHBvcnQgaW50ZXJmYWNlIFMzUHJvcHMge1xuICByZWFkb25seSBleGlzdGluZ0J1Y2tldE9iaj86IHMzLkJ1Y2tldDtcbiAgcmVhZG9ubHkgZXhpc3RpbmdCdWNrZXRJbnRlcmZhY2U/OiBzMy5JQnVja2V0O1xuICByZWFkb25seSBidWNrZXRQcm9wcz86IHMzLkJ1Y2tldFByb3BzO1xuICByZWFkb25seSBleGlzdGluZ0xvZ2dpbmdCdWNrZXRPYmo/OiBzMy5JQnVja2V0O1xuICByZWFkb25seSBsb2dnaW5nQnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wcztcbiAgcmVhZG9ubHkgbG9nUzNBY2Nlc3NMb2dzPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIENoZWNrUzNQcm9wcyhwcm9wc09iamVjdDogUzNQcm9wcyB8IGFueSkge1xuICBsZXQgZXJyb3JNZXNzYWdlcyA9ICcnO1xuICBsZXQgZXJyb3JGb3VuZCA9IGZhbHNlO1xuXG4gIGlmICgocHJvcHNPYmplY3QuZXhpc3RpbmdCdWNrZXRPYmogfHwgcHJvcHNPYmplY3QuZXhpc3RpbmdCdWNrZXRJbnRlcmZhY2UpICYmIHByb3BzT2JqZWN0LmJ1Y2tldFByb3BzKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSBidWNrZXRQcm9wcyBvciBleGlzdGluZ0J1Y2tldE9iaiwgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAocHJvcHNPYmplY3QuZXhpc3RpbmdMb2dnaW5nQnVja2V0T2JqICYmIHByb3BzT2JqZWN0LmxvZ2dpbmdCdWNrZXRQcm9wcykge1xuICAgIGVycm9yTWVzc2FnZXMgKz0gJ0Vycm9yIC0gRWl0aGVyIHByb3ZpZGUgZXhpc3RpbmdMb2dnaW5nQnVja2V0T2JqIG9yIGxvZ2dpbmdCdWNrZXRQcm9wcywgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAoKHByb3BzT2JqZWN0Py5sb2dTM0FjY2Vzc0xvZ3MgPT09IGZhbHNlKSAmJiAocHJvcHNPYmplY3QubG9nZ2luZ0J1Y2tldFByb3BzIHx8IHByb3BzT2JqZWN0LmV4aXN0aW5nTG9nZ2luZ0J1Y2tldE9iaikpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIElmIGxvZ1MzQWNjZXNzTG9ncyBpcyBmYWxzZSwgc3VwcGx5aW5nIGxvZ2dpbmdCdWNrZXRQcm9wcyBvciBleGlzdGluZ0xvZ2dpbmdCdWNrZXRPYmogaXMgaW52YWxpZC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKHByb3BzT2JqZWN0LmV4aXN0aW5nQnVja2V0T2JqICYmIChwcm9wc09iamVjdC5sb2dnaW5nQnVja2V0UHJvcHMgfHwgcHJvcHNPYmplY3QubG9nUzNBY2Nlc3NMb2dzKSkge1xuICAgIGVycm9yTWVzc2FnZXMgKz0gJ0Vycm9yIC0gSWYgZXhpc3RpbmdCdWNrZXRPYmogaXMgcHJvdmlkZWQsIHN1cHBseWluZyBsb2dnaW5nQnVja2V0UHJvcHMgb3IgbG9nUzNBY2Nlc3NMb2dzIGlzIGFuIGVycm9yLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAoZXJyb3JGb3VuZCkge1xuICAgIHRocm93IG5ldyBFcnJvcihlcnJvck1lc3NhZ2VzKTtcbiAgfVxufVxuIl19