import * as appsync from 'aws-cdk-lib/aws-appsync';
import * as cognito from 'aws-cdk-lib/aws-cognito';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as events from 'aws-cdk-lib/aws-events';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { BaseClass } from '../../../common/base-class';
import { DockerLambdaCustomProps } from '../../../common/props/DockerLambdaCustomProps';
/**
 * The properties for the ContentGenerationAppSyncLambdaProps class.
 */
export interface ContentGenerationAppSyncLambdaProps {
    /**
     * Optional custom properties for a VPC the construct will create. This VPC will
     * be used by the Lambda functions the construct creates. Providing
     * both this and existingVpc is an error.
     *
     * @default - none
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * Optional An existing VPC in which to deploy the construct. Providing both this and
     * vpcProps is an error.
     *
     * @default - none
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Optional existing security group allowing access to opensearch. Used by the lambda functions
     * built by this construct. If not provided, the construct will create one.
     *
     * @default - none
     */
    readonly existingSecurityGroup?: ec2.ISecurityGroup;
    /**
     * Optional Existing instance of an EventBridge bus. If not provided, the construct will create one.
     *
     * @default - None
     */
    readonly existingBusInterface?: events.IEventBus;
    /**
     * Existing instance of S3 Bucket object, providing both this and `generatedAssetsBucketProps` will cause an error.
     *
     * @default - None
     */
    readonly existingGeneratedAssetsBucketObj?: s3.IBucket;
    /**
     * Optional user provided props to override the default props for the S3 Bucket.
     * Providing both this and `existingGeneratedAssetsBucketObj` will cause an error.
     *
     * @default - Default props are used
     */
    readonly generatedAssetsBucketProps?: s3.BucketProps;
    /**
     * Existing merged Appsync GraphQL api.
     *
     * @default - None
     */
    readonly existingMergedApi?: appsync.CfnGraphQLApi;
    /**
     * Cognito user pool used for authentication.
     *
     * @default - None
     */
    readonly cognitoUserPool: cognito.IUserPool;
    /**
     * Value will be appended to resources name.
     *
     * @default - _dev
     */
    readonly stage?: string;
    /**
     * Enable observability. Warning: associated cost with the services
     * used. Best practive to enable by default.
     *
     * @default - true
     */
    readonly observability?: boolean;
    /**
     * Optional.CDK constructs provided collects anonymous operational
     * metrics to help AWS improve the quality and features of the
     * constructs. Data collection is subject to the AWS Privacy Policy
     * (https://aws.amazon.com/privacy/). To opt out of this feature,
     * simply disable it by setting the construct property
     * "enableOperationalMetric" to false for each construct used.
     *
     * @default - true
     */
    readonly enableOperationalMetric?: boolean;
    /**
     * Optional. Allows a user to configure
     * Lambda provisioned concurrency for consistent performance
     */
    readonly lambdaProvisionedConcurrency?: number | undefined;
    /**
     * Optional. Allows to provide custom lambda code
     * and settings instead of the existing
     */
    readonly customDockerLambdaProps?: DockerLambdaCustomProps | undefined;
}
/**
 * @summary The ContentGenerationAppSyncLambda class.
 */
export declare class ContentGenerationAppSyncLambda extends BaseClass {
    /**
     * Returns the instance of ec2.IVpc used by the construct
     */
    readonly vpc: ec2.IVpc;
    /**
     * Returns the instance of ec2.ISecurityGroup used by the construct
     */
    readonly securityGroup: ec2.ISecurityGroup;
    /**
     * Returns the instance of events.IEventBus used by the construct
     */
    readonly generatedImageBus: events.IEventBus;
    /**
     * Returns an instance of s3.IBucket created by the construct
     */
    readonly s3GenerateAssetsBucketInterface: s3.IBucket;
    /**
     * Returns an instance of s3.Bucket created by the construct.
     * IMPORTANT: If existingGeneratedAssetsBucketObj was provided in Pattern Construct Props,
     * this property will be undefined
     */
    readonly s3GenerateAssetsBucket?: s3.Bucket;
    /**
     * Returns an instance of appsync.IGraphqlApi created by the construct
     */
    readonly graphqlApi: appsync.IGraphqlApi;
    /**
     * Returns an instance of appsync.IGraphqlApi created by the construct
     */
    readonly cgLambdaFunction: lambda.DockerImageFunction;
    /**
     * @summary Constructs a new instance of the ContentGenerationAppSyncLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ContentGenerationAppSyncLambdaProps} props - user provided props for the construct.
     * @since 0.0.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: ContentGenerationAppSyncLambdaProps);
}
