import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { AdapterProps } from '../../../common/props/AdapterProps';
import { LangchainProps } from '../../../common/props/LangchainProps';
/**
 * The properties for the LangchainLayerProps class.
 */
export interface LangchainLayerProps extends LangchainProps {
    /**
     * Required. Lambda function runtime compatible with this Layer.
     */
    readonly runtime: lambda.Runtime;
    /**
     * Required. Lambda function architecture compatible with this Layer.
     */
    readonly architecture: lambda.Architecture;
    /**
     * Optional: Add '--upgrade' to pip install requirements.txt
     * In case of a LangchainCommonLayer, this parameter is not used.
     *
     * @default - false
     */
    readonly autoUpgrade?: boolean;
    /**
     * A prop allowing additional python pip libraries to be installed with this langchain layer
     *
     * @default - none
     */
    readonly additionalPackages?: string[];
    /** Optional: Local compute will be used when installing requirements.txt.
     * By default, a docker container will be spun up to install requirements. To override this behavior, use the python alias string of `python` or `python3`
     * The string value will be the python alias used to install requirements.
     *
     * @default - none
     */
    readonly local?: 'python' | 'python3';
}
/**
   * @summary The LangchainCommonDepsLayer class.
   */
export declare class LangchainCommonDepsLayer extends Construct {
    /**
     * Returns the instance of lambda.LayerVersion created by the construct
     */
    readonly layer: lambda.LayerVersion;
    /**
       * @summary This construct creates a lambda layer loaded with relevant libraries to run genai applications. Libraries include boto3, botocore, requests, requests-aws4auth, langchain, opensearch-py and openai.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {LangchainLayerProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: LangchainLayerProps);
}
/**
   * @summary LangchainCommonLayer allows developers to instantiate a llm client adapter on bedrock, sagemaker or openai following best practise.
   *
   * @example
   * import boto3
   * from genai_core.adapters.registry import registry
   *
   * adapter = registry.get_adapter(f"{provider}.{model_id}")
   * bedrock_client = boto3.client('bedrock-runtime')
   */
export declare class LangchainCommonLayer extends Construct {
    /**
     * Returns the instance of lambda.LayerVersion created by the construct
     */
    readonly layer: lambda.LayerVersion;
    /**
       * @summary This construct allows developers to instantiate a llm client adapter on bedrock, sagemaker or openai following best practise.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {AdapterProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: AdapterProps);
}
