"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LangchainCommonLayer = exports.LangchainCommonDepsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const python_lambda_layer_helper_1 = require("../../../common/helpers/python-lambda-layer-helper");
/**
   * @summary The LangchainCommonDepsLayer class.
   */
class LangchainCommonDepsLayer extends constructs_1.Construct {
    /**
       * @summary This construct creates a lambda layer loaded with relevant libraries to run genai applications. Libraries include boto3, botocore, requests, requests-aws4auth, langchain, opensearch-py and openai.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {LangchainLayerProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        const layer = new python_lambda_layer_helper_1.Layer(this, 'Langchain Layer', {
            path: path.join(__dirname, '../../../../layers/langchain-common-deps'),
            description: 'Dependencies to build gen ai applications with the langchain client',
            ...props,
        });
        this.layer = layer.layer;
    }
}
exports.LangchainCommonDepsLayer = LangchainCommonDepsLayer;
_a = JSII_RTTI_SYMBOL_1;
LangchainCommonDepsLayer[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.LangchainCommonDepsLayer", version: "0.1.94" };
/**
   * @summary LangchainCommonLayer allows developers to instantiate a llm client adapter on bedrock, sagemaker or openai following best practise.
   *
   * @example
   * import boto3
   * from genai_core.adapters.registry import registry
   *
   * adapter = registry.get_adapter(f"{provider}.{model_id}")
   * bedrock_client = boto3.client('bedrock-runtime')
   */
class LangchainCommonLayer extends constructs_1.Construct {
    /**
       * @summary This construct allows developers to instantiate a llm client adapter on bedrock, sagemaker or openai following best practise.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {AdapterProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        const layer = new lambda.LayerVersion(this, 'Model Adapter Layer', {
            code: lambda.Code.fromAsset(path.join(__dirname, '../../../../layers/langchain-common-layer')),
            description: 'Utilities to instantiate a llm client adapter. Adapters include bedrock, sagemaker, and openai',
            ...props,
        });
        this.layer = layer;
    }
}
exports.LangchainCommonLayer = LangchainCommonLayer;
_b = JSII_RTTI_SYMBOL_1;
LangchainCommonLayer[_b] = { fqn: "@cdklabs/generative-ai-cdk-constructs.LangchainCommonLayer", version: "0.1.94" };
//# sourceMappingURL=data:application/json;base64,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