"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeepLearningContainerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecr = require("aws-cdk-lib/aws-ecr");
const region_info_1 = require("aws-cdk-lib/region-info");
const container_image_1 = require("./container-image");
class DeepLearningContainerImage extends container_image_1.ContainerImage {
    static fromDeepLearningContainerImage(repositoryName, tag, accountId) {
        return new _a(repositoryName, tag, accountId);
    }
    constructor(repositoryName, tag, accountId) {
        super();
        this.repositoryName = repositoryName;
        this.tag = tag;
        this.accountId = accountId;
    }
    bind(scope, grantable) {
        const accountId = this.accountId ??
            aws_cdk_lib_1.Stack.of(scope).regionalFact(region_info_1.FactName.DLC_REPOSITORY_ACCOUNT);
        const repository = ecr.Repository.fromRepositoryAttributes(scope, 'DeepLearningContainerRepository', {
            repositoryName: this.repositoryName,
            repositoryArn: ecr.Repository.arnForLocalRepository(this.repositoryName, scope, accountId),
        });
        repository.grantPull(grantable);
        return { imageName: repository.repositoryUri + ':' + this.tag };
    }
}
exports.DeepLearningContainerImage = DeepLearningContainerImage;
_a = DeepLearningContainerImage, _b = JSII_RTTI_SYMBOL_1;
DeepLearningContainerImage[_b] = { fqn: "@cdklabs/generative-ai-cdk-constructs.DeepLearningContainerImage", version: "0.1.94" };
DeepLearningContainerImage.DJL_INFERENCE_0_19_0_DEEPSPEED0_7_3_CU113 = _a.fromDeepLearningContainerImage('djl-inference', '0.19.0-deepspeed0.7.3-cu113');
DeepLearningContainerImage.DJL_INFERENCE_0_20_0_DEEPSPEED0_7_5_CU116 = _a.fromDeepLearningContainerImage('djl-inference', '0.20.0-deepspeed0.7.5-cu116');
DeepLearningContainerImage.DJL_INFERENCE_0_21_0_DEEPSPEED0_8_0_CU117 = _a.fromDeepLearningContainerImage('djl-inference', '0.21.0-deepspeed0.8.0-cu117');
DeepLearningContainerImage.DJL_INFERENCE_0_21_0_DEEPSPEED0_8_3_CU117 = _a.fromDeepLearningContainerImage('djl-inference', '0.21.0-deepspeed0.8.3-cu117');
DeepLearningContainerImage.DJL_INFERENCE_0_21_0_FASTERTRANSFORMER5_3_0_CU117 = _a.fromDeepLearningContainerImage('djl-inference', '0.21.0-fastertransformer5.3.0-cu117');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_DEEPSPEED0_8_3_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-deepspeed0.8.3-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_DEEPSPEED0_9_2_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-deepspeed0.9.2-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_FASTERTRANSFORMER5_3_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-fastertransformer5.3.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_NEURONX_SDK2_10_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-neuronx-sdk2.10.0');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_NEURONX_SDK2_9_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-neuronx-sdk2.9.0');
DeepLearningContainerImage.DJL_INFERENCE_0_23_0_DEEPSPEED0_9_5_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.23.0-deepspeed0.9.5-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_23_0_FASTERTRANSFORMER5_3_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.23.0-fastertransformer5.3.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_23_0_NEURONX_SDK2_12_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.23.0-neuronx-sdk2.12.0');
DeepLearningContainerImage.DJL_INFERENCE_0_24_0_DEEPSPEED0_10_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.24.0-deepspeed0.10.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_24_0_FASTERTRANSFORMER5_3_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.24.0-fastertransformer5.3.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_24_0_NEURONX_SDK2_14_1 = _a.fromDeepLearningContainerImage('djl-inference', '0.24.0-neuronx-sdk2.14.1');
DeepLearningContainerImage.DJL_INFERENCE_0_25_0_DEEPSPEED0_11_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.25.0-deepspeed0.11.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_25_0_NEURONX_SDK2_15_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.25.0-neuronx-sdk2.15.0');
DeepLearningContainerImage.DJL_INFERENCE_0_26_0_DEEPSPEED0_12_6_CU121 = _a.fromDeepLearningContainerImage('djl-inference', '0.26.0-deepspeed0.12.6-cu121');
DeepLearningContainerImage.DJL_INFERENCE_0_26_0_NEURONX_SDK2_16_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.26.0-neuronx-sdk2.16.0');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_10_2_TRANSFORMERS4_17_0_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.10.2-transformers4.17.0-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_10_2_TRANSFORMERS4_17_0_GPU_PY38_CU113_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.10.2-transformers4.17.0-gpu-py38-cu113-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_13_1_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.13.1-transformers4.26.0-cpu-py39-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_13_1_TRANSFORMERS4_26_0_GPU_PY39_CU117_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.13.1-transformers4.26.0-gpu-py39-cu117-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_7_1_TRANSFORMERS4_6_1_CPU_PY36_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.7.1-transformers4.6.1-cpu-py36-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_7_1_TRANSFORMERS4_6_1_GPU_PY36_CU110_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.7.1-transformers4.6.1-gpu-py36-cu110-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_10_2_CPU_PY36_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.10.2-cpu-py36-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_10_2_GPU_PY36_CU111_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.10.2-gpu-py36-cu111-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_6_1_CPU_PY36_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.6.1-cpu-py36-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_6_1_GPU_PY36_CU111_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.6.1-gpu-py36-cu111-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_10_2_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.10.2-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_10_2_GPU_PY38_CU111_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.10.2-gpu-py38-cu111-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_11_0_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.11.0-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_11_0_GPU_PY38_CU111_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.11.0-gpu-py38-cu111-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_1_TRANSFORMERS4_12_3_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.1-transformers4.12.3-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_1_TRANSFORMERS4_12_3_GPU_PY38_CU111_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.1-transformers4.12.3-gpu-py38-cu111-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_2_0_0_TRANSFORMERS4_28_1_CPU_PY310_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '2.0.0-transformers4.28.1-cpu-py310-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_2_0_0_TRANSFORMERS4_28_1_GPU_PY310_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '2.0.0-transformers4.28.1-gpu-py310-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_2_1_0_TRANSFORMERS4_37_0_CPU_PY310_UBUNTU22_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '2.1.0-transformers4.37.0-cpu-py310-ubuntu22.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_2_1_0_TRANSFORMERS4_37_0_GPU_PY310_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '2.1.0-transformers4.37.0-gpu-py310-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_NEURONX_1_13_0_TRANSFORMERS4_28_1_NEURONX_PY38_SDK2_9_1_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference-neuronx', '1.13.0-transformers4.28.1-neuronx-py38-sdk2.9.1-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_NEURONX_1_13_1_TRANSFORMERS4_34_1_NEURONX_PY310_SDK2_15_0_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference-neuronx', '1.13.1-transformers4.34.1-neuronx-py310-sdk2.15.0-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_NEURONX_1_13_1_TRANSFORMERS4_36_2_NEURONX_PY310_SDK2_16_1_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference-neuronx', '1.13.1-transformers4.36.2-neuronx-py310-sdk2.16.1-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_0_TGI0_6_0_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.0-tgi0.6.0-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_0_TGI0_8_2_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.0-tgi0.8.2-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI0_9_3_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.1-tgi0.9.3-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI1_0_3_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.1-tgi1.0.3-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI1_1_0_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.1-tgi1.1.0-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_1_1_TGI1_2_0_GPU_PY310_CU121_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.1.1-tgi1.2.0-gpu-py310-cu121-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_1_1_TGI1_3_1_GPU_PY310_CU121_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.1.1-tgi1.3.1-gpu-py310-cu121-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_1_1_TGI1_3_3_GPU_PY310_CU121_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.1.1-tgi1.3.3-gpu-py310-cu121-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_1_1_TGI1_4_0_GPU_PY310_CU121_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.1.1-tgi1.4.0-gpu-py310-cu121-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_1_1_TGI1_4_2_GPU_PY310_CU121_UBUNTU22_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.1.1-tgi1.4.2-gpu-py310-cu121-ubuntu22.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_0_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.0-transformers4.26.0-cpu-py39-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_0_TRANSFORMERS4_26_0_GPU_PY39_CU112_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.0-transformers4.26.0-gpu-py39-cu112-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_1_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.1-transformers4.26.0-cpu-py39-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_1_TRANSFORMERS4_26_0_GPU_PY39_CU112_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.1-transformers4.26.0-gpu-py39-cu112-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_1_TRANSFORMERS4_6_1_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.1-transformers4.6.1-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_1_TRANSFORMERS4_6_1_GPU_PY37_CU110_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.1-transformers4.6.1-gpu-py37-cu110-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_3_TRANSFORMERS4_10_2_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.3-transformers4.10.2-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_3_TRANSFORMERS4_10_2_GPU_PY37_CU110_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.3-transformers4.10.2-gpu-py37-cu110-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_10_2_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.10.2-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_10_2_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.10.2-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_11_0_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.11.0-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_11_0_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.11.0-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_12_3_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.12.3-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_12_3_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.12.3-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_3_TRANSFORMERS4_12_3_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.3-transformers4.12.3-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_3_TRANSFORMERS4_12_3_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.3-transformers4.12.3-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_6_3_TRANSFORMERS4_17_0_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.6.3-transformers4.17.0-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_6_3_TRANSFORMERS4_17_0_GPU_PY38_CU112_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.6.3-transformers4.17.0-gpu-py38-cu112-ubuntu20.04');
//# sourceMappingURL=data:application/json;base64,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