import * as iam from 'aws-cdk-lib/aws-iam';
import * as sagemaker from 'aws-cdk-lib/aws-sagemaker';
import { Construct } from 'constructs';
import { ContainerImage } from './container-image';
import { SageMakerEndpointBase } from './sagemaker-endpoint-base';
import { SageMakerInstanceType } from './sagemaker-instance-type';
export interface HuggingFaceSageMakerEndpointProps {
    readonly modelId: string;
    readonly container: ContainerImage;
    readonly endpointName?: string;
    readonly instanceType: SageMakerInstanceType;
    readonly instanceCount?: number;
    readonly role?: iam.Role;
    readonly environment?: {
        [key: string]: string;
    };
    readonly startupHealthCheckTimeoutInSeconds?: number;
    readonly vpcConfig?: sagemaker.CfnModel.VpcConfigProperty | undefined;
    readonly enableOperationalMetric?: boolean;
}
/**
 * @summary The HuggingFaceSageMakerEndpoint class.
 */
export declare class HuggingFaceSageMakerEndpoint extends SageMakerEndpointBase implements iam.IGrantable {
    readonly grantPrincipal: iam.IPrincipal;
    readonly endpointArn: string;
    readonly cfnModel: sagemaker.CfnModel;
    readonly cfnEndpoint: sagemaker.CfnEndpoint;
    readonly cfnEndpointConfig: sagemaker.CfnEndpointConfig;
    readonly modelId: string;
    readonly instanceType: SageMakerInstanceType;
    readonly instanceCount: number;
    readonly role: iam.Role;
    private readonly startupHealthCheckTimeoutInSeconds;
    private readonly environment?;
    constructor(scope: Construct, id: string, props: HuggingFaceSageMakerEndpointProps);
    addToRolePolicy(statement: iam.PolicyStatement): void;
    grantInvoke(grantee: iam.IGrantable): iam.Grant;
}
