"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SageMakerInstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib/core");
/**
 * Supported instance types for SageMaker instance-based production variants.
 */
class SageMakerInstanceType {
    /**
     * Builds an InstanceType from a given string or token (such as a CfnParameter).
     * @param instanceType An instance type as string
     * @returns A strongly typed InstanceType
     */
    static of(instanceType) {
        return new SageMakerInstanceType(instanceType);
    }
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('ml.')) {
            this.instanceTypeIdentifier = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'ml.'; (got ${instanceType})`);
        }
    }
    /**
     * Return the instance type as a string
     * @returns The instance type as a string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
exports.SageMakerInstanceType = SageMakerInstanceType;
_a = JSII_RTTI_SYMBOL_1;
SageMakerInstanceType[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.SageMakerInstanceType", version: "0.1.94" };
/**
 * ml.c4.2xlarge
 */
SageMakerInstanceType.ML_C4_2XLARGE = SageMakerInstanceType.of('ml.c4.2xlarge');
/**
 * ml.c4.4xlarge
 */
SageMakerInstanceType.ML_C4_4XLARGE = SageMakerInstanceType.of('ml.c4.4xlarge');
/**
 * ml.c4.8xlarge
 */
SageMakerInstanceType.ML_C4_8XLARGE = SageMakerInstanceType.of('ml.c4.8xlarge');
/**
 * ml.c4.large
 */
SageMakerInstanceType.ML_C4_LARGE = SageMakerInstanceType.of('ml.c4.large');
/**
 * ml.c4.xlarge
 */
SageMakerInstanceType.ML_C4_XLARGE = SageMakerInstanceType.of('ml.c4.xlarge');
/**
 * ml.c5.18xlarge
 */
SageMakerInstanceType.ML_C5_18XLARGE = SageMakerInstanceType.of('ml.c5.18xlarge');
/**
 * ml.c5.2xlarge
 */
SageMakerInstanceType.ML_C5_2XLARGE = SageMakerInstanceType.of('ml.c5.2xlarge');
/**
 * ml.c5.4xlarge
 */
SageMakerInstanceType.ML_C5_4XLARGE = SageMakerInstanceType.of('ml.c5.4xlarge');
/**
 * ml.c5.9xlarge
 */
SageMakerInstanceType.ML_C5_9XLARGE = SageMakerInstanceType.of('ml.c5.9xlarge');
/**
 * ml.c5.large
 */
SageMakerInstanceType.ML_C5_LARGE = SageMakerInstanceType.of('ml.c5.large');
/**
 * ml.c5.xlarge
 */
SageMakerInstanceType.ML_C5_XLARGE = SageMakerInstanceType.of('ml.c5.xlarge');
/**
 * ml.c5d.18xlarge
 */
SageMakerInstanceType.ML_C5D_18XLARGE = SageMakerInstanceType.of('ml.c5d.18xlarge');
/**
 * ml.c5d.2xlarge
 */
SageMakerInstanceType.ML_C5D_2XLARGE = SageMakerInstanceType.of('ml.c5d.2xlarge');
/**
 * ml.c5d.4xlarge
 */
SageMakerInstanceType.ML_C5D_4XLARGE = SageMakerInstanceType.of('ml.c5d.4xlarge');
/**
 * ml.c5d.9xlarge
 */
SageMakerInstanceType.ML_C5D_9XLARGE = SageMakerInstanceType.of('ml.c5d.9xlarge');
/**
 * ml.c5d.large
 */
SageMakerInstanceType.ML_C5D_LARGE = SageMakerInstanceType.of('ml.c5d.large');
/**
 * ml.c5d.xlarge
 */
SageMakerInstanceType.ML_C5D_XLARGE = SageMakerInstanceType.of('ml.c5d.xlarge');
/**
 * ml.c6i.12xlarge
 */
SageMakerInstanceType.ML_C6I_12XLARGE = SageMakerInstanceType.of('ml.c6i.12xlarge');
/**
 * ml.c6i.16xlarge
 */
SageMakerInstanceType.ML_C6I_16XLARGE = SageMakerInstanceType.of('ml.c6i.16xlarge');
/**
 * ml.c6i.24xlarge
 */
SageMakerInstanceType.ML_C6I_24XLARGE = SageMakerInstanceType.of('ml.c6i.24xlarge');
/**
 * ml.c6i.2xlarge
 */
SageMakerInstanceType.ML_C6I_2XLARGE = SageMakerInstanceType.of('ml.c6i.2xlarge');
/**
 * ml.c6i.32xlarge
 */
SageMakerInstanceType.ML_C6I_32XLARGE = SageMakerInstanceType.of('ml.c6i.32xlarge');
/**
 * ml.c6i.4xlarge
 */
SageMakerInstanceType.ML_C6I_4XLARGE = SageMakerInstanceType.of('ml.c6i.4xlarge');
/**
 * ml.c6i.8xlarge
 */
SageMakerInstanceType.ML_C6I_8XLARGE = SageMakerInstanceType.of('ml.c6i.8xlarge');
/**
 * ml.c6i.large
 */
SageMakerInstanceType.ML_C6I_LARGE = SageMakerInstanceType.of('ml.c6i.large');
/**
 * ml.c6i.xlarge
 */
SageMakerInstanceType.ML_C6I_XLARGE = SageMakerInstanceType.of('ml.c6i.xlarge');
/**
 * ml.g4dn.12xlarge
 */
SageMakerInstanceType.ML_G4DN_12XLARGE = SageMakerInstanceType.of('ml.g4dn.12xlarge');
/**
 * ml.g4dn.16xlarge
 */
SageMakerInstanceType.ML_G4DN_16XLARGE = SageMakerInstanceType.of('ml.g4dn.16xlarge');
/**
 * ml.g4dn.2xlarge
 */
SageMakerInstanceType.ML_G4DN_2XLARGE = SageMakerInstanceType.of('ml.g4dn.2xlarge');
/**
 * ml.g4dn.4xlarge
 */
SageMakerInstanceType.ML_G4DN_4XLARGE = SageMakerInstanceType.of('ml.g4dn.4xlarge');
/**
 * ml.g4dn.8xlarge
 */
SageMakerInstanceType.ML_G4DN_8XLARGE = SageMakerInstanceType.of('ml.g4dn.8xlarge');
/**
 * ml.g4dn.xlarge
 */
SageMakerInstanceType.ML_G4DN_XLARGE = SageMakerInstanceType.of('ml.g4dn.xlarge');
/**
 * ml.g5.12xlarge
 */
SageMakerInstanceType.ML_G5_12XLARGE = SageMakerInstanceType.of('ml.g5.12xlarge');
/**
 * ml.g5.16xlarge
 */
SageMakerInstanceType.ML_G5_16XLARGE = SageMakerInstanceType.of('ml.g5.16xlarge');
/**
 * ml.g5.24xlarge
 */
SageMakerInstanceType.ML_G5_24XLARGE = SageMakerInstanceType.of('ml.g5.24xlarge');
/**
 * ml.g5.2xlarge
 */
SageMakerInstanceType.ML_G5_2XLARGE = SageMakerInstanceType.of('ml.g5.2xlarge');
/**
 * ml.g5.48xlarge
 */
SageMakerInstanceType.ML_G5_48XLARGE = SageMakerInstanceType.of('ml.g5.48xlarge');
/**
 * ml.g5.4xlarge
 */
SageMakerInstanceType.ML_G5_4XLARGE = SageMakerInstanceType.of('ml.g5.4xlarge');
/**
 * ml.g5.8xlarge
 */
SageMakerInstanceType.ML_G5_8XLARGE = SageMakerInstanceType.of('ml.g5.8xlarge');
/**
 * ml.g5.xlarge
 */
SageMakerInstanceType.ML_G5_XLARGE = SageMakerInstanceType.of('ml.g5.xlarge');
/**
 * ml.inf1.24xlarge
 */
SageMakerInstanceType.ML_INF1_24XLARGE = SageMakerInstanceType.of('ml.inf1.24xlarge');
/**
 * ml.inf1.2xlarge
 */
SageMakerInstanceType.ML_INF1_2XLARGE = SageMakerInstanceType.of('ml.inf1.2xlarge');
/**
 * ml.inf1.6xlarge
 */
SageMakerInstanceType.ML_INF1_6XLARGE = SageMakerInstanceType.of('ml.inf1.6xlarge');
/**
 * ml.inf1.xlarge
 */
SageMakerInstanceType.ML_INF1_XLARGE = SageMakerInstanceType.of('ml.inf1.xlarge');
/**
 * ml.inf2.xlarge
 */
SageMakerInstanceType.ML_INF2_XLARGE = SageMakerInstanceType.of('ml.inf2.xlarge');
/**
 * ml.inf2.8xlarge
 */
SageMakerInstanceType.ML_INF2_8XLARGE = SageMakerInstanceType.of('ml.inf2.8xlarge');
/**
 * ml.inf2.24xlarge
 */
SageMakerInstanceType.ML_INF2_24XLARGE = SageMakerInstanceType.of('ml.inf2.24xlarge');
/**
 * ml.inf2.48xlarge
 */
SageMakerInstanceType.ML_INF2_48XLARGE = SageMakerInstanceType.of('ml.inf2.48xlarge');
/**
 * ml.m4.10xlarge
 */
SageMakerInstanceType.ML_M4_10XLARGE = SageMakerInstanceType.of('ml.m4.10xlarge');
/**
 * ml.m4.16xlarge
 */
SageMakerInstanceType.ML_M4_16XLARGE = SageMakerInstanceType.of('ml.m4.16xlarge');
/**
 * ml.m4.2xlarge
 */
SageMakerInstanceType.ML_M4_2XLARGE = SageMakerInstanceType.of('ml.m4.2xlarge');
/**
 * ml.m4.4xlarge
 */
SageMakerInstanceType.ML_M4_4XLARGE = SageMakerInstanceType.of('ml.m4.4xlarge');
/**
 * ml.m4.xlarge
 */
SageMakerInstanceType.ML_M4_XLARGE = SageMakerInstanceType.of('ml.m4.xlarge');
/**
 * ml.m5.12xlarge
 */
SageMakerInstanceType.ML_M5_12XLARGE = SageMakerInstanceType.of('ml.m5.12xlarge');
/**
 * ml.m5.24xlarge
 */
SageMakerInstanceType.ML_M5_24XLARGE = SageMakerInstanceType.of('ml.m5.24xlarge');
/**
 * ml.m5.2xlarge
 */
SageMakerInstanceType.ML_M5_2XLARGE = SageMakerInstanceType.of('ml.m5.2xlarge');
/**
 * ml.m5.4xlarge
 */
SageMakerInstanceType.ML_M5_4XLARGE = SageMakerInstanceType.of('ml.m5.4xlarge');
/**
 * ml.m5.large
 */
SageMakerInstanceType.ML_M5_LARGE = SageMakerInstanceType.of('ml.m5.large');
/**
 * ml.m5.xlarge
 */
SageMakerInstanceType.ML_M5_XLARGE = SageMakerInstanceType.of('ml.m5.xlarge');
/**
 * ml.m5d.12xlarge
 */
SageMakerInstanceType.ML_M5D_12XLARGE = SageMakerInstanceType.of('ml.m5d.12xlarge');
/**
 * ml.m5d.24xlarge
 */
SageMakerInstanceType.ML_M5D_24XLARGE = SageMakerInstanceType.of('ml.m5d.24xlarge');
/**
 * ml.m5d.2xlarge
 */
SageMakerInstanceType.ML_M5D_2XLARGE = SageMakerInstanceType.of('ml.m5d.2xlarge');
/**
 * ml.m5d.4xlarge
 */
SageMakerInstanceType.ML_M5D_4XLARGE = SageMakerInstanceType.of('ml.m5d.4xlarge');
/**
 * ml.m5d.large
 */
SageMakerInstanceType.ML_M5D_LARGE = SageMakerInstanceType.of('ml.m5d.large');
/**
 * ml.m5d.xlarge
 */
SageMakerInstanceType.ML_M5D_XLARGE = SageMakerInstanceType.of('ml.m5d.xlarge');
/**
 * ml.p2.16xlarge
 */
SageMakerInstanceType.ML_P2_16XLARGE = SageMakerInstanceType.of('ml.p2.16xlarge');
/**
 * ml.p2.8xlarge
 */
SageMakerInstanceType.ML_P2_8XLARGE = SageMakerInstanceType.of('ml.p2.8xlarge');
/**
 * ml.p2.xlarge
 */
SageMakerInstanceType.ML_P2_XLARGE = SageMakerInstanceType.of('ml.p2.xlarge');
/**
 * ml.p3.16xlarge
 */
SageMakerInstanceType.ML_P3_16XLARGE = SageMakerInstanceType.of('ml.p3.16xlarge');
/**
 * ml.p3.2xlarge
 */
SageMakerInstanceType.ML_P3_2XLARGE = SageMakerInstanceType.of('ml.p3.2xlarge');
/**
 * ml.p3.8xlarge
 */
SageMakerInstanceType.ML_P3_8XLARGE = SageMakerInstanceType.of('ml.p3.8xlarge');
/**
 * ml.p4d.24xlarge
 */
SageMakerInstanceType.ML_P4D_24XLARGE = SageMakerInstanceType.of('ml.p4d.24xlarge');
/**
 * ml.r5.12xlarge
 */
SageMakerInstanceType.ML_R5_12XLARGE = SageMakerInstanceType.of('ml.r5.12xlarge');
/**
 * ml.r5.24xlarge
 */
SageMakerInstanceType.ML_R5_24XLARGE = SageMakerInstanceType.of('ml.r5.24xlarge');
/**
 * ml.r5.2xlarge
 */
SageMakerInstanceType.ML_R5_2XLARGE = SageMakerInstanceType.of('ml.r5.2xlarge');
/**
 * ml.r5.4xlarge
 */
SageMakerInstanceType.ML_R5_4XLARGE = SageMakerInstanceType.of('ml.r5.4xlarge');
/**
 * ml.r5.large
 */
SageMakerInstanceType.ML_R5_LARGE = SageMakerInstanceType.of('ml.r5.large');
/**
 * ml.r5.xlarge
 */
SageMakerInstanceType.ML_R5_XLARGE = SageMakerInstanceType.of('ml.r5.xlarge');
/**
 * ml.r5d.12xlarge
 */
SageMakerInstanceType.ML_R5D_12XLARGE = SageMakerInstanceType.of('ml.r5d.12xlarge');
/**
 * ml.r5d.24xlarge
 */
SageMakerInstanceType.ML_R5D_24XLARGE = SageMakerInstanceType.of('ml.r5d.24xlarge');
/**
 * ml.r5d.2xlarge
 */
SageMakerInstanceType.ML_R5D_2XLARGE = SageMakerInstanceType.of('ml.r5d.2xlarge');
/**
 * ml.r5d.4xlarge
 */
SageMakerInstanceType.ML_R5D_4XLARGE = SageMakerInstanceType.of('ml.r5d.4xlarge');
/**
 * ml.r5d.large
 */
SageMakerInstanceType.ML_R5D_LARGE = SageMakerInstanceType.of('ml.r5d.large');
/**
 * ml.r5d.xlarge
 */
SageMakerInstanceType.ML_R5D_XLARGE = SageMakerInstanceType.of('ml.r5d.xlarge');
/**
 * ml.t2.2xlarge
 */
SageMakerInstanceType.ML_T2_2XLARGE = SageMakerInstanceType.of('ml.t2.2xlarge');
/**
 * ml.t2.large
 */
SageMakerInstanceType.ML_T2_LARGE = SageMakerInstanceType.of('ml.t2.large');
/**
 * ml.t2.medium
 */
SageMakerInstanceType.ML_T2_MEDIUM = SageMakerInstanceType.of('ml.t2.medium');
/**
 * ml.t2.xlarge
 */
SageMakerInstanceType.ML_T2_XLARGE = SageMakerInstanceType.of('ml.t2.xlarge');
//# sourceMappingURL=data:application/json;base64,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