"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const secretsmanager = require("../lib");
class ExampleStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const loginSecret = secretsmanager.Secret.fromSecretAttributes(this, 'Secret', {
            secretArn: 'SomeLogin'
        });
        new iam.User(this, 'User', {
            // Get the 'password' field from the secret that looks like
            // { "username": "XXXX", "password": "YYYY" }
            password: loginSecret.secretValueFromJson('password')
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleStack(app, 'aws-cdk-secret-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5hcHAtd2l0aC1zZWNyZXQubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhhbXBsZS5hcHAtd2l0aC1zZWNyZXQubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXlDO0FBQ3pDLHFDQUFzQztBQUN0Qyx5Q0FBMEM7QUFFMUMsTUFBTSxZQUFhLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDbEMsWUFBWSxLQUFjLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLFNBQVM7UUFDVCxNQUFNLFdBQVcsR0FBRyxjQUFjLENBQUMsTUFBTSxDQUFDLG9CQUFvQixDQUFDLElBQUksRUFBRSxRQUFRLEVBQUU7WUFDN0UsU0FBUyxFQUFFLFdBQVc7U0FDdkIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDekIsMkRBQTJEO1lBQzNELDZDQUE2QztZQUM3QyxRQUFRLEVBQUUsV0FBVyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQztTQUN0RCxDQUFDLENBQUM7UUFDSCxTQUFTO0lBRVgsQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxZQUFZLENBQUMsR0FBRyxFQUFFLHNCQUFzQixDQUFDLENBQUM7QUFDOUMsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGlhbSA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1pYW0nKTtcbmltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jb3JlJyk7XG5pbXBvcnQgc2VjcmV0c21hbmFnZXIgPSByZXF1aXJlKCcuLi9saWInKTtcblxuY2xhc3MgRXhhbXBsZVN0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgLy8vICFzaG93XG4gICAgY29uc3QgbG9naW5TZWNyZXQgPSBzZWNyZXRzbWFuYWdlci5TZWNyZXQuZnJvbVNlY3JldEF0dHJpYnV0ZXModGhpcywgJ1NlY3JldCcsIHtcbiAgICAgIHNlY3JldEFybjogJ1NvbWVMb2dpbidcbiAgICB9KTtcblxuICAgIG5ldyBpYW0uVXNlcih0aGlzLCAnVXNlcicsIHtcbiAgICAgIC8vIEdldCB0aGUgJ3Bhc3N3b3JkJyBmaWVsZCBmcm9tIHRoZSBzZWNyZXQgdGhhdCBsb29rcyBsaWtlXG4gICAgICAvLyB7IFwidXNlcm5hbWVcIjogXCJYWFhYXCIsIFwicGFzc3dvcmRcIjogXCJZWVlZXCIgfVxuICAgICAgcGFzc3dvcmQ6IGxvZ2luU2VjcmV0LnNlY3JldFZhbHVlRnJvbUpzb24oJ3Bhc3N3b3JkJylcbiAgICB9KTtcbiAgICAvLy8gIWhpZGVcblxuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgRXhhbXBsZVN0YWNrKGFwcCwgJ2F3cy1jZGstc2VjcmV0LWludGVnJyk7XG5hcHAuc3ludGgoKTsiXX0=