from setuptools import setup, find_packages


def readme():
    with open('README.md', 'r', encoding='utf-8') as f:
        return f.read()


setup(
    name='stlflib',
    version='1.0.1',
    author='caapel',
    author_email='caapel@mail.ru',
    description='Short-Term Forecasting of Regional Electrical Load Based on CatBoost Model',
    long_description=readme(),
    long_description_content_type='text/markdown',
    url='https://github.com/caapel/ForecastPowerEnergy',
    packages=find_packages(),
    install_requires=['ephem',
                      'requests',
                      'beautifulsoup4', 
                      'tqdm',
                      'numpy',
                      'pandas',
                      'seaborn',
                      'matplotlib',
                      'catboost',
                      'graphviz',
                      'scikit-learn'
                      ],
    classifiers=[
                'Programming Language :: Python :: 3.10',
                'License :: Other/Proprietary License',
                'Operating System :: OS Independent'
                ],
    license='KSPEU License',
    keywords='STLF',
    project_urls={
                'GitHub': 'https://github.com/caapel/ForecastPowerEnergy'
                },
    python_requires='>=3.10'
    )