# This file is generated by fetch_event_schema_json.py
# it is based on api/event.schema.altered.json
# the following license applies:
# Copyright (c) 2020 Sentry (https://sentry.io) and individual contributors.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

VERSION = "2.21.0"
from decimal import Decimal
from fastjsonschema import JsonSchemaValueException


NoneType = type(None)


def validate(data, custom_formats={}, name_prefix=None):
    data_any_of_count1 = 0
    if not data_any_of_count1:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "breadcrumbs" in data_keys:
                    data_keys.remove("breadcrumbs")
                    data__breadcrumbs = data["breadcrumbs"]
                    data__breadcrumbs_any_of_count2 = 0
                    if not data__breadcrumbs_any_of_count2:
                        try:
                            if not isinstance(data__breadcrumbs, (dict, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".breadcrumbs must be object or null"
                                )
                            data__breadcrumbs_is_dict = isinstance(
                                data__breadcrumbs, dict
                            )
                            if data__breadcrumbs_is_dict:
                                data__breadcrumbs__missing_keys = (
                                    set(["values"]) - data__breadcrumbs.keys()
                                )
                                if data__breadcrumbs__missing_keys:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".breadcrumbs must contain "
                                    )
                                data__breadcrumbs_keys = set(data__breadcrumbs.keys())
                                if "values" in data__breadcrumbs_keys:
                                    data__breadcrumbs_keys.remove("values")
                                    data__breadcrumbs__values = data__breadcrumbs[
                                        "values"
                                    ]
                                    if not isinstance(
                                        data__breadcrumbs__values, (list, tuple)
                                    ):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".breadcrumbs.values must be array"
                                        )
                                    data__breadcrumbs__values_is_list = isinstance(
                                        data__breadcrumbs__values, (list, tuple)
                                    )
                                    if data__breadcrumbs__values_is_list:
                                        data__breadcrumbs__values_len = len(
                                            data__breadcrumbs__values
                                        )
                                        for (
                                            data__breadcrumbs__values_x,
                                            data__breadcrumbs__values_item,
                                        ) in enumerate(data__breadcrumbs__values):
                                            data__breadcrumbs__values_item_any_of_count3 = (
                                                0
                                            )
                                            if (
                                                not data__breadcrumbs__values_item_any_of_count3
                                            ):
                                                try:
                                                    validate___definitions_breadcrumb(
                                                        data__breadcrumbs__values_item,
                                                        custom_formats,
                                                        (name_prefix or "data")
                                                        + ".breadcrumbs.values[{data__breadcrumbs__values_x}]".format(
                                                            **locals()
                                                        ),
                                                    )
                                                    data__breadcrumbs__values_item_any_of_count3 += (
                                                        1
                                                    )
                                                except JsonSchemaValueException:
                                                    pass
                                            if (
                                                not data__breadcrumbs__values_item_any_of_count3
                                            ):
                                                try:
                                                    if not isinstance(
                                                        data__breadcrumbs__values_item,
                                                        (NoneType),
                                                    ):
                                                        raise JsonSchemaValueException(
                                                            ""
                                                            + (name_prefix or "data")
                                                            + ".breadcrumbs.values[{data__breadcrumbs__values_x}]".format(
                                                                **locals()
                                                            )
                                                            + " must be null"
                                                        )
                                                    data__breadcrumbs__values_item_any_of_count3 += (
                                                        1
                                                    )
                                                except JsonSchemaValueException:
                                                    pass
                                            if (
                                                not data__breadcrumbs__values_item_any_of_count3
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".breadcrumbs.values[{data__breadcrumbs__values_x}]".format(
                                                        **locals()
                                                    )
                                                    + " cannot be validated by any definition"
                                                )
                            data__breadcrumbs_any_of_count2 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__breadcrumbs_any_of_count2:
                        try:
                            if not isinstance(data__breadcrumbs, (list, tuple)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".breadcrumbs must be array"
                                )
                            data__breadcrumbs_is_list = isinstance(
                                data__breadcrumbs, (list, tuple)
                            )
                            if data__breadcrumbs_is_list:
                                data__breadcrumbs_len = len(data__breadcrumbs)
                                for (
                                    data__breadcrumbs_x,
                                    data__breadcrumbs_item,
                                ) in enumerate(data__breadcrumbs):
                                    data__breadcrumbs_item_any_of_count4 = 0
                                    if not data__breadcrumbs_item_any_of_count4:
                                        try:
                                            validate___definitions_breadcrumb(
                                                data__breadcrumbs_item,
                                                custom_formats,
                                                (name_prefix or "data")
                                                + ".breadcrumbs[{data__breadcrumbs_x}]".format(
                                                    **locals()
                                                ),
                                            )
                                            data__breadcrumbs_item_any_of_count4 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__breadcrumbs_item_any_of_count4:
                                        try:
                                            if not isinstance(
                                                data__breadcrumbs_item, (NoneType)
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".breadcrumbs[{data__breadcrumbs_x}]".format(
                                                        **locals()
                                                    )
                                                    + " must be null"
                                                )
                                            data__breadcrumbs_item_any_of_count4 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__breadcrumbs_item_any_of_count4:
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".breadcrumbs[{data__breadcrumbs_x}]".format(
                                                **locals()
                                            )
                                            + " cannot be validated by any definition"
                                        )
                            data__breadcrumbs_any_of_count2 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__breadcrumbs_any_of_count2:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".breadcrumbs cannot be validated by any definition"
                        )
                if "contexts" in data_keys:
                    data_keys.remove("contexts")
                    data__contexts = data["contexts"]
                    data__contexts_any_of_count5 = 0
                    if not data__contexts_any_of_count5:
                        try:
                            validate___definitions_contexts(
                                data__contexts,
                                custom_formats,
                                (name_prefix or "data") + ".contexts",
                            )
                            data__contexts_any_of_count5 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__contexts_any_of_count5:
                        try:
                            if not isinstance(data__contexts, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".contexts must be null"
                                )
                            data__contexts_any_of_count5 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__contexts_any_of_count5:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".contexts cannot be validated by any definition"
                        )
                if "culprit" in data_keys:
                    data_keys.remove("culprit")
                    data__culprit = data["culprit"]
                    if not isinstance(data__culprit, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".culprit must be string or null"
                        )
                if "debug_meta" in data_keys:
                    data_keys.remove("debug_meta")
                    data__debugmeta = data["debug_meta"]
                    data__debugmeta_any_of_count6 = 0
                    if not data__debugmeta_any_of_count6:
                        try:
                            validate___definitions_debugmeta(
                                data__debugmeta,
                                custom_formats,
                                (name_prefix or "data") + ".debug_meta",
                            )
                            data__debugmeta_any_of_count6 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugmeta_any_of_count6:
                        try:
                            if not isinstance(data__debugmeta, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".debug_meta must be null"
                                )
                            data__debugmeta_any_of_count6 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugmeta_any_of_count6:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".debug_meta cannot be validated by any definition"
                        )
                if "dist" in data_keys:
                    data_keys.remove("dist")
                    data__dist = data["dist"]
                    if not isinstance(data__dist, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".dist must be string or null"
                        )
                if "environment" in data_keys:
                    data_keys.remove("environment")
                    data__environment = data["environment"]
                    if not isinstance(data__environment, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".environment must be string or null"
                        )
                if "errors" in data_keys:
                    data_keys.remove("errors")
                    data__errors = data["errors"]
                    if not isinstance(data__errors, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".errors must be array or null"
                        )
                    data__errors_is_list = isinstance(data__errors, (list, tuple))
                    if data__errors_is_list:
                        data__errors_len = len(data__errors)
                        for data__errors_x, data__errors_item in enumerate(
                            data__errors
                        ):
                            data__errors_item_any_of_count7 = 0
                            if not data__errors_item_any_of_count7:
                                try:
                                    validate___definitions_eventprocessingerror(
                                        data__errors_item,
                                        custom_formats,
                                        (name_prefix or "data")
                                        + ".errors[{data__errors_x}]".format(
                                            **locals()
                                        ),
                                    )
                                    data__errors_item_any_of_count7 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__errors_item_any_of_count7:
                                try:
                                    if not isinstance(data__errors_item, (NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".errors[{data__errors_x}]".format(
                                                **locals()
                                            )
                                            + " must be null"
                                        )
                                    data__errors_item_any_of_count7 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__errors_item_any_of_count7:
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".errors[{data__errors_x}]".format(**locals())
                                    + " cannot be validated by any definition"
                                )
                if "event_id" in data_keys:
                    data_keys.remove("event_id")
                    data__eventid = data["event_id"]
                    data__eventid_any_of_count8 = 0
                    if not data__eventid_any_of_count8:
                        try:
                            validate___definitions_eventid(
                                data__eventid,
                                custom_formats,
                                (name_prefix or "data") + ".event_id",
                            )
                            data__eventid_any_of_count8 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__eventid_any_of_count8:
                        try:
                            if not isinstance(data__eventid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".event_id must be null"
                                )
                            data__eventid_any_of_count8 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__eventid_any_of_count8:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".event_id cannot be validated by any definition"
                        )
                if "exception" in data_keys:
                    data_keys.remove("exception")
                    data__exception = data["exception"]
                    data__exception_any_of_count9 = 0
                    if not data__exception_any_of_count9:
                        try:
                            if not isinstance(data__exception, (dict, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".exception must be object or null"
                                )
                            data__exception_is_dict = isinstance(data__exception, dict)
                            if data__exception_is_dict:
                                data__exception__missing_keys = (
                                    set(["values"]) - data__exception.keys()
                                )
                                if data__exception__missing_keys:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".exception must contain "
                                    )
                                data__exception_keys = set(data__exception.keys())
                                if "values" in data__exception_keys:
                                    data__exception_keys.remove("values")
                                    data__exception__values = data__exception["values"]
                                    if not isinstance(
                                        data__exception__values, (list, tuple)
                                    ):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".exception.values must be array"
                                        )
                                    data__exception__values_is_list = isinstance(
                                        data__exception__values, (list, tuple)
                                    )
                                    if data__exception__values_is_list:
                                        data__exception__values_len = len(
                                            data__exception__values
                                        )
                                        for (
                                            data__exception__values_x,
                                            data__exception__values_item,
                                        ) in enumerate(data__exception__values):
                                            data__exception__values_item_any_of_count10 = (
                                                0
                                            )
                                            if (
                                                not data__exception__values_item_any_of_count10
                                            ):
                                                try:
                                                    validate___definitions_exception(
                                                        data__exception__values_item,
                                                        custom_formats,
                                                        (name_prefix or "data")
                                                        + ".exception.values[{data__exception__values_x}]".format(
                                                            **locals()
                                                        ),
                                                    )
                                                    data__exception__values_item_any_of_count10 += (
                                                        1
                                                    )
                                                except JsonSchemaValueException:
                                                    pass
                                            if (
                                                not data__exception__values_item_any_of_count10
                                            ):
                                                try:
                                                    if not isinstance(
                                                        data__exception__values_item,
                                                        (NoneType),
                                                    ):
                                                        raise JsonSchemaValueException(
                                                            ""
                                                            + (name_prefix or "data")
                                                            + ".exception.values[{data__exception__values_x}]".format(
                                                                **locals()
                                                            )
                                                            + " must be null"
                                                        )
                                                    data__exception__values_item_any_of_count10 += (
                                                        1
                                                    )
                                                except JsonSchemaValueException:
                                                    pass
                                            if (
                                                not data__exception__values_item_any_of_count10
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".exception.values[{data__exception__values_x}]".format(
                                                        **locals()
                                                    )
                                                    + " cannot be validated by any definition"
                                                )
                            data__exception_any_of_count9 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__exception_any_of_count9:
                        try:
                            if not isinstance(data__exception, (list, tuple)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".exception must be array"
                                )
                            data__exception_is_list = isinstance(
                                data__exception, (list, tuple)
                            )
                            if data__exception_is_list:
                                data__exception_len = len(data__exception)
                                for (
                                    data__exception_x,
                                    data__exception_item,
                                ) in enumerate(data__exception):
                                    data__exception_item_any_of_count11 = 0
                                    if not data__exception_item_any_of_count11:
                                        try:
                                            validate___definitions_exception(
                                                data__exception_item,
                                                custom_formats,
                                                (name_prefix or "data")
                                                + ".exception[{data__exception_x}]".format(
                                                    **locals()
                                                ),
                                            )
                                            data__exception_item_any_of_count11 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__exception_item_any_of_count11:
                                        try:
                                            if not isinstance(
                                                data__exception_item, (NoneType)
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".exception[{data__exception_x}]".format(
                                                        **locals()
                                                    )
                                                    + " must be null"
                                                )
                                            data__exception_item_any_of_count11 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__exception_item_any_of_count11:
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".exception[{data__exception_x}]".format(
                                                **locals()
                                            )
                                            + " cannot be validated by any definition"
                                        )
                            data__exception_any_of_count9 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__exception_any_of_count9:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".exception cannot be validated by any definition"
                        )
                if "extra" in data_keys:
                    data_keys.remove("extra")
                    data__extra = data["extra"]
                    if not isinstance(data__extra, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".extra must be object or null"
                        )
                    data__extra_is_dict = isinstance(data__extra, dict)
                    if data__extra_is_dict:
                        data__extra_keys = set(data__extra.keys())
                if "fingerprint" in data_keys:
                    data_keys.remove("fingerprint")
                    data__fingerprint = data["fingerprint"]
                    data__fingerprint_any_of_count12 = 0
                    if not data__fingerprint_any_of_count12:
                        try:
                            validate___definitions_fingerprint(
                                data__fingerprint,
                                custom_formats,
                                (name_prefix or "data") + ".fingerprint",
                            )
                            data__fingerprint_any_of_count12 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__fingerprint_any_of_count12:
                        try:
                            if not isinstance(data__fingerprint, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".fingerprint must be null"
                                )
                            data__fingerprint_any_of_count12 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__fingerprint_any_of_count12:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".fingerprint cannot be validated by any definition"
                        )
                if "level" in data_keys:
                    data_keys.remove("level")
                    data__level = data["level"]
                    data__level_any_of_count13 = 0
                    if not data__level_any_of_count13:
                        try:
                            validate___definitions_level(
                                data__level,
                                custom_formats,
                                (name_prefix or "data") + ".level",
                            )
                            data__level_any_of_count13 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__level_any_of_count13:
                        try:
                            if not isinstance(data__level, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".level must be null"
                                )
                            data__level_any_of_count13 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__level_any_of_count13:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".level cannot be validated by any definition"
                        )
                if "logentry" in data_keys:
                    data_keys.remove("logentry")
                    data__logentry = data["logentry"]
                    data__logentry_any_of_count14 = 0
                    if not data__logentry_any_of_count14:
                        try:
                            validate___definitions_logentry(
                                data__logentry,
                                custom_formats,
                                (name_prefix or "data") + ".logentry",
                            )
                            data__logentry_any_of_count14 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__logentry_any_of_count14:
                        try:
                            if not isinstance(data__logentry, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".logentry must be null"
                                )
                            data__logentry_any_of_count14 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__logentry_any_of_count14:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".logentry cannot be validated by any definition"
                        )
                if "logger" in data_keys:
                    data_keys.remove("logger")
                    data__logger = data["logger"]
                    if not isinstance(data__logger, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".logger must be string or null"
                        )
                if "modules" in data_keys:
                    data_keys.remove("modules")
                    data__modules = data["modules"]
                    if not isinstance(data__modules, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".modules must be object or null"
                        )
                    data__modules_is_dict = isinstance(data__modules, dict)
                    if data__modules_is_dict:
                        data__modules_keys = set(data__modules.keys())
                        for data__modules_key in data__modules_keys:
                            if data__modules_key not in []:
                                data__modules_value = data__modules.get(
                                    data__modules_key
                                )
                                if not isinstance(data__modules_value, (str, NoneType)):
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".modules.{data__modules_key}".format(
                                            **locals()
                                        )
                                        + " must be string or null"
                                    )
                if "platform" in data_keys:
                    data_keys.remove("platform")
                    data__platform = data["platform"]
                    if not isinstance(data__platform, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".platform must be string or null"
                        )
                if "received" in data_keys:
                    data_keys.remove("received")
                    data__received = data["received"]
                    data__received_any_of_count15 = 0
                    if not data__received_any_of_count15:
                        try:
                            validate___definitions_timestamp(
                                data__received,
                                custom_formats,
                                (name_prefix or "data") + ".received",
                            )
                            data__received_any_of_count15 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__received_any_of_count15:
                        try:
                            if not isinstance(data__received, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".received must be null"
                                )
                            data__received_any_of_count15 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__received_any_of_count15:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".received cannot be validated by any definition"
                        )
                if "release" in data_keys:
                    data_keys.remove("release")
                    data__release = data["release"]
                    if not isinstance(data__release, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".release must be string or null"
                        )
                if "request" in data_keys:
                    data_keys.remove("request")
                    data__request = data["request"]
                    data__request_any_of_count16 = 0
                    if not data__request_any_of_count16:
                        try:
                            validate___definitions_request(
                                data__request,
                                custom_formats,
                                (name_prefix or "data") + ".request",
                            )
                            data__request_any_of_count16 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__request_any_of_count16:
                        try:
                            if not isinstance(data__request, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".request must be null"
                                )
                            data__request_any_of_count16 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__request_any_of_count16:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".request cannot be validated by any definition"
                        )
                if "sdk" in data_keys:
                    data_keys.remove("sdk")
                    data__sdk = data["sdk"]
                    data__sdk_any_of_count17 = 0
                    if not data__sdk_any_of_count17:
                        try:
                            validate___definitions_clientsdkinfo(
                                data__sdk,
                                custom_formats,
                                (name_prefix or "data") + ".sdk",
                            )
                            data__sdk_any_of_count17 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__sdk_any_of_count17:
                        try:
                            if not isinstance(data__sdk, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".sdk must be null"
                                )
                            data__sdk_any_of_count17 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__sdk_any_of_count17:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sdk cannot be validated by any definition"
                        )
                if "server_name" in data_keys:
                    data_keys.remove("server_name")
                    data__servername = data["server_name"]
                    if not isinstance(data__servername, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".server_name must be string or null"
                        )
                if "stacktrace" in data_keys:
                    data_keys.remove("stacktrace")
                    data__stacktrace = data["stacktrace"]
                    data__stacktrace_any_of_count18 = 0
                    if not data__stacktrace_any_of_count18:
                        try:
                            validate___definitions_stacktrace(
                                data__stacktrace,
                                custom_formats,
                                (name_prefix or "data") + ".stacktrace",
                            )
                            data__stacktrace_any_of_count18 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__stacktrace_any_of_count18:
                        try:
                            if not isinstance(data__stacktrace, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".stacktrace must be null"
                                )
                            data__stacktrace_any_of_count18 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__stacktrace_any_of_count18:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".stacktrace cannot be validated by any definition"
                        )
                if "tags" in data_keys:
                    data_keys.remove("tags")
                    data__tags = data["tags"]
                    data__tags_any_of_count19 = 0
                    if not data__tags_any_of_count19:
                        try:
                            validate___definitions_tags(
                                data__tags,
                                custom_formats,
                                (name_prefix or "data") + ".tags",
                            )
                            data__tags_any_of_count19 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__tags_any_of_count19:
                        try:
                            if not isinstance(data__tags, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".tags must be null"
                                )
                            data__tags_any_of_count19 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__tags_any_of_count19:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".tags cannot be validated by any definition"
                        )
                if "threads" in data_keys:
                    data_keys.remove("threads")
                    data__threads = data["threads"]
                    data__threads_any_of_count20 = 0
                    if not data__threads_any_of_count20:
                        try:
                            if not isinstance(data__threads, (dict, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".threads must be object or null"
                                )
                            data__threads_is_dict = isinstance(data__threads, dict)
                            if data__threads_is_dict:
                                data__threads__missing_keys = (
                                    set(["values"]) - data__threads.keys()
                                )
                                if data__threads__missing_keys:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".threads must contain "
                                    )
                                data__threads_keys = set(data__threads.keys())
                                if "values" in data__threads_keys:
                                    data__threads_keys.remove("values")
                                    data__threads__values = data__threads["values"]
                                    if not isinstance(
                                        data__threads__values, (list, tuple)
                                    ):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".threads.values must be array"
                                        )
                                    data__threads__values_is_list = isinstance(
                                        data__threads__values, (list, tuple)
                                    )
                                    if data__threads__values_is_list:
                                        data__threads__values_len = len(
                                            data__threads__values
                                        )
                                        for (
                                            data__threads__values_x,
                                            data__threads__values_item,
                                        ) in enumerate(data__threads__values):
                                            data__threads__values_item_any_of_count21 = (
                                                0
                                            )
                                            if (
                                                not data__threads__values_item_any_of_count21
                                            ):
                                                try:
                                                    validate___definitions_thread(
                                                        data__threads__values_item,
                                                        custom_formats,
                                                        (name_prefix or "data")
                                                        + ".threads.values[{data__threads__values_x}]".format(
                                                            **locals()
                                                        ),
                                                    )
                                                    data__threads__values_item_any_of_count21 += (
                                                        1
                                                    )
                                                except JsonSchemaValueException:
                                                    pass
                                            if (
                                                not data__threads__values_item_any_of_count21
                                            ):
                                                try:
                                                    if not isinstance(
                                                        data__threads__values_item,
                                                        (NoneType),
                                                    ):
                                                        raise JsonSchemaValueException(
                                                            ""
                                                            + (name_prefix or "data")
                                                            + ".threads.values[{data__threads__values_x}]".format(
                                                                **locals()
                                                            )
                                                            + " must be null"
                                                        )
                                                    data__threads__values_item_any_of_count21 += (
                                                        1
                                                    )
                                                except JsonSchemaValueException:
                                                    pass
                                            if (
                                                not data__threads__values_item_any_of_count21
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".threads.values[{data__threads__values_x}]".format(
                                                        **locals()
                                                    )
                                                    + " cannot be validated by any definition"
                                                )
                            data__threads_any_of_count20 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threads_any_of_count20:
                        try:
                            if not isinstance(data__threads, (list, tuple)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".threads must be array"
                                )
                            data__threads_is_list = isinstance(
                                data__threads, (list, tuple)
                            )
                            if data__threads_is_list:
                                data__threads_len = len(data__threads)
                                for data__threads_x, data__threads_item in enumerate(
                                    data__threads
                                ):
                                    data__threads_item_any_of_count22 = 0
                                    if not data__threads_item_any_of_count22:
                                        try:
                                            validate___definitions_thread(
                                                data__threads_item,
                                                custom_formats,
                                                (name_prefix or "data")
                                                + ".threads[{data__threads_x}]".format(
                                                    **locals()
                                                ),
                                            )
                                            data__threads_item_any_of_count22 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__threads_item_any_of_count22:
                                        try:
                                            if not isinstance(
                                                data__threads_item, (NoneType)
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".threads[{data__threads_x}]".format(
                                                        **locals()
                                                    )
                                                    + " must be null"
                                                )
                                            data__threads_item_any_of_count22 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__threads_item_any_of_count22:
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".threads[{data__threads_x}]".format(
                                                **locals()
                                            )
                                            + " cannot be validated by any definition"
                                        )
                            data__threads_any_of_count20 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threads_any_of_count20:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".threads cannot be validated by any definition"
                        )
                if "time_spent" in data_keys:
                    data_keys.remove("time_spent")
                    data__timespent = data["time_spent"]
                    if (
                        not isinstance(data__timespent, (int, NoneType))
                        and not (
                            isinstance(data__timespent, float)
                            and data__timespent.is_integer()
                        )
                        or isinstance(data__timespent, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".time_spent must be integer or null"
                        )
                    if isinstance(data__timespent, (int, float, Decimal)):
                        if data__timespent < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".time_spent must be bigger than or equal to 0.0"
                            )
                if "timestamp" in data_keys:
                    data_keys.remove("timestamp")
                    data__timestamp = data["timestamp"]
                    data__timestamp_any_of_count23 = 0
                    if not data__timestamp_any_of_count23:
                        try:
                            validate___definitions_timestamp(
                                data__timestamp,
                                custom_formats,
                                (name_prefix or "data") + ".timestamp",
                            )
                            data__timestamp_any_of_count23 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__timestamp_any_of_count23:
                        try:
                            if not isinstance(data__timestamp, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".timestamp must be null"
                                )
                            data__timestamp_any_of_count23 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__timestamp_any_of_count23:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".timestamp cannot be validated by any definition"
                        )
                if "transaction" in data_keys:
                    data_keys.remove("transaction")
                    data__transaction = data["transaction"]
                    if not isinstance(data__transaction, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".transaction must be string or null"
                        )
                if "transaction_info" in data_keys:
                    data_keys.remove("transaction_info")
                    data__transactioninfo = data["transaction_info"]
                    data__transactioninfo_any_of_count24 = 0
                    if not data__transactioninfo_any_of_count24:
                        try:
                            validate___definitions_transactioninfo(
                                data__transactioninfo,
                                custom_formats,
                                (name_prefix or "data") + ".transaction_info",
                            )
                            data__transactioninfo_any_of_count24 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__transactioninfo_any_of_count24:
                        try:
                            if not isinstance(data__transactioninfo, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".transaction_info must be null"
                                )
                            data__transactioninfo_any_of_count24 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__transactioninfo_any_of_count24:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".transaction_info cannot be validated by any definition"
                        )
                if "type" in data_keys:
                    data_keys.remove("type")
                    data__type = data["type"]
                    data__type_any_of_count25 = 0
                    if not data__type_any_of_count25:
                        try:
                            validate___definitions_eventtype(
                                data__type,
                                custom_formats,
                                (name_prefix or "data") + ".type",
                            )
                            data__type_any_of_count25 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__type_any_of_count25:
                        try:
                            if not isinstance(data__type, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".type must be null"
                                )
                            data__type_any_of_count25 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__type_any_of_count25:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".type cannot be validated by any definition"
                        )
                if "user" in data_keys:
                    data_keys.remove("user")
                    data__user = data["user"]
                    data__user_any_of_count26 = 0
                    if not data__user_any_of_count26:
                        try:
                            validate___definitions_user(
                                data__user,
                                custom_formats,
                                (name_prefix or "data") + ".user",
                            )
                            data__user_any_of_count26 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__user_any_of_count26:
                        try:
                            if not isinstance(data__user, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".user must be null"
                                )
                            data__user_any_of_count26 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__user_any_of_count26:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".user cannot be validated by any definition"
                        )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count1 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count1:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_user(data, custom_formats={}, name_prefix=None):
    data_any_of_count27 = 0
    if not data_any_of_count27:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "data" in data_keys:
                    data_keys.remove("data")
                    data__data = data["data"]
                    if not isinstance(data__data, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".data must be object or null"
                        )
                    data__data_is_dict = isinstance(data__data, dict)
                    if data__data_is_dict:
                        data__data_keys = set(data__data.keys())
                if "email" in data_keys:
                    data_keys.remove("email")
                    data__email = data["email"]
                    if not isinstance(data__email, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".email must be string or null"
                        )
                if "geo" in data_keys:
                    data_keys.remove("geo")
                    data__geo = data["geo"]
                    data__geo_any_of_count28 = 0
                    if not data__geo_any_of_count28:
                        try:
                            validate___definitions_geo(
                                data__geo,
                                custom_formats,
                                (name_prefix or "data") + ".geo",
                            )
                            data__geo_any_of_count28 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__geo_any_of_count28:
                        try:
                            if not isinstance(data__geo, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".geo must be null"
                                )
                            data__geo_any_of_count28 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__geo_any_of_count28:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".geo cannot be validated by any definition"
                        )
                if "id" in data_keys:
                    data_keys.remove("id")
                    data__id = data["id"]
                    if not isinstance(data__id, (str, NoneType)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + ".id must be string or null"
                        )
                if "ip_address" in data_keys:
                    data_keys.remove("ip_address")
                    data__ipaddress = data["ip_address"]
                    data__ipaddress_any_of_count29 = 0
                    if not data__ipaddress_any_of_count29:
                        try:
                            validate___definitions_string(
                                data__ipaddress,
                                custom_formats,
                                (name_prefix or "data") + ".ip_address",
                            )
                            data__ipaddress_any_of_count29 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__ipaddress_any_of_count29:
                        try:
                            if not isinstance(data__ipaddress, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".ip_address must be null"
                                )
                            data__ipaddress_any_of_count29 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__ipaddress_any_of_count29:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".ip_address cannot be validated by any definition"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "segment" in data_keys:
                    data_keys.remove("segment")
                    data__segment = data["segment"]
                    if not isinstance(data__segment, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".segment must be string or null"
                        )
                if "sentry_user" in data_keys:
                    data_keys.remove("sentry_user")
                    data__sentryuser = data["sentry_user"]
                    if not isinstance(data__sentryuser, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sentry_user must be string or null"
                        )
                if "username" in data_keys:
                    data_keys.remove("username")
                    data__username = data["username"]
                    if not isinstance(data__username, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".username must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count27 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count27:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_string(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    return data


def validate___definitions_geo(data, custom_formats={}, name_prefix=None):
    data_any_of_count30 = 0
    if not data_any_of_count30:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "city" in data_keys:
                    data_keys.remove("city")
                    data__city = data["city"]
                    if not isinstance(data__city, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".city must be string or null"
                        )
                if "country_code" in data_keys:
                    data_keys.remove("country_code")
                    data__countrycode = data["country_code"]
                    if not isinstance(data__countrycode, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".country_code must be string or null"
                        )
                if "region" in data_keys:
                    data_keys.remove("region")
                    data__region = data["region"]
                    if not isinstance(data__region, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".region must be string or null"
                        )
                if "subdivision" in data_keys:
                    data_keys.remove("subdivision")
                    data__subdivision = data["subdivision"]
                    if not isinstance(data__subdivision, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".subdivision must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count30 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count30:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_eventtype(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    if data not in [
        "error",
        "csp",
        "hpkp",
        "expectct",
        "expectstaple",
        "nel",
        "transaction",
        "userreportv2",
        "default",
    ]:
        raise JsonSchemaValueException(
            ""
            + (name_prefix or "data")
            + " must be one of ['error', 'csp', 'hpkp', 'expectct', 'expectstaple', 'nel', 'transaction', 'userreportv2', 'default']"
        )
    return data


def validate___definitions_transactioninfo(data, custom_formats={}, name_prefix=None):
    data_any_of_count31 = 0
    if not data_any_of_count31:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "changes" in data_keys:
                    data_keys.remove("changes")
                    data__changes = data["changes"]
                    if not isinstance(data__changes, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".changes must be array or null"
                        )
                    data__changes_is_list = isinstance(data__changes, (list, tuple))
                    if data__changes_is_list:
                        data__changes_len = len(data__changes)
                        for data__changes_x, data__changes_item in enumerate(
                            data__changes
                        ):
                            data__changes_item_any_of_count32 = 0
                            if not data__changes_item_any_of_count32:
                                try:
                                    validate___definitions_transactionnamechange(
                                        data__changes_item,
                                        custom_formats,
                                        (name_prefix or "data")
                                        + ".changes[{data__changes_x}]".format(
                                            **locals()
                                        ),
                                    )
                                    data__changes_item_any_of_count32 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__changes_item_any_of_count32:
                                try:
                                    if not isinstance(data__changes_item, (NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".changes[{data__changes_x}]".format(
                                                **locals()
                                            )
                                            + " must be null"
                                        )
                                    data__changes_item_any_of_count32 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__changes_item_any_of_count32:
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".changes[{data__changes_x}]".format(**locals())
                                    + " cannot be validated by any definition"
                                )
                if "original" in data_keys:
                    data_keys.remove("original")
                    data__original = data["original"]
                    if not isinstance(data__original, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".original must be string or null"
                        )
                if "propagations" in data_keys:
                    data_keys.remove("propagations")
                    data__propagations = data["propagations"]
                    if (
                        not isinstance(data__propagations, (int, NoneType))
                        and not (
                            isinstance(data__propagations, float)
                            and data__propagations.is_integer()
                        )
                        or isinstance(data__propagations, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".propagations must be integer or null"
                        )
                    if isinstance(data__propagations, (int, float, Decimal)):
                        if data__propagations < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".propagations must be bigger than or equal to 0.0"
                            )
                if "source" in data_keys:
                    data_keys.remove("source")
                    data__source = data["source"]
                    data__source_any_of_count33 = 0
                    if not data__source_any_of_count33:
                        try:
                            validate___definitions_transactionsource(
                                data__source,
                                custom_formats,
                                (name_prefix or "data") + ".source",
                            )
                            data__source_any_of_count33 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__source_any_of_count33:
                        try:
                            if not isinstance(data__source, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".source must be null"
                                )
                            data__source_any_of_count33 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__source_any_of_count33:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".source cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count31 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count31:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_transactionsource(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    if data not in [
        "custom",
        "url",
        "route",
        "view",
        "component",
        "sanitized",
        "task",
        "unknown",
    ]:
        raise JsonSchemaValueException(
            ""
            + (name_prefix or "data")
            + " must be one of ['custom', 'url', 'route', 'view', 'component', 'sanitized', 'task', 'unknown']"
        )
    return data


def validate___definitions_transactionnamechange(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count34 = 0
    if not data_any_of_count34:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "propagations" in data_keys:
                    data_keys.remove("propagations")
                    data__propagations = data["propagations"]
                    if (
                        not isinstance(data__propagations, (int, NoneType))
                        and not (
                            isinstance(data__propagations, float)
                            and data__propagations.is_integer()
                        )
                        or isinstance(data__propagations, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".propagations must be integer or null"
                        )
                    if isinstance(data__propagations, (int, float, Decimal)):
                        if data__propagations < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".propagations must be bigger than or equal to 0.0"
                            )
                if "source" in data_keys:
                    data_keys.remove("source")
                    data__source = data["source"]
                    data__source_any_of_count35 = 0
                    if not data__source_any_of_count35:
                        try:
                            validate___definitions_transactionsource(
                                data__source,
                                custom_formats,
                                (name_prefix or "data") + ".source",
                            )
                            data__source_any_of_count35 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__source_any_of_count35:
                        try:
                            if not isinstance(data__source, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".source must be null"
                                )
                            data__source_any_of_count35 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__source_any_of_count35:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".source cannot be validated by any definition"
                        )
                if "timestamp" in data_keys:
                    data_keys.remove("timestamp")
                    data__timestamp = data["timestamp"]
                    data__timestamp_any_of_count36 = 0
                    if not data__timestamp_any_of_count36:
                        try:
                            validate___definitions_timestamp(
                                data__timestamp,
                                custom_formats,
                                (name_prefix or "data") + ".timestamp",
                            )
                            data__timestamp_any_of_count36 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__timestamp_any_of_count36:
                        try:
                            if not isinstance(data__timestamp, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".timestamp must be null"
                                )
                            data__timestamp_any_of_count36 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__timestamp_any_of_count36:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".timestamp cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count34 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count34:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_thread(data, custom_formats={}, name_prefix=None):
    data_any_of_count37 = 0
    if not data_any_of_count37:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "crashed" in data_keys:
                    data_keys.remove("crashed")
                    data__crashed = data["crashed"]
                    if not isinstance(data__crashed, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".crashed must be boolean or null"
                        )
                if "current" in data_keys:
                    data_keys.remove("current")
                    data__current = data["current"]
                    if not isinstance(data__current, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".current must be boolean or null"
                        )
                if "held_locks" in data_keys:
                    data_keys.remove("held_locks")
                    data__heldlocks = data["held_locks"]
                    if not isinstance(data__heldlocks, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".held_locks must be object or null"
                        )
                    data__heldlocks_is_dict = isinstance(data__heldlocks, dict)
                    if data__heldlocks_is_dict:
                        data__heldlocks_keys = set(data__heldlocks.keys())
                        for data__heldlocks_key in data__heldlocks_keys:
                            if data__heldlocks_key not in []:
                                data__heldlocks_value = data__heldlocks.get(
                                    data__heldlocks_key
                                )
                                data__heldlocks_value_any_of_count38 = 0
                                if not data__heldlocks_value_any_of_count38:
                                    try:
                                        validate___definitions_lockreason(
                                            data__heldlocks_value,
                                            custom_formats,
                                            (name_prefix or "data")
                                            + ".held_locks.{data__heldlocks_key}".format(
                                                **locals()
                                            ),
                                        )
                                        data__heldlocks_value_any_of_count38 += 1
                                    except JsonSchemaValueException:
                                        pass
                                if not data__heldlocks_value_any_of_count38:
                                    try:
                                        if not isinstance(
                                            data__heldlocks_value, (NoneType)
                                        ):
                                            raise JsonSchemaValueException(
                                                ""
                                                + (name_prefix or "data")
                                                + ".held_locks.{data__heldlocks_key}".format(
                                                    **locals()
                                                )
                                                + " must be null"
                                            )
                                        data__heldlocks_value_any_of_count38 += 1
                                    except JsonSchemaValueException:
                                        pass
                                if not data__heldlocks_value_any_of_count38:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".held_locks.{data__heldlocks_key}".format(
                                            **locals()
                                        )
                                        + " cannot be validated by any definition"
                                    )
                if "id" in data_keys:
                    data_keys.remove("id")
                    data__id = data["id"]
                    data__id_any_of_count39 = 0
                    if not data__id_any_of_count39:
                        try:
                            validate___definitions_threadid(
                                data__id,
                                custom_formats,
                                (name_prefix or "data") + ".id",
                            )
                            data__id_any_of_count39 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__id_any_of_count39:
                        try:
                            if not isinstance(data__id, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".id must be null"
                                )
                            data__id_any_of_count39 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__id_any_of_count39:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".id cannot be validated by any definition"
                        )
                if "main" in data_keys:
                    data_keys.remove("main")
                    data__main = data["main"]
                    if not isinstance(data__main, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".main must be boolean or null"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "stacktrace" in data_keys:
                    data_keys.remove("stacktrace")
                    data__stacktrace = data["stacktrace"]
                    data__stacktrace_any_of_count40 = 0
                    if not data__stacktrace_any_of_count40:
                        try:
                            validate___definitions_stacktrace(
                                data__stacktrace,
                                custom_formats,
                                (name_prefix or "data") + ".stacktrace",
                            )
                            data__stacktrace_any_of_count40 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__stacktrace_any_of_count40:
                        try:
                            if not isinstance(data__stacktrace, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".stacktrace must be null"
                                )
                            data__stacktrace_any_of_count40 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__stacktrace_any_of_count40:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".stacktrace cannot be validated by any definition"
                        )
                if "state" in data_keys:
                    data_keys.remove("state")
                    data__state = data["state"]
                    if not isinstance(data__state, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".state must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count37 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count37:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_threadid(data, custom_formats={}, name_prefix=None):
    data_any_of_count41 = 0
    if not data_any_of_count41:
        try:
            if (
                not isinstance(data, (int))
                and not (isinstance(data, float) and data.is_integer())
                or isinstance(data, bool)
            ):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be integer"
                )
            if isinstance(data, (int, float, Decimal)):
                if data < 0.0:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must be bigger than or equal to 0.0"
                    )
            data_any_of_count41 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count41:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count41 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count41:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_lockreason(data, custom_formats={}, name_prefix=None):
    data_any_of_count42 = 0
    if not data_any_of_count42:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["type"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "address" in data_keys:
                    data_keys.remove("address")
                    data__address = data["address"]
                    if not isinstance(data__address, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".address must be string or null"
                        )
                if "class_name" in data_keys:
                    data_keys.remove("class_name")
                    data__classname = data["class_name"]
                    if not isinstance(data__classname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".class_name must be string or null"
                        )
                if "package_name" in data_keys:
                    data_keys.remove("package_name")
                    data__packagename = data["package_name"]
                    if not isinstance(data__packagename, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".package_name must be string or null"
                        )
                if "thread_id" in data_keys:
                    data_keys.remove("thread_id")
                    data__threadid = data["thread_id"]
                    data__threadid_any_of_count43 = 0
                    if not data__threadid_any_of_count43:
                        try:
                            validate___definitions_threadid(
                                data__threadid,
                                custom_formats,
                                (name_prefix or "data") + ".thread_id",
                            )
                            data__threadid_any_of_count43 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threadid_any_of_count43:
                        try:
                            if not isinstance(data__threadid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".thread_id must be null"
                                )
                            data__threadid_any_of_count43 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threadid_any_of_count43:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".thread_id cannot be validated by any definition"
                        )
                if "type" in data_keys:
                    data_keys.remove("type")
                    data__type = data["type"]
                    data__type_any_of_count44 = 0
                    if not data__type_any_of_count44:
                        try:
                            validate___definitions_lockreasontype(
                                data__type,
                                custom_formats,
                                (name_prefix or "data") + ".type",
                            )
                            data__type_any_of_count44 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__type_any_of_count44:
                        try:
                            if not isinstance(data__type, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".type must be null"
                                )
                            data__type_any_of_count44 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__type_any_of_count44:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".type cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count42 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count42:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_lockreasontype(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    if data not in ["locked", "waiting", "sleeping", "blocked"]:
        raise JsonSchemaValueException(
            ""
            + (name_prefix or "data")
            + " must be one of ['locked', 'waiting', 'sleeping', 'blocked']"
        )
    return data


def validate___definitions_tags(data, custom_formats={}, name_prefix=None):
    data_any_of_count45 = 0
    if not data_any_of_count45:
        try:
            data_any_of_count46 = 0
            if not data_any_of_count46:
                try:
                    if not isinstance(data, (dict)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + " must be object"
                        )
                    data_is_dict = isinstance(data, dict)
                    if data_is_dict:
                        data_keys = set(data.keys())
                        for data_key in data_keys:
                            if data_key not in []:
                                data_value = data.get(data_key)
                                if not isinstance(data_value, (str, NoneType)):
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".{data_key}".format(**locals())
                                        + " must be string or null"
                                    )
                    data_any_of_count46 += 1
                except JsonSchemaValueException:
                    pass
            if not data_any_of_count46:
                try:
                    if not isinstance(data, (list, tuple)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + " must be array"
                        )
                    data_is_list = isinstance(data, (list, tuple))
                    if data_is_list:
                        data_len = len(data)
                        for data_x, data_item in enumerate(data):
                            data_item_any_of_count47 = 0
                            if not data_item_any_of_count47:
                                try:
                                    validate___definitions_tagentry(
                                        data_item,
                                        custom_formats,
                                        (name_prefix or "data")
                                        + "[{data_x}]".format(**locals()),
                                    )
                                    data_item_any_of_count47 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data_item_any_of_count47:
                                try:
                                    if not isinstance(data_item, (NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + "[{data_x}]".format(**locals())
                                            + " must be null"
                                        )
                                    data_item_any_of_count47 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data_item_any_of_count47:
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + "[{data_x}]".format(**locals())
                                    + " cannot be validated by any definition"
                                )
                    data_any_of_count46 += 1
                except JsonSchemaValueException:
                    pass
            if not data_any_of_count46:
                raise JsonSchemaValueException(
                    ""
                    + (name_prefix or "data")
                    + " cannot be validated by any definition"
                )
            data_any_of_count45 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count45:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_tagentry(data, custom_formats={}, name_prefix=None):
    data_any_of_count48 = 0
    if not data_any_of_count48:
        try:
            if not isinstance(data, (list, tuple)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be array"
                )
            data_is_list = isinstance(data, (list, tuple))
            if data_is_list:
                data_len = len(data)
                if data_len < 2:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain at least 2 items"
                    )
                if data_len > 2:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must contain less than or equal to 2 items"
                    )
                if data_len > 0:
                    data__0 = data[0]
                    if not isinstance(data__0, (str, NoneType)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + "[0] must be string or null"
                        )
                if data_len > 1:
                    data__1 = data[1]
                    if not isinstance(data__1, (str, NoneType)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + "[1] must be string or null"
                        )
            data_any_of_count48 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count48:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_stacktrace(data, custom_formats={}, name_prefix=None):
    data_any_of_count49 = 0
    if not data_any_of_count49:
        try:
            validate___definitions_rawstacktrace(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count49 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count49:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_rawstacktrace(data, custom_formats={}, name_prefix=None):
    data_any_of_count50 = 0
    if not data_any_of_count50:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["frames"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "frames" in data_keys:
                    data_keys.remove("frames")
                    data__frames = data["frames"]
                    if not isinstance(data__frames, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".frames must be array or null"
                        )
                    data__frames_is_list = isinstance(data__frames, (list, tuple))
                    if data__frames_is_list:
                        data__frames_len = len(data__frames)
                        for data__frames_x, data__frames_item in enumerate(
                            data__frames
                        ):
                            data__frames_item_any_of_count51 = 0
                            if not data__frames_item_any_of_count51:
                                try:
                                    validate___definitions_frame(
                                        data__frames_item,
                                        custom_formats,
                                        (name_prefix or "data")
                                        + ".frames[{data__frames_x}]".format(
                                            **locals()
                                        ),
                                    )
                                    data__frames_item_any_of_count51 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__frames_item_any_of_count51:
                                try:
                                    if not isinstance(data__frames_item, (NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".frames[{data__frames_x}]".format(
                                                **locals()
                                            )
                                            + " must be null"
                                        )
                                    data__frames_item_any_of_count51 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__frames_item_any_of_count51:
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".frames[{data__frames_x}]".format(**locals())
                                    + " cannot be validated by any definition"
                                )
                if "instruction_addr_adjustment" in data_keys:
                    data_keys.remove("instruction_addr_adjustment")
                    data__instructionaddradjustment = data[
                        "instruction_addr_adjustment"
                    ]
                    data__instructionaddradjustment_any_of_count52 = 0
                    if not data__instructionaddradjustment_any_of_count52:
                        try:
                            validate___definitions_instructionaddradjustment(
                                data__instructionaddradjustment,
                                custom_formats,
                                (name_prefix or "data")
                                + ".instruction_addr_adjustment",
                            )
                            data__instructionaddradjustment_any_of_count52 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__instructionaddradjustment_any_of_count52:
                        try:
                            if not isinstance(
                                data__instructionaddradjustment, (NoneType)
                            ):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".instruction_addr_adjustment must be null"
                                )
                            data__instructionaddradjustment_any_of_count52 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__instructionaddradjustment_any_of_count52:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".instruction_addr_adjustment cannot be validated by any definition"
                        )
                if "lang" in data_keys:
                    data_keys.remove("lang")
                    data__lang = data["lang"]
                    if not isinstance(data__lang, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".lang must be string or null"
                        )
                if "registers" in data_keys:
                    data_keys.remove("registers")
                    data__registers = data["registers"]
                    if not isinstance(data__registers, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".registers must be object or null"
                        )
                    data__registers_is_dict = isinstance(data__registers, dict)
                    if data__registers_is_dict:
                        data__registers_keys = set(data__registers.keys())
                        for data__registers_key in data__registers_keys:
                            if data__registers_key not in []:
                                data__registers_value = data__registers.get(
                                    data__registers_key
                                )
                                data__registers_value_any_of_count53 = 0
                                if not data__registers_value_any_of_count53:
                                    try:
                                        validate___definitions_regval(
                                            data__registers_value,
                                            custom_formats,
                                            (name_prefix or "data")
                                            + ".registers.{data__registers_key}".format(
                                                **locals()
                                            ),
                                        )
                                        data__registers_value_any_of_count53 += 1
                                    except JsonSchemaValueException:
                                        pass
                                if not data__registers_value_any_of_count53:
                                    try:
                                        if not isinstance(
                                            data__registers_value, (NoneType)
                                        ):
                                            raise JsonSchemaValueException(
                                                ""
                                                + (name_prefix or "data")
                                                + ".registers.{data__registers_key}".format(
                                                    **locals()
                                                )
                                                + " must be null"
                                            )
                                        data__registers_value_any_of_count53 += 1
                                    except JsonSchemaValueException:
                                        pass
                                if not data__registers_value_any_of_count53:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".registers.{data__registers_key}".format(
                                            **locals()
                                        )
                                        + " cannot be validated by any definition"
                                    )
                if "snapshot" in data_keys:
                    data_keys.remove("snapshot")
                    data__snapshot = data["snapshot"]
                    if not isinstance(data__snapshot, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".snapshot must be boolean or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count50 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count50:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_regval(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    return data


def validate___definitions_instructionaddradjustment(
    data, custom_formats={}, name_prefix=None
):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    if data not in ["auto", "all_but_first", "all", "none"]:
        raise JsonSchemaValueException(
            ""
            + (name_prefix or "data")
            + " must be one of ['auto', 'all_but_first', 'all', 'none']"
        )
    return data


def validate___definitions_frame(data, custom_formats={}, name_prefix=None):
    data_any_of_count54 = 0
    if not data_any_of_count54:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "abs_path" in data_keys:
                    data_keys.remove("abs_path")
                    data__abspath = data["abs_path"]
                    data__abspath_any_of_count55 = 0
                    if not data__abspath_any_of_count55:
                        try:
                            validate___definitions_nativeimagepath(
                                data__abspath,
                                custom_formats,
                                (name_prefix or "data") + ".abs_path",
                            )
                            data__abspath_any_of_count55 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__abspath_any_of_count55:
                        try:
                            if not isinstance(data__abspath, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".abs_path must be null"
                                )
                            data__abspath_any_of_count55 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__abspath_any_of_count55:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".abs_path cannot be validated by any definition"
                        )
                if "addr_mode" in data_keys:
                    data_keys.remove("addr_mode")
                    data__addrmode = data["addr_mode"]
                    if not isinstance(data__addrmode, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".addr_mode must be string or null"
                        )
                if "colno" in data_keys:
                    data_keys.remove("colno")
                    data__colno = data["colno"]
                    if (
                        not isinstance(data__colno, (int, NoneType))
                        and not (
                            isinstance(data__colno, float) and data__colno.is_integer()
                        )
                        or isinstance(data__colno, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".colno must be integer or null"
                        )
                    if isinstance(data__colno, (int, float, Decimal)):
                        if data__colno < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".colno must be bigger than or equal to 0.0"
                            )
                if "context_line" in data_keys:
                    data_keys.remove("context_line")
                    data__contextline = data["context_line"]
                    if not isinstance(data__contextline, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".context_line must be string or null"
                        )
                if "filename" in data_keys:
                    data_keys.remove("filename")
                    data__filename = data["filename"]
                    data__filename_any_of_count56 = 0
                    if not data__filename_any_of_count56:
                        try:
                            validate___definitions_nativeimagepath(
                                data__filename,
                                custom_formats,
                                (name_prefix or "data") + ".filename",
                            )
                            data__filename_any_of_count56 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__filename_any_of_count56:
                        try:
                            if not isinstance(data__filename, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".filename must be null"
                                )
                            data__filename_any_of_count56 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__filename_any_of_count56:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".filename cannot be validated by any definition"
                        )
                if "function" in data_keys:
                    data_keys.remove("function")
                    data__function = data["function"]
                    if not isinstance(data__function, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".function must be string or null"
                        )
                if "function_id" in data_keys:
                    data_keys.remove("function_id")
                    data__functionid = data["function_id"]
                    data__functionid_any_of_count57 = 0
                    if not data__functionid_any_of_count57:
                        try:
                            validate___definitions_addr(
                                data__functionid,
                                custom_formats,
                                (name_prefix or "data") + ".function_id",
                            )
                            data__functionid_any_of_count57 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__functionid_any_of_count57:
                        try:
                            if not isinstance(data__functionid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".function_id must be null"
                                )
                            data__functionid_any_of_count57 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__functionid_any_of_count57:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".function_id cannot be validated by any definition"
                        )
                if "image_addr" in data_keys:
                    data_keys.remove("image_addr")
                    data__imageaddr = data["image_addr"]
                    data__imageaddr_any_of_count58 = 0
                    if not data__imageaddr_any_of_count58:
                        try:
                            validate___definitions_addr(
                                data__imageaddr,
                                custom_formats,
                                (name_prefix or "data") + ".image_addr",
                            )
                            data__imageaddr_any_of_count58 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imageaddr_any_of_count58:
                        try:
                            if not isinstance(data__imageaddr, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".image_addr must be null"
                                )
                            data__imageaddr_any_of_count58 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imageaddr_any_of_count58:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".image_addr cannot be validated by any definition"
                        )
                if "in_app" in data_keys:
                    data_keys.remove("in_app")
                    data__inapp = data["in_app"]
                    if not isinstance(data__inapp, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".in_app must be boolean or null"
                        )
                if "instruction_addr" in data_keys:
                    data_keys.remove("instruction_addr")
                    data__instructionaddr = data["instruction_addr"]
                    data__instructionaddr_any_of_count59 = 0
                    if not data__instructionaddr_any_of_count59:
                        try:
                            validate___definitions_addr(
                                data__instructionaddr,
                                custom_formats,
                                (name_prefix or "data") + ".instruction_addr",
                            )
                            data__instructionaddr_any_of_count59 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__instructionaddr_any_of_count59:
                        try:
                            if not isinstance(data__instructionaddr, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".instruction_addr must be null"
                                )
                            data__instructionaddr_any_of_count59 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__instructionaddr_any_of_count59:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".instruction_addr cannot be validated by any definition"
                        )
                if "lineno" in data_keys:
                    data_keys.remove("lineno")
                    data__lineno = data["lineno"]
                    if (
                        not isinstance(data__lineno, (int, NoneType))
                        and not (
                            isinstance(data__lineno, float)
                            and data__lineno.is_integer()
                        )
                        or isinstance(data__lineno, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".lineno must be integer or null"
                        )
                    if isinstance(data__lineno, (int, float, Decimal)):
                        if data__lineno < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".lineno must be bigger than or equal to 0.0"
                            )
                if "lock" in data_keys:
                    data_keys.remove("lock")
                    data__lock = data["lock"]
                    data__lock_any_of_count60 = 0
                    if not data__lock_any_of_count60:
                        try:
                            validate___definitions_lockreason(
                                data__lock,
                                custom_formats,
                                (name_prefix or "data") + ".lock",
                            )
                            data__lock_any_of_count60 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__lock_any_of_count60:
                        try:
                            if not isinstance(data__lock, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".lock must be null"
                                )
                            data__lock_any_of_count60 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__lock_any_of_count60:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".lock cannot be validated by any definition"
                        )
                if "module" in data_keys:
                    data_keys.remove("module")
                    data__module = data["module"]
                    if not isinstance(data__module, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".module must be string or null"
                        )
                if "package" in data_keys:
                    data_keys.remove("package")
                    data__package = data["package"]
                    if not isinstance(data__package, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".package must be string or null"
                        )
                if "platform" in data_keys:
                    data_keys.remove("platform")
                    data__platform = data["platform"]
                    if not isinstance(data__platform, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".platform must be string or null"
                        )
                if "post_context" in data_keys:
                    data_keys.remove("post_context")
                    data__postcontext = data["post_context"]
                    if not isinstance(data__postcontext, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".post_context must be array or null"
                        )
                    data__postcontext_is_list = isinstance(
                        data__postcontext, (list, tuple)
                    )
                    if data__postcontext_is_list:
                        data__postcontext_len = len(data__postcontext)
                        for data__postcontext_x, data__postcontext_item in enumerate(
                            data__postcontext
                        ):
                            if not isinstance(data__postcontext_item, (str, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".post_context[{data__postcontext_x}]".format(
                                        **locals()
                                    )
                                    + " must be string or null"
                                )
                if "pre_context" in data_keys:
                    data_keys.remove("pre_context")
                    data__precontext = data["pre_context"]
                    if not isinstance(data__precontext, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".pre_context must be array or null"
                        )
                    data__precontext_is_list = isinstance(
                        data__precontext, (list, tuple)
                    )
                    if data__precontext_is_list:
                        data__precontext_len = len(data__precontext)
                        for data__precontext_x, data__precontext_item in enumerate(
                            data__precontext
                        ):
                            if not isinstance(data__precontext_item, (str, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".pre_context[{data__precontext_x}]".format(
                                        **locals()
                                    )
                                    + " must be string or null"
                                )
                if "raw_function" in data_keys:
                    data_keys.remove("raw_function")
                    data__rawfunction = data["raw_function"]
                    if not isinstance(data__rawfunction, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".raw_function must be string or null"
                        )
                if "stack_start" in data_keys:
                    data_keys.remove("stack_start")
                    data__stackstart = data["stack_start"]
                    if not isinstance(data__stackstart, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".stack_start must be boolean or null"
                        )
                if "symbol" in data_keys:
                    data_keys.remove("symbol")
                    data__symbol = data["symbol"]
                    if not isinstance(data__symbol, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".symbol must be string or null"
                        )
                if "symbol_addr" in data_keys:
                    data_keys.remove("symbol_addr")
                    data__symboladdr = data["symbol_addr"]
                    data__symboladdr_any_of_count61 = 0
                    if not data__symboladdr_any_of_count61:
                        try:
                            validate___definitions_addr(
                                data__symboladdr,
                                custom_formats,
                                (name_prefix or "data") + ".symbol_addr",
                            )
                            data__symboladdr_any_of_count61 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__symboladdr_any_of_count61:
                        try:
                            if not isinstance(data__symboladdr, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".symbol_addr must be null"
                                )
                            data__symboladdr_any_of_count61 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__symboladdr_any_of_count61:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".symbol_addr cannot be validated by any definition"
                        )
                if "vars" in data_keys:
                    data_keys.remove("vars")
                    data__vars = data["vars"]
                    data__vars_any_of_count62 = 0
                    if not data__vars_any_of_count62:
                        try:
                            validate___definitions_framevars(
                                data__vars,
                                custom_formats,
                                (name_prefix or "data") + ".vars",
                            )
                            data__vars_any_of_count62 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__vars_any_of_count62:
                        try:
                            if not isinstance(data__vars, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".vars must be null"
                                )
                            data__vars_any_of_count62 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__vars_any_of_count62:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".vars cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count54 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count54:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_framevars(data, custom_formats={}, name_prefix=None):
    data_any_of_count63 = 0
    if not data_any_of_count63:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
            data_any_of_count63 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count63:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_addr(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    return data


def validate___definitions_nativeimagepath(data, custom_formats={}, name_prefix=None):
    data_any_of_count64 = 0
    if not data_any_of_count64:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count64 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count64:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_clientsdkinfo(data, custom_formats={}, name_prefix=None):
    data_any_of_count65 = 0
    if not data_any_of_count65:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["name", "version"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "features" in data_keys:
                    data_keys.remove("features")
                    data__features = data["features"]
                    if not isinstance(data__features, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".features must be array or null"
                        )
                    data__features_is_list = isinstance(data__features, (list, tuple))
                    if data__features_is_list:
                        data__features_len = len(data__features)
                        for data__features_x, data__features_item in enumerate(
                            data__features
                        ):
                            if not isinstance(data__features_item, (str, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".features[{data__features_x}]".format(**locals())
                                    + " must be string or null"
                                )
                if "integrations" in data_keys:
                    data_keys.remove("integrations")
                    data__integrations = data["integrations"]
                    if not isinstance(data__integrations, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".integrations must be array or null"
                        )
                    data__integrations_is_list = isinstance(
                        data__integrations, (list, tuple)
                    )
                    if data__integrations_is_list:
                        data__integrations_len = len(data__integrations)
                        for data__integrations_x, data__integrations_item in enumerate(
                            data__integrations
                        ):
                            if not isinstance(data__integrations_item, (str, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".integrations[{data__integrations_x}]".format(
                                        **locals()
                                    )
                                    + " must be string or null"
                                )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "packages" in data_keys:
                    data_keys.remove("packages")
                    data__packages = data["packages"]
                    if not isinstance(data__packages, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".packages must be array or null"
                        )
                    data__packages_is_list = isinstance(data__packages, (list, tuple))
                    if data__packages_is_list:
                        data__packages_len = len(data__packages)
                        for data__packages_x, data__packages_item in enumerate(
                            data__packages
                        ):
                            data__packages_item_any_of_count66 = 0
                            if not data__packages_item_any_of_count66:
                                try:
                                    validate___definitions_clientsdkpackage(
                                        data__packages_item,
                                        custom_formats,
                                        (name_prefix or "data")
                                        + ".packages[{data__packages_x}]".format(
                                            **locals()
                                        ),
                                    )
                                    data__packages_item_any_of_count66 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__packages_item_any_of_count66:
                                try:
                                    if not isinstance(data__packages_item, (NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".packages[{data__packages_x}]".format(
                                                **locals()
                                            )
                                            + " must be null"
                                        )
                                    data__packages_item_any_of_count66 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__packages_item_any_of_count66:
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".packages[{data__packages_x}]".format(**locals())
                                    + " cannot be validated by any definition"
                                )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count65 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count65:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_clientsdkpackage(data, custom_formats={}, name_prefix=None):
    data_any_of_count67 = 0
    if not data_any_of_count67:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count67 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count67:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_request(data, custom_formats={}, name_prefix=None):
    data_any_of_count68 = 0
    if not data_any_of_count68:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "api_target" in data_keys:
                    data_keys.remove("api_target")
                    data__apitarget = data["api_target"]
                    if not isinstance(data__apitarget, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".api_target must be string or null"
                        )
                if "body_size" in data_keys:
                    data_keys.remove("body_size")
                    data__bodysize = data["body_size"]
                    if (
                        not isinstance(data__bodysize, (int, NoneType))
                        and not (
                            isinstance(data__bodysize, float)
                            and data__bodysize.is_integer()
                        )
                        or isinstance(data__bodysize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".body_size must be integer or null"
                        )
                    if isinstance(data__bodysize, (int, float, Decimal)):
                        if data__bodysize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".body_size must be bigger than or equal to 0.0"
                            )
                if "cookies" in data_keys:
                    data_keys.remove("cookies")
                    data__cookies = data["cookies"]
                    data__cookies_any_of_count69 = 0
                    if not data__cookies_any_of_count69:
                        try:
                            validate___definitions_cookies(
                                data__cookies,
                                custom_formats,
                                (name_prefix or "data") + ".cookies",
                            )
                            data__cookies_any_of_count69 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__cookies_any_of_count69:
                        try:
                            if not isinstance(data__cookies, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".cookies must be null"
                                )
                            data__cookies_any_of_count69 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__cookies_any_of_count69:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cookies cannot be validated by any definition"
                        )
                if "data" in data_keys:
                    data_keys.remove("data")
                    data__data = data["data"]
                if "env" in data_keys:
                    data_keys.remove("env")
                    data__env = data["env"]
                    if not isinstance(data__env, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + ".env must be object or null"
                        )
                    data__env_is_dict = isinstance(data__env, dict)
                    if data__env_is_dict:
                        data__env_keys = set(data__env.keys())
                if "fragment" in data_keys:
                    data_keys.remove("fragment")
                    data__fragment = data["fragment"]
                    if not isinstance(data__fragment, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".fragment must be string or null"
                        )
                if "headers" in data_keys:
                    data_keys.remove("headers")
                    data__headers = data["headers"]
                    data__headers_any_of_count70 = 0
                    if not data__headers_any_of_count70:
                        try:
                            validate___definitions_headers(
                                data__headers,
                                custom_formats,
                                (name_prefix or "data") + ".headers",
                            )
                            data__headers_any_of_count70 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__headers_any_of_count70:
                        try:
                            if not isinstance(data__headers, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".headers must be null"
                                )
                            data__headers_any_of_count70 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__headers_any_of_count70:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".headers cannot be validated by any definition"
                        )
                if "inferred_content_type" in data_keys:
                    data_keys.remove("inferred_content_type")
                    data__inferredcontenttype = data["inferred_content_type"]
                    if not isinstance(data__inferredcontenttype, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".inferred_content_type must be string or null"
                        )
                if "method" in data_keys:
                    data_keys.remove("method")
                    data__method = data["method"]
                    if not isinstance(data__method, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".method must be string or null"
                        )
                if "protocol" in data_keys:
                    data_keys.remove("protocol")
                    data__protocol = data["protocol"]
                    if not isinstance(data__protocol, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".protocol must be string or null"
                        )
                if "query_string" in data_keys:
                    data_keys.remove("query_string")
                    data__querystring = data["query_string"]
                    data__querystring_any_of_count71 = 0
                    if not data__querystring_any_of_count71:
                        try:
                            data__querystring_any_of_count72 = 0
                            if not data__querystring_any_of_count72:
                                try:
                                    if not isinstance(data__querystring, (str)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".query_string must be string"
                                        )
                                    data__querystring_any_of_count72 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__querystring_any_of_count72:
                                try:
                                    data__querystring_any_of_count73 = 0
                                    if not data__querystring_any_of_count73:
                                        try:
                                            if not isinstance(
                                                data__querystring, (dict)
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".query_string must be object"
                                                )
                                            data__querystring_is_dict = isinstance(
                                                data__querystring, dict
                                            )
                                            if data__querystring_is_dict:
                                                data__querystring_keys = set(
                                                    data__querystring.keys()
                                                )
                                                for (
                                                    data__querystring_key
                                                ) in data__querystring_keys:
                                                    if data__querystring_key not in []:
                                                        data__querystring_value = (
                                                            data__querystring.get(
                                                                data__querystring_key
                                                            )
                                                        )
                                                        if not isinstance(
                                                            data__querystring_value,
                                                            (str, NoneType),
                                                        ):
                                                            raise JsonSchemaValueException(
                                                                ""
                                                                + (
                                                                    name_prefix
                                                                    or "data"
                                                                )
                                                                + ".query_string.{data__querystring_key}".format(
                                                                    **locals()
                                                                )
                                                                + " must be string or null"
                                                            )
                                            data__querystring_any_of_count73 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__querystring_any_of_count73:
                                        try:
                                            if not isinstance(
                                                data__querystring, (list, tuple)
                                            ):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + ".query_string must be array"
                                                )
                                            data__querystring_is_list = isinstance(
                                                data__querystring, (list, tuple)
                                            )
                                            if data__querystring_is_list:
                                                data__querystring_len = len(
                                                    data__querystring
                                                )
                                                for (
                                                    data__querystring_x,
                                                    data__querystring_item,
                                                ) in enumerate(data__querystring):
                                                    if not isinstance(
                                                        data__querystring_item,
                                                        (list, tuple, NoneType),
                                                    ):
                                                        raise JsonSchemaValueException(
                                                            ""
                                                            + (name_prefix or "data")
                                                            + ".query_string[{data__querystring_x}]".format(
                                                                **locals()
                                                            )
                                                            + " must be array or null"
                                                        )
                                                    data__querystring_item_is_list = (
                                                        isinstance(
                                                            data__querystring_item,
                                                            (list, tuple),
                                                        )
                                                    )
                                                    if data__querystring_item_is_list:
                                                        data__querystring_item_len = (
                                                            len(data__querystring_item)
                                                        )
                                                        if (
                                                            data__querystring_item_len
                                                            < 2
                                                        ):
                                                            raise JsonSchemaValueException(
                                                                ""
                                                                + (
                                                                    name_prefix
                                                                    or "data"
                                                                )
                                                                + ".query_string[{data__querystring_x}]".format(
                                                                    **locals()
                                                                )
                                                                + " must contain at least 2 items"
                                                            )
                                                        if (
                                                            data__querystring_item_len
                                                            > 2
                                                        ):
                                                            raise JsonSchemaValueException(
                                                                ""
                                                                + (
                                                                    name_prefix
                                                                    or "data"
                                                                )
                                                                + ".query_string[{data__querystring_x}]".format(
                                                                    **locals()
                                                                )
                                                                + " must contain less than or equal to 2 items"
                                                            )
                                                        if (
                                                            data__querystring_item_len
                                                            > 0
                                                        ):
                                                            data__querystring_item__0 = data__querystring_item[
                                                                0
                                                            ]
                                                            if not isinstance(
                                                                data__querystring_item__0,
                                                                (str, NoneType),
                                                            ):
                                                                raise JsonSchemaValueException(
                                                                    ""
                                                                    + (
                                                                        name_prefix
                                                                        or "data"
                                                                    )
                                                                    + ".query_string[{data__querystring_x}][0]".format(
                                                                        **locals()
                                                                    )
                                                                    + " must be string or null"
                                                                )
                                                        if (
                                                            data__querystring_item_len
                                                            > 1
                                                        ):
                                                            data__querystring_item__1 = data__querystring_item[
                                                                1
                                                            ]
                                                            if not isinstance(
                                                                data__querystring_item__1,
                                                                (str, NoneType),
                                                            ):
                                                                raise JsonSchemaValueException(
                                                                    ""
                                                                    + (
                                                                        name_prefix
                                                                        or "data"
                                                                    )
                                                                    + ".query_string[{data__querystring_x}][1]".format(
                                                                        **locals()
                                                                    )
                                                                    + " must be string or null"
                                                                )
                                            data__querystring_any_of_count73 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data__querystring_any_of_count73:
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".query_string cannot be validated by any definition"
                                        )
                                    data__querystring_any_of_count72 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__querystring_any_of_count72:
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".query_string cannot be validated by any definition"
                                )
                            data__querystring_any_of_count71 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__querystring_any_of_count71:
                        try:
                            if not isinstance(data__querystring, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".query_string must be null"
                                )
                            data__querystring_any_of_count71 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__querystring_any_of_count71:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".query_string cannot be validated by any definition"
                        )
                if "url" in data_keys:
                    data_keys.remove("url")
                    data__url = data["url"]
                    if not isinstance(data__url, (str, NoneType)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + ".url must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count68 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count68:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_headers(data, custom_formats={}, name_prefix=None):
    data_any_of_count74 = 0
    if not data_any_of_count74:
        try:
            data_any_of_count75 = 0
            if not data_any_of_count75:
                try:
                    if not isinstance(data, (dict)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + " must be object"
                        )
                    data_is_dict = isinstance(data, dict)
                    if data_is_dict:
                        data_keys = set(data.keys())
                        for data_key in data_keys:
                            if data_key not in []:
                                data_value = data.get(data_key)
                                data_value_any_of_count76 = 0
                                if not data_value_any_of_count76:
                                    try:
                                        validate___definitions_headervalue(
                                            data_value,
                                            custom_formats,
                                            (name_prefix or "data")
                                            + ".{data_key}".format(**locals()),
                                        )
                                        data_value_any_of_count76 += 1
                                    except JsonSchemaValueException:
                                        pass
                                if not data_value_any_of_count76:
                                    try:
                                        if not isinstance(data_value, (NoneType)):
                                            raise JsonSchemaValueException(
                                                ""
                                                + (name_prefix or "data")
                                                + ".{data_key}".format(**locals())
                                                + " must be null"
                                            )
                                        data_value_any_of_count76 += 1
                                    except JsonSchemaValueException:
                                        pass
                                if not data_value_any_of_count76:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".{data_key}".format(**locals())
                                        + " cannot be validated by any definition"
                                    )
                    data_any_of_count75 += 1
                except JsonSchemaValueException:
                    pass
            if not data_any_of_count75:
                try:
                    if not isinstance(data, (list, tuple)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + " must be array"
                        )
                    data_is_list = isinstance(data, (list, tuple))
                    if data_is_list:
                        data_len = len(data)
                        for data_x, data_item in enumerate(data):
                            if not isinstance(data_item, (list, tuple, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + "[{data_x}]".format(**locals())
                                    + " must be array or null"
                                )
                            data_item_is_list = isinstance(data_item, (list, tuple))
                            if data_item_is_list:
                                data_item_len = len(data_item)
                                if data_item_len < 2:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + "[{data_x}]".format(**locals())
                                        + " must contain at least 2 items"
                                    )
                                if data_item_len > 2:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + "[{data_x}]".format(**locals())
                                        + " must contain less than or equal to 2 items"
                                    )
                                if data_item_len > 0:
                                    data_item__0 = data_item[0]
                                    data_item__0_any_of_count77 = 0
                                    if not data_item__0_any_of_count77:
                                        try:
                                            validate___definitions_headername(
                                                data_item__0,
                                                custom_formats,
                                                (name_prefix or "data")
                                                + "[{data_x}][0]".format(**locals()),
                                            )
                                            data_item__0_any_of_count77 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data_item__0_any_of_count77:
                                        try:
                                            if not isinstance(data_item__0, (NoneType)):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + "[{data_x}][0]".format(**locals())
                                                    + " must be null"
                                                )
                                            data_item__0_any_of_count77 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data_item__0_any_of_count77:
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + "[{data_x}][0]".format(**locals())
                                            + " cannot be validated by any definition"
                                        )
                                if data_item_len > 1:
                                    data_item__1 = data_item[1]
                                    data_item__1_any_of_count78 = 0
                                    if not data_item__1_any_of_count78:
                                        try:
                                            validate___definitions_headervalue(
                                                data_item__1,
                                                custom_formats,
                                                (name_prefix or "data")
                                                + "[{data_x}][1]".format(**locals()),
                                            )
                                            data_item__1_any_of_count78 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data_item__1_any_of_count78:
                                        try:
                                            if not isinstance(data_item__1, (NoneType)):
                                                raise JsonSchemaValueException(
                                                    ""
                                                    + (name_prefix or "data")
                                                    + "[{data_x}][1]".format(**locals())
                                                    + " must be null"
                                                )
                                            data_item__1_any_of_count78 += 1
                                        except JsonSchemaValueException:
                                            pass
                                    if not data_item__1_any_of_count78:
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + "[{data_x}][1]".format(**locals())
                                            + " cannot be validated by any definition"
                                        )
                    data_any_of_count75 += 1
                except JsonSchemaValueException:
                    pass
            if not data_any_of_count75:
                raise JsonSchemaValueException(
                    ""
                    + (name_prefix or "data")
                    + " cannot be validated by any definition"
                )
            data_any_of_count74 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count74:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_headername(data, custom_formats={}, name_prefix=None):
    data_any_of_count79 = 0
    if not data_any_of_count79:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count79 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count79:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_headervalue(data, custom_formats={}, name_prefix=None):
    data_any_of_count80 = 0
    if not data_any_of_count80:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count80 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count80:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_cookies(data, custom_formats={}, name_prefix=None):
    data_any_of_count81 = 0
    if not data_any_of_count81:
        try:
            data_any_of_count82 = 0
            if not data_any_of_count82:
                try:
                    if not isinstance(data, (dict)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + " must be object"
                        )
                    data_is_dict = isinstance(data, dict)
                    if data_is_dict:
                        data_keys = set(data.keys())
                        for data_key in data_keys:
                            if data_key not in []:
                                data_value = data.get(data_key)
                                if not isinstance(data_value, (str, NoneType)):
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".{data_key}".format(**locals())
                                        + " must be string or null"
                                    )
                    data_any_of_count82 += 1
                except JsonSchemaValueException:
                    pass
            if not data_any_of_count82:
                try:
                    if not isinstance(data, (list, tuple)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + " must be array"
                        )
                    data_is_list = isinstance(data, (list, tuple))
                    if data_is_list:
                        data_len = len(data)
                        for data_x, data_item in enumerate(data):
                            if not isinstance(data_item, (list, tuple, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + "[{data_x}]".format(**locals())
                                    + " must be array or null"
                                )
                            data_item_is_list = isinstance(data_item, (list, tuple))
                            if data_item_is_list:
                                data_item_len = len(data_item)
                                if data_item_len < 2:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + "[{data_x}]".format(**locals())
                                        + " must contain at least 2 items"
                                    )
                                if data_item_len > 2:
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + "[{data_x}]".format(**locals())
                                        + " must contain less than or equal to 2 items"
                                    )
                                if data_item_len > 0:
                                    data_item__0 = data_item[0]
                                    if not isinstance(data_item__0, (str, NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + "[{data_x}][0]".format(**locals())
                                            + " must be string or null"
                                        )
                                if data_item_len > 1:
                                    data_item__1 = data_item[1]
                                    if not isinstance(data_item__1, (str, NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + "[{data_x}][1]".format(**locals())
                                            + " must be string or null"
                                        )
                    data_any_of_count82 += 1
                except JsonSchemaValueException:
                    pass
            if not data_any_of_count82:
                raise JsonSchemaValueException(
                    ""
                    + (name_prefix or "data")
                    + " cannot be validated by any definition"
                )
            data_any_of_count81 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count81:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_timestamp(data, custom_formats={}, name_prefix=None):
    data_any_of_count83 = 0
    if not data_any_of_count83:
        try:
            if not isinstance(data, (int, float, Decimal)) or isinstance(data, bool):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be number"
                )
            data_any_of_count83 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count83:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count83 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count83:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_logentry(data, custom_formats={}, name_prefix=None):
    data_any_of_count84 = 0
    if not data_any_of_count84:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "formatted" in data_keys:
                    data_keys.remove("formatted")
                    data__formatted = data["formatted"]
                    data__formatted_any_of_count85 = 0
                    if not data__formatted_any_of_count85:
                        try:
                            validate___definitions_message(
                                data__formatted,
                                custom_formats,
                                (name_prefix or "data") + ".formatted",
                            )
                            data__formatted_any_of_count85 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__formatted_any_of_count85:
                        try:
                            if not isinstance(data__formatted, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".formatted must be null"
                                )
                            data__formatted_any_of_count85 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__formatted_any_of_count85:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".formatted cannot be validated by any definition"
                        )
                if "message" in data_keys:
                    data_keys.remove("message")
                    data__message = data["message"]
                    data__message_any_of_count86 = 0
                    if not data__message_any_of_count86:
                        try:
                            validate___definitions_message(
                                data__message,
                                custom_formats,
                                (name_prefix or "data") + ".message",
                            )
                            data__message_any_of_count86 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__message_any_of_count86:
                        try:
                            if not isinstance(data__message, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".message must be null"
                                )
                            data__message_any_of_count86 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__message_any_of_count86:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".message cannot be validated by any definition"
                        )
                if "params" in data_keys:
                    data_keys.remove("params")
                    data__params = data["params"]
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count84 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count84:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_message(data, custom_formats={}, name_prefix=None):
    data_any_of_count87 = 0
    if not data_any_of_count87:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count87 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count87:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_level(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    if data not in ["debug", "info", "warning", "error", "fatal"]:
        raise JsonSchemaValueException(
            ""
            + (name_prefix or "data")
            + " must be one of ['debug', 'info', 'warning', 'error', 'fatal']"
        )
    return data


def validate___definitions_fingerprint(data, custom_formats={}, name_prefix=None):
    data_any_of_count88 = 0
    if not data_any_of_count88:
        try:
            if not isinstance(data, (list, tuple)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be array"
                )
            data_is_list = isinstance(data, (list, tuple))
            if data_is_list:
                data_len = len(data)
                for data_x, data_item in enumerate(data):
                    if not isinstance(data_item, (str)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + "[{data_x}]".format(**locals())
                            + " must be string"
                        )
            data_any_of_count88 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count88:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_exception(data, custom_formats={}, name_prefix=None):
    data_any_of_count89 = 0
    if not data_any_of_count89:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "mechanism" in data_keys:
                    data_keys.remove("mechanism")
                    data__mechanism = data["mechanism"]
                    data__mechanism_any_of_count90 = 0
                    if not data__mechanism_any_of_count90:
                        try:
                            validate___definitions_mechanism(
                                data__mechanism,
                                custom_formats,
                                (name_prefix or "data") + ".mechanism",
                            )
                            data__mechanism_any_of_count90 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__mechanism_any_of_count90:
                        try:
                            if not isinstance(data__mechanism, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".mechanism must be null"
                                )
                            data__mechanism_any_of_count90 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__mechanism_any_of_count90:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".mechanism cannot be validated by any definition"
                        )
                if "module" in data_keys:
                    data_keys.remove("module")
                    data__module = data["module"]
                    if not isinstance(data__module, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".module must be string or null"
                        )
                if "stacktrace" in data_keys:
                    data_keys.remove("stacktrace")
                    data__stacktrace = data["stacktrace"]
                    data__stacktrace_any_of_count91 = 0
                    if not data__stacktrace_any_of_count91:
                        try:
                            validate___definitions_stacktrace(
                                data__stacktrace,
                                custom_formats,
                                (name_prefix or "data") + ".stacktrace",
                            )
                            data__stacktrace_any_of_count91 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__stacktrace_any_of_count91:
                        try:
                            if not isinstance(data__stacktrace, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".stacktrace must be null"
                                )
                            data__stacktrace_any_of_count91 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__stacktrace_any_of_count91:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".stacktrace cannot be validated by any definition"
                        )
                if "thread_id" in data_keys:
                    data_keys.remove("thread_id")
                    data__threadid = data["thread_id"]
                    data__threadid_any_of_count92 = 0
                    if not data__threadid_any_of_count92:
                        try:
                            validate___definitions_threadid(
                                data__threadid,
                                custom_formats,
                                (name_prefix or "data") + ".thread_id",
                            )
                            data__threadid_any_of_count92 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threadid_any_of_count92:
                        try:
                            if not isinstance(data__threadid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".thread_id must be null"
                                )
                            data__threadid_any_of_count92 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threadid_any_of_count92:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".thread_id cannot be validated by any definition"
                        )
                if "type" in data_keys:
                    data_keys.remove("type")
                    data__type = data["type"]
                    if not isinstance(data__type, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".type must be string or null"
                        )
                if "value" in data_keys:
                    data_keys.remove("value")
                    data__value = data["value"]
                    data__value_any_of_count93 = 0
                    if not data__value_any_of_count93:
                        try:
                            validate___definitions_jsonlenientstring(
                                data__value,
                                custom_formats,
                                (name_prefix or "data") + ".value",
                            )
                            data__value_any_of_count93 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__value_any_of_count93:
                        try:
                            if not isinstance(data__value, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".value must be null"
                                )
                            data__value_any_of_count93 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__value_any_of_count93:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".value cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count89 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count89:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_jsonlenientstring(data, custom_formats={}, name_prefix=None):
    data_any_of_count94 = 0
    if not data_any_of_count94:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count94 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count94:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_mechanism(data, custom_formats={}, name_prefix=None):
    data_any_of_count95 = 0
    if not data_any_of_count95:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["type"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "data" in data_keys:
                    data_keys.remove("data")
                    data__data = data["data"]
                    if not isinstance(data__data, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".data must be object or null"
                        )
                    data__data_is_dict = isinstance(data__data, dict)
                    if data__data_is_dict:
                        data__data_keys = set(data__data.keys())
                if "description" in data_keys:
                    data_keys.remove("description")
                    data__description = data["description"]
                    if not isinstance(data__description, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".description must be string or null"
                        )
                if "exception_id" in data_keys:
                    data_keys.remove("exception_id")
                    data__exceptionid = data["exception_id"]
                    if (
                        not isinstance(data__exceptionid, (int, NoneType))
                        and not (
                            isinstance(data__exceptionid, float)
                            and data__exceptionid.is_integer()
                        )
                        or isinstance(data__exceptionid, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".exception_id must be integer or null"
                        )
                    if isinstance(data__exceptionid, (int, float, Decimal)):
                        if data__exceptionid < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".exception_id must be bigger than or equal to 0.0"
                            )
                if "handled" in data_keys:
                    data_keys.remove("handled")
                    data__handled = data["handled"]
                    if not isinstance(data__handled, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".handled must be boolean or null"
                        )
                if "help_link" in data_keys:
                    data_keys.remove("help_link")
                    data__helplink = data["help_link"]
                    if not isinstance(data__helplink, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".help_link must be string or null"
                        )
                if "is_exception_group" in data_keys:
                    data_keys.remove("is_exception_group")
                    data__isexceptiongroup = data["is_exception_group"]
                    if not isinstance(data__isexceptiongroup, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".is_exception_group must be boolean or null"
                        )
                if "meta" in data_keys:
                    data_keys.remove("meta")
                    data__meta = data["meta"]
                    data__meta_any_of_count96 = 0
                    if not data__meta_any_of_count96:
                        try:
                            validate___definitions_mechanismmeta(
                                data__meta,
                                custom_formats,
                                (name_prefix or "data") + ".meta",
                            )
                            data__meta_any_of_count96 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__meta_any_of_count96:
                        try:
                            if not isinstance(data__meta, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".meta must be null"
                                )
                            data__meta_any_of_count96 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__meta_any_of_count96:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".meta cannot be validated by any definition"
                        )
                if "parent_id" in data_keys:
                    data_keys.remove("parent_id")
                    data__parentid = data["parent_id"]
                    if (
                        not isinstance(data__parentid, (int, NoneType))
                        and not (
                            isinstance(data__parentid, float)
                            and data__parentid.is_integer()
                        )
                        or isinstance(data__parentid, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".parent_id must be integer or null"
                        )
                    if isinstance(data__parentid, (int, float, Decimal)):
                        if data__parentid < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".parent_id must be bigger than or equal to 0.0"
                            )
                if "source" in data_keys:
                    data_keys.remove("source")
                    data__source = data["source"]
                    if not isinstance(data__source, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".source must be string or null"
                        )
                if "synthetic" in data_keys:
                    data_keys.remove("synthetic")
                    data__synthetic = data["synthetic"]
                    if not isinstance(data__synthetic, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".synthetic must be boolean or null"
                        )
                if "type" in data_keys:
                    data_keys.remove("type")
                    data__type = data["type"]
                    if not isinstance(data__type, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".type must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count95 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count95:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_mechanismmeta(data, custom_formats={}, name_prefix=None):
    data_any_of_count97 = 0
    if not data_any_of_count97:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "errno" in data_keys:
                    data_keys.remove("errno")
                    data__errno = data["errno"]
                    data__errno_any_of_count98 = 0
                    if not data__errno_any_of_count98:
                        try:
                            validate___definitions_cerror(
                                data__errno,
                                custom_formats,
                                (name_prefix or "data") + ".errno",
                            )
                            data__errno_any_of_count98 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__errno_any_of_count98:
                        try:
                            if not isinstance(data__errno, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".errno must be null"
                                )
                            data__errno_any_of_count98 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__errno_any_of_count98:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".errno cannot be validated by any definition"
                        )
                if "mach_exception" in data_keys:
                    data_keys.remove("mach_exception")
                    data__machexception = data["mach_exception"]
                    data__machexception_any_of_count99 = 0
                    if not data__machexception_any_of_count99:
                        try:
                            validate___definitions_machexception(
                                data__machexception,
                                custom_formats,
                                (name_prefix or "data") + ".mach_exception",
                            )
                            data__machexception_any_of_count99 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__machexception_any_of_count99:
                        try:
                            if not isinstance(data__machexception, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".mach_exception must be null"
                                )
                            data__machexception_any_of_count99 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__machexception_any_of_count99:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".mach_exception cannot be validated by any definition"
                        )
                if "ns_error" in data_keys:
                    data_keys.remove("ns_error")
                    data__nserror = data["ns_error"]
                    data__nserror_any_of_count100 = 0
                    if not data__nserror_any_of_count100:
                        try:
                            validate___definitions_nserror(
                                data__nserror,
                                custom_formats,
                                (name_prefix or "data") + ".ns_error",
                            )
                            data__nserror_any_of_count100 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__nserror_any_of_count100:
                        try:
                            if not isinstance(data__nserror, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".ns_error must be null"
                                )
                            data__nserror_any_of_count100 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__nserror_any_of_count100:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".ns_error cannot be validated by any definition"
                        )
                if "signal" in data_keys:
                    data_keys.remove("signal")
                    data__signal = data["signal"]
                    data__signal_any_of_count101 = 0
                    if not data__signal_any_of_count101:
                        try:
                            validate___definitions_posixsignal(
                                data__signal,
                                custom_formats,
                                (name_prefix or "data") + ".signal",
                            )
                            data__signal_any_of_count101 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__signal_any_of_count101:
                        try:
                            if not isinstance(data__signal, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".signal must be null"
                                )
                            data__signal_any_of_count101 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__signal_any_of_count101:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".signal cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count97 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count97:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_posixsignal(data, custom_formats={}, name_prefix=None):
    data_any_of_count102 = 0
    if not data_any_of_count102:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "code" in data_keys:
                    data_keys.remove("code")
                    data__code = data["code"]
                    if (
                        not isinstance(data__code, (int, NoneType))
                        and not (
                            isinstance(data__code, float) and data__code.is_integer()
                        )
                        or isinstance(data__code, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".code must be integer or null"
                        )
                if "code_name" in data_keys:
                    data_keys.remove("code_name")
                    data__codename = data["code_name"]
                    if not isinstance(data__codename, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".code_name must be string or null"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "number" in data_keys:
                    data_keys.remove("number")
                    data__number = data["number"]
                    if (
                        not isinstance(data__number, (int, NoneType))
                        and not (
                            isinstance(data__number, float)
                            and data__number.is_integer()
                        )
                        or isinstance(data__number, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".number must be integer or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count102 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count102:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_nserror(data, custom_formats={}, name_prefix=None):
    data_any_of_count103 = 0
    if not data_any_of_count103:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "code" in data_keys:
                    data_keys.remove("code")
                    data__code = data["code"]
                    if (
                        not isinstance(data__code, (int, NoneType))
                        and not (
                            isinstance(data__code, float) and data__code.is_integer()
                        )
                        or isinstance(data__code, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".code must be integer or null"
                        )
                if "domain" in data_keys:
                    data_keys.remove("domain")
                    data__domain = data["domain"]
                    if not isinstance(data__domain, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".domain must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count103 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count103:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_machexception(data, custom_formats={}, name_prefix=None):
    data_any_of_count104 = 0
    if not data_any_of_count104:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "code" in data_keys:
                    data_keys.remove("code")
                    data__code = data["code"]
                    if (
                        not isinstance(data__code, (int, NoneType))
                        and not (
                            isinstance(data__code, float) and data__code.is_integer()
                        )
                        or isinstance(data__code, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".code must be integer or null"
                        )
                    if isinstance(data__code, (int, float, Decimal)):
                        if data__code < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".code must be bigger than or equal to 0.0"
                            )
                if "exception" in data_keys:
                    data_keys.remove("exception")
                    data__exception = data["exception"]
                    if (
                        not isinstance(data__exception, (int, NoneType))
                        and not (
                            isinstance(data__exception, float)
                            and data__exception.is_integer()
                        )
                        or isinstance(data__exception, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".exception must be integer or null"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "subcode" in data_keys:
                    data_keys.remove("subcode")
                    data__subcode = data["subcode"]
                    if (
                        not isinstance(data__subcode, (int, NoneType))
                        and not (
                            isinstance(data__subcode, float)
                            and data__subcode.is_integer()
                        )
                        or isinstance(data__subcode, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".subcode must be integer or null"
                        )
                    if isinstance(data__subcode, (int, float, Decimal)):
                        if data__subcode < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".subcode must be bigger than or equal to 0.0"
                            )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count104 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count104:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_cerror(data, custom_formats={}, name_prefix=None):
    data_any_of_count105 = 0
    if not data_any_of_count105:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "number" in data_keys:
                    data_keys.remove("number")
                    data__number = data["number"]
                    if (
                        not isinstance(data__number, (int, NoneType))
                        and not (
                            isinstance(data__number, float)
                            and data__number.is_integer()
                        )
                        or isinstance(data__number, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".number must be integer or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count105 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count105:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_eventid(data, custom_formats={}, name_prefix=None):
    data_any_of_count106 = 0
    if not data_any_of_count106:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count106 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count106:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_eventprocessingerror(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count107 = 0
    if not data_any_of_count107:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["type"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "type" in data_keys:
                    data_keys.remove("type")
                    data__type = data["type"]
                    if not isinstance(data__type, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".type must be string or null"
                        )
                if "value" in data_keys:
                    data_keys.remove("value")
                    data__value = data["value"]
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count107 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count107:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_debugmeta(data, custom_formats={}, name_prefix=None):
    data_any_of_count108 = 0
    if not data_any_of_count108:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "images" in data_keys:
                    data_keys.remove("images")
                    data__images = data["images"]
                    if not isinstance(data__images, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".images must be array or null"
                        )
                    data__images_is_list = isinstance(data__images, (list, tuple))
                    if data__images_is_list:
                        data__images_len = len(data__images)
                        for data__images_x, data__images_item in enumerate(
                            data__images
                        ):
                            data__images_item_any_of_count109 = 0
                            if not data__images_item_any_of_count109:
                                try:
                                    validate___definitions_debugimage(
                                        data__images_item,
                                        custom_formats,
                                        (name_prefix or "data")
                                        + ".images[{data__images_x}]".format(
                                            **locals()
                                        ),
                                    )
                                    data__images_item_any_of_count109 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__images_item_any_of_count109:
                                try:
                                    if not isinstance(data__images_item, (NoneType)):
                                        raise JsonSchemaValueException(
                                            ""
                                            + (name_prefix or "data")
                                            + ".images[{data__images_x}]".format(
                                                **locals()
                                            )
                                            + " must be null"
                                        )
                                    data__images_item_any_of_count109 += 1
                                except JsonSchemaValueException:
                                    pass
                            if not data__images_item_any_of_count109:
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".images[{data__images_x}]".format(**locals())
                                    + " cannot be validated by any definition"
                                )
                if "sdk_info" in data_keys:
                    data_keys.remove("sdk_info")
                    data__sdkinfo = data["sdk_info"]
                    data__sdkinfo_any_of_count110 = 0
                    if not data__sdkinfo_any_of_count110:
                        try:
                            validate___definitions_systemsdkinfo(
                                data__sdkinfo,
                                custom_formats,
                                (name_prefix or "data") + ".sdk_info",
                            )
                            data__sdkinfo_any_of_count110 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__sdkinfo_any_of_count110:
                        try:
                            if not isinstance(data__sdkinfo, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".sdk_info must be null"
                                )
                            data__sdkinfo_any_of_count110 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__sdkinfo_any_of_count110:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sdk_info cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count108 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count108:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_systemsdkinfo(data, custom_formats={}, name_prefix=None):
    data_any_of_count111 = 0
    if not data_any_of_count111:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "sdk_name" in data_keys:
                    data_keys.remove("sdk_name")
                    data__sdkname = data["sdk_name"]
                    if not isinstance(data__sdkname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sdk_name must be string or null"
                        )
                if "version_major" in data_keys:
                    data_keys.remove("version_major")
                    data__versionmajor = data["version_major"]
                    if (
                        not isinstance(data__versionmajor, (int, NoneType))
                        and not (
                            isinstance(data__versionmajor, float)
                            and data__versionmajor.is_integer()
                        )
                        or isinstance(data__versionmajor, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version_major must be integer or null"
                        )
                    if isinstance(data__versionmajor, (int, float, Decimal)):
                        if data__versionmajor < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".version_major must be bigger than or equal to 0.0"
                            )
                if "version_minor" in data_keys:
                    data_keys.remove("version_minor")
                    data__versionminor = data["version_minor"]
                    if (
                        not isinstance(data__versionminor, (int, NoneType))
                        and not (
                            isinstance(data__versionminor, float)
                            and data__versionminor.is_integer()
                        )
                        or isinstance(data__versionminor, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version_minor must be integer or null"
                        )
                    if isinstance(data__versionminor, (int, float, Decimal)):
                        if data__versionminor < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".version_minor must be bigger than or equal to 0.0"
                            )
                if "version_patchlevel" in data_keys:
                    data_keys.remove("version_patchlevel")
                    data__versionpatchlevel = data["version_patchlevel"]
                    if (
                        not isinstance(data__versionpatchlevel, (int, NoneType))
                        and not (
                            isinstance(data__versionpatchlevel, float)
                            and data__versionpatchlevel.is_integer()
                        )
                        or isinstance(data__versionpatchlevel, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version_patchlevel must be integer or null"
                        )
                    if isinstance(data__versionpatchlevel, (int, float, Decimal)):
                        if data__versionpatchlevel < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".version_patchlevel must be bigger than or equal to 0.0"
                            )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count111 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count111:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_debugimage(data, custom_formats={}, name_prefix=None):
    data_any_of_count112 = 0
    if not data_any_of_count112:
        try:
            validate___definitions_appledebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_nativedebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_nativedebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_nativedebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_nativedebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_nativedebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_proguarddebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_nativedebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_sourcemapdebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            validate___definitions_jvmdebugimage(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
            data_any_of_count112 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count112:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_jvmdebugimage(data, custom_formats={}, name_prefix=None):
    data_any_of_count113 = 0
    if not data_any_of_count113:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["debug_id"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "debug_id" in data_keys:
                    data_keys.remove("debug_id")
                    data__debugid = data["debug_id"]
                    data__debugid_any_of_count114 = 0
                    if not data__debugid_any_of_count114:
                        try:
                            validate___definitions_debugid(
                                data__debugid,
                                custom_formats,
                                (name_prefix or "data") + ".debug_id",
                            )
                            data__debugid_any_of_count114 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugid_any_of_count114:
                        try:
                            if not isinstance(data__debugid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".debug_id must be null"
                                )
                            data__debugid_any_of_count114 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugid_any_of_count114:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".debug_id cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count113 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count113:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_debugid(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    return data


def validate___definitions_sourcemapdebugimage(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count115 = 0
    if not data_any_of_count115:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["code_file", "debug_id"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "code_file" in data_keys:
                    data_keys.remove("code_file")
                    data__codefile = data["code_file"]
                    if not isinstance(data__codefile, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".code_file must be string or null"
                        )
                if "debug_file" in data_keys:
                    data_keys.remove("debug_file")
                    data__debugfile = data["debug_file"]
                    if not isinstance(data__debugfile, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".debug_file must be string or null"
                        )
                if "debug_id" in data_keys:
                    data_keys.remove("debug_id")
                    data__debugid = data["debug_id"]
                    data__debugid_any_of_count116 = 0
                    if not data__debugid_any_of_count116:
                        try:
                            validate___definitions_debugid(
                                data__debugid,
                                custom_formats,
                                (name_prefix or "data") + ".debug_id",
                            )
                            data__debugid_any_of_count116 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugid_any_of_count116:
                        try:
                            if not isinstance(data__debugid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".debug_id must be null"
                                )
                            data__debugid_any_of_count116 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugid_any_of_count116:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".debug_id cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count115 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count115:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_proguarddebugimage(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count117 = 0
    if not data_any_of_count117:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["uuid"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "uuid" in data_keys:
                    data_keys.remove("uuid")
                    data__uuid = data["uuid"]
                    if not isinstance(data__uuid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".uuid must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count117 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count117:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_nativedebugimage(data, custom_formats={}, name_prefix=None):
    data_any_of_count118 = 0
    if not data_any_of_count118:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["code_file", "debug_id"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "arch" in data_keys:
                    data_keys.remove("arch")
                    data__arch = data["arch"]
                    if not isinstance(data__arch, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".arch must be string or null"
                        )
                if "code_file" in data_keys:
                    data_keys.remove("code_file")
                    data__codefile = data["code_file"]
                    data__codefile_any_of_count119 = 0
                    if not data__codefile_any_of_count119:
                        try:
                            validate___definitions_nativeimagepath(
                                data__codefile,
                                custom_formats,
                                (name_prefix or "data") + ".code_file",
                            )
                            data__codefile_any_of_count119 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__codefile_any_of_count119:
                        try:
                            if not isinstance(data__codefile, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".code_file must be null"
                                )
                            data__codefile_any_of_count119 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__codefile_any_of_count119:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".code_file cannot be validated by any definition"
                        )
                if "code_id" in data_keys:
                    data_keys.remove("code_id")
                    data__codeid = data["code_id"]
                    data__codeid_any_of_count120 = 0
                    if not data__codeid_any_of_count120:
                        try:
                            validate___definitions_codeid(
                                data__codeid,
                                custom_formats,
                                (name_prefix or "data") + ".code_id",
                            )
                            data__codeid_any_of_count120 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__codeid_any_of_count120:
                        try:
                            if not isinstance(data__codeid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".code_id must be null"
                                )
                            data__codeid_any_of_count120 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__codeid_any_of_count120:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".code_id cannot be validated by any definition"
                        )
                if "debug_checksum" in data_keys:
                    data_keys.remove("debug_checksum")
                    data__debugchecksum = data["debug_checksum"]
                    if not isinstance(data__debugchecksum, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".debug_checksum must be string or null"
                        )
                if "debug_file" in data_keys:
                    data_keys.remove("debug_file")
                    data__debugfile = data["debug_file"]
                    data__debugfile_any_of_count121 = 0
                    if not data__debugfile_any_of_count121:
                        try:
                            validate___definitions_nativeimagepath(
                                data__debugfile,
                                custom_formats,
                                (name_prefix or "data") + ".debug_file",
                            )
                            data__debugfile_any_of_count121 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugfile_any_of_count121:
                        try:
                            if not isinstance(data__debugfile, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".debug_file must be null"
                                )
                            data__debugfile_any_of_count121 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugfile_any_of_count121:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".debug_file cannot be validated by any definition"
                        )
                if "debug_id" in data_keys:
                    data_keys.remove("debug_id")
                    data__debugid = data["debug_id"]
                    data__debugid_any_of_count122 = 0
                    if not data__debugid_any_of_count122:
                        try:
                            validate___definitions_debugid(
                                data__debugid,
                                custom_formats,
                                (name_prefix or "data") + ".debug_id",
                            )
                            data__debugid_any_of_count122 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugid_any_of_count122:
                        try:
                            if not isinstance(data__debugid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".debug_id must be null"
                                )
                            data__debugid_any_of_count122 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__debugid_any_of_count122:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".debug_id cannot be validated by any definition"
                        )
                if "image_addr" in data_keys:
                    data_keys.remove("image_addr")
                    data__imageaddr = data["image_addr"]
                    data__imageaddr_any_of_count123 = 0
                    if not data__imageaddr_any_of_count123:
                        try:
                            validate___definitions_addr(
                                data__imageaddr,
                                custom_formats,
                                (name_prefix or "data") + ".image_addr",
                            )
                            data__imageaddr_any_of_count123 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imageaddr_any_of_count123:
                        try:
                            if not isinstance(data__imageaddr, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".image_addr must be null"
                                )
                            data__imageaddr_any_of_count123 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imageaddr_any_of_count123:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".image_addr cannot be validated by any definition"
                        )
                if "image_size" in data_keys:
                    data_keys.remove("image_size")
                    data__imagesize = data["image_size"]
                    if (
                        not isinstance(data__imagesize, (int, NoneType))
                        and not (
                            isinstance(data__imagesize, float)
                            and data__imagesize.is_integer()
                        )
                        or isinstance(data__imagesize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".image_size must be integer or null"
                        )
                    if isinstance(data__imagesize, (int, float, Decimal)):
                        if data__imagesize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".image_size must be bigger than or equal to 0.0"
                            )
                if "image_vmaddr" in data_keys:
                    data_keys.remove("image_vmaddr")
                    data__imagevmaddr = data["image_vmaddr"]
                    data__imagevmaddr_any_of_count124 = 0
                    if not data__imagevmaddr_any_of_count124:
                        try:
                            validate___definitions_addr(
                                data__imagevmaddr,
                                custom_formats,
                                (name_prefix or "data") + ".image_vmaddr",
                            )
                            data__imagevmaddr_any_of_count124 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imagevmaddr_any_of_count124:
                        try:
                            if not isinstance(data__imagevmaddr, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".image_vmaddr must be null"
                                )
                            data__imagevmaddr_any_of_count124 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imagevmaddr_any_of_count124:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".image_vmaddr cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count118 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count118:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_codeid(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    return data


def validate___definitions_appledebugimage(data, custom_formats={}, name_prefix=None):
    data_any_of_count125 = 0
    if not data_any_of_count125:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = (
                    set(["image_addr", "image_size", "name", "uuid"]) - data.keys()
                )
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "arch" in data_keys:
                    data_keys.remove("arch")
                    data__arch = data["arch"]
                    if not isinstance(data__arch, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".arch must be string or null"
                        )
                if "cpu_subtype" in data_keys:
                    data_keys.remove("cpu_subtype")
                    data__cpusubtype = data["cpu_subtype"]
                    if (
                        not isinstance(data__cpusubtype, (int, NoneType))
                        and not (
                            isinstance(data__cpusubtype, float)
                            and data__cpusubtype.is_integer()
                        )
                        or isinstance(data__cpusubtype, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cpu_subtype must be integer or null"
                        )
                    if isinstance(data__cpusubtype, (int, float, Decimal)):
                        if data__cpusubtype < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".cpu_subtype must be bigger than or equal to 0.0"
                            )
                if "cpu_type" in data_keys:
                    data_keys.remove("cpu_type")
                    data__cputype = data["cpu_type"]
                    if (
                        not isinstance(data__cputype, (int, NoneType))
                        and not (
                            isinstance(data__cputype, float)
                            and data__cputype.is_integer()
                        )
                        or isinstance(data__cputype, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cpu_type must be integer or null"
                        )
                    if isinstance(data__cputype, (int, float, Decimal)):
                        if data__cputype < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".cpu_type must be bigger than or equal to 0.0"
                            )
                if "image_addr" in data_keys:
                    data_keys.remove("image_addr")
                    data__imageaddr = data["image_addr"]
                    data__imageaddr_any_of_count126 = 0
                    if not data__imageaddr_any_of_count126:
                        try:
                            validate___definitions_addr(
                                data__imageaddr,
                                custom_formats,
                                (name_prefix or "data") + ".image_addr",
                            )
                            data__imageaddr_any_of_count126 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imageaddr_any_of_count126:
                        try:
                            if not isinstance(data__imageaddr, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".image_addr must be null"
                                )
                            data__imageaddr_any_of_count126 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imageaddr_any_of_count126:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".image_addr cannot be validated by any definition"
                        )
                if "image_size" in data_keys:
                    data_keys.remove("image_size")
                    data__imagesize = data["image_size"]
                    if (
                        not isinstance(data__imagesize, (int, NoneType))
                        and not (
                            isinstance(data__imagesize, float)
                            and data__imagesize.is_integer()
                        )
                        or isinstance(data__imagesize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".image_size must be integer or null"
                        )
                    if isinstance(data__imagesize, (int, float, Decimal)):
                        if data__imagesize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".image_size must be bigger than or equal to 0.0"
                            )
                if "image_vmaddr" in data_keys:
                    data_keys.remove("image_vmaddr")
                    data__imagevmaddr = data["image_vmaddr"]
                    data__imagevmaddr_any_of_count127 = 0
                    if not data__imagevmaddr_any_of_count127:
                        try:
                            validate___definitions_addr(
                                data__imagevmaddr,
                                custom_formats,
                                (name_prefix or "data") + ".image_vmaddr",
                            )
                            data__imagevmaddr_any_of_count127 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imagevmaddr_any_of_count127:
                        try:
                            if not isinstance(data__imagevmaddr, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".image_vmaddr must be null"
                                )
                            data__imagevmaddr_any_of_count127 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__imagevmaddr_any_of_count127:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".image_vmaddr cannot be validated by any definition"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "uuid" in data_keys:
                    data_keys.remove("uuid")
                    data__uuid = data["uuid"]
                    if not isinstance(data__uuid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".uuid must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count125 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count125:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_contexts(data, custom_formats={}, name_prefix=None):
    data_any_of_count128 = 0
    if not data_any_of_count128:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                for data_key in data_keys:
                    if data_key not in []:
                        data_value = data.get(data_key)
                        data_value_any_of_count129 = 0
                        if not data_value_any_of_count129:
                            try:
                                validate___definitions_contextinner(
                                    data_value,
                                    custom_formats,
                                    (name_prefix or "data")
                                    + ".{data_key}".format(**locals()),
                                )
                                data_value_any_of_count129 += 1
                            except JsonSchemaValueException:
                                pass
                        if not data_value_any_of_count129:
                            try:
                                if not isinstance(data_value, (NoneType)):
                                    raise JsonSchemaValueException(
                                        ""
                                        + (name_prefix or "data")
                                        + ".{data_key}".format(**locals())
                                        + " must be null"
                                    )
                                data_value_any_of_count129 += 1
                            except JsonSchemaValueException:
                                pass
                        if not data_value_any_of_count129:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".{data_key}".format(**locals())
                                + " cannot be validated by any definition"
                            )
            data_any_of_count128 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count128:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_contextinner(data, custom_formats={}, name_prefix=None):
    data_any_of_count130 = 0
    if not data_any_of_count130:
        try:
            validate___definitions_context(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count130 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count130:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_context(data, custom_formats={}, name_prefix=None):
    data_any_of_count131 = 0
    if not data_any_of_count131:
        try:
            validate___definitions_devicecontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_oscontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_runtimecontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_appcontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_browsercontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_gpucontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_tracecontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_profilecontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_replaycontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_userreportv2context(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_monitorcontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_responsecontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_otelcontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_cloudresourcecontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_nelcontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            validate___definitions_performancescorecontext(
                data, custom_formats, (name_prefix or "data") + ""
            )
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
            data_any_of_count131 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count131:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_performancescorecontext(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count132 = 0
    if not data_any_of_count132:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "score_profile_version" in data_keys:
                    data_keys.remove("score_profile_version")
                    data__scoreprofileversion = data["score_profile_version"]
                    if not isinstance(data__scoreprofileversion, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".score_profile_version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count132 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count132:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_nelcontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count133 = 0
    if not data_any_of_count133:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "elapsed_time" in data_keys:
                    data_keys.remove("elapsed_time")
                    data__elapsedtime = data["elapsed_time"]
                    if (
                        not isinstance(data__elapsedtime, (int, NoneType))
                        and not (
                            isinstance(data__elapsedtime, float)
                            and data__elapsedtime.is_integer()
                        )
                        or isinstance(data__elapsedtime, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".elapsed_time must be integer or null"
                        )
                    if isinstance(data__elapsedtime, (int, float, Decimal)):
                        if data__elapsedtime < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".elapsed_time must be bigger than or equal to 0.0"
                            )
                if "error_type" in data_keys:
                    data_keys.remove("error_type")
                    data__errortype = data["error_type"]
                    if not isinstance(data__errortype, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".error_type must be string or null"
                        )
                if "phase" in data_keys:
                    data_keys.remove("phase")
                    data__phase = data["phase"]
                    data__phase_any_of_count134 = 0
                    if not data__phase_any_of_count134:
                        try:
                            validate___definitions_networkreportphases(
                                data__phase,
                                custom_formats,
                                (name_prefix or "data") + ".phase",
                            )
                            data__phase_any_of_count134 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__phase_any_of_count134:
                        try:
                            if not isinstance(data__phase, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".phase must be null"
                                )
                            data__phase_any_of_count134 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__phase_any_of_count134:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".phase cannot be validated by any definition"
                        )
                if "sampling_fraction" in data_keys:
                    data_keys.remove("sampling_fraction")
                    data__samplingfraction = data["sampling_fraction"]
                    if not isinstance(
                        data__samplingfraction, (int, float, Decimal, NoneType)
                    ) or isinstance(data__samplingfraction, bool):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sampling_fraction must be number or null"
                        )
                if "server_ip" in data_keys:
                    data_keys.remove("server_ip")
                    data__serverip = data["server_ip"]
                    data__serverip_any_of_count135 = 0
                    if not data__serverip_any_of_count135:
                        try:
                            validate___definitions_string(
                                data__serverip,
                                custom_formats,
                                (name_prefix or "data") + ".server_ip",
                            )
                            data__serverip_any_of_count135 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__serverip_any_of_count135:
                        try:
                            if not isinstance(data__serverip, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".server_ip must be null"
                                )
                            data__serverip_any_of_count135 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__serverip_any_of_count135:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".server_ip cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count133 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count133:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_networkreportphases(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count136 = 0
    if not data_any_of_count136:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count136 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count136:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count136 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count136:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count136 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count136:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count136 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count136:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_cloudresourcecontext(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count137 = 0
    if not data_any_of_count137:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "cloud.account.id" in data_keys:
                    data_keys.remove("cloud.account.id")
                    data__cloudaccountid = data["cloud.account.id"]
                    if not isinstance(data__cloudaccountid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cloud.account.id must be string or null"
                        )
                if "cloud.availability_zone" in data_keys:
                    data_keys.remove("cloud.availability_zone")
                    data__cloudavailabilityzone = data["cloud.availability_zone"]
                    if not isinstance(data__cloudavailabilityzone, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cloud.availability_zone must be string or null"
                        )
                if "cloud.platform" in data_keys:
                    data_keys.remove("cloud.platform")
                    data__cloudplatform = data["cloud.platform"]
                    if not isinstance(data__cloudplatform, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cloud.platform must be string or null"
                        )
                if "cloud.provider" in data_keys:
                    data_keys.remove("cloud.provider")
                    data__cloudprovider = data["cloud.provider"]
                    if not isinstance(data__cloudprovider, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cloud.provider must be string or null"
                        )
                if "cloud.region" in data_keys:
                    data_keys.remove("cloud.region")
                    data__cloudregion = data["cloud.region"]
                    if not isinstance(data__cloudregion, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cloud.region must be string or null"
                        )
                if "host.id" in data_keys:
                    data_keys.remove("host.id")
                    data__hostid = data["host.id"]
                    if not isinstance(data__hostid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".host.id must be string or null"
                        )
                if "host.type" in data_keys:
                    data_keys.remove("host.type")
                    data__hosttype = data["host.type"]
                    if not isinstance(data__hosttype, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".host.type must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count137 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count137:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_otelcontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count138 = 0
    if not data_any_of_count138:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "attributes" in data_keys:
                    data_keys.remove("attributes")
                    data__attributes = data["attributes"]
                    if not isinstance(data__attributes, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".attributes must be object or null"
                        )
                    data__attributes_is_dict = isinstance(data__attributes, dict)
                    if data__attributes_is_dict:
                        data__attributes_keys = set(data__attributes.keys())
                if "resource" in data_keys:
                    data_keys.remove("resource")
                    data__resource = data["resource"]
                    if not isinstance(data__resource, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".resource must be object or null"
                        )
                    data__resource_is_dict = isinstance(data__resource, dict)
                    if data__resource_is_dict:
                        data__resource_keys = set(data__resource.keys())
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count138 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count138:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_responsecontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count139 = 0
    if not data_any_of_count139:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "body_size" in data_keys:
                    data_keys.remove("body_size")
                    data__bodysize = data["body_size"]
                    if (
                        not isinstance(data__bodysize, (int, NoneType))
                        and not (
                            isinstance(data__bodysize, float)
                            and data__bodysize.is_integer()
                        )
                        or isinstance(data__bodysize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".body_size must be integer or null"
                        )
                    if isinstance(data__bodysize, (int, float, Decimal)):
                        if data__bodysize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".body_size must be bigger than or equal to 0.0"
                            )
                if "cookies" in data_keys:
                    data_keys.remove("cookies")
                    data__cookies = data["cookies"]
                    data__cookies_any_of_count140 = 0
                    if not data__cookies_any_of_count140:
                        try:
                            validate___definitions_cookies(
                                data__cookies,
                                custom_formats,
                                (name_prefix or "data") + ".cookies",
                            )
                            data__cookies_any_of_count140 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__cookies_any_of_count140:
                        try:
                            if not isinstance(data__cookies, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".cookies must be null"
                                )
                            data__cookies_any_of_count140 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__cookies_any_of_count140:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cookies cannot be validated by any definition"
                        )
                if "data" in data_keys:
                    data_keys.remove("data")
                    data__data = data["data"]
                if "headers" in data_keys:
                    data_keys.remove("headers")
                    data__headers = data["headers"]
                    data__headers_any_of_count141 = 0
                    if not data__headers_any_of_count141:
                        try:
                            validate___definitions_headers(
                                data__headers,
                                custom_formats,
                                (name_prefix or "data") + ".headers",
                            )
                            data__headers_any_of_count141 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__headers_any_of_count141:
                        try:
                            if not isinstance(data__headers, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".headers must be null"
                                )
                            data__headers_any_of_count141 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__headers_any_of_count141:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".headers cannot be validated by any definition"
                        )
                if "inferred_content_type" in data_keys:
                    data_keys.remove("inferred_content_type")
                    data__inferredcontenttype = data["inferred_content_type"]
                    if not isinstance(data__inferredcontenttype, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".inferred_content_type must be string or null"
                        )
                if "status_code" in data_keys:
                    data_keys.remove("status_code")
                    data__statuscode = data["status_code"]
                    if (
                        not isinstance(data__statuscode, (int, NoneType))
                        and not (
                            isinstance(data__statuscode, float)
                            and data__statuscode.is_integer()
                        )
                        or isinstance(data__statuscode, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".status_code must be integer or null"
                        )
                    if isinstance(data__statuscode, (int, float, Decimal)):
                        if data__statuscode < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".status_code must be bigger than or equal to 0.0"
                            )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count139 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count139:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_monitorcontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count142 = 0
    if not data_any_of_count142:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
            data_any_of_count142 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count142:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_userreportv2context(
    data, custom_formats={}, name_prefix=None
):
    data_any_of_count143 = 0
    if not data_any_of_count143:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "contact_email" in data_keys:
                    data_keys.remove("contact_email")
                    data__contactemail = data["contact_email"]
                    if not isinstance(data__contactemail, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".contact_email must be string or null"
                        )
                if "message" in data_keys:
                    data_keys.remove("message")
                    data__message = data["message"]
                    if not isinstance(data__message, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".message must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count143 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count143:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_replaycontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count144 = 0
    if not data_any_of_count144:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "replay_id" in data_keys:
                    data_keys.remove("replay_id")
                    data__replayid = data["replay_id"]
                    data__replayid_any_of_count145 = 0
                    if not data__replayid_any_of_count145:
                        try:
                            validate___definitions_eventid(
                                data__replayid,
                                custom_formats,
                                (name_prefix or "data") + ".replay_id",
                            )
                            data__replayid_any_of_count145 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__replayid_any_of_count145:
                        try:
                            if not isinstance(data__replayid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".replay_id must be null"
                                )
                            data__replayid_any_of_count145 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__replayid_any_of_count145:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".replay_id cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count144 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count144:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_profilecontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count146 = 0
    if not data_any_of_count146:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "profile_id" in data_keys:
                    data_keys.remove("profile_id")
                    data__profileid = data["profile_id"]
                    data__profileid_any_of_count147 = 0
                    if not data__profileid_any_of_count147:
                        try:
                            validate___definitions_eventid(
                                data__profileid,
                                custom_formats,
                                (name_prefix or "data") + ".profile_id",
                            )
                            data__profileid_any_of_count147 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__profileid_any_of_count147:
                        try:
                            if not isinstance(data__profileid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".profile_id must be null"
                                )
                            data__profileid_any_of_count147 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__profileid_any_of_count147:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".profile_id cannot be validated by any definition"
                        )
                if "profiler_id" in data_keys:
                    data_keys.remove("profiler_id")
                    data__profilerid = data["profiler_id"]
                    data__profilerid_any_of_count148 = 0
                    if not data__profilerid_any_of_count148:
                        try:
                            validate___definitions_eventid(
                                data__profilerid,
                                custom_formats,
                                (name_prefix or "data") + ".profiler_id",
                            )
                            data__profilerid_any_of_count148 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__profilerid_any_of_count148:
                        try:
                            if not isinstance(data__profilerid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".profiler_id must be null"
                                )
                            data__profilerid_any_of_count148 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__profilerid_any_of_count148:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".profiler_id cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count146 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count146:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_tracecontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count149 = 0
    if not data_any_of_count149:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data__missing_keys = set(["span_id", "trace_id"]) - data.keys()
                if data__missing_keys:
                    raise JsonSchemaValueException(
                        "" + (name_prefix or "data") + " must contain "
                    )
                data_keys = set(data.keys())
                if "client_sample_rate" in data_keys:
                    data_keys.remove("client_sample_rate")
                    data__clientsamplerate = data["client_sample_rate"]
                    if not isinstance(
                        data__clientsamplerate, (int, float, Decimal, NoneType)
                    ) or isinstance(data__clientsamplerate, bool):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".client_sample_rate must be number or null"
                        )
                if "data" in data_keys:
                    data_keys.remove("data")
                    data__data = data["data"]
                    data__data_any_of_count150 = 0
                    if not data__data_any_of_count150:
                        try:
                            validate___definitions_spandata(
                                data__data,
                                custom_formats,
                                (name_prefix or "data") + ".data",
                            )
                            data__data_any_of_count150 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__data_any_of_count150:
                        try:
                            if not isinstance(data__data, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".data must be null"
                                )
                            data__data_any_of_count150 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__data_any_of_count150:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".data cannot be validated by any definition"
                        )
                if "exclusive_time" in data_keys:
                    data_keys.remove("exclusive_time")
                    data__exclusivetime = data["exclusive_time"]
                    if not isinstance(
                        data__exclusivetime, (int, float, Decimal, NoneType)
                    ) or isinstance(data__exclusivetime, bool):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".exclusive_time must be number or null"
                        )
                if "op" in data_keys:
                    data_keys.remove("op")
                    data__op = data["op"]
                    if not isinstance(data__op, (str, NoneType)):
                        raise JsonSchemaValueException(
                            "" + (name_prefix or "data") + ".op must be string or null"
                        )
                if "origin" in data_keys:
                    data_keys.remove("origin")
                    data__origin = data["origin"]
                    if not isinstance(data__origin, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".origin must be string or null"
                        )
                if "parent_span_id" in data_keys:
                    data_keys.remove("parent_span_id")
                    data__parentspanid = data["parent_span_id"]
                    data__parentspanid_any_of_count151 = 0
                    if not data__parentspanid_any_of_count151:
                        try:
                            validate___definitions_spanid(
                                data__parentspanid,
                                custom_formats,
                                (name_prefix or "data") + ".parent_span_id",
                            )
                            data__parentspanid_any_of_count151 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__parentspanid_any_of_count151:
                        try:
                            if not isinstance(data__parentspanid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".parent_span_id must be null"
                                )
                            data__parentspanid_any_of_count151 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__parentspanid_any_of_count151:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".parent_span_id cannot be validated by any definition"
                        )
                if "sampled" in data_keys:
                    data_keys.remove("sampled")
                    data__sampled = data["sampled"]
                    if not isinstance(data__sampled, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sampled must be boolean or null"
                        )
                if "span_id" in data_keys:
                    data_keys.remove("span_id")
                    data__spanid = data["span_id"]
                    data__spanid_any_of_count152 = 0
                    if not data__spanid_any_of_count152:
                        try:
                            validate___definitions_spanid(
                                data__spanid,
                                custom_formats,
                                (name_prefix or "data") + ".span_id",
                            )
                            data__spanid_any_of_count152 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__spanid_any_of_count152:
                        try:
                            if not isinstance(data__spanid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".span_id must be null"
                                )
                            data__spanid_any_of_count152 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__spanid_any_of_count152:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".span_id cannot be validated by any definition"
                        )
                if "status" in data_keys:
                    data_keys.remove("status")
                    data__status = data["status"]
                    data__status_any_of_count153 = 0
                    if not data__status_any_of_count153:
                        try:
                            validate___definitions_spanstatus(
                                data__status,
                                custom_formats,
                                (name_prefix or "data") + ".status",
                            )
                            data__status_any_of_count153 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__status_any_of_count153:
                        try:
                            if not isinstance(data__status, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".status must be null"
                                )
                            data__status_any_of_count153 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__status_any_of_count153:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".status cannot be validated by any definition"
                        )
                if "trace_id" in data_keys:
                    data_keys.remove("trace_id")
                    data__traceid = data["trace_id"]
                    data__traceid_any_of_count154 = 0
                    if not data__traceid_any_of_count154:
                        try:
                            validate___definitions_traceid(
                                data__traceid,
                                custom_formats,
                                (name_prefix or "data") + ".trace_id",
                            )
                            data__traceid_any_of_count154 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__traceid_any_of_count154:
                        try:
                            if not isinstance(data__traceid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".trace_id must be null"
                                )
                            data__traceid_any_of_count154 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__traceid_any_of_count154:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".trace_id cannot be validated by any definition"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count149 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count149:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_traceid(data, custom_formats={}, name_prefix=None):
    data_any_of_count155 = 0
    if not data_any_of_count155:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count155 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count155:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_spanstatus(data, custom_formats={}, name_prefix=None):
    if not isinstance(data, (str)):
        raise JsonSchemaValueException("" + (name_prefix or "data") + " must be string")
    if data not in [
        "ok",
        "cancelled",
        "unknown",
        "invalid_argument",
        "deadline_exceeded",
        "not_found",
        "already_exists",
        "permission_denied",
        "resource_exhausted",
        "failed_precondition",
        "aborted",
        "out_of_range",
        "unimplemented",
        "internal_error",
        "unavailable",
        "data_loss",
        "unauthenticated",
    ]:
        raise JsonSchemaValueException(
            ""
            + (name_prefix or "data")
            + " must be one of ['ok', 'cancelled', 'unknown', 'invalid_argument', 'deadline_exceeded', 'not_found', 'already_exists', 'permission_denied', 'resource_exhausted', 'failed_precondition', 'aborted', 'out_of_range', 'unimplemented', 'internal_error', 'unavailable', 'data_loss', 'unauthenticated']"
        )
    return data


def validate___definitions_spanid(data, custom_formats={}, name_prefix=None):
    data_any_of_count156 = 0
    if not data_any_of_count156:
        try:
            if not isinstance(data, (str)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be string"
                )
            data_any_of_count156 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count156:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_spandata(data, custom_formats={}, name_prefix=None):
    data_any_of_count157 = 0
    if not data_any_of_count157:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "ai.completion_tokens.used" in data_keys:
                    data_keys.remove("ai.completion_tokens.used")
                    data__aicompletiontokensused = data["ai.completion_tokens.used"]
                if "ai.input_messages" in data_keys:
                    data_keys.remove("ai.input_messages")
                    data__aiinputmessages = data["ai.input_messages"]
                if "ai.model_id" in data_keys:
                    data_keys.remove("ai.model_id")
                    data__aimodelid = data["ai.model_id"]
                if "ai.pipeline.name" in data_keys:
                    data_keys.remove("ai.pipeline.name")
                    data__aipipelinename = data["ai.pipeline.name"]
                if "ai.prompt_tokens.used" in data_keys:
                    data_keys.remove("ai.prompt_tokens.used")
                    data__aiprompttokensused = data["ai.prompt_tokens.used"]
                if "ai.responses" in data_keys:
                    data_keys.remove("ai.responses")
                    data__airesponses = data["ai.responses"]
                if "ai.total_tokens.used" in data_keys:
                    data_keys.remove("ai.total_tokens.used")
                    data__aitotaltokensused = data["ai.total_tokens.used"]
                if "app_start_type" in data_keys:
                    data_keys.remove("app_start_type")
                    data__appstarttype = data["app_start_type"]
                if "browser.name" in data_keys:
                    data_keys.remove("browser.name")
                    data__browsername = data["browser.name"]
                    if not isinstance(data__browsername, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".browser.name must be string or null"
                        )
                if "cache.hit" in data_keys:
                    data_keys.remove("cache.hit")
                    data__cachehit = data["cache.hit"]
                if "cache.item_size" in data_keys:
                    data_keys.remove("cache.item_size")
                    data__cacheitemsize = data["cache.item_size"]
                if "cache.key" in data_keys:
                    data_keys.remove("cache.key")
                    data__cachekey = data["cache.key"]
                if "client.address" in data_keys:
                    data_keys.remove("client.address")
                    data__clientaddress = data["client.address"]
                    if not isinstance(data__clientaddress, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".client.address must be string or null"
                        )
                if "code.filepath" in data_keys:
                    data_keys.remove("code.filepath")
                    data__codefilepath = data["code.filepath"]
                if "code.function" in data_keys:
                    data_keys.remove("code.function")
                    data__codefunction = data["code.function"]
                if "code.lineno" in data_keys:
                    data_keys.remove("code.lineno")
                    data__codelineno = data["code.lineno"]
                if "code.namespace" in data_keys:
                    data_keys.remove("code.namespace")
                    data__codenamespace = data["code.namespace"]
                if "db.operation" in data_keys:
                    data_keys.remove("db.operation")
                    data__dboperation = data["db.operation"]
                if "db.system" in data_keys:
                    data_keys.remove("db.system")
                    data__dbsystem = data["db.system"]
                if "frames.delay" in data_keys:
                    data_keys.remove("frames.delay")
                    data__framesdelay = data["frames.delay"]
                if "http.decoded_response_content_length" in data_keys:
                    data_keys.remove("http.decoded_response_content_length")
                    data__httpdecodedresponsecontentlength = data[
                        "http.decoded_response_content_length"
                    ]
                if "http.request_method" in data_keys:
                    data_keys.remove("http.request_method")
                    data__httprequestmethod = data["http.request_method"]
                if "http.response.status_code" in data_keys:
                    data_keys.remove("http.response.status_code")
                    data__httpresponsestatuscode = data["http.response.status_code"]
                if "http.response_content_length" in data_keys:
                    data_keys.remove("http.response_content_length")
                    data__httpresponsecontentlength = data[
                        "http.response_content_length"
                    ]
                if "http.response_transfer_size" in data_keys:
                    data_keys.remove("http.response_transfer_size")
                    data__httpresponsetransfersize = data["http.response_transfer_size"]
                if "messaging.destination.name" in data_keys:
                    data_keys.remove("messaging.destination.name")
                    data__messagingdestinationname = data["messaging.destination.name"]
                    if not isinstance(data__messagingdestinationname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".messaging.destination.name must be string or null"
                        )
                if "messaging.message.body.size" in data_keys:
                    data_keys.remove("messaging.message.body.size")
                    data__messagingmessagebodysize = data["messaging.message.body.size"]
                if "messaging.message.id" in data_keys:
                    data_keys.remove("messaging.message.id")
                    data__messagingmessageid = data["messaging.message.id"]
                    if not isinstance(data__messagingmessageid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".messaging.message.id must be string or null"
                        )
                if "messaging.message.receive.latency" in data_keys:
                    data_keys.remove("messaging.message.receive.latency")
                    data__messagingmessagereceivelatency = data[
                        "messaging.message.receive.latency"
                    ]
                if "messaging.message.retry.count" in data_keys:
                    data_keys.remove("messaging.message.retry.count")
                    data__messagingmessageretrycount = data[
                        "messaging.message.retry.count"
                    ]
                if "previousRoute" in data_keys:
                    data_keys.remove("previousRoute")
                    data__previousRoute = data["previousRoute"]
                    data__previousRoute_any_of_count158 = 0
                    if not data__previousRoute_any_of_count158:
                        try:
                            validate___definitions_route(
                                data__previousRoute,
                                custom_formats,
                                (name_prefix or "data") + ".previousRoute",
                            )
                            data__previousRoute_any_of_count158 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__previousRoute_any_of_count158:
                        try:
                            if not isinstance(data__previousRoute, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".previousRoute must be null"
                                )
                            data__previousRoute_any_of_count158 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__previousRoute_any_of_count158:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".previousRoute cannot be validated by any definition"
                        )
                if "resource.render_blocking_status" in data_keys:
                    data_keys.remove("resource.render_blocking_status")
                    data__resourcerenderblockingstatus = data[
                        "resource.render_blocking_status"
                    ]
                if "route" in data_keys:
                    data_keys.remove("route")
                    data__route = data["route"]
                    data__route_any_of_count159 = 0
                    if not data__route_any_of_count159:
                        try:
                            validate___definitions_route(
                                data__route,
                                custom_formats,
                                (name_prefix or "data") + ".route",
                            )
                            data__route_any_of_count159 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__route_any_of_count159:
                        try:
                            if not isinstance(data__route, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".route must be null"
                                )
                            data__route_any_of_count159 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__route_any_of_count159:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".route cannot be validated by any definition"
                        )
                if "sentry.environment" in data_keys:
                    data_keys.remove("sentry.environment")
                    data__sentryenvironment = data["sentry.environment"]
                    if not isinstance(data__sentryenvironment, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sentry.environment must be string or null"
                        )
                if "sentry.frames.frozen" in data_keys:
                    data_keys.remove("sentry.frames.frozen")
                    data__sentryframesfrozen = data["sentry.frames.frozen"]
                if "sentry.frames.slow" in data_keys:
                    data_keys.remove("sentry.frames.slow")
                    data__sentryframesslow = data["sentry.frames.slow"]
                if "sentry.frames.total" in data_keys:
                    data_keys.remove("sentry.frames.total")
                    data__sentryframestotal = data["sentry.frames.total"]
                if "sentry.release" in data_keys:
                    data_keys.remove("sentry.release")
                    data__sentryrelease = data["sentry.release"]
                    if not isinstance(data__sentryrelease, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sentry.release must be string or null"
                        )
                if "sentry.replay.id" in data_keys:
                    data_keys.remove("sentry.replay.id")
                    data__sentryreplayid = data["sentry.replay.id"]
                if "sentry.sdk.name" in data_keys:
                    data_keys.remove("sentry.sdk.name")
                    data__sentrysdkname = data["sentry.sdk.name"]
                    if not isinstance(data__sentrysdkname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sentry.sdk.name must be string or null"
                        )
                if "sentry.sdk.version" in data_keys:
                    data_keys.remove("sentry.sdk.version")
                    data__sentrysdkversion = data["sentry.sdk.version"]
                    if not isinstance(data__sentrysdkversion, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sentry.sdk.version must be string or null"
                        )
                if "sentry.segment.name" in data_keys:
                    data_keys.remove("sentry.segment.name")
                    data__sentrysegmentname = data["sentry.segment.name"]
                    if not isinstance(data__sentrysegmentname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".sentry.segment.name must be string or null"
                        )
                if "server.address" in data_keys:
                    data_keys.remove("server.address")
                    data__serveraddress = data["server.address"]
                if "thread.id" in data_keys:
                    data_keys.remove("thread.id")
                    data__threadid = data["thread.id"]
                    data__threadid_any_of_count160 = 0
                    if not data__threadid_any_of_count160:
                        try:
                            validate___definitions_threadid(
                                data__threadid,
                                custom_formats,
                                (name_prefix or "data") + ".thread.id",
                            )
                            data__threadid_any_of_count160 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threadid_any_of_count160:
                        try:
                            if not isinstance(data__threadid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".thread.id must be null"
                                )
                            data__threadid_any_of_count160 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__threadid_any_of_count160:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".thread.id cannot be validated by any definition"
                        )
                if "thread.name" in data_keys:
                    data_keys.remove("thread.name")
                    data__threadname = data["thread.name"]
                    if not isinstance(data__threadname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".thread.name must be string or null"
                        )
                if "ui.component_name" in data_keys:
                    data_keys.remove("ui.component_name")
                    data__uicomponentname = data["ui.component_name"]
                if "url.full" in data_keys:
                    data_keys.remove("url.full")
                    data__urlfull = data["url.full"]
                    if not isinstance(data__urlfull, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".url.full must be string or null"
                        )
                if "url.scheme" in data_keys:
                    data_keys.remove("url.scheme")
                    data__urlscheme = data["url.scheme"]
                if "user" in data_keys:
                    data_keys.remove("user")
                    data__user = data["user"]
                if "user_agent.original" in data_keys:
                    data_keys.remove("user_agent.original")
                    data__useragentoriginal = data["user_agent.original"]
                    if not isinstance(data__useragentoriginal, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".user_agent.original must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count157 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count157:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_route(data, custom_formats={}, name_prefix=None):
    data_any_of_count161 = 0
    if not data_any_of_count161:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "params" in data_keys:
                    data_keys.remove("params")
                    data__params = data["params"]
                    if not isinstance(data__params, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".params must be object or null"
                        )
                    data__params_is_dict = isinstance(data__params, dict)
                    if data__params_is_dict:
                        data__params_keys = set(data__params.keys())
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count161 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count161:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_gpucontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count162 = 0
    if not data_any_of_count162:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "api_type" in data_keys:
                    data_keys.remove("api_type")
                    data__apitype = data["api_type"]
                    if not isinstance(data__apitype, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".api_type must be string or null"
                        )
                if "graphics_shader_level" in data_keys:
                    data_keys.remove("graphics_shader_level")
                    data__graphicsshaderlevel = data["graphics_shader_level"]
                    if not isinstance(data__graphicsshaderlevel, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".graphics_shader_level must be string or null"
                        )
                if "id" in data_keys:
                    data_keys.remove("id")
                    data__id = data["id"]
                if "max_texture_size" in data_keys:
                    data_keys.remove("max_texture_size")
                    data__maxtexturesize = data["max_texture_size"]
                    if (
                        not isinstance(data__maxtexturesize, (int, NoneType))
                        and not (
                            isinstance(data__maxtexturesize, float)
                            and data__maxtexturesize.is_integer()
                        )
                        or isinstance(data__maxtexturesize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".max_texture_size must be integer or null"
                        )
                    if isinstance(data__maxtexturesize, (int, float, Decimal)):
                        if data__maxtexturesize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".max_texture_size must be bigger than or equal to 0.0"
                            )
                if "memory_size" in data_keys:
                    data_keys.remove("memory_size")
                    data__memorysize = data["memory_size"]
                    if (
                        not isinstance(data__memorysize, (int, NoneType))
                        and not (
                            isinstance(data__memorysize, float)
                            and data__memorysize.is_integer()
                        )
                        or isinstance(data__memorysize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".memory_size must be integer or null"
                        )
                    if isinstance(data__memorysize, (int, float, Decimal)):
                        if data__memorysize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".memory_size must be bigger than or equal to 0.0"
                            )
                if "multi_threaded_rendering" in data_keys:
                    data_keys.remove("multi_threaded_rendering")
                    data__multithreadedrendering = data["multi_threaded_rendering"]
                    if not isinstance(data__multithreadedrendering, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".multi_threaded_rendering must be boolean or null"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "npot_support" in data_keys:
                    data_keys.remove("npot_support")
                    data__npotsupport = data["npot_support"]
                    if not isinstance(data__npotsupport, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".npot_support must be string or null"
                        )
                if "supports_compute_shaders" in data_keys:
                    data_keys.remove("supports_compute_shaders")
                    data__supportscomputeshaders = data["supports_compute_shaders"]
                    if not isinstance(data__supportscomputeshaders, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_compute_shaders must be boolean or null"
                        )
                if "supports_draw_call_instancing" in data_keys:
                    data_keys.remove("supports_draw_call_instancing")
                    data__supportsdrawcallinstancing = data[
                        "supports_draw_call_instancing"
                    ]
                    if not isinstance(
                        data__supportsdrawcallinstancing, (bool, NoneType)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_draw_call_instancing must be boolean or null"
                        )
                if "supports_geometry_shaders" in data_keys:
                    data_keys.remove("supports_geometry_shaders")
                    data__supportsgeometryshaders = data["supports_geometry_shaders"]
                    if not isinstance(data__supportsgeometryshaders, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_geometry_shaders must be boolean or null"
                        )
                if "supports_ray_tracing" in data_keys:
                    data_keys.remove("supports_ray_tracing")
                    data__supportsraytracing = data["supports_ray_tracing"]
                    if not isinstance(data__supportsraytracing, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_ray_tracing must be boolean or null"
                        )
                if "vendor_id" in data_keys:
                    data_keys.remove("vendor_id")
                    data__vendorid = data["vendor_id"]
                    if not isinstance(data__vendorid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".vendor_id must be string or null"
                        )
                if "vendor_name" in data_keys:
                    data_keys.remove("vendor_name")
                    data__vendorname = data["vendor_name"]
                    if not isinstance(data__vendorname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".vendor_name must be string or null"
                        )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count162 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count162:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_browsercontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count163 = 0
    if not data_any_of_count163:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count163 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count163:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_appcontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count164 = 0
    if not data_any_of_count164:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "app_build" in data_keys:
                    data_keys.remove("app_build")
                    data__appbuild = data["app_build"]
                    if not isinstance(data__appbuild, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".app_build must be string or null"
                        )
                if "app_identifier" in data_keys:
                    data_keys.remove("app_identifier")
                    data__appidentifier = data["app_identifier"]
                    if not isinstance(data__appidentifier, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".app_identifier must be string or null"
                        )
                if "app_memory" in data_keys:
                    data_keys.remove("app_memory")
                    data__appmemory = data["app_memory"]
                    if (
                        not isinstance(data__appmemory, (int, NoneType))
                        and not (
                            isinstance(data__appmemory, float)
                            and data__appmemory.is_integer()
                        )
                        or isinstance(data__appmemory, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".app_memory must be integer or null"
                        )
                    if isinstance(data__appmemory, (int, float, Decimal)):
                        if data__appmemory < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".app_memory must be bigger than or equal to 0.0"
                            )
                if "app_name" in data_keys:
                    data_keys.remove("app_name")
                    data__appname = data["app_name"]
                    if not isinstance(data__appname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".app_name must be string or null"
                        )
                if "app_start_time" in data_keys:
                    data_keys.remove("app_start_time")
                    data__appstarttime = data["app_start_time"]
                    if not isinstance(data__appstarttime, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".app_start_time must be string or null"
                        )
                if "app_version" in data_keys:
                    data_keys.remove("app_version")
                    data__appversion = data["app_version"]
                    if not isinstance(data__appversion, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".app_version must be string or null"
                        )
                if "build_type" in data_keys:
                    data_keys.remove("build_type")
                    data__buildtype = data["build_type"]
                    if not isinstance(data__buildtype, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".build_type must be string or null"
                        )
                if "device_app_hash" in data_keys:
                    data_keys.remove("device_app_hash")
                    data__deviceapphash = data["device_app_hash"]
                    if not isinstance(data__deviceapphash, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".device_app_hash must be string or null"
                        )
                if "in_foreground" in data_keys:
                    data_keys.remove("in_foreground")
                    data__inforeground = data["in_foreground"]
                    if not isinstance(data__inforeground, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".in_foreground must be boolean or null"
                        )
                if "view_names" in data_keys:
                    data_keys.remove("view_names")
                    data__viewnames = data["view_names"]
                    if not isinstance(data__viewnames, (list, tuple, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".view_names must be array or null"
                        )
                    data__viewnames_is_list = isinstance(data__viewnames, (list, tuple))
                    if data__viewnames_is_list:
                        data__viewnames_len = len(data__viewnames)
                        for data__viewnames_x, data__viewnames_item in enumerate(
                            data__viewnames
                        ):
                            if not isinstance(data__viewnames_item, (str, NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".view_names[{data__viewnames_x}]".format(
                                        **locals()
                                    )
                                    + " must be string or null"
                                )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count164 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count164:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_runtimecontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count165 = 0
    if not data_any_of_count165:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "build" in data_keys:
                    data_keys.remove("build")
                    data__build = data["build"]
                    if not isinstance(data__build, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".build must be string or null"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "raw_description" in data_keys:
                    data_keys.remove("raw_description")
                    data__rawdescription = data["raw_description"]
                    if not isinstance(data__rawdescription, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".raw_description must be string or null"
                        )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count165 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count165:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_oscontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count166 = 0
    if not data_any_of_count166:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "build" in data_keys:
                    data_keys.remove("build")
                    data__build = data["build"]
                    if not isinstance(data__build, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".build must be string or null"
                        )
                if "distribution" in data_keys:
                    data_keys.remove("distribution")
                    data__distribution = data["distribution"]
                    data__distribution_any_of_count167 = 0
                    if not data__distribution_any_of_count167:
                        try:
                            validate___definitions_linuxdistribution(
                                data__distribution,
                                custom_formats,
                                (name_prefix or "data") + ".distribution",
                            )
                            data__distribution_any_of_count167 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__distribution_any_of_count167:
                        try:
                            if not isinstance(data__distribution, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".distribution must be null"
                                )
                            data__distribution_any_of_count167 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__distribution_any_of_count167:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".distribution cannot be validated by any definition"
                        )
                if "kernel_version" in data_keys:
                    data_keys.remove("kernel_version")
                    data__kernelversion = data["kernel_version"]
                    if not isinstance(data__kernelversion, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".kernel_version must be string or null"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "raw_description" in data_keys:
                    data_keys.remove("raw_description")
                    data__rawdescription = data["raw_description"]
                    if not isinstance(data__rawdescription, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".raw_description must be string or null"
                        )
                if "rooted" in data_keys:
                    data_keys.remove("rooted")
                    data__rooted = data["rooted"]
                    if not isinstance(data__rooted, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".rooted must be boolean or null"
                        )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count166 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count166:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_linuxdistribution(data, custom_formats={}, name_prefix=None):
    data_any_of_count168 = 0
    if not data_any_of_count168:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "pretty_name" in data_keys:
                    data_keys.remove("pretty_name")
                    data__prettyname = data["pretty_name"]
                    if not isinstance(data__prettyname, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".pretty_name must be string or null"
                        )
                if "version" in data_keys:
                    data_keys.remove("version")
                    data__version = data["version"]
                    if not isinstance(data__version, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".version must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count168 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count168:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_devicecontext(data, custom_formats={}, name_prefix=None):
    data_any_of_count169 = 0
    if not data_any_of_count169:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "arch" in data_keys:
                    data_keys.remove("arch")
                    data__arch = data["arch"]
                    if not isinstance(data__arch, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".arch must be string or null"
                        )
                if "battery_level" in data_keys:
                    data_keys.remove("battery_level")
                    data__batterylevel = data["battery_level"]
                    if not isinstance(
                        data__batterylevel, (int, float, Decimal, NoneType)
                    ) or isinstance(data__batterylevel, bool):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".battery_level must be number or null"
                        )
                if "battery_status" in data_keys:
                    data_keys.remove("battery_status")
                    data__batterystatus = data["battery_status"]
                    if not isinstance(data__batterystatus, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".battery_status must be string or null"
                        )
                if "boot_time" in data_keys:
                    data_keys.remove("boot_time")
                    data__boottime = data["boot_time"]
                    if not isinstance(data__boottime, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".boot_time must be string or null"
                        )
                if "brand" in data_keys:
                    data_keys.remove("brand")
                    data__brand = data["brand"]
                    if not isinstance(data__brand, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".brand must be string or null"
                        )
                if "charging" in data_keys:
                    data_keys.remove("charging")
                    data__charging = data["charging"]
                    if not isinstance(data__charging, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".charging must be boolean or null"
                        )
                if "cpu_description" in data_keys:
                    data_keys.remove("cpu_description")
                    data__cpudescription = data["cpu_description"]
                    if not isinstance(data__cpudescription, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".cpu_description must be string or null"
                        )
                if "device_type" in data_keys:
                    data_keys.remove("device_type")
                    data__devicetype = data["device_type"]
                    if not isinstance(data__devicetype, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".device_type must be string or null"
                        )
                if "device_unique_identifier" in data_keys:
                    data_keys.remove("device_unique_identifier")
                    data__deviceuniqueidentifier = data["device_unique_identifier"]
                    if not isinstance(data__deviceuniqueidentifier, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".device_unique_identifier must be string or null"
                        )
                if "external_free_storage" in data_keys:
                    data_keys.remove("external_free_storage")
                    data__externalfreestorage = data["external_free_storage"]
                    if (
                        not isinstance(data__externalfreestorage, (int, NoneType))
                        and not (
                            isinstance(data__externalfreestorage, float)
                            and data__externalfreestorage.is_integer()
                        )
                        or isinstance(data__externalfreestorage, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".external_free_storage must be integer or null"
                        )
                    if isinstance(data__externalfreestorage, (int, float, Decimal)):
                        if data__externalfreestorage < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".external_free_storage must be bigger than or equal to 0.0"
                            )
                if "external_storage_size" in data_keys:
                    data_keys.remove("external_storage_size")
                    data__externalstoragesize = data["external_storage_size"]
                    if (
                        not isinstance(data__externalstoragesize, (int, NoneType))
                        and not (
                            isinstance(data__externalstoragesize, float)
                            and data__externalstoragesize.is_integer()
                        )
                        or isinstance(data__externalstoragesize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".external_storage_size must be integer or null"
                        )
                    if isinstance(data__externalstoragesize, (int, float, Decimal)):
                        if data__externalstoragesize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".external_storage_size must be bigger than or equal to 0.0"
                            )
                if "family" in data_keys:
                    data_keys.remove("family")
                    data__family = data["family"]
                    if not isinstance(data__family, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".family must be string or null"
                        )
                if "free_memory" in data_keys:
                    data_keys.remove("free_memory")
                    data__freememory = data["free_memory"]
                    if (
                        not isinstance(data__freememory, (int, NoneType))
                        and not (
                            isinstance(data__freememory, float)
                            and data__freememory.is_integer()
                        )
                        or isinstance(data__freememory, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".free_memory must be integer or null"
                        )
                    if isinstance(data__freememory, (int, float, Decimal)):
                        if data__freememory < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".free_memory must be bigger than or equal to 0.0"
                            )
                if "free_storage" in data_keys:
                    data_keys.remove("free_storage")
                    data__freestorage = data["free_storage"]
                    if (
                        not isinstance(data__freestorage, (int, NoneType))
                        and not (
                            isinstance(data__freestorage, float)
                            and data__freestorage.is_integer()
                        )
                        or isinstance(data__freestorage, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".free_storage must be integer or null"
                        )
                    if isinstance(data__freestorage, (int, float, Decimal)):
                        if data__freestorage < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".free_storage must be bigger than or equal to 0.0"
                            )
                if "locale" in data_keys:
                    data_keys.remove("locale")
                    data__locale = data["locale"]
                    if not isinstance(data__locale, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".locale must be string or null"
                        )
                if "low_memory" in data_keys:
                    data_keys.remove("low_memory")
                    data__lowmemory = data["low_memory"]
                    if not isinstance(data__lowmemory, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".low_memory must be boolean or null"
                        )
                if "manufacturer" in data_keys:
                    data_keys.remove("manufacturer")
                    data__manufacturer = data["manufacturer"]
                    if not isinstance(data__manufacturer, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".manufacturer must be string or null"
                        )
                if "memory_size" in data_keys:
                    data_keys.remove("memory_size")
                    data__memorysize = data["memory_size"]
                    if (
                        not isinstance(data__memorysize, (int, NoneType))
                        and not (
                            isinstance(data__memorysize, float)
                            and data__memorysize.is_integer()
                        )
                        or isinstance(data__memorysize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".memory_size must be integer or null"
                        )
                    if isinstance(data__memorysize, (int, float, Decimal)):
                        if data__memorysize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".memory_size must be bigger than or equal to 0.0"
                            )
                if "model" in data_keys:
                    data_keys.remove("model")
                    data__model = data["model"]
                    if not isinstance(data__model, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".model must be string or null"
                        )
                if "model_id" in data_keys:
                    data_keys.remove("model_id")
                    data__modelid = data["model_id"]
                    if not isinstance(data__modelid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".model_id must be string or null"
                        )
                if "name" in data_keys:
                    data_keys.remove("name")
                    data__name = data["name"]
                    if not isinstance(data__name, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".name must be string or null"
                        )
                if "online" in data_keys:
                    data_keys.remove("online")
                    data__online = data["online"]
                    if not isinstance(data__online, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".online must be boolean or null"
                        )
                if "orientation" in data_keys:
                    data_keys.remove("orientation")
                    data__orientation = data["orientation"]
                    if not isinstance(data__orientation, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".orientation must be string or null"
                        )
                if "processor_count" in data_keys:
                    data_keys.remove("processor_count")
                    data__processorcount = data["processor_count"]
                    if (
                        not isinstance(data__processorcount, (int, NoneType))
                        and not (
                            isinstance(data__processorcount, float)
                            and data__processorcount.is_integer()
                        )
                        or isinstance(data__processorcount, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".processor_count must be integer or null"
                        )
                    if isinstance(data__processorcount, (int, float, Decimal)):
                        if data__processorcount < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".processor_count must be bigger than or equal to 0.0"
                            )
                if "processor_frequency" in data_keys:
                    data_keys.remove("processor_frequency")
                    data__processorfrequency = data["processor_frequency"]
                    if (
                        not isinstance(data__processorfrequency, (int, NoneType))
                        and not (
                            isinstance(data__processorfrequency, float)
                            and data__processorfrequency.is_integer()
                        )
                        or isinstance(data__processorfrequency, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".processor_frequency must be integer or null"
                        )
                    if isinstance(data__processorfrequency, (int, float, Decimal)):
                        if data__processorfrequency < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".processor_frequency must be bigger than or equal to 0.0"
                            )
                if "screen_density" in data_keys:
                    data_keys.remove("screen_density")
                    data__screendensity = data["screen_density"]
                    if not isinstance(
                        data__screendensity, (int, float, Decimal, NoneType)
                    ) or isinstance(data__screendensity, bool):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".screen_density must be number or null"
                        )
                if "screen_dpi" in data_keys:
                    data_keys.remove("screen_dpi")
                    data__screendpi = data["screen_dpi"]
                    if (
                        not isinstance(data__screendpi, (int, NoneType))
                        and not (
                            isinstance(data__screendpi, float)
                            and data__screendpi.is_integer()
                        )
                        or isinstance(data__screendpi, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".screen_dpi must be integer or null"
                        )
                    if isinstance(data__screendpi, (int, float, Decimal)):
                        if data__screendpi < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".screen_dpi must be bigger than or equal to 0.0"
                            )
                if "screen_height_pixels" in data_keys:
                    data_keys.remove("screen_height_pixels")
                    data__screenheightpixels = data["screen_height_pixels"]
                    if (
                        not isinstance(data__screenheightpixels, (int, NoneType))
                        and not (
                            isinstance(data__screenheightpixels, float)
                            and data__screenheightpixels.is_integer()
                        )
                        or isinstance(data__screenheightpixels, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".screen_height_pixels must be integer or null"
                        )
                    if isinstance(data__screenheightpixels, (int, float, Decimal)):
                        if data__screenheightpixels < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".screen_height_pixels must be bigger than or equal to 0.0"
                            )
                if "screen_resolution" in data_keys:
                    data_keys.remove("screen_resolution")
                    data__screenresolution = data["screen_resolution"]
                    if not isinstance(data__screenresolution, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".screen_resolution must be string or null"
                        )
                if "screen_width_pixels" in data_keys:
                    data_keys.remove("screen_width_pixels")
                    data__screenwidthpixels = data["screen_width_pixels"]
                    if (
                        not isinstance(data__screenwidthpixels, (int, NoneType))
                        and not (
                            isinstance(data__screenwidthpixels, float)
                            and data__screenwidthpixels.is_integer()
                        )
                        or isinstance(data__screenwidthpixels, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".screen_width_pixels must be integer or null"
                        )
                    if isinstance(data__screenwidthpixels, (int, float, Decimal)):
                        if data__screenwidthpixels < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".screen_width_pixels must be bigger than or equal to 0.0"
                            )
                if "simulator" in data_keys:
                    data_keys.remove("simulator")
                    data__simulator = data["simulator"]
                    if not isinstance(data__simulator, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".simulator must be boolean or null"
                        )
                if "storage_size" in data_keys:
                    data_keys.remove("storage_size")
                    data__storagesize = data["storage_size"]
                    if (
                        not isinstance(data__storagesize, (int, NoneType))
                        and not (
                            isinstance(data__storagesize, float)
                            and data__storagesize.is_integer()
                        )
                        or isinstance(data__storagesize, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".storage_size must be integer or null"
                        )
                    if isinstance(data__storagesize, (int, float, Decimal)):
                        if data__storagesize < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".storage_size must be bigger than or equal to 0.0"
                            )
                if "supports_accelerometer" in data_keys:
                    data_keys.remove("supports_accelerometer")
                    data__supportsaccelerometer = data["supports_accelerometer"]
                    if not isinstance(data__supportsaccelerometer, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_accelerometer must be boolean or null"
                        )
                if "supports_audio" in data_keys:
                    data_keys.remove("supports_audio")
                    data__supportsaudio = data["supports_audio"]
                    if not isinstance(data__supportsaudio, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_audio must be boolean or null"
                        )
                if "supports_gyroscope" in data_keys:
                    data_keys.remove("supports_gyroscope")
                    data__supportsgyroscope = data["supports_gyroscope"]
                    if not isinstance(data__supportsgyroscope, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_gyroscope must be boolean or null"
                        )
                if "supports_location_service" in data_keys:
                    data_keys.remove("supports_location_service")
                    data__supportslocationservice = data["supports_location_service"]
                    if not isinstance(data__supportslocationservice, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_location_service must be boolean or null"
                        )
                if "supports_vibration" in data_keys:
                    data_keys.remove("supports_vibration")
                    data__supportsvibration = data["supports_vibration"]
                    if not isinstance(data__supportsvibration, (bool, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".supports_vibration must be boolean or null"
                        )
                if "timezone" in data_keys:
                    data_keys.remove("timezone")
                    data__timezone = data["timezone"]
                    if not isinstance(data__timezone, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".timezone must be string or null"
                        )
                if "usable_memory" in data_keys:
                    data_keys.remove("usable_memory")
                    data__usablememory = data["usable_memory"]
                    if (
                        not isinstance(data__usablememory, (int, NoneType))
                        and not (
                            isinstance(data__usablememory, float)
                            and data__usablememory.is_integer()
                        )
                        or isinstance(data__usablememory, bool)
                    ):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".usable_memory must be integer or null"
                        )
                    if isinstance(data__usablememory, (int, float, Decimal)):
                        if data__usablememory < 0.0:
                            raise JsonSchemaValueException(
                                ""
                                + (name_prefix or "data")
                                + ".usable_memory must be bigger than or equal to 0.0"
                            )
                if "uuid" in data_keys:
                    data_keys.remove("uuid")
                    data__uuid = data["uuid"]
                    if not isinstance(data__uuid, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".uuid must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count169 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count169:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data


def validate___definitions_breadcrumb(data, custom_formats={}, name_prefix=None):
    data_any_of_count170 = 0
    if not data_any_of_count170:
        try:
            if not isinstance(data, (dict)):
                raise JsonSchemaValueException(
                    "" + (name_prefix or "data") + " must be object"
                )
            data_is_dict = isinstance(data, dict)
            if data_is_dict:
                data_keys = set(data.keys())
                if "category" in data_keys:
                    data_keys.remove("category")
                    data__category = data["category"]
                    if not isinstance(data__category, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".category must be string or null"
                        )
                if "data" in data_keys:
                    data_keys.remove("data")
                    data__data = data["data"]
                    if not isinstance(data__data, (dict, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".data must be object or null"
                        )
                    data__data_is_dict = isinstance(data__data, dict)
                    if data__data_is_dict:
                        data__data_keys = set(data__data.keys())
                if "event_id" in data_keys:
                    data_keys.remove("event_id")
                    data__eventid = data["event_id"]
                    data__eventid_any_of_count171 = 0
                    if not data__eventid_any_of_count171:
                        try:
                            validate___definitions_eventid(
                                data__eventid,
                                custom_formats,
                                (name_prefix or "data") + ".event_id",
                            )
                            data__eventid_any_of_count171 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__eventid_any_of_count171:
                        try:
                            if not isinstance(data__eventid, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".event_id must be null"
                                )
                            data__eventid_any_of_count171 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__eventid_any_of_count171:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".event_id cannot be validated by any definition"
                        )
                if "level" in data_keys:
                    data_keys.remove("level")
                    data__level = data["level"]
                    data__level_any_of_count172 = 0
                    if not data__level_any_of_count172:
                        try:
                            validate___definitions_level(
                                data__level,
                                custom_formats,
                                (name_prefix or "data") + ".level",
                            )
                            data__level_any_of_count172 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__level_any_of_count172:
                        try:
                            if not isinstance(data__level, (NoneType)):
                                raise JsonSchemaValueException(
                                    "" + (name_prefix or "data") + ".level must be null"
                                )
                            data__level_any_of_count172 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__level_any_of_count172:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".level cannot be validated by any definition"
                        )
                if "message" in data_keys:
                    data_keys.remove("message")
                    data__message = data["message"]
                    if not isinstance(data__message, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".message must be string or null"
                        )
                if "timestamp" in data_keys:
                    data_keys.remove("timestamp")
                    data__timestamp = data["timestamp"]
                    data__timestamp_any_of_count173 = 0
                    if not data__timestamp_any_of_count173:
                        try:
                            validate___definitions_timestamp(
                                data__timestamp,
                                custom_formats,
                                (name_prefix or "data") + ".timestamp",
                            )
                            data__timestamp_any_of_count173 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__timestamp_any_of_count173:
                        try:
                            if not isinstance(data__timestamp, (NoneType)):
                                raise JsonSchemaValueException(
                                    ""
                                    + (name_prefix or "data")
                                    + ".timestamp must be null"
                                )
                            data__timestamp_any_of_count173 += 1
                        except JsonSchemaValueException:
                            pass
                    if not data__timestamp_any_of_count173:
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".timestamp cannot be validated by any definition"
                        )
                if "type" in data_keys:
                    data_keys.remove("type")
                    data__type = data["type"]
                    if not isinstance(data__type, (str, NoneType)):
                        raise JsonSchemaValueException(
                            ""
                            + (name_prefix or "data")
                            + ".type must be string or null"
                        )
                if data_keys:
                    raise JsonSchemaValueException(
                        ""
                        + (name_prefix or "data")
                        + " must not contain "
                        + str(data_keys)
                        + " properties"
                    )
            data_any_of_count170 += 1
        except JsonSchemaValueException:
            pass
    if not data_any_of_count170:
        raise JsonSchemaValueException(
            "" + (name_prefix or "data") + " cannot be validated by any definition"
        )
    return data
