# Generated by Django 4.2.18 on 2025-02-03 13:17

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    replaces = [
        ('events', '0004_event_irrelevance_for_retention'),
        ('events', '0005_event_events_even_project_abe572_idx'),
        ('events', '0006_event_never_evict'),
        ('events', '0007_set_never_evict'),
        ('events', '0008_remove_event_events_even_project_abe572_idx_and_more'),
        ('events', '0009_event_events_even_issue_i_90497b_idx'),
        ('events', '0010_rename_ingest_order_event_digest_order_and_more'),
        ('events', '0011_remove_event_events_even_project_adcdee_idx_and_more'),
        ('events', '0012_event_ingested_at'),
        ('events', '0013_harmonize_foogested_at'),
        ('events', '0014_event_grouping'),
        ('events', '0015_set_event_grouping'),
    ]

    dependencies = [
        ("events", "0003_initial"),  # the previous migration
        ("issues", "0001_initial"),  # This defines the Grouping model, which the below FKs to

        # This is what Django auto-detected, but I think it's too restrictive:
        # ("issues", "0007_alter_turningpoint_options"),

        # Additionally, Django auto-detected the below, presumably because we add a (project, event_id) unique
        # constraint. However, we don't actually depend on this migration when adding that constraint, so we don't need
        # to depend on it here.
        # ("projects", "0002_b_squashed_initial"),
    ]

    operations = [
        migrations.RenameField(
            model_name="event",
            old_name="ingest_order",
            new_name="digest_order",
        ),
        migrations.RenameField(
            model_name="event",
            old_name="server_side_timestamp",
            new_name="digested_at",
        ),
        migrations.AlterUniqueTogether(
            name="event",
            unique_together={("project", "event_id"), ("issue", "digest_order")},
        ),
        migrations.AddField(
            model_name="event",
            name="grouping",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="issues.grouping",
            ),
        ),
        migrations.AddField(
            model_name="event",
            name="ingested_at",
            field=models.DateTimeField(default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="event",
            name="irrelevance_for_retention",
            field=models.PositiveIntegerField(default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="event",
            name="never_evict",
            field=models.BooleanField(default=False),
        ),
        migrations.AddIndex(
            model_name="event",
            index=models.Index(
                fields=[
                    "project",
                    "never_evict",
                    "digested_at",
                    "irrelevance_for_retention",
                ],
                name="events_even_project_ac6fc7_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="event",
            index=models.Index(
                fields=["issue", "digested_at"], name="events_even_issue_i_b18956_idx"
            ),
        ),
    ]
