# Generated by Django 4.2.21 on 2025-07-03 08:30

from django.db import migrations


def remove_events_with_null_fks(apps, schema_editor):
    # Up until now, we have various models w/ .issue=FK(null=True, on_delete=models.SET_NULL)
    # Although it is "not expected" in the interface, issue-deletion would have led to those
    # objects with a null issue. We're about to change that to .issue=FK(null=False, ...) which
    # would crash if we don't remove those objects first. Object-removal is "fine" though, because
    # as per the meaning of the SET_NULL, these objects were "dangling" anyway.

    Event = apps.get_model("events", "Event")

    Event.objects.filter(issue__isnull=True).delete()

    # overcomplete b/c .issue would imply this, done anyway in the name of "defensive programming"
    Event.objects.filter(grouping__isnull=True).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("events", "0019_event_storage_backend"),

        # "in principle" order shouldn't matter, because the various objects that are being deleted here are all "fully
        # contained" by the .issue; to be safe, however, we depend on the below, because of Grouping.objects.delete()
        # (which would set Event.grouping=NULL, which the present migration takes into account).
        ("issues", "0020_remove_objects_with_null_issue"),
    ]

    operations = [
        migrations.RunPython(remove_events_with_null_fks, reverse_code=migrations.RunPython.noop),
    ]
