**Documentation**: <https://recordedfuture-professionalservices.github.io/psengine/>

**Github**: <https://github.com/RecordedFuture-ProfessionalServices/psengine>

**PyPi**: <https://pypi.org/project/psengine/>

---

PSEngine is a simple, yet elegant, library for rapid development of integrations with Recorded Future.

PSEngine allows you to interact with the Recorded Future API extremely easily. There’s no need to manually build the URLs and query parameters, just use the modules dedicated to individual API endpoints.

PSEngine is a Python package solely built and maintained by the Cyber Security Engineering team powering a number of high profile integrations, such as: Elasticsearch, QRadar, Anomali, Jira, TheHive, etc.

## Installation

PSEngine is a Python package that can be installed using `pip`. To install PSengine, run the following command:

```bash
pip install psengine
```

PSEngine officially supports Python >= 3.9, < 3.14.


## Supported Features & Best Practices

PSEngine is ready for the demands of building robust and reliable integrations.

It can easily interact with the following Recorded Future datasets:

- Analyst Notes
- Collective Insights
- Classic & Playbook Alerts
- Detection Rules
- Fusion File management
- Identity Exposures management
- List management
- Malware Sandbox reports download
- On demand IOC enrichment
- Risklists
- Risk History
- STIX conversion


And facilitate the development with features like:

- Built-in logging
- Easy configuration management
- Markdown creation from certain data types
- Proxy support

