##################################### TERMS OF USE ###########################################
# The following code is provided for demonstration purpose only, and should not be used      #
# without independent verification. Recorded Future makes no representations or warranties,  #
# express, implied, statutory, or otherwise, regarding any aspect of this code or of the     #
# information it may retrieve, and provides it both strictly “as-is” and without assuming    #
# responsibility for any information it may retrieve. Recorded Future shall not be liable    #
# for, and you assume all risk of using, the foregoing. By using this code, Customer         #
# represents that it is solely responsible for having all necessary licenses, permissions,   #
# rights, and/or consents to connect to third party APIs, and that it is solely responsible  #
# for having all necessary licenses, permissions, rights, and/or consents to any data        #
# accessed from any third party API.                                                         #
##############################################################################################

from typing import Optional

from pydantic import Field

from ..common_models import RFBaseModel


class DumpedItem(RFBaseModel):
    md5: Optional[str] = None
    name: Optional[str] = None
    path: Optional[str] = None
    sha1: Optional[str] = None
    sha256: Optional[str] = None
    sha512: Optional[str] = None
    size: Optional[int] = None


class Credential(RFBaseModel):
    host: Optional[str] = None
    password: Optional[str] = None
    port: Optional[int] = None
    username: Optional[str] = None


class KeyItem(RFBaseModel):
    key: Optional[str] = None
    kind: Optional[str] = None
    value: Optional[str] = None


class DropperUrl(RFBaseModel):
    type: Optional[str] = None
    url: Optional[str] = None


class Dropper(RFBaseModel):
    deobfuscated: Optional[str] = None
    family: Optional[str] = None
    language: Optional[str] = None
    source: Optional[str] = None
    urls: Optional[list[DropperUrl]] = []


class RansomNote(RFBaseModel):
    contact: Optional[list[str]] = []
    emails: Optional[list[str]] = []
    family: Optional[str] = None
    note: Optional[str] = None
    target: Optional[str] = None
    urls: Optional[list[str]] = []
    wallets: Optional[list[str]] = []


class ExtractedConfig(RFBaseModel):
    botnet: Optional[str] = None
    c2: Optional[list[str]] = []
    campaign: Optional[str] = None
    credentials: Optional[list[Credential]] = []
    decoy: Optional[list[str]] = []
    dns: Optional[list[str]] = []
    extracted_pe: Optional[str] = None
    family: Optional[str] = None
    keys: Optional[list[KeyItem]] = []
    listen_addr: Optional[str] = None
    listen_for: Optional[list[str]] = []
    listen_port: Optional[int] = None
    mutex: Optional[list[str]] = []
    rule: Optional[str] = None
    tags: Optional[list[str]] = []
    version: Optional[str] = None
    webinject: Optional[list[str]] = []


class ExtractedItem(RFBaseModel):
    config: ExtractedConfig = Field(default_factory=ExtractedConfig)
    credentials: Credential = Field(default_factory=Credential)
    dropper: Dropper = Field(default_factory=Dropper)
    dumped_file: Optional[str] = None
    path: Optional[str] = None
    ransom_note: RansomNote = Field(default_factory=RansomNote)
    resource: Optional[str] = None


class DnsRecord(RFBaseModel):
    flow_id: Optional[int] = None
    request_domain: Optional[list[str]] = []
    request_domain_fld: Optional[list[str]] = []
    request_domain_tld: Optional[list[str]] = []
    request_type: Optional[list[str]] = []
    response_domain: Optional[list[str]] = []
    response_domain_fld: Optional[list[str]] = []
    response_domain_tld: Optional[list[str]] = []
    response_type: Optional[list[str]] = []
    response_value: Optional[list[str]] = []


class Flow(RFBaseModel):
    dst_ip: Optional[str] = None
    dst_port: Optional[int] = None
    id: Optional[int] = None
    layer_7: Optional[list[str]] = []
    procid: Optional[int] = None
    proto: Optional[str] = None


class HttpRequest(RFBaseModel):
    headers: Optional[list[str]] = []
    method: Optional[str] = None
    request: Optional[str] = None
    url: Optional[str] = None


class HttpResponse(RFBaseModel):
    headers: Optional[list[str]] = []
    response: Optional[str] = None
    status: Optional[str] = None


class HttpSequenceItem(RFBaseModel):
    index: Optional[int] = None
    request: HttpRequest = Field(default_factory=HttpRequest)
    response: HttpResponse = Field(default_factory=HttpResponse)


class HttpEntry(RFBaseModel):
    flow: Optional[int] = None
    sequence: Optional[list[HttpSequenceItem]] = []


class IpInfo(RFBaseModel):
    asn: Optional[str] = None
    cc: Optional[str] = None
    ip: Optional[str] = None


class NetworkInfo(RFBaseModel):
    dns: Optional[list[DnsRecord]] = []
    dns_count: Optional[int] = None
    flows: Optional[list[Flow]] = []
    flows_count: Optional[int] = None
    http: Optional[list[HttpEntry]] = []
    ips: Optional[list[IpInfo]] = []
    ips_count: Optional[int] = None


class ProcessInfo(RFBaseModel):
    cmd: Optional[str] = None
    image: Optional[str] = None
    pid: Optional[int] = None
    ppid: Optional[int] = None
    procid: Optional[int] = None
    procid_parent: Optional[int] = None


class RegistryEntry(RFBaseModel):
    key: Optional[str] = None


class RegistryInfo(RFBaseModel):
    create: Optional[list[RegistryEntry]] = []
    read: Optional[list[RegistryEntry]] = []
    write: Optional[list[RegistryEntry]] = []


class SignatureIndicator(RFBaseModel):
    description: Optional[str] = None
    ioc: Optional[str] = None
    procid: Optional[int] = None


class Signature(RFBaseModel):
    desc: Optional[str] = None
    indicators: Optional[list[SignatureIndicator]] = []
    name: Optional[str] = None
    label: Optional[str] = None
    score: Optional[int] = None
    tags: Optional[list[str]] = []
    ttp: Optional[list[str]] = []


class PEHeader(RFBaseModel):
    dll_characteristics: Optional[list[str]] = []
    file_characteristics: Optional[list[str]] = []


class PEImport(RFBaseModel):
    dll_name: Optional[str] = None
    imports: Optional[list[str]] = []


class PESection(RFBaseModel):
    characteristics: Optional[list[str]] = []
    name: Optional[str] = None
    raw_data_offset: Optional[int] = None
    raw_data_size: Optional[int] = None
    virtual_size: Optional[int] = None


class PESignature(RFBaseModel):
    issuer: Optional[str] = None
    not_after: Optional[str] = None
    not_before: Optional[str] = None
    serial: Optional[str] = None
    subject: Optional[str] = None


class PEInfo(RFBaseModel):
    exports: Optional[list[str]] = []
    header: PEHeader = Field(default_factory=PEHeader)
    imphash: Optional[str] = None
    imports: Optional[list[PEImport]] = []
    sections: Optional[list[PESection]] = []
    signatures: Optional[list[PESignature]] = []
    timestamp: Optional[int] = None


class Industry(RFBaseModel):
    industry_id: Optional[str] = None
    industry_name: Optional[str] = None


class Metadata(RFBaseModel):
    industries: Optional[list[Industry]] = []
    sectors: Optional[list[Industry]] = []
    source: Optional[str] = None


class SampleInfo(RFBaseModel):
    completed: Optional[str] = None
    created: Optional[str] = None
    id: Optional[str] = None
    score: Optional[int] = None
    tags: Optional[list[str]] = []


class StaticInfo(RFBaseModel):
    exts: Optional[str] = None
    sha1: Optional[str] = None
    md5: Optional[str] = None
    sha256: Optional[str] = None
    sha512: Optional[str] = None
    size: Optional[int] = None
    ssdeep: Optional[str] = None
    tags: Optional[list[str]] = []
    target: Optional[str] = None


class DynamicInfo(RFBaseModel):
    dumped: Optional[list[DumpedItem]] = []
    dumped_count: Optional[int] = None
    extracted: Optional[list[ExtractedItem]] = []
    network: NetworkInfo = Field(default_factory=NetworkInfo)
    processes: Optional[list[ProcessInfo]] = []
    registry: RegistryInfo = Field(default_factory=RegistryInfo)
    registry_count: Optional[int] = None
    signatures: Optional[list[Signature]] = []
    signatures_count: Optional[int] = None
