##################################### TERMS OF USE ###########################################
# The following code is provided for demonstration purpose only, and should not be used      #
# without independent verification. Recorded Future makes no representations or warranties,  #
# express, implied, statutory, or otherwise, regarding any aspect of this code or of the     #
# information it may retrieve, and provides it both strictly “as-is” and without assuming    #
# responsibility for any information it may retrieve. Recorded Future shall not be liable    #
# for, and you assume all risk of using, the foregoing. By using this code, Customer         #
# represents that it is solely responsible for having all necessary licenses, permissions,   #
# rights, and/or consents to connect to third party APIs, and that it is solely responsible  #
# for having all necessary licenses, permissions, rights, and/or consents to any data        #
# accessed from any third party API.                                                         #
##############################################################################################

from typing import TYPE_CHECKING

from markdown_strings import bold, header

from ...markdown import MarkdownMaker, divider
from ...markdown.markdown import html_collapsible

if TYPE_CHECKING:
    from ...playbook_alerts.playbook_alerts import PBA_MalwareReport


def _add_hashes(pba: 'PBA_MalwareReport', md_maker: MarkdownMaker, html_tags: bool):
    matched_hashes = []

    detected_malwares = ', '.join(
        [f'{m.name.upper()} ({m.count})' for m in pba.panel_evidence_summary.detected_malwares]
    )
    if detected_malwares:
        matched_hashes.append(bold('Detected Malwares') + f' {detected_malwares}  ')

    sorted_hashes = sorted(
        pba.panel_evidence_summary.matched_hashes, key=lambda h: h.risk_score, reverse=True
    )

    for _, _hash in enumerate(sorted_hashes):
        matched_hashes.append(divider())
        hash_header = f'{header((f"{_hash.sha256} ({_hash.risk_score})"), 5)}'
        matched_hashes.append(hash_header)

        sandbox_reports = []
        for report in _hash.report_overviews:
            report_header = f'{header(report.report_id.split("-", 1)[1], 6)}  '
            score = f'{bold("Sandbox Score:")} {report.sandbox_score}  '
            tags = f'{bold("Tags:")} {", ".join(report.tags).upper()}  '
            sandbox_reports.extend([report_header, score, tags])

        if html_tags:
            html = html_collapsible('Sandbox Reports', '\n\n' + '\n'.join(sandbox_reports) + '\n')
            matched_hashes.append(html)
        else:
            matched_hashes.extend(sandbox_reports)

    md_maker.add_section(f'Matched Hashes ({len(sorted_hashes)})', matched_hashes)


def _malware_report_markdown(
    pba: 'PBA_MalwareReport',
    md_maker: MarkdownMaker,
    html_tags: bool,
    *args,  # noqa: ARG001
) -> str:
    _add_hashes(pba, md_maker, html_tags)
    return md_maker.format_output()
