##################################### TERMS OF USE ###########################################
# The following code is provided for demonstration purpose only, and should not be used      #
# without independent verification. Recorded Future makes no representations or warranties,  #
# express, implied, statutory, or otherwise, regarding any aspect of this code or of the     #
# information it may retrieve, and provides it both strictly “as-is” and without assuming    #
# responsibility for any information it may retrieve. Recorded Future shall not be liable    #
# for, and you assume all risk of using, the foregoing. By using this code, Customer         #
# represents that it is solely responsible for having all necessary licenses, permissions,   #
# rights, and/or consents to connect to third party APIs, and that it is solely responsible  #
# for having all necessary licenses, permissions, rights, and/or consents to any data        #
# accessed from any third party API.                                                         #
##############################################################################################

from typing import Optional

from pydantic import Field

from ...common_models import RFBaseModel
from ..models.panel_status import PanelStatus


class MalwareReportPanelStatus(PanelStatus):
    actions_taken: Optional[list[str]] = Field(default=None, exclude=True)


class ReportOverview(RFBaseModel):
    report_id: str
    sandbox_score: int
    tags: list[str]


class MatchedHash(RFBaseModel):
    sha256: str
    is_enterprise_submission: bool
    risk_score: int
    report_overviews: list[ReportOverview]


class DetectedMalware(RFBaseModel):
    name: str
    count: int


class SandboxScore(RFBaseModel):
    score: int
    count: int


class MalwareReportPanelEvidence(RFBaseModel):
    notification_title: Optional[str] = None
    report_limit_reached: Optional[bool] = None
    number_of_reports: Optional[int] = None
    matched_hashes: Optional[list[MatchedHash]] = []
    detected_malwares: Optional[list[DetectedMalware]] = []
    sandbox_scores: Optional[list[SandboxScore]] = []
