# SPDX-FileCopyrightText: 2025 cswimr <copyright@csw.im>
# SPDX-License-Identifier: MPL-2.0

"""Tidegear version information."""

# This file is automatically generated on build, do not edit!
# Do not commit this file to source control!

from yarl import URL

from tidegear.metadata import Repository, SemVer, TidegearMeta

meta: TidegearMeta = TidegearMeta(
    version=SemVer._from_tuple((1, 18, 1)),  # noqa: SLF001
    repository=Repository(
        owner="cswimr",
        name="tidegear",
        url=URL("https://c.csw.im/cswimr/tidegear"),
    ),
)
"""Tidegear Metadata object. This is automatically generated on build, so the version information will change depending on your Tidegear version."""

version: SemVer = meta.version
"""A SemVer object storing Tidegear's version."""
__version__: str = str(meta.version)
"""A string storing Tidegear's version."""
