
# SageWorks Presentations
The SageWorks framework makes AWS® both easier to use and more powerful. SageWorks handles all the details around updating and managing a complex set of AWS Services. With a simple-to-use Python API and a beautiful set of web interfaces, SageWorks makes creating AWS ML pipelines a snap. It also dramatically improves both the usability and visibility across the entire spectrum of services: Glue Job, Athena, Feature Store, Models, and Endpoints, SageWorks makes it easy to build production ready, AWS powered, machine learning pipelines.

<img align="right" width="480" alt="sageworks_new_light" src="https://github.com/SuperCowPowers/sageworks/assets/4806709/ed2ed1bd-e2d8-49a1-b350-b2e19e2b7832">

Even though SageWorks makes AWS easier, it's taking something very complex (200+ AWS Services) and making it less complex. SageWorks has a depth and breadth of functionality so we've provided higher level conceptual documentation as well as lower level coee/API documentation.

### SageWorks Presentations
- [SageWorks Overview](https://docs.google.com/presentation/d/1JCUzCtjQLGoQ7HJA_jhEHy3Q2o_j-ibkCCN864CvcVE/edit?usp=sharing)
- [Private SaaS Architecture](https://docs.google.com/presentation/d/1f_1gmE4-UAeUDDsoNdzK_d_MxALFXIkxORZwbJBjPq4/edit?usp=drive_link)
- [Python API](https://docs.google.com/presentation/d/1dvk7JoNcssEVEh7eWI-Qrh7lJbVOMM2qvrn60SrAFI8/edit?usp=drive_link)
- [Plugins Overview](https://docs.google.com/presentation/d/1RjpMmJW1i9auPztn2xXYmYKXsZjsnG7vVaCQQ4FLIMM/edit?usp=drive_link)
- [Plugins: Getting Started](https://docs.google.com/presentation/d/1S_-XapmyTsXIkO6od9AVkTbEU2nqS-mEZwFrtUucUME/edit?usp=drive_link)
- [Plugins: Pages](https://docs.google.com/presentation/d/1Yp4ka8DGPdRs8WfsAAUTnc0SHzkkcdJY2TABKxD_CPo/edit?usp=drive_link)
- [Plugins: Advanced](https://docs.google.com/presentation/d/1sByTnZa24lY6d4INRMm7OHmQndIZmLbTxOyTeAJol20/edit?usp=drive_link)
- [Exploratory Data Analysis](https://docs.google.com/presentation/d/1YBOFBMsZM7NdOyakkTEOzT3X8h5iQCACpx3cF897HEU/edit?usp=drive_link)
- [Architected ML Framework](https://docs.google.com/presentation/d/1ZiSy4ulEx5gfNQS76yRv8vgkehJ9gXRJ1PulutLKzis/edit?usp=drive_link)
- [AWS Access Management](https://docs.google.com/presentation/d/1_KwbaBsyBoiWW_8SEallHg8RMsi9FdK10dr2wwzo3CA/edit?usp=drive_link)
- [Sageworks Config](https://docs.google.com/presentation/d/1u9UU2-0ZhJ2WpDI7FxyJj6lHAdhpm3_hyMe1KsdZI6A/edit?usp=drive_link)
- [SageWorks REPL](https://docs.google.com/presentation/d/1H9OY94kLwB6dgXjWoKBf3fmE7b6fZMm5-Iex8LDr4xk/edit?usp=drive_link)

### SageWorks Python API Docs
<img align="right" width="300" alt="sageworks_api" style="padding-left: 10px;"  src="https://github.com/SuperCowPowers/sageworks/assets/4806709/bf0e8591-75d4-44c1-be05-4bfdee4b7186">

The SageWorks API documentation [SageWorks API](https://supercowpowers.github.io/sageworks/) covers our in-depth Python API and contains code examples. The code examples are provided in the Github repo `examples/` directory. For a full code listing of any example please visit our [SageWorks Examples](https://github.com/SuperCowPowers/sageworks/blob/main/examples)

### Questions?
The SuperCowPowers team is happy to anser any questions you may have about AWS and SageWorks. Please contact us at [sageworks@supercowpowers.com](mailto:sageworks@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

<img align="right" src="../docs/images/scp.png" width="180">

® Amazon Web Services, AWS, the Powered by AWS logo, are trademarks of Amazon.com, Inc. or its affiliates
