"""
FBA Finance Library - Core Module
Multi-source financial data aggregator with anti-rate-limiting
"""

__version__ = "0.1.4"
__author__ = "Fausto Bandini"

from .client import FinanceClient
from .models import Quote, HistoricalData, QuoteType
from .config import Config

# yfinance compatibility layer - allows: import fba_finance as yf
from .yfinance_compat import Ticker, download

# Screener module - get top tickers by market/sector
from .screener import (
    get_top_tickers,
    get_sector_tickers,
    get_market_tickers,
    get_available_sectors,
    get_ticker_count_by_market,
    get_ticker_count_by_sector,
)

# Market hours module - NEW in v0.1.4
from .market_hours import (
    MarketHours,
    is_market_open,
    get_market_state,
    next_market_open,
    next_market_close,
    get_market_hours,
)

__all__ = [
    # Core API
    "FinanceClient", 
    "Quote", 
    "HistoricalData", 
    "QuoteType", 
    "Config",
    # yfinance compatibility
    "Ticker",
    "download",
    # Screener
    "get_top_tickers",
    "get_sector_tickers",
    "get_market_tickers",
    "get_available_sectors",
    "get_ticker_count_by_market",
    "get_ticker_count_by_sector",
    # Market Hours (NEW in v0.1.4)
    "MarketHours",
    "is_market_open",
    "get_market_state",
    "next_market_open",
    "next_market_close",
    "get_market_hours",
]
