from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="fba_finance",
    version="0.1.4",
    author="Fausto Bandini",
    description="Multi-source financial data library with anti-rate-limiting strategies",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/faux62/fba_finance",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Intended Audience :: Financial and Insurance Industry",
        "Topic :: Office/Business :: Financial :: Investment",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.8",
    install_requires=[
        "requests>=2.31.0",
        "pandas>=2.0.0",
        "numpy>=1.24.0",
        "yfinance>=0.2.32",
        "yahooquery>=2.3.0",
        "beautifulsoup4>=4.12.0",
        "lxml>=4.9.0",
        "ratelimit>=2.2.1",
        "diskcache>=5.6.3",
        "aiohttp>=3.9.0",
        "python-dotenv>=1.0.0",
        "fake-useragent>=1.4.0",
    ],
    extras_require={
        "full": [
            "alpha-vantage>=2.3.1",
            "twelvedata>=1.2.14",
            "selenium>=4.15.0",
            "playwright>=1.40.0",
            "redis>=5.0.0",
            "websockets>=12.0",
        ],
    },
)
