import argparse
from pathlib import Path


def cyrillic_to_latin(text):
    # Mapping Cyrillic characters to Latin equivalents
    translit_map = {
        "А": "A",
        "Б": "B",
        "В": "V",
        "Г": "G",
        "Д": "D",
        "Е": "E",
        "Ё": "Yo",
        "Ж": "Zh",
        "З": "Z",
        "И": "I",
        "Й": "Y",
        "К": "K",
        "Л": "L",
        "М": "M",
        "Н": "N",
        "О": "O",
        "П": "P",
        "Р": "R",
        "С": "S",
        "Т": "T",
        "У": "U",
        "Ф": "F",
        "Х": "Kh",
        "Ц": "Ts",
        "Ч": "Ch",
        "Ш": "Sh",
        "Щ": "Shch",
        "Ъ": "",
        "Ы": "Y",
        "Ь": "",
        "Э": "E",
        "Ю": "Yu",
        "Я": "Ya",
        "а": "a",
        "б": "b",
        "в": "v",
        "г": "g",
        "д": "d",
        "е": "e",
        "ё": "yo",
        "ж": "zh",
        "з": "z",
        "и": "i",
        "й": "y",
        "к": "k",
        "л": "l",
        "м": "m",
        "н": "n",
        "о": "o",
        "п": "p",
        "р": "r",
        "с": "s",
        "т": "t",
        "у": "u",
        "ф": "f",
        "х": "kh",
        "ц": "ts",
        "ч": "ch",
        "ш": "sh",
        "щ": "shch",
        "ъ": "",
        "ы": "y",
        "ь": "",
        "э": "e",
        "ю": "yu",
        "я": "ya",
    }

    # Replace each Cyrillic character in the input text
    return "".join(translit_map.get(char, char) for char in text)


def main():
    parser = argparse.ArgumentParser(
        prog="a7p-renamer",
    )

    parser.add_argument("path", type=Path)
    file_path: Path = parser.parse_args().path

    # Transliterate the file name
    new_name = cyrillic_to_latin(file_path.stem) + file_path.suffix

    # Generate the new file path
    new_path = file_path.with_name(new_name)

    # Rename the file
    file_path.rename(new_path)


if __name__ == "__main__":
    main()
