<a id="mypy-boto3-sesv2"></a>

# mypy-boto3-sesv2

[![PyPI - mypy-boto3-sesv2](https://img.shields.io/pypi/v/mypy-boto3-sesv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-sesv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sesv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-sesv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-sesv2?color=blue)](https://pypistats.org/packages/mypy-boto3-sesv2)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SESV2 1.18.27](https://boto3.amazonaws.com/v1/documentation/api/1.18.27/reference/services/sesv2.html#SESV2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sesv2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sesv2/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sesv2](#mypy-boto3-sesv2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `SESV2` service.

```bash
python -m pip install boto3-stubs[sesv2]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sesv2]` in your environment:
  `python -m pip install 'boto3-stubs[sesv2]'`

Both type checking and auto-complete should work for `SESV2` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[sesv2]` in your environment:
  `python -m pip install 'boto3-stubs[sesv2]'`

Both type checking and auto-complete should work for `SESV2` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sesv2]` in your environment:
  `python -m pip install 'boto3-stubs[sesv2]'`
- Run `mypy` as usual

Type checking should work for `SESV2` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sesv2]` in your environment:
  `python -m pip install 'boto3-stubs[sesv2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SESV2` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SESV2Client` provides annotations for `boto3.client("sesv2")`.

```python
import boto3

from mypy_boto3_sesv2 import SESV2Client

client: SESV2Client = boto3.client("sesv2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SESV2Client = session.client("sesv2")
```

<a id="literals"></a>

### Literals

`mypy_boto3_sesv2.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_sesv2.literals import (
    BehaviorOnMxFailureType,
    BulkEmailStatusType,
    ContactLanguageType,
    ContactListImportActionType,
    DataFormatType,
    DeliverabilityDashboardAccountStatusType,
    DeliverabilityTestStatusType,
    DimensionValueSourceType,
    DkimSigningAttributesOriginType,
    DkimStatusType,
    EventTypeType,
    IdentityTypeType,
    ImportDestinationTypeType,
    JobStatusType,
    MailFromDomainStatusType,
    MailTypeType,
    ReviewStatusType,
    SubscriptionStatusType,
    SuppressionListImportActionType,
    SuppressionListReasonType,
    TlsPolicyType,
    WarmupStatusType,
)

def check_value(value: BehaviorOnMxFailureType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_sesv2.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_sesv2.type_defs import (
    AccountDetailsTypeDef,
    BlacklistEntryTypeDef,
    BodyTypeDef,
    BulkEmailContentTypeDef,
    BulkEmailEntryResultTypeDef,
    BulkEmailEntryTypeDef,
    CloudWatchDestinationTypeDef,
    CloudWatchDimensionConfigurationTypeDef,
    ContactListDestinationTypeDef,
    ContactListTypeDef,
    ContactTypeDef,
    ContentTypeDef,
    CreateConfigurationSetEventDestinationRequestRequestTypeDef,
    CreateConfigurationSetRequestRequestTypeDef,
    CreateContactListRequestRequestTypeDef,
    CreateContactRequestRequestTypeDef,
    CreateCustomVerificationEmailTemplateRequestRequestTypeDef,
    CreateDedicatedIpPoolRequestRequestTypeDef,
    CreateDeliverabilityTestReportRequestRequestTypeDef,
    CreateDeliverabilityTestReportResponseTypeDef,
    CreateEmailIdentityPolicyRequestRequestTypeDef,
    CreateEmailIdentityRequestRequestTypeDef,
    CreateEmailIdentityResponseTypeDef,
    CreateEmailTemplateRequestRequestTypeDef,
    CreateImportJobRequestRequestTypeDef,
    CreateImportJobResponseTypeDef,
    CustomVerificationEmailTemplateMetadataTypeDef,
    DailyVolumeTypeDef,
    DedicatedIpTypeDef,
    DeleteConfigurationSetEventDestinationRequestRequestTypeDef,
    DeleteConfigurationSetRequestRequestTypeDef,
    DeleteContactListRequestRequestTypeDef,
    DeleteContactRequestRequestTypeDef,
    DeleteCustomVerificationEmailTemplateRequestRequestTypeDef,
    DeleteDedicatedIpPoolRequestRequestTypeDef,
    DeleteEmailIdentityPolicyRequestRequestTypeDef,
    DeleteEmailIdentityRequestRequestTypeDef,
    DeleteEmailTemplateRequestRequestTypeDef,
    DeleteSuppressedDestinationRequestRequestTypeDef,
    DeliverabilityTestReportTypeDef,
    DeliveryOptionsTypeDef,
    DestinationTypeDef,
    DkimAttributesTypeDef,
    DkimSigningAttributesTypeDef,
    DomainDeliverabilityCampaignTypeDef,
    DomainDeliverabilityTrackingOptionTypeDef,
    DomainIspPlacementTypeDef,
    EmailContentTypeDef,
    EmailTemplateContentTypeDef,
    EmailTemplateMetadataTypeDef,
    EventDestinationDefinitionTypeDef,
    EventDestinationTypeDef,
    FailureInfoTypeDef,
    GetAccountResponseTypeDef,
    GetBlacklistReportsRequestRequestTypeDef,
    GetBlacklistReportsResponseTypeDef,
    GetConfigurationSetEventDestinationsRequestRequestTypeDef,
    GetConfigurationSetEventDestinationsResponseTypeDef,
    GetConfigurationSetRequestRequestTypeDef,
    GetConfigurationSetResponseTypeDef,
    GetContactListRequestRequestTypeDef,
    GetContactListResponseTypeDef,
    GetContactRequestRequestTypeDef,
    GetContactResponseTypeDef,
    GetCustomVerificationEmailTemplateRequestRequestTypeDef,
    GetCustomVerificationEmailTemplateResponseTypeDef,
    GetDedicatedIpRequestRequestTypeDef,
    GetDedicatedIpResponseTypeDef,
    GetDedicatedIpsRequestRequestTypeDef,
    GetDedicatedIpsResponseTypeDef,
    GetDeliverabilityDashboardOptionsResponseTypeDef,
    GetDeliverabilityTestReportRequestRequestTypeDef,
    GetDeliverabilityTestReportResponseTypeDef,
    GetDomainDeliverabilityCampaignRequestRequestTypeDef,
    GetDomainDeliverabilityCampaignResponseTypeDef,
    GetDomainStatisticsReportRequestRequestTypeDef,
    GetDomainStatisticsReportResponseTypeDef,
    GetEmailIdentityPoliciesRequestRequestTypeDef,
    GetEmailIdentityPoliciesResponseTypeDef,
    GetEmailIdentityRequestRequestTypeDef,
    GetEmailIdentityResponseTypeDef,
    GetEmailTemplateRequestRequestTypeDef,
    GetEmailTemplateResponseTypeDef,
    GetImportJobRequestRequestTypeDef,
    GetImportJobResponseTypeDef,
    GetSuppressedDestinationRequestRequestTypeDef,
    GetSuppressedDestinationResponseTypeDef,
    IdentityInfoTypeDef,
    ImportDataSourceTypeDef,
    ImportDestinationTypeDef,
    ImportJobSummaryTypeDef,
    InboxPlacementTrackingOptionTypeDef,
    IspPlacementTypeDef,
    KinesisFirehoseDestinationTypeDef,
    ListConfigurationSetsRequestRequestTypeDef,
    ListConfigurationSetsResponseTypeDef,
    ListContactListsRequestRequestTypeDef,
    ListContactListsResponseTypeDef,
    ListContactsFilterTypeDef,
    ListContactsRequestRequestTypeDef,
    ListContactsResponseTypeDef,
    ListCustomVerificationEmailTemplatesRequestRequestTypeDef,
    ListCustomVerificationEmailTemplatesResponseTypeDef,
    ListDedicatedIpPoolsRequestRequestTypeDef,
    ListDedicatedIpPoolsResponseTypeDef,
    ListDeliverabilityTestReportsRequestRequestTypeDef,
    ListDeliverabilityTestReportsResponseTypeDef,
    ListDomainDeliverabilityCampaignsRequestRequestTypeDef,
    ListDomainDeliverabilityCampaignsResponseTypeDef,
    ListEmailIdentitiesRequestRequestTypeDef,
    ListEmailIdentitiesResponseTypeDef,
    ListEmailTemplatesRequestRequestTypeDef,
    ListEmailTemplatesResponseTypeDef,
    ListImportJobsRequestRequestTypeDef,
    ListImportJobsResponseTypeDef,
    ListManagementOptionsTypeDef,
    ListSuppressedDestinationsRequestRequestTypeDef,
    ListSuppressedDestinationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MailFromAttributesTypeDef,
    MessageTagTypeDef,
    MessageTypeDef,
    OverallVolumeTypeDef,
    PinpointDestinationTypeDef,
    PlacementStatisticsTypeDef,
    PutAccountDedicatedIpWarmupAttributesRequestRequestTypeDef,
    PutAccountDetailsRequestRequestTypeDef,
    PutAccountSendingAttributesRequestRequestTypeDef,
    PutAccountSuppressionAttributesRequestRequestTypeDef,
    PutConfigurationSetDeliveryOptionsRequestRequestTypeDef,
    PutConfigurationSetReputationOptionsRequestRequestTypeDef,
    PutConfigurationSetSendingOptionsRequestRequestTypeDef,
    PutConfigurationSetSuppressionOptionsRequestRequestTypeDef,
    PutConfigurationSetTrackingOptionsRequestRequestTypeDef,
    PutDedicatedIpInPoolRequestRequestTypeDef,
    PutDedicatedIpWarmupAttributesRequestRequestTypeDef,
    PutDeliverabilityDashboardOptionRequestRequestTypeDef,
    PutEmailIdentityConfigurationSetAttributesRequestRequestTypeDef,
    PutEmailIdentityDkimAttributesRequestRequestTypeDef,
    PutEmailIdentityDkimSigningAttributesRequestRequestTypeDef,
    PutEmailIdentityDkimSigningAttributesResponseTypeDef,
    PutEmailIdentityFeedbackAttributesRequestRequestTypeDef,
    PutEmailIdentityMailFromAttributesRequestRequestTypeDef,
    PutSuppressedDestinationRequestRequestTypeDef,
    RawMessageTypeDef,
    ReplacementEmailContentTypeDef,
    ReplacementTemplateTypeDef,
    ReputationOptionsTypeDef,
    ResponseMetadataTypeDef,
    ReviewDetailsTypeDef,
    SendBulkEmailRequestRequestTypeDef,
    SendBulkEmailResponseTypeDef,
    SendCustomVerificationEmailRequestRequestTypeDef,
    SendCustomVerificationEmailResponseTypeDef,
    SendEmailRequestRequestTypeDef,
    SendEmailResponseTypeDef,
    SendQuotaTypeDef,
    SendingOptionsTypeDef,
    SnsDestinationTypeDef,
    SuppressedDestinationAttributesTypeDef,
    SuppressedDestinationSummaryTypeDef,
    SuppressedDestinationTypeDef,
    SuppressionAttributesTypeDef,
    SuppressionListDestinationTypeDef,
    SuppressionOptionsTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TemplateTypeDef,
    TestRenderEmailTemplateRequestRequestTypeDef,
    TestRenderEmailTemplateResponseTypeDef,
    TopicFilterTypeDef,
    TopicPreferenceTypeDef,
    TopicTypeDef,
    TrackingOptionsTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateConfigurationSetEventDestinationRequestRequestTypeDef,
    UpdateContactListRequestRequestTypeDef,
    UpdateContactRequestRequestTypeDef,
    UpdateCustomVerificationEmailTemplateRequestRequestTypeDef,
    UpdateEmailIdentityPolicyRequestRequestTypeDef,
    UpdateEmailTemplateRequestRequestTypeDef,
    VolumeStatisticsTypeDef,
)

def get_structure() -> AccountDetailsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-sesv2` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-sesv2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sesv2/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
