# -*- coding: UTF-8 -*-


DATE_FMT = "%Y-%m-%d"
TIME_FMT = "%H:%M"
DT_FMT = f"{DATE_FMT} {TIME_FMT}:%S"

DEFAULT_LOGGER_NAME = "uvicorn"
LOG_DT_FMT = f"{DT_FMT},%03d"
LOG_FMT_NO_DT = "[%(levelname)7s][%(correlation_id)s][%(name)s][%(filename)s::%(funcName)s(%(lineno)s)]: %(message)s"
LOG_FMT = "[%(asctime)s]" + LOG_FMT_NO_DT

ARR_EXPORT_SHORT_FMT = "MM/DD HH:mm"
ARR_DASH_SHORT_FMT = "MM-DD HH:mm"
ARR_EXPORT_DATE_FMT = "YYYY/MM/DD"
ARR_EXPORT_DATE_ONLY_FMT = "MM/DD"
ARR_DATE_FMT = "YYYY-MM-DD"
ARR_DATE_FMT_NO_DASH = "YYYYMMDD"
ARR_EXPORT_DATETIME_FMT = "YYYY/MM/DD HH:mm"
ARR_TIME_FMT = "HH:mm:ss"
ARR_TIME_ONLY_FMT = "HH:mm"
ARR_RFC3339_DT_FMT = f"{ARR_DATE_FMT}T{ARR_TIME_FMT}ZZ"
ARR_DATETIME_FMT_NO_DASH = "YYYYMMDDHHmmss"
ARR_HUMAN_READ_FMT = f"{ARR_DATE_FMT} {ARR_TIME_FMT}"
ARR_IMPORT_TS_FMT = "YYYYMMDDHHmmss.SSSSSS"
ARR_STR_DAY = "day"

STR_EMPTY = ""
STR_SPACE = " "
STR_DASH = "-"
STR_UNDERSCORE = "_"
STR_SLASH = "/"
STR_COMMA = ","

SECONDS_PER_YEAR = 30758400
SECONDS_PER_DAY = 86400
SECONDS_PER_MIN = 60

DEF_PAGE_NO = 1
DEF_PAGE_SIZE = 15
DEF_ORDER_BY = "_id"

REDIS_LPR_DATA_LIST_PREFIX = "lpr_data_list"

CORRELATION_ID_HEADER_KEY_NAME = "X-Request-ID"

SOURCE_SMART_WORKSHOP_IMPORTED_SERVICE_TICKET = 'SmartWorkshopImportedServiceTicket'
SOURCE_SMART_WORKSHOP_UPDATE_SERVICE_TICKET = 'SmartWorkshopUpdateServiceTicket'
SOURCE_SMART_WORKSHOP_IMPORTED_DMS_DATA = 'SmartWorkshopImportedDMSData'
SOURCE_WEBHOOK = 'Webhook'
SOURCE_SMART_WORKSHOP = 'SmartWorkshopManual'