ref = {'author': 'Armin Ronacher',
 'author_email': 'armin.ronacher@active-4.com',
 'classifiers': None,
 'description': 'Jinja2\n~~~~~~\n\nJinja2 is a template engine written in pure Python.  It provides a\n`Django`_ inspired non-XML syntax but supports inline expressions and\nan optional `sandboxed`_ environment.\n\nNutshell\n--------\n\nHere a small example of a Jinja template::\n\n    {% extends \'base.html\' %}\n    {% block title %}Memberlist{% endblock %}\n    {% block content %}\n      <ul>\n      {% for user in users %}\n        <li><a href="{{ user.url }}">{{ user.username }}</a></li>\n      {% endfor %}\n      </ul>\n    {% endblock %}\n\nPhilosophy\n----------\n\nApplication logic is for the controller but don\'t try to make the life\nfor the template designer too hard by giving him too few functionality.\n\nFor more informations visit the new `Jinja2 webpage`_ and `documentation`_.\n\nThe `Jinja2 tip`_ is installable via `easy_install` with ``easy_install\nJinja2==dev``.\n\n.. _sandboxed: http://en.wikipedia.org/wiki/Sandbox_(computer_security)\n.. _Django: http://www.djangoproject.com/\n.. _Jinja2 webpage: http://jinja.pocoo.org/\n.. _documentation: http://jinja.pocoo.org/2/documentation/\n.. _Jinja2 tip: http://dev.pocoo.org/hg/jinja2-main/archive/tip.tar.gz#egg=Jinja2-dev',
 'download_url': 'UNKNOWN',
 'extra_source_files': ['AUTHORS',
                        'CHANGES',
                        'LICENSE',
                        'MANIFEST.in',
                        'Makefile',
                        'TODO',
                        'artwork/jinjalogo.svg',
                        'docs/Makefile',
                        'docs/_build/.ignore',
                        'docs/_build/html/.buildinfo',
                        'docs/_build/html/_sources/api.txt',
                        'docs/_build/html/_sources/changelog.txt',
                        'docs/_build/html/_sources/extensions.txt',
                        'docs/_build/html/_sources/faq.txt',
                        'docs/_build/html/_sources/index.txt',
                        'docs/_build/html/_sources/integration.txt',
                        'docs/_build/html/_sources/intro.txt',
                        'docs/_build/html/_sources/sandbox.txt',
                        'docs/_build/html/_sources/switching.txt',
                        'docs/_build/html/_sources/templates.txt',
                        'docs/_build/html/_sources/tricks.txt',
                        'docs/_build/html/_static/basic.css',
                        'docs/_build/html/_static/darkmetal.png',
                        'docs/_build/html/_static/default.css',
                        'docs/_build/html/_static/doctools.js',
                        'docs/_build/html/_static/file.png',
                        'docs/_build/html/_static/headerbg.png',
                        'docs/_build/html/_static/implementation.png',
                        'docs/_build/html/_static/jinja.js',
                        'docs/_build/html/_static/jinjabanner.png',
                        'docs/_build/html/_static/jquery.js',
                        'docs/_build/html/_static/metal.png',
                        'docs/_build/html/_static/minus.png',
                        'docs/_build/html/_static/navigation.png',
                        'docs/_build/html/_static/note.png',
                        'docs/_build/html/_static/plus.png',
                        'docs/_build/html/_static/print.css',
                        'docs/_build/html/_static/pygments.css',
                        'docs/_build/html/_static/searchtools.js',
                        'docs/_build/html/_static/style.css',
                        'docs/_build/html/_static/watermark.png',
                        'docs/_build/html/_static/watermark_blur.png',
                        'docs/_build/html/api.html',
                        'docs/_build/html/changelog.html',
                        'docs/_build/html/extensions.html',
                        'docs/_build/html/faq.html',
                        'docs/_build/html/genindex.html',
                        'docs/_build/html/index.html',
                        'docs/_build/html/integration.html',
                        'docs/_build/html/intro.html',
                        'docs/_build/html/objects.inv',
                        'docs/_build/html/sandbox.html',
                        'docs/_build/html/search.html',
                        'docs/_build/html/searchindex.js',
                        'docs/_build/html/switching.html',
                        'docs/_build/html/templates.html',
                        'docs/_build/html/tricks.html',
                        'docs/_static/.ignore',
                        'docs/_static/darkmetal.png',
                        'docs/_static/headerbg.png',
                        'docs/_static/implementation.png',
                        'docs/_static/jinja.js',
                        'docs/_static/jinjabanner.png',
                        'docs/_static/metal.png',
                        'docs/_static/navigation.png',
                        'docs/_static/note.png',
                        'docs/_static/print.css',
                        'docs/_static/style.css',
                        'docs/_static/watermark.png',
                        'docs/_static/watermark_blur.png',
                        'docs/_templates/.ignore',
                        'docs/_templates/genindex.html',
                        'docs/_templates/layout.html',
                        'docs/_templates/opensearch.xml',
                        'docs/_templates/page.html',
                        'docs/_templates/search.html',
                        'docs/api.rst',
                        'docs/cache_extension.py',
                        'docs/changelog.rst',
                        'docs/conf.py',
                        'docs/extensions.rst',
                        'docs/faq.rst',
                        'docs/index.rst',
                        'docs/integration.rst',
                        'docs/intro.rst',
                        'docs/jinjaext.py',
                        'docs/jinjaext.pyc',
                        'docs/sandbox.rst',
                        'docs/switching.rst',
                        'docs/templates.rst',
                        'docs/tricks.rst',
                        'examples/basic/cycle.py',
                        'examples/basic/debugger.py',
                        'examples/basic/inheritance.py',
                        'examples/basic/templates/broken.html',
                        'examples/basic/templates/subbroken.html',
                        'examples/basic/test.py',
                        'examples/basic/test_filter_and_linestatements.py',
                        'examples/basic/test_loop_filter.py',
                        'examples/basic/translate.py',
                        'examples/bench.py',
                        'examples/profile.py',
                        'examples/rwbench/django/_form.html',
                        'examples/rwbench/django/_input_field.html',
                        'examples/rwbench/django/_textarea.html',
                        'examples/rwbench/django/index.html',
                        'examples/rwbench/django/layout.html',
                        'examples/rwbench/djangoext.py',
                        'examples/rwbench/djangoext.pyc',
                        'examples/rwbench/genshi/helpers.html',
                        'examples/rwbench/genshi/index.html',
                        'examples/rwbench/genshi/layout.html',
                        'examples/rwbench/jinja/helpers.html',
                        'examples/rwbench/jinja/index.html',
                        'examples/rwbench/jinja/layout.html',
                        'examples/rwbench/mako/helpers.html',
                        'examples/rwbench/mako/index.html',
                        'examples/rwbench/mako/layout.html',
                        'examples/rwbench/rwbench.py',
                        'examples/rwbench/rwbench.pyc',
                        'ext/JinjaTemplates.tmbundle.tar.gz',
                        'ext/Vim/htmljinja.vim',
                        'ext/Vim/jinja.vim',
                        'ext/django2jinja/django2jinja.py',
                        'ext/django2jinja/example.py',
                        'ext/django2jinja/templates/index.html',
                        'ext/django2jinja/templates/layout.html',
                        'ext/django2jinja/templates/subtemplate.html',
                        'ext/djangojinja2.py',
                        'ext/inlinegettext.py',
                        'ext/jinja.el',
                        'setup.cfg',
                        'setup.py',
                        'tests/loaderres/__init__$py.class',
                        'tests/loaderres/__init__.py',
                        'tests/loaderres/__init__.pyc',
                        'tests/loaderres/templates/broken.html',
                        'tests/loaderres/templates/foo/test.html',
                        'tests/loaderres/templates/syntaxerror.html',
                        'tests/loaderres/templates/test.html',
                        'tests/test_debug$py.class',
                        'tests/test_debug.py',
                        'tests/test_debug.pyc',
                        'tests/test_ext$py.class',
                        'tests/test_ext.py',
                        'tests/test_ext.pyc',
                        'tests/test_filters$py.class',
                        'tests/test_filters.py',
                        'tests/test_filters.pyc',
                        'tests/test_forloop$py.class',
                        'tests/test_forloop.py',
                        'tests/test_forloop.pyc',
                        'tests/test_heavy$py.class',
                        'tests/test_heavy.py',
                        'tests/test_heavy.pyc',
                        'tests/test_i18n$py.class',
                        'tests/test_i18n.py',
                        'tests/test_i18n.pyc',
                        'tests/test_ifcondition$py.class',
                        'tests/test_ifcondition.py',
                        'tests/test_ifcondition.pyc',
                        'tests/test_imports$py.class',
                        'tests/test_imports.py',
                        'tests/test_imports.pyc',
                        'tests/test_inheritance$py.class',
                        'tests/test_inheritance.py',
                        'tests/test_inheritance.pyc',
                        'tests/test_lexer$py.class',
                        'tests/test_lexer.py',
                        'tests/test_lexer.pyc',
                        'tests/test_loaders$py.class',
                        'tests/test_loaders.py',
                        'tests/test_loaders.pyc',
                        'tests/test_lrucache$py.class',
                        'tests/test_lrucache.py',
                        'tests/test_lrucache.pyc',
                        'tests/test_macros$py.class',
                        'tests/test_macros.py',
                        'tests/test_macros.pyc',
                        'tests/test_meta$py.class',
                        'tests/test_meta.py',
                        'tests/test_meta.pyc',
                        'tests/test_old_bugs$py.class',
                        'tests/test_old_bugs.py',
                        'tests/test_old_bugs.pyc',
                        'tests/test_parser$py.class',
                        'tests/test_parser.py',
                        'tests/test_parser.pyc',
                        'tests/test_security$py.class',
                        'tests/test_security.py',
                        'tests/test_security.pyc',
                        'tests/test_streaming$py.class',
                        'tests/test_streaming.py',
                        'tests/test_streaming.pyc',
                        'tests/test_syntax$py.class',
                        'tests/test_syntax.py',
                        'tests/test_syntax.pyc',
                        'tests/test_tests$py.class',
                        'tests/test_tests.py',
                        'tests/test_tests.pyc',
                        'tests/test_undefined$py.class',
                        'tests/test_undefined.py',
                        'tests/test_undefined.pyc',
                        'tests/test_various$py.class',
                        'tests/test_various.py',
                        'tests/test_various.pyc'],
 'libraries': {'default': {'name': 'default',
                           'packages': ['jinja2']}},
 'license': 'BSD',
 'maintainer': 'Armin Ronacher',
 'maintainer_email': 'armin.ronacher@active-4.com',
 'name': 'Jinja2',
 'path_options': {'gendatadir': {'default': '$sitedir',
                                 'description': 'Directory for datafiles obtained from distutils conversion',
                                 'name': 'gendatadir'}},
 'platforms': 'UNKNOWN',
 'summary': 'A small but fast and easy to use stand-alone template engine written in pure python.',
 'url': 'http://jinja.pocoo.org/',
 'version': '2.2.1'}
