"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NonApiResource = exports.ApiResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents information about an API resource type.
 */
class ApiResource {
    constructor(options) {
        this.apiGroup = options.apiGroup;
        this.resourceType = options.resourceType;
    }
    /**
     * API resource information for a custom resource type.
     */
    static custom(options) {
        return new ApiResource(options);
    }
    ;
    asApiResource() {
        return this;
    }
    asNonApiResource() {
        return undefined;
    }
}
exports.ApiResource = ApiResource;
_a = JSII_RTTI_SYMBOL_1;
ApiResource[_a] = { fqn: "cdk8s-plus-23.ApiResource", version: "2.0.0-rc.63" };
/**
 * API resource information for Binding.
 */
ApiResource.BINDINGS = new ApiResource({
    apiGroup: '',
    resourceType: 'bindings',
});
/**
 * API resource information for ComponentStatus.
 */
ApiResource.COMPONENT_STATUSES = new ApiResource({
    apiGroup: '',
    resourceType: 'componentstatuses',
});
/**
 * API resource information for ConfigMap.
 */
ApiResource.CONFIG_MAPS = new ApiResource({
    apiGroup: '',
    resourceType: 'configmaps',
});
/**
 * API resource information for Endpoints.
 */
ApiResource.ENDPOINTS = new ApiResource({
    apiGroup: '',
    resourceType: 'endpoints',
});
/**
 * API resource information for Event.
 */
ApiResource.EVENTS = new ApiResource({
    apiGroup: '',
    resourceType: 'events',
});
/**
 * API resource information for LimitRange.
 */
ApiResource.LIMIT_RANGES = new ApiResource({
    apiGroup: '',
    resourceType: 'limitranges',
});
/**
 * API resource information for Namespace.
 */
ApiResource.NAMESPACES = new ApiResource({
    apiGroup: '',
    resourceType: 'namespaces',
});
/**
 * API resource information for Node.
 */
ApiResource.NODES = new ApiResource({
    apiGroup: '',
    resourceType: 'nodes',
});
/**
 * API resource information for PersistentVolumeClaim.
 */
ApiResource.PERSISTENT_VOLUME_CLAIMS = new ApiResource({
    apiGroup: '',
    resourceType: 'persistentvolumeclaims',
});
/**
 * API resource information for PersistentVolume.
 */
ApiResource.PERSISTENT_VOLUMES = new ApiResource({
    apiGroup: '',
    resourceType: 'persistentvolumes',
});
/**
 * API resource information for Pod.
 */
ApiResource.PODS = new ApiResource({
    apiGroup: '',
    resourceType: 'pods',
});
/**
 * API resource information for PodTemplate.
 */
ApiResource.POD_TEMPLATES = new ApiResource({
    apiGroup: '',
    resourceType: 'podtemplates',
});
/**
 * API resource information for ReplicationController.
 */
ApiResource.REPLICATION_CONTROLLERS = new ApiResource({
    apiGroup: '',
    resourceType: 'replicationcontrollers',
});
/**
 * API resource information for ResourceQuota.
 */
ApiResource.RESOURCE_QUOTAS = new ApiResource({
    apiGroup: '',
    resourceType: 'resourcequotas',
});
/**
 * API resource information for Secret.
 */
ApiResource.SECRETS = new ApiResource({
    apiGroup: '',
    resourceType: 'secrets',
});
/**
 * API resource information for ServiceAccount.
 */
ApiResource.SERVICE_ACCOUNTS = new ApiResource({
    apiGroup: '',
    resourceType: 'serviceaccounts',
});
/**
 * API resource information for Service.
 */
ApiResource.SERVICES = new ApiResource({
    apiGroup: '',
    resourceType: 'services',
});
/**
 * API resource information for MutatingWebhookConfiguration.
 */
ApiResource.MUTATING_WEBHOOK_CONFIGURATIONS = new ApiResource({
    apiGroup: 'admissionregistration.k8s.io',
    resourceType: 'mutatingwebhookconfigurations',
});
/**
 * API resource information for ValidatingWebhookConfiguration.
 */
ApiResource.VALIDATING_WEBHOOK_CONFIGURATIONS = new ApiResource({
    apiGroup: 'admissionregistration.k8s.io',
    resourceType: 'validatingwebhookconfigurations',
});
/**
 * API resource information for CustomResourceDefinition.
 */
ApiResource.CUSTOM_RESOURCE_DEFINITIONS = new ApiResource({
    apiGroup: 'apiextensions.k8s.io',
    resourceType: 'customresourcedefinitions',
});
/**
 * API resource information for APIService.
 */
ApiResource.API_SERVICES = new ApiResource({
    apiGroup: 'apiregistration.k8s.io',
    resourceType: 'apiservices',
});
/**
 * API resource information for ControllerRevision.
 */
ApiResource.CONTROLLER_REVISIONS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'controllerrevisions',
});
/**
 * API resource information for DaemonSet.
 */
ApiResource.DAEMON_SETS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'daemonsets',
});
/**
 * API resource information for Deployment.
 */
ApiResource.DEPLOYMENTS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'deployments',
});
/**
 * API resource information for ReplicaSet.
 */
ApiResource.REPLICA_SETS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'replicasets',
});
/**
 * API resource information for StatefulSet.
 */
ApiResource.STATEFUL_SETS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'statefulsets',
});
/**
 * API resource information for TokenReview.
 */
ApiResource.TOKEN_REVIEWS = new ApiResource({
    apiGroup: 'authentication.k8s.io',
    resourceType: 'tokenreviews',
});
/**
 * API resource information for LocalSubjectAccessReview.
 */
ApiResource.LOCAL_SUBJECT_ACCESS_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'localsubjectaccessreviews',
});
/**
 * API resource information for SelfSubjectAccessReview.
 */
ApiResource.SELF_SUBJECT_ACCESS_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'selfsubjectaccessreviews',
});
/**
 * API resource information for SelfSubjectRulesReview.
 */
ApiResource.SELF_SUBJECT_RULES_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'selfsubjectrulesreviews',
});
/**
 * API resource information for SubjectAccessReview.
 */
ApiResource.SUBJECT_ACCESS_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'subjectaccessreviews',
});
/**
 * API resource information for HorizontalPodAutoscaler.
 */
ApiResource.HORIZONTAL_POD_AUTOSCALERS = new ApiResource({
    apiGroup: 'autoscaling',
    resourceType: 'horizontalpodautoscalers',
});
/**
 * API resource information for CronJob.
 */
ApiResource.CRON_JOBS = new ApiResource({
    apiGroup: 'batch',
    resourceType: 'cronjobs',
});
/**
 * API resource information for Job.
 */
ApiResource.JOBS = new ApiResource({
    apiGroup: 'batch',
    resourceType: 'jobs',
});
/**
 * API resource information for CertificateSigningRequest.
 */
ApiResource.CERTIFICATE_SIGNING_REQUESTS = new ApiResource({
    apiGroup: 'certificates.k8s.io',
    resourceType: 'certificatesigningrequests',
});
/**
 * API resource information for Lease.
 */
ApiResource.LEASES = new ApiResource({
    apiGroup: 'coordination.k8s.io',
    resourceType: 'leases',
});
/**
 * API resource information for EndpointSlice.
 */
ApiResource.ENDPOINT_SLICES = new ApiResource({
    apiGroup: 'discovery.k8s.io',
    resourceType: 'endpointslices',
});
/**
 * API resource information for FlowSchema.
 */
ApiResource.FLOW_SCHEMAS = new ApiResource({
    apiGroup: 'flowcontrol.apiserver.k8s.io',
    resourceType: 'flowschemas',
});
/**
 * API resource information for PriorityLevelConfiguration.
 */
ApiResource.PRIORITY_LEVEL_CONFIGURATIONS = new ApiResource({
    apiGroup: 'flowcontrol.apiserver.k8s.io',
    resourceType: 'prioritylevelconfigurations',
});
/**
 * API resource information for IngressClass.
 */
ApiResource.INGRESS_CLASSES = new ApiResource({
    apiGroup: 'networking.k8s.io',
    resourceType: 'ingressclasses',
});
/**
 * API resource information for Ingress.
 */
ApiResource.INGRESSES = new ApiResource({
    apiGroup: 'networking.k8s.io',
    resourceType: 'ingresses',
});
/**
 * API resource information for NetworkPolicy.
 */
ApiResource.NETWORK_POLICIES = new ApiResource({
    apiGroup: 'networking.k8s.io',
    resourceType: 'networkpolicies',
});
/**
 * API resource information for RuntimeClass.
 */
ApiResource.RUNTIME_CLASSES = new ApiResource({
    apiGroup: 'node.k8s.io',
    resourceType: 'runtimeclasses',
});
/**
 * API resource information for PodDisruptionBudget.
 */
ApiResource.POD_DISRUPTION_BUDGETS = new ApiResource({
    apiGroup: 'policy',
    resourceType: 'poddisruptionbudgets',
});
/**
 * API resource information for PodSecurityPolicy.
 */
ApiResource.POD_SECURITY_POLICIES = new ApiResource({
    apiGroup: 'policy',
    resourceType: 'podsecuritypolicies',
});
/**
 * API resource information for ClusterRoleBinding.
 */
ApiResource.CLUSTER_ROLE_BINDINGS = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'clusterrolebindings',
});
/**
 * API resource information for ClusterRole.
 */
ApiResource.CLUSTER_ROLES = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'clusterroles',
});
/**
 * API resource information for RoleBinding.
 */
ApiResource.ROLE_BINDINGS = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'rolebindings',
});
/**
 * API resource information for Role.
 */
ApiResource.ROLES = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'roles',
});
/**
 * API resource information for PriorityClass.
 */
ApiResource.PRIORITY_CLASSES = new ApiResource({
    apiGroup: 'scheduling.k8s.io',
    resourceType: 'priorityclasses',
});
/**
 * API resource information for CSIDriver.
 */
ApiResource.CSI_DRIVERS = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'csidrivers',
});
/**
 * API resource information for CSINode.
 */
ApiResource.CSI_NODES = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'csinodes',
});
/**
 * API resource information for CSIStorageCapacity.
 */
ApiResource.CSI_STORAGE_CAPACITIES = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'csistoragecapacities',
});
/**
 * API resource information for StorageClass.
 */
ApiResource.STORAGE_CLASSES = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'storageclasses',
});
/**
 * API resource information for VolumeAttachment.
 */
ApiResource.VOLUME_ATTACHMENTS = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'volumeattachments',
});
/**
 * Factory for creating non api resources.
 */
class NonApiResource {
    constructor(nonResourceUrl) {
        this.nonResourceUrl = nonResourceUrl;
    }
    static of(url) {
        return new NonApiResource(url);
    }
    ;
    asApiResource() {
        return undefined;
    }
    asNonApiResource() {
        return this.nonResourceUrl;
    }
}
exports.NonApiResource = NonApiResource;
_b = JSII_RTTI_SYMBOL_1;
NonApiResource[_b] = { fqn: "cdk8s-plus-23.NonApiResource", version: "2.0.0-rc.63" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLXJlc291cmNlLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hcGktcmVzb3VyY2UuZ2VuZXJhdGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBNERBOztHQUVHO0FBQ0gsTUFBYSxXQUFXO0lBbWR0QixZQUFvQixPQUEyQjtRQUM3QyxJQUFJLENBQUMsUUFBUSxHQUFHLE9BQU8sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLFlBQVksR0FBRyxPQUFPLENBQUMsWUFBWSxDQUFDO0lBQzNDLENBQUM7SUE3QkQ7O09BRUc7SUFDSSxNQUFNLENBQUMsTUFBTSxDQUFDLE9BQTJCO1FBQzlDLE9BQU8sSUFBSSxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUFBLENBQUM7SUFjSyxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVNLGdCQUFnQjtRQUNyQixPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDOztBQWxkSCxrQ0F1ZEM7OztBQXRkQzs7R0FFRztBQUNvQixvQkFBUSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ2hELFFBQVEsRUFBRSxFQUFFO0lBQ1osWUFBWSxFQUFFLFVBQVU7Q0FDekIsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsOEJBQWtCLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDMUQsUUFBUSxFQUFFLEVBQUU7SUFDWixZQUFZLEVBQUUsbUJBQW1CO0NBQ2xDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHVCQUFXLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDbkQsUUFBUSxFQUFFLEVBQUU7SUFDWixZQUFZLEVBQUUsWUFBWTtDQUMzQixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixxQkFBUyxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ2pELFFBQVEsRUFBRSxFQUFFO0lBQ1osWUFBWSxFQUFFLFdBQVc7Q0FDMUIsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0Isa0JBQU0sR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUM5QyxRQUFRLEVBQUUsRUFBRTtJQUNaLFlBQVksRUFBRSxRQUFRO0NBQ3ZCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHdCQUFZLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDcEQsUUFBUSxFQUFFLEVBQUU7SUFDWixZQUFZLEVBQUUsYUFBYTtDQUM1QixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixzQkFBVSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ2xELFFBQVEsRUFBRSxFQUFFO0lBQ1osWUFBWSxFQUFFLFlBQVk7Q0FDM0IsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsaUJBQUssR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUM3QyxRQUFRLEVBQUUsRUFBRTtJQUNaLFlBQVksRUFBRSxPQUFPO0NBQ3RCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLG9DQUF3QixHQUFHLElBQUksV0FBVyxDQUFDO0lBQ2hFLFFBQVEsRUFBRSxFQUFFO0lBQ1osWUFBWSxFQUFFLHdCQUF3QjtDQUN2QyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQiw4QkFBa0IsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUMxRCxRQUFRLEVBQUUsRUFBRTtJQUNaLFlBQVksRUFBRSxtQkFBbUI7Q0FDbEMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsZ0JBQUksR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUM1QyxRQUFRLEVBQUUsRUFBRTtJQUNaLFlBQVksRUFBRSxNQUFNO0NBQ3JCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHlCQUFhLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDckQsUUFBUSxFQUFFLEVBQUU7SUFDWixZQUFZLEVBQUUsY0FBYztDQUM3QixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixtQ0FBdUIsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUMvRCxRQUFRLEVBQUUsRUFBRTtJQUNaLFlBQVksRUFBRSx3QkFBd0I7Q0FDdkMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsMkJBQWUsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUN2RCxRQUFRLEVBQUUsRUFBRTtJQUNaLFlBQVksRUFBRSxnQkFBZ0I7Q0FDL0IsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsbUJBQU8sR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUMvQyxRQUFRLEVBQUUsRUFBRTtJQUNaLFlBQVksRUFBRSxTQUFTO0NBQ3hCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLDRCQUFnQixHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3hELFFBQVEsRUFBRSxFQUFFO0lBQ1osWUFBWSxFQUFFLGlCQUFpQjtDQUNoQyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixvQkFBUSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ2hELFFBQVEsRUFBRSxFQUFFO0lBQ1osWUFBWSxFQUFFLFVBQVU7Q0FDekIsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsMkNBQStCLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDdkUsUUFBUSxFQUFFLDhCQUE4QjtJQUN4QyxZQUFZLEVBQUUsK0JBQStCO0NBQzlDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLDZDQUFpQyxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3pFLFFBQVEsRUFBRSw4QkFBOEI7SUFDeEMsWUFBWSxFQUFFLGlDQUFpQztDQUNoRCxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQix1Q0FBMkIsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNuRSxRQUFRLEVBQUUsc0JBQXNCO0lBQ2hDLFlBQVksRUFBRSwyQkFBMkI7Q0FDMUMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0Isd0JBQVksR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNwRCxRQUFRLEVBQUUsd0JBQXdCO0lBQ2xDLFlBQVksRUFBRSxhQUFhO0NBQzVCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLGdDQUFvQixHQUFHLElBQUksV0FBVyxDQUFDO0lBQzVELFFBQVEsRUFBRSxNQUFNO0lBQ2hCLFlBQVksRUFBRSxxQkFBcUI7Q0FDcEMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsdUJBQVcsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNuRCxRQUFRLEVBQUUsTUFBTTtJQUNoQixZQUFZLEVBQUUsWUFBWTtDQUMzQixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQix1QkFBVyxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ25ELFFBQVEsRUFBRSxNQUFNO0lBQ2hCLFlBQVksRUFBRSxhQUFhO0NBQzVCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHdCQUFZLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDcEQsUUFBUSxFQUFFLE1BQU07SUFDaEIsWUFBWSxFQUFFLGFBQWE7Q0FDNUIsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IseUJBQWEsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNyRCxRQUFRLEVBQUUsTUFBTTtJQUNoQixZQUFZLEVBQUUsY0FBYztDQUM3QixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQix5QkFBYSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3JELFFBQVEsRUFBRSx1QkFBdUI7SUFDakMsWUFBWSxFQUFFLGNBQWM7Q0FDN0IsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0Isd0NBQTRCLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDcEUsUUFBUSxFQUFFLHNCQUFzQjtJQUNoQyxZQUFZLEVBQUUsMkJBQTJCO0NBQzFDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHVDQUEyQixHQUFHLElBQUksV0FBVyxDQUFDO0lBQ25FLFFBQVEsRUFBRSxzQkFBc0I7SUFDaEMsWUFBWSxFQUFFLDBCQUEwQjtDQUN6QyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixzQ0FBMEIsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNsRSxRQUFRLEVBQUUsc0JBQXNCO0lBQ2hDLFlBQVksRUFBRSx5QkFBeUI7Q0FDeEMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0Isa0NBQXNCLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDOUQsUUFBUSxFQUFFLHNCQUFzQjtJQUNoQyxZQUFZLEVBQUUsc0JBQXNCO0NBQ3JDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHNDQUEwQixHQUFHLElBQUksV0FBVyxDQUFDO0lBQ2xFLFFBQVEsRUFBRSxhQUFhO0lBQ3ZCLFlBQVksRUFBRSwwQkFBMEI7Q0FDekMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IscUJBQVMsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNqRCxRQUFRLEVBQUUsT0FBTztJQUNqQixZQUFZLEVBQUUsVUFBVTtDQUN6QixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixnQkFBSSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQzVDLFFBQVEsRUFBRSxPQUFPO0lBQ2pCLFlBQVksRUFBRSxNQUFNO0NBQ3JCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHdDQUE0QixHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3BFLFFBQVEsRUFBRSxxQkFBcUI7SUFDL0IsWUFBWSxFQUFFLDRCQUE0QjtDQUMzQyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixrQkFBTSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQzlDLFFBQVEsRUFBRSxxQkFBcUI7SUFDL0IsWUFBWSxFQUFFLFFBQVE7Q0FDdkIsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsMkJBQWUsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUN2RCxRQUFRLEVBQUUsa0JBQWtCO0lBQzVCLFlBQVksRUFBRSxnQkFBZ0I7Q0FDL0IsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0Isd0JBQVksR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNwRCxRQUFRLEVBQUUsOEJBQThCO0lBQ3hDLFlBQVksRUFBRSxhQUFhO0NBQzVCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHlDQUE2QixHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3JFLFFBQVEsRUFBRSw4QkFBOEI7SUFDeEMsWUFBWSxFQUFFLDZCQUE2QjtDQUM1QyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQiwyQkFBZSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3ZELFFBQVEsRUFBRSxtQkFBbUI7SUFDN0IsWUFBWSxFQUFFLGdCQUFnQjtDQUMvQixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixxQkFBUyxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ2pELFFBQVEsRUFBRSxtQkFBbUI7SUFDN0IsWUFBWSxFQUFFLFdBQVc7Q0FDMUIsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsNEJBQWdCLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDeEQsUUFBUSxFQUFFLG1CQUFtQjtJQUM3QixZQUFZLEVBQUUsaUJBQWlCO0NBQ2hDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLDJCQUFlLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDdkQsUUFBUSxFQUFFLGFBQWE7SUFDdkIsWUFBWSxFQUFFLGdCQUFnQjtDQUMvQixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQixrQ0FBc0IsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUM5RCxRQUFRLEVBQUUsUUFBUTtJQUNsQixZQUFZLEVBQUUsc0JBQXNCO0NBQ3JDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLGlDQUFxQixHQUFHLElBQUksV0FBVyxDQUFDO0lBQzdELFFBQVEsRUFBRSxRQUFRO0lBQ2xCLFlBQVksRUFBRSxxQkFBcUI7Q0FDcEMsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsaUNBQXFCLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDN0QsUUFBUSxFQUFFLDJCQUEyQjtJQUNyQyxZQUFZLEVBQUUscUJBQXFCO0NBQ3BDLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLHlCQUFhLEdBQUcsSUFBSSxXQUFXLENBQUM7SUFDckQsUUFBUSxFQUFFLDJCQUEyQjtJQUNyQyxZQUFZLEVBQUUsY0FBYztDQUM3QixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQix5QkFBYSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3JELFFBQVEsRUFBRSwyQkFBMkI7SUFDckMsWUFBWSxFQUFFLGNBQWM7Q0FDN0IsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IsaUJBQUssR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUM3QyxRQUFRLEVBQUUsMkJBQTJCO0lBQ3JDLFlBQVksRUFBRSxPQUFPO0NBQ3RCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLDRCQUFnQixHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3hELFFBQVEsRUFBRSxtQkFBbUI7SUFDN0IsWUFBWSxFQUFFLGlCQUFpQjtDQUNoQyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQix1QkFBVyxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ25ELFFBQVEsRUFBRSxnQkFBZ0I7SUFDMUIsWUFBWSxFQUFFLFlBQVk7Q0FDM0IsQ0FBQyxDQUFDO0FBRUg7O0dBRUc7QUFDb0IscUJBQVMsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUNqRCxRQUFRLEVBQUUsZ0JBQWdCO0lBQzFCLFlBQVksRUFBRSxVQUFVO0NBQ3pCLENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ29CLGtDQUFzQixHQUFHLElBQUksV0FBVyxDQUFDO0lBQzlELFFBQVEsRUFBRSxnQkFBZ0I7SUFDMUIsWUFBWSxFQUFFLHNCQUFzQjtDQUNyQyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQiwyQkFBZSxHQUFHLElBQUksV0FBVyxDQUFDO0lBQ3ZELFFBQVEsRUFBRSxnQkFBZ0I7SUFDMUIsWUFBWSxFQUFFLGdCQUFnQjtDQUMvQixDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNvQiw4QkFBa0IsR0FBRyxJQUFJLFdBQVcsQ0FBQztJQUMxRCxRQUFRLEVBQUUsZ0JBQWdCO0lBQzFCLFlBQVksRUFBRSxtQkFBbUI7Q0FDbEMsQ0FBQyxDQUFDO0FBa0NMOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBTXpCLFlBQXFDLGNBQXNCO1FBQXRCLG1CQUFjLEdBQWQsY0FBYyxDQUFRO0lBQUcsQ0FBQztJQUp4RCxNQUFNLENBQUMsRUFBRSxDQUFDLEdBQVc7UUFDMUIsT0FBTyxJQUFJLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRThELENBQUM7SUFFekQsYUFBYTtRQUNsQixPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0lBRU0sZ0JBQWdCO1FBRXJCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDOztBQWZILHdDQWdCQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIH5+IEdlbmVyYXRlZCBieSBwcm9qZW4uIFRvIG1vZGlmeSwgZWRpdCAucHJvamVucmMuanMgYW5kIHJ1biBcIm5weCBwcm9qZW5cIi5cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgcmVzb3VyY2Ugb3IgY29sbGVjdGlvbiBvZiByZXNvdXJjZXMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUFwaVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBncm91cCBwb3J0aW9uIG9mIHRoZSBBUEkgdmVyc2lvbiAoZS5nLiBgYXV0aG9yaXphdGlvbi5rOHMuaW9gKS5cbiAgICovXG4gIHJlYWRvbmx5IGFwaUdyb3VwOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIGEgcmVzb3VyY2UgdHlwZSBhcyBpdCBhcHBlYXJzIGluIHRoZSByZWxldmFudCBBUEkgZW5kcG9pbnQuXG4gICAqIEBleGFtcGxlIC0gXCJwb2RzXCIgb3IgXCJwb2RzL2xvZ1wiXG4gICAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvcmVmZXJlbmNlL2FjY2Vzcy1hdXRobi1hdXRoei9yYmFjLyNyZWZlcnJpbmctdG8tcmVzb3VyY2VzXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZVR5cGU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHVuaXF1ZSwgbmFtZXNwYWNlLWdsb2JhbCwgbmFtZSBvZiBhbiBvYmplY3QgaW5zaWRlIHRoZSBLdWJlcm5ldGVzIGNsdXN0ZXIuXG4gICAqXG4gICAqIElmIHRoaXMgaXMgb21pdHRlZCwgdGhlIEFwaVJlc291cmNlIHNob3VsZCByZXByZXNlbnQgYWxsIG9iamVjdHMgb2YgdGhlIGdpdmVuIHR5cGUuXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZU5hbWU/OiBzdHJpbmc7XG59XG4vKipcbiAqIEFuIEFQSSBFbmRwb2ludCBjYW4gZWl0aGVyIGJlIGEgcmVzb3VyY2UgZGVzY3JpcHRvciAoZS5nIC9wb2RzKVxuICogb3IgYSBub24gcmVzb3VyY2UgdXJsIChlLmcgL2hlYWx0aHopLiBJdCBtdXN0IGJlIG9uZSBvciB0aGUgb3RoZXIsIGFuZCBub3QgYm90aC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJQXBpRW5kcG9pbnQge1xuXG4gIC8qKlxuICAgKiBSZXR1cm4gdGhlIElBcGlSZXNvdXJjZSB0aGlzIG9iamVjdCByZXByZXNlbnRzLlxuICAgKi9cbiAgYXNBcGlSZXNvdXJjZSgpOiBJQXBpUmVzb3VyY2UgfCB1bmRlZmluZWQ7XG5cbiAgLyoqXG4gICAqIFJldHVybiB0aGUgbm9uIHJlc291cmNlIHVybCB0aGlzIG9iamVjdCByZXByZXNlbnRzLlxuICAgKi9cbiAgYXNOb25BcGlSZXNvdXJjZSgpOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbn1cblxuLyoqXG4gKiBPcHRpb25zIGZvciBgQXBpUmVzb3VyY2VgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEFwaVJlc291cmNlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgZ3JvdXAgcG9ydGlvbiBvZiB0aGUgQVBJIHZlcnNpb24gKGUuZy4gYGF1dGhvcml6YXRpb24uazhzLmlvYCkuXG4gICAqL1xuICByZWFkb25seSBhcGlHcm91cDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgcmVzb3VyY2UgdHlwZSBhcyBpdCBhcHBlYXJzIGluIHRoZSByZWxldmFudCBBUEkgZW5kcG9pbnQuXG4gICAqIEBleGFtcGxlIC0gXCJwb2RzXCIgb3IgXCJwb2RzL2xvZ1wiXG4gICAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvcmVmZXJlbmNlL2FjY2Vzcy1hdXRobi1hdXRoei9yYmFjLyNyZWZlcnJpbmctdG8tcmVzb3VyY2VzXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZVR5cGU6IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGluZm9ybWF0aW9uIGFib3V0IGFuIEFQSSByZXNvdXJjZSB0eXBlLlxuICovXG5leHBvcnQgY2xhc3MgQXBpUmVzb3VyY2UgaW1wbGVtZW50cyBJQXBpUmVzb3VyY2UsIElBcGlFbmRwb2ludCB7XG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIEJpbmRpbmcuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEJJTkRJTkdTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJycsXG4gICAgcmVzb3VyY2VUeXBlOiAnYmluZGluZ3MnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBDb21wb25lbnRTdGF0dXMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPTVBPTkVOVF9TVEFUVVNFUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICcnLFxuICAgIHJlc291cmNlVHlwZTogJ2NvbXBvbmVudHN0YXR1c2VzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgQ29uZmlnTWFwLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT05GSUdfTUFQUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICcnLFxuICAgIHJlc291cmNlVHlwZTogJ2NvbmZpZ21hcHMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBFbmRwb2ludHMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVORFBPSU5UUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICcnLFxuICAgIHJlc291cmNlVHlwZTogJ2VuZHBvaW50cycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIEV2ZW50LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFVkVOVFMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnJyxcbiAgICByZXNvdXJjZVR5cGU6ICdldmVudHMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBMaW1pdFJhbmdlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMSU1JVF9SQU5HRVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnJyxcbiAgICByZXNvdXJjZVR5cGU6ICdsaW1pdHJhbmdlcycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIE5hbWVzcGFjZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTkFNRVNQQUNFUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICcnLFxuICAgIHJlc291cmNlVHlwZTogJ25hbWVzcGFjZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBOb2RlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBOT0RFUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICcnLFxuICAgIHJlc291cmNlVHlwZTogJ25vZGVzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgUGVyc2lzdGVudFZvbHVtZUNsYWltLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQRVJTSVNURU5UX1ZPTFVNRV9DTEFJTVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnJyxcbiAgICByZXNvdXJjZVR5cGU6ICdwZXJzaXN0ZW50dm9sdW1lY2xhaW1zJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgUGVyc2lzdGVudFZvbHVtZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUEVSU0lTVEVOVF9WT0xVTUVTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJycsXG4gICAgcmVzb3VyY2VUeXBlOiAncGVyc2lzdGVudHZvbHVtZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBQb2QuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBPRFMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnJyxcbiAgICByZXNvdXJjZVR5cGU6ICdwb2RzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgUG9kVGVtcGxhdGUuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBPRF9URU1QTEFURVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnJyxcbiAgICByZXNvdXJjZVR5cGU6ICdwb2R0ZW1wbGF0ZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBSZXBsaWNhdGlvbkNvbnRyb2xsZXIuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFUExJQ0FUSU9OX0NPTlRST0xMRVJTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJycsXG4gICAgcmVzb3VyY2VUeXBlOiAncmVwbGljYXRpb25jb250cm9sbGVycycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFJlc291cmNlUXVvdGEuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFU09VUkNFX1FVT1RBUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICcnLFxuICAgIHJlc291cmNlVHlwZTogJ3Jlc291cmNlcXVvdGFzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgU2VjcmV0LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTRUNSRVRTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJycsXG4gICAgcmVzb3VyY2VUeXBlOiAnc2VjcmV0cycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFNlcnZpY2VBY2NvdW50LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTRVJWSUNFX0FDQ09VTlRTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJycsXG4gICAgcmVzb3VyY2VUeXBlOiAnc2VydmljZWFjY291bnRzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgU2VydmljZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VSVklDRVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnJyxcbiAgICByZXNvdXJjZVR5cGU6ICdzZXJ2aWNlcycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIE11dGF0aW5nV2ViaG9va0NvbmZpZ3VyYXRpb24uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1VVEFUSU5HX1dFQkhPT0tfQ09ORklHVVJBVElPTlMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnYWRtaXNzaW9ucmVnaXN0cmF0aW9uLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAnbXV0YXRpbmd3ZWJob29rY29uZmlndXJhdGlvbnMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBWYWxpZGF0aW5nV2ViaG9va0NvbmZpZ3VyYXRpb24uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZBTElEQVRJTkdfV0VCSE9PS19DT05GSUdVUkFUSU9OUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdhZG1pc3Npb25yZWdpc3RyYXRpb24uazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICd2YWxpZGF0aW5nd2ViaG9va2NvbmZpZ3VyYXRpb25zJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgQ3VzdG9tUmVzb3VyY2VEZWZpbml0aW9uLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDVVNUT01fUkVTT1VSQ0VfREVGSU5JVElPTlMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnYXBpZXh0ZW5zaW9ucy5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ2N1c3RvbXJlc291cmNlZGVmaW5pdGlvbnMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBBUElTZXJ2aWNlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBUElfU0VSVklDRVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnYXBpcmVnaXN0cmF0aW9uLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAnYXBpc2VydmljZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBDb250cm9sbGVyUmV2aXNpb24uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPTlRST0xMRVJfUkVWSVNJT05TID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ2FwcHMnLFxuICAgIHJlc291cmNlVHlwZTogJ2NvbnRyb2xsZXJyZXZpc2lvbnMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBEYWVtb25TZXQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERBRU1PTl9TRVRTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ2FwcHMnLFxuICAgIHJlc291cmNlVHlwZTogJ2RhZW1vbnNldHMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBEZXBsb3ltZW50LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBERVBMT1lNRU5UUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdhcHBzJyxcbiAgICByZXNvdXJjZVR5cGU6ICdkZXBsb3ltZW50cycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFJlcGxpY2FTZXQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFUExJQ0FfU0VUUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdhcHBzJyxcbiAgICByZXNvdXJjZVR5cGU6ICdyZXBsaWNhc2V0cycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFN0YXRlZnVsU2V0LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTVEFURUZVTF9TRVRTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ2FwcHMnLFxuICAgIHJlc291cmNlVHlwZTogJ3N0YXRlZnVsc2V0cycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFRva2VuUmV2aWV3LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBUT0tFTl9SRVZJRVdTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ2F1dGhlbnRpY2F0aW9uLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAndG9rZW5yZXZpZXdzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgTG9jYWxTdWJqZWN0QWNjZXNzUmV2aWV3LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMT0NBTF9TVUJKRUNUX0FDQ0VTU19SRVZJRVdTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ2F1dGhvcml6YXRpb24uazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdsb2NhbHN1YmplY3RhY2Nlc3NyZXZpZXdzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgU2VsZlN1YmplY3RBY2Nlc3NSZXZpZXcuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFTEZfU1VCSkVDVF9BQ0NFU1NfUkVWSUVXUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdhdXRob3JpemF0aW9uLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAnc2VsZnN1YmplY3RhY2Nlc3NyZXZpZXdzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgU2VsZlN1YmplY3RSdWxlc1Jldmlldy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VMRl9TVUJKRUNUX1JVTEVTX1JFVklFV1MgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnYXV0aG9yaXphdGlvbi5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ3NlbGZzdWJqZWN0cnVsZXNyZXZpZXdzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgU3ViamVjdEFjY2Vzc1Jldmlldy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1VCSkVDVF9BQ0NFU1NfUkVWSUVXUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdhdXRob3JpemF0aW9uLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAnc3ViamVjdGFjY2Vzc3Jldmlld3MnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBIb3Jpem9udGFsUG9kQXV0b3NjYWxlci5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSE9SSVpPTlRBTF9QT0RfQVVUT1NDQUxFUlMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnYXV0b3NjYWxpbmcnLFxuICAgIHJlc291cmNlVHlwZTogJ2hvcml6b250YWxwb2RhdXRvc2NhbGVycycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIENyb25Kb2IuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENST05fSk9CUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdiYXRjaCcsXG4gICAgcmVzb3VyY2VUeXBlOiAnY3JvbmpvYnMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBKb2IuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEpPQlMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnYmF0Y2gnLFxuICAgIHJlc291cmNlVHlwZTogJ2pvYnMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBDZXJ0aWZpY2F0ZVNpZ25pbmdSZXF1ZXN0LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRVJUSUZJQ0FURV9TSUdOSU5HX1JFUVVFU1RTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ2NlcnRpZmljYXRlcy5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ2NlcnRpZmljYXRlc2lnbmluZ3JlcXVlc3RzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgTGVhc2UuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExFQVNFUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdjb29yZGluYXRpb24uazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdsZWFzZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBFbmRwb2ludFNsaWNlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTkRQT0lOVF9TTElDRVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnZGlzY292ZXJ5Lms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAnZW5kcG9pbnRzbGljZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBGbG93U2NoZW1hLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBGTE9XX1NDSEVNQVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnZmxvd2NvbnRyb2wuYXBpc2VydmVyLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAnZmxvd3NjaGVtYXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBQcmlvcml0eUxldmVsQ29uZmlndXJhdGlvbi5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUFJJT1JJVFlfTEVWRUxfQ09ORklHVVJBVElPTlMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnZmxvd2NvbnRyb2wuYXBpc2VydmVyLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAncHJpb3JpdHlsZXZlbGNvbmZpZ3VyYXRpb25zJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgSW5ncmVzc0NsYXNzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJTkdSRVNTX0NMQVNTRVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnbmV0d29ya2luZy5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ2luZ3Jlc3NjbGFzc2VzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgSW5ncmVzcy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSU5HUkVTU0VTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ25ldHdvcmtpbmcuazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdpbmdyZXNzZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBOZXR3b3JrUG9saWN5LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBORVRXT1JLX1BPTElDSUVTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ25ldHdvcmtpbmcuazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICduZXR3b3JrcG9saWNpZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBSdW50aW1lQ2xhc3MuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJVTlRJTUVfQ0xBU1NFUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdub2RlLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAncnVudGltZWNsYXNzZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBQb2REaXNydXB0aW9uQnVkZ2V0LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQT0RfRElTUlVQVElPTl9CVURHRVRTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ3BvbGljeScsXG4gICAgcmVzb3VyY2VUeXBlOiAncG9kZGlzcnVwdGlvbmJ1ZGdldHMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBQb2RTZWN1cml0eVBvbGljeS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUE9EX1NFQ1VSSVRZX1BPTElDSUVTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ3BvbGljeScsXG4gICAgcmVzb3VyY2VUeXBlOiAncG9kc2VjdXJpdHlwb2xpY2llcycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIENsdXN0ZXJSb2xlQmluZGluZy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xVU1RFUl9ST0xFX0JJTkRJTkdTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ3JiYWMuYXV0aG9yaXphdGlvbi5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ2NsdXN0ZXJyb2xlYmluZGluZ3MnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBDbHVzdGVyUm9sZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xVU1RFUl9ST0xFUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdyYmFjLmF1dGhvcml6YXRpb24uazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdjbHVzdGVycm9sZXMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBSb2xlQmluZGluZy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUk9MRV9CSU5ESU5HUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdyYmFjLmF1dGhvcml6YXRpb24uazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdyb2xlYmluZGluZ3MnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBSb2xlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBST0xFUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdyYmFjLmF1dGhvcml6YXRpb24uazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdyb2xlcycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFByaW9yaXR5Q2xhc3MuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBSSU9SSVRZX0NMQVNTRVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnc2NoZWR1bGluZy5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ3ByaW9yaXR5Y2xhc3NlcycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIENTSURyaXZlci5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ1NJX0RSSVZFUlMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnc3RvcmFnZS5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ2NzaWRyaXZlcnMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBDU0lOb2RlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDU0lfTk9ERVMgPSBuZXcgQXBpUmVzb3VyY2Uoe1xuICAgIGFwaUdyb3VwOiAnc3RvcmFnZS5rOHMuaW8nLFxuICAgIHJlc291cmNlVHlwZTogJ2NzaW5vZGVzJyxcbiAgfSk7XG5cbiAgLyoqXG4gICAqIEFQSSByZXNvdXJjZSBpbmZvcm1hdGlvbiBmb3IgQ1NJU3RvcmFnZUNhcGFjaXR5LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDU0lfU1RPUkFHRV9DQVBBQ0lUSUVTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ3N0b3JhZ2UuazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdjc2lzdG9yYWdlY2FwYWNpdGllcycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFN0b3JhZ2VDbGFzcy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1RPUkFHRV9DTEFTU0VTID0gbmV3IEFwaVJlc291cmNlKHtcbiAgICBhcGlHcm91cDogJ3N0b3JhZ2UuazhzLmlvJyxcbiAgICByZXNvdXJjZVR5cGU6ICdzdG9yYWdlY2xhc3NlcycsXG4gIH0pO1xuXG4gIC8qKlxuICAgKiBBUEkgcmVzb3VyY2UgaW5mb3JtYXRpb24gZm9yIFZvbHVtZUF0dGFjaG1lbnQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZPTFVNRV9BVFRBQ0hNRU5UUyA9IG5ldyBBcGlSZXNvdXJjZSh7XG4gICAgYXBpR3JvdXA6ICdzdG9yYWdlLms4cy5pbycsXG4gICAgcmVzb3VyY2VUeXBlOiAndm9sdW1lYXR0YWNobWVudHMnLFxuICB9KTtcblxuICAvKipcbiAgICogQVBJIHJlc291cmNlIGluZm9ybWF0aW9uIGZvciBhIGN1c3RvbSByZXNvdXJjZSB0eXBlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBjdXN0b20ob3B0aW9uczogQXBpUmVzb3VyY2VPcHRpb25zKTogQXBpUmVzb3VyY2Uge1xuICAgIHJldHVybiBuZXcgQXBpUmVzb3VyY2Uob3B0aW9ucyk7XG4gIH07XG5cbiAgLyoqXG4gICAqIFRoZSBncm91cCBwb3J0aW9uIG9mIHRoZSBBUEkgdmVyc2lvbiAoZS5nLiBgYXV0aG9yaXphdGlvbi5rOHMuaW9gKS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhcGlHcm91cDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgcmVzb3VyY2UgdHlwZSBhcyBpdCBhcHBlYXJzIGluIHRoZSByZWxldmFudCBBUEkgZW5kcG9pbnQuXG4gICAqIEBleGFtcGxlIC0gXCJwb2RzXCIgb3IgXCJwb2RzL2xvZ1wiXG4gICAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvcmVmZXJlbmNlL2FjY2Vzcy1hdXRobi1hdXRoei9yYmFjLyNyZWZlcnJpbmctdG8tcmVzb3VyY2VzXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2VUeXBlOiBzdHJpbmc7XG5cbiAgcHVibGljIGFzQXBpUmVzb3VyY2UoKTogSUFwaVJlc291cmNlIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHB1YmxpYyBhc05vbkFwaVJlc291cmNlKCk6IHN0cmluZyB8IHVuZGVmaW5lZCB7XG4gICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgfVxuICBwcml2YXRlIGNvbnN0cnVjdG9yKG9wdGlvbnM6IEFwaVJlc291cmNlT3B0aW9ucykge1xuICAgIHRoaXMuYXBpR3JvdXAgPSBvcHRpb25zLmFwaUdyb3VwO1xuICAgIHRoaXMucmVzb3VyY2VUeXBlID0gb3B0aW9ucy5yZXNvdXJjZVR5cGU7XG4gIH1cbn1cblxuLyoqXG4gKiBGYWN0b3J5IGZvciBjcmVhdGluZyBub24gYXBpIHJlc291cmNlcy5cbiAqL1xuZXhwb3J0IGNsYXNzIE5vbkFwaVJlc291cmNlIGltcGxlbWVudHMgSUFwaUVuZHBvaW50IHtcblxuICBwdWJsaWMgc3RhdGljIG9mKHVybDogc3RyaW5nKTogTm9uQXBpUmVzb3VyY2Uge1xuICAgIHJldHVybiBuZXcgTm9uQXBpUmVzb3VyY2UodXJsKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBub25SZXNvdXJjZVVybDogc3RyaW5nKSB7fTtcblxuICBwdWJsaWMgYXNBcGlSZXNvdXJjZSgpOiBJQXBpUmVzb3VyY2UgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgYXNOb25BcGlSZXNvdXJjZSgpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuXG4gICAgcmV0dXJuIHRoaXMubm9uUmVzb3VyY2VVcmw7XG4gIH1cbn0iXX0=