# 🧙‍♂️ Sourcerer

**Sourcerer** is a CLI-based cloud storage explorer that provides a unified interface for developers and DevOps
engineers to view and manage files across multiple cloud providers like
**GCP Storage**, **Azure Storage**, **AWS S3**, and **S3-compatible services**.

> Your terminal. Your storages. Your control.

[Demo page](https://the-impact-craft.github.io/sourcerer/)

---

## ✨ Features

- 🔍 Unified file browser for GCP Storage, Azure Storage, AWS S3, and S3-compatible services
- 🧭 Terminal UI (TUI) built with [Textual](https://github.com/Textualize/textual)
- 🗂️ Explore buckets and objects seamlessly
- 🔄 Upload, download, and delete files
- 🔐 Secure credential management via local **SQLite database**

---

## 🪄 Installation

```bash
pipx install data-sourcerer
```
or
```bash
pip install data-sourcerer
```
--

## 🪄 Run

```bash
sourcerer
```


## 🔮 See in action

![creds_registration.gif](https://github.com/the-impact-craft/sourcerer/blob/main/media/creds_registration.gif?raw=true)

![keys_operations.gif](https://github.com/the-impact-craft/sourcerer/blob/main/media/keys_operations.gif?raw=true)
