# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Action Service

    With the Action service in Splunk Cloud Services, you can receive incoming trigger events and use pre-defined action templates to turn these events into meaningful actions. 

    OpenAPI spec version: v1beta2.12 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class Action(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "Action":

        def default_handler(model: dict) -> "Action":
            instance = Action.__new__(Action)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = Action.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, created_at: "datetime" = None, created_by: "str" = None, name: "str" = None, updated_at: "datetime" = None, updated_by: "str" = None, **extra):
        """Action"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if updated_at is not None:
            self._attrs["updatedAt"] = updated_at
        if updated_by is not None:
            self._attrs["updatedBy"] = updated_by
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this Action.
        The name of the action, as one or more identifier strings separated by periods. Each identifier string consists of lowercase letters, digits, and underscores, and cannot start with a digit.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Action.

        The name of the action, as one or more identifier strings separated by periods. Each identifier string consists of lowercase letters, digits, and underscores, and cannot start with a digit.

        :param name: The name of this Action.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this Action.
        The date and time this action template was created (ISO-8601 date/time with zone).
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this Action.

        The date and time this action template was created (ISO-8601 date/time with zone).

        :param created_at: The created_at of this Action.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this Action.
        The principal that created this action template.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this Action.

        The principal that created this action template.

        :param created_by: The created_by of this Action.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def updated_at(self) -> "datetime":
        """ Gets the updated_at of this Action.
        The date and time this action template was updated (ISO-8601 date/time with zone).
        """
        return self._attrs.get("updatedAt")

    @updated_at.setter
    def updated_at(self, updated_at: "datetime"):
        """Sets the updated_at of this Action.

        The date and time this action template was updated (ISO-8601 date/time with zone).

        :param updated_at: The updated_at of this Action.
        :type: datetime
        """
        self._attrs["updatedAt"] = updated_at

    @property
    def updated_by(self) -> "str":
        """ Gets the updated_by of this Action.
        The principal that updated this action template.
        """
        return self._attrs.get("updatedBy")

    @updated_by.setter
    def updated_by(self, updated_by: "str"):
        """Sets the updated_by of this Action.

        The principal that updated this action template.

        :param updated_by: The updated_by of this Action.
        :type: str
        """
        self._attrs["updatedBy"] = updated_by

    def to_dict(self):
        raise NotImplementedError()


class ActionKind(str, Enum):
    WEBHOOK = "webhook"
    EMAIL = "email"

    @staticmethod
    def from_value(value: str):
        if value == "webhook":
            return ActionKind.WEBHOOK
        if value == "email":
            return ActionKind.EMAIL


class ActionMutable(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ActionMutable":
        instance = ActionMutable.__new__(ActionMutable)
        instance._attrs = model
        return instance

    def __init__(self, **extra):
        """ActionMutable"""

        self._attrs = dict()
        for k, v in extra.items():
            self._attrs[k] = v

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusState(str, Enum):
    QUEUED = "QUEUED"
    RUNNING = "RUNNING"
    DONE = "DONE"
    FAILED = "FAILED"

    @staticmethod
    def from_value(value: str):
        if value == "QUEUED":
            return StatusState.QUEUED
        if value == "RUNNING":
            return StatusState.RUNNING
        if value == "DONE":
            return StatusState.DONE
        if value == "FAILED":
            return StatusState.FAILED


class ActionResult(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ActionResult":
        instance = ActionResult.__new__(ActionResult)
        instance._attrs = model
        return instance

    def __init__(self, action_name: "str", state: "StatusState", status_id: "str", message: "str" = None, **extra):
        """ActionResult"""

        self._attrs = dict()
        if action_name is not None:
            self._attrs["actionName"] = action_name
        if state is not None:
            self._attrs["state"] = state
        if status_id is not None:
            self._attrs["statusId"] = status_id
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def action_name(self) -> "str":
        """ Gets the action_name of this ActionResult.
        """
        return self._attrs.get("actionName")

    @action_name.setter
    def action_name(self, action_name: "str"):
        """Sets the action_name of this ActionResult.


        :param action_name: The action_name of this ActionResult.
        :type: str
        """
        if action_name is None:
            raise ValueError("Invalid value for `action_name`, must not be `None`")
        self._attrs["actionName"] = action_name

    @property
    def state(self) -> "StatusState":
        """ Gets the state of this ActionResult.
        """
        return StatusState.from_value(self._attrs.get("state"))

    @state.setter
    def state(self, state: "StatusState"):
        """Sets the state of this ActionResult.


        :param state: The state of this ActionResult.
        :type: StatusState
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")
        if isinstance(state, Enum):
            self._attrs["state"] = state.value
        else:
            self._attrs["state"] = state  # If you supply a string, we presume you know the service will take it.

    @property
    def status_id(self) -> "str":
        """ Gets the status_id of this ActionResult.
        """
        return self._attrs.get("statusId")

    @status_id.setter
    def status_id(self, status_id: "str"):
        """Sets the status_id of this ActionResult.


        :param status_id: The status_id of this ActionResult.
        :type: str
        """
        if status_id is None:
            raise ValueError("Invalid value for `status_id`, must not be `None`")
        self._attrs["statusId"] = status_id

    @property
    def message(self) -> "str":
        """ Gets the message of this ActionResult.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this ActionResult.


        :param message: The message of this ActionResult.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StateEnum(str, Enum):
    PENDING = "PENDING"
    NOT_FOUND = "NOT_FOUND"
    SUCCEEDED = "SUCCEEDED"
    BOUNCED = "BOUNCED"
    RECIPIENT_COMPLAINED = "RECIPIENT_COMPLAINED"

    @staticmethod
    def from_value(value: str):
        if value == "PENDING":
            return StateEnum.PENDING
        if value == "NOT_FOUND":
            return StateEnum.NOT_FOUND
        if value == "SUCCEEDED":
            return StateEnum.SUCCEEDED
        if value == "BOUNCED":
            return StateEnum.BOUNCED
        if value == "RECIPIENT_COMPLAINED":
            return StateEnum.RECIPIENT_COMPLAINED


class ActionResultEmailDetail(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ActionResultEmailDetail":
        instance = ActionResultEmailDetail.__new__(ActionResultEmailDetail)
        instance._attrs = model
        return instance

    def __init__(self, email_address: "str" = None, state: "str" = None, **extra):
        """ActionResultEmailDetail"""

        self._attrs = dict()
        if email_address is not None:
            self._attrs["emailAddress"] = email_address
        if state is not None:
            self._attrs["state"] = state
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def email_address(self) -> "str":
        """ Gets the email_address of this ActionResultEmailDetail.
        """
        return self._attrs.get("emailAddress")

    @email_address.setter
    def email_address(self, email_address: "str"):
        """Sets the email_address of this ActionResultEmailDetail.


        :param email_address: The email_address of this ActionResultEmailDetail.
        :type: str
        """
        self._attrs["emailAddress"] = email_address

    @property
    def state(self) -> "StateEnum":
        """ Gets the state of this ActionResultEmailDetail.
        """
        return StateEnum.from_value(self._attrs.get("state"))

    @state.setter
    def state(self, state: "str"):
        """Sets the state of this ActionResultEmailDetail.


        :param state: The state of this ActionResultEmailDetail.
        :type: str
        """
        if isinstance(state, Enum):
            self._attrs["state"] = state.value
        else:
            self._attrs["state"] = state  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class EmailAction(Action):

    @staticmethod
    def _from_dict(model: dict) -> "EmailAction":
        instance = EmailAction.__new__(EmailAction)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", addresses: "List[str]" = None, body: "str" = None, body_plain_text: "str" = None, created_at: "datetime" = None, created_by: "str" = None, from_name: "str" = None, members: "List[str]" = None, subject: "str" = None, title: "str" = None, updated_at: "datetime" = None, updated_by: "str" = None, **extra):
        """EmailAction"""

        self._attrs = dict()
        self._attrs["kind"] = "email" 
        if name is not None:
            self._attrs["name"] = name
        if addresses is not None:
            self._attrs["addresses"] = addresses
        if body is not None:
            self._attrs["body"] = body
        if body_plain_text is not None:
            self._attrs["bodyPlainText"] = body_plain_text
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if from_name is not None:
            self._attrs["fromName"] = from_name
        if members is not None:
            self._attrs["members"] = members
        if subject is not None:
            self._attrs["subject"] = subject
        if title is not None:
            self._attrs["title"] = title
        if updated_at is not None:
            self._attrs["updatedAt"] = updated_at
        if updated_by is not None:
            self._attrs["updatedBy"] = updated_by
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "email"


    @property
    def name(self) -> "str":
        """ Gets the name of this EmailAction.
        The name of the action, as one or more identifier strings separated by periods. Each identifier string consists of lowercase letters, digits, and underscores, and cannot start with a digit.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this EmailAction.

        The name of the action, as one or more identifier strings separated by periods. Each identifier string consists of lowercase letters, digits, and underscores, and cannot start with a digit.

        :param name: The name of this EmailAction.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def addresses(self) -> "List[str]":
        """ Gets the addresses of this EmailAction.
        An array of email addresses to include as recipients. Requires a special permission set for use. Please DO NOT include actual bouncing emails in automated testing. 
        """
        return self._attrs.get("addresses")

    @addresses.setter
    def addresses(self, addresses: "List[str]"):
        """Sets the addresses of this EmailAction.

        An array of email addresses to include as recipients. Requires a special permission set for use. Please DO NOT include actual bouncing emails in automated testing. 

        :param addresses: The addresses of this EmailAction.
        :type: List[str]
        """
        self._attrs["addresses"] = addresses

    @property
    def body(self) -> "str":
        """ Gets the body of this EmailAction.
        HTML content to send as the body of the email. You can use a template in this field.
        """
        return self._attrs.get("body")

    @body.setter
    def body(self, body: "str"):
        """Sets the body of this EmailAction.

        HTML content to send as the body of the email. You can use a template in this field.

        :param body: The body of this EmailAction.
        :type: str
        """
        self._attrs["body"] = body

    @property
    def body_plain_text(self) -> "str":
        """ Gets the body_plain_text of this EmailAction.
        Optional text to send as the text/plain part of the email. If this field is not set for an email action, the Action service converts the value from the body field to text and sends that as the text/plain part when invoking the action. You can use a template in this field.
        """
        return self._attrs.get("bodyPlainText")

    @body_plain_text.setter
    def body_plain_text(self, body_plain_text: "str"):
        """Sets the body_plain_text of this EmailAction.

        Optional text to send as the text/plain part of the email. If this field is not set for an email action, the Action service converts the value from the body field to text and sends that as the text/plain part when invoking the action. You can use a template in this field.

        :param body_plain_text: The body_plain_text of this EmailAction.
        :type: str
        """
        self._attrs["bodyPlainText"] = body_plain_text

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this EmailAction.
        The date and time this action template was created (ISO-8601 date/time with zone).
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this EmailAction.

        The date and time this action template was created (ISO-8601 date/time with zone).

        :param created_at: The created_at of this EmailAction.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this EmailAction.
        The principal that created this action template.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this EmailAction.

        The principal that created this action template.

        :param created_by: The created_by of this EmailAction.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def from_name(self) -> "str":
        """ Gets the from_name of this EmailAction.
        Optional text providing a human-friendly name for the sender. Must be less than or equal to 81 characters. You can use a template in this field.
        """
        return self._attrs.get("fromName")

    @from_name.setter
    def from_name(self, from_name: "str"):
        """Sets the from_name of this EmailAction.

        Optional text providing a human-friendly name for the sender. Must be less than or equal to 81 characters. You can use a template in this field.

        :param from_name: The from_name of this EmailAction.
        :type: str
        """
        self._attrs["fromName"] = from_name

    @property
    def members(self) -> "List[str]":
        """ Gets the members of this EmailAction.
        An array of tenant member names, whose profile email addresses will be included as recipients.
        """
        return self._attrs.get("members")

    @members.setter
    def members(self, members: "List[str]"):
        """Sets the members of this EmailAction.

        An array of tenant member names, whose profile email addresses will be included as recipients.

        :param members: The members of this EmailAction.
        :type: List[str]
        """
        self._attrs["members"] = members

    @property
    def subject(self) -> "str":
        """ Gets the subject of this EmailAction.
        The subject of the email. You can use a template in this field.
        """
        return self._attrs.get("subject")

    @subject.setter
    def subject(self, subject: "str"):
        """Sets the subject of this EmailAction.

        The subject of the email. You can use a template in this field.

        :param subject: The subject of this EmailAction.
        :type: str
        """
        self._attrs["subject"] = subject

    @property
    def title(self) -> "str":
        """ Gets the title of this EmailAction.
        A human-readable title for the action. Must be less than or equal to 128 characters.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this EmailAction.

        A human-readable title for the action. Must be less than or equal to 128 characters.

        :param title: The title of this EmailAction.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def updated_at(self) -> "datetime":
        """ Gets the updated_at of this EmailAction.
        The date and time this action template was updated (ISO-8601 date/time with zone).
        """
        return self._attrs.get("updatedAt")

    @updated_at.setter
    def updated_at(self, updated_at: "datetime"):
        """Sets the updated_at of this EmailAction.

        The date and time this action template was updated (ISO-8601 date/time with zone).

        :param updated_at: The updated_at of this EmailAction.
        :type: datetime
        """
        self._attrs["updatedAt"] = updated_at

    @property
    def updated_by(self) -> "str":
        """ Gets the updated_by of this EmailAction.
        The principal that updated this action template.
        """
        return self._attrs.get("updatedBy")

    @updated_by.setter
    def updated_by(self, updated_by: "str"):
        """Sets the updated_by of this EmailAction.

        The principal that updated this action template.

        :param updated_by: The updated_by of this EmailAction.
        :type: str
        """
        self._attrs["updatedBy"] = updated_by

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Action.from_dict_handlers["email"] = EmailAction._from_dict



class EmailActionMutable(ActionMutable):

    @staticmethod
    def _from_dict(model: dict) -> "EmailActionMutable":
        instance = EmailActionMutable.__new__(EmailActionMutable)
        instance._attrs = model
        return instance

    def __init__(self, addresses: "List[str]" = None, body: "str" = None, body_plain_text: "str" = None, from_name: "str" = None, members: "List[str]" = None, subject: "str" = None, title: "str" = None, **extra):
        """EmailActionMutable"""

        self._attrs = dict()
        if addresses is not None:
            self._attrs["addresses"] = addresses
        if body is not None:
            self._attrs["body"] = body
        if body_plain_text is not None:
            self._attrs["bodyPlainText"] = body_plain_text
        if from_name is not None:
            self._attrs["fromName"] = from_name
        if members is not None:
            self._attrs["members"] = members
        if subject is not None:
            self._attrs["subject"] = subject
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def addresses(self) -> "List[str]":
        """ Gets the addresses of this EmailActionMutable.
        An array of email addresses to include as recipients. Requires a special permission set for use. Please DO NOT include actual bouncing emails in automated testing. 
        """
        return self._attrs.get("addresses")

    @addresses.setter
    def addresses(self, addresses: "List[str]"):
        """Sets the addresses of this EmailActionMutable.

        An array of email addresses to include as recipients. Requires a special permission set for use. Please DO NOT include actual bouncing emails in automated testing. 

        :param addresses: The addresses of this EmailActionMutable.
        :type: List[str]
        """
        self._attrs["addresses"] = addresses

    @property
    def body(self) -> "str":
        """ Gets the body of this EmailActionMutable.
        HTML content to send as the body of the email. You can use a template in this field.
        """
        return self._attrs.get("body")

    @body.setter
    def body(self, body: "str"):
        """Sets the body of this EmailActionMutable.

        HTML content to send as the body of the email. You can use a template in this field.

        :param body: The body of this EmailActionMutable.
        :type: str
        """
        self._attrs["body"] = body

    @property
    def body_plain_text(self) -> "str":
        """ Gets the body_plain_text of this EmailActionMutable.
        Optional text to send as the text/plain part of the email. If this field is not set for an email action, the Action service converts the value from the body field to text and sends that as the text/plain part when invoking the action. You can use a template in this field.
        """
        return self._attrs.get("bodyPlainText")

    @body_plain_text.setter
    def body_plain_text(self, body_plain_text: "str"):
        """Sets the body_plain_text of this EmailActionMutable.

        Optional text to send as the text/plain part of the email. If this field is not set for an email action, the Action service converts the value from the body field to text and sends that as the text/plain part when invoking the action. You can use a template in this field.

        :param body_plain_text: The body_plain_text of this EmailActionMutable.
        :type: str
        """
        self._attrs["bodyPlainText"] = body_plain_text

    @property
    def from_name(self) -> "str":
        """ Gets the from_name of this EmailActionMutable.
        Optional text providing a human-friendly name for the sender. Must be less than or equal to 81 characters. You can use a template in this field.
        """
        return self._attrs.get("fromName")

    @from_name.setter
    def from_name(self, from_name: "str"):
        """Sets the from_name of this EmailActionMutable.

        Optional text providing a human-friendly name for the sender. Must be less than or equal to 81 characters. You can use a template in this field.

        :param from_name: The from_name of this EmailActionMutable.
        :type: str
        """
        self._attrs["fromName"] = from_name

    @property
    def members(self) -> "List[str]":
        """ Gets the members of this EmailActionMutable.
        An array of tenant member names, whose profile email addresses will be included as recipients.
        """
        return self._attrs.get("members")

    @members.setter
    def members(self, members: "List[str]"):
        """Sets the members of this EmailActionMutable.

        An array of tenant member names, whose profile email addresses will be included as recipients.

        :param members: The members of this EmailActionMutable.
        :type: List[str]
        """
        self._attrs["members"] = members

    @property
    def subject(self) -> "str":
        """ Gets the subject of this EmailActionMutable.
        The subject of the email. You can use a template in this field.
        """
        return self._attrs.get("subject")

    @subject.setter
    def subject(self, subject: "str"):
        """Sets the subject of this EmailActionMutable.

        The subject of the email. You can use a template in this field.

        :param subject: The subject of this EmailActionMutable.
        :type: str
        """
        self._attrs["subject"] = subject

    @property
    def title(self) -> "str":
        """ Gets the title of this EmailActionMutable.
        A human-readable title for the action. Must be less than or equal to 128 characters.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this EmailActionMutable.

        A human-readable title for the action. Must be less than or equal to 128 characters.

        :param title: The title of this EmailActionMutable.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PublicWebhookKey(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PublicWebhookKey":
        instance = PublicWebhookKey.__new__(PublicWebhookKey)
        instance._attrs = model
        return instance

    def __init__(self, key: "str", **extra):
        """PublicWebhookKey"""

        self._attrs = dict()
        if key is not None:
            self._attrs["key"] = key
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def key(self) -> "str":
        """ Gets the key of this PublicWebhookKey.
        A PEM-formatted, ASN.1 DER-encoded PKCS#1 key.
        """
        return self._attrs.get("key")

    @key.setter
    def key(self, key: "str"):
        """Sets the key of this PublicWebhookKey.

        A PEM-formatted, ASN.1 DER-encoded PKCS#1 key.

        :param key: The key of this PublicWebhookKey.
        :type: str
        """
        if key is None:
            raise ValueError("Invalid value for `key`, must not be `None`")
        self._attrs["key"] = key

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ServiceError(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ServiceError":
        instance = ServiceError.__new__(ServiceError)
        instance._attrs = model
        return instance

    def __init__(self, code: "str", message: "str", details: "object" = None, more_info: "str" = None, **extra):
        """ServiceError"""

        self._attrs = dict()
        if code is not None:
            self._attrs["code"] = code
        if message is not None:
            self._attrs["message"] = message
        if details is not None:
            self._attrs["details"] = details
        if more_info is not None:
            self._attrs["moreInfo"] = more_info
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def code(self) -> "str":
        """ Gets the code of this ServiceError.
        """
        return self._attrs.get("code")

    @code.setter
    def code(self, code: "str"):
        """Sets the code of this ServiceError.


        :param code: The code of this ServiceError.
        :type: str
        """
        if code is None:
            raise ValueError("Invalid value for `code`, must not be `None`")
        self._attrs["code"] = code

    @property
    def message(self) -> "str":
        """ Gets the message of this ServiceError.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this ServiceError.


        :param message: The message of this ServiceError.
        :type: str
        """
        if message is None:
            raise ValueError("Invalid value for `message`, must not be `None`")
        self._attrs["message"] = message

    @property
    def details(self) -> "dict":
        """ Gets the details of this ServiceError.
        """
        return self._attrs.get("details")

    @details.setter
    def details(self, details: "dict"):
        """Sets the details of this ServiceError.


        :param details: The details of this ServiceError.
        :type: object
        """
        self._attrs["details"] = details

    @property
    def more_info(self) -> "str":
        """ Gets the more_info of this ServiceError.
        """
        return self._attrs.get("moreInfo")

    @more_info.setter
    def more_info(self, more_info: "str"):
        """Sets the more_info of this ServiceError.


        :param more_info: The more_info of this ServiceError.
        :type: str
        """
        self._attrs["moreInfo"] = more_info

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TriggerEventActionMetadata(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TriggerEventActionMetadata":
        instance = TriggerEventActionMetadata.__new__(TriggerEventActionMetadata)
        instance._attrs = model
        return instance

    def __init__(self, addresses: "List[str]" = None, members: "List[str]" = None, **extra):
        """TriggerEventActionMetadata"""

        self._attrs = dict()
        if addresses is not None:
            self._attrs["addresses"] = addresses
        if members is not None:
            self._attrs["members"] = members
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def addresses(self) -> "List[str]":
        """ Gets the addresses of this TriggerEventActionMetadata.
        An array of email addresses to include as recipients. Requires a special permission set for use. Please DO NOT include actual bouncing emails in automated testing. 
        """
        return self._attrs.get("addresses")

    @addresses.setter
    def addresses(self, addresses: "List[str]"):
        """Sets the addresses of this TriggerEventActionMetadata.

        An array of email addresses to include as recipients. Requires a special permission set for use. Please DO NOT include actual bouncing emails in automated testing. 

        :param addresses: The addresses of this TriggerEventActionMetadata.
        :type: List[str]
        """
        self._attrs["addresses"] = addresses

    @property
    def members(self) -> "List[str]":
        """ Gets the members of this TriggerEventActionMetadata.
        An array of tenant member names, whose profile email addresses will be included as recipients.
        """
        return self._attrs.get("members")

    @members.setter
    def members(self, members: "List[str]"):
        """Sets the members of this TriggerEventActionMetadata.

        An array of tenant member names, whose profile email addresses will be included as recipients.

        :param members: The members of this TriggerEventActionMetadata.
        :type: List[str]
        """
        self._attrs["members"] = members

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TriggerEventKind(str, Enum):
    TRIGGER = "trigger"

    @staticmethod
    def from_value(value: str):
        if value == "trigger":
            return TriggerEventKind.TRIGGER


class TriggerEvent(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TriggerEvent":
        instance = TriggerEvent.__new__(TriggerEvent)
        instance._attrs = model
        return instance

    def __init__(self, action_metadata: "TriggerEventActionMetadata" = None, created_at: "str" = None, created_by: "str" = None, id: "str" = None, kind: "TriggerEventKind" = None, payload: "Dict[str, object]" = None, tenant: "str" = None, trigger_condition: "str" = None, trigger_name: "str" = None, ttl_seconds: "int" = 3600, **extra):
        """TriggerEvent"""

        self._attrs = dict()
        if action_metadata is not None:
            self._attrs["actionMetadata"] = action_metadata.to_dict()
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if payload is not None:
            self._attrs["payload"] = payload
        if tenant is not None:
            self._attrs["tenant"] = tenant
        if trigger_condition is not None:
            self._attrs["triggerCondition"] = trigger_condition
        if trigger_name is not None:
            self._attrs["triggerName"] = trigger_name
        if ttl_seconds is not None:
            self._attrs["ttlSeconds"] = ttl_seconds
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def action_metadata(self) -> "TriggerEventActionMetadata":
        """ Gets the action_metadata of this TriggerEvent.
        """
        return TriggerEventActionMetadata._from_dict(self._attrs["actionMetadata"])

    @action_metadata.setter
    def action_metadata(self, action_metadata: "TriggerEventActionMetadata"):
        """Sets the action_metadata of this TriggerEvent.


        :param action_metadata: The action_metadata of this TriggerEvent.
        :type: TriggerEventActionMetadata
        """
        self._attrs["actionMetadata"] = action_metadata.to_dict()

    @property
    def created_at(self) -> "str":
        """ Gets the created_at of this TriggerEvent.
        string-ified ISO-8601 date/time with zone.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "str"):
        """Sets the created_at of this TriggerEvent.

        string-ified ISO-8601 date/time with zone.

        :param created_at: The created_at of this TriggerEvent.
        :type: str
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this TriggerEvent.
        The principal that generated the trigger event.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this TriggerEvent.

        The principal that generated the trigger event.

        :param created_by: The created_by of this TriggerEvent.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def id(self) -> "str":
        """ Gets the id of this TriggerEvent.
        A unique identifier for this trigger event. Generated from a hash of all recursively-sorted event field values.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this TriggerEvent.

        A unique identifier for this trigger event. Generated from a hash of all recursively-sorted event field values.

        :param id: The id of this TriggerEvent.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "TriggerEventKind":
        """ Gets the kind of this TriggerEvent.
        """
        return TriggerEventKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "TriggerEventKind"):
        """Sets the kind of this TriggerEvent.


        :param kind: The kind of this TriggerEvent.
        :type: TriggerEventKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def payload(self) -> "dict":
        """ Gets the payload of this TriggerEvent.
        """
        return self._attrs.get("payload")

    @payload.setter
    def payload(self, payload: "dict"):
        """Sets the payload of this TriggerEvent.


        :param payload: The payload of this TriggerEvent.
        :type: Dict[str, object]
        """
        self._attrs["payload"] = payload

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this TriggerEvent.
        The tenant within which the trigger event was generated.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this TriggerEvent.

        The tenant within which the trigger event was generated.

        :param tenant: The tenant of this TriggerEvent.
        :type: str
        """
        self._attrs["tenant"] = tenant

    @property
    def trigger_condition(self) -> "str":
        """ Gets the trigger_condition of this TriggerEvent.
        A description of the condition that caused the trigger event.
        """
        return self._attrs.get("triggerCondition")

    @trigger_condition.setter
    def trigger_condition(self, trigger_condition: "str"):
        """Sets the trigger_condition of this TriggerEvent.

        A description of the condition that caused the trigger event.

        :param trigger_condition: The trigger_condition of this TriggerEvent.
        :type: str
        """
        self._attrs["triggerCondition"] = trigger_condition

    @property
    def trigger_name(self) -> "str":
        """ Gets the trigger_name of this TriggerEvent.
        The name of the trigger for which this event was created.
        """
        return self._attrs.get("triggerName")

    @trigger_name.setter
    def trigger_name(self, trigger_name: "str"):
        """Sets the trigger_name of this TriggerEvent.

        The name of the trigger for which this event was created.

        :param trigger_name: The trigger_name of this TriggerEvent.
        :type: str
        """
        self._attrs["triggerName"] = trigger_name

    @property
    def ttl_seconds(self) -> "int":
        """ Gets the ttl_seconds of this TriggerEvent.
        A time to live (TTL), expressed as seconds after createdAt, after which the trigger event will no longer be acted upon.
        """
        return self._attrs.get("ttlSeconds")

    @ttl_seconds.setter
    def ttl_seconds(self, ttl_seconds: "int"):
        """Sets the ttl_seconds of this TriggerEvent.

        A time to live (TTL), expressed as seconds after createdAt, after which the trigger event will no longer be acted upon.

        :param ttl_seconds: The ttl_seconds of this TriggerEvent.
        :type: int
        """
        self._attrs["ttlSeconds"] = ttl_seconds

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WebhookAction(Action):

    @staticmethod
    def _from_dict(model: dict) -> "WebhookAction":
        instance = WebhookAction.__new__(WebhookAction)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", created_at: "datetime" = None, created_by: "str" = None, title: "str" = None, updated_at: "datetime" = None, updated_by: "str" = None, webhook_headers: "Dict[str, List[str]]" = None, webhook_payload: "str" = None, webhook_url: "str" = None, **extra):
        """WebhookAction"""

        self._attrs = dict()
        self._attrs["kind"] = "webhook" 
        if name is not None:
            self._attrs["name"] = name
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if title is not None:
            self._attrs["title"] = title
        if updated_at is not None:
            self._attrs["updatedAt"] = updated_at
        if updated_by is not None:
            self._attrs["updatedBy"] = updated_by
        if webhook_headers is not None:
            self._attrs["webhookHeaders"] = webhook_headers
        if webhook_payload is not None:
            self._attrs["webhookPayload"] = webhook_payload
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "webhook"


    @property
    def name(self) -> "str":
        """ Gets the name of this WebhookAction.
        The name of the action, as one or more identifier strings separated by periods. Each identifier string consists of lowercase letters, digits, and underscores, and cannot start with a digit.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WebhookAction.

        The name of the action, as one or more identifier strings separated by periods. Each identifier string consists of lowercase letters, digits, and underscores, and cannot start with a digit.

        :param name: The name of this WebhookAction.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this WebhookAction.
        The date and time this action template was created (ISO-8601 date/time with zone).
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this WebhookAction.

        The date and time this action template was created (ISO-8601 date/time with zone).

        :param created_at: The created_at of this WebhookAction.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this WebhookAction.
        The principal that created this action template.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this WebhookAction.

        The principal that created this action template.

        :param created_by: The created_by of this WebhookAction.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def title(self) -> "str":
        """ Gets the title of this WebhookAction.
        A human-readable title for the action. Must be less than 128 characters.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this WebhookAction.

        A human-readable title for the action. Must be less than 128 characters.

        :param title: The title of this WebhookAction.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def updated_at(self) -> "datetime":
        """ Gets the updated_at of this WebhookAction.
        The date and time this action template was updated (ISO-8601 date/time with zone).
        """
        return self._attrs.get("updatedAt")

    @updated_at.setter
    def updated_at(self, updated_at: "datetime"):
        """Sets the updated_at of this WebhookAction.

        The date and time this action template was updated (ISO-8601 date/time with zone).

        :param updated_at: The updated_at of this WebhookAction.
        :type: datetime
        """
        self._attrs["updatedAt"] = updated_at

    @property
    def updated_by(self) -> "str":
        """ Gets the updated_by of this WebhookAction.
        The principal that updated this action template.
        """
        return self._attrs.get("updatedBy")

    @updated_by.setter
    def updated_by(self, updated_by: "str"):
        """Sets the updated_by of this WebhookAction.

        The principal that updated this action template.

        :param updated_by: The updated_by of this WebhookAction.
        :type: str
        """
        self._attrs["updatedBy"] = updated_by

    @property
    def webhook_headers(self) -> "Dict[str, List[str]]":
        """ Gets the webhook_headers of this WebhookAction.
        """
        return self._attrs.get("webhookHeaders")

    @webhook_headers.setter
    def webhook_headers(self, webhook_headers: "Dict[str, List[str]]"):
        """Sets the webhook_headers of this WebhookAction.


        :param webhook_headers: The webhook_headers of this WebhookAction.
        :type: Dict[str, List[str]]
        """
        self._attrs["webhookHeaders"] = webhook_headers

    @property
    def webhook_payload(self) -> "str":
        """ Gets the webhook_payload of this WebhookAction.
        The (possibly) templated payload body, which is POSTed to the webhookUrl when invoked. 
        """
        return self._attrs.get("webhookPayload")

    @webhook_payload.setter
    def webhook_payload(self, webhook_payload: "str"):
        """Sets the webhook_payload of this WebhookAction.

        The (possibly) templated payload body, which is POSTed to the webhookUrl when invoked. 

        :param webhook_payload: The webhook_payload of this WebhookAction.
        :type: str
        """
        self._attrs["webhookPayload"] = webhook_payload

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this WebhookAction.
        Only HTTPS is allowed. 
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this WebhookAction.

        Only HTTPS is allowed. 

        :param webhook_url: The webhook_url of this WebhookAction.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Action.from_dict_handlers["webhook"] = WebhookAction._from_dict



class WebhookActionMutable(ActionMutable):

    @staticmethod
    def _from_dict(model: dict) -> "WebhookActionMutable":
        instance = WebhookActionMutable.__new__(WebhookActionMutable)
        instance._attrs = model
        return instance

    def __init__(self, title: "str" = None, webhook_headers: "Dict[str, List[str]]" = None, webhook_payload: "str" = None, webhook_url: "str" = None, **extra):
        """WebhookActionMutable"""

        self._attrs = dict()
        if title is not None:
            self._attrs["title"] = title
        if webhook_headers is not None:
            self._attrs["webhookHeaders"] = webhook_headers
        if webhook_payload is not None:
            self._attrs["webhookPayload"] = webhook_payload
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def title(self) -> "str":
        """ Gets the title of this WebhookActionMutable.
        A human-readable title for the action. Must be less than 128 characters.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this WebhookActionMutable.

        A human-readable title for the action. Must be less than 128 characters.

        :param title: The title of this WebhookActionMutable.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def webhook_headers(self) -> "Dict[str, List[str]]":
        """ Gets the webhook_headers of this WebhookActionMutable.
        """
        return self._attrs.get("webhookHeaders")

    @webhook_headers.setter
    def webhook_headers(self, webhook_headers: "Dict[str, List[str]]"):
        """Sets the webhook_headers of this WebhookActionMutable.


        :param webhook_headers: The webhook_headers of this WebhookActionMutable.
        :type: Dict[str, List[str]]
        """
        self._attrs["webhookHeaders"] = webhook_headers

    @property
    def webhook_payload(self) -> "str":
        """ Gets the webhook_payload of this WebhookActionMutable.
        The (possibly) templated payload body, which is POSTed to the webhookUrl when invoked. 
        """
        return self._attrs.get("webhookPayload")

    @webhook_payload.setter
    def webhook_payload(self, webhook_payload: "str"):
        """Sets the webhook_payload of this WebhookActionMutable.

        The (possibly) templated payload body, which is POSTed to the webhookUrl when invoked. 

        :param webhook_payload: The webhook_payload of this WebhookActionMutable.
        :type: str
        """
        self._attrs["webhookPayload"] = webhook_payload

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this WebhookActionMutable.
        Only HTTPS is allowed. 
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this WebhookActionMutable.

        Only HTTPS is allowed. 

        :param webhook_url: The webhook_url of this WebhookActionMutable.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
