# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: App Registry

    With the App Registry service in Splunk Cloud Services, you can create, update, and manage your apps.

    OpenAPI spec version: v1beta2.0 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class AppName(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "AppName":
        instance = AppName.__new__(AppName)
        instance._attrs = model
        return instance

    def __init__(self, app_name: "str", **extra):
        """AppName"""

        self._attrs = dict()
        if app_name is not None:
            self._attrs["appName"] = app_name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def app_name(self) -> "str":
        """ Gets the app_name of this AppName.
        """
        return self._attrs.get("appName")

    @app_name.setter
    def app_name(self, app_name: "str"):
        """Sets the app_name of this AppName.


        :param app_name: The app_name of this AppName.
        :type: str
        """
        if app_name is None:
            raise ValueError("Invalid value for `app_name`, must not be `None`")
        self._attrs["appName"] = app_name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AppResourceKind(str, Enum):
    WEB = "web"
    NATIVE = "native"
    SERVICE = "service"

    @staticmethod
    def from_value(value: str):
        if value == "web":
            return AppResourceKind.WEB
        if value == "native":
            return AppResourceKind.NATIVE
        if value == "service":
            return AppResourceKind.SERVICE


class AppResponseCreateUpdate(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "AppResponseCreateUpdate":

        def default_handler(model: dict) -> "AppResponseCreateUpdate":
            instance = AppResponseCreateUpdate.__new__(AppResponseCreateUpdate)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = AppResponseCreateUpdate.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, app_principal_permissions: "List[str]" = None, client_id: "str" = None, created_at: "datetime" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, name: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """AppResponseCreateUpdate"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this AppResponseCreateUpdate.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this AppResponseCreateUpdate.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this AppResponseCreateUpdate.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this AppResponseCreateUpdate.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this AppResponseCreateUpdate.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this AppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this AppResponseCreateUpdate.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this AppResponseCreateUpdate.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this AppResponseCreateUpdate.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this AppResponseCreateUpdate.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this AppResponseCreateUpdate.

        The date that the app was created.

        :param created_at: The created_at of this AppResponseCreateUpdate.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def description(self) -> "str":
        """ Gets the description of this AppResponseCreateUpdate.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this AppResponseCreateUpdate.

        Short paragraph describing the app.

        :param description: The description of this AppResponseCreateUpdate.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this AppResponseCreateUpdate.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this AppResponseCreateUpdate.

        The URL used to log in to the app.

        :param login_url: The login_url of this AppResponseCreateUpdate.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this AppResponseCreateUpdate.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this AppResponseCreateUpdate.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this AppResponseCreateUpdate.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this AppResponseCreateUpdate.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this AppResponseCreateUpdate.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this AppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this AppResponseCreateUpdate.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this AppResponseCreateUpdate.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this AppResponseCreateUpdate.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this AppResponseCreateUpdate.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this AppResponseCreateUpdate.

        Human-readable title for the app.

        :param title: The title of this AppResponseCreateUpdate.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this AppResponseCreateUpdate.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this AppResponseCreateUpdate.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this AppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this AppResponseCreateUpdate.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this AppResponseCreateUpdate.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this AppResponseCreateUpdate.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        raise NotImplementedError()


class AppResponseGetList(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "AppResponseGetList":

        def default_handler(model: dict) -> "AppResponseGetList":
            instance = AppResponseGetList.__new__(AppResponseGetList)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = AppResponseGetList.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, app_principal_permissions: "List[str]" = None, client_id: "str" = None, created_at: "datetime" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, name: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """AppResponseGetList"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this AppResponseGetList.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this AppResponseGetList.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this AppResponseGetList.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this AppResponseGetList.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this AppResponseGetList.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this AppResponseGetList.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this AppResponseGetList.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this AppResponseGetList.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this AppResponseGetList.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this AppResponseGetList.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this AppResponseGetList.

        The date that the app was created.

        :param created_at: The created_at of this AppResponseGetList.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def description(self) -> "str":
        """ Gets the description of this AppResponseGetList.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this AppResponseGetList.

        Short paragraph describing the app.

        :param description: The description of this AppResponseGetList.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this AppResponseGetList.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this AppResponseGetList.

        The URL used to log in to the app.

        :param login_url: The login_url of this AppResponseGetList.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this AppResponseGetList.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this AppResponseGetList.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this AppResponseGetList.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this AppResponseGetList.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this AppResponseGetList.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this AppResponseGetList.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this AppResponseGetList.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this AppResponseGetList.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this AppResponseGetList.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this AppResponseGetList.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this AppResponseGetList.

        Human-readable title for the app.

        :param title: The title of this AppResponseGetList.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this AppResponseGetList.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this AppResponseGetList.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this AppResponseGetList.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this AppResponseGetList.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this AppResponseGetList.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this AppResponseGetList.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        raise NotImplementedError()


class CreateAppRequest(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "CreateAppRequest":

        def default_handler(model: dict) -> "CreateAppRequest":
            instance = CreateAppRequest.__new__(CreateAppRequest)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = CreateAppRequest.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, app_principal_permissions: "List[str]" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, name: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """CreateAppRequest"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this CreateAppRequest.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this CreateAppRequest.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this CreateAppRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this CreateAppRequest.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this CreateAppRequest.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this CreateAppRequest.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def description(self) -> "str":
        """ Gets the description of this CreateAppRequest.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this CreateAppRequest.

        Short paragraph describing the app.

        :param description: The description of this CreateAppRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this CreateAppRequest.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this CreateAppRequest.

        The URL used to log in to the app.

        :param login_url: The login_url of this CreateAppRequest.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this CreateAppRequest.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this CreateAppRequest.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this CreateAppRequest.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this CreateAppRequest.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this CreateAppRequest.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this CreateAppRequest.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this CreateAppRequest.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this CreateAppRequest.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this CreateAppRequest.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this CreateAppRequest.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this CreateAppRequest.

        Human-readable title for the app.

        :param title: The title of this CreateAppRequest.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this CreateAppRequest.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this CreateAppRequest.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this CreateAppRequest.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this CreateAppRequest.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this CreateAppRequest.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this CreateAppRequest.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        raise NotImplementedError()


class Error(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Error":
        instance = Error.__new__(Error)
        instance._attrs = model
        return instance

    def __init__(self, code: "str", message: "str", **extra):
        """Error"""

        self._attrs = dict()
        if code is not None:
            self._attrs["code"] = code
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def code(self) -> "str":
        """ Gets the code of this Error.
        """
        return self._attrs.get("code")

    @code.setter
    def code(self, code: "str"):
        """Sets the code of this Error.


        :param code: The code of this Error.
        :type: str
        """
        if code is None:
            raise ValueError("Invalid value for `code`, must not be `None`")
        self._attrs["code"] = code

    @property
    def message(self) -> "str":
        """ Gets the message of this Error.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this Error.


        :param message: The message of this Error.
        :type: str
        """
        if message is None:
            raise ValueError("Invalid value for `message`, must not be `None`")
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Key(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Key":
        instance = Key.__new__(Key)
        instance._attrs = model
        return instance

    def __init__(self, key: "str" = None, **extra):
        """Key"""

        self._attrs = dict()
        if key is not None:
            self._attrs["key"] = key
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def key(self) -> "str":
        """ Gets the key of this Key.
        Public key used for verifying signed webhook requests.
        """
        return self._attrs.get("key")

    @key.setter
    def key(self, key: "str"):
        """Sets the key of this Key.

        Public key used for verifying signed webhook requests.

        :param key: The key of this Key.
        :type: str
        """
        self._attrs["key"] = key

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class NativeAppFromAppResponseCreateUpdate(AppResponseCreateUpdate):

    @staticmethod
    def _from_dict(model: dict) -> "NativeAppFromAppResponseCreateUpdate":
        instance = NativeAppFromAppResponseCreateUpdate.__new__(NativeAppFromAppResponseCreateUpdate)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, client_id: "str" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """NativeAppFromAppResponseCreateUpdate"""

        self._attrs = dict()
        self._attrs["kind"] = "native" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "native"


    @property
    def name(self) -> "str":
        """ Gets the name of this NativeAppFromAppResponseCreateUpdate.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this NativeAppFromAppResponseCreateUpdate.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this NativeAppFromAppResponseCreateUpdate.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this NativeAppFromAppResponseCreateUpdate.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this NativeAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this NativeAppFromAppResponseCreateUpdate.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this NativeAppFromAppResponseCreateUpdate.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this NativeAppFromAppResponseCreateUpdate.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this NativeAppFromAppResponseCreateUpdate.

        The date that the app was created.

        :param created_at: The created_at of this NativeAppFromAppResponseCreateUpdate.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this NativeAppFromAppResponseCreateUpdate.
        The principal who created this app.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this NativeAppFromAppResponseCreateUpdate.

        The principal who created this app.

        :param created_by: The created_by of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this NativeAppFromAppResponseCreateUpdate.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this NativeAppFromAppResponseCreateUpdate.

        Short paragraph describing the app.

        :param description: The description of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this NativeAppFromAppResponseCreateUpdate.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this NativeAppFromAppResponseCreateUpdate.

        The URL used to log in to the app.

        :param login_url: The login_url of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this NativeAppFromAppResponseCreateUpdate.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this NativeAppFromAppResponseCreateUpdate.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this NativeAppFromAppResponseCreateUpdate.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this NativeAppFromAppResponseCreateUpdate.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this NativeAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this NativeAppFromAppResponseCreateUpdate.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this NativeAppFromAppResponseCreateUpdate.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this NativeAppFromAppResponseCreateUpdate.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this NativeAppFromAppResponseCreateUpdate.

        Human-readable title for the app.

        :param title: The title of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this NativeAppFromAppResponseCreateUpdate.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this NativeAppFromAppResponseCreateUpdate.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this NativeAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this NativeAppFromAppResponseCreateUpdate.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this NativeAppFromAppResponseCreateUpdate.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this NativeAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


AppResponseCreateUpdate.from_dict_handlers["native"] = NativeAppFromAppResponseCreateUpdate._from_dict



class NativeAppFromAppResponseGetList(AppResponseGetList):

    @staticmethod
    def _from_dict(model: dict) -> "NativeAppFromAppResponseGetList":
        instance = NativeAppFromAppResponseGetList.__new__(NativeAppFromAppResponseGetList)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, client_id: "str" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """NativeAppFromAppResponseGetList"""

        self._attrs = dict()
        self._attrs["kind"] = "native" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "native"


    @property
    def name(self) -> "str":
        """ Gets the name of this NativeAppFromAppResponseGetList.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this NativeAppFromAppResponseGetList.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this NativeAppFromAppResponseGetList.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this NativeAppFromAppResponseGetList.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this NativeAppFromAppResponseGetList.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this NativeAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this NativeAppFromAppResponseGetList.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this NativeAppFromAppResponseGetList.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this NativeAppFromAppResponseGetList.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this NativeAppFromAppResponseGetList.

        The date that the app was created.

        :param created_at: The created_at of this NativeAppFromAppResponseGetList.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this NativeAppFromAppResponseGetList.
        The principal who created this app.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this NativeAppFromAppResponseGetList.

        The principal who created this app.

        :param created_by: The created_by of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this NativeAppFromAppResponseGetList.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this NativeAppFromAppResponseGetList.

        Short paragraph describing the app.

        :param description: The description of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this NativeAppFromAppResponseGetList.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this NativeAppFromAppResponseGetList.

        The URL used to log in to the app.

        :param login_url: The login_url of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this NativeAppFromAppResponseGetList.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this NativeAppFromAppResponseGetList.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this NativeAppFromAppResponseGetList.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this NativeAppFromAppResponseGetList.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this NativeAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this NativeAppFromAppResponseGetList.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this NativeAppFromAppResponseGetList.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this NativeAppFromAppResponseGetList.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this NativeAppFromAppResponseGetList.

        Human-readable title for the app.

        :param title: The title of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this NativeAppFromAppResponseGetList.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this NativeAppFromAppResponseGetList.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this NativeAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this NativeAppFromAppResponseGetList.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this NativeAppFromAppResponseGetList.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this NativeAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


AppResponseGetList.from_dict_handlers["native"] = NativeAppFromAppResponseGetList._from_dict



class NativeAppPOST(CreateAppRequest):

    @staticmethod
    def _from_dict(model: dict) -> "NativeAppPOST":
        instance = NativeAppPOST.__new__(NativeAppPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """NativeAppPOST"""

        self._attrs = dict()
        self._attrs["kind"] = "native" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "native"


    @property
    def name(self) -> "str":
        """ Gets the name of this NativeAppPOST.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this NativeAppPOST.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this NativeAppPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this NativeAppPOST.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this NativeAppPOST.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this NativeAppPOST.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def description(self) -> "str":
        """ Gets the description of this NativeAppPOST.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this NativeAppPOST.

        Short paragraph describing the app.

        :param description: The description of this NativeAppPOST.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this NativeAppPOST.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this NativeAppPOST.

        The URL used to log in to the app.

        :param login_url: The login_url of this NativeAppPOST.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this NativeAppPOST.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this NativeAppPOST.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this NativeAppPOST.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this NativeAppPOST.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this NativeAppPOST.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this NativeAppPOST.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this NativeAppPOST.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this NativeAppPOST.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this NativeAppPOST.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this NativeAppPOST.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this NativeAppPOST.

        Human-readable title for the app.

        :param title: The title of this NativeAppPOST.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this NativeAppPOST.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this NativeAppPOST.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this NativeAppPOST.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this NativeAppPOST.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this NativeAppPOST.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this NativeAppPOST.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


CreateAppRequest.from_dict_handlers["native"] = NativeAppPOST._from_dict



class ServiceAppFromAppResponseCreateUpdate(AppResponseCreateUpdate):

    @staticmethod
    def _from_dict(model: dict) -> "ServiceAppFromAppResponseCreateUpdate":
        instance = ServiceAppFromAppResponseCreateUpdate.__new__(ServiceAppFromAppResponseCreateUpdate)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, client_id: "str" = None, client_secret: "str" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """ServiceAppFromAppResponseCreateUpdate"""

        self._attrs = dict()
        self._attrs["kind"] = "service" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if client_secret is not None:
            self._attrs["clientSecret"] = client_secret
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "service"


    @property
    def name(self) -> "str":
        """ Gets the name of this ServiceAppFromAppResponseCreateUpdate.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ServiceAppFromAppResponseCreateUpdate.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this ServiceAppFromAppResponseCreateUpdate.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this ServiceAppFromAppResponseCreateUpdate.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this ServiceAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this ServiceAppFromAppResponseCreateUpdate.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this ServiceAppFromAppResponseCreateUpdate.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def client_secret(self) -> "str":
        """ Gets the client_secret of this ServiceAppFromAppResponseCreateUpdate.
        OAuth 2.0 Client Secret string (used for confidential clients).
        """
        return self._attrs.get("clientSecret")

    @client_secret.setter
    def client_secret(self, client_secret: "str"):
        """Sets the client_secret of this ServiceAppFromAppResponseCreateUpdate.

        OAuth 2.0 Client Secret string (used for confidential clients).

        :param client_secret: The client_secret of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["clientSecret"] = client_secret

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this ServiceAppFromAppResponseCreateUpdate.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this ServiceAppFromAppResponseCreateUpdate.

        The date that the app was created.

        :param created_at: The created_at of this ServiceAppFromAppResponseCreateUpdate.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this ServiceAppFromAppResponseCreateUpdate.
        The principal who created this app.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this ServiceAppFromAppResponseCreateUpdate.

        The principal who created this app.

        :param created_by: The created_by of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this ServiceAppFromAppResponseCreateUpdate.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ServiceAppFromAppResponseCreateUpdate.

        Short paragraph describing the app.

        :param description: The description of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this ServiceAppFromAppResponseCreateUpdate.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this ServiceAppFromAppResponseCreateUpdate.

        The URL used to log in to the app.

        :param login_url: The login_url of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this ServiceAppFromAppResponseCreateUpdate.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this ServiceAppFromAppResponseCreateUpdate.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this ServiceAppFromAppResponseCreateUpdate.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this ServiceAppFromAppResponseCreateUpdate.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this ServiceAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this ServiceAppFromAppResponseCreateUpdate.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this ServiceAppFromAppResponseCreateUpdate.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this ServiceAppFromAppResponseCreateUpdate.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this ServiceAppFromAppResponseCreateUpdate.

        Human-readable title for the app.

        :param title: The title of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this ServiceAppFromAppResponseCreateUpdate.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this ServiceAppFromAppResponseCreateUpdate.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this ServiceAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this ServiceAppFromAppResponseCreateUpdate.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this ServiceAppFromAppResponseCreateUpdate.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this ServiceAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


AppResponseCreateUpdate.from_dict_handlers["service"] = ServiceAppFromAppResponseCreateUpdate._from_dict



class ServiceAppFromAppResponseGetList(AppResponseGetList):

    @staticmethod
    def _from_dict(model: dict) -> "ServiceAppFromAppResponseGetList":
        instance = ServiceAppFromAppResponseGetList.__new__(ServiceAppFromAppResponseGetList)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, client_id: "str" = None, client_secret: "str" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """ServiceAppFromAppResponseGetList"""

        self._attrs = dict()
        self._attrs["kind"] = "service" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if client_secret is not None:
            self._attrs["clientSecret"] = client_secret
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "service"


    @property
    def name(self) -> "str":
        """ Gets the name of this ServiceAppFromAppResponseGetList.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ServiceAppFromAppResponseGetList.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this ServiceAppFromAppResponseGetList.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this ServiceAppFromAppResponseGetList.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this ServiceAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this ServiceAppFromAppResponseGetList.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this ServiceAppFromAppResponseGetList.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def client_secret(self) -> "str":
        """ Gets the client_secret of this ServiceAppFromAppResponseGetList.
        OAuth 2.0 Client Secret string (used for confidential clients).
        """
        return self._attrs.get("clientSecret")

    @client_secret.setter
    def client_secret(self, client_secret: "str"):
        """Sets the client_secret of this ServiceAppFromAppResponseGetList.

        OAuth 2.0 Client Secret string (used for confidential clients).

        :param client_secret: The client_secret of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["clientSecret"] = client_secret

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this ServiceAppFromAppResponseGetList.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this ServiceAppFromAppResponseGetList.

        The date that the app was created.

        :param created_at: The created_at of this ServiceAppFromAppResponseGetList.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this ServiceAppFromAppResponseGetList.
        The principal who created this app.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this ServiceAppFromAppResponseGetList.

        The principal who created this app.

        :param created_by: The created_by of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this ServiceAppFromAppResponseGetList.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ServiceAppFromAppResponseGetList.

        Short paragraph describing the app.

        :param description: The description of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this ServiceAppFromAppResponseGetList.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this ServiceAppFromAppResponseGetList.

        The URL used to log in to the app.

        :param login_url: The login_url of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this ServiceAppFromAppResponseGetList.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this ServiceAppFromAppResponseGetList.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this ServiceAppFromAppResponseGetList.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this ServiceAppFromAppResponseGetList.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this ServiceAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this ServiceAppFromAppResponseGetList.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this ServiceAppFromAppResponseGetList.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this ServiceAppFromAppResponseGetList.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this ServiceAppFromAppResponseGetList.

        Human-readable title for the app.

        :param title: The title of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this ServiceAppFromAppResponseGetList.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this ServiceAppFromAppResponseGetList.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this ServiceAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this ServiceAppFromAppResponseGetList.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this ServiceAppFromAppResponseGetList.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this ServiceAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


AppResponseGetList.from_dict_handlers["service"] = ServiceAppFromAppResponseGetList._from_dict



class ServiceAppPOST(CreateAppRequest):

    @staticmethod
    def _from_dict(model: dict) -> "ServiceAppPOST":
        instance = ServiceAppPOST.__new__(ServiceAppPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """ServiceAppPOST"""

        self._attrs = dict()
        self._attrs["kind"] = "service" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "service"


    @property
    def name(self) -> "str":
        """ Gets the name of this ServiceAppPOST.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ServiceAppPOST.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this ServiceAppPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this ServiceAppPOST.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this ServiceAppPOST.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this ServiceAppPOST.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def description(self) -> "str":
        """ Gets the description of this ServiceAppPOST.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ServiceAppPOST.

        Short paragraph describing the app.

        :param description: The description of this ServiceAppPOST.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this ServiceAppPOST.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this ServiceAppPOST.

        The URL used to log in to the app.

        :param login_url: The login_url of this ServiceAppPOST.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this ServiceAppPOST.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this ServiceAppPOST.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this ServiceAppPOST.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this ServiceAppPOST.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this ServiceAppPOST.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this ServiceAppPOST.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this ServiceAppPOST.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this ServiceAppPOST.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this ServiceAppPOST.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this ServiceAppPOST.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this ServiceAppPOST.

        Human-readable title for the app.

        :param title: The title of this ServiceAppPOST.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this ServiceAppPOST.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this ServiceAppPOST.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this ServiceAppPOST.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this ServiceAppPOST.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this ServiceAppPOST.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this ServiceAppPOST.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


CreateAppRequest.from_dict_handlers["service"] = ServiceAppPOST._from_dict



class Subscription(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Subscription":
        instance = Subscription.__new__(Subscription)
        instance._attrs = model
        return instance

    def __init__(self, app_name: "str", created_at: "datetime", created_by: "str", description: "str", login_url: "str", logo_url: "str", title: "str", tenant: "str" = None, **extra):
        """Subscription"""

        self._attrs = dict()
        if app_name is not None:
            self._attrs["appName"] = app_name
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if title is not None:
            self._attrs["title"] = title
        if tenant is not None:
            self._attrs["tenant"] = tenant
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def app_name(self) -> "str":
        """ Gets the app_name of this Subscription.
        App name.
        """
        return self._attrs.get("appName")

    @app_name.setter
    def app_name(self, app_name: "str"):
        """Sets the app_name of this Subscription.

        App name.

        :param app_name: The app_name of this Subscription.
        :type: str
        """
        if app_name is None:
            raise ValueError("Invalid value for `app_name`, must not be `None`")
        self._attrs["appName"] = app_name

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this Subscription.
        Time of subscription creation (UTC).
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this Subscription.

        Time of subscription creation (UTC).

        :param created_at: The created_at of this Subscription.
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this Subscription.
        The user who created the subscription.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this Subscription.

        The user who created the subscription.

        :param created_by: The created_by of this Subscription.
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this Subscription.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Subscription.

        Short paragraph describing the app.

        :param description: The description of this Subscription.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this Subscription.
        URL used to login to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this Subscription.

        URL used to login to the app.

        :param login_url: The login_url of this Subscription.
        :type: str
        """
        if login_url is None:
            raise ValueError("Invalid value for `login_url`, must not be `None`")
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this Subscription.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this Subscription.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this Subscription.
        :type: str
        """
        if logo_url is None:
            raise ValueError("Invalid value for `logo_url`, must not be `None`")
        self._attrs["logoUrl"] = logo_url

    @property
    def title(self) -> "str":
        """ Gets the title of this Subscription.
        Human-readable name for the application.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this Subscription.

        Human-readable name for the application.

        :param title: The title of this Subscription.
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")
        self._attrs["title"] = title

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this Subscription.
        The tenant that is subscribed to the app.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this Subscription.

        The tenant that is subscribed to the app.

        :param tenant: The tenant of this Subscription.
        :type: str
        """
        self._attrs["tenant"] = tenant

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UpdateAppRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UpdateAppRequest":
        instance = UpdateAppRequest.__new__(UpdateAppRequest)
        instance._attrs = model
        return instance

    def __init__(self, app_principal_permissions: "List[str]" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """UpdateAppRequest"""

        self._attrs = dict()
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this UpdateAppRequest.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this UpdateAppRequest.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this UpdateAppRequest.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def description(self) -> "str":
        """ Gets the description of this UpdateAppRequest.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this UpdateAppRequest.

        Short paragraph describing the app.

        :param description: The description of this UpdateAppRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this UpdateAppRequest.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this UpdateAppRequest.

        The URL used to log in to the app.

        :param login_url: The login_url of this UpdateAppRequest.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this UpdateAppRequest.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this UpdateAppRequest.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this UpdateAppRequest.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this UpdateAppRequest.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this UpdateAppRequest.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this UpdateAppRequest.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this UpdateAppRequest.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this UpdateAppRequest.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this UpdateAppRequest.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this UpdateAppRequest.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this UpdateAppRequest.

        Human-readable title for the app.

        :param title: The title of this UpdateAppRequest.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this UpdateAppRequest.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this UpdateAppRequest.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this UpdateAppRequest.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this UpdateAppRequest.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this UpdateAppRequest.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this UpdateAppRequest.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WebAppFromAppResponseCreateUpdate(AppResponseCreateUpdate):

    @staticmethod
    def _from_dict(model: dict) -> "WebAppFromAppResponseCreateUpdate":
        instance = WebAppFromAppResponseCreateUpdate.__new__(WebAppFromAppResponseCreateUpdate)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, client_id: "str" = None, client_secret: "str" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """WebAppFromAppResponseCreateUpdate"""

        self._attrs = dict()
        self._attrs["kind"] = "web" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if client_secret is not None:
            self._attrs["clientSecret"] = client_secret
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "web"


    @property
    def name(self) -> "str":
        """ Gets the name of this WebAppFromAppResponseCreateUpdate.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WebAppFromAppResponseCreateUpdate.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this WebAppFromAppResponseCreateUpdate.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this WebAppFromAppResponseCreateUpdate.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this WebAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this WebAppFromAppResponseCreateUpdate.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this WebAppFromAppResponseCreateUpdate.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def client_secret(self) -> "str":
        """ Gets the client_secret of this WebAppFromAppResponseCreateUpdate.
        OAuth 2.0 Client Secret string (used for confidential clients).
        """
        return self._attrs.get("clientSecret")

    @client_secret.setter
    def client_secret(self, client_secret: "str"):
        """Sets the client_secret of this WebAppFromAppResponseCreateUpdate.

        OAuth 2.0 Client Secret string (used for confidential clients).

        :param client_secret: The client_secret of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["clientSecret"] = client_secret

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this WebAppFromAppResponseCreateUpdate.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this WebAppFromAppResponseCreateUpdate.

        The date that the app was created.

        :param created_at: The created_at of this WebAppFromAppResponseCreateUpdate.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this WebAppFromAppResponseCreateUpdate.
        The principal who created this app.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this WebAppFromAppResponseCreateUpdate.

        The principal who created this app.

        :param created_by: The created_by of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this WebAppFromAppResponseCreateUpdate.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WebAppFromAppResponseCreateUpdate.

        Short paragraph describing the app.

        :param description: The description of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this WebAppFromAppResponseCreateUpdate.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this WebAppFromAppResponseCreateUpdate.

        The URL used to log in to the app.

        :param login_url: The login_url of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this WebAppFromAppResponseCreateUpdate.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this WebAppFromAppResponseCreateUpdate.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this WebAppFromAppResponseCreateUpdate.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this WebAppFromAppResponseCreateUpdate.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this WebAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this WebAppFromAppResponseCreateUpdate.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this WebAppFromAppResponseCreateUpdate.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this WebAppFromAppResponseCreateUpdate.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this WebAppFromAppResponseCreateUpdate.

        Human-readable title for the app.

        :param title: The title of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this WebAppFromAppResponseCreateUpdate.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this WebAppFromAppResponseCreateUpdate.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this WebAppFromAppResponseCreateUpdate.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this WebAppFromAppResponseCreateUpdate.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this WebAppFromAppResponseCreateUpdate.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this WebAppFromAppResponseCreateUpdate.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


AppResponseCreateUpdate.from_dict_handlers["web"] = WebAppFromAppResponseCreateUpdate._from_dict



class WebAppFromAppResponseGetList(AppResponseGetList):

    @staticmethod
    def _from_dict(model: dict) -> "WebAppFromAppResponseGetList":
        instance = WebAppFromAppResponseGetList.__new__(WebAppFromAppResponseGetList)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", app_principal_permissions: "List[str]" = None, client_id: "str" = None, client_secret: "str" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, login_url: "str" = None, logo_url: "str" = None, redirect_urls: "List[str]" = None, setup_url: "str" = None, title: "str" = None, user_permissions_filter: "List[str]" = None, webhook_url: "str" = None, **extra):
        """WebAppFromAppResponseGetList"""

        self._attrs = dict()
        self._attrs["kind"] = "web" 
        if name is not None:
            self._attrs["name"] = name
        if app_principal_permissions is not None:
            self._attrs["appPrincipalPermissions"] = app_principal_permissions
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if client_secret is not None:
            self._attrs["clientSecret"] = client_secret
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if login_url is not None:
            self._attrs["loginUrl"] = login_url
        if logo_url is not None:
            self._attrs["logoUrl"] = logo_url
        if redirect_urls is not None:
            self._attrs["redirectUrls"] = redirect_urls
        if setup_url is not None:
            self._attrs["setupUrl"] = setup_url
        if title is not None:
            self._attrs["title"] = title
        if user_permissions_filter is not None:
            self._attrs["userPermissionsFilter"] = user_permissions_filter
        if webhook_url is not None:
            self._attrs["webhookUrl"] = webhook_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> str:
        return "web"


    @property
    def name(self) -> "str":
        """ Gets the name of this WebAppFromAppResponseGetList.
        App name that is unique within Splunk Cloud Platform.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WebAppFromAppResponseGetList.

        App name that is unique within Splunk Cloud Platform.

        :param name: The name of this WebAppFromAppResponseGetList.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def app_principal_permissions(self) -> "List[str]":
        """ Gets the app_principal_permissions of this WebAppFromAppResponseGetList.
        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.
        """
        return self._attrs.get("appPrincipalPermissions")

    @app_principal_permissions.setter
    def app_principal_permissions(self, app_principal_permissions: "List[str]"):
        """Sets the app_principal_permissions of this WebAppFromAppResponseGetList.

        Array of permission templates that are used to grant permission to the app principal when a tenant subscribes.

        :param app_principal_permissions: The app_principal_permissions of this WebAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["appPrincipalPermissions"] = app_principal_permissions

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this WebAppFromAppResponseGetList.
        OAuth 2.0 Client ID.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this WebAppFromAppResponseGetList.

        OAuth 2.0 Client ID.

        :param client_id: The client_id of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["clientId"] = client_id

    @property
    def client_secret(self) -> "str":
        """ Gets the client_secret of this WebAppFromAppResponseGetList.
        OAuth 2.0 Client Secret string (used for confidential clients).
        """
        return self._attrs.get("clientSecret")

    @client_secret.setter
    def client_secret(self, client_secret: "str"):
        """Sets the client_secret of this WebAppFromAppResponseGetList.

        OAuth 2.0 Client Secret string (used for confidential clients).

        :param client_secret: The client_secret of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["clientSecret"] = client_secret

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this WebAppFromAppResponseGetList.
        The date that the app was created.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this WebAppFromAppResponseGetList.

        The date that the app was created.

        :param created_at: The created_at of this WebAppFromAppResponseGetList.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this WebAppFromAppResponseGetList.
        The principal who created this app.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this WebAppFromAppResponseGetList.

        The principal who created this app.

        :param created_by: The created_by of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this WebAppFromAppResponseGetList.
        Short paragraph describing the app.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WebAppFromAppResponseGetList.

        Short paragraph describing the app.

        :param description: The description of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def login_url(self) -> "str":
        """ Gets the login_url of this WebAppFromAppResponseGetList.
        The URL used to log in to the app.
        """
        return self._attrs.get("loginUrl")

    @login_url.setter
    def login_url(self, login_url: "str"):
        """Sets the login_url of this WebAppFromAppResponseGetList.

        The URL used to log in to the app.

        :param login_url: The login_url of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["loginUrl"] = login_url

    @property
    def logo_url(self) -> "str":
        """ Gets the logo_url of this WebAppFromAppResponseGetList.
        The URL used to display the app's logo.
        """
        return self._attrs.get("logoUrl")

    @logo_url.setter
    def logo_url(self, logo_url: "str"):
        """Sets the logo_url of this WebAppFromAppResponseGetList.

        The URL used to display the app's logo.

        :param logo_url: The logo_url of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["logoUrl"] = logo_url

    @property
    def redirect_urls(self) -> "List[str]":
        """ Gets the redirect_urls of this WebAppFromAppResponseGetList.
        Array of URLs that can be used for redirect after logging into the app.
        """
        return self._attrs.get("redirectUrls")

    @redirect_urls.setter
    def redirect_urls(self, redirect_urls: "List[str]"):
        """Sets the redirect_urls of this WebAppFromAppResponseGetList.

        Array of URLs that can be used for redirect after logging into the app.

        :param redirect_urls: The redirect_urls of this WebAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["redirectUrls"] = redirect_urls

    @property
    def setup_url(self) -> "str":
        """ Gets the setup_url of this WebAppFromAppResponseGetList.
        URL to redirect to after a subscription is created.
        """
        return self._attrs.get("setupUrl")

    @setup_url.setter
    def setup_url(self, setup_url: "str"):
        """Sets the setup_url of this WebAppFromAppResponseGetList.

        URL to redirect to after a subscription is created.

        :param setup_url: The setup_url of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["setupUrl"] = setup_url

    @property
    def title(self) -> "str":
        """ Gets the title of this WebAppFromAppResponseGetList.
        Human-readable title for the app.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this WebAppFromAppResponseGetList.

        Human-readable title for the app.

        :param title: The title of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def user_permissions_filter(self) -> "List[str]":
        """ Gets the user_permissions_filter of this WebAppFromAppResponseGetList.
        Array of permission filter templates that are used to intersect with a user's permissions when using the app.
        """
        return self._attrs.get("userPermissionsFilter")

    @user_permissions_filter.setter
    def user_permissions_filter(self, user_permissions_filter: "List[str]"):
        """Sets the user_permissions_filter of this WebAppFromAppResponseGetList.

        Array of permission filter templates that are used to intersect with a user's permissions when using the app.

        :param user_permissions_filter: The user_permissions_filter of this WebAppFromAppResponseGetList.
        :type: List[str]
        """
        self._attrs["userPermissionsFilter"] = user_permissions_filter

    @property
    def webhook_url(self) -> "str":
        """ Gets the webhook_url of this WebAppFromAppResponseGetList.
        URL that webhook events are sent to.
        """
        return self._attrs.get("webhookUrl")

    @webhook_url.setter
    def webhook_url(self, webhook_url: "str"):
        """Sets the webhook_url of this WebAppFromAppResponseGetList.

        URL that webhook events are sent to.

        :param webhook_url: The webhook_url of this WebAppFromAppResponseGetList.
        :type: str
        """
        self._attrs["webhookUrl"] = webhook_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


AppResponseGetList.from_dict_handlers["web"] = WebAppFromAppResponseGetList._from_dict

