# coding: utf-8

# Copyright © 2020 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Metadata Catalog

    With the Metadata Catalog you can create and manage knowledge objects such as datasets, fields, rules, actions, dashboards, and workflows.

    OpenAPI spec version: v2alpha2.6 
    Generated by: https://openapi-generator.tech
"""


from requests import Response
from string import Template
from typing import List, Dict

from splunk_sdk.base_client import handle_response
from splunk_sdk.base_service import BaseService
from splunk_sdk.common.sscmodel import SSCModel, SSCVoidModel

from splunk_sdk.catalog.v2alpha2.gen_models import Action
from splunk_sdk.catalog.v2alpha2.gen_models import ActionPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import ActionPOST
from splunk_sdk.catalog.v2alpha2.gen_models import Annotation
from splunk_sdk.catalog.v2alpha2.gen_models import AnnotationPOST
from splunk_sdk.catalog.v2alpha2.gen_models import Dashboard
from splunk_sdk.catalog.v2alpha2.gen_models import DashboardPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import DashboardPOST
from splunk_sdk.catalog.v2alpha2.gen_models import Dataset
from splunk_sdk.catalog.v2alpha2.gen_models import DatasetImportedBy
from splunk_sdk.catalog.v2alpha2.gen_models import DatasetPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import DatasetPOST
from splunk_sdk.catalog.v2alpha2.gen_models import Field
from splunk_sdk.catalog.v2alpha2.gen_models import FieldPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import FieldPOST
from splunk_sdk.catalog.v2alpha2.gen_models import Module
from splunk_sdk.catalog.v2alpha2.gen_models import Relationship
from splunk_sdk.catalog.v2alpha2.gen_models import RelationshipPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import RelationshipPOST
from splunk_sdk.catalog.v2alpha2.gen_models import Rule
from splunk_sdk.catalog.v2alpha2.gen_models import RulePATCH
from splunk_sdk.catalog.v2alpha2.gen_models import RulePOST
from splunk_sdk.catalog.v2alpha2.gen_models import Workflow
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowBuild
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowBuildPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowBuildPOST
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowPOST
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowRun
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowRunPATCH
from splunk_sdk.catalog.v2alpha2.gen_models import WorkflowRunPOST


class MetadataCatalog(BaseService):
    """
    Metadata Catalog
    Version: v2alpha2.6
    With the Metadata Catalog you can create and manage knowledge objects such as datasets, fields, rules, actions, dashboards, and workflows.
    """

    def __init__(self, base_client):
        super().__init__(base_client)

    def create_action_for_rule(self, ruleresourcename: str, action_post: ActionPOST, query_params: Dict[str, object] = None) -> Action:
        """
        Create a new action for a rule associated with a specific resource name.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleresourcename": ruleresourcename,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}/actions").substitute(path_params)
        url = self.base_client.build_url(path)
        data = action_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Action)

    def create_action_for_rule_by_id(self, ruleid: str, action_post: ActionPOST, query_params: Dict[str, object] = None) -> Action:
        """
        Create a new action for a specific rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleid": ruleid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}/actions").substitute(path_params)
        url = self.base_client.build_url(path)
        data = action_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Action)

    def create_annotation_for_dashboardby_id(self, dashboardid: str, annotation_post: AnnotationPOST, query_params: Dict[str, object] = None) -> Annotation:
        """
        Create a new annotation for a specific dashboard.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardid": dashboardid,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardid}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        data = annotation_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Annotation)

    def create_annotation_for_dashboards_by_resource_name(self, dashboardresourcename: str, annotation_post: AnnotationPOST, query_params: Dict[str, object] = None) -> Annotation:
        """
        Create a new annotation for a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardresourcename": dashboardresourcename,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardresourcename}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        data = annotation_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Annotation)

    def create_annotation_for_dataset_by_id(self, datasetid: str, annotation_post: AnnotationPOST, query_params: Dict[str, object] = None) -> Annotation:
        """
        Create a new annotation for a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        data = annotation_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Annotation)

    def create_annotation_for_dataset_by_resource_name(self, datasetresourcename: str, annotation_post: AnnotationPOST, query_params: Dict[str, object] = None) -> Annotation:
        """
        Create a new annotation for a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        data = annotation_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Annotation)

    def create_dashboard(self, dashboard_post: DashboardPOST, query_params: Dict[str, object] = None) -> Dashboard:
        """
        Create a new dashboard.
        """
        if query_params is None:
            query_params = {}

        path_params = {
        }

        path = Template("/catalog/v2alpha2/dashboards").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dashboard_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Dashboard)

    def create_dataset(self, dataset_post: DatasetPOST, query_params: Dict[str, object] = None) -> Dataset:
        """
        Create a new dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
        }

        path = Template("/catalog/v2alpha2/datasets").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dataset_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Dataset)

    def create_dataset_import(self, datasetresourcename: str, dataset_imported_by: DatasetImportedBy = None, query_params: Dict[str, object] = None) -> Dataset:
        """
        Create a new dataset import.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/imported-by").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dataset_imported_by.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Dataset)

    def create_dataset_import_by_id(self, datasetid: str, dataset_imported_by: DatasetImportedBy = None, query_params: Dict[str, object] = None) -> DatasetImportedBy:
        """
        Create a new dataset import.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/imported-by").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dataset_imported_by.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, DatasetImportedBy)

    def create_dataset_import_by_idv1(self, datasetid: str, dataset_imported_by: DatasetImportedBy = None, query_params: Dict[str, object] = None) -> DatasetImportedBy:
        """
        Create a new dataset import.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/importedby").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dataset_imported_by.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, DatasetImportedBy)

    def create_dataset_importv1(self, datasetresourcename: str, dataset_imported_by: DatasetImportedBy = None, query_params: Dict[str, object] = None) -> Dataset:
        """
        Create a new dataset import.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/importedby").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dataset_imported_by.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Dataset)

    def create_field_for_dataset(self, datasetresourcename: str, field_post: FieldPOST, query_params: Dict[str, object] = None) -> Field:
        """
        Create a new field on a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/fields").substitute(path_params)
        url = self.base_client.build_url(path)
        data = field_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Field)

    def create_field_for_dataset_by_id(self, datasetid: str, field_post: FieldPOST, query_params: Dict[str, object] = None) -> Field:
        """
        Add a new field to a dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/fields").substitute(path_params)
        url = self.base_client.build_url(path)
        data = field_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Field)

    def create_relationship(self, relationship_post: RelationshipPOST, query_params: Dict[str, object] = None) -> Relationship:
        """
        Create a new relationship.
        """
        if query_params is None:
            query_params = {}

        path_params = {
        }

        path = Template("/catalog/v2alpha2/relationships").substitute(path_params)
        url = self.base_client.build_url(path)
        data = relationship_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Relationship)

    def create_rule(self, rule_post: RulePOST, query_params: Dict[str, object] = None) -> Rule:
        """
        Create a new rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
        }

        path = Template("/catalog/v2alpha2/rules").substitute(path_params)
        url = self.base_client.build_url(path)
        data = rule_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Rule)

    def create_workflow(self, workflow_post: WorkflowPOST, query_params: Dict[str, object] = None) -> Workflow:
        """
        Create a new workflow configuration.
        """
        if query_params is None:
            query_params = {}

        path_params = {
        }

        path = Template("/catalog/v2alpha2/workflows").substitute(path_params)
        url = self.base_client.build_url(path)
        data = workflow_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Workflow)

    def create_workflow_build(self, workflowid: str, workflow_build_post: WorkflowBuildPOST, query_params: Dict[str, object] = None) -> WorkflowBuild:
        """
        Create a new workflow build.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds").substitute(path_params)
        url = self.base_client.build_url(path)
        data = workflow_build_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, WorkflowBuild)

    def create_workflow_run(self, workflowid: str, workflowbuildid: str, workflow_run_post: WorkflowRunPOST, query_params: Dict[str, object] = None) -> WorkflowRun:
        """
        Create a new workflow run for the specified workflow build ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}/runs").substitute(path_params)
        url = self.base_client.build_url(path)
        data = workflow_run_post.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, WorkflowRun)

    def delete_action_by_id_for_rule(self, ruleresourcename: str, actionid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete an action on a rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleresourcename": ruleresourcename,
            "actionid": actionid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}/actions/${actionid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_action_by_id_for_rule_by_id(self, ruleid: str, actionid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete an action that is part of a specific rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleid": ruleid,
            "actionid": actionid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}/actions/${actionid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_annotation_of_dashboard_by_id(self, dashboardid: str, annotationid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a specific annotation of a dashboard.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardid": dashboardid,
            "annotationid": annotationid,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardid}/annotations/${annotationid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_annotation_of_dashboard_by_resource_name(self, dashboardresourcename: str, annotationid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a specific annotation of a dashboard.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardresourcename": dashboardresourcename,
            "annotationid": annotationid,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardresourcename}/annotations/${annotationid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_annotation_of_dataset_by_id(self, datasetid: str, annotationid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a specific annotation of a dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
            "annotationid": annotationid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/annotations/${annotationid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_annotation_of_dataset_by_resource_name(self, datasetresourcename: str, annotationid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a specific annotation of a dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
            "annotationid": annotationid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/annotations/${annotationid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_dashboard_by_id(self, dashboardid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete the dashboard with the specified ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardid": dashboardid,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_dashboard_by_resource_name(self, dashboardresourcename: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete the dashboard with the specified resource name.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardresourcename": dashboardresourcename,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_dataset(self, datasetresourcename: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete the dataset with the specified resource name, along with its dependencies. For the default module, the resource name format is datasetName. Otherwise, the resource name format is module.datasetName.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_dataset_by_id(self, datasetid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a specific dataset. Deleting a dataset also deletes its dependent objects, such as fields.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_field_by_id_for_dataset(self, datasetresourcename: str, fieldid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a field that is part of a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
            "fieldid": fieldid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/fields/${fieldid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_field_by_id_for_dataset_by_id(self, datasetid: str, fieldid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a field that is part of a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
            "fieldid": fieldid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/fields/${fieldid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_relationship_by_id(self, relationshipid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a specific relationship. Deleting a relationship also deleletes any objects that are dependents of that relationship, such as relationship fields.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "relationshipid": relationshipid,
        }

        path = Template("/catalog/v2alpha2/relationships/${relationshipid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_rule(self, ruleresourcename: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete the rule with the specified resource name and its dependencies.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleresourcename": ruleresourcename,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_rule_by_id(self, ruleid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete a specific rule. Deleting a rule also deleletes any objects that are dependents of that rule, such as rule actions.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleid": ruleid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_workflow_build_by_id(self, workflowid: str, workflowbuildid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete the workflow build with the specified workflow build ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_workflow_by_id(self, workflowid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete the workflow with the specified workflow ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_workflow_run_by_id(self, workflowid: str, workflowbuildid: str, workflowrunid: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Delete the workflow run with the specified workflow run ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
            "workflowrunid": workflowrunid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}/runs/${workflowrunid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def get_action_by_id_for_rule(self, ruleresourcename: str, actionid: str, query_params: Dict[str, object] = None) -> Action:
        """
        Return an action that is part of a specified rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleresourcename": ruleresourcename,
            "actionid": actionid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}/actions/${actionid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Action)

    def get_action_by_id_for_rule_by_id(self, ruleid: str, actionid: str, query_params: Dict[str, object] = None) -> Action:
        """
        Return information about an action that is part of a specific rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleid": ruleid,
            "actionid": actionid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}/actions/${actionid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Action)

    def get_dashboard_by_id(self, dashboardid: str, query_params: Dict[str, object] = None) -> Dashboard:
        """
        Return information about a dashboard with the specified ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardid": dashboardid,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Dashboard)

    def get_dashboard_by_resource_name(self, dashboardresourcename: str, query_params: Dict[str, object] = None) -> Dashboard:
        """
        Return information about a dashboard with the specified resource name.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardresourcename": dashboardresourcename,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Dashboard)

    def get_dataset(self, datasetresourcename: str, maxstale: int = None, query_params: Dict[str, object] = None) -> Dataset:
        """
        Return the dataset with the specified resource name. For the default module, the resource name format is datasetName. Otherwise, the resource name format is module.datasetName.
        """
        if query_params is None:
            query_params = {}
        if maxstale is not None:
            query_params['maxstale'] = maxstale

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Dataset)

    def get_dataset_by_id(self, datasetid: str, maxstale: int = None, query_params: Dict[str, object] = None) -> Dataset:
        """
        Return information about the dataset with the specified ID.
        """
        if query_params is None:
            query_params = {}
        if maxstale is not None:
            query_params['maxstale'] = maxstale

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Dataset)

    def get_field_by_id(self, fieldid: str, query_params: Dict[str, object] = None) -> Field:
        """
        Get a field that corresponds to a specific field ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "fieldid": fieldid,
        }

        path = Template("/catalog/v2alpha2/fields/${fieldid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Field)

    def get_field_by_id_for_dataset(self, datasetresourcename: str, fieldid: str, query_params: Dict[str, object] = None) -> Field:
        """
        Return a field that is part of a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
            "fieldid": fieldid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/fields/${fieldid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Field)

    def get_field_by_id_for_dataset_by_id(self, datasetid: str, fieldid: str, query_params: Dict[str, object] = None) -> Field:
        """
        Return a field that is part of a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
            "fieldid": fieldid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/fields/${fieldid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Field)

    def get_relationship_by_id(self, relationshipid: str, query_params: Dict[str, object] = None) -> Relationship:
        """
        Get a specific relationship.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "relationshipid": relationshipid,
        }

        path = Template("/catalog/v2alpha2/relationships/${relationshipid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Relationship)

    def get_rule(self, ruleresourcename: str, query_params: Dict[str, object] = None) -> Rule:
        """
        Get a rule with a specified resource name.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleresourcename": ruleresourcename,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Rule)

    def get_rule_by_id(self, ruleid: str, query_params: Dict[str, object] = None) -> Rule:
        """
        Get information about a specific rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleid": ruleid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Rule)

    def get_workflow_build_by_id(self, workflowid: str, workflowbuildid: str, query_params: Dict[str, object] = None) -> WorkflowBuild:
        """
        Return information about the workflow build with the specified workflow build ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, WorkflowBuild)

    def get_workflow_by_id(self, workflowid: str, query_params: Dict[str, object] = None) -> Workflow:
        """
        Return information about a workflow with the specified workflow ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Workflow)

    def get_workflow_run_by_id(self, workflowid: str, workflowbuildid: str, workflowrunid: str, query_params: Dict[str, object] = None) -> WorkflowRun:
        """
        Return information about the workflow run with the specified workflow build ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
            "workflowrunid": workflowrunid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}/runs/${workflowrunid}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, WorkflowRun)

    def list_actions_for_rule(self, ruleresourcename: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Action]:
        """
        Return the list of actions that are part of a specified rule.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "ruleresourcename": ruleresourcename,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}/actions").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Action)

    def list_actions_for_rule_by_id(self, ruleid: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Action]:
        """
        Return the set of actions that are part of a rule.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "ruleid": ruleid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}/actions").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Action)

    def list_annotations(self, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Annotation]:
        """
        Return the set of annotations across all objects.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
        }

        path = Template("/catalog/v2beta1/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Annotation)

    def list_annotations_for_dashboard_by_id(self, dashboardid: str, filter: str = None, query_params: Dict[str, object] = None) -> List[Annotation]:
        """
        Return the set of annotations that are part of a dashboard.
        """
        if query_params is None:
            query_params = {}
        if filter is not None:
            query_params['filter'] = filter

        path_params = {
            "dashboardid": dashboardid,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardid}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Annotation)

    def list_annotations_for_dashboard_by_resource_name(self, dashboardresourcename: str, filter: str = None, query_params: Dict[str, object] = None) -> List[Annotation]:
        """
        Return the set of annotations that are part of a dashboard.
        """
        if query_params is None:
            query_params = {}
        if filter is not None:
            query_params['filter'] = filter

        path_params = {
            "dashboardresourcename": dashboardresourcename,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardresourcename}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Annotation)

    def list_annotations_for_dataset_by_id(self, datasetid: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Annotation]:
        """
        Return the set of annotations that are part of a dataset.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Annotation)

    def list_annotations_for_dataset_by_resource_name(self, datasetresourcename: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Annotation]:
        """
        Return the set of annotations that are part of a dataset.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/annotations").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Annotation)

    def list_dashboards(self, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Dashboard]:
        """
        Return a list of Dashboards.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
        }

        path = Template("/catalog/v2alpha2/dashboards").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Dashboard)

    def list_datasets(self, count: int = None, filter: str = None, maxstale: int = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Dataset]:
        """
        Returns a list of all datasets, unless you specify a filter. Use a filter to return a specific list of datasets.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if maxstale is not None:
            query_params['maxstale'] = maxstale
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
        }

        path = Template("/catalog/v2alpha2/datasets").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Dataset)

    def list_fields(self, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Field]:
        """
        Get a list of all fields in the Catalog.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
        }

        path = Template("/catalog/v2alpha2/fields").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Field)

    def list_fields_for_dataset(self, datasetresourcename: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Field]:
        """
        Return the list of fields that are part of a specified dataset.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/fields").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Field)

    def list_fields_for_dataset_by_id(self, datasetid: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Field]:
        """
        Return the set of fields for the specified dataset.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/fields").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Field)

    def list_modules(self, filter: str = None, query_params: Dict[str, object] = None) -> List[Module]:
        """
        Return a list of all modules, unless you specify a filter. Use a filter to return a specific list of modules.
        """
        if query_params is None:
            query_params = {}
        if filter is not None:
            query_params['filter'] = filter

        path_params = {
        }

        path = Template("/catalog/v2alpha2/modules").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Module)

    def list_relationships(self, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Relationship]:
        """
        Returns a list of all relationships, unless you specify a filter. Use a filter to return a specific list of relationships.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
        }

        path = Template("/catalog/v2alpha2/relationships").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Relationship)

    def list_rules(self, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Rule]:
        """
        Return a list of rules that match a filter query if it is given, otherwise return all rules.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
        }

        path = Template("/catalog/v2alpha2/rules").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Rule)

    def list_workflow_builds(self, workflowid: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[WorkflowBuild]:
        """
        Return a list of Machine Learning workflow builds.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "workflowid": workflowid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, WorkflowBuild)

    def list_workflow_runs(self, workflowid: str, workflowbuildid: str, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[WorkflowRun]:
        """
        Return a list of Machine Learning workflow runs for specified workflow build ID.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}/runs").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, WorkflowRun)

    def list_workflows(self, count: int = None, filter: str = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[Workflow]:
        """
        Return a list of Machine Learning workflow configurations.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if filter is not None:
            query_params['filter'] = filter
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
        }

        path = Template("/catalog/v2alpha2/workflows").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, Workflow)

    def update_action_by_id_for_rule(self, ruleresourcename: str, actionid: str, action_patch: ActionPATCH, query_params: Dict[str, object] = None) -> Action:
        """
        Update the Action with the specified id for the specified Rule
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleresourcename": ruleresourcename,
            "actionid": actionid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}/actions/${actionid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = action_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Action)

    def update_action_by_id_for_rule_by_id(self, ruleid: str, actionid: str, action_patch: ActionPATCH, query_params: Dict[str, object] = None) -> Action:
        """
        Update an action for a specific rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleid": ruleid,
            "actionid": actionid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}/actions/${actionid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = action_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Action)

    def update_dashboard_by_id(self, dashboardid: str, dashboard_patch: DashboardPATCH, query_params: Dict[str, object] = None) -> Dashboard:
        """
        Update the dashboard with the specified ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardid": dashboardid,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dashboard_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Dashboard)

    def update_dashboard_by_resource_name(self, dashboardresourcename: str, dashboard_patch: DashboardPATCH, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Update the dashboard with the specified resource name.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "dashboardresourcename": dashboardresourcename,
        }

        path = Template("/catalog/v2alpha2/dashboards/${dashboardresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dashboard_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, )

    def update_dataset(self, datasetresourcename: str, dataset_patch: DatasetPATCH, query_params: Dict[str, object] = None) -> Dataset:
        """
        Update the dataset with the specified resource name. For the default module, the resource name format is datasetName. Otherwise, the resource name format is module.datasetName.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dataset_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Dataset)

    def update_dataset_by_id(self, datasetid: str, dataset_patch: DatasetPATCH, query_params: Dict[str, object] = None) -> Dataset:
        """
        Update a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = dataset_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Dataset)

    def update_field_by_id_for_dataset(self, datasetresourcename: str, fieldid: str, field_patch: FieldPATCH, query_params: Dict[str, object] = None) -> Field:
        """
        Update a field with a specified ID for a specified dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetresourcename": datasetresourcename,
            "fieldid": fieldid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetresourcename}/fields/${fieldid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = field_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Field)

    def update_field_by_id_for_dataset_by_id(self, datasetid: str, fieldid: str, field_patch: FieldPATCH, query_params: Dict[str, object] = None) -> Field:
        """
        Update a field for a specific dataset.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "datasetid": datasetid,
            "fieldid": fieldid,
        }

        path = Template("/catalog/v2alpha2/datasets/${datasetid}/fields/${fieldid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = field_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Field)

    def update_relationship_by_id(self, relationshipid: str, relationship_patch: RelationshipPATCH, query_params: Dict[str, object] = None) -> Relationship:
        """
        Update a specific relationship.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "relationshipid": relationshipid,
        }

        path = Template("/catalog/v2alpha2/relationships/${relationshipid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = relationship_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Relationship)

    def update_rule(self, ruleresourcename: str, rule_patch: RulePATCH, query_params: Dict[str, object] = None) -> Rule:
        """
        Update the Rule with the specified resourcename
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleresourcename": ruleresourcename,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleresourcename}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = rule_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Rule)

    def update_rule_by_id(self, ruleid: str, rule_patch: RulePATCH, query_params: Dict[str, object] = None) -> Rule:
        """
        Update a specific rule.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "ruleid": ruleid,
        }

        path = Template("/catalog/v2alpha2/rules/${ruleid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = rule_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, Rule)

    def update_workflow_build_by_id(self, workflowid: str, workflowbuildid: str, workflow_build_patch: WorkflowBuildPATCH, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Update the workflow build with the specified workflow build ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = workflow_build_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, )

    def update_workflow_by_id(self, workflowid: str, workflow_patch: WorkflowPATCH, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Update the workflow with the specified workflow ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = workflow_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, )

    def update_workflow_run_by_id(self, workflowid: str, workflowbuildid: str, workflowrunid: str, workflow_run_patch: WorkflowRunPATCH, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Update the workflow run with the specified workflow run ID.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "workflowid": workflowid,
            "workflowbuildid": workflowbuildid,
            "workflowrunid": workflowrunid,
        }

        path = Template("/catalog/v2alpha2/workflows/${workflowid}/builds/${workflowbuildid}/runs/${workflowrunid}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = workflow_run_patch.to_dict()
        response = self.base_client.patch(url, json=data, params=query_params)
        return handle_response(response, )


