# Copyright © 2020 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Metadata Catalog service

    With the Metadata Catalog in Splunk Cloud Services you can create and manage knowledge objects such as datasets, fields, rules, actions, dashboards, and workflows.

    OpenAPI spec version: v2beta1.4 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class Action(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "Action":

        def default_handler(model: dict) -> "Action":
            instance = Action.__new__(Action)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = Action.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, created: "datetime" = None, createdby: "str" = None, id: "str" = None, modified: "datetime" = None, modifiedby: "str" = None, owner: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """Action"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if id is not None:
            self._attrs["id"] = id
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Action.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Action.

        The date and time object was created.

        :param created: The created of this Action.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Action.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Action.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Action.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Action.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Action.

        The date and time object was modified.

        :param modified: The modified of this Action.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Action.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Action.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Action.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Action.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Action.

        The name of the object's owner.

        :param owner: The owner of this Action.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Action.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Action.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Action.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Action.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Action.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Action.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def id(self) -> "str":
        """ Gets the id of this Action.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Action.

        A unique action ID.

        :param id: The id of this Action.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this Action.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this Action.

        The rule that this action is part of.

        :param ruleid: The ruleid of this Action.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this Action.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Action.

        The catalog version.

        :param version: The version of this Action.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        raise NotImplementedError()


class ActionPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ActionPATCH":
        instance = ActionPATCH.__new__(ActionPATCH)
        instance._attrs = model
        return instance

    def __init__(self, owner: "str" = None, version: "int" = None, **extra):
        """ActionPATCH"""

        self._attrs = dict()
        if owner is not None:
            self._attrs["owner"] = owner
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def owner(self) -> "str":
        """ Gets the owner of this ActionPATCH.
        The name of the user who owns this action. This value is obtained from the bearer token if not present.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this ActionPATCH.

        The name of the user who owns this action. This value is obtained from the bearer token if not present.

        :param owner: The owner of this ActionPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def version(self) -> "int":
        """ Gets the version of this ActionPATCH.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ActionPATCH.

        The catalog version.

        :param version: The version of this ActionPATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ActionPOST(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "ActionPOST":

        def default_handler(model: dict) -> "ActionPOST":
            instance = ActionPOST.__new__(ActionPOST)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = ActionPOST.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, id: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """ActionPOST"""

        self._attrs = dict()
        if id is not None:
            self._attrs["id"] = id
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def id(self) -> "str":
        """ Gets the id of this ActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ActionPOST.

        A unique action ID.

        :param id: The id of this ActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this ActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this ActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this ActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this ActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ActionPOST.

        The catalog version.

        :param version: The version of this ActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        raise NotImplementedError()


class AliasActionFromAction(Action):

    @staticmethod
    def _from_dict(model: dict) -> "AliasActionFromAction":
        instance = AliasActionFromAction.__new__(AliasActionFromAction)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", alias: "str" = None, appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, field: "str" = None, id: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """AliasActionFromAction"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if alias is not None:
            self._attrs["alias"] = alias
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "ALIAS" 
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this AliasActionFromAction.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this AliasActionFromAction.

        The date and time object was created.

        :param created: The created of this AliasActionFromAction.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this AliasActionFromAction.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this AliasActionFromAction.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this AliasActionFromAction.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this AliasActionFromAction.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this AliasActionFromAction.

        The date and time object was modified.

        :param modified: The modified of this AliasActionFromAction.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this AliasActionFromAction.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this AliasActionFromAction.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this AliasActionFromAction.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this AliasActionFromAction.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this AliasActionFromAction.

        The name of the object's owner.

        :param owner: The owner of this AliasActionFromAction.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def alias(self) -> "str":
        """ Gets the alias of this AliasActionFromAction.
        The alias name.
        """
        return self._attrs.get("alias")

    @alias.setter
    def alias(self, alias: "str"):
        """Sets the alias of this AliasActionFromAction.

        The alias name.

        :param alias: The alias of this AliasActionFromAction.
        :type: str
        """
        self._attrs["alias"] = alias

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this AliasActionFromAction.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this AliasActionFromAction.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this AliasActionFromAction.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this AliasActionFromAction.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this AliasActionFromAction.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this AliasActionFromAction.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def field(self) -> "str":
        """ Gets the field of this AliasActionFromAction.
        The name of the field to be aliased.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this AliasActionFromAction.

        The name of the field to be aliased.

        :param field: The field of this AliasActionFromAction.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this AliasActionFromAction.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this AliasActionFromAction.

        A unique action ID.

        :param id: The id of this AliasActionFromAction.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "ALIAS"


    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this AliasActionFromAction.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this AliasActionFromAction.

        The rule that this action is part of.

        :param ruleid: The ruleid of this AliasActionFromAction.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this AliasActionFromAction.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AliasActionFromAction.

        The catalog version.

        :param version: The version of this AliasActionFromAction.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Action.from_dict_handlers["ALIAS"] = AliasActionFromAction._from_dict



class AliasActionFromActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "AliasActionFromActionPOST":
        instance = AliasActionFromActionPOST.__new__(AliasActionFromActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", alias: "str" = None, appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, field: "str" = None, id: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """AliasActionFromActionPOST"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if alias is not None:
            self._attrs["alias"] = alias
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "ALIAS" 
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this AliasActionFromActionPOST.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this AliasActionFromActionPOST.

        The date and time object was created.

        :param created: The created of this AliasActionFromActionPOST.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this AliasActionFromActionPOST.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this AliasActionFromActionPOST.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this AliasActionFromActionPOST.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this AliasActionFromActionPOST.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this AliasActionFromActionPOST.

        The date and time object was modified.

        :param modified: The modified of this AliasActionFromActionPOST.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this AliasActionFromActionPOST.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this AliasActionFromActionPOST.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this AliasActionFromActionPOST.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this AliasActionFromActionPOST.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this AliasActionFromActionPOST.

        The name of the object's owner.

        :param owner: The owner of this AliasActionFromActionPOST.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def alias(self) -> "str":
        """ Gets the alias of this AliasActionFromActionPOST.
        The alias name.
        """
        return self._attrs.get("alias")

    @alias.setter
    def alias(self, alias: "str"):
        """Sets the alias of this AliasActionFromActionPOST.

        The alias name.

        :param alias: The alias of this AliasActionFromActionPOST.
        :type: str
        """
        self._attrs["alias"] = alias

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this AliasActionFromActionPOST.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this AliasActionFromActionPOST.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this AliasActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this AliasActionFromActionPOST.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this AliasActionFromActionPOST.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this AliasActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def field(self) -> "str":
        """ Gets the field of this AliasActionFromActionPOST.
        The name of the field to be aliased.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this AliasActionFromActionPOST.

        The name of the field to be aliased.

        :param field: The field of this AliasActionFromActionPOST.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this AliasActionFromActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this AliasActionFromActionPOST.

        A unique action ID.

        :param id: The id of this AliasActionFromActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "ALIAS"


    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this AliasActionFromActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this AliasActionFromActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this AliasActionFromActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this AliasActionFromActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AliasActionFromActionPOST.

        The catalog version.

        :param version: The version of this AliasActionFromActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


ActionPOST.from_dict_handlers["ALIAS"] = AliasActionFromActionPOST._from_dict



class AliasActionKind(str, Enum):
    ALIAS = "ALIAS"

    @staticmethod
    def from_value(value: str):
        if value == "ALIAS":
            return AliasActionKind.ALIAS


class AliasActionPATCH(ActionPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "AliasActionPATCH":
        instance = AliasActionPATCH.__new__(AliasActionPATCH)
        instance._attrs = model
        return instance

    def __init__(self, alias: "str" = None, field: "str" = None, kind: "AliasActionKind" = None, owner: "str" = None, version: "int" = None, **extra):
        """AliasActionPATCH"""

        self._attrs = dict()
        if alias is not None:
            self._attrs["alias"] = alias
        if field is not None:
            self._attrs["field"] = field
        if kind is not None:
            self._attrs["kind"] = kind
        if owner is not None:
            self._attrs["owner"] = owner
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def alias(self) -> "str":
        """ Gets the alias of this AliasActionPATCH.
        The alias name.
        """
        return self._attrs.get("alias")

    @alias.setter
    def alias(self, alias: "str"):
        """Sets the alias of this AliasActionPATCH.

        The alias name.

        :param alias: The alias of this AliasActionPATCH.
        :type: str
        """
        self._attrs["alias"] = alias

    @property
    def field(self) -> "str":
        """ Gets the field of this AliasActionPATCH.
        The name of the field to be aliased.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this AliasActionPATCH.

        The name of the field to be aliased.

        :param field: The field of this AliasActionPATCH.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def kind(self) -> "AliasActionKind":
        """ Gets the kind of this AliasActionPATCH.
        """
        return AliasActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "AliasActionKind"):
        """Sets the kind of this AliasActionPATCH.


        :param kind: The kind of this AliasActionPATCH.
        :type: AliasActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def owner(self) -> "str":
        """ Gets the owner of this AliasActionPATCH.
        The name of the user who owns this action. This value is obtained from the bearer token if not present.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this AliasActionPATCH.

        The name of the user who owns this action. This value is obtained from the bearer token if not present.

        :param owner: The owner of this AliasActionPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def version(self) -> "int":
        """ Gets the version of this AliasActionPATCH.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AliasActionPATCH.

        The catalog version.

        :param version: The version of this AliasActionPATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AliasActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "AliasActionPOST":
        instance = AliasActionPOST.__new__(AliasActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, alias: "str" = None, field: "str" = None, id: "str" = None, kind: "AliasActionKind" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """AliasActionPOST"""

        self._attrs = dict()
        if alias is not None:
            self._attrs["alias"] = alias
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def alias(self) -> "str":
        """ Gets the alias of this AliasActionPOST.
        The alias name.
        """
        return self._attrs.get("alias")

    @alias.setter
    def alias(self, alias: "str"):
        """Sets the alias of this AliasActionPOST.

        The alias name.

        :param alias: The alias of this AliasActionPOST.
        :type: str
        """
        self._attrs["alias"] = alias

    @property
    def field(self) -> "str":
        """ Gets the field of this AliasActionPOST.
        The name of the field to be aliased.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this AliasActionPOST.

        The name of the field to be aliased.

        :param field: The field of this AliasActionPOST.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this AliasActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this AliasActionPOST.

        A unique action ID.

        :param id: The id of this AliasActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "AliasActionKind":
        """ Gets the kind of this AliasActionPOST.
        """
        return AliasActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "AliasActionKind"):
        """Sets the kind of this AliasActionPOST.


        :param kind: The kind of this AliasActionPOST.
        :type: AliasActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this AliasActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this AliasActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this AliasActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this AliasActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AliasActionPOST.

        The catalog version.

        :param version: The version of this AliasActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Annotation(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Annotation":
        instance = Annotation.__new__(Annotation)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", annotationtypeid: "str" = None, appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, dashboardid: "str" = None, datasetid: "str" = None, fieldid: "str" = None, id: "str" = None, relationshipid: "str" = None, **extra):
        """Annotation"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if annotationtypeid is not None:
            self._attrs["annotationtypeid"] = annotationtypeid
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if dashboardid is not None:
            self._attrs["dashboardid"] = dashboardid
        if datasetid is not None:
            self._attrs["datasetid"] = datasetid
        if fieldid is not None:
            self._attrs["fieldid"] = fieldid
        if id is not None:
            self._attrs["id"] = id
        if relationshipid is not None:
            self._attrs["relationshipid"] = relationshipid
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Annotation.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Annotation.

        The date and time object was created.

        :param created: The created of this Annotation.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Annotation.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Annotation.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Annotation.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Annotation.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Annotation.

        The date and time object was modified.

        :param modified: The modified of this Annotation.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Annotation.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Annotation.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Annotation.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Annotation.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Annotation.

        The name of the object's owner.

        :param owner: The owner of this Annotation.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def annotationtypeid(self) -> "str":
        """ Gets the annotationtypeid of this Annotation.
        The annotation type ID.
        """
        return self._attrs.get("annotationtypeid")

    @annotationtypeid.setter
    def annotationtypeid(self, annotationtypeid: "str"):
        """Sets the annotationtypeid of this Annotation.

        The annotation type ID.

        :param annotationtypeid: The annotationtypeid of this Annotation.
        :type: str
        """
        self._attrs["annotationtypeid"] = annotationtypeid

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Annotation.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Annotation.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Annotation.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Annotation.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Annotation.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Annotation.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def dashboardid(self) -> "str":
        """ Gets the dashboardid of this Annotation.
        The dashboard ID.
        """
        return self._attrs.get("dashboardid")

    @dashboardid.setter
    def dashboardid(self, dashboardid: "str"):
        """Sets the dashboardid of this Annotation.

        The dashboard ID.

        :param dashboardid: The dashboardid of this Annotation.
        :type: str
        """
        self._attrs["dashboardid"] = dashboardid

    @property
    def datasetid(self) -> "str":
        """ Gets the datasetid of this Annotation.
        The dataset ID. Null if not annotating a dataset.
        """
        return self._attrs.get("datasetid")

    @datasetid.setter
    def datasetid(self, datasetid: "str"):
        """Sets the datasetid of this Annotation.

        The dataset ID. Null if not annotating a dataset.

        :param datasetid: The datasetid of this Annotation.
        :type: str
        """
        self._attrs["datasetid"] = datasetid

    @property
    def fieldid(self) -> "str":
        """ Gets the fieldid of this Annotation.
        The field ID. Null if not annotating a field.
        """
        return self._attrs.get("fieldid")

    @fieldid.setter
    def fieldid(self, fieldid: "str"):
        """Sets the fieldid of this Annotation.

        The field ID. Null if not annotating a field.

        :param fieldid: The fieldid of this Annotation.
        :type: str
        """
        self._attrs["fieldid"] = fieldid

    @property
    def id(self) -> "str":
        """ Gets the id of this Annotation.
        A unique annotation ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Annotation.

        A unique annotation ID.

        :param id: The id of this Annotation.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def relationshipid(self) -> "str":
        """ Gets the relationshipid of this Annotation.
        The relationship ID. Null if not annotating a relationship.
        """
        return self._attrs.get("relationshipid")

    @relationshipid.setter
    def relationshipid(self, relationshipid: "str"):
        """Sets the relationshipid of this Annotation.

        The relationship ID. Null if not annotating a relationship.

        :param relationshipid: The relationshipid of this Annotation.
        :type: str
        """
        self._attrs["relationshipid"] = relationshipid

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AnnotationPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "AnnotationPOST":
        instance = AnnotationPOST.__new__(AnnotationPOST)
        instance._attrs = model
        return instance

    def __init__(self, annotationtypeid: "str" = None, annotationtyperesourcename: "str" = None, dashboardid: "str" = None, datasetid: "str" = None, fieldid: "str" = None, id: "str" = None, relationshipid: "str" = None, **extra):
        """AnnotationPOST"""

        self._attrs = dict()
        if annotationtypeid is not None:
            self._attrs["annotationtypeid"] = annotationtypeid
        if annotationtyperesourcename is not None:
            self._attrs["annotationtyperesourcename"] = annotationtyperesourcename
        if dashboardid is not None:
            self._attrs["dashboardid"] = dashboardid
        if datasetid is not None:
            self._attrs["datasetid"] = datasetid
        if fieldid is not None:
            self._attrs["fieldid"] = fieldid
        if id is not None:
            self._attrs["id"] = id
        if relationshipid is not None:
            self._attrs["relationshipid"] = relationshipid
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def annotationtypeid(self) -> "str":
        """ Gets the annotationtypeid of this AnnotationPOST.
        The annotation type ID.
        """
        return self._attrs.get("annotationtypeid")

    @annotationtypeid.setter
    def annotationtypeid(self, annotationtypeid: "str"):
        """Sets the annotationtypeid of this AnnotationPOST.

        The annotation type ID.

        :param annotationtypeid: The annotationtypeid of this AnnotationPOST.
        :type: str
        """
        self._attrs["annotationtypeid"] = annotationtypeid

    @property
    def annotationtyperesourcename(self) -> "str":
        """ Gets the annotationtyperesourcename of this AnnotationPOST.
        Resource name of the annotation type
        """
        return self._attrs.get("annotationtyperesourcename")

    @annotationtyperesourcename.setter
    def annotationtyperesourcename(self, annotationtyperesourcename: "str"):
        """Sets the annotationtyperesourcename of this AnnotationPOST.

        Resource name of the annotation type

        :param annotationtyperesourcename: The annotationtyperesourcename of this AnnotationPOST.
        :type: str
        """
        self._attrs["annotationtyperesourcename"] = annotationtyperesourcename

    @property
    def dashboardid(self) -> "str":
        """ Gets the dashboardid of this AnnotationPOST.
        The dashboard ID.
        """
        return self._attrs.get("dashboardid")

    @dashboardid.setter
    def dashboardid(self, dashboardid: "str"):
        """Sets the dashboardid of this AnnotationPOST.

        The dashboard ID.

        :param dashboardid: The dashboardid of this AnnotationPOST.
        :type: str
        """
        self._attrs["dashboardid"] = dashboardid

    @property
    def datasetid(self) -> "str":
        """ Gets the datasetid of this AnnotationPOST.
        The dataset ID. Null if not annotating a dataset.
        """
        return self._attrs.get("datasetid")

    @datasetid.setter
    def datasetid(self, datasetid: "str"):
        """Sets the datasetid of this AnnotationPOST.

        The dataset ID. Null if not annotating a dataset.

        :param datasetid: The datasetid of this AnnotationPOST.
        :type: str
        """
        self._attrs["datasetid"] = datasetid

    @property
    def fieldid(self) -> "str":
        """ Gets the fieldid of this AnnotationPOST.
        The field ID. Null if not annotating a field.
        """
        return self._attrs.get("fieldid")

    @fieldid.setter
    def fieldid(self, fieldid: "str"):
        """Sets the fieldid of this AnnotationPOST.

        The field ID. Null if not annotating a field.

        :param fieldid: The fieldid of this AnnotationPOST.
        :type: str
        """
        self._attrs["fieldid"] = fieldid

    @property
    def id(self) -> "str":
        """ Gets the id of this AnnotationPOST.
        A unique annotation ID. If not specified, an auto generated ID is created.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this AnnotationPOST.

        A unique annotation ID. If not specified, an auto generated ID is created.

        :param id: The id of this AnnotationPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def relationshipid(self) -> "str":
        """ Gets the relationshipid of this AnnotationPOST.
        The relationship ID. Null if not annotating a relationship.
        """
        return self._attrs.get("relationshipid")

    @relationshipid.setter
    def relationshipid(self, relationshipid: "str"):
        """Sets the relationshipid of this AnnotationPOST.

        The relationship ID. Null if not annotating a relationship.

        :param relationshipid: The relationshipid of this AnnotationPOST.
        :type: str
        """
        self._attrs["relationshipid"] = relationshipid

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AutoKVActionFromAction(Action):

    @staticmethod
    def _from_dict(model: dict) -> "AutoKVActionFromAction":
        instance = AutoKVActionFromAction.__new__(AutoKVActionFromAction)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, id: "str" = None, mode: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """AutoKVActionFromAction"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "AUTOKV" 
        if mode is not None:
            self._attrs["mode"] = mode
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this AutoKVActionFromAction.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this AutoKVActionFromAction.

        The date and time object was created.

        :param created: The created of this AutoKVActionFromAction.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this AutoKVActionFromAction.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this AutoKVActionFromAction.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this AutoKVActionFromAction.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this AutoKVActionFromAction.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this AutoKVActionFromAction.

        The date and time object was modified.

        :param modified: The modified of this AutoKVActionFromAction.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this AutoKVActionFromAction.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this AutoKVActionFromAction.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this AutoKVActionFromAction.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this AutoKVActionFromAction.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this AutoKVActionFromAction.

        The name of the object's owner.

        :param owner: The owner of this AutoKVActionFromAction.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this AutoKVActionFromAction.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this AutoKVActionFromAction.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this AutoKVActionFromAction.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this AutoKVActionFromAction.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this AutoKVActionFromAction.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this AutoKVActionFromAction.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def id(self) -> "str":
        """ Gets the id of this AutoKVActionFromAction.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this AutoKVActionFromAction.

        A unique action ID.

        :param id: The id of this AutoKVActionFromAction.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "AUTOKV"


    @property
    def mode(self) -> "str":
        """ Gets the mode of this AutoKVActionFromAction.
        The autokv action mode.
        """
        return self._attrs.get("mode")

    @mode.setter
    def mode(self, mode: "str"):
        """Sets the mode of this AutoKVActionFromAction.

        The autokv action mode.

        :param mode: The mode of this AutoKVActionFromAction.
        :type: str
        """
        self._attrs["mode"] = mode

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this AutoKVActionFromAction.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this AutoKVActionFromAction.

        The rule that this action is part of.

        :param ruleid: The ruleid of this AutoKVActionFromAction.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this AutoKVActionFromAction.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AutoKVActionFromAction.

        The catalog version.

        :param version: The version of this AutoKVActionFromAction.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Action.from_dict_handlers["AUTOKV"] = AutoKVActionFromAction._from_dict



class AutoKVActionFromActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "AutoKVActionFromActionPOST":
        instance = AutoKVActionFromActionPOST.__new__(AutoKVActionFromActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, id: "str" = None, mode: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """AutoKVActionFromActionPOST"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "AUTOKV" 
        if mode is not None:
            self._attrs["mode"] = mode
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this AutoKVActionFromActionPOST.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this AutoKVActionFromActionPOST.

        The date and time object was created.

        :param created: The created of this AutoKVActionFromActionPOST.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this AutoKVActionFromActionPOST.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this AutoKVActionFromActionPOST.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this AutoKVActionFromActionPOST.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this AutoKVActionFromActionPOST.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this AutoKVActionFromActionPOST.

        The date and time object was modified.

        :param modified: The modified of this AutoKVActionFromActionPOST.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this AutoKVActionFromActionPOST.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this AutoKVActionFromActionPOST.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this AutoKVActionFromActionPOST.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this AutoKVActionFromActionPOST.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this AutoKVActionFromActionPOST.

        The name of the object's owner.

        :param owner: The owner of this AutoKVActionFromActionPOST.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this AutoKVActionFromActionPOST.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this AutoKVActionFromActionPOST.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this AutoKVActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this AutoKVActionFromActionPOST.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this AutoKVActionFromActionPOST.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this AutoKVActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def id(self) -> "str":
        """ Gets the id of this AutoKVActionFromActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this AutoKVActionFromActionPOST.

        A unique action ID.

        :param id: The id of this AutoKVActionFromActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "AUTOKV"


    @property
    def mode(self) -> "str":
        """ Gets the mode of this AutoKVActionFromActionPOST.
        The autokv action mode.
        """
        return self._attrs.get("mode")

    @mode.setter
    def mode(self, mode: "str"):
        """Sets the mode of this AutoKVActionFromActionPOST.

        The autokv action mode.

        :param mode: The mode of this AutoKVActionFromActionPOST.
        :type: str
        """
        self._attrs["mode"] = mode

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this AutoKVActionFromActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this AutoKVActionFromActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this AutoKVActionFromActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this AutoKVActionFromActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AutoKVActionFromActionPOST.

        The catalog version.

        :param version: The version of this AutoKVActionFromActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


ActionPOST.from_dict_handlers["AUTOKV"] = AutoKVActionFromActionPOST._from_dict



class AutoKVActionKind(str, Enum):
    AUTOKV = "AUTOKV"

    @staticmethod
    def from_value(value: str):
        if value == "AUTOKV":
            return AutoKVActionKind.AUTOKV


class AutoKVActionPATCH(ActionPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "AutoKVActionPATCH":
        instance = AutoKVActionPATCH.__new__(AutoKVActionPATCH)
        instance._attrs = model
        return instance

    def __init__(self, kind: "AutoKVActionKind" = None, mode: "str" = None, owner: "str" = None, version: "int" = None, **extra):
        """AutoKVActionPATCH"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if mode is not None:
            self._attrs["mode"] = mode
        if owner is not None:
            self._attrs["owner"] = owner
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "AutoKVActionKind":
        """ Gets the kind of this AutoKVActionPATCH.
        """
        return AutoKVActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "AutoKVActionKind"):
        """Sets the kind of this AutoKVActionPATCH.


        :param kind: The kind of this AutoKVActionPATCH.
        :type: AutoKVActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def mode(self) -> "str":
        """ Gets the mode of this AutoKVActionPATCH.
        The autokv action mode.
        """
        return self._attrs.get("mode")

    @mode.setter
    def mode(self, mode: "str"):
        """Sets the mode of this AutoKVActionPATCH.

        The autokv action mode.

        :param mode: The mode of this AutoKVActionPATCH.
        :type: str
        """
        self._attrs["mode"] = mode

    @property
    def owner(self) -> "str":
        """ Gets the owner of this AutoKVActionPATCH.
        The name of the user who owns this action. This value is obtained from the bearer token if not present.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this AutoKVActionPATCH.

        The name of the user who owns this action. This value is obtained from the bearer token if not present.

        :param owner: The owner of this AutoKVActionPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def version(self) -> "int":
        """ Gets the version of this AutoKVActionPATCH.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AutoKVActionPATCH.

        The catalog version.

        :param version: The version of this AutoKVActionPATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AutoKVActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "AutoKVActionPOST":
        instance = AutoKVActionPOST.__new__(AutoKVActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, id: "str" = None, kind: "AutoKVActionKind" = None, mode: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """AutoKVActionPOST"""

        self._attrs = dict()
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if mode is not None:
            self._attrs["mode"] = mode
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def id(self) -> "str":
        """ Gets the id of this AutoKVActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this AutoKVActionPOST.

        A unique action ID.

        :param id: The id of this AutoKVActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "AutoKVActionKind":
        """ Gets the kind of this AutoKVActionPOST.
        """
        return AutoKVActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "AutoKVActionKind"):
        """Sets the kind of this AutoKVActionPOST.


        :param kind: The kind of this AutoKVActionPOST.
        :type: AutoKVActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def mode(self) -> "str":
        """ Gets the mode of this AutoKVActionPOST.
        The autokv action mode.
        """
        return self._attrs.get("mode")

    @mode.setter
    def mode(self, mode: "str"):
        """Sets the mode of this AutoKVActionPOST.

        The autokv action mode.

        :param mode: The mode of this AutoKVActionPOST.
        :type: str
        """
        self._attrs["mode"] = mode

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this AutoKVActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this AutoKVActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this AutoKVActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this AutoKVActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this AutoKVActionPOST.

        The catalog version.

        :param version: The version of this AutoKVActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DatasetGet(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "DatasetGet":

        def default_handler(model: dict) -> "DatasetGet":
            instance = DatasetGet.__new__(DatasetGet)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = DatasetGet.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, **extra):
        """DatasetGet"""

        self._attrs = dict()
        for k, v in extra.items():
            self._attrs[k] = v

    def to_dict(self):
        raise NotImplementedError()


class CatalogDataset(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "CatalogDataset":
        instance = CatalogDataset.__new__(CatalogDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, summary: "str" = None, title: "str" = None, url: "str" = None, version: "int" = None, **extra):
        """CatalogDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "catalog" 
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if url is not None:
            self._attrs["url"] = url
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this CatalogDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this CatalogDataset.

        The date and time object was created.

        :param created: The created of this CatalogDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this CatalogDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this CatalogDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this CatalogDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this CatalogDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this CatalogDataset.

        A unique dataset ID.

        :param id: The id of this CatalogDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this CatalogDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this CatalogDataset.

        The date and time object was modified.

        :param modified: The modified of this CatalogDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this CatalogDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this CatalogDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this CatalogDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this CatalogDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this CatalogDataset.

        The name of the module that contains the dataset.

        :param module: The module of this CatalogDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this CatalogDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this CatalogDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this CatalogDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this CatalogDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this CatalogDataset.

        The name of the object's owner.

        :param owner: The owner of this CatalogDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this CatalogDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this CatalogDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this CatalogDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this CatalogDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this CatalogDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this CatalogDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this CatalogDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this CatalogDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this CatalogDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this CatalogDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this CatalogDataset.

        Detailed description of the dataset.

        :param description: The description of this CatalogDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this CatalogDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this CatalogDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this CatalogDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "catalog"


    @property
    def summary(self) -> "str":
        """ Gets the summary of this CatalogDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this CatalogDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this CatalogDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this CatalogDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this CatalogDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this CatalogDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def url(self) -> "str":
        """ Gets the url of this CatalogDataset.
        Internal use only.
        """
        return self._attrs.get("url")

    @url.setter
    def url(self, url: "str"):
        """Sets the url of this CatalogDataset.

        Internal use only.

        :param url: The url of this CatalogDataset.
        :type: str
        """
        self._attrs["url"] = url

    @property
    def version(self) -> "int":
        """ Gets the version of this CatalogDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this CatalogDataset.

        The catalog version.

        :param version: The version of this CatalogDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["catalog"] = CatalogDataset._from_dict



class CatalogDatasetKind(str, Enum):
    CATALOG = "catalog"

    @staticmethod
    def from_value(value: str):
        if value == "catalog":
            return CatalogDatasetKind.CATALOG


class Dashboard(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Dashboard":
        instance = Dashboard.__new__(Dashboard)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, definition: "str" = None, id: "str" = None, isactive: "bool" = None, module: "str" = None, name: "str" = None, version: "int" = None, **extra):
        """Dashboard"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if definition is not None:
            self._attrs["definition"] = definition
        if id is not None:
            self._attrs["id"] = id
        if isactive is not None:
            self._attrs["isactive"] = isactive
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Dashboard.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Dashboard.

        The date and time object was created.

        :param created: The created of this Dashboard.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Dashboard.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Dashboard.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Dashboard.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Dashboard.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Dashboard.

        The date and time object was modified.

        :param modified: The modified of this Dashboard.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Dashboard.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Dashboard.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Dashboard.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Dashboard.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Dashboard.

        The name of the object's owner.

        :param owner: The owner of this Dashboard.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Dashboard.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Dashboard.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Dashboard.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Dashboard.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Dashboard.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Dashboard.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def definition(self) -> "str":
        """ Gets the definition of this Dashboard.
        The JSON dashboard definition.
        """
        return self._attrs.get("definition")

    @definition.setter
    def definition(self, definition: "str"):
        """Sets the definition of this Dashboard.

        The JSON dashboard definition.

        :param definition: The definition of this Dashboard.
        :type: str
        """
        self._attrs["definition"] = definition

    @property
    def id(self) -> "str":
        """ Gets the id of this Dashboard.
        A unique dashboard ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Dashboard.

        A unique dashboard ID. Random ID used if not provided.

        :param id: The id of this Dashboard.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def isactive(self) -> "bool":
        """ Gets the isactive of this Dashboard.
        Whether the dashboard is active or not.
        """
        return self._attrs.get("isactive")

    @isactive.setter
    def isactive(self, isactive: "bool"):
        """Sets the isactive of this Dashboard.

        Whether the dashboard is active or not.

        :param isactive: The isactive of this Dashboard.
        :type: bool
        """
        self._attrs["isactive"] = isactive

    @property
    def module(self) -> "str":
        """ Gets the module of this Dashboard.
        The module that contains the dashboard.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this Dashboard.

        The module that contains the dashboard.

        :param module: The module of this Dashboard.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this Dashboard.
        The dashboard name. Dashboard names must be unique within each tenant.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Dashboard.

        The dashboard name. Dashboard names must be unique within each tenant.

        :param name: The name of this Dashboard.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this Dashboard.
        The version of the dashboard.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Dashboard.

        The version of the dashboard.

        :param version: The version of this Dashboard.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DashboardPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DashboardPATCH":
        instance = DashboardPATCH.__new__(DashboardPATCH)
        instance._attrs = model
        return instance

    def __init__(self, definition: "str" = None, isactive: "bool" = None, module: "str" = None, name: "str" = None, version: "int" = None, **extra):
        """DashboardPATCH"""

        self._attrs = dict()
        if definition is not None:
            self._attrs["definition"] = definition
        if isactive is not None:
            self._attrs["isactive"] = isactive
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def definition(self) -> "str":
        """ Gets the definition of this DashboardPATCH.
        The JSON dashboard definition.
        """
        return self._attrs.get("definition")

    @definition.setter
    def definition(self, definition: "str"):
        """Sets the definition of this DashboardPATCH.

        The JSON dashboard definition.

        :param definition: The definition of this DashboardPATCH.
        :type: str
        """
        self._attrs["definition"] = definition

    @property
    def isactive(self) -> "bool":
        """ Gets the isactive of this DashboardPATCH.
        Whether the dashboard is active or not.
        """
        return self._attrs.get("isactive")

    @isactive.setter
    def isactive(self, isactive: "bool"):
        """Sets the isactive of this DashboardPATCH.

        Whether the dashboard is active or not.

        :param isactive: The isactive of this DashboardPATCH.
        :type: bool
        """
        self._attrs["isactive"] = isactive

    @property
    def module(self) -> "str":
        """ Gets the module of this DashboardPATCH.
        The module that contains the dashboard.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DashboardPATCH.

        The module that contains the dashboard.

        :param module: The module of this DashboardPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this DashboardPATCH.
        The dashboard name. Dashboard names must be unique within each tenant.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DashboardPATCH.

        The dashboard name. Dashboard names must be unique within each tenant.

        :param name: The name of this DashboardPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this DashboardPATCH.
        The version of the dashboard.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this DashboardPATCH.

        The version of the dashboard.

        :param version: The version of this DashboardPATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DashboardPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DashboardPOST":
        instance = DashboardPOST.__new__(DashboardPOST)
        instance._attrs = model
        return instance

    def __init__(self, definition: "str" = None, id: "str" = None, isactive: "bool" = None, module: "str" = None, name: "str" = None, version: "int" = None, **extra):
        """DashboardPOST"""

        self._attrs = dict()
        if definition is not None:
            self._attrs["definition"] = definition
        if id is not None:
            self._attrs["id"] = id
        if isactive is not None:
            self._attrs["isactive"] = isactive
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def definition(self) -> "str":
        """ Gets the definition of this DashboardPOST.
        The JSON dashboard definition.
        """
        return self._attrs.get("definition")

    @definition.setter
    def definition(self, definition: "str"):
        """Sets the definition of this DashboardPOST.

        The JSON dashboard definition.

        :param definition: The definition of this DashboardPOST.
        :type: str
        """
        self._attrs["definition"] = definition

    @property
    def id(self) -> "str":
        """ Gets the id of this DashboardPOST.
        A unique dashboard ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this DashboardPOST.

        A unique dashboard ID. Random ID used if not provided.

        :param id: The id of this DashboardPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def isactive(self) -> "bool":
        """ Gets the isactive of this DashboardPOST.
        Whether the dashboard is active or not.
        """
        return self._attrs.get("isactive")

    @isactive.setter
    def isactive(self, isactive: "bool"):
        """Sets the isactive of this DashboardPOST.

        Whether the dashboard is active or not.

        :param isactive: The isactive of this DashboardPOST.
        :type: bool
        """
        self._attrs["isactive"] = isactive

    @property
    def module(self) -> "str":
        """ Gets the module of this DashboardPOST.
        The module that contains the dashboard.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DashboardPOST.

        The module that contains the dashboard.

        :param module: The module of this DashboardPOST.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this DashboardPOST.
        The dashboard name. Dashboard names must be unique within each tenant.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DashboardPOST.

        The dashboard name. Dashboard names must be unique within each tenant.

        :param name: The name of this DashboardPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this DashboardPOST.
        The version of the dashboard.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this DashboardPOST.

        The version of the dashboard.

        :param version: The version of this DashboardPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Dataset(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "Dataset":

        def default_handler(model: dict) -> "Dataset":
            instance = Dataset.__new__(Dataset)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = Dataset.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, created: "datetime" = None, createdby: "str" = None, description: "str" = None, id: "str" = None, internalname: "str" = None, modified: "datetime" = None, modifiedby: "str" = None, module: "str" = None, name: "str" = None, owner: "str" = None, resourcename: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """Dataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Dataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Dataset.

        The date and time object was created.

        :param created: The created of this Dataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Dataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Dataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Dataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this Dataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Dataset.

        A unique dataset ID.

        :param id: The id of this Dataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Dataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Dataset.

        The date and time object was modified.

        :param modified: The modified of this Dataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Dataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Dataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Dataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this Dataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this Dataset.

        The name of the module that contains the dataset.

        :param module: The module of this Dataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this Dataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Dataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this Dataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Dataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Dataset.

        The name of the object's owner.

        :param owner: The owner of this Dataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this Dataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this Dataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this Dataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Dataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Dataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Dataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Dataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Dataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Dataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this Dataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Dataset.

        Detailed description of the dataset.

        :param description: The description of this Dataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this Dataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this Dataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this Dataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def summary(self) -> "str":
        """ Gets the summary of this Dataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this Dataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this Dataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this Dataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this Dataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this Dataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this Dataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Dataset.

        The catalog version.

        :param version: The version of this Dataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        raise NotImplementedError()


class DatasetImportedBy(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DatasetImportedBy":
        instance = DatasetImportedBy.__new__(DatasetImportedBy)
        instance._attrs = model
        return instance

    def __init__(self, module: "str", owner: "str", name: "str" = None, **extra):
        """DatasetImportedBy"""

        self._attrs = dict()
        if module is not None:
            self._attrs["module"] = module
        if owner is not None:
            self._attrs["owner"] = owner
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def module(self) -> "str":
        """ Gets the module of this DatasetImportedBy.
        The module that is importing the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DatasetImportedBy.

        The module that is importing the dataset.

        :param module: The module of this DatasetImportedBy.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def owner(self) -> "str":
        """ Gets the owner of this DatasetImportedBy.
        The dataset owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this DatasetImportedBy.

        The dataset owner.

        :param owner: The owner of this DatasetImportedBy.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def name(self) -> "str":
        """ Gets the name of this DatasetImportedBy.
        The dataset name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DatasetImportedBy.

        The dataset name.

        :param name: The name of this DatasetImportedBy.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DatasetPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DatasetPATCH":
        instance = DatasetPATCH.__new__(DatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """DatasetPATCH"""

        self._attrs = dict()
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def module(self) -> "str":
        """ Gets the module of this DatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this DatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this DatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this DatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this DatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this DatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this DatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FieldPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FieldPOST":
        instance = FieldPOST.__new__(FieldPOST)
        instance._attrs = model
        return instance

    def __init__(self, datatype: "FieldDataType" = None, description: "str" = None, fieldtype: "FieldType" = None, indexed: "bool" = None, name: "str" = None, prevalence: "FieldPrevalence" = None, summary: "str" = None, title: "str" = None, **extra):
        """FieldPOST"""

        self._attrs = dict()
        if datatype is not None:
            self._attrs["datatype"] = datatype
        if description is not None:
            self._attrs["description"] = description
        if fieldtype is not None:
            self._attrs["fieldtype"] = fieldtype
        if indexed is not None:
            self._attrs["indexed"] = indexed
        if name is not None:
            self._attrs["name"] = name
        if prevalence is not None:
            self._attrs["prevalence"] = prevalence
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def datatype(self) -> "FieldDataType":
        """ Gets the datatype of this FieldPOST.
        """
        return FieldDataType.from_value(self._attrs.get("datatype"))

    @datatype.setter
    def datatype(self, datatype: "FieldDataType"):
        """Sets the datatype of this FieldPOST.


        :param datatype: The datatype of this FieldPOST.
        :type: FieldDataType
        """
        if isinstance(datatype, Enum):
            self._attrs["datatype"] = datatype.value
        else:
            self._attrs["datatype"] = datatype  # If you supply a string, we presume you know the service will take it.

    @property
    def description(self) -> "str":
        """ Gets the description of this FieldPOST.
        The field description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this FieldPOST.

        The field description.

        :param description: The description of this FieldPOST.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def fieldtype(self) -> "FieldType":
        """ Gets the fieldtype of this FieldPOST.
        """
        return FieldType.from_value(self._attrs.get("fieldtype"))

    @fieldtype.setter
    def fieldtype(self, fieldtype: "FieldType"):
        """Sets the fieldtype of this FieldPOST.


        :param fieldtype: The fieldtype of this FieldPOST.
        :type: FieldType
        """
        if isinstance(fieldtype, Enum):
            self._attrs["fieldtype"] = fieldtype.value
        else:
            self._attrs["fieldtype"] = fieldtype  # If you supply a string, we presume you know the service will take it.

    @property
    def indexed(self) -> "bool":
        """ Gets the indexed of this FieldPOST.
        Whether or not the field has been indexed.
        """
        return self._attrs.get("indexed")

    @indexed.setter
    def indexed(self, indexed: "bool"):
        """Sets the indexed of this FieldPOST.

        Whether or not the field has been indexed.

        :param indexed: The indexed of this FieldPOST.
        :type: bool
        """
        self._attrs["indexed"] = indexed

    @property
    def name(self) -> "str":
        """ Gets the name of this FieldPOST.
        The field name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FieldPOST.

        The field name.

        :param name: The name of this FieldPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def prevalence(self) -> "FieldPrevalence":
        """ Gets the prevalence of this FieldPOST.
        """
        return FieldPrevalence.from_value(self._attrs.get("prevalence"))

    @prevalence.setter
    def prevalence(self, prevalence: "FieldPrevalence"):
        """Sets the prevalence of this FieldPOST.


        :param prevalence: The prevalence of this FieldPOST.
        :type: FieldPrevalence
        """
        if isinstance(prevalence, Enum):
            self._attrs["prevalence"] = prevalence.value
        else:
            self._attrs["prevalence"] = prevalence  # If you supply a string, we presume you know the service will take it.

    @property
    def summary(self) -> "str":
        """ Gets the summary of this FieldPOST.
        The field summary.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this FieldPOST.

        The field summary.

        :param summary: The summary of this FieldPOST.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this FieldPOST.
        The field title.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this FieldPOST.

        The field title.

        :param title: The title of this FieldPOST.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FieldDataType(str, Enum):
    DATE = "DATE"
    NUMBER = "NUMBER"
    OBJECT_ID = "OBJECT_ID"
    STRING = "STRING"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "DATE":
            return FieldDataType.DATE
        if value == "NUMBER":
            return FieldDataType.NUMBER
        if value == "OBJECT_ID":
            return FieldDataType.OBJECT_ID
        if value == "STRING":
            return FieldDataType.STRING
        if value == "UNKNOWN":
            return FieldDataType.UNKNOWN


class FieldType(str, Enum):
    DIMENSION = "DIMENSION"
    MEASURE = "MEASURE"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "DIMENSION":
            return FieldType.DIMENSION
        if value == "MEASURE":
            return FieldType.MEASURE
        if value == "UNKNOWN":
            return FieldType.UNKNOWN


class FieldPrevalence(str, Enum):
    ALL = "ALL"
    SOME = "SOME"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "ALL":
            return FieldPrevalence.ALL
        if value == "SOME":
            return FieldPrevalence.SOME
        if value == "UNKNOWN":
            return FieldPrevalence.UNKNOWN


class DatasetPOST(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "DatasetPOST":

        def default_handler(model: dict) -> "DatasetPOST":
            instance = DatasetPOST.__new__(DatasetPOST)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = DatasetPOST.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, fields: "List[FieldPOST]" = None, id: "str" = None, module: "str" = None, **extra):
        """DatasetPOST"""

        self._attrs = dict()
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        if module is not None:
            self._attrs["module"] = module
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this DatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this DatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this DatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this DatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this DatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this DatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def module(self) -> "str":
        """ Gets the module of this DatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this DatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    def to_dict(self):
        raise NotImplementedError()


class EvalActionFromAction(Action):

    @staticmethod
    def _from_dict(model: dict) -> "EvalActionFromAction":
        instance = EvalActionFromAction.__new__(EvalActionFromAction)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, expression: "str" = None, field: "str" = None, id: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """EvalActionFromAction"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if expression is not None:
            self._attrs["expression"] = expression
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "EVAL" 
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this EvalActionFromAction.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this EvalActionFromAction.

        The date and time object was created.

        :param created: The created of this EvalActionFromAction.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this EvalActionFromAction.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this EvalActionFromAction.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this EvalActionFromAction.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this EvalActionFromAction.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this EvalActionFromAction.

        The date and time object was modified.

        :param modified: The modified of this EvalActionFromAction.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this EvalActionFromAction.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this EvalActionFromAction.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this EvalActionFromAction.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this EvalActionFromAction.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this EvalActionFromAction.

        The name of the object's owner.

        :param owner: The owner of this EvalActionFromAction.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this EvalActionFromAction.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this EvalActionFromAction.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this EvalActionFromAction.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this EvalActionFromAction.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this EvalActionFromAction.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this EvalActionFromAction.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def expression(self) -> "str":
        """ Gets the expression of this EvalActionFromAction.
        The EVAL expression that calculates the field.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this EvalActionFromAction.

        The EVAL expression that calculates the field.

        :param expression: The expression of this EvalActionFromAction.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def field(self) -> "str":
        """ Gets the field of this EvalActionFromAction.
        The name of the field that is added or modified by the EVAL expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this EvalActionFromAction.

        The name of the field that is added or modified by the EVAL expression.

        :param field: The field of this EvalActionFromAction.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this EvalActionFromAction.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this EvalActionFromAction.

        A unique action ID.

        :param id: The id of this EvalActionFromAction.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "EVAL"


    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this EvalActionFromAction.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this EvalActionFromAction.

        The rule that this action is part of.

        :param ruleid: The ruleid of this EvalActionFromAction.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this EvalActionFromAction.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this EvalActionFromAction.

        The catalog version.

        :param version: The version of this EvalActionFromAction.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Action.from_dict_handlers["EVAL"] = EvalActionFromAction._from_dict



class EvalActionFromActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "EvalActionFromActionPOST":
        instance = EvalActionFromActionPOST.__new__(EvalActionFromActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, expression: "str" = None, field: "str" = None, id: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """EvalActionFromActionPOST"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if expression is not None:
            self._attrs["expression"] = expression
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "EVAL" 
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this EvalActionFromActionPOST.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this EvalActionFromActionPOST.

        The date and time object was created.

        :param created: The created of this EvalActionFromActionPOST.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this EvalActionFromActionPOST.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this EvalActionFromActionPOST.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this EvalActionFromActionPOST.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this EvalActionFromActionPOST.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this EvalActionFromActionPOST.

        The date and time object was modified.

        :param modified: The modified of this EvalActionFromActionPOST.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this EvalActionFromActionPOST.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this EvalActionFromActionPOST.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this EvalActionFromActionPOST.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this EvalActionFromActionPOST.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this EvalActionFromActionPOST.

        The name of the object's owner.

        :param owner: The owner of this EvalActionFromActionPOST.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this EvalActionFromActionPOST.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this EvalActionFromActionPOST.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this EvalActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this EvalActionFromActionPOST.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this EvalActionFromActionPOST.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this EvalActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def expression(self) -> "str":
        """ Gets the expression of this EvalActionFromActionPOST.
        The EVAL expression that calculates the field.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this EvalActionFromActionPOST.

        The EVAL expression that calculates the field.

        :param expression: The expression of this EvalActionFromActionPOST.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def field(self) -> "str":
        """ Gets the field of this EvalActionFromActionPOST.
        The name of the field that is added or modified by the EVAL expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this EvalActionFromActionPOST.

        The name of the field that is added or modified by the EVAL expression.

        :param field: The field of this EvalActionFromActionPOST.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this EvalActionFromActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this EvalActionFromActionPOST.

        A unique action ID.

        :param id: The id of this EvalActionFromActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "EVAL"


    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this EvalActionFromActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this EvalActionFromActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this EvalActionFromActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this EvalActionFromActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this EvalActionFromActionPOST.

        The catalog version.

        :param version: The version of this EvalActionFromActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


ActionPOST.from_dict_handlers["EVAL"] = EvalActionFromActionPOST._from_dict



class EvalActionKind(str, Enum):
    EVAL = "EVAL"

    @staticmethod
    def from_value(value: str):
        if value == "EVAL":
            return EvalActionKind.EVAL


class EvalActionPATCH(ActionPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "EvalActionPATCH":
        instance = EvalActionPATCH.__new__(EvalActionPATCH)
        instance._attrs = model
        return instance

    def __init__(self, expression: "str" = None, field: "str" = None, kind: "EvalActionKind" = None, owner: "str" = None, version: "int" = None, **extra):
        """EvalActionPATCH"""

        self._attrs = dict()
        if expression is not None:
            self._attrs["expression"] = expression
        if field is not None:
            self._attrs["field"] = field
        if kind is not None:
            self._attrs["kind"] = kind
        if owner is not None:
            self._attrs["owner"] = owner
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def expression(self) -> "str":
        """ Gets the expression of this EvalActionPATCH.
        The EVAL expression that calculates the field.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this EvalActionPATCH.

        The EVAL expression that calculates the field.

        :param expression: The expression of this EvalActionPATCH.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def field(self) -> "str":
        """ Gets the field of this EvalActionPATCH.
        The name of the field that is added or modified by the EVAL expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this EvalActionPATCH.

        The name of the field that is added or modified by the EVAL expression.

        :param field: The field of this EvalActionPATCH.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def kind(self) -> "EvalActionKind":
        """ Gets the kind of this EvalActionPATCH.
        """
        return EvalActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "EvalActionKind"):
        """Sets the kind of this EvalActionPATCH.


        :param kind: The kind of this EvalActionPATCH.
        :type: EvalActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def owner(self) -> "str":
        """ Gets the owner of this EvalActionPATCH.
        The name of the user who owns this action. This value is obtained from the bearer token if not present.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this EvalActionPATCH.

        The name of the user who owns this action. This value is obtained from the bearer token if not present.

        :param owner: The owner of this EvalActionPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def version(self) -> "int":
        """ Gets the version of this EvalActionPATCH.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this EvalActionPATCH.

        The catalog version.

        :param version: The version of this EvalActionPATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class EvalActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "EvalActionPOST":
        instance = EvalActionPOST.__new__(EvalActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, expression: "str" = None, field: "str" = None, id: "str" = None, kind: "EvalActionKind" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """EvalActionPOST"""

        self._attrs = dict()
        if expression is not None:
            self._attrs["expression"] = expression
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def expression(self) -> "str":
        """ Gets the expression of this EvalActionPOST.
        The EVAL expression that calculates the field.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this EvalActionPOST.

        The EVAL expression that calculates the field.

        :param expression: The expression of this EvalActionPOST.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def field(self) -> "str":
        """ Gets the field of this EvalActionPOST.
        The name of the field that is added or modified by the EVAL expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this EvalActionPOST.

        The name of the field that is added or modified by the EVAL expression.

        :param field: The field of this EvalActionPOST.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this EvalActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this EvalActionPOST.

        A unique action ID.

        :param id: The id of this EvalActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "EvalActionKind":
        """ Gets the kind of this EvalActionPOST.
        """
        return EvalActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "EvalActionKind"):
        """Sets the kind of this EvalActionPOST.


        :param kind: The kind of this EvalActionPOST.
        :type: EvalActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this EvalActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this EvalActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this EvalActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this EvalActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this EvalActionPOST.

        The catalog version.

        :param version: The version of this EvalActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Field(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Field":
        instance = Field.__new__(Field)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", modified: "datetime", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, datasetid: "str" = None, datatype: "FieldDataType" = None, description: "str" = None, fieldtype: "FieldType" = None, id: "str" = None, indexed: "bool" = None, name: "str" = None, prevalence: "FieldPrevalence" = None, summary: "str" = None, title: "str" = None, **extra):
        """Field"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if modified is not None:
            self._attrs["modified"] = modified
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if datasetid is not None:
            self._attrs["datasetid"] = datasetid
        if datatype is not None:
            self._attrs["datatype"] = datatype
        if description is not None:
            self._attrs["description"] = description
        if fieldtype is not None:
            self._attrs["fieldtype"] = fieldtype
        if id is not None:
            self._attrs["id"] = id
        if indexed is not None:
            self._attrs["indexed"] = indexed
        if name is not None:
            self._attrs["name"] = name
        if prevalence is not None:
            self._attrs["prevalence"] = prevalence
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Field.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Field.

        The date and time object was created.

        :param created: The created of this Field.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Field.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Field.

        The date and time object was modified.

        :param modified: The modified of this Field.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Field.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Field.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Field.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Field.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Field.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Field.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def datasetid(self) -> "str":
        """ Gets the datasetid of this Field.
        The dataset that the field is part of.
        """
        return self._attrs.get("datasetid")

    @datasetid.setter
    def datasetid(self, datasetid: "str"):
        """Sets the datasetid of this Field.

        The dataset that the field is part of.

        :param datasetid: The datasetid of this Field.
        :type: str
        """
        self._attrs["datasetid"] = datasetid

    @property
    def datatype(self) -> "FieldDataType":
        """ Gets the datatype of this Field.
        """
        return FieldDataType.from_value(self._attrs.get("datatype"))

    @datatype.setter
    def datatype(self, datatype: "FieldDataType"):
        """Sets the datatype of this Field.


        :param datatype: The datatype of this Field.
        :type: FieldDataType
        """
        if isinstance(datatype, Enum):
            self._attrs["datatype"] = datatype.value
        else:
            self._attrs["datatype"] = datatype  # If you supply a string, we presume you know the service will take it.

    @property
    def description(self) -> "str":
        """ Gets the description of this Field.
        The field description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Field.

        The field description.

        :param description: The description of this Field.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def fieldtype(self) -> "FieldType":
        """ Gets the fieldtype of this Field.
        """
        return FieldType.from_value(self._attrs.get("fieldtype"))

    @fieldtype.setter
    def fieldtype(self, fieldtype: "FieldType"):
        """Sets the fieldtype of this Field.


        :param fieldtype: The fieldtype of this Field.
        :type: FieldType
        """
        if isinstance(fieldtype, Enum):
            self._attrs["fieldtype"] = fieldtype.value
        else:
            self._attrs["fieldtype"] = fieldtype  # If you supply a string, we presume you know the service will take it.

    @property
    def id(self) -> "str":
        """ Gets the id of this Field.
        The unique ID of this field.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Field.

        The unique ID of this field.

        :param id: The id of this Field.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def indexed(self) -> "bool":
        """ Gets the indexed of this Field.
        Whether or not the field has been indexed.
        """
        return self._attrs.get("indexed")

    @indexed.setter
    def indexed(self, indexed: "bool"):
        """Sets the indexed of this Field.

        Whether or not the field has been indexed.

        :param indexed: The indexed of this Field.
        :type: bool
        """
        self._attrs["indexed"] = indexed

    @property
    def name(self) -> "str":
        """ Gets the name of this Field.
        The field name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Field.

        The field name.

        :param name: The name of this Field.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def prevalence(self) -> "FieldPrevalence":
        """ Gets the prevalence of this Field.
        """
        return FieldPrevalence.from_value(self._attrs.get("prevalence"))

    @prevalence.setter
    def prevalence(self, prevalence: "FieldPrevalence"):
        """Sets the prevalence of this Field.


        :param prevalence: The prevalence of this Field.
        :type: FieldPrevalence
        """
        if isinstance(prevalence, Enum):
            self._attrs["prevalence"] = prevalence.value
        else:
            self._attrs["prevalence"] = prevalence  # If you supply a string, we presume you know the service will take it.

    @property
    def summary(self) -> "str":
        """ Gets the summary of this Field.
        The field summary.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this Field.

        The field summary.

        :param summary: The summary of this Field.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this Field.
        The field title.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this Field.

        The field title.

        :param title: The title of this Field.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FieldPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FieldPATCH":
        instance = FieldPATCH.__new__(FieldPATCH)
        instance._attrs = model
        return instance

    def __init__(self, datatype: "FieldDataType" = None, description: "str" = None, fieldtype: "FieldType" = None, indexed: "bool" = None, name: "str" = None, prevalence: "FieldPrevalence" = None, summary: "str" = None, title: "str" = None, **extra):
        """FieldPATCH"""

        self._attrs = dict()
        if datatype is not None:
            self._attrs["datatype"] = datatype
        if description is not None:
            self._attrs["description"] = description
        if fieldtype is not None:
            self._attrs["fieldtype"] = fieldtype
        if indexed is not None:
            self._attrs["indexed"] = indexed
        if name is not None:
            self._attrs["name"] = name
        if prevalence is not None:
            self._attrs["prevalence"] = prevalence
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def datatype(self) -> "FieldDataType":
        """ Gets the datatype of this FieldPATCH.
        """
        return FieldDataType.from_value(self._attrs.get("datatype"))

    @datatype.setter
    def datatype(self, datatype: "FieldDataType"):
        """Sets the datatype of this FieldPATCH.


        :param datatype: The datatype of this FieldPATCH.
        :type: FieldDataType
        """
        if isinstance(datatype, Enum):
            self._attrs["datatype"] = datatype.value
        else:
            self._attrs["datatype"] = datatype  # If you supply a string, we presume you know the service will take it.

    @property
    def description(self) -> "str":
        """ Gets the description of this FieldPATCH.
        The field description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this FieldPATCH.

        The field description.

        :param description: The description of this FieldPATCH.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def fieldtype(self) -> "FieldType":
        """ Gets the fieldtype of this FieldPATCH.
        """
        return FieldType.from_value(self._attrs.get("fieldtype"))

    @fieldtype.setter
    def fieldtype(self, fieldtype: "FieldType"):
        """Sets the fieldtype of this FieldPATCH.


        :param fieldtype: The fieldtype of this FieldPATCH.
        :type: FieldType
        """
        if isinstance(fieldtype, Enum):
            self._attrs["fieldtype"] = fieldtype.value
        else:
            self._attrs["fieldtype"] = fieldtype  # If you supply a string, we presume you know the service will take it.

    @property
    def indexed(self) -> "bool":
        """ Gets the indexed of this FieldPATCH.
        Whether or not the field has been indexed.
        """
        return self._attrs.get("indexed")

    @indexed.setter
    def indexed(self, indexed: "bool"):
        """Sets the indexed of this FieldPATCH.

        Whether or not the field has been indexed.

        :param indexed: The indexed of this FieldPATCH.
        :type: bool
        """
        self._attrs["indexed"] = indexed

    @property
    def name(self) -> "str":
        """ Gets the name of this FieldPATCH.
        The field name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FieldPATCH.

        The field name.

        :param name: The name of this FieldPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def prevalence(self) -> "FieldPrevalence":
        """ Gets the prevalence of this FieldPATCH.
        """
        return FieldPrevalence.from_value(self._attrs.get("prevalence"))

    @prevalence.setter
    def prevalence(self, prevalence: "FieldPrevalence"):
        """Sets the prevalence of this FieldPATCH.


        :param prevalence: The prevalence of this FieldPATCH.
        :type: FieldPrevalence
        """
        if isinstance(prevalence, Enum):
            self._attrs["prevalence"] = prevalence.value
        else:
            self._attrs["prevalence"] = prevalence  # If you supply a string, we presume you know the service will take it.

    @property
    def summary(self) -> "str":
        """ Gets the summary of this FieldPATCH.
        The field summary.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this FieldPATCH.

        The field summary.

        :param summary: The summary of this FieldPATCH.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this FieldPATCH.
        The field title.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this FieldPATCH.

        The field title.

        :param title: The title of this FieldPATCH.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ImportDatasetPOST(DatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "ImportDatasetPOST":
        instance = ImportDatasetPOST.__new__(ImportDatasetPOST)
        instance._attrs = model
        return instance

    def __init__(self, fields: "List[FieldPOST]" = None, id: "str" = None, module: "str" = None, name: "str" = None, **extra):
        """ImportDatasetPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        if module is not None:
            self._attrs["module"] = module
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this ImportDatasetPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ImportDatasetPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ImportDatasetPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this ImportDatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this ImportDatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this ImportDatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this ImportDatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ImportDatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this ImportDatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def module(self) -> "str":
        """ Gets the module of this ImportDatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ImportDatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this ImportDatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetPOST.from_dict_handlers["import"] = ImportDatasetPOST._from_dict



class ImportDatasetKind(str, Enum):
    IMPORT = "import"

    @staticmethod
    def from_value(value: str):
        if value == "import":
            return ImportDatasetKind.IMPORT


class ImportDatasetByIdPOST(ImportDatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "ImportDatasetByIdPOST":
        instance = ImportDatasetByIdPOST.__new__(ImportDatasetByIdPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", fields: "List[FieldPOST]" = None, id: "str" = None, kind: "ImportDatasetKind" = None, module: "str" = None, source_id: "str" = None, **extra):
        """ImportDatasetByIdPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "import" 
        if module is not None:
            self._attrs["module"] = module
        if source_id is not None:
            self._attrs["sourceId"] = source_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this ImportDatasetByIdPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ImportDatasetByIdPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ImportDatasetByIdPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this ImportDatasetByIdPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this ImportDatasetByIdPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this ImportDatasetByIdPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this ImportDatasetByIdPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ImportDatasetByIdPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this ImportDatasetByIdPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "import"


    @property
    def module(self) -> "str":
        """ Gets the module of this ImportDatasetByIdPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ImportDatasetByIdPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this ImportDatasetByIdPOST.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def source_id(self) -> "str":
        """ Gets the source_id of this ImportDatasetByIdPOST.
        The dataset ID being imported.
        """
        return self._attrs.get("sourceId")

    @source_id.setter
    def source_id(self, source_id: "str"):
        """Sets the source_id of this ImportDatasetByIdPOST.

        The dataset ID being imported.

        :param source_id: The source_id of this ImportDatasetByIdPOST.
        :type: str
        """
        self._attrs["sourceId"] = source_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


ImportDatasetPOST.from_dict_handlers["import"] = ImportDatasetByIdPOST._from_dict



class ImportDatasetByNamePOST(ImportDatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "ImportDatasetByNamePOST":
        instance = ImportDatasetByNamePOST.__new__(ImportDatasetByNamePOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", fields: "List[FieldPOST]" = None, id: "str" = None, kind: "ImportDatasetKind" = None, module: "str" = None, source_module: "str" = None, source_name: "str" = None, **extra):
        """ImportDatasetByNamePOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "import" 
        if module is not None:
            self._attrs["module"] = module
        if source_module is not None:
            self._attrs["sourceModule"] = source_module
        if source_name is not None:
            self._attrs["sourceName"] = source_name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this ImportDatasetByNamePOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ImportDatasetByNamePOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ImportDatasetByNamePOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this ImportDatasetByNamePOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this ImportDatasetByNamePOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this ImportDatasetByNamePOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this ImportDatasetByNamePOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ImportDatasetByNamePOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this ImportDatasetByNamePOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "import"


    @property
    def module(self) -> "str":
        """ Gets the module of this ImportDatasetByNamePOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ImportDatasetByNamePOST.

        The name of the module to create the new dataset in.

        :param module: The module of this ImportDatasetByNamePOST.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def source_module(self) -> "str":
        """ Gets the source_module of this ImportDatasetByNamePOST.
        The dataset module being imported.
        """
        return self._attrs.get("sourceModule")

    @source_module.setter
    def source_module(self, source_module: "str"):
        """Sets the source_module of this ImportDatasetByNamePOST.

        The dataset module being imported.

        :param source_module: The source_module of this ImportDatasetByNamePOST.
        :type: str
        """
        self._attrs["sourceModule"] = source_module

    @property
    def source_name(self) -> "str":
        """ Gets the source_name of this ImportDatasetByNamePOST.
        The dataset name being imported.
        """
        return self._attrs.get("sourceName")

    @source_name.setter
    def source_name(self, source_name: "str"):
        """Sets the source_name of this ImportDatasetByNamePOST.

        The dataset name being imported.

        :param source_name: The source_name of this ImportDatasetByNamePOST.
        :type: str
        """
        self._attrs["sourceName"] = source_name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


ImportDatasetPOST.from_dict_handlers["import"] = ImportDatasetByNamePOST._from_dict



class ImportDatasetFromDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "ImportDatasetFromDataset":
        instance = ImportDatasetFromDataset.__new__(ImportDatasetFromDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, source_module: "str" = None, source_name: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """ImportDatasetFromDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "import" 
        if source_module is not None:
            self._attrs["sourceModule"] = source_module
        if source_name is not None:
            self._attrs["sourceName"] = source_name
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this ImportDatasetFromDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this ImportDatasetFromDataset.

        The date and time object was created.

        :param created: The created of this ImportDatasetFromDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this ImportDatasetFromDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this ImportDatasetFromDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this ImportDatasetFromDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this ImportDatasetFromDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ImportDatasetFromDataset.

        A unique dataset ID.

        :param id: The id of this ImportDatasetFromDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this ImportDatasetFromDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this ImportDatasetFromDataset.

        The date and time object was modified.

        :param modified: The modified of this ImportDatasetFromDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this ImportDatasetFromDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this ImportDatasetFromDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this ImportDatasetFromDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this ImportDatasetFromDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ImportDatasetFromDataset.

        The name of the module that contains the dataset.

        :param module: The module of this ImportDatasetFromDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this ImportDatasetFromDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ImportDatasetFromDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ImportDatasetFromDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this ImportDatasetFromDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this ImportDatasetFromDataset.

        The name of the object's owner.

        :param owner: The owner of this ImportDatasetFromDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this ImportDatasetFromDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this ImportDatasetFromDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this ImportDatasetFromDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this ImportDatasetFromDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this ImportDatasetFromDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this ImportDatasetFromDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this ImportDatasetFromDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this ImportDatasetFromDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ImportDatasetFromDataset.

        Detailed description of the dataset.

        :param description: The description of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this ImportDatasetFromDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this ImportDatasetFromDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "import"


    @property
    def source_module(self) -> "str":
        """ Gets the source_module of this ImportDatasetFromDataset.
        The dataset module being imported.
        """
        return self._attrs.get("sourceModule")

    @source_module.setter
    def source_module(self, source_module: "str"):
        """Sets the source_module of this ImportDatasetFromDataset.

        The dataset module being imported.

        :param source_module: The source_module of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["sourceModule"] = source_module

    @property
    def source_name(self) -> "str":
        """ Gets the source_name of this ImportDatasetFromDataset.
        The dataset name being imported.
        """
        return self._attrs.get("sourceName")

    @source_name.setter
    def source_name(self, source_name: "str"):
        """Sets the source_name of this ImportDatasetFromDataset.

        The dataset name being imported.

        :param source_name: The source_name of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["sourceName"] = source_name

    @property
    def summary(self) -> "str":
        """ Gets the summary of this ImportDatasetFromDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this ImportDatasetFromDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this ImportDatasetFromDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this ImportDatasetFromDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this ImportDatasetFromDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this ImportDatasetFromDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ImportDatasetFromDataset.

        The catalog version.

        :param version: The version of this ImportDatasetFromDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["import"] = ImportDatasetFromDataset._from_dict



class ImportDatasetFromDatasetGet(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "ImportDatasetFromDatasetGet":
        instance = ImportDatasetFromDatasetGet.__new__(ImportDatasetFromDatasetGet)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, source_module: "str" = None, source_name: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """ImportDatasetFromDatasetGet"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "import" 
        if source_module is not None:
            self._attrs["sourceModule"] = source_module
        if source_name is not None:
            self._attrs["sourceName"] = source_name
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this ImportDatasetFromDatasetGet.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this ImportDatasetFromDatasetGet.

        The date and time object was created.

        :param created: The created of this ImportDatasetFromDatasetGet.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this ImportDatasetFromDatasetGet.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this ImportDatasetFromDatasetGet.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this ImportDatasetFromDatasetGet.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this ImportDatasetFromDatasetGet.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ImportDatasetFromDatasetGet.

        A unique dataset ID.

        :param id: The id of this ImportDatasetFromDatasetGet.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this ImportDatasetFromDatasetGet.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this ImportDatasetFromDatasetGet.

        The date and time object was modified.

        :param modified: The modified of this ImportDatasetFromDatasetGet.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this ImportDatasetFromDatasetGet.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this ImportDatasetFromDatasetGet.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this ImportDatasetFromDatasetGet.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this ImportDatasetFromDatasetGet.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ImportDatasetFromDatasetGet.

        The name of the module that contains the dataset.

        :param module: The module of this ImportDatasetFromDatasetGet.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this ImportDatasetFromDatasetGet.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ImportDatasetFromDatasetGet.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ImportDatasetFromDatasetGet.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this ImportDatasetFromDatasetGet.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this ImportDatasetFromDatasetGet.

        The name of the object's owner.

        :param owner: The owner of this ImportDatasetFromDatasetGet.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this ImportDatasetFromDatasetGet.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this ImportDatasetFromDatasetGet.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this ImportDatasetFromDatasetGet.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this ImportDatasetFromDatasetGet.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this ImportDatasetFromDatasetGet.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this ImportDatasetFromDatasetGet.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this ImportDatasetFromDatasetGet.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this ImportDatasetFromDatasetGet.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ImportDatasetFromDatasetGet.

        Detailed description of the dataset.

        :param description: The description of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this ImportDatasetFromDatasetGet.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this ImportDatasetFromDatasetGet.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "import"


    @property
    def source_module(self) -> "str":
        """ Gets the source_module of this ImportDatasetFromDatasetGet.
        The dataset module being imported.
        """
        return self._attrs.get("sourceModule")

    @source_module.setter
    def source_module(self, source_module: "str"):
        """Sets the source_module of this ImportDatasetFromDatasetGet.

        The dataset module being imported.

        :param source_module: The source_module of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["sourceModule"] = source_module

    @property
    def source_name(self) -> "str":
        """ Gets the source_name of this ImportDatasetFromDatasetGet.
        The dataset name being imported.
        """
        return self._attrs.get("sourceName")

    @source_name.setter
    def source_name(self, source_name: "str"):
        """Sets the source_name of this ImportDatasetFromDatasetGet.

        The dataset name being imported.

        :param source_name: The source_name of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["sourceName"] = source_name

    @property
    def summary(self) -> "str":
        """ Gets the summary of this ImportDatasetFromDatasetGet.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this ImportDatasetFromDatasetGet.

        Summary of the dataset's purpose.

        :param summary: The summary of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this ImportDatasetFromDatasetGet.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this ImportDatasetFromDatasetGet.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this ImportDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this ImportDatasetFromDatasetGet.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ImportDatasetFromDatasetGet.

        The catalog version.

        :param version: The version of this ImportDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["import"] = ImportDatasetFromDatasetGet._from_dict



class ImportDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "ImportDatasetPATCH":
        instance = ImportDatasetPATCH.__new__(ImportDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """ImportDatasetPATCH"""

        self._attrs = dict()
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def module(self) -> "str":
        """ Gets the module of this ImportDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ImportDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this ImportDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this ImportDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ImportDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ImportDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this ImportDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this ImportDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this ImportDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class IndexDatasetFromDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "IndexDatasetFromDataset":
        instance = IndexDatasetFromDataset.__new__(IndexDatasetFromDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, disabled: "bool" = None, earliest_event_time: "str" = None, earliest_ingest_time: "str" = None, frozen_time_period_in_secs: "int" = None, internalname: "str" = None, latest_event_time: "str" = None, latest_ingest_time: "str" = None, latest_metadata_update_time: "str" = None, summary: "str" = None, title: "str" = None, total_event_count: "int" = None, total_size: "int" = None, version: "int" = None, **extra):
        """IndexDatasetFromDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if earliest_event_time is not None:
            self._attrs["earliestEventTime"] = earliest_event_time
        if earliest_ingest_time is not None:
            self._attrs["earliestIngestTime"] = earliest_ingest_time
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "index" 
        if latest_event_time is not None:
            self._attrs["latestEventTime"] = latest_event_time
        if latest_ingest_time is not None:
            self._attrs["latestIngestTime"] = latest_ingest_time
        if latest_metadata_update_time is not None:
            self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if total_event_count is not None:
            self._attrs["totalEventCount"] = total_event_count
        if total_size is not None:
            self._attrs["totalSize"] = total_size
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this IndexDatasetFromDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this IndexDatasetFromDataset.

        The date and time object was created.

        :param created: The created of this IndexDatasetFromDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this IndexDatasetFromDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this IndexDatasetFromDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this IndexDatasetFromDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this IndexDatasetFromDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this IndexDatasetFromDataset.

        A unique dataset ID.

        :param id: The id of this IndexDatasetFromDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this IndexDatasetFromDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this IndexDatasetFromDataset.

        The date and time object was modified.

        :param modified: The modified of this IndexDatasetFromDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this IndexDatasetFromDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this IndexDatasetFromDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this IndexDatasetFromDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this IndexDatasetFromDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this IndexDatasetFromDataset.

        The name of the module that contains the dataset.

        :param module: The module of this IndexDatasetFromDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this IndexDatasetFromDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this IndexDatasetFromDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this IndexDatasetFromDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this IndexDatasetFromDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this IndexDatasetFromDataset.

        The name of the object's owner.

        :param owner: The owner of this IndexDatasetFromDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this IndexDatasetFromDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this IndexDatasetFromDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this IndexDatasetFromDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this IndexDatasetFromDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this IndexDatasetFromDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this IndexDatasetFromDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this IndexDatasetFromDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this IndexDatasetFromDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this IndexDatasetFromDataset.

        Detailed description of the dataset.

        :param description: The description of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this IndexDatasetFromDataset.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this IndexDatasetFromDataset.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this IndexDatasetFromDataset.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def earliest_event_time(self) -> "str":
        """ Gets the earliest_event_time of this IndexDatasetFromDataset.
        The timestamp, in seconds, of the earliest event. The timestamp is in UNIX time.
        """
        return self._attrs.get("earliestEventTime")

    @earliest_event_time.setter
    def earliest_event_time(self, earliest_event_time: "str"):
        """Sets the earliest_event_time of this IndexDatasetFromDataset.

        The timestamp, in seconds, of the earliest event. The timestamp is in UNIX time.

        :param earliest_event_time: The earliest_event_time of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["earliestEventTime"] = earliest_event_time

    @property
    def earliest_ingest_time(self) -> "str":
        """ Gets the earliest_ingest_time of this IndexDatasetFromDataset.
        The earliest index time for any of the events in this index.
        """
        return self._attrs.get("earliestIngestTime")

    @earliest_ingest_time.setter
    def earliest_ingest_time(self, earliest_ingest_time: "str"):
        """Sets the earliest_ingest_time of this IndexDatasetFromDataset.

        The earliest index time for any of the events in this index.

        :param earliest_ingest_time: The earliest_ingest_time of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["earliestIngestTime"] = earliest_ingest_time

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this IndexDatasetFromDataset.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this IndexDatasetFromDataset.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this IndexDatasetFromDataset.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this IndexDatasetFromDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this IndexDatasetFromDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "index"


    @property
    def latest_event_time(self) -> "str":
        """ Gets the latest_event_time of this IndexDatasetFromDataset.
        The timestamp, in seconds, of the latest event. The timestamp is in UNIX time.
        """
        return self._attrs.get("latestEventTime")

    @latest_event_time.setter
    def latest_event_time(self, latest_event_time: "str"):
        """Sets the latest_event_time of this IndexDatasetFromDataset.

        The timestamp, in seconds, of the latest event. The timestamp is in UNIX time.

        :param latest_event_time: The latest_event_time of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["latestEventTime"] = latest_event_time

    @property
    def latest_ingest_time(self) -> "str":
        """ Gets the latest_ingest_time of this IndexDatasetFromDataset.
        The latest index time for any of the events in this index.
        """
        return self._attrs.get("latestIngestTime")

    @latest_ingest_time.setter
    def latest_ingest_time(self, latest_ingest_time: "str"):
        """Sets the latest_ingest_time of this IndexDatasetFromDataset.

        The latest index time for any of the events in this index.

        :param latest_ingest_time: The latest_ingest_time of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["latestIngestTime"] = latest_ingest_time

    @property
    def latest_metadata_update_time(self) -> "str":
        """ Gets the latest_metadata_update_time of this IndexDatasetFromDataset.
        The latest time that the index metadata was refreshed.
        """
        return self._attrs.get("latestMetadataUpdateTime")

    @latest_metadata_update_time.setter
    def latest_metadata_update_time(self, latest_metadata_update_time: "str"):
        """Sets the latest_metadata_update_time of this IndexDatasetFromDataset.

        The latest time that the index metadata was refreshed.

        :param latest_metadata_update_time: The latest_metadata_update_time of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time

    @property
    def summary(self) -> "str":
        """ Gets the summary of this IndexDatasetFromDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this IndexDatasetFromDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this IndexDatasetFromDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this IndexDatasetFromDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this IndexDatasetFromDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def total_event_count(self) -> "int":
        """ Gets the total_event_count of this IndexDatasetFromDataset.
        The number of events in the index.
        """
        return self._attrs.get("totalEventCount")

    @total_event_count.setter
    def total_event_count(self, total_event_count: "int"):
        """Sets the total_event_count of this IndexDatasetFromDataset.

        The number of events in the index.

        :param total_event_count: The total_event_count of this IndexDatasetFromDataset.
        :type: int
        """
        self._attrs["totalEventCount"] = total_event_count

    @property
    def total_size(self) -> "int":
        """ Gets the total_size of this IndexDatasetFromDataset.
        The raw size, in bytes, of the uncompressed data in the indexers.
        """
        return self._attrs.get("totalSize")

    @total_size.setter
    def total_size(self, total_size: "int"):
        """Sets the total_size of this IndexDatasetFromDataset.

        The raw size, in bytes, of the uncompressed data in the indexers.

        :param total_size: The total_size of this IndexDatasetFromDataset.
        :type: int
        """
        self._attrs["totalSize"] = total_size

    @property
    def version(self) -> "int":
        """ Gets the version of this IndexDatasetFromDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this IndexDatasetFromDataset.

        The catalog version.

        :param version: The version of this IndexDatasetFromDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["index"] = IndexDatasetFromDataset._from_dict



class IndexDatasetFromDatasetGet(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "IndexDatasetFromDatasetGet":
        instance = IndexDatasetFromDatasetGet.__new__(IndexDatasetFromDatasetGet)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, disabled: "bool" = None, earliest_event_time: "str" = None, earliest_ingest_time: "str" = None, frozen_time_period_in_secs: "int" = None, internalname: "str" = None, latest_event_time: "str" = None, latest_ingest_time: "str" = None, latest_metadata_update_time: "str" = None, summary: "str" = None, title: "str" = None, total_event_count: "int" = None, total_size: "int" = None, version: "int" = None, **extra):
        """IndexDatasetFromDatasetGet"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if earliest_event_time is not None:
            self._attrs["earliestEventTime"] = earliest_event_time
        if earliest_ingest_time is not None:
            self._attrs["earliestIngestTime"] = earliest_ingest_time
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "index" 
        if latest_event_time is not None:
            self._attrs["latestEventTime"] = latest_event_time
        if latest_ingest_time is not None:
            self._attrs["latestIngestTime"] = latest_ingest_time
        if latest_metadata_update_time is not None:
            self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if total_event_count is not None:
            self._attrs["totalEventCount"] = total_event_count
        if total_size is not None:
            self._attrs["totalSize"] = total_size
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this IndexDatasetFromDatasetGet.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this IndexDatasetFromDatasetGet.

        The date and time object was created.

        :param created: The created of this IndexDatasetFromDatasetGet.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this IndexDatasetFromDatasetGet.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this IndexDatasetFromDatasetGet.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this IndexDatasetFromDatasetGet.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this IndexDatasetFromDatasetGet.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this IndexDatasetFromDatasetGet.

        A unique dataset ID.

        :param id: The id of this IndexDatasetFromDatasetGet.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this IndexDatasetFromDatasetGet.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this IndexDatasetFromDatasetGet.

        The date and time object was modified.

        :param modified: The modified of this IndexDatasetFromDatasetGet.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this IndexDatasetFromDatasetGet.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this IndexDatasetFromDatasetGet.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this IndexDatasetFromDatasetGet.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this IndexDatasetFromDatasetGet.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this IndexDatasetFromDatasetGet.

        The name of the module that contains the dataset.

        :param module: The module of this IndexDatasetFromDatasetGet.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this IndexDatasetFromDatasetGet.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this IndexDatasetFromDatasetGet.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this IndexDatasetFromDatasetGet.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this IndexDatasetFromDatasetGet.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this IndexDatasetFromDatasetGet.

        The name of the object's owner.

        :param owner: The owner of this IndexDatasetFromDatasetGet.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this IndexDatasetFromDatasetGet.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this IndexDatasetFromDatasetGet.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this IndexDatasetFromDatasetGet.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this IndexDatasetFromDatasetGet.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this IndexDatasetFromDatasetGet.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this IndexDatasetFromDatasetGet.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this IndexDatasetFromDatasetGet.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this IndexDatasetFromDatasetGet.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this IndexDatasetFromDatasetGet.

        Detailed description of the dataset.

        :param description: The description of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this IndexDatasetFromDatasetGet.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this IndexDatasetFromDatasetGet.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this IndexDatasetFromDatasetGet.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def earliest_event_time(self) -> "str":
        """ Gets the earliest_event_time of this IndexDatasetFromDatasetGet.
        The timestamp, in seconds, of the earliest event. The timestamp is in UNIX time.
        """
        return self._attrs.get("earliestEventTime")

    @earliest_event_time.setter
    def earliest_event_time(self, earliest_event_time: "str"):
        """Sets the earliest_event_time of this IndexDatasetFromDatasetGet.

        The timestamp, in seconds, of the earliest event. The timestamp is in UNIX time.

        :param earliest_event_time: The earliest_event_time of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["earliestEventTime"] = earliest_event_time

    @property
    def earliest_ingest_time(self) -> "str":
        """ Gets the earliest_ingest_time of this IndexDatasetFromDatasetGet.
        The earliest index time for any of the events in this index.
        """
        return self._attrs.get("earliestIngestTime")

    @earliest_ingest_time.setter
    def earliest_ingest_time(self, earliest_ingest_time: "str"):
        """Sets the earliest_ingest_time of this IndexDatasetFromDatasetGet.

        The earliest index time for any of the events in this index.

        :param earliest_ingest_time: The earliest_ingest_time of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["earliestIngestTime"] = earliest_ingest_time

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this IndexDatasetFromDatasetGet.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this IndexDatasetFromDatasetGet.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this IndexDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this IndexDatasetFromDatasetGet.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this IndexDatasetFromDatasetGet.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "index"


    @property
    def latest_event_time(self) -> "str":
        """ Gets the latest_event_time of this IndexDatasetFromDatasetGet.
        The timestamp, in seconds, of the latest event. The timestamp is in UNIX time.
        """
        return self._attrs.get("latestEventTime")

    @latest_event_time.setter
    def latest_event_time(self, latest_event_time: "str"):
        """Sets the latest_event_time of this IndexDatasetFromDatasetGet.

        The timestamp, in seconds, of the latest event. The timestamp is in UNIX time.

        :param latest_event_time: The latest_event_time of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["latestEventTime"] = latest_event_time

    @property
    def latest_ingest_time(self) -> "str":
        """ Gets the latest_ingest_time of this IndexDatasetFromDatasetGet.
        The latest index time for any of the events in this index.
        """
        return self._attrs.get("latestIngestTime")

    @latest_ingest_time.setter
    def latest_ingest_time(self, latest_ingest_time: "str"):
        """Sets the latest_ingest_time of this IndexDatasetFromDatasetGet.

        The latest index time for any of the events in this index.

        :param latest_ingest_time: The latest_ingest_time of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["latestIngestTime"] = latest_ingest_time

    @property
    def latest_metadata_update_time(self) -> "str":
        """ Gets the latest_metadata_update_time of this IndexDatasetFromDatasetGet.
        The latest time that the index metadata was refreshed.
        """
        return self._attrs.get("latestMetadataUpdateTime")

    @latest_metadata_update_time.setter
    def latest_metadata_update_time(self, latest_metadata_update_time: "str"):
        """Sets the latest_metadata_update_time of this IndexDatasetFromDatasetGet.

        The latest time that the index metadata was refreshed.

        :param latest_metadata_update_time: The latest_metadata_update_time of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time

    @property
    def summary(self) -> "str":
        """ Gets the summary of this IndexDatasetFromDatasetGet.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this IndexDatasetFromDatasetGet.

        Summary of the dataset's purpose.

        :param summary: The summary of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this IndexDatasetFromDatasetGet.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this IndexDatasetFromDatasetGet.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this IndexDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def total_event_count(self) -> "int":
        """ Gets the total_event_count of this IndexDatasetFromDatasetGet.
        The number of events in the index.
        """
        return self._attrs.get("totalEventCount")

    @total_event_count.setter
    def total_event_count(self, total_event_count: "int"):
        """Sets the total_event_count of this IndexDatasetFromDatasetGet.

        The number of events in the index.

        :param total_event_count: The total_event_count of this IndexDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["totalEventCount"] = total_event_count

    @property
    def total_size(self) -> "int":
        """ Gets the total_size of this IndexDatasetFromDatasetGet.
        The raw size, in bytes, of the uncompressed data in the indexers.
        """
        return self._attrs.get("totalSize")

    @total_size.setter
    def total_size(self, total_size: "int"):
        """Sets the total_size of this IndexDatasetFromDatasetGet.

        The raw size, in bytes, of the uncompressed data in the indexers.

        :param total_size: The total_size of this IndexDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["totalSize"] = total_size

    @property
    def version(self) -> "int":
        """ Gets the version of this IndexDatasetFromDatasetGet.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this IndexDatasetFromDatasetGet.

        The catalog version.

        :param version: The version of this IndexDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["index"] = IndexDatasetFromDatasetGet._from_dict



class IndexDatasetKind(str, Enum):
    INDEX = "index"

    @staticmethod
    def from_value(value: str):
        if value == "index":
            return IndexDatasetKind.INDEX


class IndexDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "IndexDatasetPATCH":
        instance = IndexDatasetPATCH.__new__(IndexDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, disabled: "bool" = None, frozen_time_period_in_secs: "int" = None, kind: "IndexDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """IndexDatasetPATCH"""

        self._attrs = dict()
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this IndexDatasetPATCH.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this IndexDatasetPATCH.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this IndexDatasetPATCH.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this IndexDatasetPATCH.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this IndexDatasetPATCH.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this IndexDatasetPATCH.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def kind(self) -> "IndexDatasetKind":
        """ Gets the kind of this IndexDatasetPATCH.
        """
        return IndexDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "IndexDatasetKind"):
        """Sets the kind of this IndexDatasetPATCH.


        :param kind: The kind of this IndexDatasetPATCH.
        :type: IndexDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this IndexDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this IndexDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this IndexDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this IndexDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this IndexDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this IndexDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this IndexDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this IndexDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this IndexDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class IndexDatasetPOST(DatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "IndexDatasetPOST":
        instance = IndexDatasetPOST.__new__(IndexDatasetPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", disabled: "bool" = None, fields: "List[FieldPOST]" = None, frozen_time_period_in_secs: "int" = None, id: "str" = None, module: "str" = None, **extra):
        """IndexDatasetPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if fields is not None:
            self._attrs["fields"] = fields
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "index" 
        if module is not None:
            self._attrs["module"] = module
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this IndexDatasetPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this IndexDatasetPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this IndexDatasetPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this IndexDatasetPOST.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this IndexDatasetPOST.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this IndexDatasetPOST.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this IndexDatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this IndexDatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this IndexDatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this IndexDatasetPOST.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this IndexDatasetPOST.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this IndexDatasetPOST.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def id(self) -> "str":
        """ Gets the id of this IndexDatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this IndexDatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this IndexDatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "index"


    @property
    def module(self) -> "str":
        """ Gets the module of this IndexDatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this IndexDatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this IndexDatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetPOST.from_dict_handlers["index"] = IndexDatasetPOST._from_dict



class JobDatasetEventSummaryAvailableStatus(str, Enum):
    TRUE = "true"
    FALSE = "false"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "true":
            return JobDatasetEventSummaryAvailableStatus.TRUE
        if value == "false":
            return JobDatasetEventSummaryAvailableStatus.FALSE
        if value == "UNKNOWN":
            return JobDatasetEventSummaryAvailableStatus.UNKNOWN


class JobDatasetFieldSummaryAvailableStatus(str, Enum):
    TRUE = "true"
    FALSE = "false"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "true":
            return JobDatasetFieldSummaryAvailableStatus.TRUE
        if value == "false":
            return JobDatasetFieldSummaryAvailableStatus.FALSE
        if value == "UNKNOWN":
            return JobDatasetFieldSummaryAvailableStatus.UNKNOWN


class JobDatasetPropertiesTimelineMetadata(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "JobDatasetPropertiesTimelineMetadata":
        instance = JobDatasetPropertiesTimelineMetadata.__new__(JobDatasetPropertiesTimelineMetadata)
        instance._attrs = model
        return instance

    def __init__(self, auto: "JobDatasetPropertiesTimelineMetadataAuto" = None, **extra):
        """JobDatasetPropertiesTimelineMetadata"""

        self._attrs = dict()
        if auto is not None:
            self._attrs["auto"] = auto.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def auto(self) -> "JobDatasetPropertiesTimelineMetadataAuto":
        """ Gets the auto of this JobDatasetPropertiesTimelineMetadata.
        """
        return JobDatasetPropertiesTimelineMetadataAuto._from_dict(self._attrs["auto"])

    @auto.setter
    def auto(self, auto: "JobDatasetPropertiesTimelineMetadataAuto"):
        """Sets the auto of this JobDatasetPropertiesTimelineMetadata.


        :param auto: The auto of this JobDatasetPropertiesTimelineMetadata.
        :type: JobDatasetPropertiesTimelineMetadataAuto
        """
        self._attrs["auto"] = auto.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class JobDatasetPropertiesTimelineMetadataAuto(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "JobDatasetPropertiesTimelineMetadataAuto":
        instance = JobDatasetPropertiesTimelineMetadataAuto.__new__(JobDatasetPropertiesTimelineMetadataAuto)
        instance._attrs = model
        return instance

    def __init__(self, event_summary_available: "JobDatasetEventSummaryAvailableStatus" = None, field_summary_available: "JobDatasetFieldSummaryAvailableStatus" = None, time_buckets_available: "JobDatasetTimeBucketsAvailableStatus" = None, **extra):
        """JobDatasetPropertiesTimelineMetadataAuto"""

        self._attrs = dict()
        if event_summary_available is not None:
            self._attrs["eventSummaryAvailable"] = event_summary_available
        if field_summary_available is not None:
            self._attrs["fieldSummaryAvailable"] = field_summary_available
        if time_buckets_available is not None:
            self._attrs["timeBucketsAvailable"] = time_buckets_available
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def event_summary_available(self) -> "JobDatasetEventSummaryAvailableStatus":
        """ Gets the event_summary_available of this JobDatasetPropertiesTimelineMetadataAuto.
        """
        return JobDatasetEventSummaryAvailableStatus.from_value(self._attrs.get("eventSummaryAvailable"))

    @event_summary_available.setter
    def event_summary_available(self, event_summary_available: "JobDatasetEventSummaryAvailableStatus"):
        """Sets the event_summary_available of this JobDatasetPropertiesTimelineMetadataAuto.


        :param event_summary_available: The event_summary_available of this JobDatasetPropertiesTimelineMetadataAuto.
        :type: JobDatasetEventSummaryAvailableStatus
        """
        if isinstance(event_summary_available, Enum):
            self._attrs["eventSummaryAvailable"] = event_summary_available.value
        else:
            self._attrs["eventSummaryAvailable"] = event_summary_available  # If you supply a string, we presume you know the service will take it.

    @property
    def field_summary_available(self) -> "JobDatasetFieldSummaryAvailableStatus":
        """ Gets the field_summary_available of this JobDatasetPropertiesTimelineMetadataAuto.
        """
        return JobDatasetFieldSummaryAvailableStatus.from_value(self._attrs.get("fieldSummaryAvailable"))

    @field_summary_available.setter
    def field_summary_available(self, field_summary_available: "JobDatasetFieldSummaryAvailableStatus"):
        """Sets the field_summary_available of this JobDatasetPropertiesTimelineMetadataAuto.


        :param field_summary_available: The field_summary_available of this JobDatasetPropertiesTimelineMetadataAuto.
        :type: JobDatasetFieldSummaryAvailableStatus
        """
        if isinstance(field_summary_available, Enum):
            self._attrs["fieldSummaryAvailable"] = field_summary_available.value
        else:
            self._attrs["fieldSummaryAvailable"] = field_summary_available  # If you supply a string, we presume you know the service will take it.

    @property
    def time_buckets_available(self) -> "JobDatasetTimeBucketsAvailableStatus":
        """ Gets the time_buckets_available of this JobDatasetPropertiesTimelineMetadataAuto.
        """
        return JobDatasetTimeBucketsAvailableStatus.from_value(self._attrs.get("timeBucketsAvailable"))

    @time_buckets_available.setter
    def time_buckets_available(self, time_buckets_available: "JobDatasetTimeBucketsAvailableStatus"):
        """Sets the time_buckets_available of this JobDatasetPropertiesTimelineMetadataAuto.


        :param time_buckets_available: The time_buckets_available of this JobDatasetPropertiesTimelineMetadataAuto.
        :type: JobDatasetTimeBucketsAvailableStatus
        """
        if isinstance(time_buckets_available, Enum):
            self._attrs["timeBucketsAvailable"] = time_buckets_available.value
        else:
            self._attrs["timeBucketsAvailable"] = time_buckets_available  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class JobDatasetTimeBucketsAvailableStatus(str, Enum):
    TRUE = "true"
    FALSE = "false"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "true":
            return JobDatasetTimeBucketsAvailableStatus.TRUE
        if value == "false":
            return JobDatasetTimeBucketsAvailableStatus.FALSE
        if value == "UNKNOWN":
            return JobDatasetTimeBucketsAvailableStatus.UNKNOWN


class JobDatasetGET(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "JobDatasetGET":
        instance = JobDatasetGET.__new__(JobDatasetGET)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", collect_event_summary: "bool" = None, collect_field_summary: "bool" = None, collect_time_buckets: "bool" = None, completion_time: "str" = None, delete_time: "str" = None, dispatch_time: "str" = None, enable_preview: "bool" = None, execution_time: "float" = None, extract_all_fields: "bool" = None, extract_fields: "str" = None, fields: "List[FieldPOST]" = None, has_side_effects: "bool" = None, id: "str" = None, max_time: "int" = None, module: "str" = None, parameters: "object" = None, parent: "str" = None, percent_complete: "int" = None, query: "str" = None, resolved_earliest: "str" = None, resolved_latest: "str" = None, results_available: "int" = None, search_head: "str" = None, sid: "str" = None, spl: "str" = None, status: "str" = None, timeline_metadata: "JobDatasetPropertiesTimelineMetadata" = None, **extra):
        """JobDatasetGET"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if collect_event_summary is not None:
            self._attrs["collectEventSummary"] = collect_event_summary
        if collect_field_summary is not None:
            self._attrs["collectFieldSummary"] = collect_field_summary
        if collect_time_buckets is not None:
            self._attrs["collectTimeBuckets"] = collect_time_buckets
        if completion_time is not None:
            self._attrs["completionTime"] = completion_time
        if delete_time is not None:
            self._attrs["deleteTime"] = delete_time
        if dispatch_time is not None:
            self._attrs["dispatchTime"] = dispatch_time
        if enable_preview is not None:
            self._attrs["enablePreview"] = enable_preview
        if execution_time is not None:
            self._attrs["executionTime"] = execution_time
        if extract_all_fields is not None:
            self._attrs["extractAllFields"] = extract_all_fields
        if extract_fields is not None:
            self._attrs["extractFields"] = extract_fields
        if fields is not None:
            self._attrs["fields"] = fields
        if has_side_effects is not None:
            self._attrs["hasSideEffects"] = has_side_effects
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "job" 
        if max_time is not None:
            self._attrs["maxTime"] = max_time
        if module is not None:
            self._attrs["module"] = module
        if parameters is not None:
            self._attrs["parameters"] = parameters
        if parent is not None:
            self._attrs["parent"] = parent
        if percent_complete is not None:
            self._attrs["percentComplete"] = percent_complete
        if query is not None:
            self._attrs["query"] = query
        if resolved_earliest is not None:
            self._attrs["resolvedEarliest"] = resolved_earliest
        if resolved_latest is not None:
            self._attrs["resolvedLatest"] = resolved_latest
        if results_available is not None:
            self._attrs["resultsAvailable"] = results_available
        if search_head is not None:
            self._attrs["searchHead"] = search_head
        if sid is not None:
            self._attrs["sid"] = sid
        if spl is not None:
            self._attrs["spl"] = spl
        if status is not None:
            self._attrs["status"] = status
        if timeline_metadata is not None:
            self._attrs["timelineMetadata"] = timeline_metadata.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this JobDatasetGET.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this JobDatasetGET.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this JobDatasetGET.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def collect_event_summary(self) -> "bool":
        """ Gets the collect_event_summary of this JobDatasetGET.
        Was the event summary requested for this searhc job?
        """
        return self._attrs.get("collectEventSummary")

    @collect_event_summary.setter
    def collect_event_summary(self, collect_event_summary: "bool"):
        """Sets the collect_event_summary of this JobDatasetGET.

        Was the event summary requested for this searhc job?

        :param collect_event_summary: The collect_event_summary of this JobDatasetGET.
        :type: bool
        """
        self._attrs["collectEventSummary"] = collect_event_summary

    @property
    def collect_field_summary(self) -> "bool":
        """ Gets the collect_field_summary of this JobDatasetGET.
        Was the field summary requested for this searhc job?
        """
        return self._attrs.get("collectFieldSummary")

    @collect_field_summary.setter
    def collect_field_summary(self, collect_field_summary: "bool"):
        """Sets the collect_field_summary of this JobDatasetGET.

        Was the field summary requested for this searhc job?

        :param collect_field_summary: The collect_field_summary of this JobDatasetGET.
        :type: bool
        """
        self._attrs["collectFieldSummary"] = collect_field_summary

    @property
    def collect_time_buckets(self) -> "bool":
        """ Gets the collect_time_buckets of this JobDatasetGET.
        Were the time bucketes requested for this searhc job?
        """
        return self._attrs.get("collectTimeBuckets")

    @collect_time_buckets.setter
    def collect_time_buckets(self, collect_time_buckets: "bool"):
        """Sets the collect_time_buckets of this JobDatasetGET.

        Were the time bucketes requested for this searhc job?

        :param collect_time_buckets: The collect_time_buckets of this JobDatasetGET.
        :type: bool
        """
        self._attrs["collectTimeBuckets"] = collect_time_buckets

    @property
    def completion_time(self) -> "str":
        """ Gets the completion_time of this JobDatasetGET.
        Time that the job was completed
        """
        return self._attrs.get("completionTime")

    @completion_time.setter
    def completion_time(self, completion_time: "str"):
        """Sets the completion_time of this JobDatasetGET.

        Time that the job was completed

        :param completion_time: The completion_time of this JobDatasetGET.
        :type: str
        """
        self._attrs["completionTime"] = completion_time

    @property
    def delete_time(self) -> "str":
        """ Gets the delete_time of this JobDatasetGET.
        The time the dataset will be available in S3.
        """
        return self._attrs.get("deleteTime")

    @delete_time.setter
    def delete_time(self, delete_time: "str"):
        """Sets the delete_time of this JobDatasetGET.

        The time the dataset will be available in S3.

        :param delete_time: The delete_time of this JobDatasetGET.
        :type: str
        """
        self._attrs["deleteTime"] = delete_time

    @property
    def dispatch_time(self) -> "str":
        """ Gets the dispatch_time of this JobDatasetGET.
        Time that the job was dispatched
        """
        return self._attrs.get("dispatchTime")

    @dispatch_time.setter
    def dispatch_time(self, dispatch_time: "str"):
        """Sets the dispatch_time of this JobDatasetGET.

        Time that the job was dispatched

        :param dispatch_time: The dispatch_time of this JobDatasetGET.
        :type: str
        """
        self._attrs["dispatchTime"] = dispatch_time

    @property
    def enable_preview(self) -> "bool":
        """ Gets the enable_preview of this JobDatasetGET.
        Specifies whether a search is allowed to collect preview results during the runtime, internal search service use only.
        """
        return self._attrs.get("enablePreview")

    @enable_preview.setter
    def enable_preview(self, enable_preview: "bool"):
        """Sets the enable_preview of this JobDatasetGET.

        Specifies whether a search is allowed to collect preview results during the runtime, internal search service use only.

        :param enable_preview: The enable_preview of this JobDatasetGET.
        :type: bool
        """
        self._attrs["enablePreview"] = enable_preview

    @property
    def execution_time(self) -> "float":
        """ Gets the execution_time of this JobDatasetGET.
        The runtime of the search in seconds.
        """
        return self._attrs.get("executionTime")

    @execution_time.setter
    def execution_time(self, execution_time: "float"):
        """Sets the execution_time of this JobDatasetGET.

        The runtime of the search in seconds.

        :param execution_time: The execution_time of this JobDatasetGET.
        :type: float
        """
        self._attrs["executionTime"] = execution_time

    @property
    def extract_all_fields(self) -> "bool":
        """ Gets the extract_all_fields of this JobDatasetGET.
        Should the search produce all fields (including those not explicity mentioned in the SPL)?
        """
        return self._attrs.get("extractAllFields")

    @extract_all_fields.setter
    def extract_all_fields(self, extract_all_fields: "bool"):
        """Sets the extract_all_fields of this JobDatasetGET.

        Should the search produce all fields (including those not explicity mentioned in the SPL)?

        :param extract_all_fields: The extract_all_fields of this JobDatasetGET.
        :type: bool
        """
        self._attrs["extractAllFields"] = extract_all_fields

    @property
    def extract_fields(self) -> "str":
        """ Gets the extract_fields of this JobDatasetGET.
        The fields to extract. Valid values are all, none, or indexed.
        """
        return self._attrs.get("extractFields")

    @extract_fields.setter
    def extract_fields(self, extract_fields: "str"):
        """Sets the extract_fields of this JobDatasetGET.

        The fields to extract. Valid values are all, none, or indexed.

        :param extract_fields: The extract_fields of this JobDatasetGET.
        :type: str
        """
        self._attrs["extractFields"] = extract_fields

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this JobDatasetGET.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this JobDatasetGET.

        The fields to be associated with this dataset.

        :param fields: The fields of this JobDatasetGET.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def has_side_effects(self) -> "bool":
        """ Gets the has_side_effects of this JobDatasetGET.
        Did the SPL query cause any side effects on a dataset?
        """
        return self._attrs.get("hasSideEffects")

    @has_side_effects.setter
    def has_side_effects(self, has_side_effects: "bool"):
        """Sets the has_side_effects of this JobDatasetGET.

        Did the SPL query cause any side effects on a dataset?

        :param has_side_effects: The has_side_effects of this JobDatasetGET.
        :type: bool
        """
        self._attrs["hasSideEffects"] = has_side_effects

    @property
    def id(self) -> "str":
        """ Gets the id of this JobDatasetGET.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this JobDatasetGET.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this JobDatasetGET.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "job"


    @property
    def max_time(self) -> "int":
        """ Gets the max_time of this JobDatasetGET.
        The maximum number of seconds to run this search before finishing.
        """
        return self._attrs.get("maxTime")

    @max_time.setter
    def max_time(self, max_time: "int"):
        """Sets the max_time of this JobDatasetGET.

        The maximum number of seconds to run this search before finishing.

        :param max_time: The max_time of this JobDatasetGET.
        :type: int
        """
        self._attrs["maxTime"] = max_time

    @property
    def module(self) -> "str":
        """ Gets the module of this JobDatasetGET.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this JobDatasetGET.

        The name of the module to create the new dataset in.

        :param module: The module of this JobDatasetGET.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def parameters(self) -> "dict":
        """ Gets the parameters of this JobDatasetGET.
        Parameters for the search job, mainly earliest, latest, timezone, and relativeTimeAnchor.
        """
        return self._attrs.get("parameters")

    @parameters.setter
    def parameters(self, parameters: "dict"):
        """Sets the parameters of this JobDatasetGET.

        Parameters for the search job, mainly earliest, latest, timezone, and relativeTimeAnchor.

        :param parameters: The parameters of this JobDatasetGET.
        :type: object
        """
        self._attrs["parameters"] = parameters

    @property
    def parent(self) -> "str":
        """ Gets the parent of this JobDatasetGET.
        The parent's ID of the search job.
        """
        return self._attrs.get("parent")

    @parent.setter
    def parent(self, parent: "str"):
        """Sets the parent of this JobDatasetGET.

        The parent's ID of the search job.

        :param parent: The parent of this JobDatasetGET.
        :type: str
        """
        self._attrs["parent"] = parent

    @property
    def percent_complete(self) -> "int":
        """ Gets the percent_complete of this JobDatasetGET.
        An estimate of how complete the search job is.
        """
        return self._attrs.get("percentComplete")

    @percent_complete.setter
    def percent_complete(self, percent_complete: "int"):
        """Sets the percent_complete of this JobDatasetGET.

        An estimate of how complete the search job is.

        :param percent_complete: The percent_complete of this JobDatasetGET.
        :type: int
        """
        self._attrs["percentComplete"] = percent_complete

    @property
    def query(self) -> "str":
        """ Gets the query of this JobDatasetGET.
        The SPL query string for the search job.
        """
        return self._attrs.get("query")

    @query.setter
    def query(self, query: "str"):
        """Sets the query of this JobDatasetGET.

        The SPL query string for the search job.

        :param query: The query of this JobDatasetGET.
        :type: str
        """
        self._attrs["query"] = query

    @property
    def resolved_earliest(self) -> "str":
        """ Gets the resolved_earliest of this JobDatasetGET.
        Resolved earliest time for the job
        """
        return self._attrs.get("resolvedEarliest")

    @resolved_earliest.setter
    def resolved_earliest(self, resolved_earliest: "str"):
        """Sets the resolved_earliest of this JobDatasetGET.

        Resolved earliest time for the job

        :param resolved_earliest: The resolved_earliest of this JobDatasetGET.
        :type: str
        """
        self._attrs["resolvedEarliest"] = resolved_earliest

    @property
    def resolved_latest(self) -> "str":
        """ Gets the resolved_latest of this JobDatasetGET.
        Resolved latest time for the job
        """
        return self._attrs.get("resolvedLatest")

    @resolved_latest.setter
    def resolved_latest(self, resolved_latest: "str"):
        """Sets the resolved_latest of this JobDatasetGET.

        Resolved latest time for the job

        :param resolved_latest: The resolved_latest of this JobDatasetGET.
        :type: str
        """
        self._attrs["resolvedLatest"] = resolved_latest

    @property
    def results_available(self) -> "int":
        """ Gets the results_available of this JobDatasetGET.
        The instantaneous number of results produced by the search job.
        """
        return self._attrs.get("resultsAvailable")

    @results_available.setter
    def results_available(self, results_available: "int"):
        """Sets the results_available of this JobDatasetGET.

        The instantaneous number of results produced by the search job.

        :param results_available: The results_available of this JobDatasetGET.
        :type: int
        """
        self._attrs["resultsAvailable"] = results_available

    @property
    def search_head(self) -> "str":
        """ Gets the search_head of this JobDatasetGET.
        The search head that started this search job.
        """
        return self._attrs.get("searchHead")

    @search_head.setter
    def search_head(self, search_head: "str"):
        """Sets the search_head of this JobDatasetGET.

        The search head that started this search job.

        :param search_head: The search_head of this JobDatasetGET.
        :type: str
        """
        self._attrs["searchHead"] = search_head

    @property
    def sid(self) -> "str":
        """ Gets the sid of this JobDatasetGET.
        The ID assigned to the search job.
        """
        return self._attrs.get("sid")

    @sid.setter
    def sid(self, sid: "str"):
        """Sets the sid of this JobDatasetGET.

        The ID assigned to the search job.

        :param sid: The sid of this JobDatasetGET.
        :type: str
        """
        self._attrs["sid"] = sid

    @property
    def spl(self) -> "str":
        """ Gets the spl of this JobDatasetGET.
        The SPLv2 version of the search job query string.
        """
        return self._attrs.get("spl")

    @spl.setter
    def spl(self, spl: "str"):
        """Sets the spl of this JobDatasetGET.

        The SPLv2 version of the search job query string.

        :param spl: The spl of this JobDatasetGET.
        :type: str
        """
        self._attrs["spl"] = spl

    @property
    def status(self) -> "str":
        """ Gets the status of this JobDatasetGET.
        The current status of the search job.
        """
        return self._attrs.get("status")

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this JobDatasetGET.

        The current status of the search job.

        :param status: The status of this JobDatasetGET.
        :type: str
        """
        self._attrs["status"] = status

    @property
    def timeline_metadata(self) -> "JobDatasetPropertiesTimelineMetadata":
        """ Gets the timeline_metadata of this JobDatasetGET.
        """
        return JobDatasetPropertiesTimelineMetadata._from_dict(self._attrs["timelineMetadata"])

    @timeline_metadata.setter
    def timeline_metadata(self, timeline_metadata: "JobDatasetPropertiesTimelineMetadata"):
        """Sets the timeline_metadata of this JobDatasetGET.


        :param timeline_metadata: The timeline_metadata of this JobDatasetGET.
        :type: JobDatasetPropertiesTimelineMetadata
        """
        self._attrs["timelineMetadata"] = timeline_metadata.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["job"] = JobDatasetGET._from_dict



class JobDatasetKind(str, Enum):
    JOB = "job"

    @staticmethod
    def from_value(value: str):
        if value == "job":
            return JobDatasetKind.JOB


class KVCollectionDatasetFromDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "KVCollectionDatasetFromDataset":
        instance = KVCollectionDatasetFromDataset.__new__(KVCollectionDatasetFromDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """KVCollectionDatasetFromDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "kvcollection" 
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this KVCollectionDatasetFromDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this KVCollectionDatasetFromDataset.

        The date and time object was created.

        :param created: The created of this KVCollectionDatasetFromDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this KVCollectionDatasetFromDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this KVCollectionDatasetFromDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this KVCollectionDatasetFromDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this KVCollectionDatasetFromDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this KVCollectionDatasetFromDataset.

        A unique dataset ID.

        :param id: The id of this KVCollectionDatasetFromDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this KVCollectionDatasetFromDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this KVCollectionDatasetFromDataset.

        The date and time object was modified.

        :param modified: The modified of this KVCollectionDatasetFromDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this KVCollectionDatasetFromDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this KVCollectionDatasetFromDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this KVCollectionDatasetFromDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this KVCollectionDatasetFromDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this KVCollectionDatasetFromDataset.

        The name of the module that contains the dataset.

        :param module: The module of this KVCollectionDatasetFromDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this KVCollectionDatasetFromDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this KVCollectionDatasetFromDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this KVCollectionDatasetFromDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this KVCollectionDatasetFromDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this KVCollectionDatasetFromDataset.

        The name of the object's owner.

        :param owner: The owner of this KVCollectionDatasetFromDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this KVCollectionDatasetFromDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this KVCollectionDatasetFromDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this KVCollectionDatasetFromDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this KVCollectionDatasetFromDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this KVCollectionDatasetFromDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this KVCollectionDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this KVCollectionDatasetFromDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this KVCollectionDatasetFromDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this KVCollectionDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this KVCollectionDatasetFromDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this KVCollectionDatasetFromDataset.

        Detailed description of the dataset.

        :param description: The description of this KVCollectionDatasetFromDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this KVCollectionDatasetFromDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this KVCollectionDatasetFromDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this KVCollectionDatasetFromDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "kvcollection"


    @property
    def summary(self) -> "str":
        """ Gets the summary of this KVCollectionDatasetFromDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this KVCollectionDatasetFromDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this KVCollectionDatasetFromDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this KVCollectionDatasetFromDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this KVCollectionDatasetFromDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this KVCollectionDatasetFromDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this KVCollectionDatasetFromDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this KVCollectionDatasetFromDataset.

        The catalog version.

        :param version: The version of this KVCollectionDatasetFromDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["kvcollection"] = KVCollectionDatasetFromDataset._from_dict



class KVCollectionDatasetFromDatasetGet(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "KVCollectionDatasetFromDatasetGet":
        instance = KVCollectionDatasetFromDatasetGet.__new__(KVCollectionDatasetFromDatasetGet)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """KVCollectionDatasetFromDatasetGet"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "kvcollection" 
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this KVCollectionDatasetFromDatasetGet.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this KVCollectionDatasetFromDatasetGet.

        The date and time object was created.

        :param created: The created of this KVCollectionDatasetFromDatasetGet.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this KVCollectionDatasetFromDatasetGet.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this KVCollectionDatasetFromDatasetGet.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this KVCollectionDatasetFromDatasetGet.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this KVCollectionDatasetFromDatasetGet.

        A unique dataset ID.

        :param id: The id of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this KVCollectionDatasetFromDatasetGet.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this KVCollectionDatasetFromDatasetGet.

        The date and time object was modified.

        :param modified: The modified of this KVCollectionDatasetFromDatasetGet.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this KVCollectionDatasetFromDatasetGet.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this KVCollectionDatasetFromDatasetGet.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this KVCollectionDatasetFromDatasetGet.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this KVCollectionDatasetFromDatasetGet.

        The name of the module that contains the dataset.

        :param module: The module of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this KVCollectionDatasetFromDatasetGet.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this KVCollectionDatasetFromDatasetGet.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this KVCollectionDatasetFromDatasetGet.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this KVCollectionDatasetFromDatasetGet.

        The name of the object's owner.

        :param owner: The owner of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this KVCollectionDatasetFromDatasetGet.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this KVCollectionDatasetFromDatasetGet.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this KVCollectionDatasetFromDatasetGet.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this KVCollectionDatasetFromDatasetGet.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this KVCollectionDatasetFromDatasetGet.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this KVCollectionDatasetFromDatasetGet.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this KVCollectionDatasetFromDatasetGet.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this KVCollectionDatasetFromDatasetGet.

        Detailed description of the dataset.

        :param description: The description of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this KVCollectionDatasetFromDatasetGet.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this KVCollectionDatasetFromDatasetGet.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "kvcollection"


    @property
    def summary(self) -> "str":
        """ Gets the summary of this KVCollectionDatasetFromDatasetGet.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this KVCollectionDatasetFromDatasetGet.

        Summary of the dataset's purpose.

        :param summary: The summary of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this KVCollectionDatasetFromDatasetGet.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this KVCollectionDatasetFromDatasetGet.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this KVCollectionDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this KVCollectionDatasetFromDatasetGet.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this KVCollectionDatasetFromDatasetGet.

        The catalog version.

        :param version: The version of this KVCollectionDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["kvcollection"] = KVCollectionDatasetFromDatasetGet._from_dict



class KVCollectionDatasetKind(str, Enum):
    KVCOLLECTION = "kvcollection"

    @staticmethod
    def from_value(value: str):
        if value == "kvcollection":
            return KVCollectionDatasetKind.KVCOLLECTION


class KVCollectionDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "KVCollectionDatasetPATCH":
        instance = KVCollectionDatasetPATCH.__new__(KVCollectionDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, kind: "KVCollectionDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """KVCollectionDatasetPATCH"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "KVCollectionDatasetKind":
        """ Gets the kind of this KVCollectionDatasetPATCH.
        """
        return KVCollectionDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "KVCollectionDatasetKind"):
        """Sets the kind of this KVCollectionDatasetPATCH.


        :param kind: The kind of this KVCollectionDatasetPATCH.
        :type: KVCollectionDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this KVCollectionDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this KVCollectionDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this KVCollectionDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this KVCollectionDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this KVCollectionDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this KVCollectionDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this KVCollectionDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this KVCollectionDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this KVCollectionDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KVCollectionDatasetPOST(DatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "KVCollectionDatasetPOST":
        instance = KVCollectionDatasetPOST.__new__(KVCollectionDatasetPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", fields: "List[FieldPOST]" = None, id: "str" = None, module: "str" = None, **extra):
        """KVCollectionDatasetPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "kvcollection" 
        if module is not None:
            self._attrs["module"] = module
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this KVCollectionDatasetPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this KVCollectionDatasetPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this KVCollectionDatasetPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this KVCollectionDatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this KVCollectionDatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this KVCollectionDatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this KVCollectionDatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this KVCollectionDatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this KVCollectionDatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "kvcollection"


    @property
    def module(self) -> "str":
        """ Gets the module of this KVCollectionDatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this KVCollectionDatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this KVCollectionDatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetPOST.from_dict_handlers["kvcollection"] = KVCollectionDatasetPOST._from_dict



class LookupActionFromAction(Action):

    @staticmethod
    def _from_dict(model: dict) -> "LookupActionFromAction":
        instance = LookupActionFromAction.__new__(LookupActionFromAction)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, expression: "str" = None, id: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """LookupActionFromAction"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if expression is not None:
            self._attrs["expression"] = expression
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "LOOKUP" 
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this LookupActionFromAction.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this LookupActionFromAction.

        The date and time object was created.

        :param created: The created of this LookupActionFromAction.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this LookupActionFromAction.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this LookupActionFromAction.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this LookupActionFromAction.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this LookupActionFromAction.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this LookupActionFromAction.

        The date and time object was modified.

        :param modified: The modified of this LookupActionFromAction.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this LookupActionFromAction.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this LookupActionFromAction.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this LookupActionFromAction.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupActionFromAction.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupActionFromAction.

        The name of the object's owner.

        :param owner: The owner of this LookupActionFromAction.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this LookupActionFromAction.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this LookupActionFromAction.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this LookupActionFromAction.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this LookupActionFromAction.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this LookupActionFromAction.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this LookupActionFromAction.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def expression(self) -> "str":
        """ Gets the expression of this LookupActionFromAction.
        The lookup body.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this LookupActionFromAction.

        The lookup body.

        :param expression: The expression of this LookupActionFromAction.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def id(self) -> "str":
        """ Gets the id of this LookupActionFromAction.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this LookupActionFromAction.

        A unique action ID.

        :param id: The id of this LookupActionFromAction.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "LOOKUP"


    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this LookupActionFromAction.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this LookupActionFromAction.

        The rule that this action is part of.

        :param ruleid: The ruleid of this LookupActionFromAction.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this LookupActionFromAction.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this LookupActionFromAction.

        The catalog version.

        :param version: The version of this LookupActionFromAction.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Action.from_dict_handlers["LOOKUP"] = LookupActionFromAction._from_dict



class LookupActionFromActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "LookupActionFromActionPOST":
        instance = LookupActionFromActionPOST.__new__(LookupActionFromActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, expression: "str" = None, id: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """LookupActionFromActionPOST"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if expression is not None:
            self._attrs["expression"] = expression
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "LOOKUP" 
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this LookupActionFromActionPOST.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this LookupActionFromActionPOST.

        The date and time object was created.

        :param created: The created of this LookupActionFromActionPOST.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this LookupActionFromActionPOST.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this LookupActionFromActionPOST.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this LookupActionFromActionPOST.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this LookupActionFromActionPOST.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this LookupActionFromActionPOST.

        The date and time object was modified.

        :param modified: The modified of this LookupActionFromActionPOST.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this LookupActionFromActionPOST.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this LookupActionFromActionPOST.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this LookupActionFromActionPOST.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupActionFromActionPOST.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupActionFromActionPOST.

        The name of the object's owner.

        :param owner: The owner of this LookupActionFromActionPOST.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this LookupActionFromActionPOST.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this LookupActionFromActionPOST.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this LookupActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this LookupActionFromActionPOST.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this LookupActionFromActionPOST.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this LookupActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def expression(self) -> "str":
        """ Gets the expression of this LookupActionFromActionPOST.
        The lookup body.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this LookupActionFromActionPOST.

        The lookup body.

        :param expression: The expression of this LookupActionFromActionPOST.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def id(self) -> "str":
        """ Gets the id of this LookupActionFromActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this LookupActionFromActionPOST.

        A unique action ID.

        :param id: The id of this LookupActionFromActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "LOOKUP"


    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this LookupActionFromActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this LookupActionFromActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this LookupActionFromActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this LookupActionFromActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this LookupActionFromActionPOST.

        The catalog version.

        :param version: The version of this LookupActionFromActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


ActionPOST.from_dict_handlers["LOOKUP"] = LookupActionFromActionPOST._from_dict



class LookupActionKind(str, Enum):
    LOOKUP = "LOOKUP"

    @staticmethod
    def from_value(value: str):
        if value == "LOOKUP":
            return LookupActionKind.LOOKUP


class LookupActionPATCH(ActionPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "LookupActionPATCH":
        instance = LookupActionPATCH.__new__(LookupActionPATCH)
        instance._attrs = model
        return instance

    def __init__(self, expression: "str" = None, kind: "LookupActionKind" = None, owner: "str" = None, version: "int" = None, **extra):
        """LookupActionPATCH"""

        self._attrs = dict()
        if expression is not None:
            self._attrs["expression"] = expression
        if kind is not None:
            self._attrs["kind"] = kind
        if owner is not None:
            self._attrs["owner"] = owner
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def expression(self) -> "str":
        """ Gets the expression of this LookupActionPATCH.
        The lookup body.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this LookupActionPATCH.

        The lookup body.

        :param expression: The expression of this LookupActionPATCH.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def kind(self) -> "LookupActionKind":
        """ Gets the kind of this LookupActionPATCH.
        """
        return LookupActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "LookupActionKind"):
        """Sets the kind of this LookupActionPATCH.


        :param kind: The kind of this LookupActionPATCH.
        :type: LookupActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupActionPATCH.
        The name of the user who owns this action. This value is obtained from the bearer token if not present.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupActionPATCH.

        The name of the user who owns this action. This value is obtained from the bearer token if not present.

        :param owner: The owner of this LookupActionPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def version(self) -> "int":
        """ Gets the version of this LookupActionPATCH.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this LookupActionPATCH.

        The catalog version.

        :param version: The version of this LookupActionPATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class LookupActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "LookupActionPOST":
        instance = LookupActionPOST.__new__(LookupActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, expression: "str" = None, id: "str" = None, kind: "LookupActionKind" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """LookupActionPOST"""

        self._attrs = dict()
        if expression is not None:
            self._attrs["expression"] = expression
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def expression(self) -> "str":
        """ Gets the expression of this LookupActionPOST.
        The lookup body.
        """
        return self._attrs.get("expression")

    @expression.setter
    def expression(self, expression: "str"):
        """Sets the expression of this LookupActionPOST.

        The lookup body.

        :param expression: The expression of this LookupActionPOST.
        :type: str
        """
        self._attrs["expression"] = expression

    @property
    def id(self) -> "str":
        """ Gets the id of this LookupActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this LookupActionPOST.

        A unique action ID.

        :param id: The id of this LookupActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "LookupActionKind":
        """ Gets the kind of this LookupActionPOST.
        """
        return LookupActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "LookupActionKind"):
        """Sets the kind of this LookupActionPOST.


        :param kind: The kind of this LookupActionPOST.
        :type: LookupActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this LookupActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this LookupActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this LookupActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this LookupActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this LookupActionPOST.

        The catalog version.

        :param version: The version of this LookupActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class LookupDatasetExternalKind(str, Enum):
    KVCOLLECTION = "kvcollection"

    @staticmethod
    def from_value(value: str):
        if value == "kvcollection":
            return LookupDatasetExternalKind.KVCOLLECTION


class LookupDatasetFromDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "LookupDatasetFromDataset":
        instance = LookupDatasetFromDataset.__new__(LookupDatasetFromDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, case_sensitive_match: "bool" = True, description: "str" = None, external_kind: "LookupDatasetExternalKind" = None, external_name: "str" = None, filter: "str" = None, internalname: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """LookupDatasetFromDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if case_sensitive_match is not None:
            self._attrs["caseSensitiveMatch"] = case_sensitive_match
        if description is not None:
            self._attrs["description"] = description
        if external_kind is not None:
            self._attrs["externalKind"] = external_kind
        if external_name is not None:
            self._attrs["externalName"] = external_name
        if filter is not None:
            self._attrs["filter"] = filter
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "lookup" 
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this LookupDatasetFromDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this LookupDatasetFromDataset.

        The date and time object was created.

        :param created: The created of this LookupDatasetFromDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this LookupDatasetFromDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this LookupDatasetFromDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this LookupDatasetFromDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this LookupDatasetFromDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this LookupDatasetFromDataset.

        A unique dataset ID.

        :param id: The id of this LookupDatasetFromDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this LookupDatasetFromDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this LookupDatasetFromDataset.

        The date and time object was modified.

        :param modified: The modified of this LookupDatasetFromDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this LookupDatasetFromDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this LookupDatasetFromDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this LookupDatasetFromDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this LookupDatasetFromDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this LookupDatasetFromDataset.

        The name of the module that contains the dataset.

        :param module: The module of this LookupDatasetFromDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this LookupDatasetFromDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this LookupDatasetFromDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this LookupDatasetFromDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupDatasetFromDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupDatasetFromDataset.

        The name of the object's owner.

        :param owner: The owner of this LookupDatasetFromDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this LookupDatasetFromDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this LookupDatasetFromDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this LookupDatasetFromDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this LookupDatasetFromDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this LookupDatasetFromDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this LookupDatasetFromDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this LookupDatasetFromDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def case_sensitive_match(self) -> "bool":
        """ Gets the case_sensitive_match of this LookupDatasetFromDataset.
        Match case-sensitively against the lookup.
        """
        return self._attrs.get("caseSensitiveMatch")

    @case_sensitive_match.setter
    def case_sensitive_match(self, case_sensitive_match: "bool"):
        """Sets the case_sensitive_match of this LookupDatasetFromDataset.

        Match case-sensitively against the lookup.

        :param case_sensitive_match: The case_sensitive_match of this LookupDatasetFromDataset.
        :type: bool
        """
        self._attrs["caseSensitiveMatch"] = case_sensitive_match

    @property
    def description(self) -> "str":
        """ Gets the description of this LookupDatasetFromDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this LookupDatasetFromDataset.

        Detailed description of the dataset.

        :param description: The description of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def external_kind(self) -> "LookupDatasetExternalKind":
        """ Gets the external_kind of this LookupDatasetFromDataset.
        """
        return LookupDatasetExternalKind.from_value(self._attrs.get("externalKind"))

    @external_kind.setter
    def external_kind(self, external_kind: "LookupDatasetExternalKind"):
        """Sets the external_kind of this LookupDatasetFromDataset.


        :param external_kind: The external_kind of this LookupDatasetFromDataset.
        :type: LookupDatasetExternalKind
        """
        if isinstance(external_kind, Enum):
            self._attrs["externalKind"] = external_kind.value
        else:
            self._attrs["externalKind"] = external_kind  # If you supply a string, we presume you know the service will take it.

    @property
    def external_name(self) -> "str":
        """ Gets the external_name of this LookupDatasetFromDataset.
        The name of the external lookup.
        """
        return self._attrs.get("externalName")

    @external_name.setter
    def external_name(self, external_name: "str"):
        """Sets the external_name of this LookupDatasetFromDataset.

        The name of the external lookup.

        :param external_name: The external_name of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["externalName"] = external_name

    @property
    def filter(self) -> "str":
        """ Gets the filter of this LookupDatasetFromDataset.
        A query that filters results out of the lookup before those results are returned.
        """
        return self._attrs.get("filter")

    @filter.setter
    def filter(self, filter: "str"):
        """Sets the filter of this LookupDatasetFromDataset.

        A query that filters results out of the lookup before those results are returned.

        :param filter: The filter of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["filter"] = filter

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this LookupDatasetFromDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this LookupDatasetFromDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "lookup"


    @property
    def summary(self) -> "str":
        """ Gets the summary of this LookupDatasetFromDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this LookupDatasetFromDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this LookupDatasetFromDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this LookupDatasetFromDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this LookupDatasetFromDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this LookupDatasetFromDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this LookupDatasetFromDataset.

        The catalog version.

        :param version: The version of this LookupDatasetFromDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["lookup"] = LookupDatasetFromDataset._from_dict



class LookupDatasetFromDatasetGet(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "LookupDatasetFromDatasetGet":
        instance = LookupDatasetFromDatasetGet.__new__(LookupDatasetFromDatasetGet)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, case_sensitive_match: "bool" = True, description: "str" = None, external_kind: "LookupDatasetExternalKind" = None, external_name: "str" = None, filter: "str" = None, internalname: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """LookupDatasetFromDatasetGet"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if case_sensitive_match is not None:
            self._attrs["caseSensitiveMatch"] = case_sensitive_match
        if description is not None:
            self._attrs["description"] = description
        if external_kind is not None:
            self._attrs["externalKind"] = external_kind
        if external_name is not None:
            self._attrs["externalName"] = external_name
        if filter is not None:
            self._attrs["filter"] = filter
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "lookup" 
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this LookupDatasetFromDatasetGet.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this LookupDatasetFromDatasetGet.

        The date and time object was created.

        :param created: The created of this LookupDatasetFromDatasetGet.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this LookupDatasetFromDatasetGet.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this LookupDatasetFromDatasetGet.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this LookupDatasetFromDatasetGet.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this LookupDatasetFromDatasetGet.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this LookupDatasetFromDatasetGet.

        A unique dataset ID.

        :param id: The id of this LookupDatasetFromDatasetGet.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this LookupDatasetFromDatasetGet.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this LookupDatasetFromDatasetGet.

        The date and time object was modified.

        :param modified: The modified of this LookupDatasetFromDatasetGet.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this LookupDatasetFromDatasetGet.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this LookupDatasetFromDatasetGet.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this LookupDatasetFromDatasetGet.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this LookupDatasetFromDatasetGet.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this LookupDatasetFromDatasetGet.

        The name of the module that contains the dataset.

        :param module: The module of this LookupDatasetFromDatasetGet.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this LookupDatasetFromDatasetGet.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this LookupDatasetFromDatasetGet.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this LookupDatasetFromDatasetGet.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupDatasetFromDatasetGet.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupDatasetFromDatasetGet.

        The name of the object's owner.

        :param owner: The owner of this LookupDatasetFromDatasetGet.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this LookupDatasetFromDatasetGet.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this LookupDatasetFromDatasetGet.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this LookupDatasetFromDatasetGet.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this LookupDatasetFromDatasetGet.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this LookupDatasetFromDatasetGet.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this LookupDatasetFromDatasetGet.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this LookupDatasetFromDatasetGet.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def case_sensitive_match(self) -> "bool":
        """ Gets the case_sensitive_match of this LookupDatasetFromDatasetGet.
        Match case-sensitively against the lookup.
        """
        return self._attrs.get("caseSensitiveMatch")

    @case_sensitive_match.setter
    def case_sensitive_match(self, case_sensitive_match: "bool"):
        """Sets the case_sensitive_match of this LookupDatasetFromDatasetGet.

        Match case-sensitively against the lookup.

        :param case_sensitive_match: The case_sensitive_match of this LookupDatasetFromDatasetGet.
        :type: bool
        """
        self._attrs["caseSensitiveMatch"] = case_sensitive_match

    @property
    def description(self) -> "str":
        """ Gets the description of this LookupDatasetFromDatasetGet.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this LookupDatasetFromDatasetGet.

        Detailed description of the dataset.

        :param description: The description of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def external_kind(self) -> "LookupDatasetExternalKind":
        """ Gets the external_kind of this LookupDatasetFromDatasetGet.
        """
        return LookupDatasetExternalKind.from_value(self._attrs.get("externalKind"))

    @external_kind.setter
    def external_kind(self, external_kind: "LookupDatasetExternalKind"):
        """Sets the external_kind of this LookupDatasetFromDatasetGet.


        :param external_kind: The external_kind of this LookupDatasetFromDatasetGet.
        :type: LookupDatasetExternalKind
        """
        if isinstance(external_kind, Enum):
            self._attrs["externalKind"] = external_kind.value
        else:
            self._attrs["externalKind"] = external_kind  # If you supply a string, we presume you know the service will take it.

    @property
    def external_name(self) -> "str":
        """ Gets the external_name of this LookupDatasetFromDatasetGet.
        The name of the external lookup.
        """
        return self._attrs.get("externalName")

    @external_name.setter
    def external_name(self, external_name: "str"):
        """Sets the external_name of this LookupDatasetFromDatasetGet.

        The name of the external lookup.

        :param external_name: The external_name of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["externalName"] = external_name

    @property
    def filter(self) -> "str":
        """ Gets the filter of this LookupDatasetFromDatasetGet.
        A query that filters results out of the lookup before those results are returned.
        """
        return self._attrs.get("filter")

    @filter.setter
    def filter(self, filter: "str"):
        """Sets the filter of this LookupDatasetFromDatasetGet.

        A query that filters results out of the lookup before those results are returned.

        :param filter: The filter of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["filter"] = filter

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this LookupDatasetFromDatasetGet.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this LookupDatasetFromDatasetGet.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "lookup"


    @property
    def summary(self) -> "str":
        """ Gets the summary of this LookupDatasetFromDatasetGet.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this LookupDatasetFromDatasetGet.

        Summary of the dataset's purpose.

        :param summary: The summary of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this LookupDatasetFromDatasetGet.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this LookupDatasetFromDatasetGet.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this LookupDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this LookupDatasetFromDatasetGet.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this LookupDatasetFromDatasetGet.

        The catalog version.

        :param version: The version of this LookupDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["lookup"] = LookupDatasetFromDatasetGet._from_dict



class LookupDatasetKind(str, Enum):
    LOOKUP = "lookup"

    @staticmethod
    def from_value(value: str):
        if value == "lookup":
            return LookupDatasetKind.LOOKUP


class LookupDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "LookupDatasetPATCH":
        instance = LookupDatasetPATCH.__new__(LookupDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, case_sensitive_match: "bool" = True, external_kind: "LookupDatasetExternalKind" = None, external_name: "str" = None, filter: "str" = None, kind: "LookupDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """LookupDatasetPATCH"""

        self._attrs = dict()
        if case_sensitive_match is not None:
            self._attrs["caseSensitiveMatch"] = case_sensitive_match
        if external_kind is not None:
            self._attrs["externalKind"] = external_kind
        if external_name is not None:
            self._attrs["externalName"] = external_name
        if filter is not None:
            self._attrs["filter"] = filter
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def case_sensitive_match(self) -> "bool":
        """ Gets the case_sensitive_match of this LookupDatasetPATCH.
        Match case-sensitively against the lookup.
        """
        return self._attrs.get("caseSensitiveMatch")

    @case_sensitive_match.setter
    def case_sensitive_match(self, case_sensitive_match: "bool"):
        """Sets the case_sensitive_match of this LookupDatasetPATCH.

        Match case-sensitively against the lookup.

        :param case_sensitive_match: The case_sensitive_match of this LookupDatasetPATCH.
        :type: bool
        """
        self._attrs["caseSensitiveMatch"] = case_sensitive_match

    @property
    def external_kind(self) -> "LookupDatasetExternalKind":
        """ Gets the external_kind of this LookupDatasetPATCH.
        """
        return LookupDatasetExternalKind.from_value(self._attrs.get("externalKind"))

    @external_kind.setter
    def external_kind(self, external_kind: "LookupDatasetExternalKind"):
        """Sets the external_kind of this LookupDatasetPATCH.


        :param external_kind: The external_kind of this LookupDatasetPATCH.
        :type: LookupDatasetExternalKind
        """
        if isinstance(external_kind, Enum):
            self._attrs["externalKind"] = external_kind.value
        else:
            self._attrs["externalKind"] = external_kind  # If you supply a string, we presume you know the service will take it.

    @property
    def external_name(self) -> "str":
        """ Gets the external_name of this LookupDatasetPATCH.
        The name of the external lookup.
        """
        return self._attrs.get("externalName")

    @external_name.setter
    def external_name(self, external_name: "str"):
        """Sets the external_name of this LookupDatasetPATCH.

        The name of the external lookup.

        :param external_name: The external_name of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["externalName"] = external_name

    @property
    def filter(self) -> "str":
        """ Gets the filter of this LookupDatasetPATCH.
        A query that filters results out of the lookup before those results are returned.
        """
        return self._attrs.get("filter")

    @filter.setter
    def filter(self, filter: "str"):
        """Sets the filter of this LookupDatasetPATCH.

        A query that filters results out of the lookup before those results are returned.

        :param filter: The filter of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["filter"] = filter

    @property
    def kind(self) -> "LookupDatasetKind":
        """ Gets the kind of this LookupDatasetPATCH.
        """
        return LookupDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "LookupDatasetKind"):
        """Sets the kind of this LookupDatasetPATCH.


        :param kind: The kind of this LookupDatasetPATCH.
        :type: LookupDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this LookupDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this LookupDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this LookupDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this LookupDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class LookupDatasetPOST(DatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "LookupDatasetPOST":
        instance = LookupDatasetPOST.__new__(LookupDatasetPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", case_sensitive_match: "bool" = True, external_kind: "LookupDatasetExternalKind" = None, external_name: "str" = None, fields: "List[FieldPOST]" = None, filter: "str" = None, id: "str" = None, module: "str" = None, **extra):
        """LookupDatasetPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if case_sensitive_match is not None:
            self._attrs["caseSensitiveMatch"] = case_sensitive_match
        if external_kind is not None:
            self._attrs["externalKind"] = external_kind
        if external_name is not None:
            self._attrs["externalName"] = external_name
        if fields is not None:
            self._attrs["fields"] = fields
        if filter is not None:
            self._attrs["filter"] = filter
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "lookup" 
        if module is not None:
            self._attrs["module"] = module
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this LookupDatasetPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this LookupDatasetPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this LookupDatasetPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def case_sensitive_match(self) -> "bool":
        """ Gets the case_sensitive_match of this LookupDatasetPOST.
        Match case-sensitively against the lookup.
        """
        return self._attrs.get("caseSensitiveMatch")

    @case_sensitive_match.setter
    def case_sensitive_match(self, case_sensitive_match: "bool"):
        """Sets the case_sensitive_match of this LookupDatasetPOST.

        Match case-sensitively against the lookup.

        :param case_sensitive_match: The case_sensitive_match of this LookupDatasetPOST.
        :type: bool
        """
        self._attrs["caseSensitiveMatch"] = case_sensitive_match

    @property
    def external_kind(self) -> "LookupDatasetExternalKind":
        """ Gets the external_kind of this LookupDatasetPOST.
        """
        return LookupDatasetExternalKind.from_value(self._attrs.get("externalKind"))

    @external_kind.setter
    def external_kind(self, external_kind: "LookupDatasetExternalKind"):
        """Sets the external_kind of this LookupDatasetPOST.


        :param external_kind: The external_kind of this LookupDatasetPOST.
        :type: LookupDatasetExternalKind
        """
        if isinstance(external_kind, Enum):
            self._attrs["externalKind"] = external_kind.value
        else:
            self._attrs["externalKind"] = external_kind  # If you supply a string, we presume you know the service will take it.

    @property
    def external_name(self) -> "str":
        """ Gets the external_name of this LookupDatasetPOST.
        The name of the external lookup.
        """
        return self._attrs.get("externalName")

    @external_name.setter
    def external_name(self, external_name: "str"):
        """Sets the external_name of this LookupDatasetPOST.

        The name of the external lookup.

        :param external_name: The external_name of this LookupDatasetPOST.
        :type: str
        """
        self._attrs["externalName"] = external_name

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this LookupDatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this LookupDatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this LookupDatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def filter(self) -> "str":
        """ Gets the filter of this LookupDatasetPOST.
        A query that filters results out of the lookup before those results are returned.
        """
        return self._attrs.get("filter")

    @filter.setter
    def filter(self, filter: "str"):
        """Sets the filter of this LookupDatasetPOST.

        A query that filters results out of the lookup before those results are returned.

        :param filter: The filter of this LookupDatasetPOST.
        :type: str
        """
        self._attrs["filter"] = filter

    @property
    def id(self) -> "str":
        """ Gets the id of this LookupDatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this LookupDatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this LookupDatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "lookup"


    @property
    def module(self) -> "str":
        """ Gets the module of this LookupDatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this LookupDatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this LookupDatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetPOST.from_dict_handlers["lookup"] = LookupDatasetPOST._from_dict



class MetricDatasetFromDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "MetricDatasetFromDataset":
        instance = MetricDatasetFromDataset.__new__(MetricDatasetFromDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, disabled: "bool" = None, earliest_event_time: "str" = None, earliest_ingest_time: "str" = None, frozen_time_period_in_secs: "int" = None, internalname: "str" = None, latest_event_time: "str" = None, latest_ingest_time: "str" = None, latest_metadata_update_time: "str" = None, summary: "str" = None, title: "str" = None, total_event_count: "int" = None, total_size: "int" = None, version: "int" = None, **extra):
        """MetricDatasetFromDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if earliest_event_time is not None:
            self._attrs["earliestEventTime"] = earliest_event_time
        if earliest_ingest_time is not None:
            self._attrs["earliestIngestTime"] = earliest_ingest_time
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "metric" 
        if latest_event_time is not None:
            self._attrs["latestEventTime"] = latest_event_time
        if latest_ingest_time is not None:
            self._attrs["latestIngestTime"] = latest_ingest_time
        if latest_metadata_update_time is not None:
            self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if total_event_count is not None:
            self._attrs["totalEventCount"] = total_event_count
        if total_size is not None:
            self._attrs["totalSize"] = total_size
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this MetricDatasetFromDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this MetricDatasetFromDataset.

        The date and time object was created.

        :param created: The created of this MetricDatasetFromDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this MetricDatasetFromDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this MetricDatasetFromDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this MetricDatasetFromDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this MetricDatasetFromDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this MetricDatasetFromDataset.

        A unique dataset ID.

        :param id: The id of this MetricDatasetFromDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this MetricDatasetFromDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this MetricDatasetFromDataset.

        The date and time object was modified.

        :param modified: The modified of this MetricDatasetFromDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this MetricDatasetFromDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this MetricDatasetFromDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this MetricDatasetFromDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this MetricDatasetFromDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this MetricDatasetFromDataset.

        The name of the module that contains the dataset.

        :param module: The module of this MetricDatasetFromDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this MetricDatasetFromDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this MetricDatasetFromDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this MetricDatasetFromDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this MetricDatasetFromDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this MetricDatasetFromDataset.

        The name of the object's owner.

        :param owner: The owner of this MetricDatasetFromDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this MetricDatasetFromDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this MetricDatasetFromDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this MetricDatasetFromDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this MetricDatasetFromDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this MetricDatasetFromDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this MetricDatasetFromDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this MetricDatasetFromDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this MetricDatasetFromDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this MetricDatasetFromDataset.

        Detailed description of the dataset.

        :param description: The description of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this MetricDatasetFromDataset.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this MetricDatasetFromDataset.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this MetricDatasetFromDataset.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def earliest_event_time(self) -> "str":
        """ Gets the earliest_event_time of this MetricDatasetFromDataset.
        The timestamp, in seconds, of the earliest measure. The timestamp is in UNIX time.
        """
        return self._attrs.get("earliestEventTime")

    @earliest_event_time.setter
    def earliest_event_time(self, earliest_event_time: "str"):
        """Sets the earliest_event_time of this MetricDatasetFromDataset.

        The timestamp, in seconds, of the earliest measure. The timestamp is in UNIX time.

        :param earliest_event_time: The earliest_event_time of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["earliestEventTime"] = earliest_event_time

    @property
    def earliest_ingest_time(self) -> "str":
        """ Gets the earliest_ingest_time of this MetricDatasetFromDataset.
        The earliest index time for any of the measures in this index.
        """
        return self._attrs.get("earliestIngestTime")

    @earliest_ingest_time.setter
    def earliest_ingest_time(self, earliest_ingest_time: "str"):
        """Sets the earliest_ingest_time of this MetricDatasetFromDataset.

        The earliest index time for any of the measures in this index.

        :param earliest_ingest_time: The earliest_ingest_time of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["earliestIngestTime"] = earliest_ingest_time

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this MetricDatasetFromDataset.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this MetricDatasetFromDataset.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this MetricDatasetFromDataset.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this MetricDatasetFromDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this MetricDatasetFromDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "metric"


    @property
    def latest_event_time(self) -> "str":
        """ Gets the latest_event_time of this MetricDatasetFromDataset.
        The timestamp, in seconds, of the latest measure. The timestamp is in UNIX time.
        """
        return self._attrs.get("latestEventTime")

    @latest_event_time.setter
    def latest_event_time(self, latest_event_time: "str"):
        """Sets the latest_event_time of this MetricDatasetFromDataset.

        The timestamp, in seconds, of the latest measure. The timestamp is in UNIX time.

        :param latest_event_time: The latest_event_time of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["latestEventTime"] = latest_event_time

    @property
    def latest_ingest_time(self) -> "str":
        """ Gets the latest_ingest_time of this MetricDatasetFromDataset.
        The earliest index time for any of the measures in this index.
        """
        return self._attrs.get("latestIngestTime")

    @latest_ingest_time.setter
    def latest_ingest_time(self, latest_ingest_time: "str"):
        """Sets the latest_ingest_time of this MetricDatasetFromDataset.

        The earliest index time for any of the measures in this index.

        :param latest_ingest_time: The latest_ingest_time of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["latestIngestTime"] = latest_ingest_time

    @property
    def latest_metadata_update_time(self) -> "str":
        """ Gets the latest_metadata_update_time of this MetricDatasetFromDataset.
        The latest time that the metric index metadata was refreshed.
        """
        return self._attrs.get("latestMetadataUpdateTime")

    @latest_metadata_update_time.setter
    def latest_metadata_update_time(self, latest_metadata_update_time: "str"):
        """Sets the latest_metadata_update_time of this MetricDatasetFromDataset.

        The latest time that the metric index metadata was refreshed.

        :param latest_metadata_update_time: The latest_metadata_update_time of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time

    @property
    def summary(self) -> "str":
        """ Gets the summary of this MetricDatasetFromDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this MetricDatasetFromDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this MetricDatasetFromDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this MetricDatasetFromDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this MetricDatasetFromDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def total_event_count(self) -> "int":
        """ Gets the total_event_count of this MetricDatasetFromDataset.
        THe number of measures in the metric index.
        """
        return self._attrs.get("totalEventCount")

    @total_event_count.setter
    def total_event_count(self, total_event_count: "int"):
        """Sets the total_event_count of this MetricDatasetFromDataset.

        THe number of measures in the metric index.

        :param total_event_count: The total_event_count of this MetricDatasetFromDataset.
        :type: int
        """
        self._attrs["totalEventCount"] = total_event_count

    @property
    def total_size(self) -> "int":
        """ Gets the total_size of this MetricDatasetFromDataset.
        For metrics indexes, the totalSize is set to 0.
        """
        return self._attrs.get("totalSize")

    @total_size.setter
    def total_size(self, total_size: "int"):
        """Sets the total_size of this MetricDatasetFromDataset.

        For metrics indexes, the totalSize is set to 0.

        :param total_size: The total_size of this MetricDatasetFromDataset.
        :type: int
        """
        self._attrs["totalSize"] = total_size

    @property
    def version(self) -> "int":
        """ Gets the version of this MetricDatasetFromDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this MetricDatasetFromDataset.

        The catalog version.

        :param version: The version of this MetricDatasetFromDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["metric"] = MetricDatasetFromDataset._from_dict



class MetricDatasetFromDatasetGet(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "MetricDatasetFromDatasetGet":
        instance = MetricDatasetFromDatasetGet.__new__(MetricDatasetFromDatasetGet)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, disabled: "bool" = None, earliest_event_time: "str" = None, earliest_ingest_time: "str" = None, frozen_time_period_in_secs: "int" = None, internalname: "str" = None, latest_event_time: "str" = None, latest_ingest_time: "str" = None, latest_metadata_update_time: "str" = None, summary: "str" = None, title: "str" = None, total_event_count: "int" = None, total_size: "int" = None, version: "int" = None, **extra):
        """MetricDatasetFromDatasetGet"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if earliest_event_time is not None:
            self._attrs["earliestEventTime"] = earliest_event_time
        if earliest_ingest_time is not None:
            self._attrs["earliestIngestTime"] = earliest_ingest_time
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "metric" 
        if latest_event_time is not None:
            self._attrs["latestEventTime"] = latest_event_time
        if latest_ingest_time is not None:
            self._attrs["latestIngestTime"] = latest_ingest_time
        if latest_metadata_update_time is not None:
            self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if total_event_count is not None:
            self._attrs["totalEventCount"] = total_event_count
        if total_size is not None:
            self._attrs["totalSize"] = total_size
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this MetricDatasetFromDatasetGet.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this MetricDatasetFromDatasetGet.

        The date and time object was created.

        :param created: The created of this MetricDatasetFromDatasetGet.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this MetricDatasetFromDatasetGet.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this MetricDatasetFromDatasetGet.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this MetricDatasetFromDatasetGet.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this MetricDatasetFromDatasetGet.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this MetricDatasetFromDatasetGet.

        A unique dataset ID.

        :param id: The id of this MetricDatasetFromDatasetGet.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this MetricDatasetFromDatasetGet.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this MetricDatasetFromDatasetGet.

        The date and time object was modified.

        :param modified: The modified of this MetricDatasetFromDatasetGet.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this MetricDatasetFromDatasetGet.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this MetricDatasetFromDatasetGet.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this MetricDatasetFromDatasetGet.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this MetricDatasetFromDatasetGet.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this MetricDatasetFromDatasetGet.

        The name of the module that contains the dataset.

        :param module: The module of this MetricDatasetFromDatasetGet.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this MetricDatasetFromDatasetGet.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this MetricDatasetFromDatasetGet.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this MetricDatasetFromDatasetGet.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this MetricDatasetFromDatasetGet.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this MetricDatasetFromDatasetGet.

        The name of the object's owner.

        :param owner: The owner of this MetricDatasetFromDatasetGet.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this MetricDatasetFromDatasetGet.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this MetricDatasetFromDatasetGet.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this MetricDatasetFromDatasetGet.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this MetricDatasetFromDatasetGet.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this MetricDatasetFromDatasetGet.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this MetricDatasetFromDatasetGet.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this MetricDatasetFromDatasetGet.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this MetricDatasetFromDatasetGet.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this MetricDatasetFromDatasetGet.

        Detailed description of the dataset.

        :param description: The description of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this MetricDatasetFromDatasetGet.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this MetricDatasetFromDatasetGet.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this MetricDatasetFromDatasetGet.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def earliest_event_time(self) -> "str":
        """ Gets the earliest_event_time of this MetricDatasetFromDatasetGet.
        The timestamp, in seconds, of the earliest measure. The timestamp is in UNIX time.
        """
        return self._attrs.get("earliestEventTime")

    @earliest_event_time.setter
    def earliest_event_time(self, earliest_event_time: "str"):
        """Sets the earliest_event_time of this MetricDatasetFromDatasetGet.

        The timestamp, in seconds, of the earliest measure. The timestamp is in UNIX time.

        :param earliest_event_time: The earliest_event_time of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["earliestEventTime"] = earliest_event_time

    @property
    def earliest_ingest_time(self) -> "str":
        """ Gets the earliest_ingest_time of this MetricDatasetFromDatasetGet.
        The earliest index time for any of the measures in this index.
        """
        return self._attrs.get("earliestIngestTime")

    @earliest_ingest_time.setter
    def earliest_ingest_time(self, earliest_ingest_time: "str"):
        """Sets the earliest_ingest_time of this MetricDatasetFromDatasetGet.

        The earliest index time for any of the measures in this index.

        :param earliest_ingest_time: The earliest_ingest_time of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["earliestIngestTime"] = earliest_ingest_time

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this MetricDatasetFromDatasetGet.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this MetricDatasetFromDatasetGet.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this MetricDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this MetricDatasetFromDatasetGet.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this MetricDatasetFromDatasetGet.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "metric"


    @property
    def latest_event_time(self) -> "str":
        """ Gets the latest_event_time of this MetricDatasetFromDatasetGet.
        The timestamp, in seconds, of the latest measure. The timestamp is in UNIX time.
        """
        return self._attrs.get("latestEventTime")

    @latest_event_time.setter
    def latest_event_time(self, latest_event_time: "str"):
        """Sets the latest_event_time of this MetricDatasetFromDatasetGet.

        The timestamp, in seconds, of the latest measure. The timestamp is in UNIX time.

        :param latest_event_time: The latest_event_time of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["latestEventTime"] = latest_event_time

    @property
    def latest_ingest_time(self) -> "str":
        """ Gets the latest_ingest_time of this MetricDatasetFromDatasetGet.
        The earliest index time for any of the measures in this index.
        """
        return self._attrs.get("latestIngestTime")

    @latest_ingest_time.setter
    def latest_ingest_time(self, latest_ingest_time: "str"):
        """Sets the latest_ingest_time of this MetricDatasetFromDatasetGet.

        The earliest index time for any of the measures in this index.

        :param latest_ingest_time: The latest_ingest_time of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["latestIngestTime"] = latest_ingest_time

    @property
    def latest_metadata_update_time(self) -> "str":
        """ Gets the latest_metadata_update_time of this MetricDatasetFromDatasetGet.
        The latest time that the metric index metadata was refreshed.
        """
        return self._attrs.get("latestMetadataUpdateTime")

    @latest_metadata_update_time.setter
    def latest_metadata_update_time(self, latest_metadata_update_time: "str"):
        """Sets the latest_metadata_update_time of this MetricDatasetFromDatasetGet.

        The latest time that the metric index metadata was refreshed.

        :param latest_metadata_update_time: The latest_metadata_update_time of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time

    @property
    def summary(self) -> "str":
        """ Gets the summary of this MetricDatasetFromDatasetGet.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this MetricDatasetFromDatasetGet.

        Summary of the dataset's purpose.

        :param summary: The summary of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this MetricDatasetFromDatasetGet.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this MetricDatasetFromDatasetGet.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this MetricDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def total_event_count(self) -> "int":
        """ Gets the total_event_count of this MetricDatasetFromDatasetGet.
        THe number of measures in the metric index.
        """
        return self._attrs.get("totalEventCount")

    @total_event_count.setter
    def total_event_count(self, total_event_count: "int"):
        """Sets the total_event_count of this MetricDatasetFromDatasetGet.

        THe number of measures in the metric index.

        :param total_event_count: The total_event_count of this MetricDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["totalEventCount"] = total_event_count

    @property
    def total_size(self) -> "int":
        """ Gets the total_size of this MetricDatasetFromDatasetGet.
        For metrics indexes, the totalSize is set to 0.
        """
        return self._attrs.get("totalSize")

    @total_size.setter
    def total_size(self, total_size: "int"):
        """Sets the total_size of this MetricDatasetFromDatasetGet.

        For metrics indexes, the totalSize is set to 0.

        :param total_size: The total_size of this MetricDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["totalSize"] = total_size

    @property
    def version(self) -> "int":
        """ Gets the version of this MetricDatasetFromDatasetGet.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this MetricDatasetFromDatasetGet.

        The catalog version.

        :param version: The version of this MetricDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["metric"] = MetricDatasetFromDatasetGet._from_dict



class MetricDatasetKind(str, Enum):
    METRIC = "metric"

    @staticmethod
    def from_value(value: str):
        if value == "metric":
            return MetricDatasetKind.METRIC


class MetricDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "MetricDatasetPATCH":
        instance = MetricDatasetPATCH.__new__(MetricDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, disabled: "bool" = None, frozen_time_period_in_secs: "int" = None, kind: "MetricDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """MetricDatasetPATCH"""

        self._attrs = dict()
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this MetricDatasetPATCH.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this MetricDatasetPATCH.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this MetricDatasetPATCH.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this MetricDatasetPATCH.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this MetricDatasetPATCH.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this MetricDatasetPATCH.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def kind(self) -> "MetricDatasetKind":
        """ Gets the kind of this MetricDatasetPATCH.
        """
        return MetricDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "MetricDatasetKind"):
        """Sets the kind of this MetricDatasetPATCH.


        :param kind: The kind of this MetricDatasetPATCH.
        :type: MetricDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this MetricDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this MetricDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this MetricDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this MetricDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this MetricDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this MetricDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this MetricDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this MetricDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this MetricDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MetricDatasetPOST(DatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "MetricDatasetPOST":
        instance = MetricDatasetPOST.__new__(MetricDatasetPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", disabled: "bool" = None, fields: "List[FieldPOST]" = None, frozen_time_period_in_secs: "int" = None, id: "str" = None, module: "str" = None, **extra):
        """MetricDatasetPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if fields is not None:
            self._attrs["fields"] = fields
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "metric" 
        if module is not None:
            self._attrs["module"] = module
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this MetricDatasetPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this MetricDatasetPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this MetricDatasetPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this MetricDatasetPOST.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this MetricDatasetPOST.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this MetricDatasetPOST.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this MetricDatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this MetricDatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this MetricDatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this MetricDatasetPOST.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this MetricDatasetPOST.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this MetricDatasetPOST.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def id(self) -> "str":
        """ Gets the id of this MetricDatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this MetricDatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this MetricDatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "metric"


    @property
    def module(self) -> "str":
        """ Gets the module of this MetricDatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this MetricDatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this MetricDatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetPOST.from_dict_handlers["metric"] = MetricDatasetPOST._from_dict



class Module(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Module":
        instance = Module.__new__(Module)
        instance._attrs = model
        return instance

    def __init__(self, name: "str" = None, **extra):
        """Module"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this Module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Module.


        :param name: The name of this Module.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RegexActionFromAction(Action):

    @staticmethod
    def _from_dict(model: dict) -> "RegexActionFromAction":
        instance = RegexActionFromAction.__new__(RegexActionFromAction)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, field: "str" = None, id: "str" = None, limit: "int" = None, pattern: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """RegexActionFromAction"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "REGEX" 
        if limit is not None:
            self._attrs["limit"] = limit
        if pattern is not None:
            self._attrs["pattern"] = pattern
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this RegexActionFromAction.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this RegexActionFromAction.

        The date and time object was created.

        :param created: The created of this RegexActionFromAction.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this RegexActionFromAction.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this RegexActionFromAction.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this RegexActionFromAction.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this RegexActionFromAction.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this RegexActionFromAction.

        The date and time object was modified.

        :param modified: The modified of this RegexActionFromAction.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this RegexActionFromAction.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this RegexActionFromAction.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this RegexActionFromAction.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this RegexActionFromAction.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this RegexActionFromAction.

        The name of the object's owner.

        :param owner: The owner of this RegexActionFromAction.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this RegexActionFromAction.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this RegexActionFromAction.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this RegexActionFromAction.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this RegexActionFromAction.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this RegexActionFromAction.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this RegexActionFromAction.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def field(self) -> "str":
        """ Gets the field of this RegexActionFromAction.
        Name of the field that is matched against the regular expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this RegexActionFromAction.

        Name of the field that is matched against the regular expression.

        :param field: The field of this RegexActionFromAction.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this RegexActionFromAction.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this RegexActionFromAction.

        A unique action ID.

        :param id: The id of this RegexActionFromAction.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "REGEX"


    @property
    def limit(self) -> "int":
        """ Gets the limit of this RegexActionFromAction.
        The maximum number of times per event to attempt to match fields with the regular expression.
        """
        return self._attrs.get("limit")

    @limit.setter
    def limit(self, limit: "int"):
        """Sets the limit of this RegexActionFromAction.

        The maximum number of times per event to attempt to match fields with the regular expression.

        :param limit: The limit of this RegexActionFromAction.
        :type: int
        """
        self._attrs["limit"] = limit

    @property
    def pattern(self) -> "str":
        """ Gets the pattern of this RegexActionFromAction.
        A regular expression that includes named capture groups for the purpose of field extraction.
        """
        return self._attrs.get("pattern")

    @pattern.setter
    def pattern(self, pattern: "str"):
        """Sets the pattern of this RegexActionFromAction.

        A regular expression that includes named capture groups for the purpose of field extraction.

        :param pattern: The pattern of this RegexActionFromAction.
        :type: str
        """
        self._attrs["pattern"] = pattern

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this RegexActionFromAction.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this RegexActionFromAction.

        The rule that this action is part of.

        :param ruleid: The ruleid of this RegexActionFromAction.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this RegexActionFromAction.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this RegexActionFromAction.

        The catalog version.

        :param version: The version of this RegexActionFromAction.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Action.from_dict_handlers["REGEX"] = RegexActionFromAction._from_dict



class RegexActionFromActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "RegexActionFromActionPOST":
        instance = RegexActionFromActionPOST.__new__(RegexActionFromActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, field: "str" = None, id: "str" = None, limit: "int" = None, pattern: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """RegexActionFromActionPOST"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "REGEX" 
        if limit is not None:
            self._attrs["limit"] = limit
        if pattern is not None:
            self._attrs["pattern"] = pattern
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this RegexActionFromActionPOST.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this RegexActionFromActionPOST.

        The date and time object was created.

        :param created: The created of this RegexActionFromActionPOST.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this RegexActionFromActionPOST.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this RegexActionFromActionPOST.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this RegexActionFromActionPOST.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this RegexActionFromActionPOST.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this RegexActionFromActionPOST.

        The date and time object was modified.

        :param modified: The modified of this RegexActionFromActionPOST.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this RegexActionFromActionPOST.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this RegexActionFromActionPOST.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this RegexActionFromActionPOST.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this RegexActionFromActionPOST.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this RegexActionFromActionPOST.

        The name of the object's owner.

        :param owner: The owner of this RegexActionFromActionPOST.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this RegexActionFromActionPOST.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this RegexActionFromActionPOST.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this RegexActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this RegexActionFromActionPOST.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this RegexActionFromActionPOST.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this RegexActionFromActionPOST.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def field(self) -> "str":
        """ Gets the field of this RegexActionFromActionPOST.
        Name of the field that is matched against the regular expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this RegexActionFromActionPOST.

        Name of the field that is matched against the regular expression.

        :param field: The field of this RegexActionFromActionPOST.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this RegexActionFromActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this RegexActionFromActionPOST.

        A unique action ID.

        :param id: The id of this RegexActionFromActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "REGEX"


    @property
    def limit(self) -> "int":
        """ Gets the limit of this RegexActionFromActionPOST.
        The maximum number of times per event to attempt to match fields with the regular expression.
        """
        return self._attrs.get("limit")

    @limit.setter
    def limit(self, limit: "int"):
        """Sets the limit of this RegexActionFromActionPOST.

        The maximum number of times per event to attempt to match fields with the regular expression.

        :param limit: The limit of this RegexActionFromActionPOST.
        :type: int
        """
        self._attrs["limit"] = limit

    @property
    def pattern(self) -> "str":
        """ Gets the pattern of this RegexActionFromActionPOST.
        A regular expression that includes named capture groups for the purpose of field extraction.
        """
        return self._attrs.get("pattern")

    @pattern.setter
    def pattern(self, pattern: "str"):
        """Sets the pattern of this RegexActionFromActionPOST.

        A regular expression that includes named capture groups for the purpose of field extraction.

        :param pattern: The pattern of this RegexActionFromActionPOST.
        :type: str
        """
        self._attrs["pattern"] = pattern

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this RegexActionFromActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this RegexActionFromActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this RegexActionFromActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this RegexActionFromActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this RegexActionFromActionPOST.

        The catalog version.

        :param version: The version of this RegexActionFromActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


ActionPOST.from_dict_handlers["REGEX"] = RegexActionFromActionPOST._from_dict



class RegexActionKind(str, Enum):
    REGEX = "REGEX"

    @staticmethod
    def from_value(value: str):
        if value == "REGEX":
            return RegexActionKind.REGEX


class RegexActionPATCH(ActionPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "RegexActionPATCH":
        instance = RegexActionPATCH.__new__(RegexActionPATCH)
        instance._attrs = model
        return instance

    def __init__(self, field: "str" = None, kind: "RegexActionKind" = None, limit: "int" = None, owner: "str" = None, pattern: "str" = None, version: "int" = None, **extra):
        """RegexActionPATCH"""

        self._attrs = dict()
        if field is not None:
            self._attrs["field"] = field
        if kind is not None:
            self._attrs["kind"] = kind
        if limit is not None:
            self._attrs["limit"] = limit
        if owner is not None:
            self._attrs["owner"] = owner
        if pattern is not None:
            self._attrs["pattern"] = pattern
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def field(self) -> "str":
        """ Gets the field of this RegexActionPATCH.
        Name of the field that is matched against the regular expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this RegexActionPATCH.

        Name of the field that is matched against the regular expression.

        :param field: The field of this RegexActionPATCH.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def kind(self) -> "RegexActionKind":
        """ Gets the kind of this RegexActionPATCH.
        """
        return RegexActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "RegexActionKind"):
        """Sets the kind of this RegexActionPATCH.


        :param kind: The kind of this RegexActionPATCH.
        :type: RegexActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def limit(self) -> "int":
        """ Gets the limit of this RegexActionPATCH.
        The maximum number of times per event to attempt to match fields with the regular expression.
        """
        return self._attrs.get("limit")

    @limit.setter
    def limit(self, limit: "int"):
        """Sets the limit of this RegexActionPATCH.

        The maximum number of times per event to attempt to match fields with the regular expression.

        :param limit: The limit of this RegexActionPATCH.
        :type: int
        """
        self._attrs["limit"] = limit

    @property
    def owner(self) -> "str":
        """ Gets the owner of this RegexActionPATCH.
        The name of the user who owns this action. This value is obtained from the bearer token if not present.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this RegexActionPATCH.

        The name of the user who owns this action. This value is obtained from the bearer token if not present.

        :param owner: The owner of this RegexActionPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def pattern(self) -> "str":
        """ Gets the pattern of this RegexActionPATCH.
        A regular expression that includes named capture groups for the purpose of field extraction.
        """
        return self._attrs.get("pattern")

    @pattern.setter
    def pattern(self, pattern: "str"):
        """Sets the pattern of this RegexActionPATCH.

        A regular expression that includes named capture groups for the purpose of field extraction.

        :param pattern: The pattern of this RegexActionPATCH.
        :type: str
        """
        self._attrs["pattern"] = pattern

    @property
    def version(self) -> "int":
        """ Gets the version of this RegexActionPATCH.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this RegexActionPATCH.

        The catalog version.

        :param version: The version of this RegexActionPATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RegexActionPOST(ActionPOST):

    @staticmethod
    def _from_dict(model: dict) -> "RegexActionPOST":
        instance = RegexActionPOST.__new__(RegexActionPOST)
        instance._attrs = model
        return instance

    def __init__(self, field: "str" = None, id: "str" = None, kind: "RegexActionKind" = None, limit: "int" = None, pattern: "str" = None, ruleid: "str" = None, version: "int" = None, **extra):
        """RegexActionPOST"""

        self._attrs = dict()
        if field is not None:
            self._attrs["field"] = field
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if limit is not None:
            self._attrs["limit"] = limit
        if pattern is not None:
            self._attrs["pattern"] = pattern
        if ruleid is not None:
            self._attrs["ruleid"] = ruleid
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def field(self) -> "str":
        """ Gets the field of this RegexActionPOST.
        Name of the field that is matched against the regular expression.
        """
        return self._attrs.get("field")

    @field.setter
    def field(self, field: "str"):
        """Sets the field of this RegexActionPOST.

        Name of the field that is matched against the regular expression.

        :param field: The field of this RegexActionPOST.
        :type: str
        """
        self._attrs["field"] = field

    @property
    def id(self) -> "str":
        """ Gets the id of this RegexActionPOST.
        A unique action ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this RegexActionPOST.

        A unique action ID.

        :param id: The id of this RegexActionPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "RegexActionKind":
        """ Gets the kind of this RegexActionPOST.
        """
        return RegexActionKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "RegexActionKind"):
        """Sets the kind of this RegexActionPOST.


        :param kind: The kind of this RegexActionPOST.
        :type: RegexActionKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def limit(self) -> "int":
        """ Gets the limit of this RegexActionPOST.
        The maximum number of times per event to attempt to match fields with the regular expression.
        """
        return self._attrs.get("limit")

    @limit.setter
    def limit(self, limit: "int"):
        """Sets the limit of this RegexActionPOST.

        The maximum number of times per event to attempt to match fields with the regular expression.

        :param limit: The limit of this RegexActionPOST.
        :type: int
        """
        self._attrs["limit"] = limit

    @property
    def pattern(self) -> "str":
        """ Gets the pattern of this RegexActionPOST.
        A regular expression that includes named capture groups for the purpose of field extraction.
        """
        return self._attrs.get("pattern")

    @pattern.setter
    def pattern(self, pattern: "str"):
        """Sets the pattern of this RegexActionPOST.

        A regular expression that includes named capture groups for the purpose of field extraction.

        :param pattern: The pattern of this RegexActionPOST.
        :type: str
        """
        self._attrs["pattern"] = pattern

    @property
    def ruleid(self) -> "str":
        """ Gets the ruleid of this RegexActionPOST.
        The rule that this action is part of.
        """
        return self._attrs.get("ruleid")

    @ruleid.setter
    def ruleid(self, ruleid: "str"):
        """Sets the ruleid of this RegexActionPOST.

        The rule that this action is part of.

        :param ruleid: The ruleid of this RegexActionPOST.
        :type: str
        """
        self._attrs["ruleid"] = ruleid

    @property
    def version(self) -> "int":
        """ Gets the version of this RegexActionPOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this RegexActionPOST.

        The catalog version.

        :param version: The version of this RegexActionPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RelationshipField(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RelationshipField":
        instance = RelationshipField.__new__(RelationshipField)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", modified: "datetime", kind: "RelationshipFieldKind" = None, relationshipid: "str" = None, sourceid: "str" = None, targetid: "str" = None, **extra):
        """RelationshipField"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if modified is not None:
            self._attrs["modified"] = modified
        if kind is not None:
            self._attrs["kind"] = kind
        if relationshipid is not None:
            self._attrs["relationshipid"] = relationshipid
        if sourceid is not None:
            self._attrs["sourceid"] = sourceid
        if targetid is not None:
            self._attrs["targetid"] = targetid
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this RelationshipField.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this RelationshipField.

        The date and time object was created.

        :param created: The created of this RelationshipField.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this RelationshipField.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this RelationshipField.

        The date and time object was modified.

        :param modified: The modified of this RelationshipField.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def kind(self) -> "RelationshipFieldKind":
        """ Gets the kind of this RelationshipField.
        """
        return RelationshipFieldKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "RelationshipFieldKind"):
        """Sets the kind of this RelationshipField.


        :param kind: The kind of this RelationshipField.
        :type: RelationshipFieldKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def relationshipid(self) -> "str":
        """ Gets the relationshipid of this RelationshipField.
        A unique relationship ID.
        """
        return self._attrs.get("relationshipid")

    @relationshipid.setter
    def relationshipid(self, relationshipid: "str"):
        """Sets the relationshipid of this RelationshipField.

        A unique relationship ID.

        :param relationshipid: The relationshipid of this RelationshipField.
        :type: str
        """
        self._attrs["relationshipid"] = relationshipid

    @property
    def sourceid(self) -> "str":
        """ Gets the sourceid of this RelationshipField.
        A unique source dataset ID.
        """
        return self._attrs.get("sourceid")

    @sourceid.setter
    def sourceid(self, sourceid: "str"):
        """Sets the sourceid of this RelationshipField.

        A unique source dataset ID.

        :param sourceid: The sourceid of this RelationshipField.
        :type: str
        """
        self._attrs["sourceid"] = sourceid

    @property
    def targetid(self) -> "str":
        """ Gets the targetid of this RelationshipField.
        A unique target dataset ID.
        """
        return self._attrs.get("targetid")

    @targetid.setter
    def targetid(self, targetid: "str"):
        """Sets the targetid of this RelationshipField.

        A unique target dataset ID.

        :param targetid: The targetid of this RelationshipField.
        :type: str
        """
        self._attrs["targetid"] = targetid

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RelationshipFieldKind(str, Enum):
    EXACT = "EXACT"
    LATEST_BEFORE = "LATEST_BEFORE"

    @staticmethod
    def from_value(value: str):
        if value == "EXACT":
            return RelationshipFieldKind.EXACT
        if value == "LATEST_BEFORE":
            return RelationshipFieldKind.LATEST_BEFORE


class RelationshipKind(str, Enum):
    ONE = "ONE"
    MANY = "MANY"
    DEPENDENCY = "DEPENDENCY"

    @staticmethod
    def from_value(value: str):
        if value == "ONE":
            return RelationshipKind.ONE
        if value == "MANY":
            return RelationshipKind.MANY
        if value == "DEPENDENCY":
            return RelationshipKind.DEPENDENCY


class Relationship(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Relationship":
        instance = Relationship.__new__(Relationship)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, fields: "List[RelationshipField]" = None, id: "str" = None, kind: "RelationshipKind" = None, module: "str" = 'The module of the source dataset.', name: "str" = None, sourceid: "str" = None, sourceresourcename: "str" = None, targetid: "str" = None, targetresourcename: "str" = None, version: "int" = None, **extra):
        """Relationship"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if sourceid is not None:
            self._attrs["sourceid"] = sourceid
        if sourceresourcename is not None:
            self._attrs["sourceresourcename"] = sourceresourcename
        if targetid is not None:
            self._attrs["targetid"] = targetid
        if targetresourcename is not None:
            self._attrs["targetresourcename"] = targetresourcename
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Relationship.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Relationship.

        The date and time object was created.

        :param created: The created of this Relationship.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Relationship.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Relationship.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Relationship.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Relationship.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Relationship.

        The date and time object was modified.

        :param modified: The modified of this Relationship.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Relationship.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Relationship.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Relationship.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Relationship.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Relationship.

        The name of the object's owner.

        :param owner: The owner of this Relationship.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Relationship.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Relationship.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Relationship.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Relationship.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Relationship.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Relationship.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def fields(self) -> "List[RelationshipField]":
        """ Gets the fields of this Relationship.
        The relationship fields associated with the relationship.
        """
        return [RelationshipField._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[RelationshipField]"):
        """Sets the fields of this Relationship.

        The relationship fields associated with the relationship.

        :param fields: The fields of this Relationship.
        :type: List[RelationshipField]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this Relationship.
        A unique relationship ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Relationship.

        A unique relationship ID.

        :param id: The id of this Relationship.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "RelationshipKind":
        """ Gets the kind of this Relationship.
        """
        return RelationshipKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "RelationshipKind"):
        """Sets the kind of this Relationship.


        :param kind: The kind of this Relationship.
        :type: RelationshipKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this Relationship.
        The module that contains the relationship.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this Relationship.

        The module that contains the relationship.

        :param module: The module of this Relationship.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this Relationship.
        The relationship name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Relationship.

        The relationship name.

        :param name: The name of this Relationship.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def sourceid(self) -> "str":
        """ Gets the sourceid of this Relationship.
        A unique source dataset ID. Either the sourceid or sourceresourcename property must be specified.
        """
        return self._attrs.get("sourceid")

    @sourceid.setter
    def sourceid(self, sourceid: "str"):
        """Sets the sourceid of this Relationship.

        A unique source dataset ID. Either the sourceid or sourceresourcename property must be specified.

        :param sourceid: The sourceid of this Relationship.
        :type: str
        """
        self._attrs["sourceid"] = sourceid

    @property
    def sourceresourcename(self) -> "str":
        """ Gets the sourceresourcename of this Relationship.
        The source dataset name qualified by module name. Either the sourceid or sourceresourcename property must be specified.
        """
        return self._attrs.get("sourceresourcename")

    @sourceresourcename.setter
    def sourceresourcename(self, sourceresourcename: "str"):
        """Sets the sourceresourcename of this Relationship.

        The source dataset name qualified by module name. Either the sourceid or sourceresourcename property must be specified.

        :param sourceresourcename: The sourceresourcename of this Relationship.
        :type: str
        """
        self._attrs["sourceresourcename"] = sourceresourcename

    @property
    def targetid(self) -> "str":
        """ Gets the targetid of this Relationship.
        A unique target dataset ID. Either the targetid or targetresourcename property must be specified.
        """
        return self._attrs.get("targetid")

    @targetid.setter
    def targetid(self, targetid: "str"):
        """Sets the targetid of this Relationship.

        A unique target dataset ID. Either the targetid or targetresourcename property must be specified.

        :param targetid: The targetid of this Relationship.
        :type: str
        """
        self._attrs["targetid"] = targetid

    @property
    def targetresourcename(self) -> "str":
        """ Gets the targetresourcename of this Relationship.
        The target dataset name qualified by module name. Either the targetid or targetresourcename property must be specified.
        """
        return self._attrs.get("targetresourcename")

    @targetresourcename.setter
    def targetresourcename(self, targetresourcename: "str"):
        """Sets the targetresourcename of this Relationship.

        The target dataset name qualified by module name. Either the targetid or targetresourcename property must be specified.

        :param targetresourcename: The targetresourcename of this Relationship.
        :type: str
        """
        self._attrs["targetresourcename"] = targetresourcename

    @property
    def version(self) -> "int":
        """ Gets the version of this Relationship.
        The Catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Relationship.

        The Catalog version.

        :param version: The version of this Relationship.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RelationshipFieldPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RelationshipFieldPOST":
        instance = RelationshipFieldPOST.__new__(RelationshipFieldPOST)
        instance._attrs = model
        return instance

    def __init__(self, kind: "RelationshipFieldKind" = None, relationshipid: "str" = None, sourceid: "str" = None, targetid: "str" = None, **extra):
        """RelationshipFieldPOST"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if relationshipid is not None:
            self._attrs["relationshipid"] = relationshipid
        if sourceid is not None:
            self._attrs["sourceid"] = sourceid
        if targetid is not None:
            self._attrs["targetid"] = targetid
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "RelationshipFieldKind":
        """ Gets the kind of this RelationshipFieldPOST.
        """
        return RelationshipFieldKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "RelationshipFieldKind"):
        """Sets the kind of this RelationshipFieldPOST.


        :param kind: The kind of this RelationshipFieldPOST.
        :type: RelationshipFieldKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def relationshipid(self) -> "str":
        """ Gets the relationshipid of this RelationshipFieldPOST.
        A unique relationship ID.
        """
        return self._attrs.get("relationshipid")

    @relationshipid.setter
    def relationshipid(self, relationshipid: "str"):
        """Sets the relationshipid of this RelationshipFieldPOST.

        A unique relationship ID.

        :param relationshipid: The relationshipid of this RelationshipFieldPOST.
        :type: str
        """
        self._attrs["relationshipid"] = relationshipid

    @property
    def sourceid(self) -> "str":
        """ Gets the sourceid of this RelationshipFieldPOST.
        A unique source dataset ID.
        """
        return self._attrs.get("sourceid")

    @sourceid.setter
    def sourceid(self, sourceid: "str"):
        """Sets the sourceid of this RelationshipFieldPOST.

        A unique source dataset ID.

        :param sourceid: The sourceid of this RelationshipFieldPOST.
        :type: str
        """
        self._attrs["sourceid"] = sourceid

    @property
    def targetid(self) -> "str":
        """ Gets the targetid of this RelationshipFieldPOST.
        A unique target dataset ID.
        """
        return self._attrs.get("targetid")

    @targetid.setter
    def targetid(self, targetid: "str"):
        """Sets the targetid of this RelationshipFieldPOST.

        A unique target dataset ID.

        :param targetid: The targetid of this RelationshipFieldPOST.
        :type: str
        """
        self._attrs["targetid"] = targetid

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RelationshipPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RelationshipPATCH":
        instance = RelationshipPATCH.__new__(RelationshipPATCH)
        instance._attrs = model
        return instance

    def __init__(self, name: "str" = None, owner: "str" = None, **extra):
        """RelationshipPATCH"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this RelationshipPATCH.
        The name of the relationship.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this RelationshipPATCH.

        The name of the relationship.

        :param name: The name of this RelationshipPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this RelationshipPATCH.
        The user who is the owner of the relationship.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this RelationshipPATCH.

        The user who is the owner of the relationship.

        :param owner: The owner of this RelationshipPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RelationshipPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RelationshipPOST":
        instance = RelationshipPOST.__new__(RelationshipPOST)
        instance._attrs = model
        return instance

    def __init__(self, fields: "List[RelationshipFieldPOST]" = None, id: "str" = None, kind: "RelationshipKind" = None, module: "str" = 'The module of the source dataset.', name: "str" = None, sourceid: "str" = None, sourceresourcename: "str" = None, targetid: "str" = None, targetresourcename: "str" = None, version: "int" = None, **extra):
        """RelationshipPOST"""

        self._attrs = dict()
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if sourceid is not None:
            self._attrs["sourceid"] = sourceid
        if sourceresourcename is not None:
            self._attrs["sourceresourcename"] = sourceresourcename
        if targetid is not None:
            self._attrs["targetid"] = targetid
        if targetresourcename is not None:
            self._attrs["targetresourcename"] = targetresourcename
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def fields(self) -> "List[RelationshipFieldPOST]":
        """ Gets the fields of this RelationshipPOST.
        The fields associated with this relationship.
        """
        return [RelationshipFieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[RelationshipFieldPOST]"):
        """Sets the fields of this RelationshipPOST.

        The fields associated with this relationship.

        :param fields: The fields of this RelationshipPOST.
        :type: List[RelationshipFieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this RelationshipPOST.
        A unique relationship ID. If not specified, an auto generated ID is created.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this RelationshipPOST.

        A unique relationship ID. If not specified, an auto generated ID is created.

        :param id: The id of this RelationshipPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> "RelationshipKind":
        """ Gets the kind of this RelationshipPOST.
        """
        return RelationshipKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "RelationshipKind"):
        """Sets the kind of this RelationshipPOST.


        :param kind: The kind of this RelationshipPOST.
        :type: RelationshipKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this RelationshipPOST.
        The module that contains the relationship.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this RelationshipPOST.

        The module that contains the relationship.

        :param module: The module of this RelationshipPOST.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this RelationshipPOST.
        The relationship name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this RelationshipPOST.

        The relationship name.

        :param name: The name of this RelationshipPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def sourceid(self) -> "str":
        """ Gets the sourceid of this RelationshipPOST.
        A unique source dataset ID. Either the sourceid or sourceresourcename property must be specified.
        """
        return self._attrs.get("sourceid")

    @sourceid.setter
    def sourceid(self, sourceid: "str"):
        """Sets the sourceid of this RelationshipPOST.

        A unique source dataset ID. Either the sourceid or sourceresourcename property must be specified.

        :param sourceid: The sourceid of this RelationshipPOST.
        :type: str
        """
        self._attrs["sourceid"] = sourceid

    @property
    def sourceresourcename(self) -> "str":
        """ Gets the sourceresourcename of this RelationshipPOST.
        The source dataset name qualified by module name. Either the sourceid or sourceresourcename property must be specified.
        """
        return self._attrs.get("sourceresourcename")

    @sourceresourcename.setter
    def sourceresourcename(self, sourceresourcename: "str"):
        """Sets the sourceresourcename of this RelationshipPOST.

        The source dataset name qualified by module name. Either the sourceid or sourceresourcename property must be specified.

        :param sourceresourcename: The sourceresourcename of this RelationshipPOST.
        :type: str
        """
        self._attrs["sourceresourcename"] = sourceresourcename

    @property
    def targetid(self) -> "str":
        """ Gets the targetid of this RelationshipPOST.
        A unique target dataset ID. Either the targetid or targetresourcename property must be specified.
        """
        return self._attrs.get("targetid")

    @targetid.setter
    def targetid(self, targetid: "str"):
        """Sets the targetid of this RelationshipPOST.

        A unique target dataset ID. Either the targetid or targetresourcename property must be specified.

        :param targetid: The targetid of this RelationshipPOST.
        :type: str
        """
        self._attrs["targetid"] = targetid

    @property
    def targetresourcename(self) -> "str":
        """ Gets the targetresourcename of this RelationshipPOST.
        The target dataset name qualified by module name. Either the targetid or targetresourcename property must be specified.
        """
        return self._attrs.get("targetresourcename")

    @targetresourcename.setter
    def targetresourcename(self, targetresourcename: "str"):
        """Sets the targetresourcename of this RelationshipPOST.

        The target dataset name qualified by module name. Either the targetid or targetresourcename property must be specified.

        :param targetresourcename: The targetresourcename of this RelationshipPOST.
        :type: str
        """
        self._attrs["targetresourcename"] = targetresourcename

    @property
    def version(self) -> "int":
        """ Gets the version of this RelationshipPOST.
        The Catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this RelationshipPOST.

        The Catalog version.

        :param version: The version of this RelationshipPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Rule(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Rule":
        instance = Rule.__new__(Rule)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", actions: "List[Action]" = None, appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, id: "str" = None, match: "str" = None, module: "str" = '', name: "str" = None, resourcename: "str" = None, version: "int" = None, **extra):
        """Rule"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if actions is not None:
            self._attrs["actions"] = actions
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if id is not None:
            self._attrs["id"] = id
        if match is not None:
            self._attrs["match"] = match
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Rule.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Rule.

        The date and time object was created.

        :param created: The created of this Rule.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Rule.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Rule.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Rule.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Rule.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Rule.

        The date and time object was modified.

        :param modified: The modified of this Rule.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Rule.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Rule.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Rule.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Rule.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Rule.

        The name of the object's owner.

        :param owner: The owner of this Rule.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def actions(self) -> "List[Action]":
        """ Gets the actions of this Rule.
        The actions associated with the rule.
        """
        return [Action._from_dict(i) for i in self._attrs.get("actions")]

    @actions.setter
    def actions(self, actions: "List[Action]"):
        """Sets the actions of this Rule.

        The actions associated with the rule.

        :param actions: The actions of this Rule.
        :type: List[Action]
        """
        self._attrs["actions"] = actions

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Rule.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Rule.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Rule.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Rule.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Rule.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Rule.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def id(self) -> "str":
        """ Gets the id of this Rule.
        A unique Rule ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Rule.

        A unique Rule ID.

        :param id: The id of this Rule.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def match(self) -> "str":
        """ Gets the match of this Rule.
        The rule match type.
        """
        return self._attrs.get("match")

    @match.setter
    def match(self, match: "str"):
        """Sets the match of this Rule.

        The rule match type.

        :param match: The match of this Rule.
        :type: str
        """
        self._attrs["match"] = match

    @property
    def module(self) -> "str":
        """ Gets the module of this Rule.
        The module containing the rule.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this Rule.

        The module containing the rule.

        :param module: The module of this Rule.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this Rule.
        The rule name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Rule.

        The rule name.

        :param name: The name of this Rule.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this Rule.
        The rule name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this Rule.

        The rule name qualified by the module name.

        :param resourcename: The resourcename of this Rule.
        :type: str
        """
        self._attrs["resourcename"] = resourcename

    @property
    def version(self) -> "int":
        """ Gets the version of this Rule.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Rule.

        The catalog version.

        :param version: The version of this Rule.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RulePATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RulePATCH":
        instance = RulePATCH.__new__(RulePATCH)
        instance._attrs = model
        return instance

    def __init__(self, match: "str" = None, module: "str" = '', name: "str" = None, owner: "str" = None, version: "int" = None, **extra):
        """RulePATCH"""

        self._attrs = dict()
        if match is not None:
            self._attrs["match"] = match
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def match(self) -> "str":
        """ Gets the match of this RulePATCH.
        The rule match type.
        """
        return self._attrs.get("match")

    @match.setter
    def match(self, match: "str"):
        """Sets the match of this RulePATCH.

        The rule match type.

        :param match: The match of this RulePATCH.
        :type: str
        """
        self._attrs["match"] = match

    @property
    def module(self) -> "str":
        """ Gets the module of this RulePATCH.
        The module containing the rule.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this RulePATCH.

        The module containing the rule.

        :param module: The module of this RulePATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this RulePATCH.
        The rule name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this RulePATCH.

        The rule name.

        :param name: The name of this RulePATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this RulePATCH.
        The name of the user who owns the rule.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this RulePATCH.

        The name of the user who owns the rule.

        :param owner: The owner of this RulePATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def version(self) -> "int":
        """ Gets the version of this RulePATCH.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this RulePATCH.

        The catalog version.

        :param version: The version of this RulePATCH.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RulePOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RulePOST":
        instance = RulePOST.__new__(RulePOST)
        instance._attrs = model
        return instance

    def __init__(self, actions: "List[ActionPOST]" = None, id: "str" = None, match: "str" = None, module: "str" = '', name: "str" = None, version: "int" = None, **extra):
        """RulePOST"""

        self._attrs = dict()
        if actions is not None:
            self._attrs["actions"] = actions
        if id is not None:
            self._attrs["id"] = id
        if match is not None:
            self._attrs["match"] = match
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def actions(self) -> "List[ActionPOST]":
        """ Gets the actions of this RulePOST.
        The actions to be associated with this rule.
        """
        return [ActionPOST._from_dict(i) for i in self._attrs.get("actions")]

    @actions.setter
    def actions(self, actions: "List[ActionPOST]"):
        """Sets the actions of this RulePOST.

        The actions to be associated with this rule.

        :param actions: The actions of this RulePOST.
        :type: List[ActionPOST]
        """
        self._attrs["actions"] = actions

    @property
    def id(self) -> "str":
        """ Gets the id of this RulePOST.
        A unique rule ID. The newly created rule object will use this ID value if provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this RulePOST.

        A unique rule ID. The newly created rule object will use this ID value if provided.

        :param id: The id of this RulePOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def match(self) -> "str":
        """ Gets the match of this RulePOST.
        The rule match type.
        """
        return self._attrs.get("match")

    @match.setter
    def match(self, match: "str"):
        """Sets the match of this RulePOST.

        The rule match type.

        :param match: The match of this RulePOST.
        :type: str
        """
        self._attrs["match"] = match

    @property
    def module(self) -> "str":
        """ Gets the module of this RulePOST.
        The module containing the rule.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this RulePOST.

        The module containing the rule.

        :param module: The module of this RulePOST.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this RulePOST.
        The rule name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this RulePOST.

        The rule name.

        :param name: The name of this RulePOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this RulePOST.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this RulePOST.

        The catalog version.

        :param version: The version of this RulePOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Splv1sinkDataset(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "Splv1sinkDataset":
        instance = Splv1sinkDataset.__new__(Splv1sinkDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, splv1: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """Splv1sinkDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "splv1sink" 
        if splv1 is not None:
            self._attrs["splv1"] = splv1
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Splv1sinkDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Splv1sinkDataset.

        The date and time object was created.

        :param created: The created of this Splv1sinkDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Splv1sinkDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Splv1sinkDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Splv1sinkDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this Splv1sinkDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Splv1sinkDataset.

        A unique dataset ID.

        :param id: The id of this Splv1sinkDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Splv1sinkDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Splv1sinkDataset.

        The date and time object was modified.

        :param modified: The modified of this Splv1sinkDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Splv1sinkDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Splv1sinkDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Splv1sinkDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this Splv1sinkDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this Splv1sinkDataset.

        The name of the module that contains the dataset.

        :param module: The module of this Splv1sinkDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this Splv1sinkDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Splv1sinkDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this Splv1sinkDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Splv1sinkDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Splv1sinkDataset.

        The name of the object's owner.

        :param owner: The owner of this Splv1sinkDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this Splv1sinkDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this Splv1sinkDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this Splv1sinkDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Splv1sinkDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Splv1sinkDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Splv1sinkDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Splv1sinkDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Splv1sinkDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Splv1sinkDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this Splv1sinkDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Splv1sinkDataset.

        Detailed description of the dataset.

        :param description: The description of this Splv1sinkDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this Splv1sinkDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this Splv1sinkDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this Splv1sinkDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "splv1sink"


    @property
    def splv1(self) -> "str":
        """ Gets the splv1 of this Splv1sinkDataset.
        Internal use by common-ast, contains the converted SPL for a SPL2 search query.
        """
        return self._attrs.get("splv1")

    @splv1.setter
    def splv1(self, splv1: "str"):
        """Sets the splv1 of this Splv1sinkDataset.

        Internal use by common-ast, contains the converted SPL for a SPL2 search query.

        :param splv1: The splv1 of this Splv1sinkDataset.
        :type: str
        """
        self._attrs["splv1"] = splv1

    @property
    def summary(self) -> "str":
        """ Gets the summary of this Splv1sinkDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this Splv1sinkDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this Splv1sinkDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this Splv1sinkDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this Splv1sinkDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this Splv1sinkDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this Splv1sinkDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Splv1sinkDataset.

        The catalog version.

        :param version: The version of this Splv1sinkDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["splv1sink"] = Splv1sinkDataset._from_dict



class Splv1sinkDatasetKind(str, Enum):
    SPLV1SINK = "splv1sink"

    @staticmethod
    def from_value(value: str):
        if value == "splv1sink":
            return Splv1sinkDatasetKind.SPLV1SINK


class Task(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Task":
        instance = Task.__new__(Task)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", algorithm: "str" = None, children: "List[str]" = None, evaluation: "List[str]" = None, features: "List[str]" = None, id: "str" = None, name: "str" = None, outputtransformer: "str" = None, parameters: "str" = None, parents: "List[str]" = None, targetfeature: "str" = None, tasktype: "str" = None, timeoutsecs: "int" = None, workflowid: "str" = None, workflowversion: "int" = None, **extra):
        """Task"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if algorithm is not None:
            self._attrs["algorithm"] = algorithm
        if children is not None:
            self._attrs["children"] = children
        if evaluation is not None:
            self._attrs["evaluation"] = evaluation
        if features is not None:
            self._attrs["features"] = features
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if outputtransformer is not None:
            self._attrs["outputtransformer"] = outputtransformer
        if parameters is not None:
            self._attrs["parameters"] = parameters
        if parents is not None:
            self._attrs["parents"] = parents
        if targetfeature is not None:
            self._attrs["targetfeature"] = targetfeature
        if tasktype is not None:
            self._attrs["tasktype"] = tasktype
        if timeoutsecs is not None:
            self._attrs["timeoutsecs"] = timeoutsecs
        if workflowid is not None:
            self._attrs["workflowid"] = workflowid
        if workflowversion is not None:
            self._attrs["workflowversion"] = workflowversion
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Task.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Task.

        The date and time object was created.

        :param created: The created of this Task.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Task.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Task.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Task.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Task.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Task.

        The date and time object was modified.

        :param modified: The modified of this Task.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Task.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Task.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Task.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Task.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Task.

        The name of the object's owner.

        :param owner: The owner of this Task.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def algorithm(self) -> "str":
        """ Gets the algorithm of this Task.
        The task algorithm name.
        """
        return self._attrs.get("algorithm")

    @algorithm.setter
    def algorithm(self, algorithm: "str"):
        """Sets the algorithm of this Task.

        The task algorithm name.

        :param algorithm: The algorithm of this Task.
        :type: str
        """
        self._attrs["algorithm"] = algorithm

    @property
    def children(self) -> "List[str]":
        """ Gets the children of this Task.
        The children tasks of the task.
        """
        return self._attrs.get("children")

    @children.setter
    def children(self, children: "List[str]"):
        """Sets the children of this Task.

        The children tasks of the task.

        :param children: The children of this Task.
        :type: List[str]
        """
        self._attrs["children"] = children

    @property
    def evaluation(self) -> "List[str]":
        """ Gets the evaluation of this Task.
        The evaluation criteria of the task.
        """
        return self._attrs.get("evaluation")

    @evaluation.setter
    def evaluation(self, evaluation: "List[str]"):
        """Sets the evaluation of this Task.

        The evaluation criteria of the task.

        :param evaluation: The evaluation of this Task.
        :type: List[str]
        """
        self._attrs["evaluation"] = evaluation

    @property
    def features(self) -> "List[str]":
        """ Gets the features of this Task.
        The features of the task.
        """
        return self._attrs.get("features")

    @features.setter
    def features(self, features: "List[str]"):
        """Sets the features of this Task.

        The features of the task.

        :param features: The features of this Task.
        :type: List[str]
        """
        self._attrs["features"] = features

    @property
    def id(self) -> "str":
        """ Gets the id of this Task.
        A unique task ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Task.

        A unique task ID.

        :param id: The id of this Task.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this Task.
        The task name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Task.

        The task name.

        :param name: The name of this Task.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def outputtransformer(self) -> "str":
        """ Gets the outputtransformer of this Task.
        The output transformer of the task.
        """
        return self._attrs.get("outputtransformer")

    @outputtransformer.setter
    def outputtransformer(self, outputtransformer: "str"):
        """Sets the outputtransformer of this Task.

        The output transformer of the task.

        :param outputtransformer: The outputtransformer of this Task.
        :type: str
        """
        self._attrs["outputtransformer"] = outputtransformer

    @property
    def parameters(self) -> "str":
        """ Gets the parameters of this Task.
        The task parameters.
        """
        return self._attrs.get("parameters")

    @parameters.setter
    def parameters(self, parameters: "str"):
        """Sets the parameters of this Task.

        The task parameters.

        :param parameters: The parameters of this Task.
        :type: str
        """
        self._attrs["parameters"] = parameters

    @property
    def parents(self) -> "List[str]":
        """ Gets the parents of this Task.
        The parent tasks of the task.
        """
        return self._attrs.get("parents")

    @parents.setter
    def parents(self, parents: "List[str]"):
        """Sets the parents of this Task.

        The parent tasks of the task.

        :param parents: The parents of this Task.
        :type: List[str]
        """
        self._attrs["parents"] = parents

    @property
    def targetfeature(self) -> "str":
        """ Gets the targetfeature of this Task.
        The target feature of the task.
        """
        return self._attrs.get("targetfeature")

    @targetfeature.setter
    def targetfeature(self, targetfeature: "str"):
        """Sets the targetfeature of this Task.

        The target feature of the task.

        :param targetfeature: The targetfeature of this Task.
        :type: str
        """
        self._attrs["targetfeature"] = targetfeature

    @property
    def tasktype(self) -> "str":
        """ Gets the tasktype of this Task.
        The task type.
        """
        return self._attrs.get("tasktype")

    @tasktype.setter
    def tasktype(self, tasktype: "str"):
        """Sets the tasktype of this Task.

        The task type.

        :param tasktype: The tasktype of this Task.
        :type: str
        """
        self._attrs["tasktype"] = tasktype

    @property
    def timeoutsecs(self) -> "int":
        """ Gets the timeoutsecs of this Task.
        The timeout secs of the task.
        """
        return self._attrs.get("timeoutsecs")

    @timeoutsecs.setter
    def timeoutsecs(self, timeoutsecs: "int"):
        """Sets the timeoutsecs of this Task.

        The timeout secs of the task.

        :param timeoutsecs: The timeoutsecs of this Task.
        :type: int
        """
        self._attrs["timeoutsecs"] = timeoutsecs

    @property
    def workflowid(self) -> "str":
        """ Gets the workflowid of this Task.
        A unique workflow ID that is associatd with the task.
        """
        return self._attrs.get("workflowid")

    @workflowid.setter
    def workflowid(self, workflowid: "str"):
        """Sets the workflowid of this Task.

        A unique workflow ID that is associatd with the task.

        :param workflowid: The workflowid of this Task.
        :type: str
        """
        self._attrs["workflowid"] = workflowid

    @property
    def workflowversion(self) -> "int":
        """ Gets the workflowversion of this Task.
        The version of the workflow that is associated with the task.
        """
        return self._attrs.get("workflowversion")

    @workflowversion.setter
    def workflowversion(self, workflowversion: "int"):
        """Sets the workflowversion of this Task.

        The version of the workflow that is associated with the task.

        :param workflowversion: The workflowversion of this Task.
        :type: int
        """
        self._attrs["workflowversion"] = workflowversion

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TaskPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TaskPOST":
        instance = TaskPOST.__new__(TaskPOST)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", algorithm: "str" = None, children: "List[str]" = None, evaluation: "List[str]" = None, features: "List[str]" = None, id: "str" = None, name: "str" = None, outputtransformer: "str" = None, parameters: "str" = None, parents: "List[str]" = None, targetfeature: "str" = None, tasktype: "str" = None, timeoutsecs: "int" = None, workflowid: "str" = None, workflowversion: "int" = None, **extra):
        """TaskPOST"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if algorithm is not None:
            self._attrs["algorithm"] = algorithm
        if children is not None:
            self._attrs["children"] = children
        if evaluation is not None:
            self._attrs["evaluation"] = evaluation
        if features is not None:
            self._attrs["features"] = features
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if outputtransformer is not None:
            self._attrs["outputtransformer"] = outputtransformer
        if parameters is not None:
            self._attrs["parameters"] = parameters
        if parents is not None:
            self._attrs["parents"] = parents
        if targetfeature is not None:
            self._attrs["targetfeature"] = targetfeature
        if tasktype is not None:
            self._attrs["tasktype"] = tasktype
        if timeoutsecs is not None:
            self._attrs["timeoutsecs"] = timeoutsecs
        if workflowid is not None:
            self._attrs["workflowid"] = workflowid
        if workflowversion is not None:
            self._attrs["workflowversion"] = workflowversion
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this TaskPOST.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this TaskPOST.

        The date and time object was created.

        :param created: The created of this TaskPOST.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this TaskPOST.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this TaskPOST.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this TaskPOST.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this TaskPOST.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this TaskPOST.

        The date and time object was modified.

        :param modified: The modified of this TaskPOST.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this TaskPOST.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this TaskPOST.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this TaskPOST.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this TaskPOST.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this TaskPOST.

        The name of the object's owner.

        :param owner: The owner of this TaskPOST.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def algorithm(self) -> "str":
        """ Gets the algorithm of this TaskPOST.
        The task algorithm name.
        """
        return self._attrs.get("algorithm")

    @algorithm.setter
    def algorithm(self, algorithm: "str"):
        """Sets the algorithm of this TaskPOST.

        The task algorithm name.

        :param algorithm: The algorithm of this TaskPOST.
        :type: str
        """
        self._attrs["algorithm"] = algorithm

    @property
    def children(self) -> "List[str]":
        """ Gets the children of this TaskPOST.
        The children tasks of the task.
        """
        return self._attrs.get("children")

    @children.setter
    def children(self, children: "List[str]"):
        """Sets the children of this TaskPOST.

        The children tasks of the task.

        :param children: The children of this TaskPOST.
        :type: List[str]
        """
        self._attrs["children"] = children

    @property
    def evaluation(self) -> "List[str]":
        """ Gets the evaluation of this TaskPOST.
        The evaluation criteria of the task.
        """
        return self._attrs.get("evaluation")

    @evaluation.setter
    def evaluation(self, evaluation: "List[str]"):
        """Sets the evaluation of this TaskPOST.

        The evaluation criteria of the task.

        :param evaluation: The evaluation of this TaskPOST.
        :type: List[str]
        """
        self._attrs["evaluation"] = evaluation

    @property
    def features(self) -> "List[str]":
        """ Gets the features of this TaskPOST.
        The features of the task.
        """
        return self._attrs.get("features")

    @features.setter
    def features(self, features: "List[str]"):
        """Sets the features of this TaskPOST.

        The features of the task.

        :param features: The features of this TaskPOST.
        :type: List[str]
        """
        self._attrs["features"] = features

    @property
    def id(self) -> "str":
        """ Gets the id of this TaskPOST.
        A unique task ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this TaskPOST.

        A unique task ID.

        :param id: The id of this TaskPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this TaskPOST.
        The task name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TaskPOST.

        The task name.

        :param name: The name of this TaskPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def outputtransformer(self) -> "str":
        """ Gets the outputtransformer of this TaskPOST.
        The output transformer of the task.
        """
        return self._attrs.get("outputtransformer")

    @outputtransformer.setter
    def outputtransformer(self, outputtransformer: "str"):
        """Sets the outputtransformer of this TaskPOST.

        The output transformer of the task.

        :param outputtransformer: The outputtransformer of this TaskPOST.
        :type: str
        """
        self._attrs["outputtransformer"] = outputtransformer

    @property
    def parameters(self) -> "str":
        """ Gets the parameters of this TaskPOST.
        The task parameters.
        """
        return self._attrs.get("parameters")

    @parameters.setter
    def parameters(self, parameters: "str"):
        """Sets the parameters of this TaskPOST.

        The task parameters.

        :param parameters: The parameters of this TaskPOST.
        :type: str
        """
        self._attrs["parameters"] = parameters

    @property
    def parents(self) -> "List[str]":
        """ Gets the parents of this TaskPOST.
        The parent tasks of the task.
        """
        return self._attrs.get("parents")

    @parents.setter
    def parents(self, parents: "List[str]"):
        """Sets the parents of this TaskPOST.

        The parent tasks of the task.

        :param parents: The parents of this TaskPOST.
        :type: List[str]
        """
        self._attrs["parents"] = parents

    @property
    def targetfeature(self) -> "str":
        """ Gets the targetfeature of this TaskPOST.
        The target feature of the task.
        """
        return self._attrs.get("targetfeature")

    @targetfeature.setter
    def targetfeature(self, targetfeature: "str"):
        """Sets the targetfeature of this TaskPOST.

        The target feature of the task.

        :param targetfeature: The targetfeature of this TaskPOST.
        :type: str
        """
        self._attrs["targetfeature"] = targetfeature

    @property
    def tasktype(self) -> "str":
        """ Gets the tasktype of this TaskPOST.
        The task type.
        """
        return self._attrs.get("tasktype")

    @tasktype.setter
    def tasktype(self, tasktype: "str"):
        """Sets the tasktype of this TaskPOST.

        The task type.

        :param tasktype: The tasktype of this TaskPOST.
        :type: str
        """
        self._attrs["tasktype"] = tasktype

    @property
    def timeoutsecs(self) -> "int":
        """ Gets the timeoutsecs of this TaskPOST.
        The timeout secs of the task.
        """
        return self._attrs.get("timeoutsecs")

    @timeoutsecs.setter
    def timeoutsecs(self, timeoutsecs: "int"):
        """Sets the timeoutsecs of this TaskPOST.

        The timeout secs of the task.

        :param timeoutsecs: The timeoutsecs of this TaskPOST.
        :type: int
        """
        self._attrs["timeoutsecs"] = timeoutsecs

    @property
    def workflowid(self) -> "str":
        """ Gets the workflowid of this TaskPOST.
        A unique workflow ID that is associated with the task.
        """
        return self._attrs.get("workflowid")

    @workflowid.setter
    def workflowid(self, workflowid: "str"):
        """Sets the workflowid of this TaskPOST.

        A unique workflow ID that is associated with the task.

        :param workflowid: The workflowid of this TaskPOST.
        :type: str
        """
        self._attrs["workflowid"] = workflowid

    @property
    def workflowversion(self) -> "int":
        """ Gets the workflowversion of this TaskPOST.
        The version of the workflow that is associated with the task.
        """
        return self._attrs.get("workflowversion")

    @workflowversion.setter
    def workflowversion(self, workflowversion: "int"):
        """Sets the workflowversion of this TaskPOST.

        The version of the workflow that is associated with the task.

        :param workflowversion: The workflowversion of this TaskPOST.
        :type: int
        """
        self._attrs["workflowversion"] = workflowversion

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ViewDatasetFromDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "ViewDatasetFromDataset":
        instance = ViewDatasetFromDataset.__new__(ViewDatasetFromDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, search: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """ViewDatasetFromDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "view" 
        if search is not None:
            self._attrs["search"] = search
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this ViewDatasetFromDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this ViewDatasetFromDataset.

        The date and time object was created.

        :param created: The created of this ViewDatasetFromDataset.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this ViewDatasetFromDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this ViewDatasetFromDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this ViewDatasetFromDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this ViewDatasetFromDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ViewDatasetFromDataset.

        A unique dataset ID.

        :param id: The id of this ViewDatasetFromDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this ViewDatasetFromDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this ViewDatasetFromDataset.

        The date and time object was modified.

        :param modified: The modified of this ViewDatasetFromDataset.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this ViewDatasetFromDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this ViewDatasetFromDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this ViewDatasetFromDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this ViewDatasetFromDataset.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ViewDatasetFromDataset.

        The name of the module that contains the dataset.

        :param module: The module of this ViewDatasetFromDataset.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this ViewDatasetFromDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ViewDatasetFromDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ViewDatasetFromDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this ViewDatasetFromDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this ViewDatasetFromDataset.

        The name of the object's owner.

        :param owner: The owner of this ViewDatasetFromDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this ViewDatasetFromDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this ViewDatasetFromDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this ViewDatasetFromDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this ViewDatasetFromDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this ViewDatasetFromDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this ViewDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this ViewDatasetFromDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this ViewDatasetFromDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this ViewDatasetFromDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this ViewDatasetFromDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ViewDatasetFromDataset.

        Detailed description of the dataset.

        :param description: The description of this ViewDatasetFromDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this ViewDatasetFromDataset.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this ViewDatasetFromDataset.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this ViewDatasetFromDataset.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "view"


    @property
    def search(self) -> "str":
        """ Gets the search of this ViewDatasetFromDataset.
        A valid SPL-defined search.
        """
        return self._attrs.get("search")

    @search.setter
    def search(self, search: "str"):
        """Sets the search of this ViewDatasetFromDataset.

        A valid SPL-defined search.

        :param search: The search of this ViewDatasetFromDataset.
        :type: str
        """
        self._attrs["search"] = search

    @property
    def summary(self) -> "str":
        """ Gets the summary of this ViewDatasetFromDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this ViewDatasetFromDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this ViewDatasetFromDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this ViewDatasetFromDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this ViewDatasetFromDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this ViewDatasetFromDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this ViewDatasetFromDataset.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ViewDatasetFromDataset.

        The catalog version.

        :param version: The version of this ViewDatasetFromDataset.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["view"] = ViewDatasetFromDataset._from_dict



class ViewDatasetFromDatasetGet(DatasetGet):

    @staticmethod
    def _from_dict(model: dict) -> "ViewDatasetFromDatasetGet":
        instance = ViewDatasetFromDatasetGet.__new__(ViewDatasetFromDatasetGet)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", modified: "datetime", modifiedby: "str", module: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, internalname: "str" = None, search: "str" = None, summary: "str" = None, title: "str" = None, version: "int" = None, **extra):
        """ViewDatasetFromDatasetGet"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if internalname is not None:
            self._attrs["internalname"] = internalname
        self._attrs["kind"] = "view" 
        if search is not None:
            self._attrs["search"] = search
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this ViewDatasetFromDatasetGet.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this ViewDatasetFromDatasetGet.

        The date and time object was created.

        :param created: The created of this ViewDatasetFromDatasetGet.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this ViewDatasetFromDatasetGet.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this ViewDatasetFromDatasetGet.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this ViewDatasetFromDatasetGet.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this ViewDatasetFromDatasetGet.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ViewDatasetFromDatasetGet.

        A unique dataset ID.

        :param id: The id of this ViewDatasetFromDatasetGet.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this ViewDatasetFromDatasetGet.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this ViewDatasetFromDatasetGet.

        The date and time object was modified.

        :param modified: The modified of this ViewDatasetFromDatasetGet.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this ViewDatasetFromDatasetGet.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this ViewDatasetFromDatasetGet.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this ViewDatasetFromDatasetGet.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def module(self) -> "str":
        """ Gets the module of this ViewDatasetFromDatasetGet.
        The name of the module that contains the dataset.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ViewDatasetFromDatasetGet.

        The name of the module that contains the dataset.

        :param module: The module of this ViewDatasetFromDatasetGet.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this ViewDatasetFromDatasetGet.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ViewDatasetFromDatasetGet.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ViewDatasetFromDatasetGet.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this ViewDatasetFromDatasetGet.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this ViewDatasetFromDatasetGet.

        The name of the object's owner.

        :param owner: The owner of this ViewDatasetFromDatasetGet.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this ViewDatasetFromDatasetGet.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this ViewDatasetFromDatasetGet.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this ViewDatasetFromDatasetGet.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this ViewDatasetFromDatasetGet.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this ViewDatasetFromDatasetGet.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this ViewDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this ViewDatasetFromDatasetGet.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this ViewDatasetFromDatasetGet.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this ViewDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this ViewDatasetFromDatasetGet.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ViewDatasetFromDatasetGet.

        Detailed description of the dataset.

        :param description: The description of this ViewDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def internalname(self) -> "str":
        """ Gets the internalname of this ViewDatasetFromDatasetGet.
        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.
        """
        return self._attrs.get("internalname")

    @internalname.setter
    def internalname(self, internalname: "str"):
        """Sets the internalname of this ViewDatasetFromDatasetGet.

        The dataset name qualified by the module name, primarily used to distinguish between index/metric versus other datasets. Index/metric datasets have a distinct underscore separator (_____) between name and module. Internal use only.

        :param internalname: The internalname of this ViewDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["internalname"] = internalname

    @property
    def kind(self) -> str:
        return "view"


    @property
    def search(self) -> "str":
        """ Gets the search of this ViewDatasetFromDatasetGet.
        A valid SPL-defined search.
        """
        return self._attrs.get("search")

    @search.setter
    def search(self, search: "str"):
        """Sets the search of this ViewDatasetFromDatasetGet.

        A valid SPL-defined search.

        :param search: The search of this ViewDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["search"] = search

    @property
    def summary(self) -> "str":
        """ Gets the summary of this ViewDatasetFromDatasetGet.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this ViewDatasetFromDatasetGet.

        Summary of the dataset's purpose.

        :param summary: The summary of this ViewDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this ViewDatasetFromDatasetGet.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this ViewDatasetFromDatasetGet.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this ViewDatasetFromDatasetGet.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def version(self) -> "int":
        """ Gets the version of this ViewDatasetFromDatasetGet.
        The catalog version.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ViewDatasetFromDatasetGet.

        The catalog version.

        :param version: The version of this ViewDatasetFromDatasetGet.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetGet.from_dict_handlers["view"] = ViewDatasetFromDatasetGet._from_dict



class ViewDatasetKind(str, Enum):
    VIEW = "view"

    @staticmethod
    def from_value(value: str):
        if value == "view":
            return ViewDatasetKind.VIEW


class ViewDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "ViewDatasetPATCH":
        instance = ViewDatasetPATCH.__new__(ViewDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, kind: "ViewDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, search: "str" = None, **extra):
        """ViewDatasetPATCH"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if search is not None:
            self._attrs["search"] = search
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "ViewDatasetKind":
        """ Gets the kind of this ViewDatasetPATCH.
        """
        return ViewDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "ViewDatasetKind"):
        """Sets the kind of this ViewDatasetPATCH.


        :param kind: The kind of this ViewDatasetPATCH.
        :type: ViewDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this ViewDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ViewDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this ViewDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this ViewDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ViewDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ViewDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this ViewDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this ViewDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this ViewDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    @property
    def search(self) -> "str":
        """ Gets the search of this ViewDatasetPATCH.
        A valid SPL-defined search.
        """
        return self._attrs.get("search")

    @search.setter
    def search(self, search: "str"):
        """Sets the search of this ViewDatasetPATCH.

        A valid SPL-defined search.

        :param search: The search of this ViewDatasetPATCH.
        :type: str
        """
        self._attrs["search"] = search

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ViewDatasetPOST(DatasetPOST):

    @staticmethod
    def _from_dict(model: dict) -> "ViewDatasetPOST":
        instance = ViewDatasetPOST.__new__(ViewDatasetPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", fields: "List[FieldPOST]" = None, id: "str" = None, module: "str" = None, search: "str" = None, **extra):
        """ViewDatasetPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        self._attrs["kind"] = "view" 
        if module is not None:
            self._attrs["module"] = module
        if search is not None:
            self._attrs["search"] = search
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this ViewDatasetPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ViewDatasetPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this ViewDatasetPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this ViewDatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this ViewDatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this ViewDatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this ViewDatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ViewDatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this ViewDatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def kind(self) -> str:
        return "view"


    @property
    def module(self) -> "str":
        """ Gets the module of this ViewDatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this ViewDatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this ViewDatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def search(self) -> "str":
        """ Gets the search of this ViewDatasetPOST.
        A valid SPL-defined search.
        """
        return self._attrs.get("search")

    @search.setter
    def search(self, search: "str"):
        """Sets the search of this ViewDatasetPOST.

        A valid SPL-defined search.

        :param search: The search of this ViewDatasetPOST.
        :type: str
        """
        self._attrs["search"] = search

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


DatasetPOST.from_dict_handlers["view"] = ViewDatasetPOST._from_dict



class Workflow(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Workflow":
        instance = Workflow.__new__(Workflow)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", description: "str" = None, experimentid: "str" = None, id: "str" = None, name: "str" = None, tasks: "List[Task]" = None, version: "int" = None, **extra):
        """Workflow"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if description is not None:
            self._attrs["description"] = description
        if experimentid is not None:
            self._attrs["experimentid"] = experimentid
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if tasks is not None:
            self._attrs["tasks"] = tasks
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this Workflow.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this Workflow.

        The date and time object was created.

        :param created: The created of this Workflow.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Workflow.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Workflow.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Workflow.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this Workflow.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this Workflow.

        The date and time object was modified.

        :param modified: The modified of this Workflow.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Workflow.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Workflow.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Workflow.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Workflow.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Workflow.

        The name of the object's owner.

        :param owner: The owner of this Workflow.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def description(self) -> "str":
        """ Gets the description of this Workflow.
        The workflow description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Workflow.

        The workflow description.

        :param description: The description of this Workflow.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def experimentid(self) -> "str":
        """ Gets the experimentid of this Workflow.
        A unique experiment ID that is associated with the workflow.
        """
        return self._attrs.get("experimentid")

    @experimentid.setter
    def experimentid(self, experimentid: "str"):
        """Sets the experimentid of this Workflow.

        A unique experiment ID that is associated with the workflow.

        :param experimentid: The experimentid of this Workflow.
        :type: str
        """
        self._attrs["experimentid"] = experimentid

    @property
    def id(self) -> "str":
        """ Gets the id of this Workflow.
        A unique workflow ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Workflow.

        A unique workflow ID.

        :param id: The id of this Workflow.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this Workflow.
        The workflow name. Workflow names must be unique within each tenant.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Workflow.

        The workflow name. Workflow names must be unique within each tenant.

        :param name: The name of this Workflow.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def tasks(self) -> "List[Task]":
        """ Gets the tasks of this Workflow.
        """
        return [Task._from_dict(i) for i in self._attrs.get("tasks")]

    @tasks.setter
    def tasks(self, tasks: "List[Task]"):
        """Sets the tasks of this Workflow.


        :param tasks: The tasks of this Workflow.
        :type: List[Task]
        """
        self._attrs["tasks"] = tasks

    @property
    def version(self) -> "int":
        """ Gets the version of this Workflow.
        The version of the workflow.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Workflow.

        The version of the workflow.

        :param version: The version of this Workflow.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ValidationkindEnum(str, Enum):
    TRAINTEST = "TrainTest"
    CROSSVALIDATION = "CrossValidation"

    @staticmethod
    def from_value(value: str):
        if value == "TrainTest":
            return ValidationkindEnum.TRAINTEST
        if value == "CrossValidation":
            return ValidationkindEnum.CROSSVALIDATION


class WorkflowBuild(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuild":
        instance = WorkflowBuild.__new__(WorkflowBuild)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", modified: "datetime", modifiedby: "str", owner: "str", description: "str" = None, ended: "datetime" = None, evaluationresults: "List[str]" = None, failuremessage: "str" = None, id: "str" = None, inputdata: "List[str]" = None, kfold: "float" = None, name: "str" = None, outputdata: "List[str]" = None, randomstate: "int" = None, started: "datetime" = None, status: "str" = None, stratified: "bool" = None, timeoutsecs: "int" = None, traintestsplit: "float" = None, validationkind: "str" = None, version: "int" = None, workflowid: "str" = None, workflowversion: "int" = None, **extra):
        """WorkflowBuild"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if owner is not None:
            self._attrs["owner"] = owner
        if description is not None:
            self._attrs["description"] = description
        if ended is not None:
            self._attrs["ended"] = ended
        if evaluationresults is not None:
            self._attrs["evaluationresults"] = evaluationresults
        if failuremessage is not None:
            self._attrs["failuremessage"] = failuremessage
        if id is not None:
            self._attrs["id"] = id
        if inputdata is not None:
            self._attrs["inputdata"] = inputdata
        if kfold is not None:
            self._attrs["kfold"] = kfold
        if name is not None:
            self._attrs["name"] = name
        if outputdata is not None:
            self._attrs["outputdata"] = outputdata
        if randomstate is not None:
            self._attrs["randomstate"] = randomstate
        if started is not None:
            self._attrs["started"] = started
        if status is not None:
            self._attrs["status"] = status
        if stratified is not None:
            self._attrs["stratified"] = stratified
        if timeoutsecs is not None:
            self._attrs["timeoutsecs"] = timeoutsecs
        if traintestsplit is not None:
            self._attrs["traintestsplit"] = traintestsplit
        if validationkind is not None:
            self._attrs["validationkind"] = validationkind
        if version is not None:
            self._attrs["version"] = version
        if workflowid is not None:
            self._attrs["workflowid"] = workflowid
        if workflowversion is not None:
            self._attrs["workflowversion"] = workflowversion
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this WorkflowBuild.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this WorkflowBuild.

        The date and time object was created.

        :param created: The created of this WorkflowBuild.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this WorkflowBuild.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this WorkflowBuild.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this WorkflowBuild.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def modified(self) -> "datetime":
        """ Gets the modified of this WorkflowBuild.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "datetime"):
        """Sets the modified of this WorkflowBuild.

        The date and time object was modified.

        :param modified: The modified of this WorkflowBuild.
        :type: datetime
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this WorkflowBuild.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this WorkflowBuild.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this WorkflowBuild.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def owner(self) -> "str":
        """ Gets the owner of this WorkflowBuild.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this WorkflowBuild.

        The name of the object's owner.

        :param owner: The owner of this WorkflowBuild.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowBuild.
        The description of the workflow build.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowBuild.

        The description of the workflow build.

        :param description: The description of this WorkflowBuild.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def ended(self) -> "datetime":
        """ Gets the ended of this WorkflowBuild.
        The date and time the workflow build ended.
        """
        return self._attrs.get("ended")

    @ended.setter
    def ended(self, ended: "datetime"):
        """Sets the ended of this WorkflowBuild.

        The date and time the workflow build ended.

        :param ended: The ended of this WorkflowBuild.
        :type: datetime
        """
        self._attrs["ended"] = ended

    @property
    def evaluationresults(self) -> "List[str]":
        """ Gets the evaluationresults of this WorkflowBuild.
        The evaluation results of the workflow build.
        """
        return self._attrs.get("evaluationresults")

    @evaluationresults.setter
    def evaluationresults(self, evaluationresults: "List[str]"):
        """Sets the evaluationresults of this WorkflowBuild.

        The evaluation results of the workflow build.

        :param evaluationresults: The evaluationresults of this WorkflowBuild.
        :type: List[str]
        """
        self._attrs["evaluationresults"] = evaluationresults

    @property
    def failuremessage(self) -> "str":
        """ Gets the failuremessage of this WorkflowBuild.
        The failure message of the workflow build.
        """
        return self._attrs.get("failuremessage")

    @failuremessage.setter
    def failuremessage(self, failuremessage: "str"):
        """Sets the failuremessage of this WorkflowBuild.

        The failure message of the workflow build.

        :param failuremessage: The failuremessage of this WorkflowBuild.
        :type: str
        """
        self._attrs["failuremessage"] = failuremessage

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowBuild.
        A unique workflow build ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowBuild.

        A unique workflow build ID.

        :param id: The id of this WorkflowBuild.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def inputdata(self) -> "List[str]":
        """ Gets the inputdata of this WorkflowBuild.
        The input data of the workflow build.
        """
        return self._attrs.get("inputdata")

    @inputdata.setter
    def inputdata(self, inputdata: "List[str]"):
        """Sets the inputdata of this WorkflowBuild.

        The input data of the workflow build.

        :param inputdata: The inputdata of this WorkflowBuild.
        :type: List[str]
        """
        self._attrs["inputdata"] = inputdata

    @property
    def kfold(self) -> "float":
        """ Gets the kfold of this WorkflowBuild.
        The number of kfold when the validation type if CrossValidation.
        """
        return self._attrs.get("kfold")

    @kfold.setter
    def kfold(self, kfold: "float"):
        """Sets the kfold of this WorkflowBuild.

        The number of kfold when the validation type if CrossValidation.

        :param kfold: The kfold of this WorkflowBuild.
        :type: float
        """
        self._attrs["kfold"] = kfold

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowBuild.
        The workflow build name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowBuild.

        The workflow build name.

        :param name: The name of this WorkflowBuild.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def outputdata(self) -> "List[str]":
        """ Gets the outputdata of this WorkflowBuild.
        The output data of the workflow build.
        """
        return self._attrs.get("outputdata")

    @outputdata.setter
    def outputdata(self, outputdata: "List[str]"):
        """Sets the outputdata of this WorkflowBuild.

        The output data of the workflow build.

        :param outputdata: The outputdata of this WorkflowBuild.
        :type: List[str]
        """
        self._attrs["outputdata"] = outputdata

    @property
    def randomstate(self) -> "int":
        """ Gets the randomstate of this WorkflowBuild.
        The random state of the workflow build.
        """
        return self._attrs.get("randomstate")

    @randomstate.setter
    def randomstate(self, randomstate: "int"):
        """Sets the randomstate of this WorkflowBuild.

        The random state of the workflow build.

        :param randomstate: The randomstate of this WorkflowBuild.
        :type: int
        """
        self._attrs["randomstate"] = randomstate

    @property
    def started(self) -> "datetime":
        """ Gets the started of this WorkflowBuild.
        The date and time the workflow build started.
        """
        return self._attrs.get("started")

    @started.setter
    def started(self, started: "datetime"):
        """Sets the started of this WorkflowBuild.

        The date and time the workflow build started.

        :param started: The started of this WorkflowBuild.
        :type: datetime
        """
        self._attrs["started"] = started

    @property
    def status(self) -> "str":
        """ Gets the status of this WorkflowBuild.
        The status of the workflow build.
        """
        return self._attrs.get("status")

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowBuild.

        The status of the workflow build.

        :param status: The status of this WorkflowBuild.
        :type: str
        """
        self._attrs["status"] = status

    @property
    def stratified(self) -> "bool":
        """ Gets the stratified of this WorkflowBuild.
        Whether data is stratified.
        """
        return self._attrs.get("stratified")

    @stratified.setter
    def stratified(self, stratified: "bool"):
        """Sets the stratified of this WorkflowBuild.

        Whether data is stratified.

        :param stratified: The stratified of this WorkflowBuild.
        :type: bool
        """
        self._attrs["stratified"] = stratified

    @property
    def timeoutsecs(self) -> "int":
        """ Gets the timeoutsecs of this WorkflowBuild.
        The timeout in seconds of the workflow.
        """
        return self._attrs.get("timeoutsecs")

    @timeoutsecs.setter
    def timeoutsecs(self, timeoutsecs: "int"):
        """Sets the timeoutsecs of this WorkflowBuild.

        The timeout in seconds of the workflow.

        :param timeoutsecs: The timeoutsecs of this WorkflowBuild.
        :type: int
        """
        self._attrs["timeoutsecs"] = timeoutsecs

    @property
    def traintestsplit(self) -> "float":
        """ Gets the traintestsplit of this WorkflowBuild.
        The train test split of the workflow build.
        """
        return self._attrs.get("traintestsplit")

    @traintestsplit.setter
    def traintestsplit(self, traintestsplit: "float"):
        """Sets the traintestsplit of this WorkflowBuild.

        The train test split of the workflow build.

        :param traintestsplit: The traintestsplit of this WorkflowBuild.
        :type: float
        """
        self._attrs["traintestsplit"] = traintestsplit

    @property
    def validationkind(self) -> "ValidationkindEnum":
        """ Gets the validationkind of this WorkflowBuild.
        The type of validation.
        """
        return ValidationkindEnum.from_value(self._attrs.get("validationkind"))

    @validationkind.setter
    def validationkind(self, validationkind: "str"):
        """Sets the validationkind of this WorkflowBuild.

        The type of validation.

        :param validationkind: The validationkind of this WorkflowBuild.
        :type: str
        """
        if isinstance(validationkind, Enum):
            self._attrs["validationkind"] = validationkind.value
        else:
            self._attrs["validationkind"] = validationkind  # If you supply a string, we presume you know the service will take it.

    @property
    def version(self) -> "int":
        """ Gets the version of this WorkflowBuild.
        The version of the workflow.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this WorkflowBuild.

        The version of the workflow.

        :param version: The version of this WorkflowBuild.
        :type: int
        """
        self._attrs["version"] = version

    @property
    def workflowid(self) -> "str":
        """ Gets the workflowid of this WorkflowBuild.
        A unique workflow ID that is associated with the workflow build.
        """
        return self._attrs.get("workflowid")

    @workflowid.setter
    def workflowid(self, workflowid: "str"):
        """Sets the workflowid of this WorkflowBuild.

        A unique workflow ID that is associated with the workflow build.

        :param workflowid: The workflowid of this WorkflowBuild.
        :type: str
        """
        self._attrs["workflowid"] = workflowid

    @property
    def workflowversion(self) -> "int":
        """ Gets the workflowversion of this WorkflowBuild.
        The version of the workflow that is associated with the workflow build.
        """
        return self._attrs.get("workflowversion")

    @workflowversion.setter
    def workflowversion(self, workflowversion: "int"):
        """Sets the workflowversion of this WorkflowBuild.

        The version of the workflow that is associated with the workflow build.

        :param workflowversion: The workflowversion of this WorkflowBuild.
        :type: int
        """
        self._attrs["workflowversion"] = workflowversion

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowBuildPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuildPATCH":
        instance = WorkflowBuildPATCH.__new__(WorkflowBuildPATCH)
        instance._attrs = model
        return instance

    def __init__(self, description: "str" = None, name: "str" = None, status: "str" = None, **extra):
        """WorkflowBuildPATCH"""

        self._attrs = dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowBuildPATCH.
        The workflow build description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowBuildPATCH.

        The workflow build description.

        :param description: The description of this WorkflowBuildPATCH.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowBuildPATCH.
        The workflow build name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowBuildPATCH.

        The workflow build name.

        :param name: The name of this WorkflowBuildPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def status(self) -> "str":
        """ Gets the status of this WorkflowBuildPATCH.
        The status of the workflow build.
        """
        return self._attrs.get("status")

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowBuildPATCH.

        The status of the workflow build.

        :param status: The status of this WorkflowBuildPATCH.
        :type: str
        """
        self._attrs["status"] = status

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowBuildPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuildPOST":
        instance = WorkflowBuildPOST.__new__(WorkflowBuildPOST)
        instance._attrs = model
        return instance

    def __init__(self, inputdata: "List[str]", timeoutsecs: "int", description: "str" = None, ended: "datetime" = None, evaluationresults: "List[str]" = None, failuremessage: "str" = None, id: "str" = None, name: "str" = None, outputdata: "List[str]" = None, randomstate: "int" = None, started: "datetime" = None, status: "str" = None, traintestsplit: "float" = None, version: "int" = None, workflowid: "str" = None, workflowversion: "int" = None, **extra):
        """WorkflowBuildPOST"""

        self._attrs = dict()
        if inputdata is not None:
            self._attrs["inputdata"] = inputdata
        if timeoutsecs is not None:
            self._attrs["timeoutsecs"] = timeoutsecs
        if description is not None:
            self._attrs["description"] = description
        if ended is not None:
            self._attrs["ended"] = ended
        if evaluationresults is not None:
            self._attrs["evaluationresults"] = evaluationresults
        if failuremessage is not None:
            self._attrs["failuremessage"] = failuremessage
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if outputdata is not None:
            self._attrs["outputdata"] = outputdata
        if randomstate is not None:
            self._attrs["randomstate"] = randomstate
        if started is not None:
            self._attrs["started"] = started
        if status is not None:
            self._attrs["status"] = status
        if traintestsplit is not None:
            self._attrs["traintestsplit"] = traintestsplit
        if version is not None:
            self._attrs["version"] = version
        if workflowid is not None:
            self._attrs["workflowid"] = workflowid
        if workflowversion is not None:
            self._attrs["workflowversion"] = workflowversion
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def inputdata(self) -> "List[str]":
        """ Gets the inputdata of this WorkflowBuildPOST.
        The input data of the workflow build.
        """
        return self._attrs.get("inputdata")

    @inputdata.setter
    def inputdata(self, inputdata: "List[str]"):
        """Sets the inputdata of this WorkflowBuildPOST.

        The input data of the workflow build.

        :param inputdata: The inputdata of this WorkflowBuildPOST.
        :type: List[str]
        """
        if inputdata is None:
            raise ValueError("Invalid value for `inputdata`, must not be `None`")
        self._attrs["inputdata"] = inputdata

    @property
    def timeoutsecs(self) -> "int":
        """ Gets the timeoutsecs of this WorkflowBuildPOST.
        The timeout in seconds of the workflow.
        """
        return self._attrs.get("timeoutsecs")

    @timeoutsecs.setter
    def timeoutsecs(self, timeoutsecs: "int"):
        """Sets the timeoutsecs of this WorkflowBuildPOST.

        The timeout in seconds of the workflow.

        :param timeoutsecs: The timeoutsecs of this WorkflowBuildPOST.
        :type: int
        """
        if timeoutsecs is None:
            raise ValueError("Invalid value for `timeoutsecs`, must not be `None`")
        self._attrs["timeoutsecs"] = timeoutsecs

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowBuildPOST.
        The description of the workflow build.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowBuildPOST.

        The description of the workflow build.

        :param description: The description of this WorkflowBuildPOST.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def ended(self) -> "datetime":
        """ Gets the ended of this WorkflowBuildPOST.
        The date and time the workflow build ended.
        """
        return self._attrs.get("ended")

    @ended.setter
    def ended(self, ended: "datetime"):
        """Sets the ended of this WorkflowBuildPOST.

        The date and time the workflow build ended.

        :param ended: The ended of this WorkflowBuildPOST.
        :type: datetime
        """
        self._attrs["ended"] = ended

    @property
    def evaluationresults(self) -> "List[str]":
        """ Gets the evaluationresults of this WorkflowBuildPOST.
        The evaluation results of the workflow build.
        """
        return self._attrs.get("evaluationresults")

    @evaluationresults.setter
    def evaluationresults(self, evaluationresults: "List[str]"):
        """Sets the evaluationresults of this WorkflowBuildPOST.

        The evaluation results of the workflow build.

        :param evaluationresults: The evaluationresults of this WorkflowBuildPOST.
        :type: List[str]
        """
        self._attrs["evaluationresults"] = evaluationresults

    @property
    def failuremessage(self) -> "str":
        """ Gets the failuremessage of this WorkflowBuildPOST.
        The failure message of the workflow build.
        """
        return self._attrs.get("failuremessage")

    @failuremessage.setter
    def failuremessage(self, failuremessage: "str"):
        """Sets the failuremessage of this WorkflowBuildPOST.

        The failure message of the workflow build.

        :param failuremessage: The failuremessage of this WorkflowBuildPOST.
        :type: str
        """
        self._attrs["failuremessage"] = failuremessage

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowBuildPOST.
        A unique workflow build ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowBuildPOST.

        A unique workflow build ID.

        :param id: The id of this WorkflowBuildPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowBuildPOST.
        The workflow build name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowBuildPOST.

        The workflow build name.

        :param name: The name of this WorkflowBuildPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def outputdata(self) -> "List[str]":
        """ Gets the outputdata of this WorkflowBuildPOST.
        The output data of the workflow build.
        """
        return self._attrs.get("outputdata")

    @outputdata.setter
    def outputdata(self, outputdata: "List[str]"):
        """Sets the outputdata of this WorkflowBuildPOST.

        The output data of the workflow build.

        :param outputdata: The outputdata of this WorkflowBuildPOST.
        :type: List[str]
        """
        self._attrs["outputdata"] = outputdata

    @property
    def randomstate(self) -> "int":
        """ Gets the randomstate of this WorkflowBuildPOST.
        The random state of the workflow build.
        """
        return self._attrs.get("randomstate")

    @randomstate.setter
    def randomstate(self, randomstate: "int"):
        """Sets the randomstate of this WorkflowBuildPOST.

        The random state of the workflow build.

        :param randomstate: The randomstate of this WorkflowBuildPOST.
        :type: int
        """
        self._attrs["randomstate"] = randomstate

    @property
    def started(self) -> "datetime":
        """ Gets the started of this WorkflowBuildPOST.
        The date and time the workflow build started.
        """
        return self._attrs.get("started")

    @started.setter
    def started(self, started: "datetime"):
        """Sets the started of this WorkflowBuildPOST.

        The date and time the workflow build started.

        :param started: The started of this WorkflowBuildPOST.
        :type: datetime
        """
        self._attrs["started"] = started

    @property
    def status(self) -> "str":
        """ Gets the status of this WorkflowBuildPOST.
        The status of the workflow build.
        """
        return self._attrs.get("status")

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowBuildPOST.

        The status of the workflow build.

        :param status: The status of this WorkflowBuildPOST.
        :type: str
        """
        self._attrs["status"] = status

    @property
    def traintestsplit(self) -> "float":
        """ Gets the traintestsplit of this WorkflowBuildPOST.
        The train test split of the workflow build.
        """
        return self._attrs.get("traintestsplit")

    @traintestsplit.setter
    def traintestsplit(self, traintestsplit: "float"):
        """Sets the traintestsplit of this WorkflowBuildPOST.

        The train test split of the workflow build.

        :param traintestsplit: The traintestsplit of this WorkflowBuildPOST.
        :type: float
        """
        self._attrs["traintestsplit"] = traintestsplit

    @property
    def version(self) -> "int":
        """ Gets the version of this WorkflowBuildPOST.
        The version of the workflow.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this WorkflowBuildPOST.

        The version of the workflow.

        :param version: The version of this WorkflowBuildPOST.
        :type: int
        """
        self._attrs["version"] = version

    @property
    def workflowid(self) -> "str":
        """ Gets the workflowid of this WorkflowBuildPOST.
        A unique workflow ID that is associated with the workflow build.
        """
        return self._attrs.get("workflowid")

    @workflowid.setter
    def workflowid(self, workflowid: "str"):
        """Sets the workflowid of this WorkflowBuildPOST.

        A unique workflow ID that is associated with the workflow build.

        :param workflowid: The workflowid of this WorkflowBuildPOST.
        :type: str
        """
        self._attrs["workflowid"] = workflowid

    @property
    def workflowversion(self) -> "int":
        """ Gets the workflowversion of this WorkflowBuildPOST.
        The version of the workflow that is associated with the workflow build.
        """
        return self._attrs.get("workflowversion")

    @workflowversion.setter
    def workflowversion(self, workflowversion: "int"):
        """Sets the workflowversion of this WorkflowBuildPOST.

        The version of the workflow that is associated with the workflow build.

        :param workflowversion: The workflowversion of this WorkflowBuildPOST.
        :type: int
        """
        self._attrs["workflowversion"] = workflowversion

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowPATCH":
        instance = WorkflowPATCH.__new__(WorkflowPATCH)
        instance._attrs = model
        return instance

    def __init__(self, description: "str" = None, name: "str" = None, **extra):
        """WorkflowPATCH"""

        self._attrs = dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowPATCH.
        The workflow description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowPATCH.

        The workflow description.

        :param description: The description of this WorkflowPATCH.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowPATCH.
        The workflow name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowPATCH.

        The workflow name.

        :param name: The name of this WorkflowPATCH.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowPOST":
        instance = WorkflowPOST.__new__(WorkflowPOST)
        instance._attrs = model
        return instance

    def __init__(self, tasks: "List[TaskPOST]", description: "str" = None, experimentid: "str" = None, id: "str" = None, name: "str" = None, version: "int" = None, **extra):
        """WorkflowPOST"""

        self._attrs = dict()
        if tasks is not None:
            self._attrs["tasks"] = tasks
        if description is not None:
            self._attrs["description"] = description
        if experimentid is not None:
            self._attrs["experimentid"] = experimentid
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def tasks(self) -> "List[TaskPOST]":
        """ Gets the tasks of this WorkflowPOST.
        """
        return [TaskPOST._from_dict(i) for i in self._attrs.get("tasks")]

    @tasks.setter
    def tasks(self, tasks: "List[TaskPOST]"):
        """Sets the tasks of this WorkflowPOST.


        :param tasks: The tasks of this WorkflowPOST.
        :type: List[TaskPOST]
        """
        if tasks is None:
            raise ValueError("Invalid value for `tasks`, must not be `None`")
        self._attrs["tasks"] = tasks

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowPOST.
        The workflow description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowPOST.

        The workflow description.

        :param description: The description of this WorkflowPOST.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def experimentid(self) -> "str":
        """ Gets the experimentid of this WorkflowPOST.
        A unique experiment ID that is associate with the workflow.
        """
        return self._attrs.get("experimentid")

    @experimentid.setter
    def experimentid(self, experimentid: "str"):
        """Sets the experimentid of this WorkflowPOST.

        A unique experiment ID that is associate with the workflow.

        :param experimentid: The experimentid of this WorkflowPOST.
        :type: str
        """
        self._attrs["experimentid"] = experimentid

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowPOST.
        A unique workflow ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowPOST.

        A unique workflow ID. Random ID used if not provided.

        :param id: The id of this WorkflowPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this WorkflowPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this WorkflowPOST.
        The version of the workflow.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this WorkflowPOST.

        The version of the workflow.

        :param version: The version of this WorkflowPOST.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowRun(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowRun":
        instance = WorkflowRun.__new__(WorkflowRun)
        instance._attrs = model
        return instance

    def __init__(self, created: "datetime", createdby: "str", id: "str", inputdata: "List[str]", outputdata: "List[str]", owner: "str", timeoutsecs: "int", workflowbuildid: "str", workflowbuildversion: "int", description: "str" = None, ended: "datetime" = None, failuremessage: "str" = None, name: "str" = None, started: "datetime" = None, status: "str" = None, **extra):
        """WorkflowRun"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if inputdata is not None:
            self._attrs["inputdata"] = inputdata
        if outputdata is not None:
            self._attrs["outputdata"] = outputdata
        if owner is not None:
            self._attrs["owner"] = owner
        if timeoutsecs is not None:
            self._attrs["timeoutsecs"] = timeoutsecs
        if workflowbuildid is not None:
            self._attrs["workflowbuildid"] = workflowbuildid
        if workflowbuildversion is not None:
            self._attrs["workflowbuildversion"] = workflowbuildversion
        if description is not None:
            self._attrs["description"] = description
        if ended is not None:
            self._attrs["ended"] = ended
        if failuremessage is not None:
            self._attrs["failuremessage"] = failuremessage
        if name is not None:
            self._attrs["name"] = name
        if started is not None:
            self._attrs["started"] = started
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "datetime":
        """ Gets the created of this WorkflowRun.
        The date and time the workflow run was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "datetime"):
        """Sets the created of this WorkflowRun.

        The date and time the workflow run was created.

        :param created: The created of this WorkflowRun.
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this WorkflowRun.
        The name of the user who created the workflow run. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this WorkflowRun.

        The name of the user who created the workflow run. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this WorkflowRun.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowRun.
        A unique workflow Run ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowRun.

        A unique workflow Run ID.

        :param id: The id of this WorkflowRun.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def inputdata(self) -> "List[str]":
        """ Gets the inputdata of this WorkflowRun.
        The input data of the workflow run.
        """
        return self._attrs.get("inputdata")

    @inputdata.setter
    def inputdata(self, inputdata: "List[str]"):
        """Sets the inputdata of this WorkflowRun.

        The input data of the workflow run.

        :param inputdata: The inputdata of this WorkflowRun.
        :type: List[str]
        """
        if inputdata is None:
            raise ValueError("Invalid value for `inputdata`, must not be `None`")
        self._attrs["inputdata"] = inputdata

    @property
    def outputdata(self) -> "List[str]":
        """ Gets the outputdata of this WorkflowRun.
        The output data of the workflow run.
        """
        return self._attrs.get("outputdata")

    @outputdata.setter
    def outputdata(self, outputdata: "List[str]"):
        """Sets the outputdata of this WorkflowRun.

        The output data of the workflow run.

        :param outputdata: The outputdata of this WorkflowRun.
        :type: List[str]
        """
        if outputdata is None:
            raise ValueError("Invalid value for `outputdata`, must not be `None`")
        self._attrs["outputdata"] = outputdata

    @property
    def owner(self) -> "str":
        """ Gets the owner of this WorkflowRun.
        The name of the workflow run's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this WorkflowRun.

        The name of the workflow run's owner.

        :param owner: The owner of this WorkflowRun.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def timeoutsecs(self) -> "int":
        """ Gets the timeoutsecs of this WorkflowRun.
        The timeout in seconds of the workflow.
        """
        return self._attrs.get("timeoutsecs")

    @timeoutsecs.setter
    def timeoutsecs(self, timeoutsecs: "int"):
        """Sets the timeoutsecs of this WorkflowRun.

        The timeout in seconds of the workflow.

        :param timeoutsecs: The timeoutsecs of this WorkflowRun.
        :type: int
        """
        if timeoutsecs is None:
            raise ValueError("Invalid value for `timeoutsecs`, must not be `None`")
        self._attrs["timeoutsecs"] = timeoutsecs

    @property
    def workflowbuildid(self) -> "str":
        """ Gets the workflowbuildid of this WorkflowRun.
        A unique workflow build ID that is associated with the workflow run.
        """
        return self._attrs.get("workflowbuildid")

    @workflowbuildid.setter
    def workflowbuildid(self, workflowbuildid: "str"):
        """Sets the workflowbuildid of this WorkflowRun.

        A unique workflow build ID that is associated with the workflow run.

        :param workflowbuildid: The workflowbuildid of this WorkflowRun.
        :type: str
        """
        if workflowbuildid is None:
            raise ValueError("Invalid value for `workflowbuildid`, must not be `None`")
        self._attrs["workflowbuildid"] = workflowbuildid

    @property
    def workflowbuildversion(self) -> "int":
        """ Gets the workflowbuildversion of this WorkflowRun.
        The version of the workflow build that is associated with the workflow run.
        """
        return self._attrs.get("workflowbuildversion")

    @workflowbuildversion.setter
    def workflowbuildversion(self, workflowbuildversion: "int"):
        """Sets the workflowbuildversion of this WorkflowRun.

        The version of the workflow build that is associated with the workflow run.

        :param workflowbuildversion: The workflowbuildversion of this WorkflowRun.
        :type: int
        """
        if workflowbuildversion is None:
            raise ValueError("Invalid value for `workflowbuildversion`, must not be `None`")
        self._attrs["workflowbuildversion"] = workflowbuildversion

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowRun.
        The description of the workflow run.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowRun.

        The description of the workflow run.

        :param description: The description of this WorkflowRun.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def ended(self) -> "datetime":
        """ Gets the ended of this WorkflowRun.
        The date and time the workflow build ended.
        """
        return self._attrs.get("ended")

    @ended.setter
    def ended(self, ended: "datetime"):
        """Sets the ended of this WorkflowRun.

        The date and time the workflow build ended.

        :param ended: The ended of this WorkflowRun.
        :type: datetime
        """
        self._attrs["ended"] = ended

    @property
    def failuremessage(self) -> "str":
        """ Gets the failuremessage of this WorkflowRun.
        The failure message of the workflow run.
        """
        return self._attrs.get("failuremessage")

    @failuremessage.setter
    def failuremessage(self, failuremessage: "str"):
        """Sets the failuremessage of this WorkflowRun.

        The failure message of the workflow run.

        :param failuremessage: The failuremessage of this WorkflowRun.
        :type: str
        """
        self._attrs["failuremessage"] = failuremessage

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowRun.
        The workflow run name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowRun.

        The workflow run name.

        :param name: The name of this WorkflowRun.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def started(self) -> "datetime":
        """ Gets the started of this WorkflowRun.
        The date and time the workflow build started.
        """
        return self._attrs.get("started")

    @started.setter
    def started(self, started: "datetime"):
        """Sets the started of this WorkflowRun.

        The date and time the workflow build started.

        :param started: The started of this WorkflowRun.
        :type: datetime
        """
        self._attrs["started"] = started

    @property
    def status(self) -> "str":
        """ Gets the status of this WorkflowRun.
        The status of the workflow run.
        """
        return self._attrs.get("status")

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowRun.

        The status of the workflow run.

        :param status: The status of this WorkflowRun.
        :type: str
        """
        self._attrs["status"] = status

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowRunPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowRunPATCH":
        instance = WorkflowRunPATCH.__new__(WorkflowRunPATCH)
        instance._attrs = model
        return instance

    def __init__(self, description: "str" = None, name: "str" = None, status: "str" = None, **extra):
        """WorkflowRunPATCH"""

        self._attrs = dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowRunPATCH.
        The workflow run description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowRunPATCH.

        The workflow run description.

        :param description: The description of this WorkflowRunPATCH.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowRunPATCH.
        The workflow run name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowRunPATCH.

        The workflow run name.

        :param name: The name of this WorkflowRunPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def status(self) -> "str":
        """ Gets the status of this WorkflowRunPATCH.
        The status of the workflow run.
        """
        return self._attrs.get("status")

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowRunPATCH.

        The status of the workflow run.

        :param status: The status of this WorkflowRunPATCH.
        :type: str
        """
        self._attrs["status"] = status

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowRunPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowRunPOST":
        instance = WorkflowRunPOST.__new__(WorkflowRunPOST)
        instance._attrs = model
        return instance

    def __init__(self, inputdata: "List[str]", outputdata: "List[str]", timeoutsecs: "int", description: "str" = None, ended: "datetime" = None, failuremessage: "str" = None, id: "str" = None, name: "str" = None, started: "datetime" = None, status: "str" = None, workflowbuildid: "str" = None, workflowbuildversion: "int" = None, **extra):
        """WorkflowRunPOST"""

        self._attrs = dict()
        if inputdata is not None:
            self._attrs["inputdata"] = inputdata
        if outputdata is not None:
            self._attrs["outputdata"] = outputdata
        if timeoutsecs is not None:
            self._attrs["timeoutsecs"] = timeoutsecs
        if description is not None:
            self._attrs["description"] = description
        if ended is not None:
            self._attrs["ended"] = ended
        if failuremessage is not None:
            self._attrs["failuremessage"] = failuremessage
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if started is not None:
            self._attrs["started"] = started
        if status is not None:
            self._attrs["status"] = status
        if workflowbuildid is not None:
            self._attrs["workflowbuildid"] = workflowbuildid
        if workflowbuildversion is not None:
            self._attrs["workflowbuildversion"] = workflowbuildversion
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def inputdata(self) -> "List[str]":
        """ Gets the inputdata of this WorkflowRunPOST.
        The input data of the workflow run for specified workflow build ID.
        """
        return self._attrs.get("inputdata")

    @inputdata.setter
    def inputdata(self, inputdata: "List[str]"):
        """Sets the inputdata of this WorkflowRunPOST.

        The input data of the workflow run for specified workflow build ID.

        :param inputdata: The inputdata of this WorkflowRunPOST.
        :type: List[str]
        """
        if inputdata is None:
            raise ValueError("Invalid value for `inputdata`, must not be `None`")
        self._attrs["inputdata"] = inputdata

    @property
    def outputdata(self) -> "List[str]":
        """ Gets the outputdata of this WorkflowRunPOST.
        The output data of the workflow run for specified workflow build ID.
        """
        return self._attrs.get("outputdata")

    @outputdata.setter
    def outputdata(self, outputdata: "List[str]"):
        """Sets the outputdata of this WorkflowRunPOST.

        The output data of the workflow run for specified workflow build ID.

        :param outputdata: The outputdata of this WorkflowRunPOST.
        :type: List[str]
        """
        if outputdata is None:
            raise ValueError("Invalid value for `outputdata`, must not be `None`")
        self._attrs["outputdata"] = outputdata

    @property
    def timeoutsecs(self) -> "int":
        """ Gets the timeoutsecs of this WorkflowRunPOST.
        The timeout in seconds of the workflow run for specified workflow build ID.
        """
        return self._attrs.get("timeoutsecs")

    @timeoutsecs.setter
    def timeoutsecs(self, timeoutsecs: "int"):
        """Sets the timeoutsecs of this WorkflowRunPOST.

        The timeout in seconds of the workflow run for specified workflow build ID.

        :param timeoutsecs: The timeoutsecs of this WorkflowRunPOST.
        :type: int
        """
        if timeoutsecs is None:
            raise ValueError("Invalid value for `timeoutsecs`, must not be `None`")
        self._attrs["timeoutsecs"] = timeoutsecs

    @property
    def description(self) -> "str":
        """ Gets the description of this WorkflowRunPOST.
        The description of the workflow run.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this WorkflowRunPOST.

        The description of the workflow run.

        :param description: The description of this WorkflowRunPOST.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def ended(self) -> "datetime":
        """ Gets the ended of this WorkflowRunPOST.
        The date and time the workflow run ended for specified workflow build ID.
        """
        return self._attrs.get("ended")

    @ended.setter
    def ended(self, ended: "datetime"):
        """Sets the ended of this WorkflowRunPOST.

        The date and time the workflow run ended for specified workflow build ID.

        :param ended: The ended of this WorkflowRunPOST.
        :type: datetime
        """
        self._attrs["ended"] = ended

    @property
    def failuremessage(self) -> "str":
        """ Gets the failuremessage of this WorkflowRunPOST.
        The failure message of the workflow run for specified workflow build ID.
        """
        return self._attrs.get("failuremessage")

    @failuremessage.setter
    def failuremessage(self, failuremessage: "str"):
        """Sets the failuremessage of this WorkflowRunPOST.

        The failure message of the workflow run for specified workflow build ID.

        :param failuremessage: The failuremessage of this WorkflowRunPOST.
        :type: str
        """
        self._attrs["failuremessage"] = failuremessage

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowRunPOST.
        A unique workflow Run ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowRunPOST.

        A unique workflow Run ID.

        :param id: The id of this WorkflowRunPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowRunPOST.
        The workflow run name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowRunPOST.

        The workflow run name.

        :param name: The name of this WorkflowRunPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def started(self) -> "datetime":
        """ Gets the started of this WorkflowRunPOST.
        The date and time the workflow run started for specified workflow build ID.
        """
        return self._attrs.get("started")

    @started.setter
    def started(self, started: "datetime"):
        """Sets the started of this WorkflowRunPOST.

        The date and time the workflow run started for specified workflow build ID.

        :param started: The started of this WorkflowRunPOST.
        :type: datetime
        """
        self._attrs["started"] = started

    @property
    def status(self) -> "str":
        """ Gets the status of this WorkflowRunPOST.
        The status of the workflow run for specified workflow build ID.
        """
        return self._attrs.get("status")

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowRunPOST.

        The status of the workflow run for specified workflow build ID.

        :param status: The status of this WorkflowRunPOST.
        :type: str
        """
        self._attrs["status"] = status

    @property
    def workflowbuildid(self) -> "str":
        """ Gets the workflowbuildid of this WorkflowRunPOST.
        A unique workflow build ID that is associated with the workflow run.
        """
        return self._attrs.get("workflowbuildid")

    @workflowbuildid.setter
    def workflowbuildid(self, workflowbuildid: "str"):
        """Sets the workflowbuildid of this WorkflowRunPOST.

        A unique workflow build ID that is associated with the workflow run.

        :param workflowbuildid: The workflowbuildid of this WorkflowRunPOST.
        :type: str
        """
        self._attrs["workflowbuildid"] = workflowbuildid

    @property
    def workflowbuildversion(self) -> "int":
        """ Gets the workflowbuildversion of this WorkflowRunPOST.
        The version of the workflow build that is assocaited with the workflow run.
        """
        return self._attrs.get("workflowbuildversion")

    @workflowbuildversion.setter
    def workflowbuildversion(self, workflowbuildversion: "int"):
        """Sets the workflowbuildversion of this WorkflowRunPOST.

        The version of the workflow build that is assocaited with the workflow run.

        :param workflowbuildversion: The workflowbuildversion of this WorkflowRunPOST.
        :type: int
        """
        self._attrs["workflowbuildversion"] = workflowbuildversion

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
