# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Identity

    With the Identity service in Splunk Cloud Services, you can authenticate and authorize Splunk Cloud Services users.

    OpenAPI spec version: v2beta1.21 
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class AddGroupMemberBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "AddGroupMemberBody":
        instance = AddGroupMemberBody.__new__(AddGroupMemberBody)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", **extra):
        """AddGroupMemberBody"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this AddGroupMemberBody.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this AddGroupMemberBody.


        :param name: The name of this AddGroupMemberBody.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AddGroupRoleBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "AddGroupRoleBody":
        instance = AddGroupRoleBody.__new__(AddGroupRoleBody)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", **extra):
        """AddGroupRoleBody"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this AddGroupRoleBody.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this AddGroupRoleBody.


        :param name: The name of this AddGroupRoleBody.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AddMemberBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "AddMemberBody":
        instance = AddMemberBody.__new__(AddMemberBody)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", **extra):
        """AddMemberBody"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this AddMemberBody.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this AddMemberBody.


        :param name: The name of this AddMemberBody.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class CreateGroupBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "CreateGroupBody":
        instance = CreateGroupBody.__new__(CreateGroupBody)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", **extra):
        """CreateGroupBody"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this CreateGroupBody.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this CreateGroupBody.


        :param name: The name of this CreateGroupBody.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PrincipalKind(str, Enum):
    USER = "user"
    SERVICE_ACCOUNT = "service_account"
    SERVICE = "service"

    @staticmethod
    def from_value(value: str):
        if value == "user":
            return PrincipalKind.USER
        if value == "service_account":
            return PrincipalKind.SERVICE_ACCOUNT
        if value == "service":
            return PrincipalKind.SERVICE


class TypeEnum(str, Enum):
    PASSWORD = "password"

    @staticmethod
    def from_value(value: str):
        if value == "password":
            return TypeEnum.PASSWORD


class Credential(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Credential":
        instance = Credential.__new__(Credential)
        instance._attrs = model
        return instance

    def __init__(self, type: "str", value: "str", **extra):
        """Credential"""

        self._attrs = dict()
        if type is not None:
            self._attrs["type"] = type
        if value is not None:
            self._attrs["value"] = value
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def type(self) -> "TypeEnum":
        """ Gets the type of this Credential.
        """
        return TypeEnum.from_value(self._attrs.get("type"))

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this Credential.


        :param type: The type of this Credential.
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")
        if isinstance(type, Enum):
            self._attrs["type"] = type.value
        else:
            self._attrs["type"] = type  # If you supply a string, we presume you know the service will take it.

    @property
    def value(self) -> "str":
        """ Gets the value of this Credential.
        """
        return self._attrs.get("value")

    @value.setter
    def value(self, value: "str"):
        """Sets the value of this Credential.


        :param value: The value of this Credential.
        :type: str
        """
        if value is None:
            raise ValueError("Invalid value for `value`, must not be `None`")
        self._attrs["value"] = value

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class AlgEnum(str, Enum):
    ES256 = "ES256"
    ES384 = "ES384"
    ES512 = "ES512"

    @staticmethod
    def from_value(value: str):
        if value == "ES256":
            return AlgEnum.ES256
        if value == "ES384":
            return AlgEnum.ES384
        if value == "ES512":
            return AlgEnum.ES512


class KtyEnum(str, Enum):
    EC = "EC"

    @staticmethod
    def from_value(value: str):
        if value == "EC":
            return KtyEnum.EC


class ECJwk(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ECJwk":
        instance = ECJwk.__new__(ECJwk)
        instance._attrs = model
        return instance

    def __init__(self, alg: "str" = None, crv: "str" = None, d: "str" = None, kid: "str" = None, kty: "str" = None, x: "str" = None, y: "str" = None, **extra):
        """ECJwk"""

        self._attrs = dict()
        if alg is not None:
            self._attrs["alg"] = alg
        if crv is not None:
            self._attrs["crv"] = crv
        if d is not None:
            self._attrs["d"] = d
        if kid is not None:
            self._attrs["kid"] = kid
        if kty is not None:
            self._attrs["kty"] = kty
        if x is not None:
            self._attrs["x"] = x
        if y is not None:
            self._attrs["y"] = y
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def alg(self) -> "AlgEnum":
        """ Gets the alg of this ECJwk.
        """
        return AlgEnum.from_value(self._attrs.get("alg"))

    @alg.setter
    def alg(self, alg: "str"):
        """Sets the alg of this ECJwk.


        :param alg: The alg of this ECJwk.
        :type: str
        """
        if isinstance(alg, Enum):
            self._attrs["alg"] = alg.value
        else:
            self._attrs["alg"] = alg  # If you supply a string, we presume you know the service will take it.

    @property
    def crv(self) -> "str":
        """ Gets the crv of this ECJwk.
        """
        return self._attrs.get("crv")

    @crv.setter
    def crv(self, crv: "str"):
        """Sets the crv of this ECJwk.


        :param crv: The crv of this ECJwk.
        :type: str
        """
        self._attrs["crv"] = crv

    @property
    def d(self) -> "str":
        """ Gets the d of this ECJwk.
        """
        return self._attrs.get("d")

    @d.setter
    def d(self, d: "str"):
        """Sets the d of this ECJwk.


        :param d: The d of this ECJwk.
        :type: str
        """
        self._attrs["d"] = d

    @property
    def kid(self) -> "str":
        """ Gets the kid of this ECJwk.
        """
        return self._attrs.get("kid")

    @kid.setter
    def kid(self, kid: "str"):
        """Sets the kid of this ECJwk.


        :param kid: The kid of this ECJwk.
        :type: str
        """
        self._attrs["kid"] = kid

    @property
    def kty(self) -> "KtyEnum":
        """ Gets the kty of this ECJwk.
        """
        return KtyEnum.from_value(self._attrs.get("kty"))

    @kty.setter
    def kty(self, kty: "str"):
        """Sets the kty of this ECJwk.


        :param kty: The kty of this ECJwk.
        :type: str
        """
        if isinstance(kty, Enum):
            self._attrs["kty"] = kty.value
        else:
            self._attrs["kty"] = kty  # If you supply a string, we presume you know the service will take it.

    @property
    def x(self) -> "str":
        """ Gets the x of this ECJwk.
        """
        return self._attrs.get("x")

    @x.setter
    def x(self, x: "str"):
        """Sets the x of this ECJwk.


        :param x: The x of this ECJwk.
        :type: str
        """
        self._attrs["x"] = x

    @property
    def y(self) -> "str":
        """ Gets the y of this ECJwk.
        """
        return self._attrs.get("y")

    @y.setter
    def y(self, y: "str"):
        """Sets the y of this ECJwk.


        :param y: The y of this ECJwk.
        :type: str
        """
        self._attrs["y"] = y

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class CreatePrincipalProfile(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "CreatePrincipalProfile":
        instance = CreatePrincipalProfile.__new__(CreatePrincipalProfile)
        instance._attrs = model
        return instance

    def __init__(self, email: "str", first_name: "str", last_name: "str", **extra):
        """CreatePrincipalProfile"""

        self._attrs = dict()
        if email is not None:
            self._attrs["email"] = email
        if first_name is not None:
            self._attrs["firstName"] = first_name
        if last_name is not None:
            self._attrs["lastName"] = last_name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def email(self) -> "str":
        """ Gets the email of this CreatePrincipalProfile.
        """
        return self._attrs.get("email")

    @email.setter
    def email(self, email: "str"):
        """Sets the email of this CreatePrincipalProfile.


        :param email: The email of this CreatePrincipalProfile.
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")
        self._attrs["email"] = email

    @property
    def first_name(self) -> "str":
        """ Gets the first_name of this CreatePrincipalProfile.
        """
        return self._attrs.get("firstName")

    @first_name.setter
    def first_name(self, first_name: "str"):
        """Sets the first_name of this CreatePrincipalProfile.


        :param first_name: The first_name of this CreatePrincipalProfile.
        :type: str
        """
        if first_name is None:
            raise ValueError("Invalid value for `first_name`, must not be `None`")
        self._attrs["firstName"] = first_name

    @property
    def last_name(self) -> "str":
        """ Gets the last_name of this CreatePrincipalProfile.
        """
        return self._attrs.get("lastName")

    @last_name.setter
    def last_name(self, last_name: "str"):
        """Sets the last_name of this CreatePrincipalProfile.


        :param last_name: The last_name of this CreatePrincipalProfile.
        :type: str
        """
        if last_name is None:
            raise ValueError("Invalid value for `last_name`, must not be `None`")
        self._attrs["lastName"] = last_name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class CreatePrincipalBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "CreatePrincipalBody":
        instance = CreatePrincipalBody.__new__(CreatePrincipalBody)
        instance._attrs = model
        return instance

    def __init__(self, kind: "PrincipalKind", accept_tos: "bool" = False, credentials: "List[Credential]" = None, enabled: "bool" = None, key: "ECJwk" = None, name: "str" = None, profile: "CreatePrincipalProfile" = None, **extra):
        """CreatePrincipalBody"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if accept_tos is not None:
            self._attrs["acceptTos"] = accept_tos
        if credentials is not None:
            self._attrs["credentials"] = credentials
        if enabled is not None:
            self._attrs["enabled"] = enabled
        if key is not None:
            self._attrs["key"] = key.to_dict()
        if name is not None:
            self._attrs["name"] = name
        if profile is not None:
            self._attrs["profile"] = profile.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "PrincipalKind":
        """ Gets the kind of this CreatePrincipalBody.
        """
        return PrincipalKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "PrincipalKind"):
        """Sets the kind of this CreatePrincipalBody.


        :param kind: The kind of this CreatePrincipalBody.
        :type: PrincipalKind
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def accept_tos(self) -> "bool":
        """ Gets the accept_tos of this CreatePrincipalBody.
        """
        return self._attrs.get("acceptTos")

    @accept_tos.setter
    def accept_tos(self, accept_tos: "bool"):
        """Sets the accept_tos of this CreatePrincipalBody.


        :param accept_tos: The accept_tos of this CreatePrincipalBody.
        :type: bool
        """
        self._attrs["acceptTos"] = accept_tos

    @property
    def credentials(self) -> "List[Credential]":
        """ Gets the credentials of this CreatePrincipalBody.
        List of credentials
        """
        return [Credential._from_dict(i) for i in self._attrs.get("credentials")]

    @credentials.setter
    def credentials(self, credentials: "List[Credential]"):
        """Sets the credentials of this CreatePrincipalBody.

        List of credentials

        :param credentials: The credentials of this CreatePrincipalBody.
        :type: List[Credential]
        """
        self._attrs["credentials"] = credentials

    @property
    def enabled(self) -> "bool":
        """ Gets the enabled of this CreatePrincipalBody.
        """
        return self._attrs.get("enabled")

    @enabled.setter
    def enabled(self, enabled: "bool"):
        """Sets the enabled of this CreatePrincipalBody.


        :param enabled: The enabled of this CreatePrincipalBody.
        :type: bool
        """
        self._attrs["enabled"] = enabled

    @property
    def key(self) -> "ECJwk":
        """ Gets the key of this CreatePrincipalBody.
        """
        return ECJwk._from_dict(self._attrs["key"])

    @key.setter
    def key(self, key: "ECJwk"):
        """Sets the key of this CreatePrincipalBody.


        :param key: The key of this CreatePrincipalBody.
        :type: ECJwk
        """
        self._attrs["key"] = key.to_dict()

    @property
    def name(self) -> "str":
        """ Gets the name of this CreatePrincipalBody.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this CreatePrincipalBody.


        :param name: The name of this CreatePrincipalBody.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def profile(self) -> "CreatePrincipalProfile":
        """ Gets the profile of this CreatePrincipalBody.
        """
        return CreatePrincipalProfile._from_dict(self._attrs["profile"])

    @profile.setter
    def profile(self, profile: "CreatePrincipalProfile"):
        """Sets the profile of this CreatePrincipalBody.


        :param profile: The profile of this CreatePrincipalBody.
        :type: CreatePrincipalProfile
        """
        self._attrs["profile"] = profile.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class CreateRoleBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "CreateRoleBody":
        instance = CreateRoleBody.__new__(CreateRoleBody)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", **extra):
        """CreateRoleBody"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this CreateRoleBody.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this CreateRoleBody.


        :param name: The name of this CreateRoleBody.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Group(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Group":
        instance = Group.__new__(Group)
        instance._attrs = model
        return instance

    def __init__(self, created_at: "datetime", created_by: "str", member_count: "int", name: "str", role_count: "int", tenant: "str", **extra):
        """Group"""

        self._attrs = dict()
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if member_count is not None:
            self._attrs["memberCount"] = member_count
        if name is not None:
            self._attrs["name"] = name
        if role_count is not None:
            self._attrs["roleCount"] = role_count
        if tenant is not None:
            self._attrs["tenant"] = tenant
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this Group.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this Group.


        :param created_at: The created_at of this Group.
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this Group.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this Group.


        :param created_by: The created_by of this Group.
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")
        self._attrs["createdBy"] = created_by

    @property
    def member_count(self) -> "int":
        """ Gets the member_count of this Group.
        """
        return self._attrs.get("memberCount")

    @member_count.setter
    def member_count(self, member_count: "int"):
        """Sets the member_count of this Group.


        :param member_count: The member_count of this Group.
        :type: int
        """
        if member_count is None:
            raise ValueError("Invalid value for `member_count`, must not be `None`")
        self._attrs["memberCount"] = member_count

    @property
    def name(self) -> "str":
        """ Gets the name of this Group.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Group.


        :param name: The name of this Group.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def role_count(self) -> "int":
        """ Gets the role_count of this Group.
        """
        return self._attrs.get("roleCount")

    @role_count.setter
    def role_count(self, role_count: "int"):
        """Sets the role_count of this Group.


        :param role_count: The role_count of this Group.
        :type: int
        """
        if role_count is None:
            raise ValueError("Invalid value for `role_count`, must not be `None`")
        self._attrs["roleCount"] = role_count

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this Group.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this Group.


        :param tenant: The tenant of this Group.
        :type: str
        """
        if tenant is None:
            raise ValueError("Invalid value for `tenant`, must not be `None`")
        self._attrs["tenant"] = tenant

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupMember(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupMember":
        instance = GroupMember.__new__(GroupMember)
        instance._attrs = model
        return instance

    def __init__(self, added_at: "datetime", added_by: "str", group: "str", principal: "str", tenant: "str", **extra):
        """GroupMember"""

        self._attrs = dict()
        if added_at is not None:
            self._attrs["addedAt"] = added_at
        if added_by is not None:
            self._attrs["addedBy"] = added_by
        if group is not None:
            self._attrs["group"] = group
        if principal is not None:
            self._attrs["principal"] = principal
        if tenant is not None:
            self._attrs["tenant"] = tenant
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def added_at(self) -> "datetime":
        """ Gets the added_at of this GroupMember.
        """
        return self._attrs.get("addedAt")

    @added_at.setter
    def added_at(self, added_at: "datetime"):
        """Sets the added_at of this GroupMember.


        :param added_at: The added_at of this GroupMember.
        :type: datetime
        """
        if added_at is None:
            raise ValueError("Invalid value for `added_at`, must not be `None`")
        self._attrs["addedAt"] = added_at

    @property
    def added_by(self) -> "str":
        """ Gets the added_by of this GroupMember.
        """
        return self._attrs.get("addedBy")

    @added_by.setter
    def added_by(self, added_by: "str"):
        """Sets the added_by of this GroupMember.


        :param added_by: The added_by of this GroupMember.
        :type: str
        """
        if added_by is None:
            raise ValueError("Invalid value for `added_by`, must not be `None`")
        self._attrs["addedBy"] = added_by

    @property
    def group(self) -> "str":
        """ Gets the group of this GroupMember.
        """
        return self._attrs.get("group")

    @group.setter
    def group(self, group: "str"):
        """Sets the group of this GroupMember.


        :param group: The group of this GroupMember.
        :type: str
        """
        if group is None:
            raise ValueError("Invalid value for `group`, must not be `None`")
        self._attrs["group"] = group

    @property
    def principal(self) -> "str":
        """ Gets the principal of this GroupMember.
        """
        return self._attrs.get("principal")

    @principal.setter
    def principal(self, principal: "str"):
        """Sets the principal of this GroupMember.


        :param principal: The principal of this GroupMember.
        :type: str
        """
        if principal is None:
            raise ValueError("Invalid value for `principal`, must not be `None`")
        self._attrs["principal"] = principal

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this GroupMember.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this GroupMember.


        :param tenant: The tenant of this GroupMember.
        :type: str
        """
        if tenant is None:
            raise ValueError("Invalid value for `tenant`, must not be `None`")
        self._attrs["tenant"] = tenant

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupRole(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupRole":
        instance = GroupRole.__new__(GroupRole)
        instance._attrs = model
        return instance

    def __init__(self, added_at: "datetime", added_by: "str", group: "str", role: "str", tenant: "str", **extra):
        """GroupRole"""

        self._attrs = dict()
        if added_at is not None:
            self._attrs["addedAt"] = added_at
        if added_by is not None:
            self._attrs["addedBy"] = added_by
        if group is not None:
            self._attrs["group"] = group
        if role is not None:
            self._attrs["role"] = role
        if tenant is not None:
            self._attrs["tenant"] = tenant
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def added_at(self) -> "datetime":
        """ Gets the added_at of this GroupRole.
        """
        return self._attrs.get("addedAt")

    @added_at.setter
    def added_at(self, added_at: "datetime"):
        """Sets the added_at of this GroupRole.


        :param added_at: The added_at of this GroupRole.
        :type: datetime
        """
        if added_at is None:
            raise ValueError("Invalid value for `added_at`, must not be `None`")
        self._attrs["addedAt"] = added_at

    @property
    def added_by(self) -> "str":
        """ Gets the added_by of this GroupRole.
        """
        return self._attrs.get("addedBy")

    @added_by.setter
    def added_by(self, added_by: "str"):
        """Sets the added_by of this GroupRole.


        :param added_by: The added_by of this GroupRole.
        :type: str
        """
        if added_by is None:
            raise ValueError("Invalid value for `added_by`, must not be `None`")
        self._attrs["addedBy"] = added_by

    @property
    def group(self) -> "str":
        """ Gets the group of this GroupRole.
        """
        return self._attrs.get("group")

    @group.setter
    def group(self, group: "str"):
        """Sets the group of this GroupRole.


        :param group: The group of this GroupRole.
        :type: str
        """
        if group is None:
            raise ValueError("Invalid value for `group`, must not be `None`")
        self._attrs["group"] = group

    @property
    def role(self) -> "str":
        """ Gets the role of this GroupRole.
        """
        return self._attrs.get("role")

    @role.setter
    def role(self, role: "str"):
        """Sets the role of this GroupRole.


        :param role: The role of this GroupRole.
        :type: str
        """
        if role is None:
            raise ValueError("Invalid value for `role`, must not be `None`")
        self._attrs["role"] = role

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this GroupRole.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this GroupRole.


        :param tenant: The tenant of this GroupRole.
        :type: str
        """
        if tenant is None:
            raise ValueError("Invalid value for `tenant`, must not be `None`")
        self._attrs["tenant"] = tenant

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MethodEnum(str, Enum):
    POST = "post"
    REDIRECT = "redirect"

    @staticmethod
    def from_value(value: str):
        if value == "post":
            return MethodEnum.POST
        if value == "redirect":
            return MethodEnum.REDIRECT


class IdentityProviderBodyConfig(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "IdentityProviderBodyConfig":
        instance = IdentityProviderBodyConfig.__new__(IdentityProviderBodyConfig)
        instance._attrs = model
        return instance

    def __init__(self, certificate: "str", email_attribute: "str", entity_descriptor: "str", method: "str", single_sign_on_service_url: "str", first_name_attribute: "str" = None, last_name_attribute: "str" = None, **extra):
        """IdentityProviderBodyConfig"""

        self._attrs = dict()
        if certificate is not None:
            self._attrs["certificate"] = certificate
        if email_attribute is not None:
            self._attrs["email_attribute"] = email_attribute
        if entity_descriptor is not None:
            self._attrs["entity_descriptor"] = entity_descriptor
        if method is not None:
            self._attrs["method"] = method
        if single_sign_on_service_url is not None:
            self._attrs["single_sign_on_service_url"] = single_sign_on_service_url
        if first_name_attribute is not None:
            self._attrs["first_name_attribute"] = first_name_attribute
        if last_name_attribute is not None:
            self._attrs["last_name_attribute"] = last_name_attribute
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def certificate(self) -> "str":
        """ Gets the certificate of this IdentityProviderBodyConfig.
        """
        return self._attrs.get("certificate")

    @certificate.setter
    def certificate(self, certificate: "str"):
        """Sets the certificate of this IdentityProviderBodyConfig.


        :param certificate: The certificate of this IdentityProviderBodyConfig.
        :type: str
        """
        if certificate is None:
            raise ValueError("Invalid value for `certificate`, must not be `None`")
        self._attrs["certificate"] = certificate

    @property
    def email_attribute(self) -> "str":
        """ Gets the email_attribute of this IdentityProviderBodyConfig.
        """
        return self._attrs.get("email_attribute")

    @email_attribute.setter
    def email_attribute(self, email_attribute: "str"):
        """Sets the email_attribute of this IdentityProviderBodyConfig.


        :param email_attribute: The email_attribute of this IdentityProviderBodyConfig.
        :type: str
        """
        if email_attribute is None:
            raise ValueError("Invalid value for `email_attribute`, must not be `None`")
        self._attrs["email_attribute"] = email_attribute

    @property
    def entity_descriptor(self) -> "str":
        """ Gets the entity_descriptor of this IdentityProviderBodyConfig.
        """
        return self._attrs.get("entity_descriptor")

    @entity_descriptor.setter
    def entity_descriptor(self, entity_descriptor: "str"):
        """Sets the entity_descriptor of this IdentityProviderBodyConfig.


        :param entity_descriptor: The entity_descriptor of this IdentityProviderBodyConfig.
        :type: str
        """
        if entity_descriptor is None:
            raise ValueError("Invalid value for `entity_descriptor`, must not be `None`")
        self._attrs["entity_descriptor"] = entity_descriptor

    @property
    def method(self) -> "MethodEnum":
        """ Gets the method of this IdentityProviderBodyConfig.
        """
        return MethodEnum.from_value(self._attrs.get("method"))

    @method.setter
    def method(self, method: "str"):
        """Sets the method of this IdentityProviderBodyConfig.


        :param method: The method of this IdentityProviderBodyConfig.
        :type: str
        """
        if method is None:
            raise ValueError("Invalid value for `method`, must not be `None`")
        if isinstance(method, Enum):
            self._attrs["method"] = method.value
        else:
            self._attrs["method"] = method  # If you supply a string, we presume you know the service will take it.

    @property
    def single_sign_on_service_url(self) -> "str":
        """ Gets the single_sign_on_service_url of this IdentityProviderBodyConfig.
        """
        return self._attrs.get("single_sign_on_service_url")

    @single_sign_on_service_url.setter
    def single_sign_on_service_url(self, single_sign_on_service_url: "str"):
        """Sets the single_sign_on_service_url of this IdentityProviderBodyConfig.


        :param single_sign_on_service_url: The single_sign_on_service_url of this IdentityProviderBodyConfig.
        :type: str
        """
        if single_sign_on_service_url is None:
            raise ValueError("Invalid value for `single_sign_on_service_url`, must not be `None`")
        self._attrs["single_sign_on_service_url"] = single_sign_on_service_url

    @property
    def first_name_attribute(self) -> "str":
        """ Gets the first_name_attribute of this IdentityProviderBodyConfig.
        """
        return self._attrs.get("first_name_attribute")

    @first_name_attribute.setter
    def first_name_attribute(self, first_name_attribute: "str"):
        """Sets the first_name_attribute of this IdentityProviderBodyConfig.


        :param first_name_attribute: The first_name_attribute of this IdentityProviderBodyConfig.
        :type: str
        """
        self._attrs["first_name_attribute"] = first_name_attribute

    @property
    def last_name_attribute(self) -> "str":
        """ Gets the last_name_attribute of this IdentityProviderBodyConfig.
        """
        return self._attrs.get("last_name_attribute")

    @last_name_attribute.setter
    def last_name_attribute(self, last_name_attribute: "str"):
        """Sets the last_name_attribute of this IdentityProviderBodyConfig.


        :param last_name_attribute: The last_name_attribute of this IdentityProviderBodyConfig.
        :type: str
        """
        self._attrs["last_name_attribute"] = last_name_attribute

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    SAML = "saml"

    @staticmethod
    def from_value(value: str):
        if value == "saml":
            return KindEnum.SAML


class IdentityProviderBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "IdentityProviderBody":
        instance = IdentityProviderBody.__new__(IdentityProviderBody)
        instance._attrs = model
        return instance

    def __init__(self, config: "IdentityProviderBodyConfig", id: "str", kind: "str", title: "str", created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, enabled: "bool" = None, **extra):
        """IdentityProviderBody"""

        self._attrs = dict()
        if config is not None:
            self._attrs["config"] = config.to_dict()
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if title is not None:
            self._attrs["title"] = title
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if enabled is not None:
            self._attrs["enabled"] = enabled
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def config(self) -> "IdentityProviderBodyConfig":
        """ Gets the config of this IdentityProviderBody.
        """
        return IdentityProviderBodyConfig._from_dict(self._attrs["config"])

    @config.setter
    def config(self, config: "IdentityProviderBodyConfig"):
        """Sets the config of this IdentityProviderBody.


        :param config: The config of this IdentityProviderBody.
        :type: IdentityProviderBodyConfig
        """
        if config is None:
            raise ValueError("Invalid value for `config`, must not be `None`")
        self._attrs["config"] = config.to_dict()

    @property
    def id(self) -> "str":
        """ Gets the id of this IdentityProviderBody.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this IdentityProviderBody.


        :param id: The id of this IdentityProviderBody.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this IdentityProviderBody.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this IdentityProviderBody.


        :param kind: The kind of this IdentityProviderBody.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def title(self) -> "str":
        """ Gets the title of this IdentityProviderBody.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this IdentityProviderBody.


        :param title: The title of this IdentityProviderBody.
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")
        self._attrs["title"] = title

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this IdentityProviderBody.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this IdentityProviderBody.


        :param created_at: The created_at of this IdentityProviderBody.
        :type: datetime
        """
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this IdentityProviderBody.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this IdentityProviderBody.


        :param created_by: The created_by of this IdentityProviderBody.
        :type: str
        """
        self._attrs["createdBy"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this IdentityProviderBody.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this IdentityProviderBody.


        :param description: The description of this IdentityProviderBody.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def enabled(self) -> "bool":
        """ Gets the enabled of this IdentityProviderBody.
        """
        return self._attrs.get("enabled")

    @enabled.setter
    def enabled(self, enabled: "bool"):
        """Sets the enabled of this IdentityProviderBody.


        :param enabled: The enabled of this IdentityProviderBody.
        :type: bool
        """
        self._attrs["enabled"] = enabled

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MethodEnum(str, Enum):
    POST = "post"
    REDIRECT = "redirect"

    @staticmethod
    def from_value(value: str):
        if value == "post":
            return MethodEnum.POST
        if value == "redirect":
            return MethodEnum.REDIRECT


class IdentityProviderConfigBodyConfig(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "IdentityProviderConfigBodyConfig":
        instance = IdentityProviderConfigBodyConfig.__new__(IdentityProviderConfigBodyConfig)
        instance._attrs = model
        return instance

    def __init__(self, certificate: "str" = None, email_attribute: "str" = None, entity_descriptor: "str" = None, first_name_attribute: "str" = None, last_name_attribute: "str" = None, method: "str" = None, single_sign_on_service_url: "str" = None, **extra):
        """IdentityProviderConfigBodyConfig"""

        self._attrs = dict()
        if certificate is not None:
            self._attrs["certificate"] = certificate
        if email_attribute is not None:
            self._attrs["email_attribute"] = email_attribute
        if entity_descriptor is not None:
            self._attrs["entity_descriptor"] = entity_descriptor
        if first_name_attribute is not None:
            self._attrs["first_name_attribute"] = first_name_attribute
        if last_name_attribute is not None:
            self._attrs["last_name_attribute"] = last_name_attribute
        if method is not None:
            self._attrs["method"] = method
        if single_sign_on_service_url is not None:
            self._attrs["single_sign_on_service_url"] = single_sign_on_service_url
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def certificate(self) -> "str":
        """ Gets the certificate of this IdentityProviderConfigBodyConfig.
        """
        return self._attrs.get("certificate")

    @certificate.setter
    def certificate(self, certificate: "str"):
        """Sets the certificate of this IdentityProviderConfigBodyConfig.


        :param certificate: The certificate of this IdentityProviderConfigBodyConfig.
        :type: str
        """
        self._attrs["certificate"] = certificate

    @property
    def email_attribute(self) -> "str":
        """ Gets the email_attribute of this IdentityProviderConfigBodyConfig.
        """
        return self._attrs.get("email_attribute")

    @email_attribute.setter
    def email_attribute(self, email_attribute: "str"):
        """Sets the email_attribute of this IdentityProviderConfigBodyConfig.


        :param email_attribute: The email_attribute of this IdentityProviderConfigBodyConfig.
        :type: str
        """
        self._attrs["email_attribute"] = email_attribute

    @property
    def entity_descriptor(self) -> "str":
        """ Gets the entity_descriptor of this IdentityProviderConfigBodyConfig.
        """
        return self._attrs.get("entity_descriptor")

    @entity_descriptor.setter
    def entity_descriptor(self, entity_descriptor: "str"):
        """Sets the entity_descriptor of this IdentityProviderConfigBodyConfig.


        :param entity_descriptor: The entity_descriptor of this IdentityProviderConfigBodyConfig.
        :type: str
        """
        self._attrs["entity_descriptor"] = entity_descriptor

    @property
    def first_name_attribute(self) -> "str":
        """ Gets the first_name_attribute of this IdentityProviderConfigBodyConfig.
        """
        return self._attrs.get("first_name_attribute")

    @first_name_attribute.setter
    def first_name_attribute(self, first_name_attribute: "str"):
        """Sets the first_name_attribute of this IdentityProviderConfigBodyConfig.


        :param first_name_attribute: The first_name_attribute of this IdentityProviderConfigBodyConfig.
        :type: str
        """
        self._attrs["first_name_attribute"] = first_name_attribute

    @property
    def last_name_attribute(self) -> "str":
        """ Gets the last_name_attribute of this IdentityProviderConfigBodyConfig.
        """
        return self._attrs.get("last_name_attribute")

    @last_name_attribute.setter
    def last_name_attribute(self, last_name_attribute: "str"):
        """Sets the last_name_attribute of this IdentityProviderConfigBodyConfig.


        :param last_name_attribute: The last_name_attribute of this IdentityProviderConfigBodyConfig.
        :type: str
        """
        self._attrs["last_name_attribute"] = last_name_attribute

    @property
    def method(self) -> "MethodEnum":
        """ Gets the method of this IdentityProviderConfigBodyConfig.
        """
        return MethodEnum.from_value(self._attrs.get("method"))

    @method.setter
    def method(self, method: "str"):
        """Sets the method of this IdentityProviderConfigBodyConfig.


        :param method: The method of this IdentityProviderConfigBodyConfig.
        :type: str
        """
        if isinstance(method, Enum):
            self._attrs["method"] = method.value
        else:
            self._attrs["method"] = method  # If you supply a string, we presume you know the service will take it.

    @property
    def single_sign_on_service_url(self) -> "str":
        """ Gets the single_sign_on_service_url of this IdentityProviderConfigBodyConfig.
        """
        return self._attrs.get("single_sign_on_service_url")

    @single_sign_on_service_url.setter
    def single_sign_on_service_url(self, single_sign_on_service_url: "str"):
        """Sets the single_sign_on_service_url of this IdentityProviderConfigBodyConfig.


        :param single_sign_on_service_url: The single_sign_on_service_url of this IdentityProviderConfigBodyConfig.
        :type: str
        """
        self._attrs["single_sign_on_service_url"] = single_sign_on_service_url

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    SAML = "saml"

    @staticmethod
    def from_value(value: str):
        if value == "saml":
            return KindEnum.SAML


class IdentityProviderConfigBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "IdentityProviderConfigBody":
        instance = IdentityProviderConfigBody.__new__(IdentityProviderConfigBody)
        instance._attrs = model
        return instance

    def __init__(self, config: "IdentityProviderConfigBodyConfig", id: "str", kind: "str", description: "str" = None, enabled: "bool" = None, title: "str" = None, **extra):
        """IdentityProviderConfigBody"""

        self._attrs = dict()
        if config is not None:
            self._attrs["config"] = config.to_dict()
        if id is not None:
            self._attrs["id"] = id
        if kind is not None:
            self._attrs["kind"] = kind
        if description is not None:
            self._attrs["description"] = description
        if enabled is not None:
            self._attrs["enabled"] = enabled
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def config(self) -> "IdentityProviderConfigBodyConfig":
        """ Gets the config of this IdentityProviderConfigBody.
        """
        return IdentityProviderConfigBodyConfig._from_dict(self._attrs["config"])

    @config.setter
    def config(self, config: "IdentityProviderConfigBodyConfig"):
        """Sets the config of this IdentityProviderConfigBody.


        :param config: The config of this IdentityProviderConfigBody.
        :type: IdentityProviderConfigBodyConfig
        """
        if config is None:
            raise ValueError("Invalid value for `config`, must not be `None`")
        self._attrs["config"] = config.to_dict()

    @property
    def id(self) -> "str":
        """ Gets the id of this IdentityProviderConfigBody.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this IdentityProviderConfigBody.


        :param id: The id of this IdentityProviderConfigBody.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this IdentityProviderConfigBody.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this IdentityProviderConfigBody.


        :param kind: The kind of this IdentityProviderConfigBody.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def description(self) -> "str":
        """ Gets the description of this IdentityProviderConfigBody.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this IdentityProviderConfigBody.


        :param description: The description of this IdentityProviderConfigBody.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def enabled(self) -> "bool":
        """ Gets the enabled of this IdentityProviderConfigBody.
        """
        return self._attrs.get("enabled")

    @enabled.setter
    def enabled(self, enabled: "bool"):
        """Sets the enabled of this IdentityProviderConfigBody.


        :param enabled: The enabled of this IdentityProviderConfigBody.
        :type: bool
        """
        self._attrs["enabled"] = enabled

    @property
    def title(self) -> "str":
        """ Gets the title of this IdentityProviderConfigBody.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this IdentityProviderConfigBody.


        :param title: The title of this IdentityProviderConfigBody.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PrincipalProfile(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PrincipalProfile":
        instance = PrincipalProfile.__new__(PrincipalProfile)
        instance._attrs = model
        return instance

    def __init__(self, email: "str" = None, first_name: "str" = None, full_name: "str" = None, last_name: "str" = None, **extra):
        """PrincipalProfile"""

        self._attrs = dict()
        if email is not None:
            self._attrs["email"] = email
        if first_name is not None:
            self._attrs["firstName"] = first_name
        if full_name is not None:
            self._attrs["fullName"] = full_name
        if last_name is not None:
            self._attrs["lastName"] = last_name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def email(self) -> "str":
        """ Gets the email of this PrincipalProfile.
        """
        return self._attrs.get("email")

    @email.setter
    def email(self, email: "str"):
        """Sets the email of this PrincipalProfile.


        :param email: The email of this PrincipalProfile.
        :type: str
        """
        self._attrs["email"] = email

    @property
    def first_name(self) -> "str":
        """ Gets the first_name of this PrincipalProfile.
        """
        return self._attrs.get("firstName")

    @first_name.setter
    def first_name(self, first_name: "str"):
        """Sets the first_name of this PrincipalProfile.


        :param first_name: The first_name of this PrincipalProfile.
        :type: str
        """
        self._attrs["firstName"] = first_name

    @property
    def full_name(self) -> "str":
        """ Gets the full_name of this PrincipalProfile.
        """
        return self._attrs.get("fullName")

    @full_name.setter
    def full_name(self, full_name: "str"):
        """Sets the full_name of this PrincipalProfile.


        :param full_name: The full_name of this PrincipalProfile.
        :type: str
        """
        self._attrs["fullName"] = full_name

    @property
    def last_name(self) -> "str":
        """ Gets the last_name of this PrincipalProfile.
        """
        return self._attrs.get("lastName")

    @last_name.setter
    def last_name(self, last_name: "str"):
        """Sets the last_name of this PrincipalProfile.


        :param last_name: The last_name of this PrincipalProfile.
        :type: str
        """
        self._attrs["lastName"] = last_name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Member(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Member":
        instance = Member.__new__(Member)
        instance._attrs = model
        return instance

    def __init__(self, added_at: "datetime", added_by: "str", group_count: "int", name: "str", tenant: "str", expires_at: "datetime" = None, profile: "PrincipalProfile" = None, visible: "bool" = None, **extra):
        """Member"""

        self._attrs = dict()
        if added_at is not None:
            self._attrs["addedAt"] = added_at
        if added_by is not None:
            self._attrs["addedBy"] = added_by
        if group_count is not None:
            self._attrs["groupCount"] = group_count
        if name is not None:
            self._attrs["name"] = name
        if tenant is not None:
            self._attrs["tenant"] = tenant
        if expires_at is not None:
            self._attrs["expiresAt"] = expires_at
        if profile is not None:
            self._attrs["profile"] = profile.to_dict()
        if visible is not None:
            self._attrs["visible"] = visible
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def added_at(self) -> "datetime":
        """ Gets the added_at of this Member.
        When the principal was added to the tenant.
        """
        return self._attrs.get("addedAt")

    @added_at.setter
    def added_at(self, added_at: "datetime"):
        """Sets the added_at of this Member.

        When the principal was added to the tenant.

        :param added_at: The added_at of this Member.
        :type: datetime
        """
        if added_at is None:
            raise ValueError("Invalid value for `added_at`, must not be `None`")
        self._attrs["addedAt"] = added_at

    @property
    def added_by(self) -> "str":
        """ Gets the added_by of this Member.
        """
        return self._attrs.get("addedBy")

    @added_by.setter
    def added_by(self, added_by: "str"):
        """Sets the added_by of this Member.


        :param added_by: The added_by of this Member.
        :type: str
        """
        if added_by is None:
            raise ValueError("Invalid value for `added_by`, must not be `None`")
        self._attrs["addedBy"] = added_by

    @property
    def group_count(self) -> "int":
        """ Gets the group_count of this Member.
        """
        return self._attrs.get("groupCount")

    @group_count.setter
    def group_count(self, group_count: "int"):
        """Sets the group_count of this Member.


        :param group_count: The group_count of this Member.
        :type: int
        """
        if group_count is None:
            raise ValueError("Invalid value for `group_count`, must not be `None`")
        self._attrs["groupCount"] = group_count

    @property
    def name(self) -> "str":
        """ Gets the name of this Member.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Member.


        :param name: The name of this Member.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this Member.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this Member.


        :param tenant: The tenant of this Member.
        :type: str
        """
        if tenant is None:
            raise ValueError("Invalid value for `tenant`, must not be `None`")
        self._attrs["tenant"] = tenant

    @property
    def expires_at(self) -> "datetime":
        """ Gets the expires_at of this Member.
        """
        return self._attrs.get("expiresAt")

    @expires_at.setter
    def expires_at(self, expires_at: "datetime"):
        """Sets the expires_at of this Member.


        :param expires_at: The expires_at of this Member.
        :type: datetime
        """
        self._attrs["expiresAt"] = expires_at

    @property
    def profile(self) -> "PrincipalProfile":
        """ Gets the profile of this Member.
        """
        return PrincipalProfile._from_dict(self._attrs["profile"])

    @profile.setter
    def profile(self, profile: "PrincipalProfile"):
        """Sets the profile of this Member.


        :param profile: The profile of this Member.
        :type: PrincipalProfile
        """
        self._attrs["profile"] = profile.to_dict()

    @property
    def visible(self) -> "bool":
        """ Gets the visible of this Member.
        """
        return self._attrs.get("visible")

    @visible.setter
    def visible(self, visible: "bool"):
        """Sets the visible of this Member.


        :param visible: The visible of this Member.
        :type: bool
        """
        self._attrs["visible"] = visible

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PermissionString(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PermissionString":
        instance = PermissionString.__new__(PermissionString)
        instance._attrs = model
        return instance

    def __init__(self, **extra):
        """PermissionString"""

        self._attrs = dict()
        for k, v in extra.items():
            self._attrs[k] = v

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Principal(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Principal":
        instance = Principal.__new__(Principal)
        instance._attrs = model
        return instance

    def __init__(self, created_at: "datetime", created_by: "str", kind: "PrincipalKind", name: "str", tenants: "List[str]", updated_at: "datetime", updated_by: "str", profile: "PrincipalProfile" = None, **extra):
        """Principal"""

        self._attrs = dict()
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if kind is not None:
            self._attrs["kind"] = kind
        if name is not None:
            self._attrs["name"] = name
        if tenants is not None:
            self._attrs["tenants"] = tenants
        if updated_at is not None:
            self._attrs["updatedAt"] = updated_at
        if updated_by is not None:
            self._attrs["updatedBy"] = updated_by
        if profile is not None:
            self._attrs["profile"] = profile.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this Principal.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this Principal.


        :param created_at: The created_at of this Principal.
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this Principal.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this Principal.


        :param created_by: The created_by of this Principal.
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")
        self._attrs["createdBy"] = created_by

    @property
    def kind(self) -> "PrincipalKind":
        """ Gets the kind of this Principal.
        """
        return PrincipalKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "PrincipalKind"):
        """Sets the kind of this Principal.


        :param kind: The kind of this Principal.
        :type: PrincipalKind
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def name(self) -> "str":
        """ Gets the name of this Principal.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Principal.


        :param name: The name of this Principal.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def tenants(self) -> "List[str]":
        """ Gets the tenants of this Principal.
        """
        return self._attrs.get("tenants")

    @tenants.setter
    def tenants(self, tenants: "List[str]"):
        """Sets the tenants of this Principal.


        :param tenants: The tenants of this Principal.
        :type: List[str]
        """
        if tenants is None:
            raise ValueError("Invalid value for `tenants`, must not be `None`")
        self._attrs["tenants"] = tenants

    @property
    def updated_at(self) -> "datetime":
        """ Gets the updated_at of this Principal.
        """
        return self._attrs.get("updatedAt")

    @updated_at.setter
    def updated_at(self, updated_at: "datetime"):
        """Sets the updated_at of this Principal.


        :param updated_at: The updated_at of this Principal.
        :type: datetime
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")
        self._attrs["updatedAt"] = updated_at

    @property
    def updated_by(self) -> "str":
        """ Gets the updated_by of this Principal.
        """
        return self._attrs.get("updatedBy")

    @updated_by.setter
    def updated_by(self, updated_by: "str"):
        """Sets the updated_by of this Principal.


        :param updated_by: The updated_by of this Principal.
        :type: str
        """
        if updated_by is None:
            raise ValueError("Invalid value for `updated_by`, must not be `None`")
        self._attrs["updatedBy"] = updated_by

    @property
    def profile(self) -> "PrincipalProfile":
        """ Gets the profile of this Principal.
        """
        return PrincipalProfile._from_dict(self._attrs["profile"])

    @profile.setter
    def profile(self, profile: "PrincipalProfile"):
        """Sets the profile of this Principal.


        :param profile: The profile of this Principal.
        :type: PrincipalProfile
        """
        self._attrs["profile"] = profile.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    ACTIVE = "active"
    INACTIVE = "inactive"
    DELETED = "deleted"

    @staticmethod
    def from_value(value: str):
        if value == "active":
            return StatusEnum.ACTIVE
        if value == "inactive":
            return StatusEnum.INACTIVE
        if value == "deleted":
            return StatusEnum.DELETED


class PrincipalPublicKey(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PrincipalPublicKey":
        instance = PrincipalPublicKey.__new__(PrincipalPublicKey)
        instance._attrs = model
        return instance

    def __init__(self, created_at: "datetime", created_by: "str", key: "ECJwk", status: "str", updated_at: "datetime", updated_by: "str", **extra):
        """PrincipalPublicKey"""

        self._attrs = dict()
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if key is not None:
            self._attrs["key"] = key.to_dict()
        if status is not None:
            self._attrs["status"] = status
        if updated_at is not None:
            self._attrs["updatedAt"] = updated_at
        if updated_by is not None:
            self._attrs["updatedBy"] = updated_by
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this PrincipalPublicKey.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this PrincipalPublicKey.


        :param created_at: The created_at of this PrincipalPublicKey.
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this PrincipalPublicKey.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this PrincipalPublicKey.


        :param created_by: The created_by of this PrincipalPublicKey.
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")
        self._attrs["createdBy"] = created_by

    @property
    def key(self) -> "ECJwk":
        """ Gets the key of this PrincipalPublicKey.
        """
        return ECJwk._from_dict(self._attrs["key"])

    @key.setter
    def key(self, key: "ECJwk"):
        """Sets the key of this PrincipalPublicKey.


        :param key: The key of this PrincipalPublicKey.
        :type: ECJwk
        """
        if key is None:
            raise ValueError("Invalid value for `key`, must not be `None`")
        self._attrs["key"] = key.to_dict()

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this PrincipalPublicKey.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this PrincipalPublicKey.


        :param status: The status of this PrincipalPublicKey.
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    @property
    def updated_at(self) -> "datetime":
        """ Gets the updated_at of this PrincipalPublicKey.
        """
        return self._attrs.get("updatedAt")

    @updated_at.setter
    def updated_at(self, updated_at: "datetime"):
        """Sets the updated_at of this PrincipalPublicKey.


        :param updated_at: The updated_at of this PrincipalPublicKey.
        :type: datetime
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")
        self._attrs["updatedAt"] = updated_at

    @property
    def updated_by(self) -> "str":
        """ Gets the updated_by of this PrincipalPublicKey.
        """
        return self._attrs.get("updatedBy")

    @updated_by.setter
    def updated_by(self, updated_by: "str"):
        """Sets the updated_by of this PrincipalPublicKey.


        :param updated_by: The updated_by of this PrincipalPublicKey.
        :type: str
        """
        if updated_by is None:
            raise ValueError("Invalid value for `updated_by`, must not be `None`")
        self._attrs["updatedBy"] = updated_by

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    ACTIVE = "active"
    INACTIVE = "inactive"

    @staticmethod
    def from_value(value: str):
        if value == "active":
            return StatusEnum.ACTIVE
        if value == "inactive":
            return StatusEnum.INACTIVE


class PrincipalPublicKeyStatusBody(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PrincipalPublicKeyStatusBody":
        instance = PrincipalPublicKeyStatusBody.__new__(PrincipalPublicKeyStatusBody)
        instance._attrs = model
        return instance

    def __init__(self, status: "str", **extra):
        """PrincipalPublicKeyStatusBody"""

        self._attrs = dict()
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this PrincipalPublicKeyStatusBody.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this PrincipalPublicKeyStatusBody.


        :param status: The status of this PrincipalPublicKeyStatusBody.
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Role(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Role":
        instance = Role.__new__(Role)
        instance._attrs = model
        return instance

    def __init__(self, created_at: "datetime", created_by: "str", name: "str", tenant: "str", permissions: "List[str]" = None, **extra):
        """Role"""

        self._attrs = dict()
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if name is not None:
            self._attrs["name"] = name
        if tenant is not None:
            self._attrs["tenant"] = tenant
        if permissions is not None:
            self._attrs["permissions"] = permissions
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this Role.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this Role.


        :param created_at: The created_at of this Role.
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this Role.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this Role.


        :param created_by: The created_by of this Role.
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")
        self._attrs["createdBy"] = created_by

    @property
    def name(self) -> "str":
        """ Gets the name of this Role.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Role.


        :param name: The name of this Role.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this Role.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this Role.


        :param tenant: The tenant of this Role.
        :type: str
        """
        if tenant is None:
            raise ValueError("Invalid value for `tenant`, must not be `None`")
        self._attrs["tenant"] = tenant

    @property
    def permissions(self) -> "List[str]":
        """ Gets the permissions of this Role.
        """
        return self._attrs.get("permissions")

    @permissions.setter
    def permissions(self, permissions: "List[str]"):
        """Sets the permissions of this Role.


        :param permissions: The permissions of this Role.
        :type: List[str]
        """
        self._attrs["permissions"] = permissions

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RolePermission(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RolePermission":
        instance = RolePermission.__new__(RolePermission)
        instance._attrs = model
        return instance

    def __init__(self, added_at: "datetime", added_by: "str", permission: "str", role: "str", tenant: "str", **extra):
        """RolePermission"""

        self._attrs = dict()
        if added_at is not None:
            self._attrs["addedAt"] = added_at
        if added_by is not None:
            self._attrs["addedBy"] = added_by
        if permission is not None:
            self._attrs["permission"] = permission
        if role is not None:
            self._attrs["role"] = role
        if tenant is not None:
            self._attrs["tenant"] = tenant
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def added_at(self) -> "datetime":
        """ Gets the added_at of this RolePermission.
        """
        return self._attrs.get("addedAt")

    @added_at.setter
    def added_at(self, added_at: "datetime"):
        """Sets the added_at of this RolePermission.


        :param added_at: The added_at of this RolePermission.
        :type: datetime
        """
        if added_at is None:
            raise ValueError("Invalid value for `added_at`, must not be `None`")
        self._attrs["addedAt"] = added_at

    @property
    def added_by(self) -> "str":
        """ Gets the added_by of this RolePermission.
        """
        return self._attrs.get("addedBy")

    @added_by.setter
    def added_by(self, added_by: "str"):
        """Sets the added_by of this RolePermission.


        :param added_by: The added_by of this RolePermission.
        :type: str
        """
        if added_by is None:
            raise ValueError("Invalid value for `added_by`, must not be `None`")
        self._attrs["addedBy"] = added_by

    @property
    def permission(self) -> "str":
        """ Gets the permission of this RolePermission.
        """
        return self._attrs.get("permission")

    @permission.setter
    def permission(self, permission: "str"):
        """Sets the permission of this RolePermission.


        :param permission: The permission of this RolePermission.
        :type: str
        """
        if permission is None:
            raise ValueError("Invalid value for `permission`, must not be `None`")
        self._attrs["permission"] = permission

    @property
    def role(self) -> "str":
        """ Gets the role of this RolePermission.
        """
        return self._attrs.get("role")

    @role.setter
    def role(self, role: "str"):
        """Sets the role of this RolePermission.


        :param role: The role of this RolePermission.
        :type: str
        """
        if role is None:
            raise ValueError("Invalid value for `role`, must not be `None`")
        self._attrs["role"] = role

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this RolePermission.
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this RolePermission.


        :param tenant: The tenant of this RolePermission.
        :type: str
        """
        if tenant is None:
            raise ValueError("Invalid value for `tenant`, must not be `None`")
        self._attrs["tenant"] = tenant

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TenantStatus(str, Enum):
    PROVISIONING = "provisioning"
    FAILED = "failed"
    READY = "ready"
    DELETING = "deleting"
    DELETED = "deleted"
    TOMBSTONED = "tombstoned"
    SUSPENDED = "suspended"

    @staticmethod
    def from_value(value: str):
        if value == "provisioning":
            return TenantStatus.PROVISIONING
        if value == "failed":
            return TenantStatus.FAILED
        if value == "ready":
            return TenantStatus.READY
        if value == "deleting":
            return TenantStatus.DELETING
        if value == "deleted":
            return TenantStatus.DELETED
        if value == "tombstoned":
            return TenantStatus.TOMBSTONED
        if value == "suspended":
            return TenantStatus.SUSPENDED


class Tenant(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Tenant":
        instance = Tenant.__new__(Tenant)
        instance._attrs = model
        return instance

    def __init__(self, created_at: "datetime", created_by: "str", name: "str", status: "TenantStatus", **extra):
        """Tenant"""

        self._attrs = dict()
        if created_at is not None:
            self._attrs["createdAt"] = created_at
        if created_by is not None:
            self._attrs["createdBy"] = created_by
        if name is not None:
            self._attrs["name"] = name
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this Tenant.
        """
        return self._attrs.get("createdAt")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this Tenant.


        :param created_at: The created_at of this Tenant.
        :type: datetime
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")
        self._attrs["createdAt"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this Tenant.
        """
        return self._attrs.get("createdBy")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this Tenant.


        :param created_by: The created_by of this Tenant.
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")
        self._attrs["createdBy"] = created_by

    @property
    def name(self) -> "str":
        """ Gets the name of this Tenant.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Tenant.


        :param name: The name of this Tenant.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def status(self) -> "TenantStatus":
        """ Gets the status of this Tenant.
        """
        return TenantStatus.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "TenantStatus"):
        """Sets the status of this Tenant.


        :param status: The status of this Tenant.
        :type: TenantStatus
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    PRINCIPAL = "principal"
    API_KEY = "api_key"

    @staticmethod
    def from_value(value: str):
        if value == "principal":
            return KindEnum.PRINCIPAL
        if value == "api_key":
            return KindEnum.API_KEY


class ValidateInfo(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ValidateInfo":
        instance = ValidateInfo.__new__(ValidateInfo)
        instance._attrs = model
        return instance

    def __init__(self, client_id: "str", kind: "str", name: "str", principal: "Principal" = None, tenant: "Tenant" = None, **extra):
        """ValidateInfo"""

        self._attrs = dict()
        if client_id is not None:
            self._attrs["clientId"] = client_id
        if kind is not None:
            self._attrs["kind"] = kind
        if name is not None:
            self._attrs["name"] = name
        if principal is not None:
            self._attrs["principal"] = principal.to_dict()
        if tenant is not None:
            self._attrs["tenant"] = tenant.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def client_id(self) -> "str":
        """ Gets the client_id of this ValidateInfo.
        """
        return self._attrs.get("clientId")

    @client_id.setter
    def client_id(self, client_id: "str"):
        """Sets the client_id of this ValidateInfo.


        :param client_id: The client_id of this ValidateInfo.
        :type: str
        """
        if client_id is None:
            raise ValueError("Invalid value for `client_id`, must not be `None`")
        self._attrs["clientId"] = client_id

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this ValidateInfo.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this ValidateInfo.


        :param kind: The kind of this ValidateInfo.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def name(self) -> "str":
        """ Gets the name of this ValidateInfo.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ValidateInfo.


        :param name: The name of this ValidateInfo.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def principal(self) -> "Principal":
        """ Gets the principal of this ValidateInfo.
        """
        return Principal._from_dict(self._attrs["principal"])

    @principal.setter
    def principal(self, principal: "Principal"):
        """Sets the principal of this ValidateInfo.


        :param principal: The principal of this ValidateInfo.
        :type: Principal
        """
        self._attrs["principal"] = principal.to_dict()

    @property
    def tenant(self) -> "Tenant":
        """ Gets the tenant of this ValidateInfo.
        """
        return Tenant._from_dict(self._attrs["tenant"])

    @tenant.setter
    def tenant(self, tenant: "Tenant"):
        """Sets the tenant of this ValidateInfo.


        :param tenant: The tenant of this ValidateInfo.
        :type: Tenant
        """
        self._attrs["tenant"] = tenant.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
