# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Ingest API

    Use the Ingest service in Splunk Cloud Services to send event and metrics data, or upload a static file, to Splunk Cloud Services.

    OpenAPI spec version: v1beta2.32 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class Error(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Error":
        instance = Error.__new__(Error)
        instance._attrs = model
        return instance

    def __init__(self, code: "str" = None, details: "object" = None, message: "str" = None, **extra):
        """Error"""

        self._attrs = dict()
        if code is not None:
            self._attrs["code"] = code
        if details is not None:
            self._attrs["details"] = details
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def code(self) -> "str":
        """ Gets the code of this Error.
        """
        return self._attrs.get("code")

    @code.setter
    def code(self, code: "str"):
        """Sets the code of this Error.


        :param code: The code of this Error.
        :type: str
        """
        self._attrs["code"] = code

    @property
    def details(self) -> "dict":
        """ Gets the details of this Error.
        """
        return self._attrs.get("details")

    @details.setter
    def details(self, details: "dict"):
        """Sets the details of this Error.


        :param details: The details of this Error.
        :type: object
        """
        self._attrs["details"] = details

    @property
    def message(self) -> "str":
        """ Gets the message of this Error.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this Error.


        :param message: The message of this Error.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Event(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Event":
        instance = Event.__new__(Event)
        instance._attrs = model
        return instance

    def __init__(self, body: "object", attributes: "Dict[str, object]" = None, host: "str" = None, id: "str" = None, nanos: "int" = None, source: "str" = None, sourcetype: "str" = None, timestamp: "int" = None, **extra):
        """Event"""

        self._attrs = dict()
        if body is not None:
            self._attrs["body"] = body
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if host is not None:
            self._attrs["host"] = host
        if id is not None:
            self._attrs["id"] = id
        if nanos is not None:
            self._attrs["nanos"] = nanos
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        if timestamp is not None:
            self._attrs["timestamp"] = timestamp
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def body(self) -> "object":
        """ Gets the body of this Event.
        The raw event content. It can be a string, number, string array, number array, JSON object, map, list, a JSON array, or a byte array.
        """
        return self._attrs.get("body")

    @body.setter
    def body(self, body: "object"):
        """Sets the body of this Event.

        The raw event content. It can be a string, number, string array, number array, JSON object, map, list, a JSON array, or a byte array.

        :param body: The body of this Event.
        :type: object
        """
        if body is None:
            raise ValueError("Invalid value for `body`, must not be `None`")
        self._attrs["body"] = body

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this Event.
        Specifies a JSON object that contains explicit custom fields to be defined at index time.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this Event.

        Specifies a JSON object that contains explicit custom fields to be defined at index time.

        :param attributes: The attributes of this Event.
        :type: Dict[str, object]
        """
        self._attrs["attributes"] = attributes

    @property
    def host(self) -> "str":
        """ Gets the host of this Event.
        The host value assigned to the event data. Typically, this is the hostname of the client from which you are sending data.
        """
        return self._attrs.get("host")

    @host.setter
    def host(self, host: "str"):
        """Sets the host of this Event.

        The host value assigned to the event data. Typically, this is the hostname of the client from which you are sending data.

        :param host: The host of this Event.
        :type: str
        """
        self._attrs["host"] = host

    @property
    def id(self) -> "str":
        """ Gets the id of this Event.
        An optional ID that uniquely identifies the event data. It is used to deduplicate the data if same data is set multiple times. If ID is not specified, it will be assigned by the system.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Event.

        An optional ID that uniquely identifies the event data. It is used to deduplicate the data if same data is set multiple times. If ID is not specified, it will be assigned by the system.

        :param id: The id of this Event.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def nanos(self) -> "int":
        """ Gets the nanos of this Event.
        Optional nanoseconds part of the timestamp.
        """
        return self._attrs.get("nanos")

    @nanos.setter
    def nanos(self, nanos: "int"):
        """Sets the nanos of this Event.

        Optional nanoseconds part of the timestamp.

        :param nanos: The nanos of this Event.
        :type: int
        """
        self._attrs["nanos"] = nanos

    @property
    def source(self) -> "str":
        """ Gets the source of this Event.
        The source value to assign to the event data. For example, if you are sending data from an app that you are developing, set this key to the name of the app.
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this Event.

        The source value to assign to the event data. For example, if you are sending data from an app that you are developing, set this key to the name of the app.

        :param source: The source of this Event.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this Event.
        The sourcetype value assigned to the event data.
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this Event.

        The sourcetype value assigned to the event data.

        :param sourcetype: The sourcetype of this Event.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    @property
    def timestamp(self) -> "int":
        """ Gets the timestamp of this Event.
        Epoch time in milliseconds.
        """
        return self._attrs.get("timestamp")

    @timestamp.setter
    def timestamp(self, timestamp: "int"):
        """Sets the timestamp of this Event.

        Epoch time in milliseconds.

        :param timestamp: The timestamp of this Event.
        :type: int
        """
        self._attrs["timestamp"] = timestamp

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FileUploadDetails(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FileUploadDetails":
        instance = FileUploadDetails.__new__(FileUploadDetails)
        instance._attrs = model
        return instance

    def __init__(self, filename: "str" = None, **extra):
        """FileUploadDetails"""

        self._attrs = dict()
        if filename is not None:
            self._attrs["filename"] = filename
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def filename(self) -> "str":
        """ Gets the filename of this FileUploadDetails.
        """
        return self._attrs.get("filename")

    @filename.setter
    def filename(self, filename: "str"):
        """Sets the filename of this FileUploadDetails.


        :param filename: The filename of this FileUploadDetails.
        :type: str
        """
        self._attrs["filename"] = filename

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class HECTokenAccessResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "HECTokenAccessResponse":
        instance = HECTokenAccessResponse.__new__(HECTokenAccessResponse)
        instance._attrs = model
        return instance

    def __init__(self, ack_enabled: "bool" = None, allow_query_string_auth: "bool" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, disabled: "bool" = None, index: "str" = None, indexes: "List[str]" = None, last_modified_at: "datetime" = None, last_modified_by: "str" = None, name: "str" = None, source: "str" = None, sourcetype: "str" = None, tenant: "str" = None, **extra):
        """HECTokenAccessResponse"""

        self._attrs = dict()
        if ack_enabled is not None:
            self._attrs["ack_enabled"] = ack_enabled
        if allow_query_string_auth is not None:
            self._attrs["allow_query_string_auth"] = allow_query_string_auth
        if created_at is not None:
            self._attrs["created_at"] = created_at
        if created_by is not None:
            self._attrs["created_by"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if index is not None:
            self._attrs["index"] = index
        if indexes is not None:
            self._attrs["indexes"] = indexes
        if last_modified_at is not None:
            self._attrs["last_modified_at"] = last_modified_at
        if last_modified_by is not None:
            self._attrs["last_modified_by"] = last_modified_by
        if name is not None:
            self._attrs["name"] = name
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        if tenant is not None:
            self._attrs["tenant"] = tenant
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def ack_enabled(self) -> "bool":
        """ Gets the ack_enabled of this HECTokenAccessResponse.
        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: bool
        """
        return self._attrs.get("ack_enabled")

    @ack_enabled.setter
    def ack_enabled(self, ack_enabled: "bool"):
        """Sets the ack_enabled of this HECTokenAccessResponse.

        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: bool

        :param ack_enabled: The ack_enabled of this HECTokenAccessResponse.
        :type: bool
        """
        self._attrs["ack_enabled"] = ack_enabled

    @property
    def allow_query_string_auth(self) -> "bool":
        """ Gets the allow_query_string_auth of this HECTokenAccessResponse.
        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: bool
        """
        return self._attrs.get("allow_query_string_auth")

    @allow_query_string_auth.setter
    def allow_query_string_auth(self, allow_query_string_auth: "bool"):
        """Sets the allow_query_string_auth of this HECTokenAccessResponse.

        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: bool

        :param allow_query_string_auth: The allow_query_string_auth of this HECTokenAccessResponse.
        :type: bool
        """
        self._attrs["allow_query_string_auth"] = allow_query_string_auth

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this HECTokenAccessResponse.
        created_at is a timestamp that captures when this token was created.  type: string format: date-time
        """
        return self._attrs.get("created_at")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this HECTokenAccessResponse.

        created_at is a timestamp that captures when this token was created.  type: string format: date-time

        :param created_at: The created_at of this HECTokenAccessResponse.
        :type: datetime
        """
        self._attrs["created_at"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this HECTokenAccessResponse.
        created_by is the principal that created the token.  type: string
        """
        return self._attrs.get("created_by")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this HECTokenAccessResponse.

        created_by is the principal that created the token.  type: string

        :param created_by: The created_by of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["created_by"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this HECTokenAccessResponse.
        description is an optional description of the token.  type: string
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this HECTokenAccessResponse.

        description is an optional description of the token.  type: string

        :param description: The description of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this HECTokenAccessResponse.
        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: bool
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this HECTokenAccessResponse.

        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: bool

        :param disabled: The disabled of this HECTokenAccessResponse.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def index(self) -> "str":
        """ Gets the index of this HECTokenAccessResponse.
        index is the default value of the index field for records collected using this token.  type: string
        """
        return self._attrs.get("index")

    @index.setter
    def index(self, index: "str"):
        """Sets the index of this HECTokenAccessResponse.

        index is the default value of the index field for records collected using this token.  type: string

        :param index: The index of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["index"] = index

    @property
    def indexes(self) -> "List[str]":
        """ Gets the indexes of this HECTokenAccessResponse.
        indexes is a list of index names that this token is allowed to send events to  type: []string
        """
        return self._attrs.get("indexes")

    @indexes.setter
    def indexes(self, indexes: "List[str]"):
        """Sets the indexes of this HECTokenAccessResponse.

        indexes is a list of index names that this token is allowed to send events to  type: []string

        :param indexes: The indexes of this HECTokenAccessResponse.
        :type: List[str]
        """
        self._attrs["indexes"] = indexes

    @property
    def last_modified_at(self) -> "datetime":
        """ Gets the last_modified_at of this HECTokenAccessResponse.
        last_modified_at is a timestamp that captures when this token was last modified.  type: string format: date-time
        """
        return self._attrs.get("last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at: "datetime"):
        """Sets the last_modified_at of this HECTokenAccessResponse.

        last_modified_at is a timestamp that captures when this token was last modified.  type: string format: date-time

        :param last_modified_at: The last_modified_at of this HECTokenAccessResponse.
        :type: datetime
        """
        self._attrs["last_modified_at"] = last_modified_at

    @property
    def last_modified_by(self) -> "str":
        """ Gets the last_modified_by of this HECTokenAccessResponse.
        last_modified_by is the principal that last modified the token.  type: string
        """
        return self._attrs.get("last_modified_by")

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by: "str"):
        """Sets the last_modified_by of this HECTokenAccessResponse.

        last_modified_by is the principal that last modified the token.  type: string

        :param last_modified_by: The last_modified_by of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["last_modified_by"] = last_modified_by

    @property
    def name(self) -> "str":
        """ Gets the name of this HECTokenAccessResponse.
        name is the name of the token (unique within the tenant that it belongs to).  type: string
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this HECTokenAccessResponse.

        name is the name of the token (unique within the tenant that it belongs to).  type: string

        :param name: The name of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def source(self) -> "str":
        """ Gets the source of this HECTokenAccessResponse.
        source is the default value of the source field for records collected using this token.  type: string
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this HECTokenAccessResponse.

        source is the default value of the source field for records collected using this token.  type: string

        :param source: The source of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this HECTokenAccessResponse.
        sourcetype is the default value of the sourcetype field for records collected using this token.  type: string
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this HECTokenAccessResponse.

        sourcetype is the default value of the sourcetype field for records collected using this token.  type: string

        :param sourcetype: The sourcetype of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this HECTokenAccessResponse.
        tenant is the tenant that this token belongs to  type: string
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this HECTokenAccessResponse.

        tenant is the tenant that this token belongs to  type: string

        :param tenant: The tenant of this HECTokenAccessResponse.
        :type: str
        """
        self._attrs["tenant"] = tenant

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class HECTokenCreateRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "HECTokenCreateRequest":
        instance = HECTokenCreateRequest.__new__(HECTokenCreateRequest)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", ack_enabled: "bool" = None, allow_query_string_auth: "bool" = None, description: "str" = None, disabled: "bool" = None, index: "str" = None, indexes: "List[str]" = None, source: "str" = None, sourcetype: "str" = None, **extra):
        """HECTokenCreateRequest"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if ack_enabled is not None:
            self._attrs["ack_enabled"] = ack_enabled
        if allow_query_string_auth is not None:
            self._attrs["allow_query_string_auth"] = allow_query_string_auth
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if index is not None:
            self._attrs["index"] = index
        if indexes is not None:
            self._attrs["indexes"] = indexes
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this HECTokenCreateRequest.
        name is the name of the token (unique within the tenant that it belongs to).  type: string
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this HECTokenCreateRequest.

        name is the name of the token (unique within the tenant that it belongs to).  type: string

        :param name: The name of this HECTokenCreateRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def ack_enabled(self) -> "bool":
        """ Gets the ack_enabled of this HECTokenCreateRequest.
        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: bool
        """
        return self._attrs.get("ack_enabled")

    @ack_enabled.setter
    def ack_enabled(self, ack_enabled: "bool"):
        """Sets the ack_enabled of this HECTokenCreateRequest.

        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: bool

        :param ack_enabled: The ack_enabled of this HECTokenCreateRequest.
        :type: bool
        """
        self._attrs["ack_enabled"] = ack_enabled

    @property
    def allow_query_string_auth(self) -> "bool":
        """ Gets the allow_query_string_auth of this HECTokenCreateRequest.
        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: bool
        """
        return self._attrs.get("allow_query_string_auth")

    @allow_query_string_auth.setter
    def allow_query_string_auth(self, allow_query_string_auth: "bool"):
        """Sets the allow_query_string_auth of this HECTokenCreateRequest.

        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: bool

        :param allow_query_string_auth: The allow_query_string_auth of this HECTokenCreateRequest.
        :type: bool
        """
        self._attrs["allow_query_string_auth"] = allow_query_string_auth

    @property
    def description(self) -> "str":
        """ Gets the description of this HECTokenCreateRequest.
        description is an optional description of the token.  type: string
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this HECTokenCreateRequest.

        description is an optional description of the token.  type: string

        :param description: The description of this HECTokenCreateRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this HECTokenCreateRequest.
        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: bool
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this HECTokenCreateRequest.

        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: bool

        :param disabled: The disabled of this HECTokenCreateRequest.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def index(self) -> "str":
        """ Gets the index of this HECTokenCreateRequest.
        index is the default value of the index field for records collected using this token.  type: string
        """
        return self._attrs.get("index")

    @index.setter
    def index(self, index: "str"):
        """Sets the index of this HECTokenCreateRequest.

        index is the default value of the index field for records collected using this token.  type: string

        :param index: The index of this HECTokenCreateRequest.
        :type: str
        """
        self._attrs["index"] = index

    @property
    def indexes(self) -> "List[str]":
        """ Gets the indexes of this HECTokenCreateRequest.
        indexes is a list of index names that this token is allowed to send events to  type: []string
        """
        return self._attrs.get("indexes")

    @indexes.setter
    def indexes(self, indexes: "List[str]"):
        """Sets the indexes of this HECTokenCreateRequest.

        indexes is a list of index names that this token is allowed to send events to  type: []string

        :param indexes: The indexes of this HECTokenCreateRequest.
        :type: List[str]
        """
        self._attrs["indexes"] = indexes

    @property
    def source(self) -> "str":
        """ Gets the source of this HECTokenCreateRequest.
        source is the default value of the source field for records collected using this token.  type: string
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this HECTokenCreateRequest.

        source is the default value of the source field for records collected using this token.  type: string

        :param source: The source of this HECTokenCreateRequest.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this HECTokenCreateRequest.
        sourcetype is the default value of the sourcetype field for records collected using this token.  type: string
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this HECTokenCreateRequest.

        sourcetype is the default value of the sourcetype field for records collected using this token.  type: string

        :param sourcetype: The sourcetype of this HECTokenCreateRequest.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class HECTokenCreateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "HECTokenCreateResponse":
        instance = HECTokenCreateResponse.__new__(HECTokenCreateResponse)
        instance._attrs = model
        return instance

    def __init__(self, ack_enabled: "bool" = None, allow_query_string_auth: "bool" = None, created_at: "datetime" = None, created_by: "str" = None, description: "str" = None, disabled: "bool" = None, index: "str" = None, indexes: "List[str]" = None, last_modified_at: "datetime" = None, last_modified_by: "str" = None, name: "str" = None, source: "str" = None, sourcetype: "str" = None, tenant: "str" = None, token: "str" = None, **extra):
        """HECTokenCreateResponse"""

        self._attrs = dict()
        if ack_enabled is not None:
            self._attrs["ack_enabled"] = ack_enabled
        if allow_query_string_auth is not None:
            self._attrs["allow_query_string_auth"] = allow_query_string_auth
        if created_at is not None:
            self._attrs["created_at"] = created_at
        if created_by is not None:
            self._attrs["created_by"] = created_by
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if index is not None:
            self._attrs["index"] = index
        if indexes is not None:
            self._attrs["indexes"] = indexes
        if last_modified_at is not None:
            self._attrs["last_modified_at"] = last_modified_at
        if last_modified_by is not None:
            self._attrs["last_modified_by"] = last_modified_by
        if name is not None:
            self._attrs["name"] = name
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        if tenant is not None:
            self._attrs["tenant"] = tenant
        if token is not None:
            self._attrs["token"] = token
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def ack_enabled(self) -> "bool":
        """ Gets the ack_enabled of this HECTokenCreateResponse.
        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: bool
        """
        return self._attrs.get("ack_enabled")

    @ack_enabled.setter
    def ack_enabled(self, ack_enabled: "bool"):
        """Sets the ack_enabled of this HECTokenCreateResponse.

        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: bool

        :param ack_enabled: The ack_enabled of this HECTokenCreateResponse.
        :type: bool
        """
        self._attrs["ack_enabled"] = ack_enabled

    @property
    def allow_query_string_auth(self) -> "bool":
        """ Gets the allow_query_string_auth of this HECTokenCreateResponse.
        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: bool
        """
        return self._attrs.get("allow_query_string_auth")

    @allow_query_string_auth.setter
    def allow_query_string_auth(self, allow_query_string_auth: "bool"):
        """Sets the allow_query_string_auth of this HECTokenCreateResponse.

        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: bool

        :param allow_query_string_auth: The allow_query_string_auth of this HECTokenCreateResponse.
        :type: bool
        """
        self._attrs["allow_query_string_auth"] = allow_query_string_auth

    @property
    def created_at(self) -> "datetime":
        """ Gets the created_at of this HECTokenCreateResponse.
        created_at is a timestamp that captures when this token was created.  type: string format: date-time
        """
        return self._attrs.get("created_at")

    @created_at.setter
    def created_at(self, created_at: "datetime"):
        """Sets the created_at of this HECTokenCreateResponse.

        created_at is a timestamp that captures when this token was created.  type: string format: date-time

        :param created_at: The created_at of this HECTokenCreateResponse.
        :type: datetime
        """
        self._attrs["created_at"] = created_at

    @property
    def created_by(self) -> "str":
        """ Gets the created_by of this HECTokenCreateResponse.
        created_by is the principal that created the token.  type: string
        """
        return self._attrs.get("created_by")

    @created_by.setter
    def created_by(self, created_by: "str"):
        """Sets the created_by of this HECTokenCreateResponse.

        created_by is the principal that created the token.  type: string

        :param created_by: The created_by of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["created_by"] = created_by

    @property
    def description(self) -> "str":
        """ Gets the description of this HECTokenCreateResponse.
        description is an optional description of the token.  type: string
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this HECTokenCreateResponse.

        description is an optional description of the token.  type: string

        :param description: The description of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this HECTokenCreateResponse.
        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: bool
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this HECTokenCreateResponse.

        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: bool

        :param disabled: The disabled of this HECTokenCreateResponse.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def index(self) -> "str":
        """ Gets the index of this HECTokenCreateResponse.
        index is the default value of the index field for records collected using this token.  type: string
        """
        return self._attrs.get("index")

    @index.setter
    def index(self, index: "str"):
        """Sets the index of this HECTokenCreateResponse.

        index is the default value of the index field for records collected using this token.  type: string

        :param index: The index of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["index"] = index

    @property
    def indexes(self) -> "List[str]":
        """ Gets the indexes of this HECTokenCreateResponse.
        indexes is a list of index names that this token is allowed to send events to  type: []string
        """
        return self._attrs.get("indexes")

    @indexes.setter
    def indexes(self, indexes: "List[str]"):
        """Sets the indexes of this HECTokenCreateResponse.

        indexes is a list of index names that this token is allowed to send events to  type: []string

        :param indexes: The indexes of this HECTokenCreateResponse.
        :type: List[str]
        """
        self._attrs["indexes"] = indexes

    @property
    def last_modified_at(self) -> "datetime":
        """ Gets the last_modified_at of this HECTokenCreateResponse.
        last_modified_at is a timestamp that captures when this token was last modified.  type: string format: date-time
        """
        return self._attrs.get("last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at: "datetime"):
        """Sets the last_modified_at of this HECTokenCreateResponse.

        last_modified_at is a timestamp that captures when this token was last modified.  type: string format: date-time

        :param last_modified_at: The last_modified_at of this HECTokenCreateResponse.
        :type: datetime
        """
        self._attrs["last_modified_at"] = last_modified_at

    @property
    def last_modified_by(self) -> "str":
        """ Gets the last_modified_by of this HECTokenCreateResponse.
        last_modified_by is the principal that last modified the token.  type: string
        """
        return self._attrs.get("last_modified_by")

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by: "str"):
        """Sets the last_modified_by of this HECTokenCreateResponse.

        last_modified_by is the principal that last modified the token.  type: string

        :param last_modified_by: The last_modified_by of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["last_modified_by"] = last_modified_by

    @property
    def name(self) -> "str":
        """ Gets the name of this HECTokenCreateResponse.
        name is the name of the token (unique within the tenant that it belongs to).  type: string
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this HECTokenCreateResponse.

        name is the name of the token (unique within the tenant that it belongs to).  type: string

        :param name: The name of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def source(self) -> "str":
        """ Gets the source of this HECTokenCreateResponse.
        source is the default value of the source field for records collected using this token.  type: string
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this HECTokenCreateResponse.

        source is the default value of the source field for records collected using this token.  type: string

        :param source: The source of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this HECTokenCreateResponse.
        sourcetype is the default value of the sourcetype field for records collected using this token.  type: string
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this HECTokenCreateResponse.

        sourcetype is the default value of the sourcetype field for records collected using this token.  type: string

        :param sourcetype: The sourcetype of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    @property
    def tenant(self) -> "str":
        """ Gets the tenant of this HECTokenCreateResponse.
        tenant is the tenant that this token belongs to.  type: string
        """
        return self._attrs.get("tenant")

    @tenant.setter
    def tenant(self, tenant: "str"):
        """Sets the tenant of this HECTokenCreateResponse.

        tenant is the tenant that this token belongs to.  type: string

        :param tenant: The tenant of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["tenant"] = tenant

    @property
    def token(self) -> "str":
        """ Gets the token of this HECTokenCreateResponse.
        token is the token value.  type: string
        """
        return self._attrs.get("token")

    @token.setter
    def token(self, token: "str"):
        """Sets the token of this HECTokenCreateResponse.

        token is the token value.  type: string

        :param token: The token of this HECTokenCreateResponse.
        :type: str
        """
        self._attrs["token"] = token

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class HECTokenUpdateRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "HECTokenUpdateRequest":
        instance = HECTokenUpdateRequest.__new__(HECTokenUpdateRequest)
        instance._attrs = model
        return instance

    def __init__(self, ack_enabled: "bool" = None, allow_query_string_auth: "bool" = None, description: "str" = None, disabled: "bool" = None, index: "str" = None, indexes: "List[str]" = None, source: "str" = None, sourcetype: "str" = None, **extra):
        """HECTokenUpdateRequest"""

        self._attrs = dict()
        if ack_enabled is not None:
            self._attrs["ack_enabled"] = ack_enabled
        if allow_query_string_auth is not None:
            self._attrs["allow_query_string_auth"] = allow_query_string_auth
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if index is not None:
            self._attrs["index"] = index
        if indexes is not None:
            self._attrs["indexes"] = indexes
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def ack_enabled(self) -> "bool":
        """ Gets the ack_enabled of this HECTokenUpdateRequest.
        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: *bool
        """
        return self._attrs.get("ack_enabled")

    @ack_enabled.setter
    def ack_enabled(self, ack_enabled: "bool"):
        """Sets the ack_enabled of this HECTokenUpdateRequest.

        ack_enabled is set to true if events sent with the auth token should support indexer acknowledgement  type: *bool

        :param ack_enabled: The ack_enabled of this HECTokenUpdateRequest.
        :type: bool
        """
        self._attrs["ack_enabled"] = ack_enabled

    @property
    def allow_query_string_auth(self) -> "bool":
        """ Gets the allow_query_string_auth of this HECTokenUpdateRequest.
        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: *bool
        """
        return self._attrs.get("allow_query_string_auth")

    @allow_query_string_auth.setter
    def allow_query_string_auth(self, allow_query_string_auth: "bool"):
        """Sets the allow_query_string_auth of this HECTokenUpdateRequest.

        allow_query_string_auth is set to true if this token can be passed into the ingest endpoint's query parameter for auth  type: *bool

        :param allow_query_string_auth: The allow_query_string_auth of this HECTokenUpdateRequest.
        :type: bool
        """
        self._attrs["allow_query_string_auth"] = allow_query_string_auth

    @property
    def description(self) -> "str":
        """ Gets the description of this HECTokenUpdateRequest.
        description is an optional description of the token.  type: *string
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this HECTokenUpdateRequest.

        description is an optional description of the token.  type: *string

        :param description: The description of this HECTokenUpdateRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this HECTokenUpdateRequest.
        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: *bool
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this HECTokenUpdateRequest.

        disabled is set to true if this auth token has been disabled and cannot be used to send events to HECv1  type: *bool

        :param disabled: The disabled of this HECTokenUpdateRequest.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def index(self) -> "str":
        """ Gets the index of this HECTokenUpdateRequest.
        index is the default value of the index field for records collected using this token  type: *string
        """
        return self._attrs.get("index")

    @index.setter
    def index(self, index: "str"):
        """Sets the index of this HECTokenUpdateRequest.

        index is the default value of the index field for records collected using this token  type: *string

        :param index: The index of this HECTokenUpdateRequest.
        :type: str
        """
        self._attrs["index"] = index

    @property
    def indexes(self) -> "List[str]":
        """ Gets the indexes of this HECTokenUpdateRequest.
        indexes is a list of index names that this token is allowed to send events to  type: []string
        """
        return self._attrs.get("indexes")

    @indexes.setter
    def indexes(self, indexes: "List[str]"):
        """Sets the indexes of this HECTokenUpdateRequest.

        indexes is a list of index names that this token is allowed to send events to  type: []string

        :param indexes: The indexes of this HECTokenUpdateRequest.
        :type: List[str]
        """
        self._attrs["indexes"] = indexes

    @property
    def source(self) -> "str":
        """ Gets the source of this HECTokenUpdateRequest.
        source is the default value of the source field for records collected using this token  type: *string
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this HECTokenUpdateRequest.

        source is the default value of the source field for records collected using this token  type: *string

        :param source: The source of this HECTokenUpdateRequest.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this HECTokenUpdateRequest.
        sourcetype is the default value of the sourcetype field for records collected using this token  type: *string
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this HECTokenUpdateRequest.

        sourcetype is the default value of the sourcetype field for records collected using this token  type: *string

        :param sourcetype: The sourcetype of this HECTokenUpdateRequest.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class HTTPResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "HTTPResponse":
        instance = HTTPResponse.__new__(HTTPResponse)
        instance._attrs = model
        return instance

    def __init__(self, code: "str" = None, details: "object" = None, message: "str" = None, **extra):
        """HTTPResponse"""

        self._attrs = dict()
        if code is not None:
            self._attrs["code"] = code
        if details is not None:
            self._attrs["details"] = details
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def code(self) -> "str":
        """ Gets the code of this HTTPResponse.
        """
        return self._attrs.get("code")

    @code.setter
    def code(self, code: "str"):
        """Sets the code of this HTTPResponse.


        :param code: The code of this HTTPResponse.
        :type: str
        """
        self._attrs["code"] = code

    @property
    def details(self) -> "dict":
        """ Gets the details of this HTTPResponse.
        """
        return self._attrs.get("details")

    @details.setter
    def details(self, details: "dict"):
        """Sets the details of this HTTPResponse.


        :param details: The details of this HTTPResponse.
        :type: object
        """
        self._attrs["details"] = details

    @property
    def message(self) -> "str":
        """ Gets the message of this HTTPResponse.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this HTTPResponse.


        :param message: The message of this HTTPResponse.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Metric(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Metric":
        instance = Metric.__new__(Metric)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", dimensions: "Dict[str, str]" = None, type: "str" = None, unit: "str" = None, value: "float" = None, **extra):
        """Metric"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if dimensions is not None:
            self._attrs["dimensions"] = dimensions
        if type is not None:
            self._attrs["type"] = type
        if unit is not None:
            self._attrs["unit"] = unit
        if value is not None:
            self._attrs["value"] = value
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this Metric.
        Name of the metric e.g. CPU, Memory etc.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Metric.

        Name of the metric e.g. CPU, Memory etc.

        :param name: The name of this Metric.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def dimensions(self) -> "Dict[str, str]":
        """ Gets the dimensions of this Metric.
        Dimensions allow metrics to be classified e.g. {\"Server\":\"nginx\", \"Region\":\"us-west-1\", ...}
        """
        return self._attrs.get("dimensions")

    @dimensions.setter
    def dimensions(self, dimensions: "Dict[str, str]"):
        """Sets the dimensions of this Metric.

        Dimensions allow metrics to be classified e.g. {\"Server\":\"nginx\", \"Region\":\"us-west-1\", ...}

        :param dimensions: The dimensions of this Metric.
        :type: Dict[str, str]
        """
        self._attrs["dimensions"] = dimensions

    @property
    def type(self) -> "str":
        """ Gets the type of this Metric.
        Type of metric. Default is g for gauge.
        """
        return self._attrs.get("type")

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this Metric.

        Type of metric. Default is g for gauge.

        :param type: The type of this Metric.
        :type: str
        """
        self._attrs["type"] = type

    @property
    def unit(self) -> "str":
        """ Gets the unit of this Metric.
        Unit of the metric e.g. percent, megabytes, seconds etc.
        """
        return self._attrs.get("unit")

    @unit.setter
    def unit(self, unit: "str"):
        """Sets the unit of this Metric.

        Unit of the metric e.g. percent, megabytes, seconds etc.

        :param unit: The unit of this Metric.
        :type: str
        """
        self._attrs["unit"] = unit

    @property
    def value(self) -> "float":
        """ Gets the value of this Metric.
        Value of the metric. If not specified, it will be defaulted to 0.
        """
        return self._attrs.get("value")

    @value.setter
    def value(self, value: "float"):
        """Sets the value of this Metric.

        Value of the metric. If not specified, it will be defaulted to 0.

        :param value: The value of this Metric.
        :type: float
        """
        self._attrs["value"] = value

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MetricAttribute(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "MetricAttribute":
        instance = MetricAttribute.__new__(MetricAttribute)
        instance._attrs = model
        return instance

    def __init__(self, default_dimensions: "Dict[str, str]" = None, default_type: "str" = None, default_unit: "str" = None, **extra):
        """MetricAttribute"""

        self._attrs = dict()
        if default_dimensions is not None:
            self._attrs["defaultDimensions"] = default_dimensions
        if default_type is not None:
            self._attrs["defaultType"] = default_type
        if default_unit is not None:
            self._attrs["defaultUnit"] = default_unit
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def default_dimensions(self) -> "Dict[str, str]":
        """ Gets the default_dimensions of this MetricAttribute.
        Optional. If set, individual metrics inherit these dimensions and can override any and/or all of them.
        """
        return self._attrs.get("defaultDimensions")

    @default_dimensions.setter
    def default_dimensions(self, default_dimensions: "Dict[str, str]"):
        """Sets the default_dimensions of this MetricAttribute.

        Optional. If set, individual metrics inherit these dimensions and can override any and/or all of them.

        :param default_dimensions: The default_dimensions of this MetricAttribute.
        :type: Dict[str, str]
        """
        self._attrs["defaultDimensions"] = default_dimensions

    @property
    def default_type(self) -> "str":
        """ Gets the default_type of this MetricAttribute.
        Optional. If set, individual metrics inherit this type and can optionally override.
        """
        return self._attrs.get("defaultType")

    @default_type.setter
    def default_type(self, default_type: "str"):
        """Sets the default_type of this MetricAttribute.

        Optional. If set, individual metrics inherit this type and can optionally override.

        :param default_type: The default_type of this MetricAttribute.
        :type: str
        """
        self._attrs["defaultType"] = default_type

    @property
    def default_unit(self) -> "str":
        """ Gets the default_unit of this MetricAttribute.
        Optional. If set, individual metrics inherit this unit and can optionally override.
        """
        return self._attrs.get("defaultUnit")

    @default_unit.setter
    def default_unit(self, default_unit: "str"):
        """Sets the default_unit of this MetricAttribute.

        Optional. If set, individual metrics inherit this unit and can optionally override.

        :param default_unit: The default_unit of this MetricAttribute.
        :type: str
        """
        self._attrs["defaultUnit"] = default_unit

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MetricEvent(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "MetricEvent":
        instance = MetricEvent.__new__(MetricEvent)
        instance._attrs = model
        return instance

    def __init__(self, body: "List[Metric]", attributes: "MetricAttribute" = None, host: "str" = None, id: "str" = None, nanos: "int" = None, source: "str" = None, sourcetype: "str" = None, timestamp: "int" = None, **extra):
        """MetricEvent"""

        self._attrs = dict()
        if body is not None:
            self._attrs["body"] = body
        if attributes is not None:
            self._attrs["attributes"] = attributes.to_dict()
        if host is not None:
            self._attrs["host"] = host
        if id is not None:
            self._attrs["id"] = id
        if nanos is not None:
            self._attrs["nanos"] = nanos
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        if timestamp is not None:
            self._attrs["timestamp"] = timestamp
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def body(self) -> "List[Metric]":
        """ Gets the body of this MetricEvent.
        Specifies multiple related metrics e.g. Memory, CPU etc.
        """
        return [Metric._from_dict(i) for i in self._attrs.get("body")]

    @body.setter
    def body(self, body: "List[Metric]"):
        """Sets the body of this MetricEvent.

        Specifies multiple related metrics e.g. Memory, CPU etc.

        :param body: The body of this MetricEvent.
        :type: List[Metric]
        """
        if body is None:
            raise ValueError("Invalid value for `body`, must not be `None`")
        self._attrs["body"] = body

    @property
    def attributes(self) -> "MetricAttribute":
        """ Gets the attributes of this MetricEvent.
        """
        return MetricAttribute._from_dict(self._attrs["attributes"])

    @attributes.setter
    def attributes(self, attributes: "MetricAttribute"):
        """Sets the attributes of this MetricEvent.


        :param attributes: The attributes of this MetricEvent.
        :type: MetricAttribute
        """
        self._attrs["attributes"] = attributes.to_dict()

    @property
    def host(self) -> "str":
        """ Gets the host of this MetricEvent.
        The host value assigned to the event data. Typically, this is the hostname of the client from which you are sending data.
        """
        return self._attrs.get("host")

    @host.setter
    def host(self, host: "str"):
        """Sets the host of this MetricEvent.

        The host value assigned to the event data. Typically, this is the hostname of the client from which you are sending data.

        :param host: The host of this MetricEvent.
        :type: str
        """
        self._attrs["host"] = host

    @property
    def id(self) -> "str":
        """ Gets the id of this MetricEvent.
        An optional ID that uniquely identifies the metric data. It is used to deduplicate the data if same data is set multiple times. If ID is not specified, it will be assigned by the system.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this MetricEvent.

        An optional ID that uniquely identifies the metric data. It is used to deduplicate the data if same data is set multiple times. If ID is not specified, it will be assigned by the system.

        :param id: The id of this MetricEvent.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def nanos(self) -> "int":
        """ Gets the nanos of this MetricEvent.
        Optional nanoseconds part of the timestamp.
        """
        return self._attrs.get("nanos")

    @nanos.setter
    def nanos(self, nanos: "int"):
        """Sets the nanos of this MetricEvent.

        Optional nanoseconds part of the timestamp.

        :param nanos: The nanos of this MetricEvent.
        :type: int
        """
        self._attrs["nanos"] = nanos

    @property
    def source(self) -> "str":
        """ Gets the source of this MetricEvent.
        The source value to assign to the event data. For example, if you are sending data from an app that you are developing, set this key to the name of the app.
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this MetricEvent.

        The source value to assign to the event data. For example, if you are sending data from an app that you are developing, set this key to the name of the app.

        :param source: The source of this MetricEvent.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this MetricEvent.
        The sourcetype value assigned to the event data.
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this MetricEvent.

        The sourcetype value assigned to the event data.

        :param sourcetype: The sourcetype of this MetricEvent.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    @property
    def timestamp(self) -> "int":
        """ Gets the timestamp of this MetricEvent.
        Epoch time in milliseconds.
        """
        return self._attrs.get("timestamp")

    @timestamp.setter
    def timestamp(self, timestamp: "int"):
        """Sets the timestamp of this MetricEvent.

        Epoch time in milliseconds.

        :param timestamp: The timestamp of this MetricEvent.
        :type: int
        """
        self._attrs["timestamp"] = timestamp

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UploadSuccessResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UploadSuccessResponse":
        instance = UploadSuccessResponse.__new__(UploadSuccessResponse)
        instance._attrs = model
        return instance

    def __init__(self, code: "str" = None, details: "FileUploadDetails" = None, message: "str" = None, **extra):
        """UploadSuccessResponse"""

        self._attrs = dict()
        if code is not None:
            self._attrs["code"] = code
        if details is not None:
            self._attrs["details"] = details.to_dict()
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def code(self) -> "str":
        """ Gets the code of this UploadSuccessResponse.
        """
        return self._attrs.get("code")

    @code.setter
    def code(self, code: "str"):
        """Sets the code of this UploadSuccessResponse.


        :param code: The code of this UploadSuccessResponse.
        :type: str
        """
        self._attrs["code"] = code

    @property
    def details(self) -> "FileUploadDetails":
        """ Gets the details of this UploadSuccessResponse.
        """
        return FileUploadDetails._from_dict(self._attrs["details"])

    @details.setter
    def details(self, details: "FileUploadDetails"):
        """Sets the details of this UploadSuccessResponse.


        :param details: The details of this UploadSuccessResponse.
        :type: FileUploadDetails
        """
        self._attrs["details"] = details.to_dict()

    @property
    def message(self) -> "str":
        """ Gets the message of this UploadSuccessResponse.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this UploadSuccessResponse.


        :param message: The message of this UploadSuccessResponse.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
