# coding: utf-8

# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: KV Store API

    With the Splunk Cloud KV store service in Splunk Cloud Services, you can save and retrieve data within your Splunk Cloud apps, enabling you to manage and maintain state in your application.

    OpenAPI spec version: v1beta1.2 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from requests import Response
from string import Template
from typing import List, Dict

from splunk_sdk.base_client import handle_response
from splunk_sdk.base_service import BaseService
from splunk_sdk.common.sscmodel import SSCModel, SSCVoidModel

from splunk_sdk.kvstore.v1beta1.gen_models import ErrorResponse
from splunk_sdk.kvstore.v1beta1.gen_models import IndexDefinition
from splunk_sdk.kvstore.v1beta1.gen_models import IndexDescription
from splunk_sdk.kvstore.v1beta1.gen_models import List
from splunk_sdk.kvstore.v1beta1.gen_models import PingResponse
from splunk_sdk.kvstore.v1beta1.gen_models import Record


class KVStoreAPI(BaseService):
    """
    KV Store API
    Version: v1beta1.2
    With the Splunk Cloud KV store service in Splunk Cloud Services, you can save and retrieve data within your Splunk Cloud apps, enabling you to manage and maintain state in your application.
    """

    def __init__(self, base_client):
        super().__init__(base_client)

    def create_index(self, collection: str, index_definition: IndexDefinition = None, query_params: Dict[str, object] = None) -> IndexDescription:
        """
        Creates an index on a collection.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/indexes").substitute(path_params)
        url = self.base_client.build_url(path)
        data = index_definition.to_dict()
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, IndexDescription)

    def delete_index(self, collection: str, index: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Removes an index from a collection.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
            "index": index,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/indexes/${index}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_record_by_key(self, collection: str, key: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Deletes a record with a given key.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
            "key": key,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/records/${key}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def delete_records(self, collection: str, query: str = None, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Removes records in a collection that match the query.
        """
        if query_params is None:
            query_params = {}
        if query is not None:
            query_params['query'] = query

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/query").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )

    def get_record_by_key(self, collection: str, key: str, query_params: Dict[str, object] = None) -> object:
        """
        Returns a record with a given key.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
            "key": key,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/records/${key}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, object)

    def insert_record(self, collection: str, body: object, query_params: Dict[str, object] = None) -> Record:
        """
        Inserts a record into a collection.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = body
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, Record)

    def insert_records(self, collection: str, request_body: List[object], allow_updates: bool = None, query_params: Dict[str, object] = None) -> List[str]:
        """
        Inserts multiple records in a single request.
        """
        if query_params is None:
            query_params = {}
        if allow_updates is not None:
            query_params['allow_updates'] = allow_updates

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/batch").substitute(path_params)
        url = self.base_client.build_url(path)
        data = request_body
        response = self.base_client.post(url, json=data, params=query_params)
        return handle_response(response, str)

    def list_indexes(self, collection: str, query_params: Dict[str, object] = None) -> List[IndexDefinition]:
        """
        Returns a list of all indexes on a collection.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/indexes").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, IndexDefinition)

    def list_records(self, collection: str, count: int = None, fields: List[str] = None, offset: int = None, orderby: List[str] = None, query_params: Dict[str, object] = None) -> List[object]:
        """
        Returns a list of records in a collection with basic filtering, sorting, pagination and field projection.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if fields is not None:
            query_params['fields'] = fields
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, object)

    def ping(self, query_params: Dict[str, object] = None) -> PingResponse:
        """
        Returns the health status from the database.
        """
        if query_params is None:
            query_params = {}

        path_params = {
        }

        path = Template("/kvstore/v1beta1/ping").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, PingResponse)

    def put_record(self, collection: str, key: str, body: object, query_params: Dict[str, object] = None) -> Record:
        """
        Updates the record with a given key, either by inserting or replacing the record.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
            "key": key,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/records/${key}").substitute(path_params)
        url = self.base_client.build_url(path)
        data = body
        response = self.base_client.put(url, json=data, params=query_params)
        return handle_response(response, Record)

    def query_records(self, collection: str, count: int = None, fields: List[str] = None, offset: int = None, orderby: List[str] = None, query: str = None, query_params: Dict[str, object] = None) -> List[object]:
        """
        Returns a list of query records in a collection.
        """
        if query_params is None:
            query_params = {}
        if count is not None:
            query_params['count'] = count
        if fields is not None:
            query_params['fields'] = fields
        if offset is not None:
            query_params['offset'] = offset
        if orderby is not None:
            query_params['orderby'] = orderby
        if query is not None:
            query_params['query'] = query

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/query").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.get(url, params=query_params)
        return handle_response(response, object)

    def truncate_records(self, collection: str, query_params: Dict[str, object] = None) -> SSCVoidModel:
        """
        Deletes all the records in a collection.
        """
        if query_params is None:
            query_params = {}

        path_params = {
            "collection": collection,
        }

        path = Template("/kvstore/v1beta1/collections/${collection}/truncate").substitute(path_params)
        url = self.base_client.build_url(path)
        response = self.base_client.delete(url, params=query_params)
        return handle_response(response, )


