# Copyright © 2020 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Machine Learning

    Use the Machine Learning service in Splunk Cloud Services to deliver resource intensive machine learning workloads. The Machine Learning service covers model experimentation, training, inference, validation, scoring, and serving.

    OpenAPI spec version: v2beta1.1 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class WorkflowValidationOption(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowValidationOption":
        instance = WorkflowValidationOption.__new__(WorkflowValidationOption)
        instance._attrs = model
        return instance

    def __init__(self, random_seed: "int" = 0, stratified: "bool" = False, **extra):
        """WorkflowValidationOption"""

        self._attrs = dict()
        if random_seed is not None:
            self._attrs["randomSeed"] = random_seed
        if stratified is not None:
            self._attrs["stratified"] = stratified
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def random_seed(self) -> "int":
        """ Gets the random_seed of this WorkflowValidationOption.
        Random state to shuffle and partition data.
        """
        return self._attrs.get("randomSeed")

    @random_seed.setter
    def random_seed(self, random_seed: "int"):
        """Sets the random_seed of this WorkflowValidationOption.

        Random state to shuffle and partition data.

        :param random_seed: The random_seed of this WorkflowValidationOption.
        :type: int
        """
        self._attrs["randomSeed"] = random_seed

    @property
    def stratified(self) -> "bool":
        """ Gets the stratified of this WorkflowValidationOption.
        Determine whether stratification is used in partitioning the data.
        """
        return self._attrs.get("stratified")

    @stratified.setter
    def stratified(self, stratified: "bool"):
        """Sets the stratified of this WorkflowValidationOption.

        Determine whether stratification is used in partitioning the data.

        :param stratified: The stratified of this WorkflowValidationOption.
        :type: bool
        """
        self._attrs["stratified"] = stratified

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class CrossValidation(WorkflowValidationOption):

    @staticmethod
    def _from_dict(model: dict) -> "CrossValidation":
        instance = CrossValidation.__new__(CrossValidation)
        instance._attrs = model
        return instance

    def __init__(self, k_fold: "int" = 5, random_seed: "int" = 0, stratified: "bool" = False, **extra):
        """CrossValidation"""

        self._attrs = dict()
        if k_fold is not None:
            self._attrs["kFold"] = k_fold
        if random_seed is not None:
            self._attrs["randomSeed"] = random_seed
        if stratified is not None:
            self._attrs["stratified"] = stratified
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def k_fold(self) -> "int":
        """ Gets the k_fold of this CrossValidation.
        Number of folds in the K-fold cross validation.
        """
        return self._attrs.get("kFold")

    @k_fold.setter
    def k_fold(self, k_fold: "int"):
        """Sets the k_fold of this CrossValidation.

        Number of folds in the K-fold cross validation.

        :param k_fold: The k_fold of this CrossValidation.
        :type: int
        """
        self._attrs["kFold"] = k_fold

    @property
    def random_seed(self) -> "int":
        """ Gets the random_seed of this CrossValidation.
        Random state to shuffle and partition data.
        """
        return self._attrs.get("randomSeed")

    @random_seed.setter
    def random_seed(self, random_seed: "int"):
        """Sets the random_seed of this CrossValidation.

        Random state to shuffle and partition data.

        :param random_seed: The random_seed of this CrossValidation.
        :type: int
        """
        self._attrs["randomSeed"] = random_seed

    @property
    def stratified(self) -> "bool":
        """ Gets the stratified of this CrossValidation.
        Determine whether stratification is used in partitioning the data.
        """
        return self._attrs.get("stratified")

    @stratified.setter
    def stratified(self, stratified: "bool"):
        """Sets the stratified of this CrossValidation.

        Determine whether stratification is used in partitioning the data.

        :param stratified: The stratified of this CrossValidation.
        :type: bool
        """
        self._attrs["stratified"] = stratified

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DeploymentSpec(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DeploymentSpec":
        instance = DeploymentSpec.__new__(DeploymentSpec)
        instance._attrs = model
        return instance

    def __init__(self, cpu_limit: "str" = '1', cpu_request: "str" = '125m', memory_limit: "str" = '1G', memory_request: "str" = '128M', replicas: "int" = 1, **extra):
        """DeploymentSpec"""

        self._attrs = dict()
        if cpu_limit is not None:
            self._attrs["cpuLimit"] = cpu_limit
        if cpu_request is not None:
            self._attrs["cpuRequest"] = cpu_request
        if memory_limit is not None:
            self._attrs["memoryLimit"] = memory_limit
        if memory_request is not None:
            self._attrs["memoryRequest"] = memory_request
        if replicas is not None:
            self._attrs["replicas"] = replicas
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def cpu_limit(self) -> "str":
        """ Gets the cpu_limit of this DeploymentSpec.
        CPU Resource limit for each container in a deployment.
        """
        return self._attrs.get("cpuLimit")

    @cpu_limit.setter
    def cpu_limit(self, cpu_limit: "str"):
        """Sets the cpu_limit of this DeploymentSpec.

        CPU Resource limit for each container in a deployment.

        :param cpu_limit: The cpu_limit of this DeploymentSpec.
        :type: str
        """
        self._attrs["cpuLimit"] = cpu_limit

    @property
    def cpu_request(self) -> "str":
        """ Gets the cpu_request of this DeploymentSpec.
        CPU Resource limit for serving requests.
        """
        return self._attrs.get("cpuRequest")

    @cpu_request.setter
    def cpu_request(self, cpu_request: "str"):
        """Sets the cpu_request of this DeploymentSpec.

        CPU Resource limit for serving requests.

        :param cpu_request: The cpu_request of this DeploymentSpec.
        :type: str
        """
        self._attrs["cpuRequest"] = cpu_request

    @property
    def memory_limit(self) -> "str":
        """ Gets the memory_limit of this DeploymentSpec.
        Memory Resource limit for each container in a deployment.
        """
        return self._attrs.get("memoryLimit")

    @memory_limit.setter
    def memory_limit(self, memory_limit: "str"):
        """Sets the memory_limit of this DeploymentSpec.

        Memory Resource limit for each container in a deployment.

        :param memory_limit: The memory_limit of this DeploymentSpec.
        :type: str
        """
        self._attrs["memoryLimit"] = memory_limit

    @property
    def memory_request(self) -> "str":
        """ Gets the memory_request of this DeploymentSpec.
        Memory Resource limit for serving requests.
        """
        return self._attrs.get("memoryRequest")

    @memory_request.setter
    def memory_request(self, memory_request: "str"):
        """Sets the memory_request of this DeploymentSpec.

        Memory Resource limit for serving requests.

        :param memory_request: The memory_request of this DeploymentSpec.
        :type: str
        """
        self._attrs["memoryRequest"] = memory_request

    @property
    def replicas(self) -> "int":
        """ Gets the replicas of this DeploymentSpec.
        Create replicated pods in a deployment.
        """
        return self._attrs.get("replicas")

    @replicas.setter
    def replicas(self, replicas: "int"):
        """Sets the replicas of this DeploymentSpec.

        Create replicated pods in a deployment.

        :param replicas: The replicas of this DeploymentSpec.
        :type: int
        """
        self._attrs["replicas"] = replicas

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Error(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Error":
        instance = Error.__new__(Error)
        instance._attrs = model
        return instance

    def __init__(self, code: "str", message: "str", details: "List[object]" = None, **extra):
        """Error"""

        self._attrs = dict()
        if code is not None:
            self._attrs["code"] = code
        if message is not None:
            self._attrs["message"] = message
        if details is not None:
            self._attrs["details"] = details
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def code(self) -> "str":
        """ Gets the code of this Error.
        """
        return self._attrs.get("code")

    @code.setter
    def code(self, code: "str"):
        """Sets the code of this Error.


        :param code: The code of this Error.
        :type: str
        """
        if code is None:
            raise ValueError("Invalid value for `code`, must not be `None`")
        self._attrs["code"] = code

    @property
    def message(self) -> "str":
        """ Gets the message of this Error.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this Error.


        :param message: The message of this Error.
        :type: str
        """
        if message is None:
            raise ValueError("Invalid value for `message`, must not be `None`")
        self._attrs["message"] = message

    @property
    def details(self) -> "List[object]":
        """ Gets the details of this Error.
        """
        return self._attrs.get("details")

    @details.setter
    def details(self, details: "List[object]"):
        """Sets the details of this Error.


        :param details: The details of this Error.
        :type: List[object]
        """
        self._attrs["details"] = details

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class OutputDataDestination(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "OutputDataDestination":
        instance = OutputDataDestination.__new__(OutputDataDestination)
        instance._attrs = model
        return instance

    def __init__(self, attributes: "object" = None, host: "str" = None, source: "str" = None, sourcetype: "str" = None, **extra):
        """OutputDataDestination"""

        self._attrs = dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if host is not None:
            self._attrs["host"] = host
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this OutputDataDestination.
        Specifies a JSON object that contains explicit custom fields to be defined at index time.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this OutputDataDestination.

        Specifies a JSON object that contains explicit custom fields to be defined at index time.

        :param attributes: The attributes of this OutputDataDestination.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def host(self) -> "str":
        """ Gets the host of this OutputDataDestination.
        Splunk host field.
        """
        return self._attrs.get("host")

    @host.setter
    def host(self, host: "str"):
        """Sets the host of this OutputDataDestination.

        Splunk host field.

        :param host: The host of this OutputDataDestination.
        :type: str
        """
        self._attrs["host"] = host

    @property
    def source(self) -> "str":
        """ Gets the source of this OutputDataDestination.
        Splunk source field.
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this OutputDataDestination.

        Splunk source field.

        :param source: The source of this OutputDataDestination.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this OutputDataDestination.
        Splunk sourcetype field.
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this OutputDataDestination.

        Splunk sourcetype field.

        :param sourcetype: The sourcetype of this OutputDataDestination.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Events(OutputDataDestination):

    @staticmethod
    def _from_dict(model: dict) -> "Events":
        instance = Events.__new__(Events)
        instance._attrs = model
        return instance

    def __init__(self, attributes: "object" = None, host: "str" = None, source: "str" = None, sourcetype: "str" = None, **extra):
        """Events"""

        self._attrs = dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if host is not None:
            self._attrs["host"] = host
        if source is not None:
            self._attrs["source"] = source
        if sourcetype is not None:
            self._attrs["sourcetype"] = sourcetype
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this Events.
        Specifies a JSON object that contains explicit custom fields to be defined at index time.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this Events.

        Specifies a JSON object that contains explicit custom fields to be defined at index time.

        :param attributes: The attributes of this Events.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def host(self) -> "str":
        """ Gets the host of this Events.
        Splunk host field.
        """
        return self._attrs.get("host")

    @host.setter
    def host(self, host: "str"):
        """Sets the host of this Events.

        Splunk host field.

        :param host: The host of this Events.
        :type: str
        """
        self._attrs["host"] = host

    @property
    def source(self) -> "str":
        """ Gets the source of this Events.
        Splunk source field.
        """
        return self._attrs.get("source")

    @source.setter
    def source(self, source: "str"):
        """Sets the source of this Events.

        Splunk source field.

        :param source: The source of this Events.
        :type: str
        """
        self._attrs["source"] = source

    @property
    def sourcetype(self) -> "str":
        """ Gets the sourcetype of this Events.
        Splunk sourcetype field.
        """
        return self._attrs.get("sourcetype")

    @sourcetype.setter
    def sourcetype(self, sourcetype: "str"):
        """Sets the sourcetype of this Events.

        Splunk sourcetype field.

        :param sourcetype: The sourcetype of this Events.
        :type: str
        """
        self._attrs["sourcetype"] = sourcetype

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ExecutorErrors(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ExecutorErrors":
        instance = ExecutorErrors.__new__(ExecutorErrors)
        instance._attrs = model
        return instance

    def __init__(self, message: "str" = None, **extra):
        """ExecutorErrors"""

        self._attrs = dict()
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def message(self) -> "str":
        """ Gets the message of this ExecutorErrors.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this ExecutorErrors.


        :param message: The message of this ExecutorErrors.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ExecutorLogs(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ExecutorLogs":
        instance = ExecutorLogs.__new__(ExecutorLogs)
        instance._attrs = model
        return instance

    def __init__(self, level: "str" = None, message: "str" = None, **extra):
        """ExecutorLogs"""

        self._attrs = dict()
        if level is not None:
            self._attrs["level"] = level
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def level(self) -> "str":
        """ Gets the level of this ExecutorLogs.
        """
        return self._attrs.get("level")

    @level.setter
    def level(self, level: "str"):
        """Sets the level of this ExecutorLogs.


        :param level: The level of this ExecutorLogs.
        :type: str
        """
        self._attrs["level"] = level

    @property
    def message(self) -> "str":
        """ Gets the message of this ExecutorLogs.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this ExecutorLogs.


        :param message: The message of this ExecutorLogs.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Fields(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Fields":
        instance = Fields.__new__(Fields)
        instance._attrs = model
        return instance

    def __init__(self, features: "List[str]", created: "List[str]" = None, target: "str" = None, **extra):
        """Fields"""

        self._attrs = dict()
        if features is not None:
            self._attrs["features"] = features
        if created is not None:
            self._attrs["created"] = created
        if target is not None:
            self._attrs["target"] = target
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def features(self) -> "List[str]":
        """ Gets the features of this Fields.
        Fields necessary for task.
        """
        return self._attrs.get("features")

    @features.setter
    def features(self, features: "List[str]"):
        """Sets the features of this Fields.

        Fields necessary for task.

        :param features: The features of this Fields.
        :type: List[str]
        """
        if features is None:
            raise ValueError("Invalid value for `features`, must not be `None`")
        self._attrs["features"] = features

    @property
    def created(self) -> "List[str]":
        """ Gets the created of this Fields.
        Fields produced by task.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "List[str]"):
        """Sets the created of this Fields.

        Fields produced by task.

        :param created: The created of this Fields.
        :type: List[str]
        """
        self._attrs["created"] = created

    @property
    def target(self) -> "str":
        """ Gets the target of this Fields.
        Target field necessary for task.
        """
        return self._attrs.get("target")

    @target.setter
    def target(self, target: "str"):
        """Sets the target of this Fields.

        Target field necessary for task.

        :param target: The target of this Fields.
        :type: str
        """
        self._attrs["target"] = target

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    FIT = "fit"

    @staticmethod
    def from_value(value: str):
        if value == "fit":
            return KindEnum.FIT


class Task(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "Task":

        def default_handler(model: dict) -> "Task":
            instance = Task.__new__(Task)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = Task.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, algorithm: "str" = None, fields: "Fields" = None, kind: "str" = None, name: "str" = None, output_transformer: "str" = None, parameters: "object" = None, **extra):
        """Task"""

        self._attrs = dict()
        if algorithm is not None:
            self._attrs["algorithm"] = algorithm
        if fields is not None:
            self._attrs["fields"] = fields.to_dict()
        self._attrs["kind"] = "fit" 
        if name is not None:
            self._attrs["name"] = name
        if output_transformer is not None:
            self._attrs["outputTransformer"] = output_transformer
        if parameters is not None:
            self._attrs["parameters"] = parameters
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def algorithm(self) -> "str":
        """ Gets the algorithm of this Task.
        """
        return self._attrs.get("algorithm")

    @algorithm.setter
    def algorithm(self, algorithm: "str"):
        """Sets the algorithm of this Task.


        :param algorithm: The algorithm of this Task.
        :type: str
        """
        if algorithm is None:
            raise ValueError("Invalid value for `algorithm`, must not be `None`")
        self._attrs["algorithm"] = algorithm

    @property
    def fields(self) -> "Fields":
        """ Gets the fields of this Task.
        """
        return Fields._from_dict(self._attrs["fields"])

    @fields.setter
    def fields(self, fields: "Fields"):
        """Sets the fields of this Task.


        :param fields: The fields of this Task.
        :type: Fields
        """
        if fields is None:
            raise ValueError("Invalid value for `fields`, must not be `None`")
        self._attrs["fields"] = fields.to_dict()

    @property
    def kind(self) -> str:
        return "fit"


    @property
    def name(self) -> "str":
        """ Gets the name of this Task.
        The name has to be unique in the same workflow, it is optional, can be used to identify that task artifact.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Task.

        The name has to be unique in the same workflow, it is optional, can be used to identify that task artifact.

        :param name: The name of this Task.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def output_transformer(self) -> "str":
        """ Gets the output_transformer of this Task.
        """
        return self._attrs.get("outputTransformer")

    @output_transformer.setter
    def output_transformer(self, output_transformer: "str"):
        """Sets the output_transformer of this Task.


        :param output_transformer: The output_transformer of this Task.
        :type: str
        """
        self._attrs["outputTransformer"] = output_transformer

    @property
    def parameters(self) -> "dict":
        """ Gets the parameters of this Task.
        """
        return self._attrs.get("parameters")

    @parameters.setter
    def parameters(self, parameters: "dict"):
        """Sets the parameters of this Task.


        :param parameters: The parameters of this Task.
        :type: object
        """
        self._attrs["parameters"] = parameters

    def to_dict(self):
        raise NotImplementedError()


class KindEnum(str, Enum):
    FIT = "fit"

    @staticmethod
    def from_value(value: str):
        if value == "fit":
            return KindEnum.FIT


class FitTask(Task):

    @staticmethod
    def _from_dict(model: dict) -> "FitTask":
        instance = FitTask.__new__(FitTask)
        instance._attrs = model
        return instance

    def __init__(self, algorithm: "str", fields: "Fields", name: "str" = None, output_transformer: "str" = None, parameters: "object" = None, **extra):
        """FitTask"""

        self._attrs = dict()
        if algorithm is not None:
            self._attrs["algorithm"] = algorithm
        if fields is not None:
            self._attrs["fields"] = fields.to_dict()
        self._attrs["kind"] = "fit" 
        if name is not None:
            self._attrs["name"] = name
        if output_transformer is not None:
            self._attrs["outputTransformer"] = output_transformer
        if parameters is not None:
            self._attrs["parameters"] = parameters
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def algorithm(self) -> "str":
        """ Gets the algorithm of this FitTask.
        """
        return self._attrs.get("algorithm")

    @algorithm.setter
    def algorithm(self, algorithm: "str"):
        """Sets the algorithm of this FitTask.


        :param algorithm: The algorithm of this FitTask.
        :type: str
        """
        if algorithm is None:
            raise ValueError("Invalid value for `algorithm`, must not be `None`")
        self._attrs["algorithm"] = algorithm

    @property
    def fields(self) -> "Fields":
        """ Gets the fields of this FitTask.
        """
        return Fields._from_dict(self._attrs["fields"])

    @fields.setter
    def fields(self, fields: "Fields"):
        """Sets the fields of this FitTask.


        :param fields: The fields of this FitTask.
        :type: Fields
        """
        if fields is None:
            raise ValueError("Invalid value for `fields`, must not be `None`")
        self._attrs["fields"] = fields.to_dict()

    @property
    def kind(self) -> str:
        return "fit"


    @property
    def name(self) -> "str":
        """ Gets the name of this FitTask.
        The name has to be unique in the same workflow, it is optional, can be used to identify that task artifact.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FitTask.

        The name has to be unique in the same workflow, it is optional, can be used to identify that task artifact.

        :param name: The name of this FitTask.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def output_transformer(self) -> "str":
        """ Gets the output_transformer of this FitTask.
        """
        return self._attrs.get("outputTransformer")

    @output_transformer.setter
    def output_transformer(self, output_transformer: "str"):
        """Sets the output_transformer of this FitTask.


        :param output_transformer: The output_transformer of this FitTask.
        :type: str
        """
        self._attrs["outputTransformer"] = output_transformer

    @property
    def parameters(self) -> "dict":
        """ Gets the parameters of this FitTask.
        """
        return self._attrs.get("parameters")

    @parameters.setter
    def parameters(self, parameters: "dict"):
        """Sets the parameters of this FitTask.


        :param parameters: The parameters of this FitTask.
        :type: object
        """
        self._attrs["parameters"] = parameters

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Task.from_dict_handlers["fit"] = FitTask._from_dict



class InputDataSource(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "InputDataSource":
        instance = InputDataSource.__new__(InputDataSource)
        instance._attrs = model
        return instance

    def __init__(self, **extra):
        """InputDataSource"""

        self._attrs = dict()
        for k, v in extra.items():
            self._attrs[k] = v

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    SPL = "SPL"
    RAWDATA = "RawData"

    @staticmethod
    def from_value(value: str):
        if value == "SPL":
            return KindEnum.SPL
        if value == "RawData":
            return KindEnum.RAWDATA


class InputData(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "InputData":
        instance = InputData.__new__(InputData)
        instance._attrs = model
        return instance

    def __init__(self, kind: "str", source: "InputDataSource", **extra):
        """InputData"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if source is not None:
            self._attrs["source"] = source.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this InputData.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this InputData.


        :param kind: The kind of this InputData.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def source(self) -> "InputDataSource":
        """ Gets the source of this InputData.
        """
        return InputDataSource._from_dict(self._attrs["source"])

    @source.setter
    def source(self, source: "InputDataSource"):
        """Sets the source of this InputData.


        :param source: The source of this InputData.
        :type: InputDataSource
        """
        if source is None:
            raise ValueError("Invalid value for `source`, must not be `None`")
        self._attrs["source"] = source.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Offset_resetEnum(str, Enum):
    EARLIEST = "earliest"
    LATEST = "latest"

    @staticmethod
    def from_value(value: str):
        if value == "earliest":
            return Offset_resetEnum.EARLIEST
        if value == "latest":
            return Offset_resetEnum.LATEST


class InputStreamSource(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "InputStreamSource":
        instance = InputStreamSource.__new__(InputStreamSource)
        instance._attrs = model
        return instance

    def __init__(self, offset_reset: "str" = 'latest', topic: "str" = None, **extra):
        """InputStreamSource"""

        self._attrs = dict()
        if topic is not None:
            self._attrs["topic"] = topic
        if offset_reset is not None:
            self._attrs["offsetReset"] = offset_reset
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def topic(self) -> "str":
        """ Gets the topic of this InputStreamSource.
        """
        return self._attrs.get("topic")

    @topic.setter
    def topic(self, topic: "str"):
        """Sets the topic of this InputStreamSource.


        :param topic: The topic of this InputStreamSource.
        :type: str
        """
        if topic is None:
            raise ValueError("Invalid value for `topic`, must not be `None`")
        self._attrs["topic"] = topic

    @property
    def offset_reset(self) -> "Offset_resetEnum":
        """ Gets the offset_reset of this InputStreamSource.
        """
        return Offset_resetEnum.from_value(self._attrs.get("offsetReset"))

    @offset_reset.setter
    def offset_reset(self, offset_reset: "str"):
        """Sets the offset_reset of this InputStreamSource.


        :param offset_reset: The offset_reset of this InputStreamSource.
        :type: str
        """
        if isinstance(offset_reset, Enum):
            self._attrs["offsetReset"] = offset_reset.value
        else:
            self._attrs["offsetReset"] = offset_reset  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    KAFKA = "Kafka"

    @staticmethod
    def from_value(value: str):
        if value == "Kafka":
            return KindEnum.KAFKA


class InputStream(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "InputStream":
        instance = InputStream.__new__(InputStream)
        instance._attrs = model
        return instance

    def __init__(self, kind: "str", source: "InputStreamSource", **extra):
        """InputStream"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if source is not None:
            self._attrs["source"] = source.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this InputStream.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this InputStream.


        :param kind: The kind of this InputStream.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def source(self) -> "InputStreamSource":
        """ Gets the source of this InputStream.
        """
        return InputStreamSource._from_dict(self._attrs["source"])

    @source.setter
    def source(self, source: "InputStreamSource"):
        """Sets the source of this InputStream.


        :param source: The source of this InputStream.
        :type: InputStreamSource
        """
        if source is None:
            raise ValueError("Invalid value for `source`, must not be `None`")
        self._attrs["source"] = source.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Offset_resetEnum(str, Enum):
    EARLIEST = "earliest"
    LATEST = "latest"

    @staticmethod
    def from_value(value: str):
        if value == "earliest":
            return Offset_resetEnum.EARLIEST
        if value == "latest":
            return Offset_resetEnum.LATEST


class KafkaInput(InputStreamSource):

    @staticmethod
    def _from_dict(model: dict) -> "KafkaInput":
        instance = KafkaInput.__new__(KafkaInput)
        instance._attrs = model
        return instance

    def __init__(self, topic: "str", offset_reset: "str" = 'latest', **extra):
        """KafkaInput"""

        self._attrs = dict()
        if topic is not None:
            self._attrs["topic"] = topic
        if offset_reset is not None:
            self._attrs["offsetReset"] = offset_reset
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def topic(self) -> "str":
        """ Gets the topic of this KafkaInput.
        """
        return self._attrs.get("topic")

    @topic.setter
    def topic(self, topic: "str"):
        """Sets the topic of this KafkaInput.


        :param topic: The topic of this KafkaInput.
        :type: str
        """
        if topic is None:
            raise ValueError("Invalid value for `topic`, must not be `None`")
        self._attrs["topic"] = topic

    @property
    def offset_reset(self) -> "Offset_resetEnum":
        """ Gets the offset_reset of this KafkaInput.
        """
        return Offset_resetEnum.from_value(self._attrs.get("offsetReset"))

    @offset_reset.setter
    def offset_reset(self, offset_reset: "str"):
        """Sets the offset_reset of this KafkaInput.


        :param offset_reset: The offset_reset of this KafkaInput.
        :type: str
        """
        if isinstance(offset_reset, Enum):
            self._attrs["offsetReset"] = offset_reset.value
        else:
            self._attrs["offsetReset"] = offset_reset  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class OutputStreamDestination(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "OutputStreamDestination":
        instance = OutputStreamDestination.__new__(OutputStreamDestination)
        instance._attrs = model
        return instance

    def __init__(self, topic: "str" = None, **extra):
        """OutputStreamDestination"""

        self._attrs = dict()
        if topic is not None:
            self._attrs["topic"] = topic
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def topic(self) -> "str":
        """ Gets the topic of this OutputStreamDestination.
        """
        return self._attrs.get("topic")

    @topic.setter
    def topic(self, topic: "str"):
        """Sets the topic of this OutputStreamDestination.


        :param topic: The topic of this OutputStreamDestination.
        :type: str
        """
        if topic is None:
            raise ValueError("Invalid value for `topic`, must not be `None`")
        self._attrs["topic"] = topic

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KafkaOutput(OutputStreamDestination):

    @staticmethod
    def _from_dict(model: dict) -> "KafkaOutput":
        instance = KafkaOutput.__new__(KafkaOutput)
        instance._attrs = model
        return instance

    def __init__(self, topic: "str", **extra):
        """KafkaOutput"""

        self._attrs = dict()
        if topic is not None:
            self._attrs["topic"] = topic
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def topic(self) -> "str":
        """ Gets the topic of this KafkaOutput.
        """
        return self._attrs.get("topic")

    @topic.setter
    def topic(self, topic: "str"):
        """Sets the topic of this KafkaOutput.


        :param topic: The topic of this KafkaOutput.
        :type: str
        """
        if topic is None:
            raise ValueError("Invalid value for `topic`, must not be `None`")
        self._attrs["topic"] = topic

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    EVENTS = "Events"

    @staticmethod
    def from_value(value: str):
        if value == "Events":
            return KindEnum.EVENTS


class OutputData(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "OutputData":
        instance = OutputData.__new__(OutputData)
        instance._attrs = model
        return instance

    def __init__(self, destination: "OutputDataDestination" = None, kind: "str" = None, **extra):
        """OutputData"""

        self._attrs = dict()
        if destination is not None:
            self._attrs["destination"] = destination.to_dict()
        if kind is not None:
            self._attrs["kind"] = kind
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def destination(self) -> "OutputDataDestination":
        """ Gets the destination of this OutputData.
        """
        return OutputDataDestination._from_dict(self._attrs["destination"])

    @destination.setter
    def destination(self, destination: "OutputDataDestination"):
        """Sets the destination of this OutputData.


        :param destination: The destination of this OutputData.
        :type: OutputDataDestination
        """
        self._attrs["destination"] = destination.to_dict()

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this OutputData.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this OutputData.


        :param kind: The kind of this OutputData.
        :type: str
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    KAFKA = "Kafka"

    @staticmethod
    def from_value(value: str):
        if value == "Kafka":
            return KindEnum.KAFKA


class OutputStream(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "OutputStream":
        instance = OutputStream.__new__(OutputStream)
        instance._attrs = model
        return instance

    def __init__(self, destination: "OutputStreamDestination", kind: "str", **extra):
        """OutputStream"""

        self._attrs = dict()
        if destination is not None:
            self._attrs["destination"] = destination.to_dict()
        if kind is not None:
            self._attrs["kind"] = kind
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def destination(self) -> "OutputStreamDestination":
        """ Gets the destination of this OutputStream.
        """
        return OutputStreamDestination._from_dict(self._attrs["destination"])

    @destination.setter
    def destination(self, destination: "OutputStreamDestination"):
        """Sets the destination of this OutputStream.


        :param destination: The destination of this OutputStream.
        :type: OutputStreamDestination
        """
        if destination is None:
            raise ValueError("Invalid value for `destination`, must not be `None`")
        self._attrs["destination"] = destination.to_dict()

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this OutputStream.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this OutputStream.


        :param kind: The kind of this OutputStream.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RawData(InputDataSource):

    @staticmethod
    def _from_dict(model: dict) -> "RawData":
        instance = RawData.__new__(RawData)
        instance._attrs = model
        return instance

    def __init__(self, data: "str" = None, **extra):
        """RawData"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "str":
        """ Gets the data of this RawData.
        A base-64 encoded CSV string.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "str"):
        """Sets the data of this RawData.

        A base-64 encoded CSV string.

        :param data: The data of this RawData.
        :type: str
        """
        self._attrs["data"] = data

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SPL(InputDataSource):

    @staticmethod
    def _from_dict(model: dict) -> "SPL":
        instance = SPL.__new__(SPL)
        instance._attrs = model
        return instance

    def __init__(self, query: "str", extract_all_fields: "bool" = None, max_time: "int" = None, module: "str" = None, query_parameters: "object" = None, **extra):
        """SPL"""

        self._attrs = dict()
        if query is not None:
            self._attrs["query"] = query
        if extract_all_fields is not None:
            self._attrs["extractAllFields"] = extract_all_fields
        if max_time is not None:
            self._attrs["maxTime"] = max_time
        if module is not None:
            self._attrs["module"] = module
        if query_parameters is not None:
            self._attrs["queryParameters"] = query_parameters
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def query(self) -> "str":
        """ Gets the query of this SPL.
        """
        return self._attrs.get("query")

    @query.setter
    def query(self, query: "str"):
        """Sets the query of this SPL.


        :param query: The query of this SPL.
        :type: str
        """
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")
        self._attrs["query"] = query

    @property
    def extract_all_fields(self) -> "bool":
        """ Gets the extract_all_fields of this SPL.
        Determine whether the Search service extracts all available fields in the data, including fields not mentioned in the SPL for the search job. Set to 'false' for better search performance.
        """
        return self._attrs.get("extractAllFields")

    @extract_all_fields.setter
    def extract_all_fields(self, extract_all_fields: "bool"):
        """Sets the extract_all_fields of this SPL.

        Determine whether the Search service extracts all available fields in the data, including fields not mentioned in the SPL for the search job. Set to 'false' for better search performance.

        :param extract_all_fields: The extract_all_fields of this SPL.
        :type: bool
        """
        self._attrs["extractAllFields"] = extract_all_fields

    @property
    def max_time(self) -> "int":
        """ Gets the max_time of this SPL.
        The number of seconds to run this search before finalizing.
        """
        return self._attrs.get("maxTime")

    @max_time.setter
    def max_time(self, max_time: "int"):
        """Sets the max_time of this SPL.

        The number of seconds to run this search before finalizing.

        :param max_time: The max_time of this SPL.
        :type: int
        """
        self._attrs["maxTime"] = max_time

    @property
    def module(self) -> "str":
        """ Gets the module of this SPL.
        The module to run the search in. The default module is used if a module is not specified.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this SPL.

        The module to run the search in. The default module is used if a module is not specified.

        :param module: The module of this SPL.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def query_parameters(self) -> "dict":
        """ Gets the query_parameters of this SPL.
        Represents parameters on the search job such as 'earliest' and 'latest'.
        """
        return self._attrs.get("queryParameters")

    @query_parameters.setter
    def query_parameters(self, query_parameters: "dict"):
        """Sets the query_parameters of this SPL.

        Represents parameters on the search job such as 'earliest' and 'latest'.

        :param query_parameters: The query_parameters of this SPL.
        :type: object
        """
        self._attrs["queryParameters"] = query_parameters

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ScoreReport(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ScoreReport":
        instance = ScoreReport.__new__(ScoreReport)
        instance._attrs = model
        return instance

    def __init__(self, **extra):
        """ScoreReport"""

        self._attrs = dict()
        for k, v in extra.items():
            self._attrs[k] = v

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    REGRESSION = "regression"
    CLASSIFICATION = "classification"
    CLUSTERING = "clustering"
    FORECASTING = "forecasting"

    @staticmethod
    def from_value(value: str):
        if value == "regression":
            return KindEnum.REGRESSION
        if value == "classification":
            return KindEnum.CLASSIFICATION
        if value == "clustering":
            return KindEnum.CLUSTERING
        if value == "forecasting":
            return KindEnum.FORECASTING


class Score(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Score":
        instance = Score.__new__(Score)
        instance._attrs = model
        return instance

    def __init__(self, kind: "str", report: "ScoreReport", **extra):
        """Score"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if report is not None:
            self._attrs["report"] = report.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this Score.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this Score.


        :param kind: The kind of this Score.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def report(self) -> "ScoreReport":
        """ Gets the report of this Score.
        """
        return ScoreReport._from_dict(self._attrs["report"])

    @report.setter
    def report(self, report: "ScoreReport"):
        """Sets the report of this Score.


        :param report: The report of this Score.
        :type: ScoreReport
        """
        if report is None:
            raise ValueError("Invalid value for `report`, must not be `None`")
        self._attrs["report"] = report.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TaskSummary(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TaskSummary":
        instance = TaskSummary.__new__(TaskSummary)
        instance._attrs = model
        return instance

    def __init__(self, algorithm: "str" = None, name: "str" = None, summary: "object" = None, **extra):
        """TaskSummary"""

        self._attrs = dict()
        if algorithm is not None:
            self._attrs["algorithm"] = algorithm
        if name is not None:
            self._attrs["name"] = name
        if summary is not None:
            self._attrs["summary"] = summary
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def algorithm(self) -> "str":
        """ Gets the algorithm of this TaskSummary.
        """
        return self._attrs.get("algorithm")

    @algorithm.setter
    def algorithm(self, algorithm: "str"):
        """Sets the algorithm of this TaskSummary.


        :param algorithm: The algorithm of this TaskSummary.
        :type: str
        """
        self._attrs["algorithm"] = algorithm

    @property
    def name(self) -> "str":
        """ Gets the name of this TaskSummary.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TaskSummary.


        :param name: The name of this TaskSummary.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def summary(self) -> "object":
        """ Gets the summary of this TaskSummary.
        Summary of the task, including but not limited to learned parameters and statistics.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "object"):
        """Sets the summary of this TaskSummary.

        Summary of the task, including but not limited to learned parameters and statistics.

        :param summary: The summary of this TaskSummary.
        :type: object
        """
        self._attrs["summary"] = summary

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowValidationScore(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowValidationScore":
        instance = WorkflowValidationScore.__new__(WorkflowValidationScore)
        instance._attrs = model
        return instance

    def __init__(self, test_score: "Score" = None, training_score: "Score" = None, **extra):
        """WorkflowValidationScore"""

        self._attrs = dict()
        if test_score is not None:
            self._attrs["testScore"] = test_score.to_dict()
        if training_score is not None:
            self._attrs["trainingScore"] = training_score.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def test_score(self) -> "Score":
        """ Gets the test_score of this WorkflowValidationScore.
        """
        return Score._from_dict(self._attrs["testScore"])

    @test_score.setter
    def test_score(self, test_score: "Score"):
        """Sets the test_score of this WorkflowValidationScore.


        :param test_score: The test_score of this WorkflowValidationScore.
        :type: Score
        """
        self._attrs["testScore"] = test_score.to_dict()

    @property
    def training_score(self) -> "Score":
        """ Gets the training_score of this WorkflowValidationScore.
        """
        return Score._from_dict(self._attrs["trainingScore"])

    @training_score.setter
    def training_score(self, training_score: "Score"):
        """Sets the training_score of this WorkflowValidationScore.


        :param training_score: The training_score of this WorkflowValidationScore.
        :type: Score
        """
        self._attrs["trainingScore"] = training_score.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TrainTestScore(WorkflowValidationScore):

    @staticmethod
    def _from_dict(model: dict) -> "TrainTestScore":
        instance = TrainTestScore.__new__(TrainTestScore)
        instance._attrs = model
        return instance

    def __init__(self, test_score: "Score" = None, training_score: "Score" = None, **extra):
        """TrainTestScore"""

        self._attrs = dict()
        if test_score is not None:
            self._attrs["testScore"] = test_score.to_dict()
        if training_score is not None:
            self._attrs["trainingScore"] = training_score.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def test_score(self) -> "Score":
        """ Gets the test_score of this TrainTestScore.
        """
        return Score._from_dict(self._attrs["testScore"])

    @test_score.setter
    def test_score(self, test_score: "Score"):
        """Sets the test_score of this TrainTestScore.


        :param test_score: The test_score of this TrainTestScore.
        :type: Score
        """
        self._attrs["testScore"] = test_score.to_dict()

    @property
    def training_score(self) -> "Score":
        """ Gets the training_score of this TrainTestScore.
        """
        return Score._from_dict(self._attrs["trainingScore"])

    @training_score.setter
    def training_score(self, training_score: "Score"):
        """Sets the training_score of this TrainTestScore.


        :param training_score: The training_score of this TrainTestScore.
        :type: Score
        """
        self._attrs["trainingScore"] = training_score.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TrainTestSplit(WorkflowValidationOption):

    @staticmethod
    def _from_dict(model: dict) -> "TrainTestSplit":
        instance = TrainTestSplit.__new__(TrainTestSplit)
        instance._attrs = model
        return instance

    def __init__(self, random_seed: "int" = 0, ratio: "float" = 0.8, stratified: "bool" = False, **extra):
        """TrainTestSplit"""

        self._attrs = dict()
        if random_seed is not None:
            self._attrs["randomSeed"] = random_seed
        if ratio is not None:
            self._attrs["ratio"] = ratio
        if stratified is not None:
            self._attrs["stratified"] = stratified
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def random_seed(self) -> "int":
        """ Gets the random_seed of this TrainTestSplit.
        Random state to shuffle and partition data.
        """
        return self._attrs.get("randomSeed")

    @random_seed.setter
    def random_seed(self, random_seed: "int"):
        """Sets the random_seed of this TrainTestSplit.

        Random state to shuffle and partition data.

        :param random_seed: The random_seed of this TrainTestSplit.
        :type: int
        """
        self._attrs["randomSeed"] = random_seed

    @property
    def ratio(self) -> "float":
        """ Gets the ratio of this TrainTestSplit.
        Ratio to split out training set and test set. For example, 0.8 means 80% of data for the training set and 20% for the test set.
        """
        return self._attrs.get("ratio")

    @ratio.setter
    def ratio(self, ratio: "float"):
        """Sets the ratio of this TrainTestSplit.

        Ratio to split out training set and test set. For example, 0.8 means 80% of data for the training set and 20% for the test set.

        :param ratio: The ratio of this TrainTestSplit.
        :type: float
        """
        self._attrs["ratio"] = ratio

    @property
    def stratified(self) -> "bool":
        """ Gets the stratified of this TrainTestSplit.
        Determine whether stratification is used in partitioning the data.
        """
        return self._attrs.get("stratified")

    @stratified.setter
    def stratified(self, stratified: "bool"):
        """Sets the stratified of this TrainTestSplit.

        Determine whether stratification is used in partitioning the data.

        :param stratified: The stratified of this TrainTestSplit.
        :type: bool
        """
        self._attrs["stratified"] = stratified

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Workflow(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Workflow":
        instance = Workflow.__new__(Workflow)
        instance._attrs = model
        return instance

    def __init__(self, tasks: "List[Task]", creation_time: "datetime" = None, id: "str" = None, name: "str" = None, **extra):
        """Workflow"""

        self._attrs = dict()
        if tasks is not None:
            self._attrs["tasks"] = tasks
        if creation_time is not None:
            self._attrs["creationTime"] = creation_time
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def tasks(self) -> "List[Task]":
        """ Gets the tasks of this Workflow.
        """
        return [Task._from_dict(i) for i in self._attrs.get("tasks")]

    @tasks.setter
    def tasks(self, tasks: "List[Task]"):
        """Sets the tasks of this Workflow.


        :param tasks: The tasks of this Workflow.
        :type: List[Task]
        """
        if tasks is None:
            raise ValueError("Invalid value for `tasks`, must not be `None`")
        self._attrs["tasks"] = tasks

    @property
    def creation_time(self) -> "datetime":
        """ Gets the creation_time of this Workflow.
        """
        return self._attrs.get("creationTime")

    @creation_time.setter
    def creation_time(self, creation_time: "datetime"):
        """Sets the creation_time of this Workflow.


        :param creation_time: The creation_time of this Workflow.
        :type: datetime
        """
        self._attrs["creationTime"] = creation_time

    @property
    def id(self) -> "str":
        """ Gets the id of this Workflow.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Workflow.


        :param id: The id of this Workflow.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this Workflow.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Workflow.


        :param name: The name of this Workflow.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    TRAINTEST = "TrainTest"
    CROSSVALIDATION = "CrossValidation"

    @staticmethod
    def from_value(value: str):
        if value == "TrainTest":
            return KindEnum.TRAINTEST
        if value == "CrossValidation":
            return KindEnum.CROSSVALIDATION


class WorkflowBuildValidationOption(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuildValidationOption":
        instance = WorkflowBuildValidationOption.__new__(WorkflowBuildValidationOption)
        instance._attrs = model
        return instance

    def __init__(self, kind: "str", option: "WorkflowValidationOption" = None, **extra):
        """WorkflowBuildValidationOption"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if option is not None:
            self._attrs["option"] = option.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this WorkflowBuildValidationOption.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this WorkflowBuildValidationOption.


        :param kind: The kind of this WorkflowBuildValidationOption.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def option(self) -> "WorkflowValidationOption":
        """ Gets the option of this WorkflowBuildValidationOption.
        """
        return WorkflowValidationOption._from_dict(self._attrs["option"])

    @option.setter
    def option(self, option: "WorkflowValidationOption"):
        """Sets the option of this WorkflowBuildValidationOption.


        :param option: The option of this WorkflowBuildValidationOption.
        :type: WorkflowValidationOption
        """
        self._attrs["option"] = option.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KindEnum(str, Enum):
    TRAINTEST = "TrainTest"
    CROSSVALIDATION = "CrossValidation"

    @staticmethod
    def from_value(value: str):
        if value == "TrainTest":
            return KindEnum.TRAINTEST
        if value == "CrossValidation":
            return KindEnum.CROSSVALIDATION


class WorkflowBuildValidationScore(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuildValidationScore":
        instance = WorkflowBuildValidationScore.__new__(WorkflowBuildValidationScore)
        instance._attrs = model
        return instance

    def __init__(self, kind: "str", score: "WorkflowValidationScore", **extra):
        """WorkflowBuildValidationScore"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if score is not None:
            self._attrs["score"] = score.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "KindEnum":
        """ Gets the kind of this WorkflowBuildValidationScore.
        """
        return KindEnum.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "str"):
        """Sets the kind of this WorkflowBuildValidationScore.


        :param kind: The kind of this WorkflowBuildValidationScore.
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def score(self) -> "WorkflowValidationScore":
        """ Gets the score of this WorkflowBuildValidationScore.
        """
        return WorkflowValidationScore._from_dict(self._attrs["score"])

    @score.setter
    def score(self, score: "WorkflowValidationScore"):
        """Sets the score of this WorkflowBuildValidationScore.


        :param score: The score of this WorkflowBuildValidationScore.
        :type: WorkflowValidationScore
        """
        if score is None:
            raise ValueError("Invalid value for `score`, must not be `None`")
        self._attrs["score"] = score.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    RUNNING = "running"
    FAILED = "failed"
    SUCCESS = "success"
    SCHEDULED = "scheduled"

    @staticmethod
    def from_value(value: str):
        if value == "running":
            return StatusEnum.RUNNING
        if value == "failed":
            return StatusEnum.FAILED
        if value == "success":
            return StatusEnum.SUCCESS
        if value == "scheduled":
            return StatusEnum.SCHEDULED


class WorkflowBuild(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuild":
        instance = WorkflowBuild.__new__(WorkflowBuild)
        instance._attrs = model
        return instance

    def __init__(self, input: "InputData", creation_time: "datetime" = None, end_time: "datetime" = None, id: "str" = None, name: "str" = None, output: "OutputData" = None, pipeline_summary: "List[TaskSummary]" = None, start_time: "datetime" = None, status: "str" = None, timeout_secs: "int" = 86400, training_score: "Score" = None, validation_option: "WorkflowBuildValidationOption" = None, validation_score: "WorkflowBuildValidationScore" = None, workflow: "Workflow" = None, **extra):
        """WorkflowBuild"""

        self._attrs = dict()
        if input is not None:
            self._attrs["input"] = input.to_dict()
        if creation_time is not None:
            self._attrs["creationTime"] = creation_time
        if end_time is not None:
            self._attrs["endTime"] = end_time
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if output is not None:
            self._attrs["output"] = output.to_dict()
        if pipeline_summary is not None:
            self._attrs["pipelineSummary"] = pipeline_summary
        if start_time is not None:
            self._attrs["startTime"] = start_time
        if status is not None:
            self._attrs["status"] = status
        if timeout_secs is not None:
            self._attrs["timeoutSecs"] = timeout_secs
        if training_score is not None:
            self._attrs["trainingScore"] = training_score.to_dict()
        if validation_option is not None:
            self._attrs["validationOption"] = validation_option.to_dict()
        if validation_score is not None:
            self._attrs["validationScore"] = validation_score.to_dict()
        if workflow is not None:
            self._attrs["workflow"] = workflow.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def input(self) -> "InputData":
        """ Gets the input of this WorkflowBuild.
        """
        return InputData._from_dict(self._attrs["input"])

    @input.setter
    def input(self, input: "InputData"):
        """Sets the input of this WorkflowBuild.


        :param input: The input of this WorkflowBuild.
        :type: InputData
        """
        if input is None:
            raise ValueError("Invalid value for `input`, must not be `None`")
        self._attrs["input"] = input.to_dict()

    @property
    def creation_time(self) -> "datetime":
        """ Gets the creation_time of this WorkflowBuild.
        """
        return self._attrs.get("creationTime")

    @creation_time.setter
    def creation_time(self, creation_time: "datetime"):
        """Sets the creation_time of this WorkflowBuild.


        :param creation_time: The creation_time of this WorkflowBuild.
        :type: datetime
        """
        self._attrs["creationTime"] = creation_time

    @property
    def end_time(self) -> "datetime":
        """ Gets the end_time of this WorkflowBuild.
        """
        return self._attrs.get("endTime")

    @end_time.setter
    def end_time(self, end_time: "datetime"):
        """Sets the end_time of this WorkflowBuild.


        :param end_time: The end_time of this WorkflowBuild.
        :type: datetime
        """
        self._attrs["endTime"] = end_time

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowBuild.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowBuild.


        :param id: The id of this WorkflowBuild.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowBuild.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowBuild.


        :param name: The name of this WorkflowBuild.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def output(self) -> "OutputData":
        """ Gets the output of this WorkflowBuild.
        """
        return OutputData._from_dict(self._attrs["output"])

    @output.setter
    def output(self, output: "OutputData"):
        """Sets the output of this WorkflowBuild.


        :param output: The output of this WorkflowBuild.
        :type: OutputData
        """
        self._attrs["output"] = output.to_dict()

    @property
    def pipeline_summary(self) -> "List[TaskSummary]":
        """ Gets the pipeline_summary of this WorkflowBuild.
        """
        return [TaskSummary._from_dict(i) for i in self._attrs.get("pipelineSummary")]

    @pipeline_summary.setter
    def pipeline_summary(self, pipeline_summary: "List[TaskSummary]"):
        """Sets the pipeline_summary of this WorkflowBuild.


        :param pipeline_summary: The pipeline_summary of this WorkflowBuild.
        :type: List[TaskSummary]
        """
        self._attrs["pipelineSummary"] = pipeline_summary

    @property
    def start_time(self) -> "datetime":
        """ Gets the start_time of this WorkflowBuild.
        """
        return self._attrs.get("startTime")

    @start_time.setter
    def start_time(self, start_time: "datetime"):
        """Sets the start_time of this WorkflowBuild.


        :param start_time: The start_time of this WorkflowBuild.
        :type: datetime
        """
        self._attrs["startTime"] = start_time

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this WorkflowBuild.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowBuild.


        :param status: The status of this WorkflowBuild.
        :type: str
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    @property
    def timeout_secs(self) -> "int":
        """ Gets the timeout_secs of this WorkflowBuild.
        Number of seconds before a workflow build times out.
        """
        return self._attrs.get("timeoutSecs")

    @timeout_secs.setter
    def timeout_secs(self, timeout_secs: "int"):
        """Sets the timeout_secs of this WorkflowBuild.

        Number of seconds before a workflow build times out.

        :param timeout_secs: The timeout_secs of this WorkflowBuild.
        :type: int
        """
        self._attrs["timeoutSecs"] = timeout_secs

    @property
    def training_score(self) -> "Score":
        """ Gets the training_score of this WorkflowBuild.
        """
        return Score._from_dict(self._attrs["trainingScore"])

    @training_score.setter
    def training_score(self, training_score: "Score"):
        """Sets the training_score of this WorkflowBuild.


        :param training_score: The training_score of this WorkflowBuild.
        :type: Score
        """
        self._attrs["trainingScore"] = training_score.to_dict()

    @property
    def validation_option(self) -> "WorkflowBuildValidationOption":
        """ Gets the validation_option of this WorkflowBuild.
        """
        return WorkflowBuildValidationOption._from_dict(self._attrs["validationOption"])

    @validation_option.setter
    def validation_option(self, validation_option: "WorkflowBuildValidationOption"):
        """Sets the validation_option of this WorkflowBuild.


        :param validation_option: The validation_option of this WorkflowBuild.
        :type: WorkflowBuildValidationOption
        """
        self._attrs["validationOption"] = validation_option.to_dict()

    @property
    def validation_score(self) -> "WorkflowBuildValidationScore":
        """ Gets the validation_score of this WorkflowBuild.
        """
        return WorkflowBuildValidationScore._from_dict(self._attrs["validationScore"])

    @validation_score.setter
    def validation_score(self, validation_score: "WorkflowBuildValidationScore"):
        """Sets the validation_score of this WorkflowBuild.


        :param validation_score: The validation_score of this WorkflowBuild.
        :type: WorkflowBuildValidationScore
        """
        self._attrs["validationScore"] = validation_score.to_dict()

    @property
    def workflow(self) -> "Workflow":
        """ Gets the workflow of this WorkflowBuild.
        """
        return Workflow._from_dict(self._attrs["workflow"])

    @workflow.setter
    def workflow(self, workflow: "Workflow"):
        """Sets the workflow of this WorkflowBuild.


        :param workflow: The workflow of this WorkflowBuild.
        :type: Workflow
        """
        self._attrs["workflow"] = workflow.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowManagerErrors(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowManagerErrors":
        instance = WorkflowManagerErrors.__new__(WorkflowManagerErrors)
        instance._attrs = model
        return instance

    def __init__(self, message: "str" = None, **extra):
        """WorkflowManagerErrors"""

        self._attrs = dict()
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def message(self) -> "str":
        """ Gets the message of this WorkflowManagerErrors.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this WorkflowManagerErrors.


        :param message: The message of this WorkflowManagerErrors.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowBuildError(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuildError":
        instance = WorkflowBuildError.__new__(WorkflowBuildError)
        instance._attrs = model
        return instance

    def __init__(self, id: "str", workflow_id: "str", executor_errors: "List[ExecutorErrors]" = None, request_id: "str" = None, workflow_manager_errors: "List[WorkflowManagerErrors]" = None, **extra):
        """WorkflowBuildError"""

        self._attrs = dict()
        if id is not None:
            self._attrs["id"] = id
        if workflow_id is not None:
            self._attrs["workflowId"] = workflow_id
        if executor_errors is not None:
            self._attrs["executorErrors"] = executor_errors
        if request_id is not None:
            self._attrs["requestId"] = request_id
        if workflow_manager_errors is not None:
            self._attrs["workflowManagerErrors"] = workflow_manager_errors
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowBuildError.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowBuildError.


        :param id: The id of this WorkflowBuildError.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def workflow_id(self) -> "str":
        """ Gets the workflow_id of this WorkflowBuildError.
        """
        return self._attrs.get("workflowId")

    @workflow_id.setter
    def workflow_id(self, workflow_id: "str"):
        """Sets the workflow_id of this WorkflowBuildError.


        :param workflow_id: The workflow_id of this WorkflowBuildError.
        :type: str
        """
        if workflow_id is None:
            raise ValueError("Invalid value for `workflow_id`, must not be `None`")
        self._attrs["workflowId"] = workflow_id

    @property
    def executor_errors(self) -> "List[ExecutorErrors]":
        """ Gets the executor_errors of this WorkflowBuildError.
        """
        return [ExecutorErrors._from_dict(i) for i in self._attrs.get("executorErrors")]

    @executor_errors.setter
    def executor_errors(self, executor_errors: "List[ExecutorErrors]"):
        """Sets the executor_errors of this WorkflowBuildError.


        :param executor_errors: The executor_errors of this WorkflowBuildError.
        :type: List[ExecutorErrors]
        """
        self._attrs["executorErrors"] = executor_errors

    @property
    def request_id(self) -> "str":
        """ Gets the request_id of this WorkflowBuildError.
        """
        return self._attrs.get("requestId")

    @request_id.setter
    def request_id(self, request_id: "str"):
        """Sets the request_id of this WorkflowBuildError.


        :param request_id: The request_id of this WorkflowBuildError.
        :type: str
        """
        self._attrs["requestId"] = request_id

    @property
    def workflow_manager_errors(self) -> "List[WorkflowManagerErrors]":
        """ Gets the workflow_manager_errors of this WorkflowBuildError.
        """
        return [WorkflowManagerErrors._from_dict(i) for i in self._attrs.get("workflowManagerErrors")]

    @workflow_manager_errors.setter
    def workflow_manager_errors(self, workflow_manager_errors: "List[WorkflowManagerErrors]"):
        """Sets the workflow_manager_errors of this WorkflowBuildError.


        :param workflow_manager_errors: The workflow_manager_errors of this WorkflowBuildError.
        :type: List[WorkflowManagerErrors]
        """
        self._attrs["workflowManagerErrors"] = workflow_manager_errors

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowManagerLogs(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowManagerLogs":
        instance = WorkflowManagerLogs.__new__(WorkflowManagerLogs)
        instance._attrs = model
        return instance

    def __init__(self, level: "str" = None, message: "str" = None, **extra):
        """WorkflowManagerLogs"""

        self._attrs = dict()
        if level is not None:
            self._attrs["level"] = level
        if message is not None:
            self._attrs["message"] = message
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def level(self) -> "str":
        """ Gets the level of this WorkflowManagerLogs.
        """
        return self._attrs.get("level")

    @level.setter
    def level(self, level: "str"):
        """Sets the level of this WorkflowManagerLogs.


        :param level: The level of this WorkflowManagerLogs.
        :type: str
        """
        self._attrs["level"] = level

    @property
    def message(self) -> "str":
        """ Gets the message of this WorkflowManagerLogs.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this WorkflowManagerLogs.


        :param message: The message of this WorkflowManagerLogs.
        :type: str
        """
        self._attrs["message"] = message

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowBuildLog(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowBuildLog":
        instance = WorkflowBuildLog.__new__(WorkflowBuildLog)
        instance._attrs = model
        return instance

    def __init__(self, id: "str", workflow_id: "str", executor_logs: "List[ExecutorLogs]" = None, request_id: "str" = None, workflow_manager_logs: "List[WorkflowManagerLogs]" = None, **extra):
        """WorkflowBuildLog"""

        self._attrs = dict()
        if id is not None:
            self._attrs["id"] = id
        if workflow_id is not None:
            self._attrs["workflowId"] = workflow_id
        if executor_logs is not None:
            self._attrs["executorLogs"] = executor_logs
        if request_id is not None:
            self._attrs["requestId"] = request_id
        if workflow_manager_logs is not None:
            self._attrs["workflowManagerLogs"] = workflow_manager_logs
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowBuildLog.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowBuildLog.


        :param id: The id of this WorkflowBuildLog.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def workflow_id(self) -> "str":
        """ Gets the workflow_id of this WorkflowBuildLog.
        """
        return self._attrs.get("workflowId")

    @workflow_id.setter
    def workflow_id(self, workflow_id: "str"):
        """Sets the workflow_id of this WorkflowBuildLog.


        :param workflow_id: The workflow_id of this WorkflowBuildLog.
        :type: str
        """
        if workflow_id is None:
            raise ValueError("Invalid value for `workflow_id`, must not be `None`")
        self._attrs["workflowId"] = workflow_id

    @property
    def executor_logs(self) -> "List[ExecutorLogs]":
        """ Gets the executor_logs of this WorkflowBuildLog.
        """
        return [ExecutorLogs._from_dict(i) for i in self._attrs.get("executorLogs")]

    @executor_logs.setter
    def executor_logs(self, executor_logs: "List[ExecutorLogs]"):
        """Sets the executor_logs of this WorkflowBuildLog.


        :param executor_logs: The executor_logs of this WorkflowBuildLog.
        :type: List[ExecutorLogs]
        """
        self._attrs["executorLogs"] = executor_logs

    @property
    def request_id(self) -> "str":
        """ Gets the request_id of this WorkflowBuildLog.
        """
        return self._attrs.get("requestId")

    @request_id.setter
    def request_id(self, request_id: "str"):
        """Sets the request_id of this WorkflowBuildLog.


        :param request_id: The request_id of this WorkflowBuildLog.
        :type: str
        """
        self._attrs["requestId"] = request_id

    @property
    def workflow_manager_logs(self) -> "List[WorkflowManagerLogs]":
        """ Gets the workflow_manager_logs of this WorkflowBuildLog.
        """
        return [WorkflowManagerLogs._from_dict(i) for i in self._attrs.get("workflowManagerLogs")]

    @workflow_manager_logs.setter
    def workflow_manager_logs(self, workflow_manager_logs: "List[WorkflowManagerLogs]"):
        """Sets the workflow_manager_logs of this WorkflowBuildLog.


        :param workflow_manager_logs: The workflow_manager_logs of this WorkflowBuildLog.
        :type: List[WorkflowManagerLogs]
        """
        self._attrs["workflowManagerLogs"] = workflow_manager_logs

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    RUNNING = "running"
    FAILED = "failed"
    SUCCESS = "success"
    SCHEDULED = "scheduled"
    INITIALIZING = "initializing"

    @staticmethod
    def from_value(value: str):
        if value == "running":
            return StatusEnum.RUNNING
        if value == "failed":
            return StatusEnum.FAILED
        if value == "success":
            return StatusEnum.SUCCESS
        if value == "scheduled":
            return StatusEnum.SCHEDULED
        if value == "initializing":
            return StatusEnum.INITIALIZING


class WorkflowDeployment(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowDeployment":
        instance = WorkflowDeployment.__new__(WorkflowDeployment)
        instance._attrs = model
        return instance

    def __init__(self, spec: "DeploymentSpec", creation_time: "datetime" = None, end_time: "datetime" = None, id: "str" = None, name: "str" = None, start_time: "datetime" = None, status: "str" = None, workflow_build: "WorkflowBuild" = None, **extra):
        """WorkflowDeployment"""

        self._attrs = dict()
        if spec is not None:
            self._attrs["spec"] = spec.to_dict()
        if creation_time is not None:
            self._attrs["creationTime"] = creation_time
        if end_time is not None:
            self._attrs["endTime"] = end_time
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if start_time is not None:
            self._attrs["startTime"] = start_time
        if status is not None:
            self._attrs["status"] = status
        if workflow_build is not None:
            self._attrs["workflowBuild"] = workflow_build.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def spec(self) -> "DeploymentSpec":
        """ Gets the spec of this WorkflowDeployment.
        """
        return DeploymentSpec._from_dict(self._attrs["spec"])

    @spec.setter
    def spec(self, spec: "DeploymentSpec"):
        """Sets the spec of this WorkflowDeployment.


        :param spec: The spec of this WorkflowDeployment.
        :type: DeploymentSpec
        """
        if spec is None:
            raise ValueError("Invalid value for `spec`, must not be `None`")
        self._attrs["spec"] = spec.to_dict()

    @property
    def creation_time(self) -> "datetime":
        """ Gets the creation_time of this WorkflowDeployment.
        """
        return self._attrs.get("creationTime")

    @creation_time.setter
    def creation_time(self, creation_time: "datetime"):
        """Sets the creation_time of this WorkflowDeployment.


        :param creation_time: The creation_time of this WorkflowDeployment.
        :type: datetime
        """
        self._attrs["creationTime"] = creation_time

    @property
    def end_time(self) -> "datetime":
        """ Gets the end_time of this WorkflowDeployment.
        """
        return self._attrs.get("endTime")

    @end_time.setter
    def end_time(self, end_time: "datetime"):
        """Sets the end_time of this WorkflowDeployment.


        :param end_time: The end_time of this WorkflowDeployment.
        :type: datetime
        """
        self._attrs["endTime"] = end_time

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowDeployment.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowDeployment.


        :param id: The id of this WorkflowDeployment.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowDeployment.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowDeployment.


        :param name: The name of this WorkflowDeployment.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def start_time(self) -> "datetime":
        """ Gets the start_time of this WorkflowDeployment.
        """
        return self._attrs.get("startTime")

    @start_time.setter
    def start_time(self, start_time: "datetime"):
        """Sets the start_time of this WorkflowDeployment.


        :param start_time: The start_time of this WorkflowDeployment.
        :type: datetime
        """
        self._attrs["startTime"] = start_time

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this WorkflowDeployment.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowDeployment.


        :param status: The status of this WorkflowDeployment.
        :type: str
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    @property
    def workflow_build(self) -> "WorkflowBuild":
        """ Gets the workflow_build of this WorkflowDeployment.
        """
        return WorkflowBuild._from_dict(self._attrs["workflowBuild"])

    @workflow_build.setter
    def workflow_build(self, workflow_build: "WorkflowBuild"):
        """Sets the workflow_build of this WorkflowDeployment.


        :param workflow_build: The workflow_build of this WorkflowDeployment.
        :type: WorkflowBuild
        """
        self._attrs["workflowBuild"] = workflow_build.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowDeploymentError(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowDeploymentError":
        instance = WorkflowDeploymentError.__new__(WorkflowDeploymentError)
        instance._attrs = model
        return instance

    def __init__(self, build_id: "str", id: "str", workflow_id: "str", executor_errors: "List[ExecutorErrors]" = None, request_id: "str" = None, workflow_manager_errors: "List[WorkflowManagerErrors]" = None, **extra):
        """WorkflowDeploymentError"""

        self._attrs = dict()
        if build_id is not None:
            self._attrs["buildId"] = build_id
        if id is not None:
            self._attrs["id"] = id
        if workflow_id is not None:
            self._attrs["workflowId"] = workflow_id
        if executor_errors is not None:
            self._attrs["executorErrors"] = executor_errors
        if request_id is not None:
            self._attrs["requestId"] = request_id
        if workflow_manager_errors is not None:
            self._attrs["workflowManagerErrors"] = workflow_manager_errors
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def build_id(self) -> "str":
        """ Gets the build_id of this WorkflowDeploymentError.
        """
        return self._attrs.get("buildId")

    @build_id.setter
    def build_id(self, build_id: "str"):
        """Sets the build_id of this WorkflowDeploymentError.


        :param build_id: The build_id of this WorkflowDeploymentError.
        :type: str
        """
        if build_id is None:
            raise ValueError("Invalid value for `build_id`, must not be `None`")
        self._attrs["buildId"] = build_id

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowDeploymentError.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowDeploymentError.


        :param id: The id of this WorkflowDeploymentError.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def workflow_id(self) -> "str":
        """ Gets the workflow_id of this WorkflowDeploymentError.
        """
        return self._attrs.get("workflowId")

    @workflow_id.setter
    def workflow_id(self, workflow_id: "str"):
        """Sets the workflow_id of this WorkflowDeploymentError.


        :param workflow_id: The workflow_id of this WorkflowDeploymentError.
        :type: str
        """
        if workflow_id is None:
            raise ValueError("Invalid value for `workflow_id`, must not be `None`")
        self._attrs["workflowId"] = workflow_id

    @property
    def executor_errors(self) -> "List[ExecutorErrors]":
        """ Gets the executor_errors of this WorkflowDeploymentError.
        """
        return [ExecutorErrors._from_dict(i) for i in self._attrs.get("executorErrors")]

    @executor_errors.setter
    def executor_errors(self, executor_errors: "List[ExecutorErrors]"):
        """Sets the executor_errors of this WorkflowDeploymentError.


        :param executor_errors: The executor_errors of this WorkflowDeploymentError.
        :type: List[ExecutorErrors]
        """
        self._attrs["executorErrors"] = executor_errors

    @property
    def request_id(self) -> "str":
        """ Gets the request_id of this WorkflowDeploymentError.
        """
        return self._attrs.get("requestId")

    @request_id.setter
    def request_id(self, request_id: "str"):
        """Sets the request_id of this WorkflowDeploymentError.


        :param request_id: The request_id of this WorkflowDeploymentError.
        :type: str
        """
        self._attrs["requestId"] = request_id

    @property
    def workflow_manager_errors(self) -> "List[WorkflowManagerErrors]":
        """ Gets the workflow_manager_errors of this WorkflowDeploymentError.
        """
        return [WorkflowManagerErrors._from_dict(i) for i in self._attrs.get("workflowManagerErrors")]

    @workflow_manager_errors.setter
    def workflow_manager_errors(self, workflow_manager_errors: "List[WorkflowManagerErrors]"):
        """Sets the workflow_manager_errors of this WorkflowDeploymentError.


        :param workflow_manager_errors: The workflow_manager_errors of this WorkflowDeploymentError.
        :type: List[WorkflowManagerErrors]
        """
        self._attrs["workflowManagerErrors"] = workflow_manager_errors

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowDeploymentLog(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowDeploymentLog":
        instance = WorkflowDeploymentLog.__new__(WorkflowDeploymentLog)
        instance._attrs = model
        return instance

    def __init__(self, build_id: "str", id: "str", workflow_id: "str", executor_logs: "List[ExecutorLogs]" = None, request_id: "str" = None, workflow_manager_logs: "List[WorkflowManagerLogs]" = None, **extra):
        """WorkflowDeploymentLog"""

        self._attrs = dict()
        if build_id is not None:
            self._attrs["buildId"] = build_id
        if id is not None:
            self._attrs["id"] = id
        if workflow_id is not None:
            self._attrs["workflowId"] = workflow_id
        if executor_logs is not None:
            self._attrs["executorLogs"] = executor_logs
        if request_id is not None:
            self._attrs["requestId"] = request_id
        if workflow_manager_logs is not None:
            self._attrs["workflowManagerLogs"] = workflow_manager_logs
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def build_id(self) -> "str":
        """ Gets the build_id of this WorkflowDeploymentLog.
        """
        return self._attrs.get("buildId")

    @build_id.setter
    def build_id(self, build_id: "str"):
        """Sets the build_id of this WorkflowDeploymentLog.


        :param build_id: The build_id of this WorkflowDeploymentLog.
        :type: str
        """
        if build_id is None:
            raise ValueError("Invalid value for `build_id`, must not be `None`")
        self._attrs["buildId"] = build_id

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowDeploymentLog.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowDeploymentLog.


        :param id: The id of this WorkflowDeploymentLog.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def workflow_id(self) -> "str":
        """ Gets the workflow_id of this WorkflowDeploymentLog.
        """
        return self._attrs.get("workflowId")

    @workflow_id.setter
    def workflow_id(self, workflow_id: "str"):
        """Sets the workflow_id of this WorkflowDeploymentLog.


        :param workflow_id: The workflow_id of this WorkflowDeploymentLog.
        :type: str
        """
        if workflow_id is None:
            raise ValueError("Invalid value for `workflow_id`, must not be `None`")
        self._attrs["workflowId"] = workflow_id

    @property
    def executor_logs(self) -> "List[ExecutorLogs]":
        """ Gets the executor_logs of this WorkflowDeploymentLog.
        """
        return [ExecutorLogs._from_dict(i) for i in self._attrs.get("executorLogs")]

    @executor_logs.setter
    def executor_logs(self, executor_logs: "List[ExecutorLogs]"):
        """Sets the executor_logs of this WorkflowDeploymentLog.


        :param executor_logs: The executor_logs of this WorkflowDeploymentLog.
        :type: List[ExecutorLogs]
        """
        self._attrs["executorLogs"] = executor_logs

    @property
    def request_id(self) -> "str":
        """ Gets the request_id of this WorkflowDeploymentLog.
        """
        return self._attrs.get("requestId")

    @request_id.setter
    def request_id(self, request_id: "str"):
        """Sets the request_id of this WorkflowDeploymentLog.


        :param request_id: The request_id of this WorkflowDeploymentLog.
        :type: str
        """
        self._attrs["requestId"] = request_id

    @property
    def workflow_manager_logs(self) -> "List[WorkflowManagerLogs]":
        """ Gets the workflow_manager_logs of this WorkflowDeploymentLog.
        """
        return [WorkflowManagerLogs._from_dict(i) for i in self._attrs.get("workflowManagerLogs")]

    @workflow_manager_logs.setter
    def workflow_manager_logs(self, workflow_manager_logs: "List[WorkflowManagerLogs]"):
        """Sets the workflow_manager_logs of this WorkflowDeploymentLog.


        :param workflow_manager_logs: The workflow_manager_logs of this WorkflowDeploymentLog.
        :type: List[WorkflowManagerLogs]
        """
        self._attrs["workflowManagerLogs"] = workflow_manager_logs

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowInference(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowInference":
        instance = WorkflowInference.__new__(WorkflowInference)
        instance._attrs = model
        return instance

    def __init__(self, input: "str", output: "str" = None, **extra):
        """WorkflowInference"""

        self._attrs = dict()
        if input is not None:
            self._attrs["input"] = input
        if output is not None:
            self._attrs["output"] = output
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def input(self) -> "str":
        """ Gets the input of this WorkflowInference.
        """
        return self._attrs.get("input")

    @input.setter
    def input(self, input: "str"):
        """Sets the input of this WorkflowInference.


        :param input: The input of this WorkflowInference.
        :type: str
        """
        if input is None:
            raise ValueError("Invalid value for `input`, must not be `None`")
        self._attrs["input"] = input

    @property
    def output(self) -> "str":
        """ Gets the output of this WorkflowInference.
        """
        return self._attrs.get("output")

    @output.setter
    def output(self, output: "str"):
        """Sets the output of this WorkflowInference.


        :param output: The output of this WorkflowInference.
        :type: str
        """
        self._attrs["output"] = output

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    RUNNING = "running"
    FAILED = "failed"
    SUCCESS = "success"
    SCHEDULED = "scheduled"

    @staticmethod
    def from_value(value: str):
        if value == "running":
            return StatusEnum.RUNNING
        if value == "failed":
            return StatusEnum.FAILED
        if value == "success":
            return StatusEnum.SUCCESS
        if value == "scheduled":
            return StatusEnum.SCHEDULED


class WorkflowRun(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowRun":
        instance = WorkflowRun.__new__(WorkflowRun)
        instance._attrs = model
        return instance

    def __init__(self, input: "InputData", output: "OutputData", creation_time: "datetime" = None, end_time: "datetime" = None, evaluate: "bool" = True, id: "str" = None, name: "str" = None, prediction_score: "Score" = None, start_time: "datetime" = None, status: "str" = None, timeout_secs: "int" = 86400, workflow_build: "WorkflowBuild" = None, **extra):
        """WorkflowRun"""

        self._attrs = dict()
        if input is not None:
            self._attrs["input"] = input.to_dict()
        if output is not None:
            self._attrs["output"] = output.to_dict()
        if creation_time is not None:
            self._attrs["creationTime"] = creation_time
        if end_time is not None:
            self._attrs["endTime"] = end_time
        if evaluate is not None:
            self._attrs["evaluate"] = evaluate
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if prediction_score is not None:
            self._attrs["predictionScore"] = prediction_score.to_dict()
        if start_time is not None:
            self._attrs["startTime"] = start_time
        if status is not None:
            self._attrs["status"] = status
        if timeout_secs is not None:
            self._attrs["timeoutSecs"] = timeout_secs
        if workflow_build is not None:
            self._attrs["workflowBuild"] = workflow_build.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def input(self) -> "InputData":
        """ Gets the input of this WorkflowRun.
        """
        return InputData._from_dict(self._attrs["input"])

    @input.setter
    def input(self, input: "InputData"):
        """Sets the input of this WorkflowRun.


        :param input: The input of this WorkflowRun.
        :type: InputData
        """
        if input is None:
            raise ValueError("Invalid value for `input`, must not be `None`")
        self._attrs["input"] = input.to_dict()

    @property
    def output(self) -> "OutputData":
        """ Gets the output of this WorkflowRun.
        """
        return OutputData._from_dict(self._attrs["output"])

    @output.setter
    def output(self, output: "OutputData"):
        """Sets the output of this WorkflowRun.


        :param output: The output of this WorkflowRun.
        :type: OutputData
        """
        if output is None:
            raise ValueError("Invalid value for `output`, must not be `None`")
        self._attrs["output"] = output.to_dict()

    @property
    def creation_time(self) -> "datetime":
        """ Gets the creation_time of this WorkflowRun.
        """
        return self._attrs.get("creationTime")

    @creation_time.setter
    def creation_time(self, creation_time: "datetime"):
        """Sets the creation_time of this WorkflowRun.


        :param creation_time: The creation_time of this WorkflowRun.
        :type: datetime
        """
        self._attrs["creationTime"] = creation_time

    @property
    def end_time(self) -> "datetime":
        """ Gets the end_time of this WorkflowRun.
        """
        return self._attrs.get("endTime")

    @end_time.setter
    def end_time(self, end_time: "datetime"):
        """Sets the end_time of this WorkflowRun.


        :param end_time: The end_time of this WorkflowRun.
        :type: datetime
        """
        self._attrs["endTime"] = end_time

    @property
    def evaluate(self) -> "bool":
        """ Gets the evaluate of this WorkflowRun.
        Determine whether to evaluate the prediction.
        """
        return self._attrs.get("evaluate")

    @evaluate.setter
    def evaluate(self, evaluate: "bool"):
        """Sets the evaluate of this WorkflowRun.

        Determine whether to evaluate the prediction.

        :param evaluate: The evaluate of this WorkflowRun.
        :type: bool
        """
        self._attrs["evaluate"] = evaluate

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowRun.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowRun.


        :param id: The id of this WorkflowRun.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowRun.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowRun.


        :param name: The name of this WorkflowRun.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def prediction_score(self) -> "Score":
        """ Gets the prediction_score of this WorkflowRun.
        """
        return Score._from_dict(self._attrs["predictionScore"])

    @prediction_score.setter
    def prediction_score(self, prediction_score: "Score"):
        """Sets the prediction_score of this WorkflowRun.


        :param prediction_score: The prediction_score of this WorkflowRun.
        :type: Score
        """
        self._attrs["predictionScore"] = prediction_score.to_dict()

    @property
    def start_time(self) -> "datetime":
        """ Gets the start_time of this WorkflowRun.
        """
        return self._attrs.get("startTime")

    @start_time.setter
    def start_time(self, start_time: "datetime"):
        """Sets the start_time of this WorkflowRun.


        :param start_time: The start_time of this WorkflowRun.
        :type: datetime
        """
        self._attrs["startTime"] = start_time

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this WorkflowRun.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowRun.


        :param status: The status of this WorkflowRun.
        :type: str
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    @property
    def timeout_secs(self) -> "int":
        """ Gets the timeout_secs of this WorkflowRun.
        Number of seconds before a workflow run times out.
        """
        return self._attrs.get("timeoutSecs")

    @timeout_secs.setter
    def timeout_secs(self, timeout_secs: "int"):
        """Sets the timeout_secs of this WorkflowRun.

        Number of seconds before a workflow run times out.

        :param timeout_secs: The timeout_secs of this WorkflowRun.
        :type: int
        """
        self._attrs["timeoutSecs"] = timeout_secs

    @property
    def workflow_build(self) -> "WorkflowBuild":
        """ Gets the workflow_build of this WorkflowRun.
        """
        return WorkflowBuild._from_dict(self._attrs["workflowBuild"])

    @workflow_build.setter
    def workflow_build(self, workflow_build: "WorkflowBuild"):
        """Sets the workflow_build of this WorkflowRun.


        :param workflow_build: The workflow_build of this WorkflowRun.
        :type: WorkflowBuild
        """
        self._attrs["workflowBuild"] = workflow_build.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowRunError(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowRunError":
        instance = WorkflowRunError.__new__(WorkflowRunError)
        instance._attrs = model
        return instance

    def __init__(self, build_id: "str", id: "str", workflow_id: "str", executor_errors: "List[ExecutorErrors]" = None, request_id: "str" = None, workflow_manager_errors: "List[WorkflowManagerErrors]" = None, **extra):
        """WorkflowRunError"""

        self._attrs = dict()
        if build_id is not None:
            self._attrs["buildId"] = build_id
        if id is not None:
            self._attrs["id"] = id
        if workflow_id is not None:
            self._attrs["workflowId"] = workflow_id
        if executor_errors is not None:
            self._attrs["executorErrors"] = executor_errors
        if request_id is not None:
            self._attrs["requestId"] = request_id
        if workflow_manager_errors is not None:
            self._attrs["workflowManagerErrors"] = workflow_manager_errors
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def build_id(self) -> "str":
        """ Gets the build_id of this WorkflowRunError.
        """
        return self._attrs.get("buildId")

    @build_id.setter
    def build_id(self, build_id: "str"):
        """Sets the build_id of this WorkflowRunError.


        :param build_id: The build_id of this WorkflowRunError.
        :type: str
        """
        if build_id is None:
            raise ValueError("Invalid value for `build_id`, must not be `None`")
        self._attrs["buildId"] = build_id

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowRunError.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowRunError.


        :param id: The id of this WorkflowRunError.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def workflow_id(self) -> "str":
        """ Gets the workflow_id of this WorkflowRunError.
        """
        return self._attrs.get("workflowId")

    @workflow_id.setter
    def workflow_id(self, workflow_id: "str"):
        """Sets the workflow_id of this WorkflowRunError.


        :param workflow_id: The workflow_id of this WorkflowRunError.
        :type: str
        """
        if workflow_id is None:
            raise ValueError("Invalid value for `workflow_id`, must not be `None`")
        self._attrs["workflowId"] = workflow_id

    @property
    def executor_errors(self) -> "List[ExecutorErrors]":
        """ Gets the executor_errors of this WorkflowRunError.
        """
        return [ExecutorErrors._from_dict(i) for i in self._attrs.get("executorErrors")]

    @executor_errors.setter
    def executor_errors(self, executor_errors: "List[ExecutorErrors]"):
        """Sets the executor_errors of this WorkflowRunError.


        :param executor_errors: The executor_errors of this WorkflowRunError.
        :type: List[ExecutorErrors]
        """
        self._attrs["executorErrors"] = executor_errors

    @property
    def request_id(self) -> "str":
        """ Gets the request_id of this WorkflowRunError.
        """
        return self._attrs.get("requestId")

    @request_id.setter
    def request_id(self, request_id: "str"):
        """Sets the request_id of this WorkflowRunError.


        :param request_id: The request_id of this WorkflowRunError.
        :type: str
        """
        self._attrs["requestId"] = request_id

    @property
    def workflow_manager_errors(self) -> "List[WorkflowManagerErrors]":
        """ Gets the workflow_manager_errors of this WorkflowRunError.
        """
        return [WorkflowManagerErrors._from_dict(i) for i in self._attrs.get("workflowManagerErrors")]

    @workflow_manager_errors.setter
    def workflow_manager_errors(self, workflow_manager_errors: "List[WorkflowManagerErrors]"):
        """Sets the workflow_manager_errors of this WorkflowRunError.


        :param workflow_manager_errors: The workflow_manager_errors of this WorkflowRunError.
        :type: List[WorkflowManagerErrors]
        """
        self._attrs["workflowManagerErrors"] = workflow_manager_errors

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowRunLog(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowRunLog":
        instance = WorkflowRunLog.__new__(WorkflowRunLog)
        instance._attrs = model
        return instance

    def __init__(self, build_id: "str", id: "str", workflow_id: "str", executor_logs: "List[ExecutorLogs]" = None, request_id: "str" = None, workflow_manager_logs: "List[WorkflowManagerLogs]" = None, **extra):
        """WorkflowRunLog"""

        self._attrs = dict()
        if build_id is not None:
            self._attrs["buildId"] = build_id
        if id is not None:
            self._attrs["id"] = id
        if workflow_id is not None:
            self._attrs["workflowId"] = workflow_id
        if executor_logs is not None:
            self._attrs["executorLogs"] = executor_logs
        if request_id is not None:
            self._attrs["requestId"] = request_id
        if workflow_manager_logs is not None:
            self._attrs["workflowManagerLogs"] = workflow_manager_logs
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def build_id(self) -> "str":
        """ Gets the build_id of this WorkflowRunLog.
        """
        return self._attrs.get("buildId")

    @build_id.setter
    def build_id(self, build_id: "str"):
        """Sets the build_id of this WorkflowRunLog.


        :param build_id: The build_id of this WorkflowRunLog.
        :type: str
        """
        if build_id is None:
            raise ValueError("Invalid value for `build_id`, must not be `None`")
        self._attrs["buildId"] = build_id

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowRunLog.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowRunLog.


        :param id: The id of this WorkflowRunLog.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def workflow_id(self) -> "str":
        """ Gets the workflow_id of this WorkflowRunLog.
        """
        return self._attrs.get("workflowId")

    @workflow_id.setter
    def workflow_id(self, workflow_id: "str"):
        """Sets the workflow_id of this WorkflowRunLog.


        :param workflow_id: The workflow_id of this WorkflowRunLog.
        :type: str
        """
        if workflow_id is None:
            raise ValueError("Invalid value for `workflow_id`, must not be `None`")
        self._attrs["workflowId"] = workflow_id

    @property
    def executor_logs(self) -> "List[ExecutorLogs]":
        """ Gets the executor_logs of this WorkflowRunLog.
        """
        return [ExecutorLogs._from_dict(i) for i in self._attrs.get("executorLogs")]

    @executor_logs.setter
    def executor_logs(self, executor_logs: "List[ExecutorLogs]"):
        """Sets the executor_logs of this WorkflowRunLog.


        :param executor_logs: The executor_logs of this WorkflowRunLog.
        :type: List[ExecutorLogs]
        """
        self._attrs["executorLogs"] = executor_logs

    @property
    def request_id(self) -> "str":
        """ Gets the request_id of this WorkflowRunLog.
        """
        return self._attrs.get("requestId")

    @request_id.setter
    def request_id(self, request_id: "str"):
        """Sets the request_id of this WorkflowRunLog.


        :param request_id: The request_id of this WorkflowRunLog.
        :type: str
        """
        self._attrs["requestId"] = request_id

    @property
    def workflow_manager_logs(self) -> "List[WorkflowManagerLogs]":
        """ Gets the workflow_manager_logs of this WorkflowRunLog.
        """
        return [WorkflowManagerLogs._from_dict(i) for i in self._attrs.get("workflowManagerLogs")]

    @workflow_manager_logs.setter
    def workflow_manager_logs(self, workflow_manager_logs: "List[WorkflowManagerLogs]"):
        """Sets the workflow_manager_logs of this WorkflowRunLog.


        :param workflow_manager_logs: The workflow_manager_logs of this WorkflowRunLog.
        :type: List[WorkflowManagerLogs]
        """
        self._attrs["workflowManagerLogs"] = workflow_manager_logs

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    RUNNING = "running"
    FAILED = "failed"
    SUCCESS = "success"
    SCHEDULED = "scheduled"
    INITIALIZING = "initializing"

    @staticmethod
    def from_value(value: str):
        if value == "running":
            return StatusEnum.RUNNING
        if value == "failed":
            return StatusEnum.FAILED
        if value == "success":
            return StatusEnum.SUCCESS
        if value == "scheduled":
            return StatusEnum.SCHEDULED
        if value == "initializing":
            return StatusEnum.INITIALIZING


class WorkflowStreamDeployment(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowStreamDeployment":
        instance = WorkflowStreamDeployment.__new__(WorkflowStreamDeployment)
        instance._attrs = model
        return instance

    def __init__(self, input: "InputStream", output: "OutputStream", creation_time: "datetime" = None, end_time: "datetime" = None, id: "str" = None, name: "str" = None, spec: "DeploymentSpec" = None, start_time: "datetime" = None, status: "str" = None, workflow_build: "WorkflowBuild" = None, **extra):
        """WorkflowStreamDeployment"""

        self._attrs = dict()
        if input is not None:
            self._attrs["input"] = input.to_dict()
        if output is not None:
            self._attrs["output"] = output.to_dict()
        if creation_time is not None:
            self._attrs["creationTime"] = creation_time
        if end_time is not None:
            self._attrs["endTime"] = end_time
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if spec is not None:
            self._attrs["spec"] = spec.to_dict()
        if start_time is not None:
            self._attrs["startTime"] = start_time
        if status is not None:
            self._attrs["status"] = status
        if workflow_build is not None:
            self._attrs["workflowBuild"] = workflow_build.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def input(self) -> "InputStream":
        """ Gets the input of this WorkflowStreamDeployment.
        """
        return InputStream._from_dict(self._attrs["input"])

    @input.setter
    def input(self, input: "InputStream"):
        """Sets the input of this WorkflowStreamDeployment.


        :param input: The input of this WorkflowStreamDeployment.
        :type: InputStream
        """
        if input is None:
            raise ValueError("Invalid value for `input`, must not be `None`")
        self._attrs["input"] = input.to_dict()

    @property
    def output(self) -> "OutputStream":
        """ Gets the output of this WorkflowStreamDeployment.
        """
        return OutputStream._from_dict(self._attrs["output"])

    @output.setter
    def output(self, output: "OutputStream"):
        """Sets the output of this WorkflowStreamDeployment.


        :param output: The output of this WorkflowStreamDeployment.
        :type: OutputStream
        """
        if output is None:
            raise ValueError("Invalid value for `output`, must not be `None`")
        self._attrs["output"] = output.to_dict()

    @property
    def creation_time(self) -> "datetime":
        """ Gets the creation_time of this WorkflowStreamDeployment.
        """
        return self._attrs.get("creationTime")

    @creation_time.setter
    def creation_time(self, creation_time: "datetime"):
        """Sets the creation_time of this WorkflowStreamDeployment.


        :param creation_time: The creation_time of this WorkflowStreamDeployment.
        :type: datetime
        """
        self._attrs["creationTime"] = creation_time

    @property
    def end_time(self) -> "datetime":
        """ Gets the end_time of this WorkflowStreamDeployment.
        """
        return self._attrs.get("endTime")

    @end_time.setter
    def end_time(self, end_time: "datetime"):
        """Sets the end_time of this WorkflowStreamDeployment.


        :param end_time: The end_time of this WorkflowStreamDeployment.
        :type: datetime
        """
        self._attrs["endTime"] = end_time

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowStreamDeployment.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowStreamDeployment.


        :param id: The id of this WorkflowStreamDeployment.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowStreamDeployment.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowStreamDeployment.


        :param name: The name of this WorkflowStreamDeployment.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def spec(self) -> "DeploymentSpec":
        """ Gets the spec of this WorkflowStreamDeployment.
        """
        return DeploymentSpec._from_dict(self._attrs["spec"])

    @spec.setter
    def spec(self, spec: "DeploymentSpec"):
        """Sets the spec of this WorkflowStreamDeployment.


        :param spec: The spec of this WorkflowStreamDeployment.
        :type: DeploymentSpec
        """
        self._attrs["spec"] = spec.to_dict()

    @property
    def start_time(self) -> "datetime":
        """ Gets the start_time of this WorkflowStreamDeployment.
        """
        return self._attrs.get("startTime")

    @start_time.setter
    def start_time(self, start_time: "datetime"):
        """Sets the start_time of this WorkflowStreamDeployment.


        :param start_time: The start_time of this WorkflowStreamDeployment.
        :type: datetime
        """
        self._attrs["startTime"] = start_time

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this WorkflowStreamDeployment.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this WorkflowStreamDeployment.


        :param status: The status of this WorkflowStreamDeployment.
        :type: str
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    @property
    def workflow_build(self) -> "WorkflowBuild":
        """ Gets the workflow_build of this WorkflowStreamDeployment.
        """
        return WorkflowBuild._from_dict(self._attrs["workflowBuild"])

    @workflow_build.setter
    def workflow_build(self, workflow_build: "WorkflowBuild"):
        """Sets the workflow_build of this WorkflowStreamDeployment.


        :param workflow_build: The workflow_build of this WorkflowStreamDeployment.
        :type: WorkflowBuild
        """
        self._attrs["workflowBuild"] = workflow_build.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class WorkflowsGetResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "WorkflowsGetResponse":
        instance = WorkflowsGetResponse.__new__(WorkflowsGetResponse)
        instance._attrs = model
        return instance

    def __init__(self, creation_time: "datetime" = None, id: "str" = None, name: "str" = None, **extra):
        """WorkflowsGetResponse"""

        self._attrs = dict()
        if creation_time is not None:
            self._attrs["creationTime"] = creation_time
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def creation_time(self) -> "datetime":
        """ Gets the creation_time of this WorkflowsGetResponse.
        """
        return self._attrs.get("creationTime")

    @creation_time.setter
    def creation_time(self, creation_time: "datetime"):
        """Sets the creation_time of this WorkflowsGetResponse.


        :param creation_time: The creation_time of this WorkflowsGetResponse.
        :type: datetime
        """
        self._attrs["creationTime"] = creation_time

    @property
    def id(self) -> "str":
        """ Gets the id of this WorkflowsGetResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this WorkflowsGetResponse.


        :param id: The id of this WorkflowsGetResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this WorkflowsGetResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this WorkflowsGetResponse.


        :param name: The name of this WorkflowsGetResponse.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
