# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Splunk Search service

    Use the Search service in Splunk Cloud Services to dispatch, review, and manage searches and search jobs. You can finalize or cancel jobs, retrieve search results, and request search-related configurations from the Metadata Catalog service in Splunk Cloud Services.

    OpenAPI spec version: v2 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class TypeEnum(str, Enum):
    INFO = "INFO"
    DEBUG = "DEBUG"
    FATAL = "FATAL"
    ERROR = "ERROR"

    @staticmethod
    def from_value(value: str):
        if value == "INFO":
            return TypeEnum.INFO
        if value == "DEBUG":
            return TypeEnum.DEBUG
        if value == "FATAL":
            return TypeEnum.FATAL
        if value == "ERROR":
            return TypeEnum.ERROR


class Message(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Message":
        instance = Message.__new__(Message)
        instance._attrs = model
        return instance

    def __init__(self, text: "str" = None, type: "str" = None, **extra):
        """Message"""

        self._attrs = dict()
        if text is not None:
            self._attrs["text"] = text
        if type is not None:
            self._attrs["type"] = type
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def text(self) -> "str":
        """ Gets the text of this Message.
        """
        return self._attrs.get("text")

    @text.setter
    def text(self, text: "str"):
        """Sets the text of this Message.


        :param text: The text of this Message.
        :type: str
        """
        self._attrs["text"] = text

    @property
    def type(self) -> "TypeEnum":
        """ Gets the type of this Message.
        """
        return TypeEnum.from_value(self._attrs.get("type"))

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this Message.


        :param type: The type of this Message.
        :type: str
        """
        if isinstance(type, Enum):
            self._attrs["type"] = type.value
        else:
            self._attrs["type"] = type  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class QueryParameters(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "QueryParameters":
        instance = QueryParameters.__new__(QueryParameters)
        instance._attrs = model
        return instance

    def __init__(self, earliest: "str" = '-24h@h', latest: "str" = 'now', relative_time_anchor: "datetime" = None, timezone: "object" = None, **extra):
        """QueryParameters"""

        self._attrs = dict()
        if earliest is not None:
            self._attrs["earliest"] = earliest
        if latest is not None:
            self._attrs["latest"] = latest
        if relative_time_anchor is not None:
            self._attrs["relativeTimeAnchor"] = relative_time_anchor
        if timezone is not None:
            self._attrs["timezone"] = timezone
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def earliest(self) -> "str":
        """ Gets the earliest of this QueryParameters.
        The earliest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2021-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 
        """
        return self._attrs.get("earliest")

    @earliest.setter
    def earliest(self, earliest: "str"):
        """Sets the earliest of this QueryParameters.

        The earliest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2021-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 

        :param earliest: The earliest of this QueryParameters.
        :type: str
        """
        self._attrs["earliest"] = earliest

    @property
    def latest(self) -> "str":
        """ Gets the latest of this QueryParameters.
        The latest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2021-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 
        """
        return self._attrs.get("latest")

    @latest.setter
    def latest(self, latest: "str"):
        """Sets the latest of this QueryParameters.

        The latest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2021-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 

        :param latest: The latest of this QueryParameters.
        :type: str
        """
        self._attrs["latest"] = latest

    @property
    def relative_time_anchor(self) -> "datetime":
        """ Gets the relative_time_anchor of this QueryParameters.
        Specify a time string to set the absolute time used for any relative time specifier in the search. Defaults to the current system time. You can specify a relative time modifier ('earliest' or 'latest') for this parameter.  For example, if 'earliest' is set to -d and  the 'relativeTimeAnchor' is set to '2021-01-05T13:15:30Z' then 'resolvedEarliest' is '2021-01-04T13:15:30Z'. 
        """
        return self._attrs.get("relativeTimeAnchor")

    @relative_time_anchor.setter
    def relative_time_anchor(self, relative_time_anchor: "datetime"):
        """Sets the relative_time_anchor of this QueryParameters.

        Specify a time string to set the absolute time used for any relative time specifier in the search. Defaults to the current system time. You can specify a relative time modifier ('earliest' or 'latest') for this parameter.  For example, if 'earliest' is set to -d and  the 'relativeTimeAnchor' is set to '2021-01-05T13:15:30Z' then 'resolvedEarliest' is '2021-01-04T13:15:30Z'. 

        :param relative_time_anchor: The relative_time_anchor of this QueryParameters.
        :type: datetime
        """
        self._attrs["relativeTimeAnchor"] = relative_time_anchor

    @property
    def timezone(self) -> "object":
        """ Gets the timezone of this QueryParameters.
        The timezone that relative time modifiers are based off of. Timezone only applies to relative time literals for 'earliest' and 'latest'. If UNIX time or UTC format is used for 'earliest' and 'latest', this field is ignored. For the list of supported timezone formats, see https://docs.splunk.com/Documentation/Splunk/latest/Data/Applytimezoneoffsetstotimestamps#zoneinfo_.28TZ.29_database type: string default: \"GMT\" 
        """
        return self._attrs.get("timezone")

    @timezone.setter
    def timezone(self, timezone: "object"):
        """Sets the timezone of this QueryParameters.

        The timezone that relative time modifiers are based off of. Timezone only applies to relative time literals for 'earliest' and 'latest'. If UNIX time or UTC format is used for 'earliest' and 'latest', this field is ignored. For the list of supported timezone formats, see https://docs.splunk.com/Documentation/Splunk/latest/Data/Applytimezoneoffsetstotimestamps#zoneinfo_.28TZ.29_database type: string default: \"GMT\" 

        :param timezone: The timezone of this QueryParameters.
        :type: object
        """
        self._attrs["timezone"] = timezone

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SearchStatus(str, Enum):
    RUNNING = "running"
    DONE = "done"
    CANCELED = "canceled"
    FAILED = "failed"

    @staticmethod
    def from_value(value: str):
        if value == "running":
            return SearchStatus.RUNNING
        if value == "done":
            return SearchStatus.DONE
        if value == "canceled":
            return SearchStatus.CANCELED
        if value == "failed":
            return SearchStatus.FAILED


class DeleteSearchJob(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DeleteSearchJob":
        instance = DeleteSearchJob.__new__(DeleteSearchJob)
        instance._attrs = model
        return instance

    def __init__(self, index: "str", module: "str", predicate: "str", allow_side_effects: "bool" = True, collect_event_summary: "bool" = False, collect_field_summary: "bool" = False, collect_time_buckets: "bool" = False, completion_time: "str" = None, dispatch_time: "str" = None, enable_preview: "bool" = False, extract_fields: "str" = 'none', max_time: "int" = 3600, messages: "List[Message]" = None, name: "str" = None, percent_complete: "int" = 0, preview_available: "str" = 'false', query: "str" = None, query_parameters: "QueryParameters" = None, required_freshness: "int" = 0, resolved_earliest: "str" = None, resolved_latest: "str" = None, results_available: "int" = 0, results_preview_available: "int" = 0, sid: "str" = None, status: "SearchStatus" = None, **extra):
        """DeleteSearchJob"""

        self._attrs = dict()
        if index is not None:
            self._attrs["index"] = index
        if module is not None:
            self._attrs["module"] = module
        if predicate is not None:
            self._attrs["predicate"] = predicate
        if allow_side_effects is not None:
            self._attrs["allowSideEffects"] = allow_side_effects
        if collect_event_summary is not None:
            self._attrs["collectEventSummary"] = collect_event_summary
        if collect_field_summary is not None:
            self._attrs["collectFieldSummary"] = collect_field_summary
        if collect_time_buckets is not None:
            self._attrs["collectTimeBuckets"] = collect_time_buckets
        if completion_time is not None:
            self._attrs["completionTime"] = completion_time
        if dispatch_time is not None:
            self._attrs["dispatchTime"] = dispatch_time
        if enable_preview is not None:
            self._attrs["enablePreview"] = enable_preview
        if extract_fields is not None:
            self._attrs["extractFields"] = extract_fields
        if max_time is not None:
            self._attrs["maxTime"] = max_time
        if messages is not None:
            self._attrs["messages"] = messages
        if name is not None:
            self._attrs["name"] = name
        if percent_complete is not None:
            self._attrs["percentComplete"] = percent_complete
        if preview_available is not None:
            self._attrs["previewAvailable"] = preview_available
        if query is not None:
            self._attrs["query"] = query
        if query_parameters is not None:
            self._attrs["queryParameters"] = query_parameters.to_dict()
        if required_freshness is not None:
            self._attrs["requiredFreshness"] = required_freshness
        if resolved_earliest is not None:
            self._attrs["resolvedEarliest"] = resolved_earliest
        if resolved_latest is not None:
            self._attrs["resolvedLatest"] = resolved_latest
        if results_available is not None:
            self._attrs["resultsAvailable"] = results_available
        if results_preview_available is not None:
            self._attrs["resultsPreviewAvailable"] = results_preview_available
        if sid is not None:
            self._attrs["sid"] = sid
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def index(self) -> "str":
        """ Gets the index of this DeleteSearchJob.
        The index to delete the events from.
        """
        return self._attrs.get("index")

    @index.setter
    def index(self, index: "str"):
        """Sets the index of this DeleteSearchJob.

        The index to delete the events from.

        :param index: The index of this DeleteSearchJob.
        :type: str
        """
        if index is None:
            raise ValueError("Invalid value for `index`, must not be `None`")
        self._attrs["index"] = index

    @property
    def module(self) -> "str":
        """ Gets the module of this DeleteSearchJob.
        The module to run the delete search job in. The default module is used if the module field is empty.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DeleteSearchJob.

        The module to run the delete search job in. The default module is used if the module field is empty.

        :param module: The module of this DeleteSearchJob.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def predicate(self) -> "str":
        """ Gets the predicate of this DeleteSearchJob.
        The predicate expression that identifies the events to delete from the index. This expression must return true or false. To delete all events from the index, specify \"true\" instead of an expression.
        """
        return self._attrs.get("predicate")

    @predicate.setter
    def predicate(self, predicate: "str"):
        """Sets the predicate of this DeleteSearchJob.

        The predicate expression that identifies the events to delete from the index. This expression must return true or false. To delete all events from the index, specify \"true\" instead of an expression.

        :param predicate: The predicate of this DeleteSearchJob.
        :type: str
        """
        if predicate is None:
            raise ValueError("Invalid value for `predicate`, must not be `None`")
        self._attrs["predicate"] = predicate

    @property
    def allow_side_effects(self) -> "bool":
        """ Gets the allow_side_effects of this DeleteSearchJob.
        Specifies that the delete search job contains side effects, with possible security risks. 
        """
        return self._attrs.get("allowSideEffects")

    @allow_side_effects.setter
    def allow_side_effects(self, allow_side_effects: "bool"):
        """Sets the allow_side_effects of this DeleteSearchJob.

        Specifies that the delete search job contains side effects, with possible security risks. 

        :param allow_side_effects: The allow_side_effects of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["allowSideEffects"] = allow_side_effects

    @property
    def collect_event_summary(self) -> "bool":
        """ Gets the collect_event_summary of this DeleteSearchJob.
        This property does not apply to delete search jobs endpoint and is set to false by default. 
        """
        return self._attrs.get("collectEventSummary")

    @collect_event_summary.setter
    def collect_event_summary(self, collect_event_summary: "bool"):
        """Sets the collect_event_summary of this DeleteSearchJob.

        This property does not apply to delete search jobs endpoint and is set to false by default. 

        :param collect_event_summary: The collect_event_summary of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["collectEventSummary"] = collect_event_summary

    @property
    def collect_field_summary(self) -> "bool":
        """ Gets the collect_field_summary of this DeleteSearchJob.
        This property does not apply to delete search jobs endpoint and is set to false by default. 
        """
        return self._attrs.get("collectFieldSummary")

    @collect_field_summary.setter
    def collect_field_summary(self, collect_field_summary: "bool"):
        """Sets the collect_field_summary of this DeleteSearchJob.

        This property does not apply to delete search jobs endpoint and is set to false by default. 

        :param collect_field_summary: The collect_field_summary of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["collectFieldSummary"] = collect_field_summary

    @property
    def collect_time_buckets(self) -> "bool":
        """ Gets the collect_time_buckets of this DeleteSearchJob.
        This property does not apply to delete search jobs endpoint and is set to false by default. 
        """
        return self._attrs.get("collectTimeBuckets")

    @collect_time_buckets.setter
    def collect_time_buckets(self, collect_time_buckets: "bool"):
        """Sets the collect_time_buckets of this DeleteSearchJob.

        This property does not apply to delete search jobs endpoint and is set to false by default. 

        :param collect_time_buckets: The collect_time_buckets of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["collectTimeBuckets"] = collect_time_buckets

    @property
    def completion_time(self) -> "str":
        """ Gets the completion_time of this DeleteSearchJob.
        The time, in GMT, that the search job is finished. Empty if the search job has not completed. 
        """
        return self._attrs.get("completionTime")

    @completion_time.setter
    def completion_time(self, completion_time: "str"):
        """Sets the completion_time of this DeleteSearchJob.

        The time, in GMT, that the search job is finished. Empty if the search job has not completed. 

        :param completion_time: The completion_time of this DeleteSearchJob.
        :type: str
        """
        self._attrs["completionTime"] = completion_time

    @property
    def dispatch_time(self) -> "str":
        """ Gets the dispatch_time of this DeleteSearchJob.
        The time, in GMT, that the search job is dispatched. 
        """
        return self._attrs.get("dispatchTime")

    @dispatch_time.setter
    def dispatch_time(self, dispatch_time: "str"):
        """Sets the dispatch_time of this DeleteSearchJob.

        The time, in GMT, that the search job is dispatched. 

        :param dispatch_time: The dispatch_time of this DeleteSearchJob.
        :type: str
        """
        self._attrs["dispatchTime"] = dispatch_time

    @property
    def enable_preview(self) -> "bool":
        """ Gets the enable_preview of this DeleteSearchJob.
        This property does not apply to delete search jobs endpoint and is set to false by default. 
        """
        return self._attrs.get("enablePreview")

    @enable_preview.setter
    def enable_preview(self, enable_preview: "bool"):
        """Sets the enable_preview of this DeleteSearchJob.

        This property does not apply to delete search jobs endpoint and is set to false by default. 

        :param enable_preview: The enable_preview of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["enablePreview"] = enable_preview

    @property
    def extract_fields(self) -> "str":
        """ Gets the extract_fields of this DeleteSearchJob.
        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' will extract all fields, 'indexed' will extract only indexed fields, and 'none' will extract only the default fields. This parameter overwrites the value of the 'extractAllFields' parameter. Set to 'none' for better search performance. 
        """
        return self._attrs.get("extractFields")

    @extract_fields.setter
    def extract_fields(self, extract_fields: "str"):
        """Sets the extract_fields of this DeleteSearchJob.

        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' will extract all fields, 'indexed' will extract only indexed fields, and 'none' will extract only the default fields. This parameter overwrites the value of the 'extractAllFields' parameter. Set to 'none' for better search performance. 

        :param extract_fields: The extract_fields of this DeleteSearchJob.
        :type: str
        """
        self._attrs["extractFields"] = extract_fields

    @property
    def max_time(self) -> "int":
        """ Gets the max_time of this DeleteSearchJob.
        The amount of time, in seconds, to run the delete search job before finalizing the search. The maximum value is 3600 seconds (1 hour). 
        """
        return self._attrs.get("maxTime")

    @max_time.setter
    def max_time(self, max_time: "int"):
        """Sets the max_time of this DeleteSearchJob.

        The amount of time, in seconds, to run the delete search job before finalizing the search. The maximum value is 3600 seconds (1 hour). 

        :param max_time: The max_time of this DeleteSearchJob.
        :type: int
        """
        self._attrs["maxTime"] = max_time

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this DeleteSearchJob.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this DeleteSearchJob.


        :param messages: The messages of this DeleteSearchJob.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def name(self) -> "str":
        """ Gets the name of this DeleteSearchJob.
        The name of the search job.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DeleteSearchJob.

        The name of the search job.

        :param name: The name of this DeleteSearchJob.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def percent_complete(self) -> "int":
        """ Gets the percent_complete of this DeleteSearchJob.
        An estimate of the percent of time remaining before the delete search job completes.
        """
        return self._attrs.get("percentComplete")

    @percent_complete.setter
    def percent_complete(self, percent_complete: "int"):
        """Sets the percent_complete of this DeleteSearchJob.

        An estimate of the percent of time remaining before the delete search job completes.

        :param percent_complete: The percent_complete of this DeleteSearchJob.
        :type: int
        """
        self._attrs["percentComplete"] = percent_complete

    @property
    def preview_available(self) -> "str":
        """ Gets the preview_available of this DeleteSearchJob.
        This property does not apply to delete search jobs endpoint and is set to false by default.
        """
        return self._attrs.get("previewAvailable")

    @preview_available.setter
    def preview_available(self, preview_available: "str"):
        """Sets the preview_available of this DeleteSearchJob.

        This property does not apply to delete search jobs endpoint and is set to false by default.

        :param preview_available: The preview_available of this DeleteSearchJob.
        :type: str
        """
        self._attrs["previewAvailable"] = preview_available

    @property
    def query(self) -> "str":
        """ Gets the query of this DeleteSearchJob.
        The SPL search string that includes the index, module, and predicate that you specify.
        """
        return self._attrs.get("query")

    @query.setter
    def query(self, query: "str"):
        """Sets the query of this DeleteSearchJob.

        The SPL search string that includes the index, module, and predicate that you specify.

        :param query: The query of this DeleteSearchJob.
        :type: str
        """
        self._attrs["query"] = query

    @property
    def query_parameters(self) -> "QueryParameters":
        """ Gets the query_parameters of this DeleteSearchJob.
        Represents parameters on the search job such as 'earliest' and 'latest'.
        """
        return QueryParameters._from_dict(self._attrs["queryParameters"])

    @query_parameters.setter
    def query_parameters(self, query_parameters: "QueryParameters"):
        """Sets the query_parameters of this DeleteSearchJob.

        Represents parameters on the search job such as 'earliest' and 'latest'.

        :param query_parameters: The query_parameters of this DeleteSearchJob.
        :type: QueryParameters
        """
        self._attrs["queryParameters"] = query_parameters.to_dict()

    @property
    def required_freshness(self) -> "int":
        """ Gets the required_freshness of this DeleteSearchJob.
        This property does not apply to delete search jobs endpoint and is set to 0 by default. 
        """
        return self._attrs.get("requiredFreshness")

    @required_freshness.setter
    def required_freshness(self, required_freshness: "int"):
        """Sets the required_freshness of this DeleteSearchJob.

        This property does not apply to delete search jobs endpoint and is set to 0 by default. 

        :param required_freshness: The required_freshness of this DeleteSearchJob.
        :type: int
        """
        self._attrs["requiredFreshness"] = required_freshness

    @property
    def resolved_earliest(self) -> "str":
        """ Gets the resolved_earliest of this DeleteSearchJob.
        The earliest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedEarliest")

    @resolved_earliest.setter
    def resolved_earliest(self, resolved_earliest: "str"):
        """Sets the resolved_earliest of this DeleteSearchJob.

        The earliest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 

        :param resolved_earliest: The resolved_earliest of this DeleteSearchJob.
        :type: str
        """
        self._attrs["resolvedEarliest"] = resolved_earliest

    @property
    def resolved_latest(self) -> "str":
        """ Gets the resolved_latest of this DeleteSearchJob.
        The latest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedLatest")

    @resolved_latest.setter
    def resolved_latest(self, resolved_latest: "str"):
        """Sets the resolved_latest of this DeleteSearchJob.

        The latest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 

        :param resolved_latest: The resolved_latest of this DeleteSearchJob.
        :type: str
        """
        self._attrs["resolvedLatest"] = resolved_latest

    @property
    def results_available(self) -> "int":
        """ Gets the results_available of this DeleteSearchJob.
        The number of results produced so far by the delete search job that are going to be deleted.
        """
        return self._attrs.get("resultsAvailable")

    @results_available.setter
    def results_available(self, results_available: "int"):
        """Sets the results_available of this DeleteSearchJob.

        The number of results produced so far by the delete search job that are going to be deleted.

        :param results_available: The results_available of this DeleteSearchJob.
        :type: int
        """
        self._attrs["resultsAvailable"] = results_available

    @property
    def results_preview_available(self) -> "int":
        """ Gets the results_preview_available of this DeleteSearchJob.
        This property does not apply to delete search jobs endpoint and is set to 0 by default.
        """
        return self._attrs.get("resultsPreviewAvailable")

    @results_preview_available.setter
    def results_preview_available(self, results_preview_available: "int"):
        """Sets the results_preview_available of this DeleteSearchJob.

        This property does not apply to delete search jobs endpoint and is set to 0 by default.

        :param results_preview_available: The results_preview_available of this DeleteSearchJob.
        :type: int
        """
        self._attrs["resultsPreviewAvailable"] = results_preview_available

    @property
    def sid(self) -> "str":
        """ Gets the sid of this DeleteSearchJob.
        The ID assigned to the delete search job.
        """
        return self._attrs.get("sid")

    @sid.setter
    def sid(self, sid: "str"):
        """Sets the sid of this DeleteSearchJob.

        The ID assigned to the delete search job.

        :param sid: The sid of this DeleteSearchJob.
        :type: str
        """
        self._attrs["sid"] = sid

    @property
    def status(self) -> "SearchStatus":
        """ Gets the status of this DeleteSearchJob.
        """
        return SearchStatus.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "SearchStatus"):
        """Sets the status of this DeleteSearchJob.


        :param status: The status of this DeleteSearchJob.
        :type: SearchStatus
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SingleFieldSummary(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SingleFieldSummary":
        instance = SingleFieldSummary.__new__(SingleFieldSummary)
        instance._attrs = model
        return instance

    def __init__(self, count: "int" = None, distinct_count: "int" = None, is_exact: "bool" = None, max: "str" = None, mean: "float" = None, min: "str" = None, modes: "List[SingleValueMode]" = None, numeric_count: "int" = None, relevant: "bool" = None, stddev: "float" = None, **extra):
        """SingleFieldSummary"""

        self._attrs = dict()
        if count is not None:
            self._attrs["count"] = count
        if distinct_count is not None:
            self._attrs["distinctCount"] = distinct_count
        if is_exact is not None:
            self._attrs["isExact"] = is_exact
        if max is not None:
            self._attrs["max"] = max
        if mean is not None:
            self._attrs["mean"] = mean
        if min is not None:
            self._attrs["min"] = min
        if modes is not None:
            self._attrs["modes"] = modes
        if numeric_count is not None:
            self._attrs["numericCount"] = numeric_count
        if relevant is not None:
            self._attrs["relevant"] = relevant
        if stddev is not None:
            self._attrs["stddev"] = stddev
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def count(self) -> "int":
        """ Gets the count of this SingleFieldSummary.
        The total number of events that the field appears in.
        """
        return self._attrs.get("count")

    @count.setter
    def count(self, count: "int"):
        """Sets the count of this SingleFieldSummary.

        The total number of events that the field appears in.

        :param count: The count of this SingleFieldSummary.
        :type: int
        """
        self._attrs["count"] = count

    @property
    def distinct_count(self) -> "int":
        """ Gets the distinct_count of this SingleFieldSummary.
        The total number of unique values in the field.
        """
        return self._attrs.get("distinctCount")

    @distinct_count.setter
    def distinct_count(self, distinct_count: "int"):
        """Sets the distinct_count of this SingleFieldSummary.

        The total number of unique values in the field.

        :param distinct_count: The distinct_count of this SingleFieldSummary.
        :type: int
        """
        self._attrs["distinctCount"] = distinct_count

    @property
    def is_exact(self) -> "bool":
        """ Gets the is_exact of this SingleFieldSummary.
        Specifies if the 'distinctCount' is accurate. When the count exceeds the maximum count, an approximate count is computed instead and the 'isExact' property is FALSE. 
        """
        return self._attrs.get("isExact")

    @is_exact.setter
    def is_exact(self, is_exact: "bool"):
        """Sets the is_exact of this SingleFieldSummary.

        Specifies if the 'distinctCount' is accurate. When the count exceeds the maximum count, an approximate count is computed instead and the 'isExact' property is FALSE. 

        :param is_exact: The is_exact of this SingleFieldSummary.
        :type: bool
        """
        self._attrs["isExact"] = is_exact

    @property
    def max(self) -> "str":
        """ Gets the max of this SingleFieldSummary.
        The maximum numeric value in the field.
        """
        return self._attrs.get("max")

    @max.setter
    def max(self, max: "str"):
        """Sets the max of this SingleFieldSummary.

        The maximum numeric value in the field.

        :param max: The max of this SingleFieldSummary.
        :type: str
        """
        self._attrs["max"] = max

    @property
    def mean(self) -> "float":
        """ Gets the mean of this SingleFieldSummary.
        The mean (average) for the numeric value in the field.
        """
        return self._attrs.get("mean")

    @mean.setter
    def mean(self, mean: "float"):
        """Sets the mean of this SingleFieldSummary.

        The mean (average) for the numeric value in the field.

        :param mean: The mean of this SingleFieldSummary.
        :type: float
        """
        self._attrs["mean"] = mean

    @property
    def min(self) -> "str":
        """ Gets the min of this SingleFieldSummary.
        The minimum numeric value in the field.
        """
        return self._attrs.get("min")

    @min.setter
    def min(self, min: "str"):
        """Sets the min of this SingleFieldSummary.

        The minimum numeric value in the field.

        :param min: The min of this SingleFieldSummary.
        :type: str
        """
        self._attrs["min"] = min

    @property
    def modes(self) -> "List[SingleValueMode]":
        """ Gets the modes of this SingleFieldSummary.
        An array of the values in the field.
        """
        return [SingleValueMode._from_dict(i) for i in self._attrs.get("modes")]

    @modes.setter
    def modes(self, modes: "List[SingleValueMode]"):
        """Sets the modes of this SingleFieldSummary.

        An array of the values in the field.

        :param modes: The modes of this SingleFieldSummary.
        :type: List[SingleValueMode]
        """
        self._attrs["modes"] = modes

    @property
    def numeric_count(self) -> "int":
        """ Gets the numeric_count of this SingleFieldSummary.
        The count of the numeric values in the field.
        """
        return self._attrs.get("numericCount")

    @numeric_count.setter
    def numeric_count(self, numeric_count: "int"):
        """Sets the numeric_count of this SingleFieldSummary.

        The count of the numeric values in the field.

        :param numeric_count: The numeric_count of this SingleFieldSummary.
        :type: int
        """
        self._attrs["numericCount"] = numeric_count

    @property
    def relevant(self) -> "bool":
        """ Gets the relevant of this SingleFieldSummary.
        Specifies if the field was added or changed by the search.
        """
        return self._attrs.get("relevant")

    @relevant.setter
    def relevant(self, relevant: "bool"):
        """Sets the relevant of this SingleFieldSummary.

        Specifies if the field was added or changed by the search.

        :param relevant: The relevant of this SingleFieldSummary.
        :type: bool
        """
        self._attrs["relevant"] = relevant

    @property
    def stddev(self) -> "float":
        """ Gets the stddev of this SingleFieldSummary.
        The standard deviation for the numeric values in the field.
        """
        return self._attrs.get("stddev")

    @stddev.setter
    def stddev(self, stddev: "float"):
        """Sets the stddev of this SingleFieldSummary.

        The standard deviation for the numeric values in the field.

        :param stddev: The stddev of this SingleFieldSummary.
        :type: float
        """
        self._attrs["stddev"] = stddev

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SingleValueMode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SingleValueMode":
        instance = SingleValueMode.__new__(SingleValueMode)
        instance._attrs = model
        return instance

    def __init__(self, count: "int" = None, is_exact: "bool" = None, value: "str" = None, **extra):
        """SingleValueMode"""

        self._attrs = dict()
        if count is not None:
            self._attrs["count"] = count
        if is_exact is not None:
            self._attrs["isExact"] = is_exact
        if value is not None:
            self._attrs["value"] = value
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def count(self) -> "int":
        """ Gets the count of this SingleValueMode.
        The number of occurrences that the value appears in a field.
        """
        return self._attrs.get("count")

    @count.setter
    def count(self, count: "int"):
        """Sets the count of this SingleValueMode.

        The number of occurrences that the value appears in a field.

        :param count: The count of this SingleValueMode.
        :type: int
        """
        self._attrs["count"] = count

    @property
    def is_exact(self) -> "bool":
        """ Gets the is_exact of this SingleValueMode.
        Specifies if the count is accurate. When the count exceeds the maximum count, an approximate count is computed instead and the 'isExact' property is FALSE. 
        """
        return self._attrs.get("isExact")

    @is_exact.setter
    def is_exact(self, is_exact: "bool"):
        """Sets the is_exact of this SingleValueMode.

        Specifies if the count is accurate. When the count exceeds the maximum count, an approximate count is computed instead and the 'isExact' property is FALSE. 

        :param is_exact: The is_exact of this SingleValueMode.
        :type: bool
        """
        self._attrs["isExact"] = is_exact

    @property
    def value(self) -> "str":
        """ Gets the value of this SingleValueMode.
        The value in the field.
        """
        return self._attrs.get("value")

    @value.setter
    def value(self, value: "str"):
        """Sets the value of this SingleValueMode.

        The value in the field.

        :param value: The value of this SingleValueMode.
        :type: str
        """
        self._attrs["value"] = value

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FieldsSummary(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FieldsSummary":
        instance = FieldsSummary.__new__(FieldsSummary)
        instance._attrs = model
        return instance

    def __init__(self, duration: "float" = None, earliest_time: "str" = None, event_count: "int" = None, fields: "Dict[str, SingleFieldSummary]" = None, latest_time: "str" = None, **extra):
        """FieldsSummary"""

        self._attrs = dict()
        if duration is not None:
            self._attrs["duration"] = duration
        if earliest_time is not None:
            self._attrs["earliestTime"] = earliest_time
        if event_count is not None:
            self._attrs["eventCount"] = event_count
        if fields is not None:
            self._attrs["fields"] = fields
        if latest_time is not None:
            self._attrs["latestTime"] = latest_time
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def duration(self) -> "float":
        """ Gets the duration of this FieldsSummary.
        The amount of time, in seconds, that a time bucket spans from the earliest to the latest time.
        """
        return self._attrs.get("duration")

    @duration.setter
    def duration(self, duration: "float"):
        """Sets the duration of this FieldsSummary.

        The amount of time, in seconds, that a time bucket spans from the earliest to the latest time.

        :param duration: The duration of this FieldsSummary.
        :type: float
        """
        self._attrs["duration"] = duration

    @property
    def earliest_time(self) -> "str":
        """ Gets the earliest_time of this FieldsSummary.
        The earliest timestamp, in UTC format, of the events to process.
        """
        return self._attrs.get("earliestTime")

    @earliest_time.setter
    def earliest_time(self, earliest_time: "str"):
        """Sets the earliest_time of this FieldsSummary.

        The earliest timestamp, in UTC format, of the events to process.

        :param earliest_time: The earliest_time of this FieldsSummary.
        :type: str
        """
        self._attrs["earliestTime"] = earliest_time

    @property
    def event_count(self) -> "int":
        """ Gets the event_count of this FieldsSummary.
        The total number of events for all fields returned in the time range (earliestTime and latestTime) specified.
        """
        return self._attrs.get("eventCount")

    @event_count.setter
    def event_count(self, event_count: "int"):
        """Sets the event_count of this FieldsSummary.

        The total number of events for all fields returned in the time range (earliestTime and latestTime) specified.

        :param event_count: The event_count of this FieldsSummary.
        :type: int
        """
        self._attrs["eventCount"] = event_count

    @property
    def fields(self) -> "Dict[str, SingleFieldSummary]":
        """ Gets the fields of this FieldsSummary.
        A list of the fields in the time range specified.
        """
        return self._attrs.get("fields")

    @fields.setter
    def fields(self, fields: "Dict[str, SingleFieldSummary]"):
        """Sets the fields of this FieldsSummary.

        A list of the fields in the time range specified.

        :param fields: The fields of this FieldsSummary.
        :type: Dict[str, SingleFieldSummary]
        """
        self._attrs["fields"] = fields

    @property
    def latest_time(self) -> "str":
        """ Gets the latest_time of this FieldsSummary.
        The latest timestamp, in UTC format, of the events to process.
        """
        return self._attrs.get("latestTime")

    @latest_time.setter
    def latest_time(self, latest_time: "str"):
        """Sets the latest_time of this FieldsSummary.

        The latest timestamp, in UTC format, of the events to process.

        :param latest_time: The latest_time of this FieldsSummary.
        :type: str
        """
        self._attrs["latestTime"] = latest_time

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ListPreviewResultsResponseFields(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ListPreviewResultsResponseFields":
        instance = ListPreviewResultsResponseFields.__new__(ListPreviewResultsResponseFields)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", data_source: "str" = None, groupby_rank: "str" = None, split_field: "str" = None, split_value: "str" = None, splitby_special: "str" = None, type_special: "str" = None, **extra):
        """ListPreviewResultsResponseFields"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if data_source is not None:
            self._attrs["dataSource"] = data_source
        if groupby_rank is not None:
            self._attrs["groupbyRank"] = groupby_rank
        if split_field is not None:
            self._attrs["splitField"] = split_field
        if split_value is not None:
            self._attrs["splitValue"] = split_value
        if splitby_special is not None:
            self._attrs["splitbySpecial"] = splitby_special
        if type_special is not None:
            self._attrs["typeSpecial"] = type_special
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ListPreviewResultsResponseFields.


        :param name: The name of this ListPreviewResultsResponseFields.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def data_source(self) -> "str":
        """ Gets the data_source of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("dataSource")

    @data_source.setter
    def data_source(self, data_source: "str"):
        """Sets the data_source of this ListPreviewResultsResponseFields.


        :param data_source: The data_source of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["dataSource"] = data_source

    @property
    def groupby_rank(self) -> "str":
        """ Gets the groupby_rank of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("groupbyRank")

    @groupby_rank.setter
    def groupby_rank(self, groupby_rank: "str"):
        """Sets the groupby_rank of this ListPreviewResultsResponseFields.


        :param groupby_rank: The groupby_rank of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["groupbyRank"] = groupby_rank

    @property
    def split_field(self) -> "str":
        """ Gets the split_field of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("splitField")

    @split_field.setter
    def split_field(self, split_field: "str"):
        """Sets the split_field of this ListPreviewResultsResponseFields.


        :param split_field: The split_field of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["splitField"] = split_field

    @property
    def split_value(self) -> "str":
        """ Gets the split_value of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("splitValue")

    @split_value.setter
    def split_value(self, split_value: "str"):
        """Sets the split_value of this ListPreviewResultsResponseFields.


        :param split_value: The split_value of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["splitValue"] = split_value

    @property
    def splitby_special(self) -> "str":
        """ Gets the splitby_special of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("splitbySpecial")

    @splitby_special.setter
    def splitby_special(self, splitby_special: "str"):
        """Sets the splitby_special of this ListPreviewResultsResponseFields.


        :param splitby_special: The splitby_special of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["splitbySpecial"] = splitby_special

    @property
    def type_special(self) -> "str":
        """ Gets the type_special of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("typeSpecial")

    @type_special.setter
    def type_special(self, type_special: "str"):
        """Sets the type_special of this ListPreviewResultsResponseFields.


        :param type_special: The type_special of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["typeSpecial"] = type_special

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ListPreviewResultsResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ListPreviewResultsResponse":
        instance = ListPreviewResultsResponse.__new__(ListPreviewResultsResponse)
        instance._attrs = model
        return instance

    def __init__(self, is_preview_stable: "bool", results: "List[object]", fields: "List[ListPreviewResultsResponseFields]" = None, messages: "List[Message]" = None, next_link: "str" = None, wait: "str" = None, **extra):
        """ListPreviewResultsResponse"""

        self._attrs = dict()
        if is_preview_stable is not None:
            self._attrs["isPreviewStable"] = is_preview_stable
        if results is not None:
            self._attrs["results"] = results
        if fields is not None:
            self._attrs["fields"] = fields
        if messages is not None:
            self._attrs["messages"] = messages
        if next_link is not None:
            self._attrs["nextLink"] = next_link
        if wait is not None:
            self._attrs["wait"] = wait
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def is_preview_stable(self) -> "bool":
        """ Gets the is_preview_stable of this ListPreviewResultsResponse.
        """
        return self._attrs.get("isPreviewStable")

    @is_preview_stable.setter
    def is_preview_stable(self, is_preview_stable: "bool"):
        """Sets the is_preview_stable of this ListPreviewResultsResponse.


        :param is_preview_stable: The is_preview_stable of this ListPreviewResultsResponse.
        :type: bool
        """
        if is_preview_stable is None:
            raise ValueError("Invalid value for `is_preview_stable`, must not be `None`")
        self._attrs["isPreviewStable"] = is_preview_stable

    @property
    def results(self) -> "List[object]":
        """ Gets the results of this ListPreviewResultsResponse.
        """
        return self._attrs.get("results")

    @results.setter
    def results(self, results: "List[object]"):
        """Sets the results of this ListPreviewResultsResponse.


        :param results: The results of this ListPreviewResultsResponse.
        :type: List[object]
        """
        if results is None:
            raise ValueError("Invalid value for `results`, must not be `None`")
        self._attrs["results"] = results

    @property
    def fields(self) -> "List[ListPreviewResultsResponseFields]":
        """ Gets the fields of this ListPreviewResultsResponse.
        """
        return [ListPreviewResultsResponseFields._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[ListPreviewResultsResponseFields]"):
        """Sets the fields of this ListPreviewResultsResponse.


        :param fields: The fields of this ListPreviewResultsResponse.
        :type: List[ListPreviewResultsResponseFields]
        """
        self._attrs["fields"] = fields

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this ListPreviewResultsResponse.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this ListPreviewResultsResponse.


        :param messages: The messages of this ListPreviewResultsResponse.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def next_link(self) -> "str":
        """ Gets the next_link of this ListPreviewResultsResponse.
        """
        return self._attrs.get("nextLink")

    @next_link.setter
    def next_link(self, next_link: "str"):
        """Sets the next_link of this ListPreviewResultsResponse.


        :param next_link: The next_link of this ListPreviewResultsResponse.
        :type: str
        """
        self._attrs["nextLink"] = next_link

    @property
    def wait(self) -> "str":
        """ Gets the wait of this ListPreviewResultsResponse.
        """
        return self._attrs.get("wait")

    @wait.setter
    def wait(self, wait: "str"):
        """Sets the wait of this ListPreviewResultsResponse.


        :param wait: The wait of this ListPreviewResultsResponse.
        :type: str
        """
        self._attrs["wait"] = wait

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ListSearchResultsResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ListSearchResultsResponse":
        instance = ListSearchResultsResponse.__new__(ListSearchResultsResponse)
        instance._attrs = model
        return instance

    def __init__(self, results: "List[object]", fields: "List[ListPreviewResultsResponseFields]" = None, messages: "List[Message]" = None, next_link: "str" = None, wait: "str" = None, **extra):
        """ListSearchResultsResponse"""

        self._attrs = dict()
        if results is not None:
            self._attrs["results"] = results
        if fields is not None:
            self._attrs["fields"] = fields
        if messages is not None:
            self._attrs["messages"] = messages
        if next_link is not None:
            self._attrs["nextLink"] = next_link
        if wait is not None:
            self._attrs["wait"] = wait
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def results(self) -> "List[object]":
        """ Gets the results of this ListSearchResultsResponse.
        """
        return self._attrs.get("results")

    @results.setter
    def results(self, results: "List[object]"):
        """Sets the results of this ListSearchResultsResponse.


        :param results: The results of this ListSearchResultsResponse.
        :type: List[object]
        """
        if results is None:
            raise ValueError("Invalid value for `results`, must not be `None`")
        self._attrs["results"] = results

    @property
    def fields(self) -> "List[ListPreviewResultsResponseFields]":
        """ Gets the fields of this ListSearchResultsResponse.
        """
        return [ListPreviewResultsResponseFields._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[ListPreviewResultsResponseFields]"):
        """Sets the fields of this ListSearchResultsResponse.


        :param fields: The fields of this ListSearchResultsResponse.
        :type: List[ListPreviewResultsResponseFields]
        """
        self._attrs["fields"] = fields

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this ListSearchResultsResponse.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this ListSearchResultsResponse.


        :param messages: The messages of this ListSearchResultsResponse.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def next_link(self) -> "str":
        """ Gets the next_link of this ListSearchResultsResponse.
        """
        return self._attrs.get("nextLink")

    @next_link.setter
    def next_link(self, next_link: "str"):
        """Sets the next_link of this ListSearchResultsResponse.


        :param next_link: The next_link of this ListSearchResultsResponse.
        :type: str
        """
        self._attrs["nextLink"] = next_link

    @property
    def wait(self) -> "str":
        """ Gets the wait of this ListSearchResultsResponse.
        """
        return self._attrs.get("wait")

    @wait.setter
    def wait(self, wait: "str"):
        """Sets the wait of this ListSearchResultsResponse.


        :param wait: The wait of this ListSearchResultsResponse.
        :type: str
        """
        self._attrs["wait"] = wait

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SearchJob(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SearchJob":
        instance = SearchJob.__new__(SearchJob)
        instance._attrs = model
        return instance

    def __init__(self, query: "str", allow_side_effects: "bool" = False, collect_event_summary: "bool" = False, collect_field_summary: "bool" = False, collect_time_buckets: "bool" = False, completion_time: "str" = None, dispatch_time: "str" = None, enable_preview: "bool" = False, extract_all_fields: "bool" = False, extract_fields: "str" = 'none', max_time: "int" = 3600, messages: "List[Message]" = None, module: "str" = '', name: "str" = None, percent_complete: "int" = 0, preview_available: "str" = 'false', query_parameters: "QueryParameters" = None, required_freshness: "int" = 0, resolved_earliest: "str" = None, resolved_latest: "str" = None, results_available: "int" = 0, results_preview_available: "int" = 0, sid: "str" = None, status: "SearchStatus" = None, **extra):
        """SearchJob"""

        self._attrs = dict()
        if query is not None:
            self._attrs["query"] = query
        if allow_side_effects is not None:
            self._attrs["allowSideEffects"] = allow_side_effects
        if collect_event_summary is not None:
            self._attrs["collectEventSummary"] = collect_event_summary
        if collect_field_summary is not None:
            self._attrs["collectFieldSummary"] = collect_field_summary
        if collect_time_buckets is not None:
            self._attrs["collectTimeBuckets"] = collect_time_buckets
        if completion_time is not None:
            self._attrs["completionTime"] = completion_time
        if dispatch_time is not None:
            self._attrs["dispatchTime"] = dispatch_time
        if enable_preview is not None:
            self._attrs["enablePreview"] = enable_preview
        if extract_all_fields is not None:
            self._attrs["extractAllFields"] = extract_all_fields
        if extract_fields is not None:
            self._attrs["extractFields"] = extract_fields
        if max_time is not None:
            self._attrs["maxTime"] = max_time
        if messages is not None:
            self._attrs["messages"] = messages
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if percent_complete is not None:
            self._attrs["percentComplete"] = percent_complete
        if preview_available is not None:
            self._attrs["previewAvailable"] = preview_available
        if query_parameters is not None:
            self._attrs["queryParameters"] = query_parameters.to_dict()
        if required_freshness is not None:
            self._attrs["requiredFreshness"] = required_freshness
        if resolved_earliest is not None:
            self._attrs["resolvedEarliest"] = resolved_earliest
        if resolved_latest is not None:
            self._attrs["resolvedLatest"] = resolved_latest
        if results_available is not None:
            self._attrs["resultsAvailable"] = results_available
        if results_preview_available is not None:
            self._attrs["resultsPreviewAvailable"] = results_preview_available
        if sid is not None:
            self._attrs["sid"] = sid
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def query(self) -> "str":
        """ Gets the query of this SearchJob.
        The SPL search string.
        """
        return self._attrs.get("query")

    @query.setter
    def query(self, query: "str"):
        """Sets the query of this SearchJob.

        The SPL search string.

        :param query: The query of this SearchJob.
        :type: str
        """
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")
        self._attrs["query"] = query

    @property
    def allow_side_effects(self) -> "bool":
        """ Gets the allow_side_effects of this SearchJob.
        Specifies whether a search that contains commands with side effects (with possible security risks) is allowed to run. 
        """
        return self._attrs.get("allowSideEffects")

    @allow_side_effects.setter
    def allow_side_effects(self, allow_side_effects: "bool"):
        """Sets the allow_side_effects of this SearchJob.

        Specifies whether a search that contains commands with side effects (with possible security risks) is allowed to run. 

        :param allow_side_effects: The allow_side_effects of this SearchJob.
        :type: bool
        """
        self._attrs["allowSideEffects"] = allow_side_effects

    @property
    def collect_event_summary(self) -> "bool":
        """ Gets the collect_event_summary of this SearchJob.
        Specifies whether a search is allowed to collect event summary information during the run time. 
        """
        return self._attrs.get("collectEventSummary")

    @collect_event_summary.setter
    def collect_event_summary(self, collect_event_summary: "bool"):
        """Sets the collect_event_summary of this SearchJob.

        Specifies whether a search is allowed to collect event summary information during the run time. 

        :param collect_event_summary: The collect_event_summary of this SearchJob.
        :type: bool
        """
        self._attrs["collectEventSummary"] = collect_event_summary

    @property
    def collect_field_summary(self) -> "bool":
        """ Gets the collect_field_summary of this SearchJob.
        Specifies whether a search is allowed to collect field summary information during the run time. 
        """
        return self._attrs.get("collectFieldSummary")

    @collect_field_summary.setter
    def collect_field_summary(self, collect_field_summary: "bool"):
        """Sets the collect_field_summary of this SearchJob.

        Specifies whether a search is allowed to collect field summary information during the run time. 

        :param collect_field_summary: The collect_field_summary of this SearchJob.
        :type: bool
        """
        self._attrs["collectFieldSummary"] = collect_field_summary

    @property
    def collect_time_buckets(self) -> "bool":
        """ Gets the collect_time_buckets of this SearchJob.
        Specifies whether a search is allowed to collect timeline bucket summary information during the run time. 
        """
        return self._attrs.get("collectTimeBuckets")

    @collect_time_buckets.setter
    def collect_time_buckets(self, collect_time_buckets: "bool"):
        """Sets the collect_time_buckets of this SearchJob.

        Specifies whether a search is allowed to collect timeline bucket summary information during the run time. 

        :param collect_time_buckets: The collect_time_buckets of this SearchJob.
        :type: bool
        """
        self._attrs["collectTimeBuckets"] = collect_time_buckets

    @property
    def completion_time(self) -> "str":
        """ Gets the completion_time of this SearchJob.
        The time, in GMT, that the search job is finished. Empty if the search job has not completed. 
        """
        return self._attrs.get("completionTime")

    @completion_time.setter
    def completion_time(self, completion_time: "str"):
        """Sets the completion_time of this SearchJob.

        The time, in GMT, that the search job is finished. Empty if the search job has not completed. 

        :param completion_time: The completion_time of this SearchJob.
        :type: str
        """
        self._attrs["completionTime"] = completion_time

    @property
    def dispatch_time(self) -> "str":
        """ Gets the dispatch_time of this SearchJob.
        The time, in GMT, that the search job is dispatched. 
        """
        return self._attrs.get("dispatchTime")

    @dispatch_time.setter
    def dispatch_time(self, dispatch_time: "str"):
        """Sets the dispatch_time of this SearchJob.

        The time, in GMT, that the search job is dispatched. 

        :param dispatch_time: The dispatch_time of this SearchJob.
        :type: str
        """
        self._attrs["dispatchTime"] = dispatch_time

    @property
    def enable_preview(self) -> "bool":
        """ Gets the enable_preview of this SearchJob.
        Specifies whether a search is allowed to collect preview results during the run time. 
        """
        return self._attrs.get("enablePreview")

    @enable_preview.setter
    def enable_preview(self, enable_preview: "bool"):
        """Sets the enable_preview of this SearchJob.

        Specifies whether a search is allowed to collect preview results during the run time. 

        :param enable_preview: The enable_preview of this SearchJob.
        :type: bool
        """
        self._attrs["enablePreview"] = enable_preview

    @property
    def extract_all_fields(self) -> "bool":
        """ Gets the extract_all_fields of this SearchJob.
        Specifies whether the Search service should extract all of the available fields in the data, including fields not mentioned in the SPL, for the search job. Set to 'false' for better search performance. The 'extractAllFields' parameter is deprecated as of version v3alpha1. Although this parameter continues to function, it might be removed in a future version. Use the 'extractFields' parameter instead. 
        """
        return self._attrs.get("extractAllFields")

    @extract_all_fields.setter
    def extract_all_fields(self, extract_all_fields: "bool"):
        """Sets the extract_all_fields of this SearchJob.

        Specifies whether the Search service should extract all of the available fields in the data, including fields not mentioned in the SPL, for the search job. Set to 'false' for better search performance. The 'extractAllFields' parameter is deprecated as of version v3alpha1. Although this parameter continues to function, it might be removed in a future version. Use the 'extractFields' parameter instead. 

        :param extract_all_fields: The extract_all_fields of this SearchJob.
        :type: bool
        """
        self._attrs["extractAllFields"] = extract_all_fields

    @property
    def extract_fields(self) -> "str":
        """ Gets the extract_fields of this SearchJob.
        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'.  Use 'all' to extract all fields. Use 'indexed' to extract only indexed fields. Use 'none' to extract only the default fields. 
        """
        return self._attrs.get("extractFields")

    @extract_fields.setter
    def extract_fields(self, extract_fields: "str"):
        """Sets the extract_fields of this SearchJob.

        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'.  Use 'all' to extract all fields. Use 'indexed' to extract only indexed fields. Use 'none' to extract only the default fields. 

        :param extract_fields: The extract_fields of this SearchJob.
        :type: str
        """
        self._attrs["extractFields"] = extract_fields

    @property
    def max_time(self) -> "int":
        """ Gets the max_time of this SearchJob.
        The number of seconds to run the search before finalizing the search. The maximum value is 3600 seconds (1 hour). 
        """
        return self._attrs.get("maxTime")

    @max_time.setter
    def max_time(self, max_time: "int"):
        """Sets the max_time of this SearchJob.

        The number of seconds to run the search before finalizing the search. The maximum value is 3600 seconds (1 hour). 

        :param max_time: The max_time of this SearchJob.
        :type: int
        """
        self._attrs["maxTime"] = max_time

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this SearchJob.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this SearchJob.


        :param messages: The messages of this SearchJob.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def module(self) -> "str":
        """ Gets the module of this SearchJob.
        The module to run the search in. The default module is used if a module is not specified.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this SearchJob.

        The module to run the search in. The default module is used if a module is not specified.

        :param module: The module of this SearchJob.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this SearchJob.
        The name of the search job.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this SearchJob.

        The name of the search job.

        :param name: The name of this SearchJob.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def percent_complete(self) -> "int":
        """ Gets the percent_complete of this SearchJob.
        An estimate of the percent of time remaining before the job completes.
        """
        return self._attrs.get("percentComplete")

    @percent_complete.setter
    def percent_complete(self, percent_complete: "int"):
        """Sets the percent_complete of this SearchJob.

        An estimate of the percent of time remaining before the job completes.

        :param percent_complete: The percent_complete of this SearchJob.
        :type: int
        """
        self._attrs["percentComplete"] = percent_complete

    @property
    def preview_available(self) -> "str":
        """ Gets the preview_available of this SearchJob.
        Specifies if preview results for the search job are available. The valid status values are 'unknown', 'true', and 'false'. You must set the 'enablePreview=true' parameter to return preview search results.
        """
        return self._attrs.get("previewAvailable")

    @preview_available.setter
    def preview_available(self, preview_available: "str"):
        """Sets the preview_available of this SearchJob.

        Specifies if preview results for the search job are available. The valid status values are 'unknown', 'true', and 'false'. You must set the 'enablePreview=true' parameter to return preview search results.

        :param preview_available: The preview_available of this SearchJob.
        :type: str
        """
        self._attrs["previewAvailable"] = preview_available

    @property
    def query_parameters(self) -> "QueryParameters":
        """ Gets the query_parameters of this SearchJob.
        Represents parameters on the search job such as 'earliest' and 'latest'.
        """
        return QueryParameters._from_dict(self._attrs["queryParameters"])

    @query_parameters.setter
    def query_parameters(self, query_parameters: "QueryParameters"):
        """Sets the query_parameters of this SearchJob.

        Represents parameters on the search job such as 'earliest' and 'latest'.

        :param query_parameters: The query_parameters of this SearchJob.
        :type: QueryParameters
        """
        self._attrs["queryParameters"] = query_parameters.to_dict()

    @property
    def required_freshness(self) -> "int":
        """ Gets the required_freshness of this SearchJob.
        Specifies a maximum time interval, in seconds, between identical existing searches. The 'requiredFreshness' parameter is used to determine if an existing search with the same query and the same time boundaries can be reused, instead of running the same search again. Freshness is applied to the 'resolvedEarliest' and 'resolvedLatest' parameters. If an existing search has the same exact criteria as this search and the 'resolvedEarliest' and 'resolvedLatest' values are within the freshness interval, the existing search metadata is returned instead of initiating a new search job. By default, the 'requiredFreshness' parameter is set to 0 which means that the platform does not attempt to use an existing search. The maximum value for the 'requiredFreshness' parameter is 259200 seconds (72 hours). 
        """
        return self._attrs.get("requiredFreshness")

    @required_freshness.setter
    def required_freshness(self, required_freshness: "int"):
        """Sets the required_freshness of this SearchJob.

        Specifies a maximum time interval, in seconds, between identical existing searches. The 'requiredFreshness' parameter is used to determine if an existing search with the same query and the same time boundaries can be reused, instead of running the same search again. Freshness is applied to the 'resolvedEarliest' and 'resolvedLatest' parameters. If an existing search has the same exact criteria as this search and the 'resolvedEarliest' and 'resolvedLatest' values are within the freshness interval, the existing search metadata is returned instead of initiating a new search job. By default, the 'requiredFreshness' parameter is set to 0 which means that the platform does not attempt to use an existing search. The maximum value for the 'requiredFreshness' parameter is 259200 seconds (72 hours). 

        :param required_freshness: The required_freshness of this SearchJob.
        :type: int
        """
        self._attrs["requiredFreshness"] = required_freshness

    @property
    def resolved_earliest(self) -> "str":
        """ Gets the resolved_earliest of this SearchJob.
        The earliest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedEarliest")

    @resolved_earliest.setter
    def resolved_earliest(self, resolved_earliest: "str"):
        """Sets the resolved_earliest of this SearchJob.

        The earliest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 

        :param resolved_earliest: The resolved_earliest of this SearchJob.
        :type: str
        """
        self._attrs["resolvedEarliest"] = resolved_earliest

    @property
    def resolved_latest(self) -> "str":
        """ Gets the resolved_latest of this SearchJob.
        The latest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedLatest")

    @resolved_latest.setter
    def resolved_latest(self, resolved_latest: "str"):
        """Sets the resolved_latest of this SearchJob.

        The latest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 

        :param resolved_latest: The resolved_latest of this SearchJob.
        :type: str
        """
        self._attrs["resolvedLatest"] = resolved_latest

    @property
    def results_available(self) -> "int":
        """ Gets the results_available of this SearchJob.
        The number of results produced so far for the search job.
        """
        return self._attrs.get("resultsAvailable")

    @results_available.setter
    def results_available(self, results_available: "int"):
        """Sets the results_available of this SearchJob.

        The number of results produced so far for the search job.

        :param results_available: The results_available of this SearchJob.
        :type: int
        """
        self._attrs["resultsAvailable"] = results_available

    @property
    def results_preview_available(self) -> "int":
        """ Gets the results_preview_available of this SearchJob.
        The number of the preview search results for the job with the specified search ID (SID). You must set the 'enablePreview=true' parameter to return preview search results.
        """
        return self._attrs.get("resultsPreviewAvailable")

    @results_preview_available.setter
    def results_preview_available(self, results_preview_available: "int"):
        """Sets the results_preview_available of this SearchJob.

        The number of the preview search results for the job with the specified search ID (SID). You must set the 'enablePreview=true' parameter to return preview search results.

        :param results_preview_available: The results_preview_available of this SearchJob.
        :type: int
        """
        self._attrs["resultsPreviewAvailable"] = results_preview_available

    @property
    def sid(self) -> "str":
        """ Gets the sid of this SearchJob.
        The ID assigned to the search job.
        """
        return self._attrs.get("sid")

    @sid.setter
    def sid(self, sid: "str"):
        """Sets the sid of this SearchJob.

        The ID assigned to the search job.

        :param sid: The sid of this SearchJob.
        :type: str
        """
        self._attrs["sid"] = sid

    @property
    def status(self) -> "SearchStatus":
        """ Gets the status of this SearchJob.
        """
        return SearchStatus.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "SearchStatus"):
        """Sets the status of this SearchJob.


        :param status: The status of this SearchJob.
        :type: SearchStatus
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SingleTimeBucket(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SingleTimeBucket":
        instance = SingleTimeBucket.__new__(SingleTimeBucket)
        instance._attrs = model
        return instance

    def __init__(self, available_count: "int" = None, duration: "float" = None, earliest_time: "float" = None, earliest_time_strf_time: "str" = None, is_finalized: "bool" = None, total_count: "int" = None, **extra):
        """SingleTimeBucket"""

        self._attrs = dict()
        if available_count is not None:
            self._attrs["availableCount"] = available_count
        if duration is not None:
            self._attrs["duration"] = duration
        if earliest_time is not None:
            self._attrs["earliestTime"] = earliest_time
        if earliest_time_strf_time is not None:
            self._attrs["earliestTimeStrfTime"] = earliest_time_strf_time
        if is_finalized is not None:
            self._attrs["isFinalized"] = is_finalized
        if total_count is not None:
            self._attrs["totalCount"] = total_count
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def available_count(self) -> "int":
        """ Gets the available_count of this SingleTimeBucket.
        Count of available events. Not all events in a bucket are retrievable. Typically this count is capped at 10000.
        """
        return self._attrs.get("availableCount")

    @available_count.setter
    def available_count(self, available_count: "int"):
        """Sets the available_count of this SingleTimeBucket.

        Count of available events. Not all events in a bucket are retrievable. Typically this count is capped at 10000.

        :param available_count: The available_count of this SingleTimeBucket.
        :type: int
        """
        self._attrs["availableCount"] = available_count

    @property
    def duration(self) -> "float":
        """ Gets the duration of this SingleTimeBucket.
        """
        return self._attrs.get("duration")

    @duration.setter
    def duration(self, duration: "float"):
        """Sets the duration of this SingleTimeBucket.


        :param duration: The duration of this SingleTimeBucket.
        :type: float
        """
        self._attrs["duration"] = duration

    @property
    def earliest_time(self) -> "float":
        """ Gets the earliest_time of this SingleTimeBucket.
        The timestamp of the earliest event in the current bucket, in UNIX format. This is the same time as 'earliestTimeStrfTime' in UNIX format.
        """
        return self._attrs.get("earliestTime")

    @earliest_time.setter
    def earliest_time(self, earliest_time: "float"):
        """Sets the earliest_time of this SingleTimeBucket.

        The timestamp of the earliest event in the current bucket, in UNIX format. This is the same time as 'earliestTimeStrfTime' in UNIX format.

        :param earliest_time: The earliest_time of this SingleTimeBucket.
        :type: float
        """
        self._attrs["earliestTime"] = earliest_time

    @property
    def earliest_time_strf_time(self) -> "str":
        """ Gets the earliest_time_strf_time of this SingleTimeBucket.
        The timestamp of the earliest event in the current bucket, in UTC format with seconds. For example 2021-01-25T13:15:30Z, which follows the ISO-8601 (%FT%T.%Q) format.
        """
        return self._attrs.get("earliestTimeStrfTime")

    @earliest_time_strf_time.setter
    def earliest_time_strf_time(self, earliest_time_strf_time: "str"):
        """Sets the earliest_time_strf_time of this SingleTimeBucket.

        The timestamp of the earliest event in the current bucket, in UTC format with seconds. For example 2021-01-25T13:15:30Z, which follows the ISO-8601 (%FT%T.%Q) format.

        :param earliest_time_strf_time: The earliest_time_strf_time of this SingleTimeBucket.
        :type: str
        """
        self._attrs["earliestTimeStrfTime"] = earliest_time_strf_time

    @property
    def is_finalized(self) -> "bool":
        """ Gets the is_finalized of this SingleTimeBucket.
        Specifies if all of the events in the current bucket have been finalized.
        """
        return self._attrs.get("isFinalized")

    @is_finalized.setter
    def is_finalized(self, is_finalized: "bool"):
        """Sets the is_finalized of this SingleTimeBucket.

        Specifies if all of the events in the current bucket have been finalized.

        :param is_finalized: The is_finalized of this SingleTimeBucket.
        :type: bool
        """
        self._attrs["isFinalized"] = is_finalized

    @property
    def total_count(self) -> "int":
        """ Gets the total_count of this SingleTimeBucket.
        The total count of the events in the current bucket.
        """
        return self._attrs.get("totalCount")

    @total_count.setter
    def total_count(self, total_count: "int"):
        """Sets the total_count of this SingleTimeBucket.

        The total count of the events in the current bucket.

        :param total_count: The total_count of this SingleTimeBucket.
        :type: int
        """
        self._attrs["totalCount"] = total_count

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TimeBucketsSummary(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TimeBucketsSummary":
        instance = TimeBucketsSummary.__new__(TimeBucketsSummary)
        instance._attrs = model
        return instance

    def __init__(self, is_time_cursored: "bool" = None, buckets: "List[SingleTimeBucket]" = None, cursor_time: "float" = None, event_count: "int" = None, **extra):
        """TimeBucketsSummary"""

        self._attrs = dict()
        if is_time_cursored is not None:
            self._attrs["IsTimeCursored"] = is_time_cursored
        if buckets is not None:
            self._attrs["buckets"] = buckets
        if cursor_time is not None:
            self._attrs["cursorTime"] = cursor_time
        if event_count is not None:
            self._attrs["eventCount"] = event_count
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def is_time_cursored(self) -> "bool":
        """ Gets the is_time_cursored of this TimeBucketsSummary.
        Specifies if the events are returned in time order.
        """
        return self._attrs.get("IsTimeCursored")

    @is_time_cursored.setter
    def is_time_cursored(self, is_time_cursored: "bool"):
        """Sets the is_time_cursored of this TimeBucketsSummary.

        Specifies if the events are returned in time order.

        :param is_time_cursored: The is_time_cursored of this TimeBucketsSummary.
        :type: bool
        """
        self._attrs["IsTimeCursored"] = is_time_cursored

    @property
    def buckets(self) -> "List[SingleTimeBucket]":
        """ Gets the buckets of this TimeBucketsSummary.
        """
        return [SingleTimeBucket._from_dict(i) for i in self._attrs.get("buckets")]

    @buckets.setter
    def buckets(self, buckets: "List[SingleTimeBucket]"):
        """Sets the buckets of this TimeBucketsSummary.


        :param buckets: The buckets of this TimeBucketsSummary.
        :type: List[SingleTimeBucket]
        """
        self._attrs["buckets"] = buckets

    @property
    def cursor_time(self) -> "float":
        """ Gets the cursor_time of this TimeBucketsSummary.
        Identifies where the cursor is in processing the events. The 'cursorTime' is a timestamp specified in UNIX time.
        """
        return self._attrs.get("cursorTime")

    @cursor_time.setter
    def cursor_time(self, cursor_time: "float"):
        """Sets the cursor_time of this TimeBucketsSummary.

        Identifies where the cursor is in processing the events. The 'cursorTime' is a timestamp specified in UNIX time.

        :param cursor_time: The cursor_time of this TimeBucketsSummary.
        :type: float
        """
        self._attrs["cursorTime"] = cursor_time

    @property
    def event_count(self) -> "int":
        """ Gets the event_count of this TimeBucketsSummary.
        The number of events processed at the 'cursorTime'.
        """
        return self._attrs.get("eventCount")

    @event_count.setter
    def event_count(self, event_count: "int"):
        """Sets the event_count of this TimeBucketsSummary.

        The number of events processed at the 'cursorTime'.

        :param event_count: The event_count of this TimeBucketsSummary.
        :type: int
        """
        self._attrs["eventCount"] = event_count

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    CANCELED = "canceled"
    FINALIZED = "finalized"

    @staticmethod
    def from_value(value: str):
        if value == "canceled":
            return StatusEnum.CANCELED
        if value == "finalized":
            return StatusEnum.FINALIZED


class UpdateJob(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UpdateJob":
        instance = UpdateJob.__new__(UpdateJob)
        instance._attrs = model
        return instance

    def __init__(self, status: "str", **extra):
        """UpdateJob"""

        self._attrs = dict()
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this UpdateJob.
        Modify the status of an existing search job using PATCH. The only status values you can PATCH are 'canceled' and 'finalized'.  You can PATCH the 'canceled' status only to a search job that is running. 'finalize' means to terminate the search job, and the status will be set to 'failed'.  
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this UpdateJob.

        Modify the status of an existing search job using PATCH. The only status values you can PATCH are 'canceled' and 'finalized'.  You can PATCH the 'canceled' status only to a search job that is running. 'finalize' means to terminate the search job, and the status will be set to 'failed'.  

        :param status: The status of this UpdateJob.
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
