# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Splunk Search service

    Use the Search service in Splunk Cloud Services to dispatch, review, and manage searches and search jobs. You can finalize or cancel jobs, retrieve search results, and request search-related configurations from the Metadata Catalog service in Splunk Cloud Services.

    OpenAPI spec version: v3alpha1 
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class Dataset(SSCModel):

    from_dict_handlers = dict()
    @staticmethod
    def _from_dict(model: dict) -> "Dataset":

        def default_handler(model: dict) -> "Dataset":
            instance = Dataset.__new__(Dataset)
            instance._attrs = model
            return instance

        kind = model['kind']
        handler = Dataset.from_dict_handlers.get(kind, default_handler)
        return handler(model)

    def __init__(self, appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, created: "str" = None, createdby: "str" = None, description: "str" = None, id: "str" = None, modified: "str" = None, modifiedby: "str" = None, name: "str" = None, namespace: "str" = None, owner: "str" = None, resourcename: "str" = None, summary: "str" = None, title: "str" = None, **extra):
        """Dataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if namespace is not None:
            self._attrs["namespace"] = namespace
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this Dataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this Dataset.

        The date and time object was created.

        :param created: The created of this Dataset.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Dataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Dataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this Dataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this Dataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Dataset.

        A unique dataset ID.

        :param id: The id of this Dataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "str":
        """ Gets the modified of this Dataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "str"):
        """Sets the modified of this Dataset.

        The date and time object was modified.

        :param modified: The modified of this Dataset.
        :type: str
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this Dataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this Dataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this Dataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def name(self) -> "str":
        """ Gets the name of this Dataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Dataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this Dataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this Dataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this Dataset.

        The name of the object's owner.

        :param owner: The owner of this Dataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this Dataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this Dataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this Dataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this Dataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this Dataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this Dataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this Dataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this Dataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this Dataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this Dataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Dataset.

        Detailed description of the dataset.

        :param description: The description of this Dataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this Dataset.
        The name of the namespace that contains the dataset.
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this Dataset.

        The name of the namespace that contains the dataset.

        :param namespace: The namespace of this Dataset.
        :type: str
        """
        self._attrs["namespace"] = namespace

    @property
    def summary(self) -> "str":
        """ Gets the summary of this Dataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this Dataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this Dataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this Dataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this Dataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this Dataset.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        raise NotImplementedError()


class DatasetPATCH(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DatasetPATCH":
        instance = DatasetPATCH.__new__(DatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """DatasetPATCH"""

        self._attrs = dict()
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def module(self) -> "str":
        """ Gets the module of this DatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this DatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this DatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this DatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this DatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this DatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this DatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FieldPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FieldPOST":
        instance = FieldPOST.__new__(FieldPOST)
        instance._attrs = model
        return instance

    def __init__(self, datatype: "FieldDataType" = None, description: "str" = None, fieldtype: "FieldType" = None, indexed: "bool" = None, name: "str" = None, prevalence: "FieldPrevalence" = None, summary: "str" = None, title: "str" = None, **extra):
        """FieldPOST"""

        self._attrs = dict()
        if datatype is not None:
            self._attrs["datatype"] = datatype
        if description is not None:
            self._attrs["description"] = description
        if fieldtype is not None:
            self._attrs["fieldtype"] = fieldtype
        if indexed is not None:
            self._attrs["indexed"] = indexed
        if name is not None:
            self._attrs["name"] = name
        if prevalence is not None:
            self._attrs["prevalence"] = prevalence
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def datatype(self) -> "FieldDataType":
        """ Gets the datatype of this FieldPOST.
        """
        return FieldDataType.from_value(self._attrs.get("datatype"))

    @datatype.setter
    def datatype(self, datatype: "FieldDataType"):
        """Sets the datatype of this FieldPOST.


        :param datatype: The datatype of this FieldPOST.
        :type: FieldDataType
        """
        if isinstance(datatype, Enum):
            self._attrs["datatype"] = datatype.value
        else:
            self._attrs["datatype"] = datatype  # If you supply a string, we presume you know the service will take it.

    @property
    def description(self) -> "str":
        """ Gets the description of this FieldPOST.
        The field description.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this FieldPOST.

        The field description.

        :param description: The description of this FieldPOST.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def fieldtype(self) -> "FieldType":
        """ Gets the fieldtype of this FieldPOST.
        """
        return FieldType.from_value(self._attrs.get("fieldtype"))

    @fieldtype.setter
    def fieldtype(self, fieldtype: "FieldType"):
        """Sets the fieldtype of this FieldPOST.


        :param fieldtype: The fieldtype of this FieldPOST.
        :type: FieldType
        """
        if isinstance(fieldtype, Enum):
            self._attrs["fieldtype"] = fieldtype.value
        else:
            self._attrs["fieldtype"] = fieldtype  # If you supply a string, we presume you know the service will take it.

    @property
    def indexed(self) -> "bool":
        """ Gets the indexed of this FieldPOST.
        Whether or not the field has been indexed.
        """
        return self._attrs.get("indexed")

    @indexed.setter
    def indexed(self, indexed: "bool"):
        """Sets the indexed of this FieldPOST.

        Whether or not the field has been indexed.

        :param indexed: The indexed of this FieldPOST.
        :type: bool
        """
        self._attrs["indexed"] = indexed

    @property
    def name(self) -> "str":
        """ Gets the name of this FieldPOST.
        The field name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FieldPOST.

        The field name.

        :param name: The name of this FieldPOST.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def prevalence(self) -> "FieldPrevalence":
        """ Gets the prevalence of this FieldPOST.
        """
        return FieldPrevalence.from_value(self._attrs.get("prevalence"))

    @prevalence.setter
    def prevalence(self, prevalence: "FieldPrevalence"):
        """Sets the prevalence of this FieldPOST.


        :param prevalence: The prevalence of this FieldPOST.
        :type: FieldPrevalence
        """
        if isinstance(prevalence, Enum):
            self._attrs["prevalence"] = prevalence.value
        else:
            self._attrs["prevalence"] = prevalence  # If you supply a string, we presume you know the service will take it.

    @property
    def summary(self) -> "str":
        """ Gets the summary of this FieldPOST.
        The field summary.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this FieldPOST.

        The field summary.

        :param summary: The summary of this FieldPOST.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this FieldPOST.
        The field title.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this FieldPOST.

        The field title.

        :param title: The title of this FieldPOST.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FieldDataType(str, Enum):
    DATE = "DATE"
    NUMBER = "NUMBER"
    OBJECT_ID = "OBJECT_ID"
    STRING = "STRING"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "DATE":
            return FieldDataType.DATE
        if value == "NUMBER":
            return FieldDataType.NUMBER
        if value == "OBJECT_ID":
            return FieldDataType.OBJECT_ID
        if value == "STRING":
            return FieldDataType.STRING
        if value == "UNKNOWN":
            return FieldDataType.UNKNOWN


class FieldType(str, Enum):
    DIMENSION = "DIMENSION"
    MEASURE = "MEASURE"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "DIMENSION":
            return FieldType.DIMENSION
        if value == "MEASURE":
            return FieldType.MEASURE
        if value == "UNKNOWN":
            return FieldType.UNKNOWN


class FieldPrevalence(str, Enum):
    ALL = "ALL"
    SOME = "SOME"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "ALL":
            return FieldPrevalence.ALL
        if value == "SOME":
            return FieldPrevalence.SOME
        if value == "UNKNOWN":
            return FieldPrevalence.UNKNOWN


class DatasetPOST(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DatasetPOST":
        instance = DatasetPOST.__new__(DatasetPOST)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", fields: "List[FieldPOST]" = None, id: "str" = None, module: "str" = None, **extra):
        """DatasetPOST"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if fields is not None:
            self._attrs["fields"] = fields
        if id is not None:
            self._attrs["id"] = id
        if module is not None:
            self._attrs["module"] = module
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this DatasetPOST.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DatasetPOST.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this DatasetPOST.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def fields(self) -> "List[FieldPOST]":
        """ Gets the fields of this DatasetPOST.
        The fields to be associated with this dataset.
        """
        return [FieldPOST._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[FieldPOST]"):
        """Sets the fields of this DatasetPOST.

        The fields to be associated with this dataset.

        :param fields: The fields of this DatasetPOST.
        :type: List[FieldPOST]
        """
        self._attrs["fields"] = fields

    @property
    def id(self) -> "str":
        """ Gets the id of this DatasetPOST.
        A unique dataset ID. Random ID used if not provided.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this DatasetPOST.

        A unique dataset ID. Random ID used if not provided.

        :param id: The id of this DatasetPOST.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def module(self) -> "str":
        """ Gets the module of this DatasetPOST.
        The name of the module to create the new dataset in.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DatasetPOST.

        The name of the module to create the new dataset in.

        :param module: The module of this DatasetPOST.
        :type: str
        """
        self._attrs["module"] = module

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TypeEnum(str, Enum):
    INFO = "INFO"
    DEBUG = "DEBUG"
    FATAL = "FATAL"
    ERROR = "ERROR"

    @staticmethod
    def from_value(value: str):
        if value == "INFO":
            return TypeEnum.INFO
        if value == "DEBUG":
            return TypeEnum.DEBUG
        if value == "FATAL":
            return TypeEnum.FATAL
        if value == "ERROR":
            return TypeEnum.ERROR


class Message(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Message":
        instance = Message.__new__(Message)
        instance._attrs = model
        return instance

    def __init__(self, text: "str" = None, type: "str" = None, **extra):
        """Message"""

        self._attrs = dict()
        if text is not None:
            self._attrs["text"] = text
        if type is not None:
            self._attrs["type"] = type
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def text(self) -> "str":
        """ Gets the text of this Message.
        """
        return self._attrs.get("text")

    @text.setter
    def text(self, text: "str"):
        """Sets the text of this Message.


        :param text: The text of this Message.
        :type: str
        """
        self._attrs["text"] = text

    @property
    def type(self) -> "TypeEnum":
        """ Gets the type of this Message.
        """
        return TypeEnum.from_value(self._attrs.get("type"))

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this Message.


        :param type: The type of this Message.
        :type: str
        """
        if isinstance(type, Enum):
            self._attrs["type"] = type.value
        else:
            self._attrs["type"] = type  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class QueryParameters(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "QueryParameters":
        instance = QueryParameters.__new__(QueryParameters)
        instance._attrs = model
        return instance

    def __init__(self, earliest: "str" = '-24h@h', latest: "str" = 'now', relative_time_anchor: "datetime" = None, timezone: "object" = None, **extra):
        """QueryParameters"""

        self._attrs = dict()
        if earliest is not None:
            self._attrs["earliest"] = earliest
        if latest is not None:
            self._attrs["latest"] = latest
        if relative_time_anchor is not None:
            self._attrs["relativeTimeAnchor"] = relative_time_anchor
        if timezone is not None:
            self._attrs["timezone"] = timezone
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def earliest(self) -> "str":
        """ Gets the earliest of this QueryParameters.
        The earliest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2019-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 
        """
        return self._attrs.get("earliest")

    @earliest.setter
    def earliest(self, earliest: "str"):
        """Sets the earliest of this QueryParameters.

        The earliest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2019-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 

        :param earliest: The earliest of this QueryParameters.
        :type: str
        """
        self._attrs["earliest"] = earliest

    @property
    def latest(self) -> "str":
        """ Gets the latest of this QueryParameters.
        The latest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2019-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 
        """
        return self._attrs.get("latest")

    @latest.setter
    def latest(self, latest: "str"):
        """Sets the latest of this QueryParameters.

        The latest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2019-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 

        :param latest: The latest of this QueryParameters.
        :type: str
        """
        self._attrs["latest"] = latest

    @property
    def relative_time_anchor(self) -> "datetime":
        """ Gets the relative_time_anchor of this QueryParameters.
        Relative values for the 'earliest' and 'latest' parameters snap to the unit that you specify. For example, if 'earliest' is set to -d@d, the unit is day. If the 'relativeTimeAnchor' is is set to '2020-10-05T13:15:30Z' then 'resolvedEarliest' is snapped to '2020-10-05T00:00:00Z', which is the day. Hours, minutes, and seconds are dropped. If no 'relativeTimeAnchor' is specified, the default value is set to the time the search job was created. 
        """
        return self._attrs.get("relativeTimeAnchor")

    @relative_time_anchor.setter
    def relative_time_anchor(self, relative_time_anchor: "datetime"):
        """Sets the relative_time_anchor of this QueryParameters.

        Relative values for the 'earliest' and 'latest' parameters snap to the unit that you specify. For example, if 'earliest' is set to -d@d, the unit is day. If the 'relativeTimeAnchor' is is set to '2020-10-05T13:15:30Z' then 'resolvedEarliest' is snapped to '2020-10-05T00:00:00Z', which is the day. Hours, minutes, and seconds are dropped. If no 'relativeTimeAnchor' is specified, the default value is set to the time the search job was created. 

        :param relative_time_anchor: The relative_time_anchor of this QueryParameters.
        :type: datetime
        """
        self._attrs["relativeTimeAnchor"] = relative_time_anchor

    @property
    def timezone(self) -> "object":
        """ Gets the timezone of this QueryParameters.
        The timezone that relative time specifiers are based off of. Timezone only applies to relative time literals for 'earliest' and 'latest'. If UNIX time or UTC format is used for 'earliest' and 'latest', this field is ignored. For the list of supported timezone formats, see https://docs.splunk.com/Documentation/Splunk/latest/Data/Applytimezoneoffsetstotimestamps#zoneinfo_.28TZ.29_database type: string default: \"GMT\" 
        """
        return self._attrs.get("timezone")

    @timezone.setter
    def timezone(self, timezone: "object"):
        """Sets the timezone of this QueryParameters.

        The timezone that relative time specifiers are based off of. Timezone only applies to relative time literals for 'earliest' and 'latest'. If UNIX time or UTC format is used for 'earliest' and 'latest', this field is ignored. For the list of supported timezone formats, see https://docs.splunk.com/Documentation/Splunk/latest/Data/Applytimezoneoffsetstotimestamps#zoneinfo_.28TZ.29_database type: string default: \"GMT\" 

        :param timezone: The timezone of this QueryParameters.
        :type: object
        """
        self._attrs["timezone"] = timezone

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SearchStatus(str, Enum):
    RUNNING = "running"
    DONE = "done"
    CANCELED = "canceled"
    FAILED = "failed"

    @staticmethod
    def from_value(value: str):
        if value == "running":
            return SearchStatus.RUNNING
        if value == "done":
            return SearchStatus.DONE
        if value == "canceled":
            return SearchStatus.CANCELED
        if value == "failed":
            return SearchStatus.FAILED


class DeleteSearchJob(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DeleteSearchJob":
        instance = DeleteSearchJob.__new__(DeleteSearchJob)
        instance._attrs = model
        return instance

    def __init__(self, index: "str", module: "str", predicate: "str", allow_side_effects: "bool" = True, collect_event_summary: "bool" = False, collect_field_summary: "bool" = False, collect_time_buckets: "bool" = False, completion_time: "str" = None, dispatch_time: "str" = None, enable_preview: "bool" = False, extract_all_fields: "bool" = False, extract_fields: "str" = '', max_time: "int" = 3600, messages: "List[Message]" = None, name: "str" = None, percent_complete: "int" = 0, preview_available: "str" = 'false', query: "str" = None, query_parameters: "QueryParameters" = None, required_freshness: "int" = 0, resolved_earliest: "str" = None, resolved_latest: "str" = None, results_available: "int" = 0, results_preview_available: "int" = 0, sid: "str" = None, status: "SearchStatus" = None, **extra):
        """DeleteSearchJob"""

        self._attrs = dict()
        if index is not None:
            self._attrs["index"] = index
        if module is not None:
            self._attrs["module"] = module
        if predicate is not None:
            self._attrs["predicate"] = predicate
        if allow_side_effects is not None:
            self._attrs["allowSideEffects"] = allow_side_effects
        if collect_event_summary is not None:
            self._attrs["collectEventSummary"] = collect_event_summary
        if collect_field_summary is not None:
            self._attrs["collectFieldSummary"] = collect_field_summary
        if collect_time_buckets is not None:
            self._attrs["collectTimeBuckets"] = collect_time_buckets
        if completion_time is not None:
            self._attrs["completionTime"] = completion_time
        if dispatch_time is not None:
            self._attrs["dispatchTime"] = dispatch_time
        if enable_preview is not None:
            self._attrs["enablePreview"] = enable_preview
        if extract_all_fields is not None:
            self._attrs["extractAllFields"] = extract_all_fields
        if extract_fields is not None:
            self._attrs["extractFields"] = extract_fields
        if max_time is not None:
            self._attrs["maxTime"] = max_time
        if messages is not None:
            self._attrs["messages"] = messages
        if name is not None:
            self._attrs["name"] = name
        if percent_complete is not None:
            self._attrs["percentComplete"] = percent_complete
        if preview_available is not None:
            self._attrs["previewAvailable"] = preview_available
        if query is not None:
            self._attrs["query"] = query
        if query_parameters is not None:
            self._attrs["queryParameters"] = query_parameters.to_dict()
        if required_freshness is not None:
            self._attrs["requiredFreshness"] = required_freshness
        if resolved_earliest is not None:
            self._attrs["resolvedEarliest"] = resolved_earliest
        if resolved_latest is not None:
            self._attrs["resolvedLatest"] = resolved_latest
        if results_available is not None:
            self._attrs["resultsAvailable"] = results_available
        if results_preview_available is not None:
            self._attrs["resultsPreviewAvailable"] = results_preview_available
        if sid is not None:
            self._attrs["sid"] = sid
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def index(self) -> "str":
        """ Gets the index of this DeleteSearchJob.
        The index to delete events from.
        """
        return self._attrs.get("index")

    @index.setter
    def index(self, index: "str"):
        """Sets the index of this DeleteSearchJob.

        The index to delete events from.

        :param index: The index of this DeleteSearchJob.
        :type: str
        """
        if index is None:
            raise ValueError("Invalid value for `index`, must not be `None`")
        self._attrs["index"] = index

    @property
    def module(self) -> "str":
        """ Gets the module of this DeleteSearchJob.
        The module to run the delete search job in. The default module is used if module field is empty.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this DeleteSearchJob.

        The module to run the delete search job in. The default module is used if module field is empty.

        :param module: The module of this DeleteSearchJob.
        :type: str
        """
        if module is None:
            raise ValueError("Invalid value for `module`, must not be `None`")
        self._attrs["module"] = module

    @property
    def predicate(self) -> "str":
        """ Gets the predicate of this DeleteSearchJob.
        The predicate expression that identifies the events to delete from the index. This expression must return true or false. To delete all events from the index, specify \"true\" instead of an expression.
        """
        return self._attrs.get("predicate")

    @predicate.setter
    def predicate(self, predicate: "str"):
        """Sets the predicate of this DeleteSearchJob.

        The predicate expression that identifies the events to delete from the index. This expression must return true or false. To delete all events from the index, specify \"true\" instead of an expression.

        :param predicate: The predicate of this DeleteSearchJob.
        :type: str
        """
        if predicate is None:
            raise ValueError("Invalid value for `predicate`, must not be `None`")
        self._attrs["predicate"] = predicate

    @property
    def allow_side_effects(self) -> "bool":
        """ Gets the allow_side_effects of this DeleteSearchJob.
        Specifies that the delete search job will contain side effects, with possible security risks. 
        """
        return self._attrs.get("allowSideEffects")

    @allow_side_effects.setter
    def allow_side_effects(self, allow_side_effects: "bool"):
        """Sets the allow_side_effects of this DeleteSearchJob.

        Specifies that the delete search job will contain side effects, with possible security risks. 

        :param allow_side_effects: The allow_side_effects of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["allowSideEffects"] = allow_side_effects

    @property
    def collect_event_summary(self) -> "bool":
        """ Gets the collect_event_summary of this DeleteSearchJob.
        This field does not apply to delete search jobs and is defaulted to false. 
        """
        return self._attrs.get("collectEventSummary")

    @collect_event_summary.setter
    def collect_event_summary(self, collect_event_summary: "bool"):
        """Sets the collect_event_summary of this DeleteSearchJob.

        This field does not apply to delete search jobs and is defaulted to false. 

        :param collect_event_summary: The collect_event_summary of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["collectEventSummary"] = collect_event_summary

    @property
    def collect_field_summary(self) -> "bool":
        """ Gets the collect_field_summary of this DeleteSearchJob.
        This field does not apply to delete search jobs and is defaulted to false. 
        """
        return self._attrs.get("collectFieldSummary")

    @collect_field_summary.setter
    def collect_field_summary(self, collect_field_summary: "bool"):
        """Sets the collect_field_summary of this DeleteSearchJob.

        This field does not apply to delete search jobs and is defaulted to false. 

        :param collect_field_summary: The collect_field_summary of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["collectFieldSummary"] = collect_field_summary

    @property
    def collect_time_buckets(self) -> "bool":
        """ Gets the collect_time_buckets of this DeleteSearchJob.
        This field does not apply to delete search jobs and is defaulted to false. 
        """
        return self._attrs.get("collectTimeBuckets")

    @collect_time_buckets.setter
    def collect_time_buckets(self, collect_time_buckets: "bool"):
        """Sets the collect_time_buckets of this DeleteSearchJob.

        This field does not apply to delete search jobs and is defaulted to false. 

        :param collect_time_buckets: The collect_time_buckets of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["collectTimeBuckets"] = collect_time_buckets

    @property
    def completion_time(self) -> "str":
        """ Gets the completion_time of this DeleteSearchJob.
        The time, in GMT, that the search job is finished. Empty if the search job has not completed. 
        """
        return self._attrs.get("completionTime")

    @completion_time.setter
    def completion_time(self, completion_time: "str"):
        """Sets the completion_time of this DeleteSearchJob.

        The time, in GMT, that the search job is finished. Empty if the search job has not completed. 

        :param completion_time: The completion_time of this DeleteSearchJob.
        :type: str
        """
        self._attrs["completionTime"] = completion_time

    @property
    def dispatch_time(self) -> "str":
        """ Gets the dispatch_time of this DeleteSearchJob.
        The time, in GMT, that the search job is dispatched. 
        """
        return self._attrs.get("dispatchTime")

    @dispatch_time.setter
    def dispatch_time(self, dispatch_time: "str"):
        """Sets the dispatch_time of this DeleteSearchJob.

        The time, in GMT, that the search job is dispatched. 

        :param dispatch_time: The dispatch_time of this DeleteSearchJob.
        :type: str
        """
        self._attrs["dispatchTime"] = dispatch_time

    @property
    def enable_preview(self) -> "bool":
        """ Gets the enable_preview of this DeleteSearchJob.
        This field does not apply to delete search jobs and is defaulted to false. 
        """
        return self._attrs.get("enablePreview")

    @enable_preview.setter
    def enable_preview(self, enable_preview: "bool"):
        """Sets the enable_preview of this DeleteSearchJob.

        This field does not apply to delete search jobs and is defaulted to false. 

        :param enable_preview: The enable_preview of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["enablePreview"] = enable_preview

    @property
    def extract_all_fields(self) -> "bool":
        """ Gets the extract_all_fields of this DeleteSearchJob.
        Specifies whether the Search service should extract all of the available fields in the data, including fields not mentioned in the SPL for the search job. Set to 'false' for better search peformance. The 'extractAllFields' parameter is deprecated as of version v3alpha1. Although this parameter continues to function, it might be removed in a future version. Use the 'extractFields' parameter instead. 
        """
        return self._attrs.get("extractAllFields")

    @extract_all_fields.setter
    def extract_all_fields(self, extract_all_fields: "bool"):
        """Sets the extract_all_fields of this DeleteSearchJob.

        Specifies whether the Search service should extract all of the available fields in the data, including fields not mentioned in the SPL for the search job. Set to 'false' for better search peformance. The 'extractAllFields' parameter is deprecated as of version v3alpha1. Although this parameter continues to function, it might be removed in a future version. Use the 'extractFields' parameter instead. 

        :param extract_all_fields: The extract_all_fields of this DeleteSearchJob.
        :type: bool
        """
        self._attrs["extractAllFields"] = extract_all_fields

    @property
    def extract_fields(self) -> "str":
        """ Gets the extract_fields of this DeleteSearchJob.
        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' will extract all fields, 'indexed' will extract only indexed fields, and 'none' will extract only the default fields. This parameter overwrites the value of the 'extractAllFields' parameter. Set to 'none' for better search performance. 
        """
        return self._attrs.get("extractFields")

    @extract_fields.setter
    def extract_fields(self, extract_fields: "str"):
        """Sets the extract_fields of this DeleteSearchJob.

        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' will extract all fields, 'indexed' will extract only indexed fields, and 'none' will extract only the default fields. This parameter overwrites the value of the 'extractAllFields' parameter. Set to 'none' for better search performance. 

        :param extract_fields: The extract_fields of this DeleteSearchJob.
        :type: str
        """
        self._attrs["extractFields"] = extract_fields

    @property
    def max_time(self) -> "int":
        """ Gets the max_time of this DeleteSearchJob.
        The amount of time, in seconds, to run the delete search job before finalizing the search. The maximum value is 3600 seconds (1 hour). 
        """
        return self._attrs.get("maxTime")

    @max_time.setter
    def max_time(self, max_time: "int"):
        """Sets the max_time of this DeleteSearchJob.

        The amount of time, in seconds, to run the delete search job before finalizing the search. The maximum value is 3600 seconds (1 hour). 

        :param max_time: The max_time of this DeleteSearchJob.
        :type: int
        """
        self._attrs["maxTime"] = max_time

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this DeleteSearchJob.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this DeleteSearchJob.


        :param messages: The messages of this DeleteSearchJob.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def name(self) -> "str":
        """ Gets the name of this DeleteSearchJob.
        The name of the created search job.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this DeleteSearchJob.

        The name of the created search job.

        :param name: The name of this DeleteSearchJob.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def percent_complete(self) -> "int":
        """ Gets the percent_complete of this DeleteSearchJob.
        An estimate of the percent of time remaining before the delete search job completes.
        """
        return self._attrs.get("percentComplete")

    @percent_complete.setter
    def percent_complete(self, percent_complete: "int"):
        """Sets the percent_complete of this DeleteSearchJob.

        An estimate of the percent of time remaining before the delete search job completes.

        :param percent_complete: The percent_complete of this DeleteSearchJob.
        :type: int
        """
        self._attrs["percentComplete"] = percent_complete

    @property
    def preview_available(self) -> "str":
        """ Gets the preview_available of this DeleteSearchJob.
        This field does not apply to delete search jobs and is defaulted to false.
        """
        return self._attrs.get("previewAvailable")

    @preview_available.setter
    def preview_available(self, preview_available: "str"):
        """Sets the preview_available of this DeleteSearchJob.

        This field does not apply to delete search jobs and is defaulted to false.

        :param preview_available: The preview_available of this DeleteSearchJob.
        :type: str
        """
        self._attrs["previewAvailable"] = preview_available

    @property
    def query(self) -> "str":
        """ Gets the query of this DeleteSearchJob.
        The SPL search string that is generated based on index, module and predicate that are specified.
        """
        return self._attrs.get("query")

    @query.setter
    def query(self, query: "str"):
        """Sets the query of this DeleteSearchJob.

        The SPL search string that is generated based on index, module and predicate that are specified.

        :param query: The query of this DeleteSearchJob.
        :type: str
        """
        self._attrs["query"] = query

    @property
    def query_parameters(self) -> "QueryParameters":
        """ Gets the query_parameters of this DeleteSearchJob.
        Represents parameters on the search job such as 'earliest' and 'latest'.
        """
        return QueryParameters._from_dict(self._attrs["queryParameters"])

    @query_parameters.setter
    def query_parameters(self, query_parameters: "QueryParameters"):
        """Sets the query_parameters of this DeleteSearchJob.

        Represents parameters on the search job such as 'earliest' and 'latest'.

        :param query_parameters: The query_parameters of this DeleteSearchJob.
        :type: QueryParameters
        """
        self._attrs["queryParameters"] = query_parameters.to_dict()

    @property
    def required_freshness(self) -> "int":
        """ Gets the required_freshness of this DeleteSearchJob.
        This field does not apply to delete search jobs and is set to 0. 
        """
        return self._attrs.get("requiredFreshness")

    @required_freshness.setter
    def required_freshness(self, required_freshness: "int"):
        """Sets the required_freshness of this DeleteSearchJob.

        This field does not apply to delete search jobs and is set to 0. 

        :param required_freshness: The required_freshness of this DeleteSearchJob.
        :type: int
        """
        self._attrs["requiredFreshness"] = required_freshness

    @property
    def resolved_earliest(self) -> "str":
        """ Gets the resolved_earliest of this DeleteSearchJob.
        The earliest time speciifed as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedEarliest")

    @resolved_earliest.setter
    def resolved_earliest(self, resolved_earliest: "str"):
        """Sets the resolved_earliest of this DeleteSearchJob.

        The earliest time speciifed as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 

        :param resolved_earliest: The resolved_earliest of this DeleteSearchJob.
        :type: str
        """
        self._attrs["resolvedEarliest"] = resolved_earliest

    @property
    def resolved_latest(self) -> "str":
        """ Gets the resolved_latest of this DeleteSearchJob.
        The latest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedLatest")

    @resolved_latest.setter
    def resolved_latest(self, resolved_latest: "str"):
        """Sets the resolved_latest of this DeleteSearchJob.

        The latest time specified as an absolute value in GMT. The time is computed based on the values you specify for the 'timezone' and 'earliest' queryParameters. 

        :param resolved_latest: The resolved_latest of this DeleteSearchJob.
        :type: str
        """
        self._attrs["resolvedLatest"] = resolved_latest

    @property
    def results_available(self) -> "int":
        """ Gets the results_available of this DeleteSearchJob.
        The number of results produced so far by the delete search job that are going to be deleted.
        """
        return self._attrs.get("resultsAvailable")

    @results_available.setter
    def results_available(self, results_available: "int"):
        """Sets the results_available of this DeleteSearchJob.

        The number of results produced so far by the delete search job that are going to be deleted.

        :param results_available: The results_available of this DeleteSearchJob.
        :type: int
        """
        self._attrs["resultsAvailable"] = results_available

    @property
    def results_preview_available(self) -> "int":
        """ Gets the results_preview_available of this DeleteSearchJob.
        This field does not apply to delete search jobs and is defaulted to 0.
        """
        return self._attrs.get("resultsPreviewAvailable")

    @results_preview_available.setter
    def results_preview_available(self, results_preview_available: "int"):
        """Sets the results_preview_available of this DeleteSearchJob.

        This field does not apply to delete search jobs and is defaulted to 0.

        :param results_preview_available: The results_preview_available of this DeleteSearchJob.
        :type: int
        """
        self._attrs["resultsPreviewAvailable"] = results_preview_available

    @property
    def sid(self) -> "str":
        """ Gets the sid of this DeleteSearchJob.
        The ID assigned to the delete search job.
        """
        return self._attrs.get("sid")

    @sid.setter
    def sid(self, sid: "str"):
        """Sets the sid of this DeleteSearchJob.

        The ID assigned to the delete search job.

        :param sid: The sid of this DeleteSearchJob.
        :type: str
        """
        self._attrs["sid"] = sid

    @property
    def status(self) -> "SearchStatus":
        """ Gets the status of this DeleteSearchJob.
        """
        return SearchStatus.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "SearchStatus"):
        """Sets the status of this DeleteSearchJob.


        :param status: The status of this DeleteSearchJob.
        :type: SearchStatus
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FederatedConnection(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FederatedConnection":
        instance = FederatedConnection.__new__(FederatedConnection)
        instance._attrs = model
        return instance

    def __init__(self, created: "str" = None, createdby: "str" = None, hostnameip: "str" = None, modified: "str" = None, modifiedby: "str" = None, name: "str" = None, port: "float" = None, serviceaccountuser: "str" = None, **extra):
        """FederatedConnection"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if hostnameip is not None:
            self._attrs["hostnameip"] = hostnameip
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if name is not None:
            self._attrs["name"] = name
        if port is not None:
            self._attrs["port"] = port
        if serviceaccountuser is not None:
            self._attrs["serviceaccountuser"] = serviceaccountuser
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this FederatedConnection.
        The timestamp when the federated connection was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this FederatedConnection.

        The timestamp when the federated connection was created.

        :param created: The created of this FederatedConnection.
        :type: str
        """
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this FederatedConnection.
        The user who created the federated connection.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this FederatedConnection.

        The user who created the federated connection.

        :param createdby: The createdby of this FederatedConnection.
        :type: str
        """
        self._attrs["createdby"] = createdby

    @property
    def hostnameip(self) -> "str":
        """ Gets the hostnameip of this FederatedConnection.
        The remote hostname to connect yo.
        """
        return self._attrs.get("hostnameip")

    @hostnameip.setter
    def hostnameip(self, hostnameip: "str"):
        """Sets the hostnameip of this FederatedConnection.

        The remote hostname to connect yo.

        :param hostnameip: The hostnameip of this FederatedConnection.
        :type: str
        """
        self._attrs["hostnameip"] = hostnameip

    @property
    def modified(self) -> "str":
        """ Gets the modified of this FederatedConnection.
        The timestamp when the federated connection was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "str"):
        """Sets the modified of this FederatedConnection.

        The timestamp when the federated connection was modified.

        :param modified: The modified of this FederatedConnection.
        :type: str
        """
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this FederatedConnection.
        The user who last modified the federated connection.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this FederatedConnection.

        The user who last modified the federated connection.

        :param modifiedby: The modifiedby of this FederatedConnection.
        :type: str
        """
        self._attrs["modifiedby"] = modifiedby

    @property
    def name(self) -> "str":
        """ Gets the name of this FederatedConnection.
        The name of the federated connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FederatedConnection.

        The name of the federated connection.

        :param name: The name of this FederatedConnection.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def port(self) -> "float":
        """ Gets the port of this FederatedConnection.
        The remote port number.
        """
        return self._attrs.get("port")

    @port.setter
    def port(self, port: "float"):
        """Sets the port of this FederatedConnection.

        The remote port number.

        :param port: The port of this FederatedConnection.
        :type: float
        """
        self._attrs["port"] = port

    @property
    def serviceaccountuser(self) -> "str":
        """ Gets the serviceaccountuser of this FederatedConnection.
        The username on the service account.
        """
        return self._attrs.get("serviceaccountuser")

    @serviceaccountuser.setter
    def serviceaccountuser(self, serviceaccountuser: "str"):
        """Sets the serviceaccountuser of this FederatedConnection.

        The username on the service account.

        :param serviceaccountuser: The serviceaccountuser of this FederatedConnection.
        :type: str
        """
        self._attrs["serviceaccountuser"] = serviceaccountuser

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FederatedConnectionInput(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FederatedConnectionInput":
        instance = FederatedConnectionInput.__new__(FederatedConnectionInput)
        instance._attrs = model
        return instance

    def __init__(self, hostnameip: "str" = None, name: "str" = None, port: "float" = None, serviceaccountuser: "str" = None, **extra):
        """FederatedConnectionInput"""

        self._attrs = dict()
        if hostnameip is not None:
            self._attrs["hostnameip"] = hostnameip
        if name is not None:
            self._attrs["name"] = name
        if port is not None:
            self._attrs["port"] = port
        if serviceaccountuser is not None:
            self._attrs["serviceaccountuser"] = serviceaccountuser
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def hostnameip(self) -> "str":
        """ Gets the hostnameip of this FederatedConnectionInput.
        The remote hostname to connect to.
        """
        return self._attrs.get("hostnameip")

    @hostnameip.setter
    def hostnameip(self, hostnameip: "str"):
        """Sets the hostnameip of this FederatedConnectionInput.

        The remote hostname to connect to.

        :param hostnameip: The hostnameip of this FederatedConnectionInput.
        :type: str
        """
        self._attrs["hostnameip"] = hostnameip

    @property
    def name(self) -> "str":
        """ Gets the name of this FederatedConnectionInput.
        The name of the federated connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FederatedConnectionInput.

        The name of the federated connection.

        :param name: The name of this FederatedConnectionInput.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def port(self) -> "float":
        """ Gets the port of this FederatedConnectionInput.
        The remote port number.
        """
        return self._attrs.get("port")

    @port.setter
    def port(self, port: "float"):
        """Sets the port of this FederatedConnectionInput.

        The remote port number.

        :param port: The port of this FederatedConnectionInput.
        :type: float
        """
        self._attrs["port"] = port

    @property
    def serviceaccountuser(self) -> "str":
        """ Gets the serviceaccountuser of this FederatedConnectionInput.
        The username on the service account.
        """
        return self._attrs.get("serviceaccountuser")

    @serviceaccountuser.setter
    def serviceaccountuser(self, serviceaccountuser: "str"):
        """Sets the serviceaccountuser of this FederatedConnectionInput.

        The username on the service account.

        :param serviceaccountuser: The serviceaccountuser of this FederatedConnectionInput.
        :type: str
        """
        self._attrs["serviceaccountuser"] = serviceaccountuser

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FederatedDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "FederatedDataset":
        instance = FederatedDataset.__new__(FederatedDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "str", createdby: "str", id: "str", modified: "str", modifiedby: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, federated_connection: "str" = None, federated_dataset: "str" = None, federated_dataset_kind: "str" = None, namespace: "str" = None, summary: "str" = None, title: "str" = None, **extra):
        """FederatedDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if federated_connection is not None:
            self._attrs["federatedConnection"] = federated_connection
        if federated_dataset is not None:
            self._attrs["federatedDataset"] = federated_dataset
        if federated_dataset_kind is not None:
            self._attrs["federatedDatasetKind"] = federated_dataset_kind
        self._attrs["kind"] = "federated" 
        if namespace is not None:
            self._attrs["namespace"] = namespace
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this FederatedDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this FederatedDataset.

        The date and time object was created.

        :param created: The created of this FederatedDataset.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this FederatedDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this FederatedDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this FederatedDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this FederatedDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this FederatedDataset.

        A unique dataset ID.

        :param id: The id of this FederatedDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "str":
        """ Gets the modified of this FederatedDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "str"):
        """Sets the modified of this FederatedDataset.

        The date and time object was modified.

        :param modified: The modified of this FederatedDataset.
        :type: str
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this FederatedDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this FederatedDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this FederatedDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def name(self) -> "str":
        """ Gets the name of this FederatedDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FederatedDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this FederatedDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this FederatedDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this FederatedDataset.

        The name of the object's owner.

        :param owner: The owner of this FederatedDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this FederatedDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this FederatedDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this FederatedDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this FederatedDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this FederatedDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this FederatedDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this FederatedDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this FederatedDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this FederatedDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this FederatedDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this FederatedDataset.

        Detailed description of the dataset.

        :param description: The description of this FederatedDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def federated_connection(self) -> "str":
        """ Gets the federated_connection of this FederatedDataset.
        Connection information to connect to remote federated connection.
        """
        return self._attrs.get("federatedConnection")

    @federated_connection.setter
    def federated_connection(self, federated_connection: "str"):
        """Sets the federated_connection of this FederatedDataset.

        Connection information to connect to remote federated connection.

        :param federated_connection: The federated_connection of this FederatedDataset.
        :type: str
        """
        self._attrs["federatedConnection"] = federated_connection

    @property
    def federated_dataset(self) -> "str":
        """ Gets the federated_dataset of this FederatedDataset.
        Dataset information in the remote instance.
        """
        return self._attrs.get("federatedDataset")

    @federated_dataset.setter
    def federated_dataset(self, federated_dataset: "str"):
        """Sets the federated_dataset of this FederatedDataset.

        Dataset information in the remote instance.

        :param federated_dataset: The federated_dataset of this FederatedDataset.
        :type: str
        """
        self._attrs["federatedDataset"] = federated_dataset

    @property
    def federated_dataset_kind(self) -> "str":
        """ Gets the federated_dataset_kind of this FederatedDataset.
        Dataset kind information in the remote instance.
        """
        return self._attrs.get("federatedDatasetKind")

    @federated_dataset_kind.setter
    def federated_dataset_kind(self, federated_dataset_kind: "str"):
        """Sets the federated_dataset_kind of this FederatedDataset.

        Dataset kind information in the remote instance.

        :param federated_dataset_kind: The federated_dataset_kind of this FederatedDataset.
        :type: str
        """
        self._attrs["federatedDatasetKind"] = federated_dataset_kind

    @property
    def kind(self) -> str:
        return "federated"


    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this FederatedDataset.
        The name of the namespace that contains the dataset.
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this FederatedDataset.

        The name of the namespace that contains the dataset.

        :param namespace: The namespace of this FederatedDataset.
        :type: str
        """
        self._attrs["namespace"] = namespace

    @property
    def summary(self) -> "str":
        """ Gets the summary of this FederatedDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this FederatedDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this FederatedDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this FederatedDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this FederatedDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this FederatedDataset.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["federated"] = FederatedDataset._from_dict



class FederatedDatasetKind(str, Enum):
    FEDERATED = "federated"

    @staticmethod
    def from_value(value: str):
        if value == "federated":
            return FederatedDatasetKind.FEDERATED


class FederatedDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "FederatedDatasetPATCH":
        instance = FederatedDatasetPATCH.__new__(FederatedDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, federated_connection: "str" = None, federated_dataset: "str" = None, federated_dataset_kind: "str" = None, kind: "FederatedDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """FederatedDatasetPATCH"""

        self._attrs = dict()
        if federated_connection is not None:
            self._attrs["federatedConnection"] = federated_connection
        if federated_dataset is not None:
            self._attrs["federatedDataset"] = federated_dataset
        if federated_dataset_kind is not None:
            self._attrs["federatedDatasetKind"] = federated_dataset_kind
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def federated_connection(self) -> "str":
        """ Gets the federated_connection of this FederatedDatasetPATCH.
        Connection information to connect to remote federated connection.
        """
        return self._attrs.get("federatedConnection")

    @federated_connection.setter
    def federated_connection(self, federated_connection: "str"):
        """Sets the federated_connection of this FederatedDatasetPATCH.

        Connection information to connect to remote federated connection.

        :param federated_connection: The federated_connection of this FederatedDatasetPATCH.
        :type: str
        """
        self._attrs["federatedConnection"] = federated_connection

    @property
    def federated_dataset(self) -> "str":
        """ Gets the federated_dataset of this FederatedDatasetPATCH.
        Dataset information in the remote instance.
        """
        return self._attrs.get("federatedDataset")

    @federated_dataset.setter
    def federated_dataset(self, federated_dataset: "str"):
        """Sets the federated_dataset of this FederatedDatasetPATCH.

        Dataset information in the remote instance.

        :param federated_dataset: The federated_dataset of this FederatedDatasetPATCH.
        :type: str
        """
        self._attrs["federatedDataset"] = federated_dataset

    @property
    def federated_dataset_kind(self) -> "str":
        """ Gets the federated_dataset_kind of this FederatedDatasetPATCH.
        Dataset kind information in the remote instance.
        """
        return self._attrs.get("federatedDatasetKind")

    @federated_dataset_kind.setter
    def federated_dataset_kind(self, federated_dataset_kind: "str"):
        """Sets the federated_dataset_kind of this FederatedDatasetPATCH.

        Dataset kind information in the remote instance.

        :param federated_dataset_kind: The federated_dataset_kind of this FederatedDatasetPATCH.
        :type: str
        """
        self._attrs["federatedDatasetKind"] = federated_dataset_kind

    @property
    def kind(self) -> "FederatedDatasetKind":
        """ Gets the kind of this FederatedDatasetPATCH.
        """
        return FederatedDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "FederatedDatasetKind"):
        """Sets the kind of this FederatedDatasetPATCH.


        :param kind: The kind of this FederatedDatasetPATCH.
        :type: FederatedDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this FederatedDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this FederatedDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this FederatedDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this FederatedDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this FederatedDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this FederatedDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this FederatedDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this FederatedDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this FederatedDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SingleFieldSummary(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SingleFieldSummary":
        instance = SingleFieldSummary.__new__(SingleFieldSummary)
        instance._attrs = model
        return instance

    def __init__(self, count: "int" = None, distinct_count: "int" = None, is_exact: "bool" = None, max: "str" = None, mean: "float" = None, min: "str" = None, modes: "List[SingleValueMode]" = None, numeric_count: "int" = None, relevant: "bool" = None, stddev: "float" = None, **extra):
        """SingleFieldSummary"""

        self._attrs = dict()
        if count is not None:
            self._attrs["count"] = count
        if distinct_count is not None:
            self._attrs["distinctCount"] = distinct_count
        if is_exact is not None:
            self._attrs["isExact"] = is_exact
        if max is not None:
            self._attrs["max"] = max
        if mean is not None:
            self._attrs["mean"] = mean
        if min is not None:
            self._attrs["min"] = min
        if modes is not None:
            self._attrs["modes"] = modes
        if numeric_count is not None:
            self._attrs["numericCount"] = numeric_count
        if relevant is not None:
            self._attrs["relevant"] = relevant
        if stddev is not None:
            self._attrs["stddev"] = stddev
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def count(self) -> "int":
        """ Gets the count of this SingleFieldSummary.
        The total number of events that contain the field.
        """
        return self._attrs.get("count")

    @count.setter
    def count(self, count: "int"):
        """Sets the count of this SingleFieldSummary.

        The total number of events that contain the field.

        :param count: The count of this SingleFieldSummary.
        :type: int
        """
        self._attrs["count"] = count

    @property
    def distinct_count(self) -> "int":
        """ Gets the distinct_count of this SingleFieldSummary.
        The total number of unique values in the field.
        """
        return self._attrs.get("distinctCount")

    @distinct_count.setter
    def distinct_count(self, distinct_count: "int"):
        """Sets the distinct_count of this SingleFieldSummary.

        The total number of unique values in the field.

        :param distinct_count: The distinct_count of this SingleFieldSummary.
        :type: int
        """
        self._attrs["distinctCount"] = distinct_count

    @property
    def is_exact(self) -> "bool":
        """ Gets the is_exact of this SingleFieldSummary.
        Specifies if the 'distinctCount' is accurate.  The 'isExact' property is FALSE when the 'distinctCount'  exceeds the maximum count and an exact count is not available. 
        """
        return self._attrs.get("isExact")

    @is_exact.setter
    def is_exact(self, is_exact: "bool"):
        """Sets the is_exact of this SingleFieldSummary.

        Specifies if the 'distinctCount' is accurate.  The 'isExact' property is FALSE when the 'distinctCount'  exceeds the maximum count and an exact count is not available. 

        :param is_exact: The is_exact of this SingleFieldSummary.
        :type: bool
        """
        self._attrs["isExact"] = is_exact

    @property
    def max(self) -> "str":
        """ Gets the max of this SingleFieldSummary.
        The maximum numeric values in the field.
        """
        return self._attrs.get("max")

    @max.setter
    def max(self, max: "str"):
        """Sets the max of this SingleFieldSummary.

        The maximum numeric values in the field.

        :param max: The max of this SingleFieldSummary.
        :type: str
        """
        self._attrs["max"] = max

    @property
    def mean(self) -> "float":
        """ Gets the mean of this SingleFieldSummary.
        The mean (average) for the numeric values in the field.
        """
        return self._attrs.get("mean")

    @mean.setter
    def mean(self, mean: "float"):
        """Sets the mean of this SingleFieldSummary.

        The mean (average) for the numeric values in the field.

        :param mean: The mean of this SingleFieldSummary.
        :type: float
        """
        self._attrs["mean"] = mean

    @property
    def min(self) -> "str":
        """ Gets the min of this SingleFieldSummary.
        The minimum numeric values in the field.
        """
        return self._attrs.get("min")

    @min.setter
    def min(self, min: "str"):
        """Sets the min of this SingleFieldSummary.

        The minimum numeric values in the field.

        :param min: The min of this SingleFieldSummary.
        :type: str
        """
        self._attrs["min"] = min

    @property
    def modes(self) -> "List[SingleValueMode]":
        """ Gets the modes of this SingleFieldSummary.
        An array of the values in the field.
        """
        return [SingleValueMode._from_dict(i) for i in self._attrs.get("modes")]

    @modes.setter
    def modes(self, modes: "List[SingleValueMode]"):
        """Sets the modes of this SingleFieldSummary.

        An array of the values in the field.

        :param modes: The modes of this SingleFieldSummary.
        :type: List[SingleValueMode]
        """
        self._attrs["modes"] = modes

    @property
    def numeric_count(self) -> "int":
        """ Gets the numeric_count of this SingleFieldSummary.
        The count of the numeric values in the field.
        """
        return self._attrs.get("numericCount")

    @numeric_count.setter
    def numeric_count(self, numeric_count: "int"):
        """Sets the numeric_count of this SingleFieldSummary.

        The count of the numeric values in the field.

        :param numeric_count: The numeric_count of this SingleFieldSummary.
        :type: int
        """
        self._attrs["numericCount"] = numeric_count

    @property
    def relevant(self) -> "bool":
        """ Gets the relevant of this SingleFieldSummary.
        Specifies if the field was added or changed by the search.
        """
        return self._attrs.get("relevant")

    @relevant.setter
    def relevant(self, relevant: "bool"):
        """Sets the relevant of this SingleFieldSummary.

        Specifies if the field was added or changed by the search.

        :param relevant: The relevant of this SingleFieldSummary.
        :type: bool
        """
        self._attrs["relevant"] = relevant

    @property
    def stddev(self) -> "float":
        """ Gets the stddev of this SingleFieldSummary.
        The standard deviation for the numeric values in the field.
        """
        return self._attrs.get("stddev")

    @stddev.setter
    def stddev(self, stddev: "float"):
        """Sets the stddev of this SingleFieldSummary.

        The standard deviation for the numeric values in the field.

        :param stddev: The stddev of this SingleFieldSummary.
        :type: float
        """
        self._attrs["stddev"] = stddev

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SingleValueMode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SingleValueMode":
        instance = SingleValueMode.__new__(SingleValueMode)
        instance._attrs = model
        return instance

    def __init__(self, count: "int" = None, is_exact: "bool" = None, value: "str" = None, **extra):
        """SingleValueMode"""

        self._attrs = dict()
        if count is not None:
            self._attrs["count"] = count
        if is_exact is not None:
            self._attrs["isExact"] = is_exact
        if value is not None:
            self._attrs["value"] = value
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def count(self) -> "int":
        """ Gets the count of this SingleValueMode.
        The number of occurences that the value appears in a field.
        """
        return self._attrs.get("count")

    @count.setter
    def count(self, count: "int"):
        """Sets the count of this SingleValueMode.

        The number of occurences that the value appears in a field.

        :param count: The count of this SingleValueMode.
        :type: int
        """
        self._attrs["count"] = count

    @property
    def is_exact(self) -> "bool":
        """ Gets the is_exact of this SingleValueMode.
        Specifies if the count is accurate.  The 'isExact' property is FALSE when the 'count' exceeds  the maximum count and an exact count is not available. 
        """
        return self._attrs.get("isExact")

    @is_exact.setter
    def is_exact(self, is_exact: "bool"):
        """Sets the is_exact of this SingleValueMode.

        Specifies if the count is accurate.  The 'isExact' property is FALSE when the 'count' exceeds  the maximum count and an exact count is not available. 

        :param is_exact: The is_exact of this SingleValueMode.
        :type: bool
        """
        self._attrs["isExact"] = is_exact

    @property
    def value(self) -> "str":
        """ Gets the value of this SingleValueMode.
        The value in the field.
        """
        return self._attrs.get("value")

    @value.setter
    def value(self, value: "str"):
        """Sets the value of this SingleValueMode.

        The value in the field.

        :param value: The value of this SingleValueMode.
        :type: str
        """
        self._attrs["value"] = value

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FieldsSummary(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FieldsSummary":
        instance = FieldsSummary.__new__(FieldsSummary)
        instance._attrs = model
        return instance

    def __init__(self, duration: "float" = None, earliest_time: "str" = None, event_count: "int" = None, fields: "Dict[str, SingleFieldSummary]" = None, latest_time: "str" = None, **extra):
        """FieldsSummary"""

        self._attrs = dict()
        if duration is not None:
            self._attrs["duration"] = duration
        if earliest_time is not None:
            self._attrs["earliestTime"] = earliest_time
        if event_count is not None:
            self._attrs["eventCount"] = event_count
        if fields is not None:
            self._attrs["fields"] = fields
        if latest_time is not None:
            self._attrs["latestTime"] = latest_time
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def duration(self) -> "float":
        """ Gets the duration of this FieldsSummary.
        The amount of time, in seconds, that a time bucket  spans from the earliest to the latest time. 
        """
        return self._attrs.get("duration")

    @duration.setter
    def duration(self, duration: "float"):
        """Sets the duration of this FieldsSummary.

        The amount of time, in seconds, that a time bucket  spans from the earliest to the latest time. 

        :param duration: The duration of this FieldsSummary.
        :type: float
        """
        self._attrs["duration"] = duration

    @property
    def earliest_time(self) -> "str":
        """ Gets the earliest_time of this FieldsSummary.
        If specified, the earliest timestamp in UTC format  of the events to process. 
        """
        return self._attrs.get("earliestTime")

    @earliest_time.setter
    def earliest_time(self, earliest_time: "str"):
        """Sets the earliest_time of this FieldsSummary.

        If specified, the earliest timestamp in UTC format  of the events to process. 

        :param earliest_time: The earliest_time of this FieldsSummary.
        :type: str
        """
        self._attrs["earliestTime"] = earliest_time

    @property
    def event_count(self) -> "int":
        """ Gets the event_count of this FieldsSummary.
        The total number of events for all fields returned  in the time range ('earliestTime' and 'latestTime') specified. 
        """
        return self._attrs.get("eventCount")

    @event_count.setter
    def event_count(self, event_count: "int"):
        """Sets the event_count of this FieldsSummary.

        The total number of events for all fields returned  in the time range ('earliestTime' and 'latestTime') specified. 

        :param event_count: The event_count of this FieldsSummary.
        :type: int
        """
        self._attrs["eventCount"] = event_count

    @property
    def fields(self) -> "Dict[str, SingleFieldSummary]":
        """ Gets the fields of this FieldsSummary.
        A map of the fields in the time range specified.
        """
        return self._attrs.get("fields")

    @fields.setter
    def fields(self, fields: "Dict[str, SingleFieldSummary]"):
        """Sets the fields of this FieldsSummary.

        A map of the fields in the time range specified.

        :param fields: The fields of this FieldsSummary.
        :type: Dict[str, SingleFieldSummary]
        """
        self._attrs["fields"] = fields

    @property
    def latest_time(self) -> "str":
        """ Gets the latest_time of this FieldsSummary.
        If specified, the latest timestamp in UTC format  of the events to process. 
        """
        return self._attrs.get("latestTime")

    @latest_time.setter
    def latest_time(self, latest_time: "str"):
        """Sets the latest_time of this FieldsSummary.

        If specified, the latest timestamp in UTC format  of the events to process. 

        :param latest_time: The latest_time of this FieldsSummary.
        :type: str
        """
        self._attrs["latestTime"] = latest_time

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class IndexDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "IndexDataset":
        instance = IndexDataset.__new__(IndexDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "str", createdby: "str", id: "str", modified: "str", modifiedby: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, disabled: "bool" = None, earliest_event_time: "str" = None, earliest_ingest_time: "str" = None, frozen_time_period_in_secs: "int" = None, latest_event_time: "str" = None, latest_ingest_time: "str" = None, latest_metadata_update_time: "str" = None, namespace: "str" = None, summary: "str" = None, title: "str" = None, total_event_count: "int" = None, total_size: "int" = None, **extra):
        """IndexDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if earliest_event_time is not None:
            self._attrs["earliestEventTime"] = earliest_event_time
        if earliest_ingest_time is not None:
            self._attrs["earliestIngestTime"] = earliest_ingest_time
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        self._attrs["kind"] = "index" 
        if latest_event_time is not None:
            self._attrs["latestEventTime"] = latest_event_time
        if latest_ingest_time is not None:
            self._attrs["latestIngestTime"] = latest_ingest_time
        if latest_metadata_update_time is not None:
            self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time
        if namespace is not None:
            self._attrs["namespace"] = namespace
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if total_event_count is not None:
            self._attrs["totalEventCount"] = total_event_count
        if total_size is not None:
            self._attrs["totalSize"] = total_size
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this IndexDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this IndexDataset.

        The date and time object was created.

        :param created: The created of this IndexDataset.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this IndexDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this IndexDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this IndexDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this IndexDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this IndexDataset.

        A unique dataset ID.

        :param id: The id of this IndexDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "str":
        """ Gets the modified of this IndexDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "str"):
        """Sets the modified of this IndexDataset.

        The date and time object was modified.

        :param modified: The modified of this IndexDataset.
        :type: str
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this IndexDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this IndexDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this IndexDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def name(self) -> "str":
        """ Gets the name of this IndexDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this IndexDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this IndexDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this IndexDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this IndexDataset.

        The name of the object's owner.

        :param owner: The owner of this IndexDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this IndexDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this IndexDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this IndexDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this IndexDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this IndexDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this IndexDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this IndexDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this IndexDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this IndexDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this IndexDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this IndexDataset.

        Detailed description of the dataset.

        :param description: The description of this IndexDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this IndexDataset.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this IndexDataset.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this IndexDataset.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def earliest_event_time(self) -> "str":
        """ Gets the earliest_event_time of this IndexDataset.
        The timestamp, in seconds, of the earliest event. The timestamp is in UNIX time.
        """
        return self._attrs.get("earliestEventTime")

    @earliest_event_time.setter
    def earliest_event_time(self, earliest_event_time: "str"):
        """Sets the earliest_event_time of this IndexDataset.

        The timestamp, in seconds, of the earliest event. The timestamp is in UNIX time.

        :param earliest_event_time: The earliest_event_time of this IndexDataset.
        :type: str
        """
        self._attrs["earliestEventTime"] = earliest_event_time

    @property
    def earliest_ingest_time(self) -> "str":
        """ Gets the earliest_ingest_time of this IndexDataset.
        The earliest index time for any of the events in this index.
        """
        return self._attrs.get("earliestIngestTime")

    @earliest_ingest_time.setter
    def earliest_ingest_time(self, earliest_ingest_time: "str"):
        """Sets the earliest_ingest_time of this IndexDataset.

        The earliest index time for any of the events in this index.

        :param earliest_ingest_time: The earliest_ingest_time of this IndexDataset.
        :type: str
        """
        self._attrs["earliestIngestTime"] = earliest_ingest_time

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this IndexDataset.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this IndexDataset.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this IndexDataset.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def kind(self) -> str:
        return "index"


    @property
    def latest_event_time(self) -> "str":
        """ Gets the latest_event_time of this IndexDataset.
        The timestamp, in seconds, of the latest event. The timestamp is in UNIX time.
        """
        return self._attrs.get("latestEventTime")

    @latest_event_time.setter
    def latest_event_time(self, latest_event_time: "str"):
        """Sets the latest_event_time of this IndexDataset.

        The timestamp, in seconds, of the latest event. The timestamp is in UNIX time.

        :param latest_event_time: The latest_event_time of this IndexDataset.
        :type: str
        """
        self._attrs["latestEventTime"] = latest_event_time

    @property
    def latest_ingest_time(self) -> "str":
        """ Gets the latest_ingest_time of this IndexDataset.
        The latest index time for any of the events in this index.
        """
        return self._attrs.get("latestIngestTime")

    @latest_ingest_time.setter
    def latest_ingest_time(self, latest_ingest_time: "str"):
        """Sets the latest_ingest_time of this IndexDataset.

        The latest index time for any of the events in this index.

        :param latest_ingest_time: The latest_ingest_time of this IndexDataset.
        :type: str
        """
        self._attrs["latestIngestTime"] = latest_ingest_time

    @property
    def latest_metadata_update_time(self) -> "str":
        """ Gets the latest_metadata_update_time of this IndexDataset.
        The latest time that the index metadata was refreshed.
        """
        return self._attrs.get("latestMetadataUpdateTime")

    @latest_metadata_update_time.setter
    def latest_metadata_update_time(self, latest_metadata_update_time: "str"):
        """Sets the latest_metadata_update_time of this IndexDataset.

        The latest time that the index metadata was refreshed.

        :param latest_metadata_update_time: The latest_metadata_update_time of this IndexDataset.
        :type: str
        """
        self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time

    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this IndexDataset.
        The name of the namespace that contains the dataset.
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this IndexDataset.

        The name of the namespace that contains the dataset.

        :param namespace: The namespace of this IndexDataset.
        :type: str
        """
        self._attrs["namespace"] = namespace

    @property
    def summary(self) -> "str":
        """ Gets the summary of this IndexDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this IndexDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this IndexDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this IndexDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this IndexDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this IndexDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def total_event_count(self) -> "int":
        """ Gets the total_event_count of this IndexDataset.
        The number of events in the index.
        """
        return self._attrs.get("totalEventCount")

    @total_event_count.setter
    def total_event_count(self, total_event_count: "int"):
        """Sets the total_event_count of this IndexDataset.

        The number of events in the index.

        :param total_event_count: The total_event_count of this IndexDataset.
        :type: int
        """
        self._attrs["totalEventCount"] = total_event_count

    @property
    def total_size(self) -> "int":
        """ Gets the total_size of this IndexDataset.
        The raw size, in bytes, of the uncompressed data in the indexers.
        """
        return self._attrs.get("totalSize")

    @total_size.setter
    def total_size(self, total_size: "int"):
        """Sets the total_size of this IndexDataset.

        The raw size, in bytes, of the uncompressed data in the indexers.

        :param total_size: The total_size of this IndexDataset.
        :type: int
        """
        self._attrs["totalSize"] = total_size

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["index"] = IndexDataset._from_dict



class IndexDatasetKind(str, Enum):
    INDEX = "index"

    @staticmethod
    def from_value(value: str):
        if value == "index":
            return IndexDatasetKind.INDEX


class IndexDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "IndexDatasetPATCH":
        instance = IndexDatasetPATCH.__new__(IndexDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, disabled: "bool" = None, frozen_time_period_in_secs: "int" = None, kind: "IndexDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """IndexDatasetPATCH"""

        self._attrs = dict()
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this IndexDatasetPATCH.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this IndexDatasetPATCH.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this IndexDatasetPATCH.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this IndexDatasetPATCH.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this IndexDatasetPATCH.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this IndexDatasetPATCH.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def kind(self) -> "IndexDatasetKind":
        """ Gets the kind of this IndexDatasetPATCH.
        """
        return IndexDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "IndexDatasetKind"):
        """Sets the kind of this IndexDatasetPATCH.


        :param kind: The kind of this IndexDatasetPATCH.
        :type: IndexDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this IndexDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this IndexDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this IndexDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this IndexDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this IndexDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this IndexDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this IndexDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this IndexDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this IndexDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class KVCollectionDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "KVCollectionDataset":
        instance = KVCollectionDataset.__new__(KVCollectionDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "str", createdby: "str", id: "str", modified: "str", modifiedby: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, namespace: "str" = None, summary: "str" = None, title: "str" = None, **extra):
        """KVCollectionDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        self._attrs["kind"] = "kvcollection" 
        if namespace is not None:
            self._attrs["namespace"] = namespace
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this KVCollectionDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this KVCollectionDataset.

        The date and time object was created.

        :param created: The created of this KVCollectionDataset.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this KVCollectionDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this KVCollectionDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this KVCollectionDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this KVCollectionDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this KVCollectionDataset.

        A unique dataset ID.

        :param id: The id of this KVCollectionDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "str":
        """ Gets the modified of this KVCollectionDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "str"):
        """Sets the modified of this KVCollectionDataset.

        The date and time object was modified.

        :param modified: The modified of this KVCollectionDataset.
        :type: str
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this KVCollectionDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this KVCollectionDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this KVCollectionDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def name(self) -> "str":
        """ Gets the name of this KVCollectionDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this KVCollectionDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this KVCollectionDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this KVCollectionDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this KVCollectionDataset.

        The name of the object's owner.

        :param owner: The owner of this KVCollectionDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this KVCollectionDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this KVCollectionDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this KVCollectionDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this KVCollectionDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this KVCollectionDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this KVCollectionDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this KVCollectionDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this KVCollectionDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this KVCollectionDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this KVCollectionDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this KVCollectionDataset.

        Detailed description of the dataset.

        :param description: The description of this KVCollectionDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def kind(self) -> str:
        return "kvcollection"


    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this KVCollectionDataset.
        The name of the namespace that contains the dataset.
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this KVCollectionDataset.

        The name of the namespace that contains the dataset.

        :param namespace: The namespace of this KVCollectionDataset.
        :type: str
        """
        self._attrs["namespace"] = namespace

    @property
    def summary(self) -> "str":
        """ Gets the summary of this KVCollectionDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this KVCollectionDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this KVCollectionDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this KVCollectionDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this KVCollectionDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this KVCollectionDataset.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["kvcollection"] = KVCollectionDataset._from_dict



class KVCollectionDatasetKind(str, Enum):
    KVCOLLECTION = "kvcollection"

    @staticmethod
    def from_value(value: str):
        if value == "kvcollection":
            return KVCollectionDatasetKind.KVCOLLECTION


class KVCollectionDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "KVCollectionDatasetPATCH":
        instance = KVCollectionDatasetPATCH.__new__(KVCollectionDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, kind: "KVCollectionDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """KVCollectionDatasetPATCH"""

        self._attrs = dict()
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def kind(self) -> "KVCollectionDatasetKind":
        """ Gets the kind of this KVCollectionDatasetPATCH.
        """
        return KVCollectionDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "KVCollectionDatasetKind"):
        """Sets the kind of this KVCollectionDatasetPATCH.


        :param kind: The kind of this KVCollectionDatasetPATCH.
        :type: KVCollectionDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this KVCollectionDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this KVCollectionDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this KVCollectionDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this KVCollectionDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this KVCollectionDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this KVCollectionDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this KVCollectionDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this KVCollectionDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this KVCollectionDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Module(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Module":
        instance = Module.__new__(Module)
        instance._attrs = model
        return instance

    def __init__(self, created: "str" = None, createdby: "str" = None, definition: "str" = None, name: "str" = None, namespace: "str" = None, **extra):
        """Module"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if definition is not None:
            self._attrs["definition"] = definition
        if name is not None:
            self._attrs["name"] = name
        if namespace is not None:
            self._attrs["namespace"] = namespace
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this Module.
        The timestamp when the module was created
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this Module.

        The timestamp when the module was created

        :param created: The created of this Module.
        :type: str
        """
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this Module.
        The user who created the module
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this Module.

        The user who created the module

        :param createdby: The createdby of this Module.
        :type: str
        """
        self._attrs["createdby"] = createdby

    @property
    def definition(self) -> "str":
        """ Gets the definition of this Module.
        The definition of the module
        """
        return self._attrs.get("definition")

    @definition.setter
    def definition(self, definition: "str"):
        """Sets the definition of this Module.

        The definition of the module

        :param definition: The definition of this Module.
        :type: str
        """
        self._attrs["definition"] = definition

    @property
    def name(self) -> "str":
        """ Gets the name of this Module.
        The name of the module
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Module.

        The name of the module

        :param name: The name of this Module.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this Module.
        The namespace of the module
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this Module.

        The namespace of the module

        :param namespace: The namespace of this Module.
        :type: str
        """
        self._attrs["namespace"] = namespace

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ListModules(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ListModules":
        instance = ListModules.__new__(ListModules)
        instance._attrs = model
        return instance

    def __init__(self, results: "List[Module]" = None, **extra):
        """ListModules"""

        self._attrs = dict()
        if results is not None:
            self._attrs["results"] = results
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def results(self) -> "List[Module]":
        """ Gets the results of this ListModules.
        list of all modules
        """
        return [Module._from_dict(i) for i in self._attrs.get("results")]

    @results.setter
    def results(self, results: "List[Module]"):
        """Sets the results of this ListModules.

        list of all modules

        :param results: The results of this ListModules.
        :type: List[Module]
        """
        self._attrs["results"] = results

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ListPreviewResultsResponseFields(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ListPreviewResultsResponseFields":
        instance = ListPreviewResultsResponseFields.__new__(ListPreviewResultsResponseFields)
        instance._attrs = model
        return instance

    def __init__(self, name: "str", data_source: "str" = None, groupby_rank: "str" = None, split_field: "str" = None, split_value: "str" = None, splitby_special: "str" = None, type_special: "str" = None, **extra):
        """ListPreviewResultsResponseFields"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if data_source is not None:
            self._attrs["dataSource"] = data_source
        if groupby_rank is not None:
            self._attrs["groupbyRank"] = groupby_rank
        if split_field is not None:
            self._attrs["splitField"] = split_field
        if split_value is not None:
            self._attrs["splitValue"] = split_value
        if splitby_special is not None:
            self._attrs["splitbySpecial"] = splitby_special
        if type_special is not None:
            self._attrs["typeSpecial"] = type_special
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ListPreviewResultsResponseFields.


        :param name: The name of this ListPreviewResultsResponseFields.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def data_source(self) -> "str":
        """ Gets the data_source of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("dataSource")

    @data_source.setter
    def data_source(self, data_source: "str"):
        """Sets the data_source of this ListPreviewResultsResponseFields.


        :param data_source: The data_source of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["dataSource"] = data_source

    @property
    def groupby_rank(self) -> "str":
        """ Gets the groupby_rank of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("groupbyRank")

    @groupby_rank.setter
    def groupby_rank(self, groupby_rank: "str"):
        """Sets the groupby_rank of this ListPreviewResultsResponseFields.


        :param groupby_rank: The groupby_rank of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["groupbyRank"] = groupby_rank

    @property
    def split_field(self) -> "str":
        """ Gets the split_field of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("splitField")

    @split_field.setter
    def split_field(self, split_field: "str"):
        """Sets the split_field of this ListPreviewResultsResponseFields.


        :param split_field: The split_field of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["splitField"] = split_field

    @property
    def split_value(self) -> "str":
        """ Gets the split_value of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("splitValue")

    @split_value.setter
    def split_value(self, split_value: "str"):
        """Sets the split_value of this ListPreviewResultsResponseFields.


        :param split_value: The split_value of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["splitValue"] = split_value

    @property
    def splitby_special(self) -> "str":
        """ Gets the splitby_special of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("splitbySpecial")

    @splitby_special.setter
    def splitby_special(self, splitby_special: "str"):
        """Sets the splitby_special of this ListPreviewResultsResponseFields.


        :param splitby_special: The splitby_special of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["splitbySpecial"] = splitby_special

    @property
    def type_special(self) -> "str":
        """ Gets the type_special of this ListPreviewResultsResponseFields.
        """
        return self._attrs.get("typeSpecial")

    @type_special.setter
    def type_special(self, type_special: "str"):
        """Sets the type_special of this ListPreviewResultsResponseFields.


        :param type_special: The type_special of this ListPreviewResultsResponseFields.
        :type: str
        """
        self._attrs["typeSpecial"] = type_special

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ListPreviewResultsResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ListPreviewResultsResponse":
        instance = ListPreviewResultsResponse.__new__(ListPreviewResultsResponse)
        instance._attrs = model
        return instance

    def __init__(self, is_preview_stable: "bool", results: "List[object]", fields: "List[ListPreviewResultsResponseFields]" = None, messages: "List[Message]" = None, next_link: "str" = None, wait: "str" = None, **extra):
        """ListPreviewResultsResponse"""

        self._attrs = dict()
        if is_preview_stable is not None:
            self._attrs["isPreviewStable"] = is_preview_stable
        if results is not None:
            self._attrs["results"] = results
        if fields is not None:
            self._attrs["fields"] = fields
        if messages is not None:
            self._attrs["messages"] = messages
        if next_link is not None:
            self._attrs["nextLink"] = next_link
        if wait is not None:
            self._attrs["wait"] = wait
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def is_preview_stable(self) -> "bool":
        """ Gets the is_preview_stable of this ListPreviewResultsResponse.
        """
        return self._attrs.get("isPreviewStable")

    @is_preview_stable.setter
    def is_preview_stable(self, is_preview_stable: "bool"):
        """Sets the is_preview_stable of this ListPreviewResultsResponse.


        :param is_preview_stable: The is_preview_stable of this ListPreviewResultsResponse.
        :type: bool
        """
        if is_preview_stable is None:
            raise ValueError("Invalid value for `is_preview_stable`, must not be `None`")
        self._attrs["isPreviewStable"] = is_preview_stable

    @property
    def results(self) -> "List[object]":
        """ Gets the results of this ListPreviewResultsResponse.
        """
        return self._attrs.get("results")

    @results.setter
    def results(self, results: "List[object]"):
        """Sets the results of this ListPreviewResultsResponse.


        :param results: The results of this ListPreviewResultsResponse.
        :type: List[object]
        """
        if results is None:
            raise ValueError("Invalid value for `results`, must not be `None`")
        self._attrs["results"] = results

    @property
    def fields(self) -> "List[ListPreviewResultsResponseFields]":
        """ Gets the fields of this ListPreviewResultsResponse.
        """
        return [ListPreviewResultsResponseFields._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[ListPreviewResultsResponseFields]"):
        """Sets the fields of this ListPreviewResultsResponse.


        :param fields: The fields of this ListPreviewResultsResponse.
        :type: List[ListPreviewResultsResponseFields]
        """
        self._attrs["fields"] = fields

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this ListPreviewResultsResponse.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this ListPreviewResultsResponse.


        :param messages: The messages of this ListPreviewResultsResponse.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def next_link(self) -> "str":
        """ Gets the next_link of this ListPreviewResultsResponse.
        """
        return self._attrs.get("nextLink")

    @next_link.setter
    def next_link(self, next_link: "str"):
        """Sets the next_link of this ListPreviewResultsResponse.


        :param next_link: The next_link of this ListPreviewResultsResponse.
        :type: str
        """
        self._attrs["nextLink"] = next_link

    @property
    def wait(self) -> "str":
        """ Gets the wait of this ListPreviewResultsResponse.
        """
        return self._attrs.get("wait")

    @wait.setter
    def wait(self, wait: "str"):
        """Sets the wait of this ListPreviewResultsResponse.


        :param wait: The wait of this ListPreviewResultsResponse.
        :type: str
        """
        self._attrs["wait"] = wait

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ListSearchResultsResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ListSearchResultsResponse":
        instance = ListSearchResultsResponse.__new__(ListSearchResultsResponse)
        instance._attrs = model
        return instance

    def __init__(self, results: "List[object]", fields: "List[ListPreviewResultsResponseFields]" = None, messages: "List[Message]" = None, next_link: "str" = None, wait: "str" = None, **extra):
        """ListSearchResultsResponse"""

        self._attrs = dict()
        if results is not None:
            self._attrs["results"] = results
        if fields is not None:
            self._attrs["fields"] = fields
        if messages is not None:
            self._attrs["messages"] = messages
        if next_link is not None:
            self._attrs["nextLink"] = next_link
        if wait is not None:
            self._attrs["wait"] = wait
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def results(self) -> "List[object]":
        """ Gets the results of this ListSearchResultsResponse.
        """
        return self._attrs.get("results")

    @results.setter
    def results(self, results: "List[object]"):
        """Sets the results of this ListSearchResultsResponse.


        :param results: The results of this ListSearchResultsResponse.
        :type: List[object]
        """
        if results is None:
            raise ValueError("Invalid value for `results`, must not be `None`")
        self._attrs["results"] = results

    @property
    def fields(self) -> "List[ListPreviewResultsResponseFields]":
        """ Gets the fields of this ListSearchResultsResponse.
        """
        return [ListPreviewResultsResponseFields._from_dict(i) for i in self._attrs.get("fields")]

    @fields.setter
    def fields(self, fields: "List[ListPreviewResultsResponseFields]"):
        """Sets the fields of this ListSearchResultsResponse.


        :param fields: The fields of this ListSearchResultsResponse.
        :type: List[ListPreviewResultsResponseFields]
        """
        self._attrs["fields"] = fields

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this ListSearchResultsResponse.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this ListSearchResultsResponse.


        :param messages: The messages of this ListSearchResultsResponse.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def next_link(self) -> "str":
        """ Gets the next_link of this ListSearchResultsResponse.
        """
        return self._attrs.get("nextLink")

    @next_link.setter
    def next_link(self, next_link: "str"):
        """Sets the next_link of this ListSearchResultsResponse.


        :param next_link: The next_link of this ListSearchResultsResponse.
        :type: str
        """
        self._attrs["nextLink"] = next_link

    @property
    def wait(self) -> "str":
        """ Gets the wait of this ListSearchResultsResponse.
        """
        return self._attrs.get("wait")

    @wait.setter
    def wait(self, wait: "str"):
        """Sets the wait of this ListSearchResultsResponse.


        :param wait: The wait of this ListSearchResultsResponse.
        :type: str
        """
        self._attrs["wait"] = wait

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class LookupDatasetExternalKind(str, Enum):
    KVCOLLECTION = "kvcollection"

    @staticmethod
    def from_value(value: str):
        if value == "kvcollection":
            return LookupDatasetExternalKind.KVCOLLECTION


class LookupDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "LookupDataset":
        instance = LookupDataset.__new__(LookupDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "str", createdby: "str", id: "str", modified: "str", modifiedby: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, case_sensitive_match: "bool" = True, description: "str" = None, external_kind: "LookupDatasetExternalKind" = None, external_name: "str" = None, filter: "str" = None, namespace: "str" = None, summary: "str" = None, title: "str" = None, **extra):
        """LookupDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if case_sensitive_match is not None:
            self._attrs["caseSensitiveMatch"] = case_sensitive_match
        if description is not None:
            self._attrs["description"] = description
        if external_kind is not None:
            self._attrs["externalKind"] = external_kind
        if external_name is not None:
            self._attrs["externalName"] = external_name
        if filter is not None:
            self._attrs["filter"] = filter
        self._attrs["kind"] = "lookup" 
        if namespace is not None:
            self._attrs["namespace"] = namespace
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this LookupDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this LookupDataset.

        The date and time object was created.

        :param created: The created of this LookupDataset.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this LookupDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this LookupDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this LookupDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this LookupDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this LookupDataset.

        A unique dataset ID.

        :param id: The id of this LookupDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "str":
        """ Gets the modified of this LookupDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "str"):
        """Sets the modified of this LookupDataset.

        The date and time object was modified.

        :param modified: The modified of this LookupDataset.
        :type: str
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this LookupDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this LookupDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this LookupDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def name(self) -> "str":
        """ Gets the name of this LookupDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this LookupDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this LookupDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupDataset.

        The name of the object's owner.

        :param owner: The owner of this LookupDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this LookupDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this LookupDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this LookupDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this LookupDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this LookupDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this LookupDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this LookupDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this LookupDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this LookupDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def case_sensitive_match(self) -> "bool":
        """ Gets the case_sensitive_match of this LookupDataset.
        Match case-sensitively against the lookup.
        """
        return self._attrs.get("caseSensitiveMatch")

    @case_sensitive_match.setter
    def case_sensitive_match(self, case_sensitive_match: "bool"):
        """Sets the case_sensitive_match of this LookupDataset.

        Match case-sensitively against the lookup.

        :param case_sensitive_match: The case_sensitive_match of this LookupDataset.
        :type: bool
        """
        self._attrs["caseSensitiveMatch"] = case_sensitive_match

    @property
    def description(self) -> "str":
        """ Gets the description of this LookupDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this LookupDataset.

        Detailed description of the dataset.

        :param description: The description of this LookupDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def external_kind(self) -> "LookupDatasetExternalKind":
        """ Gets the external_kind of this LookupDataset.
        """
        return LookupDatasetExternalKind.from_value(self._attrs.get("externalKind"))

    @external_kind.setter
    def external_kind(self, external_kind: "LookupDatasetExternalKind"):
        """Sets the external_kind of this LookupDataset.


        :param external_kind: The external_kind of this LookupDataset.
        :type: LookupDatasetExternalKind
        """
        if isinstance(external_kind, Enum):
            self._attrs["externalKind"] = external_kind.value
        else:
            self._attrs["externalKind"] = external_kind  # If you supply a string, we presume you know the service will take it.

    @property
    def external_name(self) -> "str":
        """ Gets the external_name of this LookupDataset.
        The name of the external lookup.
        """
        return self._attrs.get("externalName")

    @external_name.setter
    def external_name(self, external_name: "str"):
        """Sets the external_name of this LookupDataset.

        The name of the external lookup.

        :param external_name: The external_name of this LookupDataset.
        :type: str
        """
        self._attrs["externalName"] = external_name

    @property
    def filter(self) -> "str":
        """ Gets the filter of this LookupDataset.
        A query that filters results out of the lookup before those results are returned.
        """
        return self._attrs.get("filter")

    @filter.setter
    def filter(self, filter: "str"):
        """Sets the filter of this LookupDataset.

        A query that filters results out of the lookup before those results are returned.

        :param filter: The filter of this LookupDataset.
        :type: str
        """
        self._attrs["filter"] = filter

    @property
    def kind(self) -> str:
        return "lookup"


    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this LookupDataset.
        The name of the namespace that contains the dataset.
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this LookupDataset.

        The name of the namespace that contains the dataset.

        :param namespace: The namespace of this LookupDataset.
        :type: str
        """
        self._attrs["namespace"] = namespace

    @property
    def summary(self) -> "str":
        """ Gets the summary of this LookupDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this LookupDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this LookupDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this LookupDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this LookupDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this LookupDataset.
        :type: str
        """
        self._attrs["title"] = title

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["lookup"] = LookupDataset._from_dict



class LookupDatasetKind(str, Enum):
    LOOKUP = "lookup"

    @staticmethod
    def from_value(value: str):
        if value == "lookup":
            return LookupDatasetKind.LOOKUP


class LookupDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "LookupDatasetPATCH":
        instance = LookupDatasetPATCH.__new__(LookupDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, case_sensitive_match: "bool" = True, external_kind: "LookupDatasetExternalKind" = None, external_name: "str" = None, filter: "str" = None, kind: "LookupDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """LookupDatasetPATCH"""

        self._attrs = dict()
        if case_sensitive_match is not None:
            self._attrs["caseSensitiveMatch"] = case_sensitive_match
        if external_kind is not None:
            self._attrs["externalKind"] = external_kind
        if external_name is not None:
            self._attrs["externalName"] = external_name
        if filter is not None:
            self._attrs["filter"] = filter
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def case_sensitive_match(self) -> "bool":
        """ Gets the case_sensitive_match of this LookupDatasetPATCH.
        Match case-sensitively against the lookup.
        """
        return self._attrs.get("caseSensitiveMatch")

    @case_sensitive_match.setter
    def case_sensitive_match(self, case_sensitive_match: "bool"):
        """Sets the case_sensitive_match of this LookupDatasetPATCH.

        Match case-sensitively against the lookup.

        :param case_sensitive_match: The case_sensitive_match of this LookupDatasetPATCH.
        :type: bool
        """
        self._attrs["caseSensitiveMatch"] = case_sensitive_match

    @property
    def external_kind(self) -> "LookupDatasetExternalKind":
        """ Gets the external_kind of this LookupDatasetPATCH.
        """
        return LookupDatasetExternalKind.from_value(self._attrs.get("externalKind"))

    @external_kind.setter
    def external_kind(self, external_kind: "LookupDatasetExternalKind"):
        """Sets the external_kind of this LookupDatasetPATCH.


        :param external_kind: The external_kind of this LookupDatasetPATCH.
        :type: LookupDatasetExternalKind
        """
        if isinstance(external_kind, Enum):
            self._attrs["externalKind"] = external_kind.value
        else:
            self._attrs["externalKind"] = external_kind  # If you supply a string, we presume you know the service will take it.

    @property
    def external_name(self) -> "str":
        """ Gets the external_name of this LookupDatasetPATCH.
        The name of the external lookup.
        """
        return self._attrs.get("externalName")

    @external_name.setter
    def external_name(self, external_name: "str"):
        """Sets the external_name of this LookupDatasetPATCH.

        The name of the external lookup.

        :param external_name: The external_name of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["externalName"] = external_name

    @property
    def filter(self) -> "str":
        """ Gets the filter of this LookupDatasetPATCH.
        A query that filters results out of the lookup before those results are returned.
        """
        return self._attrs.get("filter")

    @filter.setter
    def filter(self, filter: "str"):
        """Sets the filter of this LookupDatasetPATCH.

        A query that filters results out of the lookup before those results are returned.

        :param filter: The filter of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["filter"] = filter

    @property
    def kind(self) -> "LookupDatasetKind":
        """ Gets the kind of this LookupDatasetPATCH.
        """
        return LookupDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "LookupDatasetKind"):
        """Sets the kind of this LookupDatasetPATCH.


        :param kind: The kind of this LookupDatasetPATCH.
        :type: LookupDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this LookupDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this LookupDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this LookupDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this LookupDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this LookupDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this LookupDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this LookupDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MetricDataset(Dataset):

    @staticmethod
    def _from_dict(model: dict) -> "MetricDataset":
        instance = MetricDataset.__new__(MetricDataset)
        instance._attrs = model
        return instance

    def __init__(self, created: "str", createdby: "str", id: "str", modified: "str", modifiedby: "str", name: "str", owner: "str", resourcename: "str", appclientidcreatedby: "str" = None, appclientidmodifiedby: "str" = None, description: "str" = None, disabled: "bool" = None, earliest_event_time: "str" = None, earliest_ingest_time: "str" = None, frozen_time_period_in_secs: "int" = None, latest_event_time: "str" = None, latest_ingest_time: "str" = None, latest_metadata_update_time: "str" = None, namespace: "str" = None, summary: "str" = None, title: "str" = None, total_event_count: "int" = None, total_size: "int" = None, **extra):
        """MetricDataset"""

        self._attrs = dict()
        if created is not None:
            self._attrs["created"] = created
        if createdby is not None:
            self._attrs["createdby"] = createdby
        if id is not None:
            self._attrs["id"] = id
        if modified is not None:
            self._attrs["modified"] = modified
        if modifiedby is not None:
            self._attrs["modifiedby"] = modifiedby
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        if resourcename is not None:
            self._attrs["resourcename"] = resourcename
        if appclientidcreatedby is not None:
            self._attrs["appclientidcreatedby"] = appclientidcreatedby
        if appclientidmodifiedby is not None:
            self._attrs["appclientidmodifiedby"] = appclientidmodifiedby
        if description is not None:
            self._attrs["description"] = description
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if earliest_event_time is not None:
            self._attrs["earliestEventTime"] = earliest_event_time
        if earliest_ingest_time is not None:
            self._attrs["earliestIngestTime"] = earliest_ingest_time
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        self._attrs["kind"] = "metric" 
        if latest_event_time is not None:
            self._attrs["latestEventTime"] = latest_event_time
        if latest_ingest_time is not None:
            self._attrs["latestIngestTime"] = latest_ingest_time
        if latest_metadata_update_time is not None:
            self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time
        if namespace is not None:
            self._attrs["namespace"] = namespace
        if summary is not None:
            self._attrs["summary"] = summary
        if title is not None:
            self._attrs["title"] = title
        if total_event_count is not None:
            self._attrs["totalEventCount"] = total_event_count
        if total_size is not None:
            self._attrs["totalSize"] = total_size
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created(self) -> "str":
        """ Gets the created of this MetricDataset.
        The date and time object was created.
        """
        return self._attrs.get("created")

    @created.setter
    def created(self, created: "str"):
        """Sets the created of this MetricDataset.

        The date and time object was created.

        :param created: The created of this MetricDataset.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")
        self._attrs["created"] = created

    @property
    def createdby(self) -> "str":
        """ Gets the createdby of this MetricDataset.
        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.
        """
        return self._attrs.get("createdby")

    @createdby.setter
    def createdby(self, createdby: "str"):
        """Sets the createdby of this MetricDataset.

        The name of the user who created the object. This value is obtained from the bearer token and may not be changed.

        :param createdby: The createdby of this MetricDataset.
        :type: str
        """
        if createdby is None:
            raise ValueError("Invalid value for `createdby`, must not be `None`")
        self._attrs["createdby"] = createdby

    @property
    def id(self) -> "str":
        """ Gets the id of this MetricDataset.
        A unique dataset ID.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this MetricDataset.

        A unique dataset ID.

        :param id: The id of this MetricDataset.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def modified(self) -> "str":
        """ Gets the modified of this MetricDataset.
        The date and time object was modified.
        """
        return self._attrs.get("modified")

    @modified.setter
    def modified(self, modified: "str"):
        """Sets the modified of this MetricDataset.

        The date and time object was modified.

        :param modified: The modified of this MetricDataset.
        :type: str
        """
        if modified is None:
            raise ValueError("Invalid value for `modified`, must not be `None`")
        self._attrs["modified"] = modified

    @property
    def modifiedby(self) -> "str":
        """ Gets the modifiedby of this MetricDataset.
        The name of the user who most recently modified the object.
        """
        return self._attrs.get("modifiedby")

    @modifiedby.setter
    def modifiedby(self, modifiedby: "str"):
        """Sets the modifiedby of this MetricDataset.

        The name of the user who most recently modified the object.

        :param modifiedby: The modifiedby of this MetricDataset.
        :type: str
        """
        if modifiedby is None:
            raise ValueError("Invalid value for `modifiedby`, must not be `None`")
        self._attrs["modifiedby"] = modifiedby

    @property
    def name(self) -> "str":
        """ Gets the name of this MetricDataset.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this MetricDataset.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this MetricDataset.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this MetricDataset.
        The name of the object's owner.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this MetricDataset.

        The name of the object's owner.

        :param owner: The owner of this MetricDataset.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")
        self._attrs["owner"] = owner

    @property
    def resourcename(self) -> "str":
        """ Gets the resourcename of this MetricDataset.
        The dataset name qualified by the module name.
        """
        return self._attrs.get("resourcename")

    @resourcename.setter
    def resourcename(self, resourcename: "str"):
        """Sets the resourcename of this MetricDataset.

        The dataset name qualified by the module name.

        :param resourcename: The resourcename of this MetricDataset.
        :type: str
        """
        if resourcename is None:
            raise ValueError("Invalid value for `resourcename`, must not be `None`")
        self._attrs["resourcename"] = resourcename

    @property
    def appclientidcreatedby(self) -> "str":
        """ Gets the appclientidcreatedby of this MetricDataset.
        AppClinetId of the creator app of the dataset.
        """
        return self._attrs.get("appclientidcreatedby")

    @appclientidcreatedby.setter
    def appclientidcreatedby(self, appclientidcreatedby: "str"):
        """Sets the appclientidcreatedby of this MetricDataset.

        AppClinetId of the creator app of the dataset.

        :param appclientidcreatedby: The appclientidcreatedby of this MetricDataset.
        :type: str
        """
        self._attrs["appclientidcreatedby"] = appclientidcreatedby

    @property
    def appclientidmodifiedby(self) -> "str":
        """ Gets the appclientidmodifiedby of this MetricDataset.
        AppClinetId of the modifier app of the dataset.
        """
        return self._attrs.get("appclientidmodifiedby")

    @appclientidmodifiedby.setter
    def appclientidmodifiedby(self, appclientidmodifiedby: "str"):
        """Sets the appclientidmodifiedby of this MetricDataset.

        AppClinetId of the modifier app of the dataset.

        :param appclientidmodifiedby: The appclientidmodifiedby of this MetricDataset.
        :type: str
        """
        self._attrs["appclientidmodifiedby"] = appclientidmodifiedby

    @property
    def description(self) -> "str":
        """ Gets the description of this MetricDataset.
        Detailed description of the dataset.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this MetricDataset.

        Detailed description of the dataset.

        :param description: The description of this MetricDataset.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this MetricDataset.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this MetricDataset.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this MetricDataset.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def earliest_event_time(self) -> "str":
        """ Gets the earliest_event_time of this MetricDataset.
        The timestamp, in seconds, of the earliest measure. The timestamp is in UNIX time.
        """
        return self._attrs.get("earliestEventTime")

    @earliest_event_time.setter
    def earliest_event_time(self, earliest_event_time: "str"):
        """Sets the earliest_event_time of this MetricDataset.

        The timestamp, in seconds, of the earliest measure. The timestamp is in UNIX time.

        :param earliest_event_time: The earliest_event_time of this MetricDataset.
        :type: str
        """
        self._attrs["earliestEventTime"] = earliest_event_time

    @property
    def earliest_ingest_time(self) -> "str":
        """ Gets the earliest_ingest_time of this MetricDataset.
        The earliest index time for any of the measures in this index.
        """
        return self._attrs.get("earliestIngestTime")

    @earliest_ingest_time.setter
    def earliest_ingest_time(self, earliest_ingest_time: "str"):
        """Sets the earliest_ingest_time of this MetricDataset.

        The earliest index time for any of the measures in this index.

        :param earliest_ingest_time: The earliest_ingest_time of this MetricDataset.
        :type: str
        """
        self._attrs["earliestIngestTime"] = earliest_ingest_time

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this MetricDataset.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this MetricDataset.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this MetricDataset.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def kind(self) -> str:
        return "metric"


    @property
    def latest_event_time(self) -> "str":
        """ Gets the latest_event_time of this MetricDataset.
        The timestamp, in seconds, of the latest measure. The timestamp is in UNIX time.
        """
        return self._attrs.get("latestEventTime")

    @latest_event_time.setter
    def latest_event_time(self, latest_event_time: "str"):
        """Sets the latest_event_time of this MetricDataset.

        The timestamp, in seconds, of the latest measure. The timestamp is in UNIX time.

        :param latest_event_time: The latest_event_time of this MetricDataset.
        :type: str
        """
        self._attrs["latestEventTime"] = latest_event_time

    @property
    def latest_ingest_time(self) -> "str":
        """ Gets the latest_ingest_time of this MetricDataset.
        The earliest index time for any of the measures in this index.
        """
        return self._attrs.get("latestIngestTime")

    @latest_ingest_time.setter
    def latest_ingest_time(self, latest_ingest_time: "str"):
        """Sets the latest_ingest_time of this MetricDataset.

        The earliest index time for any of the measures in this index.

        :param latest_ingest_time: The latest_ingest_time of this MetricDataset.
        :type: str
        """
        self._attrs["latestIngestTime"] = latest_ingest_time

    @property
    def latest_metadata_update_time(self) -> "str":
        """ Gets the latest_metadata_update_time of this MetricDataset.
        The latest time that the metric index metadata was refreshed.
        """
        return self._attrs.get("latestMetadataUpdateTime")

    @latest_metadata_update_time.setter
    def latest_metadata_update_time(self, latest_metadata_update_time: "str"):
        """Sets the latest_metadata_update_time of this MetricDataset.

        The latest time that the metric index metadata was refreshed.

        :param latest_metadata_update_time: The latest_metadata_update_time of this MetricDataset.
        :type: str
        """
        self._attrs["latestMetadataUpdateTime"] = latest_metadata_update_time

    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this MetricDataset.
        The name of the namespace that contains the dataset.
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this MetricDataset.

        The name of the namespace that contains the dataset.

        :param namespace: The namespace of this MetricDataset.
        :type: str
        """
        self._attrs["namespace"] = namespace

    @property
    def summary(self) -> "str":
        """ Gets the summary of this MetricDataset.
        Summary of the dataset's purpose.
        """
        return self._attrs.get("summary")

    @summary.setter
    def summary(self, summary: "str"):
        """Sets the summary of this MetricDataset.

        Summary of the dataset's purpose.

        :param summary: The summary of this MetricDataset.
        :type: str
        """
        self._attrs["summary"] = summary

    @property
    def title(self) -> "str":
        """ Gets the title of this MetricDataset.
        The title of the dataset.  Does not have to be unique.
        """
        return self._attrs.get("title")

    @title.setter
    def title(self, title: "str"):
        """Sets the title of this MetricDataset.

        The title of the dataset.  Does not have to be unique.

        :param title: The title of this MetricDataset.
        :type: str
        """
        self._attrs["title"] = title

    @property
    def total_event_count(self) -> "int":
        """ Gets the total_event_count of this MetricDataset.
        THe number of measures in the metric index.
        """
        return self._attrs.get("totalEventCount")

    @total_event_count.setter
    def total_event_count(self, total_event_count: "int"):
        """Sets the total_event_count of this MetricDataset.

        THe number of measures in the metric index.

        :param total_event_count: The total_event_count of this MetricDataset.
        :type: int
        """
        self._attrs["totalEventCount"] = total_event_count

    @property
    def total_size(self) -> "int":
        """ Gets the total_size of this MetricDataset.
        For metrics indexes, the totalSize is set to 0.
        """
        return self._attrs.get("totalSize")

    @total_size.setter
    def total_size(self, total_size: "int"):
        """Sets the total_size of this MetricDataset.

        For metrics indexes, the totalSize is set to 0.

        :param total_size: The total_size of this MetricDataset.
        :type: int
        """
        self._attrs["totalSize"] = total_size

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


Dataset.from_dict_handlers["metric"] = MetricDataset._from_dict



class MetricDatasetKind(str, Enum):
    METRIC = "metric"

    @staticmethod
    def from_value(value: str):
        if value == "metric":
            return MetricDatasetKind.METRIC


class MetricDatasetPATCH(DatasetPATCH):

    @staticmethod
    def _from_dict(model: dict) -> "MetricDatasetPATCH":
        instance = MetricDatasetPATCH.__new__(MetricDatasetPATCH)
        instance._attrs = model
        return instance

    def __init__(self, disabled: "bool" = None, frozen_time_period_in_secs: "int" = None, kind: "MetricDatasetKind" = None, module: "str" = None, name: "str" = None, owner: "str" = None, **extra):
        """MetricDatasetPATCH"""

        self._attrs = dict()
        if disabled is not None:
            self._attrs["disabled"] = disabled
        if frozen_time_period_in_secs is not None:
            self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs
        if kind is not None:
            self._attrs["kind"] = kind
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if owner is not None:
            self._attrs["owner"] = owner
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def disabled(self) -> "bool":
        """ Gets the disabled of this MetricDatasetPATCH.
        Specifies whether or not the Splunk index is disabled.
        """
        return self._attrs.get("disabled")

    @disabled.setter
    def disabled(self, disabled: "bool"):
        """Sets the disabled of this MetricDatasetPATCH.

        Specifies whether or not the Splunk index is disabled.

        :param disabled: The disabled of this MetricDatasetPATCH.
        :type: bool
        """
        self._attrs["disabled"] = disabled

    @property
    def frozen_time_period_in_secs(self) -> "int":
        """ Gets the frozen_time_period_in_secs of this MetricDatasetPATCH.
        The frozenTimePeriodInSecs to use for the index
        """
        return self._attrs.get("frozenTimePeriodInSecs")

    @frozen_time_period_in_secs.setter
    def frozen_time_period_in_secs(self, frozen_time_period_in_secs: "int"):
        """Sets the frozen_time_period_in_secs of this MetricDatasetPATCH.

        The frozenTimePeriodInSecs to use for the index

        :param frozen_time_period_in_secs: The frozen_time_period_in_secs of this MetricDatasetPATCH.
        :type: int
        """
        self._attrs["frozenTimePeriodInSecs"] = frozen_time_period_in_secs

    @property
    def kind(self) -> "MetricDatasetKind":
        """ Gets the kind of this MetricDatasetPATCH.
        """
        return MetricDatasetKind.from_value(self._attrs.get("kind"))

    @kind.setter
    def kind(self, kind: "MetricDatasetKind"):
        """Sets the kind of this MetricDatasetPATCH.


        :param kind: The kind of this MetricDatasetPATCH.
        :type: MetricDatasetKind
        """
        if isinstance(kind, Enum):
            self._attrs["kind"] = kind.value
        else:
            self._attrs["kind"] = kind  # If you supply a string, we presume you know the service will take it.

    @property
    def module(self) -> "str":
        """ Gets the module of this MetricDatasetPATCH.
        The name of module to reassign dataset into.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this MetricDatasetPATCH.

        The name of module to reassign dataset into.

        :param module: The module of this MetricDatasetPATCH.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this MetricDatasetPATCH.
        The dataset name. Dataset names must be unique within each module.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this MetricDatasetPATCH.

        The dataset name. Dataset names must be unique within each module.

        :param name: The name of this MetricDatasetPATCH.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner(self) -> "str":
        """ Gets the owner of this MetricDatasetPATCH.
        The name of the dataset owner. This value is obtained from the bearer token.
        """
        return self._attrs.get("owner")

    @owner.setter
    def owner(self, owner: "str"):
        """Sets the owner of this MetricDatasetPATCH.

        The name of the dataset owner. This value is obtained from the bearer token.

        :param owner: The owner of this MetricDatasetPATCH.
        :type: str
        """
        self._attrs["owner"] = owner

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SearchJob(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SearchJob":
        instance = SearchJob.__new__(SearchJob)
        instance._attrs = model
        return instance

    def __init__(self, query: "str", allow_side_effects: "bool" = False, collect_event_summary: "bool" = False, collect_field_summary: "bool" = False, collect_time_buckets: "bool" = False, completion_time: "str" = None, dispatch_time: "str" = None, enable_preview: "bool" = False, extract_all_fields: "bool" = False, extract_fields: "str" = '', max_time: "int" = 3600, messages: "List[Message]" = None, module: "str" = '', name: "str" = None, parent: "str" = None, percent_complete: "int" = 0, preview_available: "str" = 'false', query_parameters: "QueryParameters" = None, required_freshness: "int" = 0, resolved_earliest: "str" = None, resolved_latest: "str" = None, results_available: "int" = 0, results_preview_available: "int" = 0, sid: "str" = None, status: "SearchStatus" = None, **extra):
        """SearchJob"""

        self._attrs = dict()
        if query is not None:
            self._attrs["query"] = query
        if allow_side_effects is not None:
            self._attrs["allowSideEffects"] = allow_side_effects
        if collect_event_summary is not None:
            self._attrs["collectEventSummary"] = collect_event_summary
        if collect_field_summary is not None:
            self._attrs["collectFieldSummary"] = collect_field_summary
        if collect_time_buckets is not None:
            self._attrs["collectTimeBuckets"] = collect_time_buckets
        if completion_time is not None:
            self._attrs["completionTime"] = completion_time
        if dispatch_time is not None:
            self._attrs["dispatchTime"] = dispatch_time
        if enable_preview is not None:
            self._attrs["enablePreview"] = enable_preview
        if extract_all_fields is not None:
            self._attrs["extractAllFields"] = extract_all_fields
        if extract_fields is not None:
            self._attrs["extractFields"] = extract_fields
        if max_time is not None:
            self._attrs["maxTime"] = max_time
        if messages is not None:
            self._attrs["messages"] = messages
        if module is not None:
            self._attrs["module"] = module
        if name is not None:
            self._attrs["name"] = name
        if parent is not None:
            self._attrs["parent"] = parent
        if percent_complete is not None:
            self._attrs["percentComplete"] = percent_complete
        if preview_available is not None:
            self._attrs["previewAvailable"] = preview_available
        if query_parameters is not None:
            self._attrs["queryParameters"] = query_parameters.to_dict()
        if required_freshness is not None:
            self._attrs["requiredFreshness"] = required_freshness
        if resolved_earliest is not None:
            self._attrs["resolvedEarliest"] = resolved_earliest
        if resolved_latest is not None:
            self._attrs["resolvedLatest"] = resolved_latest
        if results_available is not None:
            self._attrs["resultsAvailable"] = results_available
        if results_preview_available is not None:
            self._attrs["resultsPreviewAvailable"] = results_preview_available
        if sid is not None:
            self._attrs["sid"] = sid
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def query(self) -> "str":
        """ Gets the query of this SearchJob.
        The SPL search string.
        """
        return self._attrs.get("query")

    @query.setter
    def query(self, query: "str"):
        """Sets the query of this SearchJob.

        The SPL search string.

        :param query: The query of this SearchJob.
        :type: str
        """
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")
        self._attrs["query"] = query

    @property
    def allow_side_effects(self) -> "bool":
        """ Gets the allow_side_effects of this SearchJob.
        Specifies whether a search that contains commands with side effects  (with possible security risks) is allowed to run. 
        """
        return self._attrs.get("allowSideEffects")

    @allow_side_effects.setter
    def allow_side_effects(self, allow_side_effects: "bool"):
        """Sets the allow_side_effects of this SearchJob.

        Specifies whether a search that contains commands with side effects  (with possible security risks) is allowed to run. 

        :param allow_side_effects: The allow_side_effects of this SearchJob.
        :type: bool
        """
        self._attrs["allowSideEffects"] = allow_side_effects

    @property
    def collect_event_summary(self) -> "bool":
        """ Gets the collect_event_summary of this SearchJob.
        Specifies whether a search is allowed to collect events summary  information during the run time. 
        """
        return self._attrs.get("collectEventSummary")

    @collect_event_summary.setter
    def collect_event_summary(self, collect_event_summary: "bool"):
        """Sets the collect_event_summary of this SearchJob.

        Specifies whether a search is allowed to collect events summary  information during the run time. 

        :param collect_event_summary: The collect_event_summary of this SearchJob.
        :type: bool
        """
        self._attrs["collectEventSummary"] = collect_event_summary

    @property
    def collect_field_summary(self) -> "bool":
        """ Gets the collect_field_summary of this SearchJob.
        Specifies whether a search is allowed to collect fields summary  information during the run time. 
        """
        return self._attrs.get("collectFieldSummary")

    @collect_field_summary.setter
    def collect_field_summary(self, collect_field_summary: "bool"):
        """Sets the collect_field_summary of this SearchJob.

        Specifies whether a search is allowed to collect fields summary  information during the run time. 

        :param collect_field_summary: The collect_field_summary of this SearchJob.
        :type: bool
        """
        self._attrs["collectFieldSummary"] = collect_field_summary

    @property
    def collect_time_buckets(self) -> "bool":
        """ Gets the collect_time_buckets of this SearchJob.
        Specifies whether a search is allowed to collect timeline buckets  summary information during the run time. 
        """
        return self._attrs.get("collectTimeBuckets")

    @collect_time_buckets.setter
    def collect_time_buckets(self, collect_time_buckets: "bool"):
        """Sets the collect_time_buckets of this SearchJob.

        Specifies whether a search is allowed to collect timeline buckets  summary information during the run time. 

        :param collect_time_buckets: The collect_time_buckets of this SearchJob.
        :type: bool
        """
        self._attrs["collectTimeBuckets"] = collect_time_buckets

    @property
    def completion_time(self) -> "str":
        """ Gets the completion_time of this SearchJob.
        The time, in GMT, that the search job is finished.  Empty if the search job has not completed. 
        """
        return self._attrs.get("completionTime")

    @completion_time.setter
    def completion_time(self, completion_time: "str"):
        """Sets the completion_time of this SearchJob.

        The time, in GMT, that the search job is finished.  Empty if the search job has not completed. 

        :param completion_time: The completion_time of this SearchJob.
        :type: str
        """
        self._attrs["completionTime"] = completion_time

    @property
    def dispatch_time(self) -> "str":
        """ Gets the dispatch_time of this SearchJob.
        The time, in GMT, that the search job is dispatched. 
        """
        return self._attrs.get("dispatchTime")

    @dispatch_time.setter
    def dispatch_time(self, dispatch_time: "str"):
        """Sets the dispatch_time of this SearchJob.

        The time, in GMT, that the search job is dispatched. 

        :param dispatch_time: The dispatch_time of this SearchJob.
        :type: str
        """
        self._attrs["dispatchTime"] = dispatch_time

    @property
    def enable_preview(self) -> "bool":
        """ Gets the enable_preview of this SearchJob.
        Specifies whether a search is allowed to collect preview results  during the run time. 
        """
        return self._attrs.get("enablePreview")

    @enable_preview.setter
    def enable_preview(self, enable_preview: "bool"):
        """Sets the enable_preview of this SearchJob.

        Specifies whether a search is allowed to collect preview results  during the run time. 

        :param enable_preview: The enable_preview of this SearchJob.
        :type: bool
        """
        self._attrs["enablePreview"] = enable_preview

    @property
    def extract_all_fields(self) -> "bool":
        """ Gets the extract_all_fields of this SearchJob.
        Specifies whether the Search service should extract all of the available fields in the data, including fields not mentioned in the SPL for the search job. Set to 'false' for better search performance. The 'extractAllFields' parameter is deprecated as of version v3alpha1. Although this parameter continues to function, it might be removed in a future version. Use the 'extractFields' parameter instead. 
        """
        return self._attrs.get("extractAllFields")

    @extract_all_fields.setter
    def extract_all_fields(self, extract_all_fields: "bool"):
        """Sets the extract_all_fields of this SearchJob.

        Specifies whether the Search service should extract all of the available fields in the data, including fields not mentioned in the SPL for the search job. Set to 'false' for better search performance. The 'extractAllFields' parameter is deprecated as of version v3alpha1. Although this parameter continues to function, it might be removed in a future version. Use the 'extractFields' parameter instead. 

        :param extract_all_fields: The extract_all_fields of this SearchJob.
        :type: bool
        """
        self._attrs["extractAllFields"] = extract_all_fields

    @property
    def extract_fields(self) -> "str":
        """ Gets the extract_fields of this SearchJob.
        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' will extract all fields, 'indexed' will extract only indexed fields, and 'none' will extract only the default fields. This parameter overwrites the value of the 'extractAllFields' parameter. Set to 'none' for better search performance. 
        """
        return self._attrs.get("extractFields")

    @extract_fields.setter
    def extract_fields(self, extract_fields: "str"):
        """Sets the extract_fields of this SearchJob.

        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' will extract all fields, 'indexed' will extract only indexed fields, and 'none' will extract only the default fields. This parameter overwrites the value of the 'extractAllFields' parameter. Set to 'none' for better search performance. 

        :param extract_fields: The extract_fields of this SearchJob.
        :type: str
        """
        self._attrs["extractFields"] = extract_fields

    @property
    def max_time(self) -> "int":
        """ Gets the max_time of this SearchJob.
        The number of seconds to run the search before finalizing the search.  The default value is 3600 seconds (1 hour).  The maximum value is 3600 seconds (1 hour). 
        """
        return self._attrs.get("maxTime")

    @max_time.setter
    def max_time(self, max_time: "int"):
        """Sets the max_time of this SearchJob.

        The number of seconds to run the search before finalizing the search.  The default value is 3600 seconds (1 hour).  The maximum value is 3600 seconds (1 hour). 

        :param max_time: The max_time of this SearchJob.
        :type: int
        """
        self._attrs["maxTime"] = max_time

    @property
    def messages(self) -> "List[Message]":
        """ Gets the messages of this SearchJob.
        """
        return [Message._from_dict(i) for i in self._attrs.get("messages")]

    @messages.setter
    def messages(self, messages: "List[Message]"):
        """Sets the messages of this SearchJob.


        :param messages: The messages of this SearchJob.
        :type: List[Message]
        """
        self._attrs["messages"] = messages

    @property
    def module(self) -> "str":
        """ Gets the module of this SearchJob.
        The module to run the search in. The default module is  used if a module is not specified. 
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this SearchJob.

        The module to run the search in. The default module is  used if a module is not specified. 

        :param module: The module of this SearchJob.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def name(self) -> "str":
        """ Gets the name of this SearchJob.
        The name of the created search job.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this SearchJob.

        The name of the created search job.

        :param name: The name of this SearchJob.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def parent(self) -> "str":
        """ Gets the parent of this SearchJob.
        The 'rsid' of an associated recurring-search, if this search  job is dispatched by a recurring-search. 
        """
        return self._attrs.get("parent")

    @parent.setter
    def parent(self, parent: "str"):
        """Sets the parent of this SearchJob.

        The 'rsid' of an associated recurring-search, if this search  job is dispatched by a recurring-search. 

        :param parent: The parent of this SearchJob.
        :type: str
        """
        self._attrs["parent"] = parent

    @property
    def percent_complete(self) -> "int":
        """ Gets the percent_complete of this SearchJob.
        An estimate of the percent of time remaining  before the job completes. 
        """
        return self._attrs.get("percentComplete")

    @percent_complete.setter
    def percent_complete(self, percent_complete: "int"):
        """Sets the percent_complete of this SearchJob.

        An estimate of the percent of time remaining  before the job completes. 

        :param percent_complete: The percent_complete of this SearchJob.
        :type: int
        """
        self._attrs["percentComplete"] = percent_complete

    @property
    def preview_available(self) -> "str":
        """ Gets the preview_available of this SearchJob.
        Specifies if preview results are available for the search job.  The valid status values are 'unknown', 'true', and 'false'. 
        """
        return self._attrs.get("previewAvailable")

    @preview_available.setter
    def preview_available(self, preview_available: "str"):
        """Sets the preview_available of this SearchJob.

        Specifies if preview results are available for the search job.  The valid status values are 'unknown', 'true', and 'false'. 

        :param preview_available: The preview_available of this SearchJob.
        :type: str
        """
        self._attrs["previewAvailable"] = preview_available

    @property
    def query_parameters(self) -> "QueryParameters":
        """ Gets the query_parameters of this SearchJob.
        Represents parameters on the search job such as  'earliest' and 'latest'. 
        """
        return QueryParameters._from_dict(self._attrs["queryParameters"])

    @query_parameters.setter
    def query_parameters(self, query_parameters: "QueryParameters"):
        """Sets the query_parameters of this SearchJob.

        Represents parameters on the search job such as  'earliest' and 'latest'. 

        :param query_parameters: The query_parameters of this SearchJob.
        :type: QueryParameters
        """
        self._attrs["queryParameters"] = query_parameters.to_dict()

    @property
    def required_freshness(self) -> "int":
        """ Gets the required_freshness of this SearchJob.
        Specifies a maximum time interval, in seconds, between identical existing searches. The 'requiredFreshness' parameter is used to determine if an existing search with the same query and the same time boundaries can be reused, instead of running the same search again. Freshness is applied to the resolvedEarliest and resolvedLatest parameters. If an existing search has the same exact criteria as this search and the resolvedEarliest and resolvedLatest values are within the freshness interval, the existing search metadata is returned instead of initiating a new search job. By default, the requiredFreshness parameter is set to 0 which means that the platform does not attempt to use an existing search. 
        """
        return self._attrs.get("requiredFreshness")

    @required_freshness.setter
    def required_freshness(self, required_freshness: "int"):
        """Sets the required_freshness of this SearchJob.

        Specifies a maximum time interval, in seconds, between identical existing searches. The 'requiredFreshness' parameter is used to determine if an existing search with the same query and the same time boundaries can be reused, instead of running the same search again. Freshness is applied to the resolvedEarliest and resolvedLatest parameters. If an existing search has the same exact criteria as this search and the resolvedEarliest and resolvedLatest values are within the freshness interval, the existing search metadata is returned instead of initiating a new search job. By default, the requiredFreshness parameter is set to 0 which means that the platform does not attempt to use an existing search. 

        :param required_freshness: The required_freshness of this SearchJob.
        :type: int
        """
        self._attrs["requiredFreshness"] = required_freshness

    @property
    def resolved_earliest(self) -> "str":
        """ Gets the resolved_earliest of this SearchJob.
        The earliest time speciifed as an absolute value in GMT.  The time is computed based on the values you specify for the  'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedEarliest")

    @resolved_earliest.setter
    def resolved_earliest(self, resolved_earliest: "str"):
        """Sets the resolved_earliest of this SearchJob.

        The earliest time speciifed as an absolute value in GMT.  The time is computed based on the values you specify for the  'timezone' and 'earliest' queryParameters. 

        :param resolved_earliest: The resolved_earliest of this SearchJob.
        :type: str
        """
        self._attrs["resolvedEarliest"] = resolved_earliest

    @property
    def resolved_latest(self) -> "str":
        """ Gets the resolved_latest of this SearchJob.
        The latest time specified as an absolute value in GMT.  The time is computed based on the values you specify for the  'timezone' and 'earliest' queryParameters. 
        """
        return self._attrs.get("resolvedLatest")

    @resolved_latest.setter
    def resolved_latest(self, resolved_latest: "str"):
        """Sets the resolved_latest of this SearchJob.

        The latest time specified as an absolute value in GMT.  The time is computed based on the values you specify for the  'timezone' and 'earliest' queryParameters. 

        :param resolved_latest: The resolved_latest of this SearchJob.
        :type: str
        """
        self._attrs["resolvedLatest"] = resolved_latest

    @property
    def results_available(self) -> "int":
        """ Gets the results_available of this SearchJob.
        The number of results produced so far for the search job.
        """
        return self._attrs.get("resultsAvailable")

    @results_available.setter
    def results_available(self, results_available: "int"):
        """Sets the results_available of this SearchJob.

        The number of results produced so far for the search job.

        :param results_available: The results_available of this SearchJob.
        :type: int
        """
        self._attrs["resultsAvailable"] = results_available

    @property
    def results_preview_available(self) -> "int":
        """ Gets the results_preview_available of this SearchJob.
        The number of the preview search results for the job with the  specified search ID (sid). 
        """
        return self._attrs.get("resultsPreviewAvailable")

    @results_preview_available.setter
    def results_preview_available(self, results_preview_available: "int"):
        """Sets the results_preview_available of this SearchJob.

        The number of the preview search results for the job with the  specified search ID (sid). 

        :param results_preview_available: The results_preview_available of this SearchJob.
        :type: int
        """
        self._attrs["resultsPreviewAvailable"] = results_preview_available

    @property
    def sid(self) -> "str":
        """ Gets the sid of this SearchJob.
        The ID assigned to the search job.
        """
        return self._attrs.get("sid")

    @sid.setter
    def sid(self, sid: "str"):
        """Sets the sid of this SearchJob.

        The ID assigned to the search job.

        :param sid: The sid of this SearchJob.
        :type: str
        """
        self._attrs["sid"] = sid

    @property
    def status(self) -> "SearchStatus":
        """ Gets the status of this SearchJob.
        """
        return SearchStatus.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "SearchStatus"):
        """Sets the status of this SearchJob.


        :param status: The status of this SearchJob.
        :type: SearchStatus
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SingleStatementQueryParameters(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SingleStatementQueryParameters":
        instance = SingleStatementQueryParameters.__new__(SingleStatementQueryParameters)
        instance._attrs = model
        return instance

    def __init__(self, allow_side_effects: "bool" = False, collect_field_summary: "bool" = False, collect_time_buckets: "bool" = False, earliest: "str" = '-24h@h', enable_preview: "bool" = False, extract_fields: "str" = 'indexed', latest: "str" = 'now', max_time: "int" = 3600, relative_time_anchor: "datetime" = None, sid: "str" = '', timezone: "object" = None, **extra):
        """SingleStatementQueryParameters"""

        self._attrs = dict()
        if allow_side_effects is not None:
            self._attrs["allowSideEffects"] = allow_side_effects
        if collect_field_summary is not None:
            self._attrs["collectFieldSummary"] = collect_field_summary
        if collect_time_buckets is not None:
            self._attrs["collectTimeBuckets"] = collect_time_buckets
        if earliest is not None:
            self._attrs["earliest"] = earliest
        if enable_preview is not None:
            self._attrs["enablePreview"] = enable_preview
        if extract_fields is not None:
            self._attrs["extractFields"] = extract_fields
        if latest is not None:
            self._attrs["latest"] = latest
        if max_time is not None:
            self._attrs["maxTime"] = max_time
        if relative_time_anchor is not None:
            self._attrs["relativeTimeAnchor"] = relative_time_anchor
        if sid is not None:
            self._attrs["sid"] = sid
        if timezone is not None:
            self._attrs["timezone"] = timezone
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def allow_side_effects(self) -> "bool":
        """ Gets the allow_side_effects of this SingleStatementQueryParameters.
        Specifies whether a search that contains commands with side effects (with possible security risks) is allowed to run. The search contains commands, thru or into, that have side effects. 
        """
        return self._attrs.get("allowSideEffects")

    @allow_side_effects.setter
    def allow_side_effects(self, allow_side_effects: "bool"):
        """Sets the allow_side_effects of this SingleStatementQueryParameters.

        Specifies whether a search that contains commands with side effects (with possible security risks) is allowed to run. The search contains commands, thru or into, that have side effects. 

        :param allow_side_effects: The allow_side_effects of this SingleStatementQueryParameters.
        :type: bool
        """
        self._attrs["allowSideEffects"] = allow_side_effects

    @property
    def collect_field_summary(self) -> "bool":
        """ Gets the collect_field_summary of this SingleStatementQueryParameters.
        Specifies whether a search is allowed to collect the Fields summary during the run time. 
        """
        return self._attrs.get("collectFieldSummary")

    @collect_field_summary.setter
    def collect_field_summary(self, collect_field_summary: "bool"):
        """Sets the collect_field_summary of this SingleStatementQueryParameters.

        Specifies whether a search is allowed to collect the Fields summary during the run time. 

        :param collect_field_summary: The collect_field_summary of this SingleStatementQueryParameters.
        :type: bool
        """
        self._attrs["collectFieldSummary"] = collect_field_summary

    @property
    def collect_time_buckets(self) -> "bool":
        """ Gets the collect_time_buckets of this SingleStatementQueryParameters.
        Specifies whether a search is allowed to collect the Timeline Buckets summary during the run time. 
        """
        return self._attrs.get("collectTimeBuckets")

    @collect_time_buckets.setter
    def collect_time_buckets(self, collect_time_buckets: "bool"):
        """Sets the collect_time_buckets of this SingleStatementQueryParameters.

        Specifies whether a search is allowed to collect the Timeline Buckets summary during the run time. 

        :param collect_time_buckets: The collect_time_buckets of this SingleStatementQueryParameters.
        :type: bool
        """
        self._attrs["collectTimeBuckets"] = collect_time_buckets

    @property
    def earliest(self) -> "str":
        """ Gets the earliest of this SingleStatementQueryParameters.
        The earliest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2020-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 
        """
        return self._attrs.get("earliest")

    @earliest.setter
    def earliest(self, earliest: "str"):
        """Sets the earliest of this SingleStatementQueryParameters.

        The earliest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2020-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 

        :param earliest: The earliest of this SingleStatementQueryParameters.
        :type: str
        """
        self._attrs["earliest"] = earliest

    @property
    def enable_preview(self) -> "bool":
        """ Gets the enable_preview of this SingleStatementQueryParameters.
        Specifies whether a search is allowed to collect the preview results during the run time. 
        """
        return self._attrs.get("enablePreview")

    @enable_preview.setter
    def enable_preview(self, enable_preview: "bool"):
        """Sets the enable_preview of this SingleStatementQueryParameters.

        Specifies whether a search is allowed to collect the preview results during the run time. 

        :param enable_preview: The enable_preview of this SingleStatementQueryParameters.
        :type: bool
        """
        self._attrs["enablePreview"] = enable_preview

    @property
    def extract_fields(self) -> "str":
        """ Gets the extract_fields of this SingleStatementQueryParameters.
        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' extracts all fields, 'indexed' extracts only indexed fields, and 'none' extracts only the default fields. 
        """
        return self._attrs.get("extractFields")

    @extract_fields.setter
    def extract_fields(self, extract_fields: "str"):
        """Sets the extract_fields of this SingleStatementQueryParameters.

        Specifies how the Search service should extract fields. Valid values include 'all', 'none', or 'indexed'. 'all' extracts all fields, 'indexed' extracts only indexed fields, and 'none' extracts only the default fields. 

        :param extract_fields: The extract_fields of this SingleStatementQueryParameters.
        :type: str
        """
        self._attrs["extractFields"] = extract_fields

    @property
    def latest(self) -> "str":
        """ Gets the latest of this SingleStatementQueryParameters.
        The latest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2020-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 
        """
        return self._attrs.get("latest")

    @latest.setter
    def latest(self, latest: "str"):
        """Sets the latest of this SingleStatementQueryParameters.

        The latest time, in absolute or relative format, to retrieve events. When specifying an absolute time specify either UNIX time, or UTC in seconds using the ISO-8601 (%FT%T.%Q) format. For example 2020-01-25T13:15:30Z. GMT is the default timezone. You must specify GMT when you specify UTC. Any offset specified is ignored. 

        :param latest: The latest of this SingleStatementQueryParameters.
        :type: str
        """
        self._attrs["latest"] = latest

    @property
    def max_time(self) -> "int":
        """ Gets the max_time of this SingleStatementQueryParameters.
        The number of seconds to run the search before finalizing the search. The maximum value is 3600 seconds (1 hour). 
        """
        return self._attrs.get("maxTime")

    @max_time.setter
    def max_time(self, max_time: "int"):
        """Sets the max_time of this SingleStatementQueryParameters.

        The number of seconds to run the search before finalizing the search. The maximum value is 3600 seconds (1 hour). 

        :param max_time: The max_time of this SingleStatementQueryParameters.
        :type: int
        """
        self._attrs["maxTime"] = max_time

    @property
    def relative_time_anchor(self) -> "datetime":
        """ Gets the relative_time_anchor of this SingleStatementQueryParameters.
        Relative values for the 'earliest' and 'latest' parameters snap to the unit that you specify. For example, if 'earliest' is set to -d@d, the unit is day. If the 'relativeTimeAnchor' is is set to '2020-10-05T13:15:30Z' then 'resolvedEarliest' is snapped to '2020-10-05T00:00:00Z', which is the day. Hours, minutes, and seconds are dropped. If no 'relativeTimeAnchor' is specified, the default value is set to the time the search job was created. 
        """
        return self._attrs.get("relativeTimeAnchor")

    @relative_time_anchor.setter
    def relative_time_anchor(self, relative_time_anchor: "datetime"):
        """Sets the relative_time_anchor of this SingleStatementQueryParameters.

        Relative values for the 'earliest' and 'latest' parameters snap to the unit that you specify. For example, if 'earliest' is set to -d@d, the unit is day. If the 'relativeTimeAnchor' is is set to '2020-10-05T13:15:30Z' then 'resolvedEarliest' is snapped to '2020-10-05T00:00:00Z', which is the day. Hours, minutes, and seconds are dropped. If no 'relativeTimeAnchor' is specified, the default value is set to the time the search job was created. 

        :param relative_time_anchor: The relative_time_anchor of this SingleStatementQueryParameters.
        :type: datetime
        """
        self._attrs["relativeTimeAnchor"] = relative_time_anchor

    @property
    def sid(self) -> "str":
        """ Gets the sid of this SingleStatementQueryParameters.
        Reuse the results from the previous search ID (sid) for the statement. For customized default queryParameters, the sid is ignored. 
        """
        return self._attrs.get("sid")

    @sid.setter
    def sid(self, sid: "str"):
        """Sets the sid of this SingleStatementQueryParameters.

        Reuse the results from the previous search ID (sid) for the statement. For customized default queryParameters, the sid is ignored. 

        :param sid: The sid of this SingleStatementQueryParameters.
        :type: str
        """
        self._attrs["sid"] = sid

    @property
    def timezone(self) -> "object":
        """ Gets the timezone of this SingleStatementQueryParameters.
        The timezone that relative time specifiers are based off of. Timezone only applies to relative time literals for 'earliest' and 'latest'. If UNIX time or UTC format is used for 'earliest' and 'latest', this field is ignored. For the list of supported timezone formats, see https://docs.splunk.com/Documentation/Splunk/latest/Data/Applytimezoneoffsetstotimestamps#zoneinfo_.28TZ.29_database type: string default: \"GMT\" 
        """
        return self._attrs.get("timezone")

    @timezone.setter
    def timezone(self, timezone: "object"):
        """Sets the timezone of this SingleStatementQueryParameters.

        The timezone that relative time specifiers are based off of. Timezone only applies to relative time literals for 'earliest' and 'latest'. If UNIX time or UTC format is used for 'earliest' and 'latest', this field is ignored. For the list of supported timezone formats, see https://docs.splunk.com/Documentation/Splunk/latest/Data/Applytimezoneoffsetstotimestamps#zoneinfo_.28TZ.29_database type: string default: \"GMT\" 

        :param timezone: The timezone of this SingleStatementQueryParameters.
        :type: object
        """
        self._attrs["timezone"] = timezone

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SearchModule(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SearchModule":
        instance = SearchModule.__new__(SearchModule)
        instance._attrs = model
        return instance

    def __init__(self, module: "str" = None, namespace: "str" = '', query_parameters: "Dict[str, SingleStatementQueryParameters]" = None, **extra):
        """SearchModule"""

        self._attrs = dict()
        if module is not None:
            self._attrs["module"] = module
        if namespace is not None:
            self._attrs["namespace"] = namespace
        if query_parameters is not None:
            self._attrs["queryParameters"] = query_parameters
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def module(self) -> "str":
        """ Gets the module of this SearchModule.
        Multi-statement module with inter-dependencies between statements. Statements are separated by semicolons.
        """
        return self._attrs.get("module")

    @module.setter
    def module(self, module: "str"):
        """Sets the module of this SearchModule.

        Multi-statement module with inter-dependencies between statements. Statements are separated by semicolons.

        :param module: The module of this SearchModule.
        :type: str
        """
        self._attrs["module"] = module

    @property
    def namespace(self) -> "str":
        """ Gets the namespace of this SearchModule.
        The namespace to run the search in. The default namespace is used if a namespace is not specified.
        """
        return self._attrs.get("namespace")

    @namespace.setter
    def namespace(self, namespace: "str"):
        """Sets the namespace of this SearchModule.

        The namespace to run the search in. The default namespace is used if a namespace is not specified.

        :param namespace: The namespace of this SearchModule.
        :type: str
        """
        self._attrs["namespace"] = namespace

    @property
    def query_parameters(self) -> "Dict[str, SingleStatementQueryParameters]":
        """ Gets the query_parameters of this SearchModule.
        The parameters on the search statement, such as 'earliest' and 'latest. The request can specify a \"defaults\" set of statement queryParameters which override the system default queryParameters. Each export statement requires to have a statement queryParameters in the object, it can be empty if there is no override. 
        """
        return self._attrs.get("queryParameters")

    @query_parameters.setter
    def query_parameters(self, query_parameters: "Dict[str, SingleStatementQueryParameters]"):
        """Sets the query_parameters of this SearchModule.

        The parameters on the search statement, such as 'earliest' and 'latest. The request can specify a \"defaults\" set of statement queryParameters which override the system default queryParameters. Each export statement requires to have a statement queryParameters in the object, it can be empty if there is no override. 

        :param query_parameters: The query_parameters of this SearchModule.
        :type: Dict[str, SingleStatementQueryParameters]
        """
        self._attrs["queryParameters"] = query_parameters

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SingleTimeBucket(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SingleTimeBucket":
        instance = SingleTimeBucket.__new__(SingleTimeBucket)
        instance._attrs = model
        return instance

    def __init__(self, available_count: "int" = None, duration: "float" = None, earliest_time: "float" = None, earliest_time_strf_time: "str" = None, is_finalized: "bool" = None, total_count: "int" = None, **extra):
        """SingleTimeBucket"""

        self._attrs = dict()
        if available_count is not None:
            self._attrs["availableCount"] = available_count
        if duration is not None:
            self._attrs["duration"] = duration
        if earliest_time is not None:
            self._attrs["earliestTime"] = earliest_time
        if earliest_time_strf_time is not None:
            self._attrs["earliestTimeStrfTime"] = earliest_time_strf_time
        if is_finalized is not None:
            self._attrs["isFinalized"] = is_finalized
        if total_count is not None:
            self._attrs["totalCount"] = total_count
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def available_count(self) -> "int":
        """ Gets the available_count of this SingleTimeBucket.
        Count of available events. Not all events in a bucket  are retrievable. Typically this count is capped at 10000. 
        """
        return self._attrs.get("availableCount")

    @available_count.setter
    def available_count(self, available_count: "int"):
        """Sets the available_count of this SingleTimeBucket.

        Count of available events. Not all events in a bucket  are retrievable. Typically this count is capped at 10000. 

        :param available_count: The available_count of this SingleTimeBucket.
        :type: int
        """
        self._attrs["availableCount"] = available_count

    @property
    def duration(self) -> "float":
        """ Gets the duration of this SingleTimeBucket.
        """
        return self._attrs.get("duration")

    @duration.setter
    def duration(self, duration: "float"):
        """Sets the duration of this SingleTimeBucket.


        :param duration: The duration of this SingleTimeBucket.
        :type: float
        """
        self._attrs["duration"] = duration

    @property
    def earliest_time(self) -> "float":
        """ Gets the earliest_time of this SingleTimeBucket.
        The timestamp of the earliest event in the current bucket,  in UNIX format. This is the same time as 'earliestTimeStrfTime'  in UNIX format. 
        """
        return self._attrs.get("earliestTime")

    @earliest_time.setter
    def earliest_time(self, earliest_time: "float"):
        """Sets the earliest_time of this SingleTimeBucket.

        The timestamp of the earliest event in the current bucket,  in UNIX format. This is the same time as 'earliestTimeStrfTime'  in UNIX format. 

        :param earliest_time: The earliest_time of this SingleTimeBucket.
        :type: float
        """
        self._attrs["earliestTime"] = earliest_time

    @property
    def earliest_time_strf_time(self) -> "str":
        """ Gets the earliest_time_strf_time of this SingleTimeBucket.
        The timestamp of the earliest event in the current bucket,  in UTC format with seconds. For example 2019-01-25T13:15:30Z,  which follows the ISO-8601 (%FT%T.%Q) format. 
        """
        return self._attrs.get("earliestTimeStrfTime")

    @earliest_time_strf_time.setter
    def earliest_time_strf_time(self, earliest_time_strf_time: "str"):
        """Sets the earliest_time_strf_time of this SingleTimeBucket.

        The timestamp of the earliest event in the current bucket,  in UTC format with seconds. For example 2019-01-25T13:15:30Z,  which follows the ISO-8601 (%FT%T.%Q) format. 

        :param earliest_time_strf_time: The earliest_time_strf_time of this SingleTimeBucket.
        :type: str
        """
        self._attrs["earliestTimeStrfTime"] = earliest_time_strf_time

    @property
    def is_finalized(self) -> "bool":
        """ Gets the is_finalized of this SingleTimeBucket.
        Specifies if all of the events in the current bucket  have been finalized. 
        """
        return self._attrs.get("isFinalized")

    @is_finalized.setter
    def is_finalized(self, is_finalized: "bool"):
        """Sets the is_finalized of this SingleTimeBucket.

        Specifies if all of the events in the current bucket  have been finalized. 

        :param is_finalized: The is_finalized of this SingleTimeBucket.
        :type: bool
        """
        self._attrs["isFinalized"] = is_finalized

    @property
    def total_count(self) -> "int":
        """ Gets the total_count of this SingleTimeBucket.
        The total count of the events in the current bucket.
        """
        return self._attrs.get("totalCount")

    @total_count.setter
    def total_count(self, total_count: "int"):
        """Sets the total_count of this SingleTimeBucket.

        The total count of the events in the current bucket.

        :param total_count: The total_count of this SingleTimeBucket.
        :type: int
        """
        self._attrs["totalCount"] = total_count

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TimeBucketsSummary(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TimeBucketsSummary":
        instance = TimeBucketsSummary.__new__(TimeBucketsSummary)
        instance._attrs = model
        return instance

    def __init__(self, is_time_cursored: "bool" = None, buckets: "List[SingleTimeBucket]" = None, cursor_time: "float" = None, event_count: "int" = None, **extra):
        """TimeBucketsSummary"""

        self._attrs = dict()
        if is_time_cursored is not None:
            self._attrs["IsTimeCursored"] = is_time_cursored
        if buckets is not None:
            self._attrs["buckets"] = buckets
        if cursor_time is not None:
            self._attrs["cursorTime"] = cursor_time
        if event_count is not None:
            self._attrs["eventCount"] = event_count
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def is_time_cursored(self) -> "bool":
        """ Gets the is_time_cursored of this TimeBucketsSummary.
        Specifies if the events are returned in time order.
        """
        return self._attrs.get("IsTimeCursored")

    @is_time_cursored.setter
    def is_time_cursored(self, is_time_cursored: "bool"):
        """Sets the is_time_cursored of this TimeBucketsSummary.

        Specifies if the events are returned in time order.

        :param is_time_cursored: The is_time_cursored of this TimeBucketsSummary.
        :type: bool
        """
        self._attrs["IsTimeCursored"] = is_time_cursored

    @property
    def buckets(self) -> "List[SingleTimeBucket]":
        """ Gets the buckets of this TimeBucketsSummary.
        """
        return [SingleTimeBucket._from_dict(i) for i in self._attrs.get("buckets")]

    @buckets.setter
    def buckets(self, buckets: "List[SingleTimeBucket]"):
        """Sets the buckets of this TimeBucketsSummary.


        :param buckets: The buckets of this TimeBucketsSummary.
        :type: List[SingleTimeBucket]
        """
        self._attrs["buckets"] = buckets

    @property
    def cursor_time(self) -> "float":
        """ Gets the cursor_time of this TimeBucketsSummary.
        Identifies where the cursor is, in processing the events.  The 'cursorTime' is a timestamp specified in UNIX time. 
        """
        return self._attrs.get("cursorTime")

    @cursor_time.setter
    def cursor_time(self, cursor_time: "float"):
        """Sets the cursor_time of this TimeBucketsSummary.

        Identifies where the cursor is, in processing the events.  The 'cursorTime' is a timestamp specified in UNIX time. 

        :param cursor_time: The cursor_time of this TimeBucketsSummary.
        :type: float
        """
        self._attrs["cursorTime"] = cursor_time

    @property
    def event_count(self) -> "int":
        """ Gets the event_count of this TimeBucketsSummary.
        The number of events processed at the 'cursorTime'.
        """
        return self._attrs.get("eventCount")

    @event_count.setter
    def event_count(self, event_count: "int"):
        """Sets the event_count of this TimeBucketsSummary.

        The number of events processed at the 'cursorTime'.

        :param event_count: The event_count of this TimeBucketsSummary.
        :type: int
        """
        self._attrs["eventCount"] = event_count

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    CANCELED = "canceled"
    FINALIZED = "finalized"

    @staticmethod
    def from_value(value: str):
        if value == "canceled":
            return StatusEnum.CANCELED
        if value == "finalized":
            return StatusEnum.FINALIZED


class UpdateJob(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UpdateJob":
        instance = UpdateJob.__new__(UpdateJob)
        instance._attrs = model
        return instance

    def __init__(self, status: "str", **extra):
        """UpdateJob"""

        self._attrs = dict()
        if status is not None:
            self._attrs["status"] = status
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this UpdateJob.
        The status to PATCH to an existing search job. The only status values you can PATCH are 'canceled' and 'finalized'. You can PATCH the 'canceled' status only to a search job that is running. 
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this UpdateJob.

        The status to PATCH to an existing search job. The only status values you can PATCH are 'canceled' and 'finalized'. You can PATCH the 'canceled' status only to a search job that is running. 

        :param status: The status of this UpdateJob.
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
