# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Data Stream Processing REST API

    Use the Streams service to perform create, read, update, and delete (CRUD) operations on your data pipeline. The Streams service also has metrics and preview session endpoints and gives you full control over your data pipeline.

    OpenAPI spec version: v2beta1.4 
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class ActivatePipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ActivatePipelineRequest":
        instance = ActivatePipelineRequest.__new__(ActivatePipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, activate_latest_version: "bool" = None, allow_non_restored_state: "bool" = None, skip_restore_state: "bool" = None, **extra):
        """ActivatePipelineRequest"""

        self._attrs = dict()
        if activate_latest_version is not None:
            self._attrs["activateLatestVersion"] = activate_latest_version
        if allow_non_restored_state is not None:
            self._attrs["allowNonRestoredState"] = allow_non_restored_state
        if skip_restore_state is not None:
            self._attrs["skipRestoreState"] = skip_restore_state
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activate_latest_version(self) -> "bool":
        """ Gets the activate_latest_version of this ActivatePipelineRequest.
        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.
        """
        return self._attrs.get("activateLatestVersion")

    @activate_latest_version.setter
    def activate_latest_version(self, activate_latest_version: "bool"):
        """Sets the activate_latest_version of this ActivatePipelineRequest.

        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.

        :param activate_latest_version: The activate_latest_version of this ActivatePipelineRequest.
        :type: bool
        """
        self._attrs["activateLatestVersion"] = activate_latest_version

    @property
    def allow_non_restored_state(self) -> "bool":
        """ Gets the allow_non_restored_state of this ActivatePipelineRequest.
        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to activate a pipeline in this state. Defaults to false.
        """
        return self._attrs.get("allowNonRestoredState")

    @allow_non_restored_state.setter
    def allow_non_restored_state(self, allow_non_restored_state: "bool"):
        """Sets the allow_non_restored_state of this ActivatePipelineRequest.

        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to activate a pipeline in this state. Defaults to false.

        :param allow_non_restored_state: The allow_non_restored_state of this ActivatePipelineRequest.
        :type: bool
        """
        self._attrs["allowNonRestoredState"] = allow_non_restored_state

    @property
    def skip_restore_state(self) -> "bool":
        """ Gets the skip_restore_state of this ActivatePipelineRequest.
        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.
        """
        return self._attrs.get("skipRestoreState")

    @skip_restore_state.setter
    def skip_restore_state(self, skip_restore_state: "bool"):
        """Sets the skip_restore_state of this ActivatePipelineRequest.

        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.

        :param skip_restore_state: The skip_restore_state of this ActivatePipelineRequest.
        :type: bool
        """
        self._attrs["skipRestoreState"] = skip_restore_state

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionPatchRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionPatchRequest":
        instance = ConnectionPatchRequest.__new__(ConnectionPatchRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "object" = None, description: "str" = None, name: "str" = None, **extra):
        """ConnectionPatchRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionPatchRequest.
        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionPatchRequest.

        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.

        :param data: The data of this ConnectionPatchRequest.
        :type: object
        """
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionPatchRequest.
        The description of the connection.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionPatchRequest.

        The description of the connection.

        :param description: The description of this ConnectionPatchRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionPatchRequest.
        The name of the connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionPatchRequest.

        The name of the connection.

        :param name: The name of this ConnectionPatchRequest.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionPutRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionPutRequest":
        instance = ConnectionPutRequest.__new__(ConnectionPutRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "object", description: "str", name: "str", **extra):
        """ConnectionPutRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionPutRequest.
        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionPutRequest.

        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.

        :param data: The data of this ConnectionPutRequest.
        :type: object
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionPutRequest.
        The description of the connection.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionPutRequest.

        The description of the connection.

        :param description: The description of this ConnectionPutRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionPutRequest.
        The name of the connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionPutRequest.

        The name of the connection.

        :param name: The name of this ConnectionPutRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionRequest":
        instance = ConnectionRequest.__new__(ConnectionRequest)
        instance._attrs = model
        return instance

    def __init__(self, connector_id: "str", data: "object", description: "str", name: "str", **extra):
        """ConnectionRequest"""

        self._attrs = dict()
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this ConnectionRequest.
        The ID of the parent connector.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this ConnectionRequest.

        The ID of the parent connector.

        :param connector_id: The connector_id of this ConnectionRequest.
        :type: str
        """
        if connector_id is None:
            raise ValueError("Invalid value for `connector_id`, must not be `None`")
        self._attrs["connectorId"] = connector_id

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionRequest.
        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionRequest.

        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.

        :param data: The data of this ConnectionRequest.
        :type: object
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionRequest.
        The description of the connection.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionRequest.

        The description of the connection.

        :param description: The description of this ConnectionRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionRequest.
        The name of the connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionRequest.

        The name of the connection.

        :param name: The name of this ConnectionRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Source(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Source":
        instance = Source.__new__(Source)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "object" = None, connection_id: "str" = None, connector_id: "str" = None, create_date: "int" = None, create_user_id: "str" = None, data_stream_id: "str" = None, description: "str" = None, enabled: "bool" = None, id: "str" = None, last_update_date: "int" = None, last_update_user_id: "str" = None, name: "str" = None, parallelism: "int" = None, tenant_id: "str" = None, version: "int" = None, **extra):
        """Source"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if connection_id is not None:
            self._attrs["connectionId"] = connection_id
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data_stream_id is not None:
            self._attrs["dataStreamId"] = data_stream_id
        if description is not None:
            self._attrs["description"] = description
        if enabled is not None:
            self._attrs["enabled"] = enabled
        if id is not None:
            self._attrs["id"] = id
        if last_update_date is not None:
            self._attrs["lastUpdateDate"] = last_update_date
        if last_update_user_id is not None:
            self._attrs["lastUpdateUserId"] = last_update_user_id
        if name is not None:
            self._attrs["name"] = name
        if parallelism is not None:
            self._attrs["parallelism"] = parallelism
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "dict":
        """ Gets the arguments of this Source.
        """
        return self._attrs.get("arguments")

    @arguments.setter
    def arguments(self, arguments: "dict"):
        """Sets the arguments of this Source.


        :param arguments: The arguments of this Source.
        :type: object
        """
        self._attrs["arguments"] = arguments

    @property
    def connection_id(self) -> "str":
        """ Gets the connection_id of this Source.
        """
        return self._attrs.get("connectionId")

    @connection_id.setter
    def connection_id(self, connection_id: "str"):
        """Sets the connection_id of this Source.


        :param connection_id: The connection_id of this Source.
        :type: str
        """
        self._attrs["connectionId"] = connection_id

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this Source.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this Source.


        :param connector_id: The connector_id of this Source.
        :type: str
        """
        self._attrs["connectorId"] = connector_id

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this Source.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this Source.


        :param create_date: The create_date of this Source.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this Source.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this Source.


        :param create_user_id: The create_user_id of this Source.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data_stream_id(self) -> "str":
        """ Gets the data_stream_id of this Source.
        """
        return self._attrs.get("dataStreamId")

    @data_stream_id.setter
    def data_stream_id(self, data_stream_id: "str"):
        """Sets the data_stream_id of this Source.


        :param data_stream_id: The data_stream_id of this Source.
        :type: str
        """
        self._attrs["dataStreamId"] = data_stream_id

    @property
    def description(self) -> "str":
        """ Gets the description of this Source.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Source.


        :param description: The description of this Source.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def enabled(self) -> "bool":
        """ Gets the enabled of this Source.
        """
        return self._attrs.get("enabled")

    @enabled.setter
    def enabled(self, enabled: "bool"):
        """Sets the enabled of this Source.


        :param enabled: The enabled of this Source.
        :type: bool
        """
        self._attrs["enabled"] = enabled

    @property
    def id(self) -> "str":
        """ Gets the id of this Source.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Source.


        :param id: The id of this Source.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def last_update_date(self) -> "int":
        """ Gets the last_update_date of this Source.
        """
        return self._attrs.get("lastUpdateDate")

    @last_update_date.setter
    def last_update_date(self, last_update_date: "int"):
        """Sets the last_update_date of this Source.


        :param last_update_date: The last_update_date of this Source.
        :type: int
        """
        self._attrs["lastUpdateDate"] = last_update_date

    @property
    def last_update_user_id(self) -> "str":
        """ Gets the last_update_user_id of this Source.
        """
        return self._attrs.get("lastUpdateUserId")

    @last_update_user_id.setter
    def last_update_user_id(self, last_update_user_id: "str"):
        """Sets the last_update_user_id of this Source.


        :param last_update_user_id: The last_update_user_id of this Source.
        :type: str
        """
        self._attrs["lastUpdateUserId"] = last_update_user_id

    @property
    def name(self) -> "str":
        """ Gets the name of this Source.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Source.


        :param name: The name of this Source.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def parallelism(self) -> "int":
        """ Gets the parallelism of this Source.
        """
        return self._attrs.get("parallelism")

    @parallelism.setter
    def parallelism(self, parallelism: "int"):
        """Sets the parallelism of this Source.


        :param parallelism: The parallelism of this Source.
        :type: int
        """
        self._attrs["parallelism"] = parallelism

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this Source.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this Source.


        :param tenant_id: The tenant_id of this Source.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    @property
    def version(self) -> "int":
        """ Gets the version of this Source.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Source.


        :param version: The version of this Source.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionVersionResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionVersionResponse":
        instance = ConnectionVersionResponse.__new__(ConnectionVersionResponse)
        instance._attrs = model
        return instance

    def __init__(self, create_date: "int" = None, create_user_id: "str" = None, data: "object" = None, description: "str" = None, name: "str" = None, version: "int" = None, **extra):
        """ConnectionVersionResponse"""

        self._attrs = dict()
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this ConnectionVersionResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this ConnectionVersionResponse.


        :param create_date: The create_date of this ConnectionVersionResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this ConnectionVersionResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this ConnectionVersionResponse.


        :param create_user_id: The create_user_id of this ConnectionVersionResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionVersionResponse.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionVersionResponse.


        :param data: The data of this ConnectionVersionResponse.
        :type: object
        """
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionVersionResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionVersionResponse.


        :param description: The description of this ConnectionVersionResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionVersionResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionVersionResponse.


        :param name: The name of this ConnectionVersionResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this ConnectionVersionResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ConnectionVersionResponse.


        :param version: The version of this ConnectionVersionResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionResponse":
        instance = ConnectionResponse.__new__(ConnectionResponse)
        instance._attrs = model
        return instance

    def __init__(self, active_pipelines_using: "List[object]" = None, active_sources_using: "List[Source]" = None, connector_id: "str" = None, connector_name: "str" = None, create_date: "int" = None, create_user_id: "str" = None, id: "str" = None, last_update_date: "int" = None, last_update_user_id: "str" = None, versions: "List[ConnectionVersionResponse]" = None, **extra):
        """ConnectionResponse"""

        self._attrs = dict()
        if active_pipelines_using is not None:
            self._attrs["activePipelinesUsing"] = active_pipelines_using
        if active_sources_using is not None:
            self._attrs["activeSourcesUsing"] = active_sources_using
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if connector_name is not None:
            self._attrs["connectorName"] = connector_name
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if id is not None:
            self._attrs["id"] = id
        if last_update_date is not None:
            self._attrs["lastUpdateDate"] = last_update_date
        if last_update_user_id is not None:
            self._attrs["lastUpdateUserId"] = last_update_user_id
        if versions is not None:
            self._attrs["versions"] = versions
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def active_pipelines_using(self) -> "List[object]":
        """ Gets the active_pipelines_using of this ConnectionResponse.
        """
        return self._attrs.get("activePipelinesUsing")

    @active_pipelines_using.setter
    def active_pipelines_using(self, active_pipelines_using: "List[object]"):
        """Sets the active_pipelines_using of this ConnectionResponse.


        :param active_pipelines_using: The active_pipelines_using of this ConnectionResponse.
        :type: List[object]
        """
        self._attrs["activePipelinesUsing"] = active_pipelines_using

    @property
    def active_sources_using(self) -> "List[Source]":
        """ Gets the active_sources_using of this ConnectionResponse.
        """
        return [Source._from_dict(i) for i in self._attrs.get("activeSourcesUsing")]

    @active_sources_using.setter
    def active_sources_using(self, active_sources_using: "List[Source]"):
        """Sets the active_sources_using of this ConnectionResponse.


        :param active_sources_using: The active_sources_using of this ConnectionResponse.
        :type: List[Source]
        """
        self._attrs["activeSourcesUsing"] = active_sources_using

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this ConnectionResponse.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this ConnectionResponse.


        :param connector_id: The connector_id of this ConnectionResponse.
        :type: str
        """
        self._attrs["connectorId"] = connector_id

    @property
    def connector_name(self) -> "str":
        """ Gets the connector_name of this ConnectionResponse.
        """
        return self._attrs.get("connectorName")

    @connector_name.setter
    def connector_name(self, connector_name: "str"):
        """Sets the connector_name of this ConnectionResponse.


        :param connector_name: The connector_name of this ConnectionResponse.
        :type: str
        """
        self._attrs["connectorName"] = connector_name

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this ConnectionResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this ConnectionResponse.


        :param create_date: The create_date of this ConnectionResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this ConnectionResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this ConnectionResponse.


        :param create_user_id: The create_user_id of this ConnectionResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def id(self) -> "str":
        """ Gets the id of this ConnectionResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ConnectionResponse.


        :param id: The id of this ConnectionResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def last_update_date(self) -> "int":
        """ Gets the last_update_date of this ConnectionResponse.
        """
        return self._attrs.get("lastUpdateDate")

    @last_update_date.setter
    def last_update_date(self, last_update_date: "int"):
        """Sets the last_update_date of this ConnectionResponse.


        :param last_update_date: The last_update_date of this ConnectionResponse.
        :type: int
        """
        self._attrs["lastUpdateDate"] = last_update_date

    @property
    def last_update_user_id(self) -> "str":
        """ Gets the last_update_user_id of this ConnectionResponse.
        """
        return self._attrs.get("lastUpdateUserId")

    @last_update_user_id.setter
    def last_update_user_id(self, last_update_user_id: "str"):
        """Sets the last_update_user_id of this ConnectionResponse.


        :param last_update_user_id: The last_update_user_id of this ConnectionResponse.
        :type: str
        """
        self._attrs["lastUpdateUserId"] = last_update_user_id

    @property
    def versions(self) -> "List[ConnectionVersionResponse]":
        """ Gets the versions of this ConnectionResponse.
        """
        return [ConnectionVersionResponse._from_dict(i) for i in self._attrs.get("versions")]

    @versions.setter
    def versions(self, versions: "List[ConnectionVersionResponse]"):
        """Sets the versions of this ConnectionResponse.


        :param versions: The versions of this ConnectionResponse.
        :type: List[ConnectionVersionResponse]
        """
        self._attrs["versions"] = versions

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionSaveResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionSaveResponse":
        instance = ConnectionSaveResponse.__new__(ConnectionSaveResponse)
        instance._attrs = model
        return instance

    def __init__(self, connector_id: "str" = None, create_date: "int" = None, create_user_id: "str" = None, data: "object" = None, description: "str" = None, id: "str" = None, messages: "List[str]" = None, name: "str" = None, version: "int" = None, **extra):
        """ConnectionSaveResponse"""

        self._attrs = dict()
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if id is not None:
            self._attrs["id"] = id
        if messages is not None:
            self._attrs["messages"] = messages
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this ConnectionSaveResponse.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this ConnectionSaveResponse.


        :param connector_id: The connector_id of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["connectorId"] = connector_id

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this ConnectionSaveResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this ConnectionSaveResponse.


        :param create_date: The create_date of this ConnectionSaveResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this ConnectionSaveResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this ConnectionSaveResponse.


        :param create_user_id: The create_user_id of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionSaveResponse.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionSaveResponse.


        :param data: The data of this ConnectionSaveResponse.
        :type: object
        """
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionSaveResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionSaveResponse.


        :param description: The description of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def id(self) -> "str":
        """ Gets the id of this ConnectionSaveResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ConnectionSaveResponse.


        :param id: The id of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def messages(self) -> "List[str]":
        """ Gets the messages of this ConnectionSaveResponse.
        """
        return self._attrs.get("messages")

    @messages.setter
    def messages(self, messages: "List[str]"):
        """Sets the messages of this ConnectionSaveResponse.


        :param messages: The messages of this ConnectionSaveResponse.
        :type: List[str]
        """
        self._attrs["messages"] = messages

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionSaveResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionSaveResponse.


        :param name: The name of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this ConnectionSaveResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ConnectionSaveResponse.


        :param version: The version of this ConnectionSaveResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectorResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectorResponse":
        instance = ConnectorResponse.__new__(ConnectorResponse)
        instance._attrs = model
        return instance

    def __init__(self, attributes: "object" = None, config: "object" = None, connector_type: "str" = None, description: "str" = None, functions: "List[object]" = None, hidden: "bool" = None, id: "str" = None, name: "str" = None, panel_url: "str" = None, tag: "str" = None, **extra):
        """ConnectorResponse"""

        self._attrs = dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if config is not None:
            self._attrs["config"] = config
        if connector_type is not None:
            self._attrs["connectorType"] = connector_type
        if description is not None:
            self._attrs["description"] = description
        if functions is not None:
            self._attrs["functions"] = functions
        if hidden is not None:
            self._attrs["hidden"] = hidden
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        if panel_url is not None:
            self._attrs["panelUrl"] = panel_url
        if tag is not None:
            self._attrs["tag"] = tag
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this ConnectorResponse.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this ConnectorResponse.


        :param attributes: The attributes of this ConnectorResponse.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def config(self) -> "dict":
        """ Gets the config of this ConnectorResponse.
        """
        return self._attrs.get("config")

    @config.setter
    def config(self, config: "dict"):
        """Sets the config of this ConnectorResponse.


        :param config: The config of this ConnectorResponse.
        :type: object
        """
        self._attrs["config"] = config

    @property
    def connector_type(self) -> "str":
        """ Gets the connector_type of this ConnectorResponse.
        """
        return self._attrs.get("connectorType")

    @connector_type.setter
    def connector_type(self, connector_type: "str"):
        """Sets the connector_type of this ConnectorResponse.


        :param connector_type: The connector_type of this ConnectorResponse.
        :type: str
        """
        self._attrs["connectorType"] = connector_type

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectorResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectorResponse.


        :param description: The description of this ConnectorResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def functions(self) -> "List[object]":
        """ Gets the functions of this ConnectorResponse.
        """
        return self._attrs.get("functions")

    @functions.setter
    def functions(self, functions: "List[object]"):
        """Sets the functions of this ConnectorResponse.


        :param functions: The functions of this ConnectorResponse.
        :type: List[object]
        """
        self._attrs["functions"] = functions

    @property
    def hidden(self) -> "bool":
        """ Gets the hidden of this ConnectorResponse.
        """
        return self._attrs.get("hidden")

    @hidden.setter
    def hidden(self, hidden: "bool"):
        """Sets the hidden of this ConnectorResponse.


        :param hidden: The hidden of this ConnectorResponse.
        :type: bool
        """
        self._attrs["hidden"] = hidden

    @property
    def id(self) -> "str":
        """ Gets the id of this ConnectorResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ConnectorResponse.


        :param id: The id of this ConnectorResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectorResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectorResponse.


        :param name: The name of this ConnectorResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def panel_url(self) -> "str":
        """ Gets the panel_url of this ConnectorResponse.
        """
        return self._attrs.get("panelUrl")

    @panel_url.setter
    def panel_url(self, panel_url: "str"):
        """Sets the panel_url of this ConnectorResponse.


        :param panel_url: The panel_url of this ConnectorResponse.
        :type: str
        """
        self._attrs["panelUrl"] = panel_url

    @property
    def tag(self) -> "str":
        """ Gets the tag of this ConnectorResponse.
        """
        return self._attrs.get("tag")

    @tag.setter
    def tag(self, tag: "str"):
        """Sets the tag of this ConnectorResponse.


        :param tag: The tag of this ConnectorResponse.
        :type: str
        """
        self._attrs["tag"] = tag

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DeactivatePipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DeactivatePipelineRequest":
        instance = DeactivatePipelineRequest.__new__(DeactivatePipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, skip_savepoint: "bool" = None, **extra):
        """DeactivatePipelineRequest"""

        self._attrs = dict()
        if skip_savepoint is not None:
            self._attrs["skipSavepoint"] = skip_savepoint
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def skip_savepoint(self) -> "bool":
        """ Gets the skip_savepoint of this DeactivatePipelineRequest.
        Set to true to skip saving the state of a deactivated pipeline. When the pipeline is later activated, it will start with the newest data and skip any data that arrived after this deactivation, which can cause data loss. Defaults to false.
        """
        return self._attrs.get("skipSavepoint")

    @skip_savepoint.setter
    def skip_savepoint(self, skip_savepoint: "bool"):
        """Sets the skip_savepoint of this DeactivatePipelineRequest.

        Set to true to skip saving the state of a deactivated pipeline. When the pipeline is later activated, it will start with the newest data and skip any data that arrived after this deactivation, which can cause data loss. Defaults to false.

        :param skip_savepoint: The skip_savepoint of this DeactivatePipelineRequest.
        :type: bool
        """
        self._attrs["skipSavepoint"] = skip_savepoint

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DslCompilationRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DslCompilationRequest":
        instance = DslCompilationRequest.__new__(DslCompilationRequest)
        instance._attrs = model
        return instance

    def __init__(self, dsl: "str", **extra):
        """DslCompilationRequest"""

        self._attrs = dict()
        if dsl is not None:
            self._attrs["dsl"] = dsl
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def dsl(self) -> "str":
        """ Gets the dsl of this DslCompilationRequest.
        The Streams DSL representation of a pipeline.
        """
        return self._attrs.get("dsl")

    @dsl.setter
    def dsl(self, dsl: "str"):
        """Sets the dsl of this DslCompilationRequest.

        The Streams DSL representation of a pipeline.

        :param dsl: The dsl of this DslCompilationRequest.
        :type: str
        """
        if dsl is None:
            raise ValueError("Invalid value for `dsl`, must not be `None`")
        self._attrs["dsl"] = dsl

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplPipeline(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplPipeline":
        instance = UplPipeline.__new__(UplPipeline)
        instance._attrs = model
        return instance

    def __init__(self, edges: "List[UplEdge]", nodes: "List[UplNode]", root_node: "List[str]", migration_info: "PipelineMigrationInfo" = None, root_node_from_upl_pipeline: "List[str]" = None, **extra):
        """UplPipeline"""

        self._attrs = dict()
        if edges is not None:
            self._attrs["edges"] = edges
        if nodes is not None:
            self._attrs["nodes"] = nodes
        if root_node is not None:
            self._attrs["rootNode"] = root_node
        if migration_info is not None:
            self._attrs["migrationInfo"] = migration_info.to_dict()
        if root_node_from_upl_pipeline is not None:
            self._attrs["rootNodeFromUplPipeline"] = root_node_from_upl_pipeline
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def edges(self) -> "List[UplEdge]":
        """ Gets the edges of this UplPipeline.
        A list of links or connections between the output of one pipeline function and the input of another pipeline function
        """
        return [UplEdge._from_dict(i) for i in self._attrs.get("edges")]

    @edges.setter
    def edges(self, edges: "List[UplEdge]"):
        """Sets the edges of this UplPipeline.

        A list of links or connections between the output of one pipeline function and the input of another pipeline function

        :param edges: The edges of this UplPipeline.
        :type: List[UplEdge]
        """
        if edges is None:
            raise ValueError("Invalid value for `edges`, must not be `None`")
        self._attrs["edges"] = edges

    @property
    def nodes(self) -> "List[UplNode]":
        """ Gets the nodes of this UplPipeline.
        The functions (or nodes) in your entire pipeline, including each function's operations, attributes, and properties
        """
        return [UplNode._from_dict(i) for i in self._attrs.get("nodes")]

    @nodes.setter
    def nodes(self, nodes: "List[UplNode]"):
        """Sets the nodes of this UplPipeline.

        The functions (or nodes) in your entire pipeline, including each function's operations, attributes, and properties

        :param nodes: The nodes of this UplPipeline.
        :type: List[UplNode]
        """
        if nodes is None:
            raise ValueError("Invalid value for `nodes`, must not be `None`")
        self._attrs["nodes"] = nodes

    @property
    def root_node(self) -> "List[str]":
        """ Gets the root_node of this UplPipeline.
        The UUIDs of all sink functions in a given pipeline
        """
        return self._attrs.get("rootNode")

    @root_node.setter
    def root_node(self, root_node: "List[str]"):
        """Sets the root_node of this UplPipeline.

        The UUIDs of all sink functions in a given pipeline

        :param root_node: The root_node of this UplPipeline.
        :type: List[str]
        """
        if root_node is None:
            raise ValueError("Invalid value for `root_node`, must not be `None`")
        self._attrs["rootNode"] = root_node

    @property
    def migration_info(self) -> "PipelineMigrationInfo":
        """ Gets the migration_info of this UplPipeline.
        """
        return PipelineMigrationInfo._from_dict(self._attrs["migrationInfo"])

    @migration_info.setter
    def migration_info(self, migration_info: "PipelineMigrationInfo"):
        """Sets the migration_info of this UplPipeline.


        :param migration_info: The migration_info of this UplPipeline.
        :type: PipelineMigrationInfo
        """
        self._attrs["migrationInfo"] = migration_info.to_dict()

    @property
    def root_node_from_upl_pipeline(self) -> "List[str]":
        """ Gets the root_node_from_upl_pipeline of this UplPipeline.
        """
        return self._attrs.get("rootNodeFromUplPipeline")

    @root_node_from_upl_pipeline.setter
    def root_node_from_upl_pipeline(self, root_node_from_upl_pipeline: "List[str]"):
        """Sets the root_node_from_upl_pipeline of this UplPipeline.


        :param root_node_from_upl_pipeline: The root_node_from_upl_pipeline of this UplPipeline.
        :type: List[str]
        """
        self._attrs["rootNodeFromUplPipeline"] = root_node_from_upl_pipeline

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplEdge(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplEdge":
        instance = UplEdge.__new__(UplEdge)
        instance._attrs = model
        return instance

    def __init__(self, source_node: "str", source_port: "str", target_node: "str", target_port: "str", attributes: "object" = None, **extra):
        """UplEdge"""

        self._attrs = dict()
        if source_node is not None:
            self._attrs["sourceNode"] = source_node
        if source_port is not None:
            self._attrs["sourcePort"] = source_port
        if target_node is not None:
            self._attrs["targetNode"] = target_node
        if target_port is not None:
            self._attrs["targetPort"] = target_port
        if attributes is not None:
            self._attrs["attributes"] = attributes
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def source_node(self) -> "str":
        """ Gets the source_node of this UplEdge.
        The source function's (node's) id
        """
        return self._attrs.get("sourceNode")

    @source_node.setter
    def source_node(self, source_node: "str"):
        """Sets the source_node of this UplEdge.

        The source function's (node's) id

        :param source_node: The source_node of this UplEdge.
        :type: str
        """
        if source_node is None:
            raise ValueError("Invalid value for `source_node`, must not be `None`")
        self._attrs["sourceNode"] = source_node

    @property
    def source_port(self) -> "str":
        """ Gets the source_port of this UplEdge.
        The source function's (node's) port
        """
        return self._attrs.get("sourcePort")

    @source_port.setter
    def source_port(self, source_port: "str"):
        """Sets the source_port of this UplEdge.

        The source function's (node's) port

        :param source_port: The source_port of this UplEdge.
        :type: str
        """
        if source_port is None:
            raise ValueError("Invalid value for `source_port`, must not be `None`")
        self._attrs["sourcePort"] = source_port

    @property
    def target_node(self) -> "str":
        """ Gets the target_node of this UplEdge.
        The target function's (node's) id
        """
        return self._attrs.get("targetNode")

    @target_node.setter
    def target_node(self, target_node: "str"):
        """Sets the target_node of this UplEdge.

        The target function's (node's) id

        :param target_node: The target_node of this UplEdge.
        :type: str
        """
        if target_node is None:
            raise ValueError("Invalid value for `target_node`, must not be `None`")
        self._attrs["targetNode"] = target_node

    @property
    def target_port(self) -> "str":
        """ Gets the target_port of this UplEdge.
        The target function's (node's) port
        """
        return self._attrs.get("targetPort")

    @target_port.setter
    def target_port(self, target_port: "str"):
        """Sets the target_port of this UplEdge.

        The target function's (node's) port

        :param target_port: The target_port of this UplEdge.
        :type: str
        """
        if target_port is None:
            raise ValueError("Invalid value for `target_port`, must not be `None`")
        self._attrs["targetPort"] = target_port

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this UplEdge.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this UplEdge.


        :param attributes: The attributes of this UplEdge.
        :type: object
        """
        self._attrs["attributes"] = attributes

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplNode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplNode":
        instance = UplNode.__new__(UplNode)
        instance._attrs = model
        return instance

    def __init__(self, id: "str", op: "str", attributes: "object" = None, resolved_id: "str" = None, **extra):
        """UplNode"""

        self._attrs = dict()
        if id is not None:
            self._attrs["id"] = id
        if op is not None:
            self._attrs["op"] = op
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if resolved_id is not None:
            self._attrs["resolvedId"] = resolved_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def id(self) -> "str":
        """ Gets the id of this UplNode.
        The function's (node's) UUID
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this UplNode.

        The function's (node's) UUID

        :param id: The id of this UplNode.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def op(self) -> "str":
        """ Gets the op of this UplNode.
        The function's ID or its API name
        """
        return self._attrs.get("op")

    @op.setter
    def op(self, op: "str"):
        """Sets the op of this UplNode.

        The function's ID or its API name

        :param op: The op of this UplNode.
        :type: str
        """
        if op is None:
            raise ValueError("Invalid value for `op`, must not be `None`")
        self._attrs["op"] = op

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this UplNode.
        Optional key-value pair for a function (node)
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this UplNode.

        Optional key-value pair for a function (node)

        :param attributes: The attributes of this UplNode.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def resolved_id(self) -> "str":
        """ Gets the resolved_id of this UplNode.
        """
        return self._attrs.get("resolvedId")

    @resolved_id.setter
    def resolved_id(self, resolved_id: "str"):
        """Sets the resolved_id of this UplNode.


        :param resolved_id: The resolved_id of this UplNode.
        :type: str
        """
        self._attrs["resolvedId"] = resolved_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineMigrationInfo(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineMigrationInfo":
        instance = PipelineMigrationInfo.__new__(PipelineMigrationInfo)
        instance._attrs = model
        return instance

    def __init__(self, can_migrate: "bool" = None, create_api_version: "int" = None, target_api_version: "int" = None, **extra):
        """PipelineMigrationInfo"""

        self._attrs = dict()
        if can_migrate is not None:
            self._attrs["canMigrate"] = can_migrate
        if create_api_version is not None:
            self._attrs["createApiVersion"] = create_api_version
        if target_api_version is not None:
            self._attrs["targetApiVersion"] = target_api_version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def can_migrate(self) -> "bool":
        """ Gets the can_migrate of this PipelineMigrationInfo.
        """
        return self._attrs.get("canMigrate")

    @can_migrate.setter
    def can_migrate(self, can_migrate: "bool"):
        """Sets the can_migrate of this PipelineMigrationInfo.


        :param can_migrate: The can_migrate of this PipelineMigrationInfo.
        :type: bool
        """
        self._attrs["canMigrate"] = can_migrate

    @property
    def create_api_version(self) -> "int":
        """ Gets the create_api_version of this PipelineMigrationInfo.
        """
        return self._attrs.get("createApiVersion")

    @create_api_version.setter
    def create_api_version(self, create_api_version: "int"):
        """Sets the create_api_version of this PipelineMigrationInfo.


        :param create_api_version: The create_api_version of this PipelineMigrationInfo.
        :type: int
        """
        self._attrs["createApiVersion"] = create_api_version

    @property
    def target_api_version(self) -> "int":
        """ Gets the target_api_version of this PipelineMigrationInfo.
        """
        return self._attrs.get("targetApiVersion")

    @target_api_version.setter
    def target_api_version(self, target_api_version: "int"):
        """Sets the target_api_version of this PipelineMigrationInfo.


        :param target_api_version: The target_api_version of this PipelineMigrationInfo.
        :type: int
        """
        self._attrs["targetApiVersion"] = target_api_version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GetInputSchemaRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GetInputSchemaRequest":
        instance = GetInputSchemaRequest.__new__(GetInputSchemaRequest)
        instance._attrs = model
        return instance

    def __init__(self, node_uuid: "str", target_port_name: "str", upl_json: "UplPipeline", **extra):
        """GetInputSchemaRequest"""

        self._attrs = dict()
        if node_uuid is not None:
            self._attrs["nodeUuid"] = node_uuid
        if target_port_name is not None:
            self._attrs["targetPortName"] = target_port_name
        if upl_json is not None:
            self._attrs["uplJson"] = upl_json.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def node_uuid(self) -> "str":
        """ Gets the node_uuid of this GetInputSchemaRequest.
        The function ID.
        """
        return self._attrs.get("nodeUuid")

    @node_uuid.setter
    def node_uuid(self, node_uuid: "str"):
        """Sets the node_uuid of this GetInputSchemaRequest.

        The function ID.

        :param node_uuid: The node_uuid of this GetInputSchemaRequest.
        :type: str
        """
        if node_uuid is None:
            raise ValueError("Invalid value for `node_uuid`, must not be `None`")
        self._attrs["nodeUuid"] = node_uuid

    @property
    def target_port_name(self) -> "str":
        """ Gets the target_port_name of this GetInputSchemaRequest.
        The name of the input port.
        """
        return self._attrs.get("targetPortName")

    @target_port_name.setter
    def target_port_name(self, target_port_name: "str"):
        """Sets the target_port_name of this GetInputSchemaRequest.

        The name of the input port.

        :param target_port_name: The target_port_name of this GetInputSchemaRequest.
        :type: str
        """
        if target_port_name is None:
            raise ValueError("Invalid value for `target_port_name`, must not be `None`")
        self._attrs["targetPortName"] = target_port_name

    @property
    def upl_json(self) -> "UplPipeline":
        """ Gets the upl_json of this GetInputSchemaRequest.
        """
        return UplPipeline._from_dict(self._attrs["uplJson"])

    @upl_json.setter
    def upl_json(self, upl_json: "UplPipeline"):
        """Sets the upl_json of this GetInputSchemaRequest.


        :param upl_json: The upl_json of this GetInputSchemaRequest.
        :type: UplPipeline
        """
        if upl_json is None:
            raise ValueError("Invalid value for `upl_json`, must not be `None`")
        self._attrs["uplJson"] = upl_json.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GetOutputSchemaRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GetOutputSchemaRequest":
        instance = GetOutputSchemaRequest.__new__(GetOutputSchemaRequest)
        instance._attrs = model
        return instance

    def __init__(self, upl_json: "UplPipeline", node_uuid: "str" = None, source_port_name: "str" = None, **extra):
        """GetOutputSchemaRequest"""

        self._attrs = dict()
        if upl_json is not None:
            self._attrs["uplJson"] = upl_json.to_dict()
        if node_uuid is not None:
            self._attrs["nodeUuid"] = node_uuid
        if source_port_name is not None:
            self._attrs["sourcePortName"] = source_port_name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def upl_json(self) -> "UplPipeline":
        """ Gets the upl_json of this GetOutputSchemaRequest.
        """
        return UplPipeline._from_dict(self._attrs["uplJson"])

    @upl_json.setter
    def upl_json(self, upl_json: "UplPipeline"):
        """Sets the upl_json of this GetOutputSchemaRequest.


        :param upl_json: The upl_json of this GetOutputSchemaRequest.
        :type: UplPipeline
        """
        if upl_json is None:
            raise ValueError("Invalid value for `upl_json`, must not be `None`")
        self._attrs["uplJson"] = upl_json.to_dict()

    @property
    def node_uuid(self) -> "str":
        """ Gets the node_uuid of this GetOutputSchemaRequest.
        The function ID. If omitted, returns the output schema for all functions.
        """
        return self._attrs.get("nodeUuid")

    @node_uuid.setter
    def node_uuid(self, node_uuid: "str"):
        """Sets the node_uuid of this GetOutputSchemaRequest.

        The function ID. If omitted, returns the output schema for all functions.

        :param node_uuid: The node_uuid of this GetOutputSchemaRequest.
        :type: str
        """
        self._attrs["nodeUuid"] = node_uuid

    @property
    def source_port_name(self) -> "str":
        """ Gets the source_port_name of this GetOutputSchemaRequest.
        The name of the output port. Deprecated.
        """
        return self._attrs.get("sourcePortName")

    @source_port_name.setter
    def source_port_name(self, source_port_name: "str"):
        """Sets the source_port_name of this GetOutputSchemaRequest.

        The name of the output port. Deprecated.

        :param source_port_name: The source_port_name of this GetOutputSchemaRequest.
        :type: str
        """
        self._attrs["sourcePortName"] = source_port_name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupArgumentsNode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupArgumentsNode":
        instance = GroupArgumentsNode.__new__(GroupArgumentsNode)
        instance._attrs = model
        return instance

    def __init__(self, group_arg: "str", position: "int", type: "str", **extra):
        """GroupArgumentsNode"""

        self._attrs = dict()
        if group_arg is not None:
            self._attrs["groupArg"] = group_arg
        if position is not None:
            self._attrs["position"] = position
        if type is not None:
            self._attrs["type"] = type
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def group_arg(self) -> "str":
        """ Gets the group_arg of this GroupArgumentsNode.
        The argument name for your group function.
        """
        return self._attrs.get("groupArg")

    @group_arg.setter
    def group_arg(self, group_arg: "str"):
        """Sets the group_arg of this GroupArgumentsNode.

        The argument name for your group function.

        :param group_arg: The group_arg of this GroupArgumentsNode.
        :type: str
        """
        if group_arg is None:
            raise ValueError("Invalid value for `group_arg`, must not be `None`")
        self._attrs["groupArg"] = group_arg

    @property
    def position(self) -> "int":
        """ Gets the position of this GroupArgumentsNode.
        Group function argument position number.
        """
        return self._attrs.get("position")

    @position.setter
    def position(self, position: "int"):
        """Sets the position of this GroupArgumentsNode.

        Group function argument position number.

        :param position: The position of this GroupArgumentsNode.
        :type: int
        """
        if position is None:
            raise ValueError("Invalid value for `position`, must not be `None`")
        self._attrs["position"] = position

    @property
    def type(self) -> "str":
        """ Gets the type of this GroupArgumentsNode.
        The group function's data type.
        """
        return self._attrs.get("type")

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this GroupArgumentsNode.

        The group function's data type.

        :param type: The type of this GroupArgumentsNode.
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")
        self._attrs["type"] = type

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupExpandRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupExpandRequest":
        instance = GroupExpandRequest.__new__(GroupExpandRequest)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "object", id: "str", **extra):
        """GroupExpandRequest"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if id is not None:
            self._attrs["id"] = id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "dict":
        """ Gets the arguments of this GroupExpandRequest.
        Function arguments for the given id. Overrides default values.
        """
        return self._attrs.get("arguments")

    @arguments.setter
    def arguments(self, arguments: "dict"):
        """Sets the arguments of this GroupExpandRequest.

        Function arguments for the given id. Overrides default values.

        :param arguments: The arguments of this GroupExpandRequest.
        :type: object
        """
        if arguments is None:
            raise ValueError("Invalid value for `arguments`, must not be `None`")
        self._attrs["arguments"] = arguments

    @property
    def id(self) -> "str":
        """ Gets the id of this GroupExpandRequest.
        The ID associated with your group function in the pipeline Streams JSON
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this GroupExpandRequest.

        The ID associated with your group function in the pipeline Streams JSON

        :param id: The id of this GroupExpandRequest.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupFunctionArgsNode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupFunctionArgsNode":
        instance = GroupFunctionArgsNode.__new__(GroupFunctionArgsNode)
        instance._attrs = model
        return instance

    def __init__(self, function_arg: "str", group_arg: "str", **extra):
        """GroupFunctionArgsNode"""

        self._attrs = dict()
        if function_arg is not None:
            self._attrs["functionArg"] = function_arg
        if group_arg is not None:
            self._attrs["groupArg"] = group_arg
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def function_arg(self) -> "str":
        """ Gets the function_arg of this GroupFunctionArgsNode.
        Function argument name.
        """
        return self._attrs.get("functionArg")

    @function_arg.setter
    def function_arg(self, function_arg: "str"):
        """Sets the function_arg of this GroupFunctionArgsNode.

        Function argument name.

        :param function_arg: The function_arg of this GroupFunctionArgsNode.
        :type: str
        """
        if function_arg is None:
            raise ValueError("Invalid value for `function_arg`, must not be `None`")
        self._attrs["functionArg"] = function_arg

    @property
    def group_arg(self) -> "str":
        """ Gets the group_arg of this GroupFunctionArgsNode.
        The argument name for your group function.
        """
        return self._attrs.get("groupArg")

    @group_arg.setter
    def group_arg(self, group_arg: "str"):
        """Sets the group_arg of this GroupFunctionArgsNode.

        The argument name for your group function.

        :param group_arg: The group_arg of this GroupFunctionArgsNode.
        :type: str
        """
        if group_arg is None:
            raise ValueError("Invalid value for `group_arg`, must not be `None`")
        self._attrs["groupArg"] = group_arg

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupFunctionArgsMappingNode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupFunctionArgsMappingNode":
        instance = GroupFunctionArgsMappingNode.__new__(GroupFunctionArgsMappingNode)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "List[GroupFunctionArgsNode]", function_id: "str", **extra):
        """GroupFunctionArgsMappingNode"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if function_id is not None:
            self._attrs["functionId"] = function_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "List[GroupFunctionArgsNode]":
        """ Gets the arguments of this GroupFunctionArgsMappingNode.
        List of mappings from group function argument to function argument.
        """
        return [GroupFunctionArgsNode._from_dict(i) for i in self._attrs.get("arguments")]

    @arguments.setter
    def arguments(self, arguments: "List[GroupFunctionArgsNode]"):
        """Sets the arguments of this GroupFunctionArgsMappingNode.

        List of mappings from group function argument to function argument.

        :param arguments: The arguments of this GroupFunctionArgsMappingNode.
        :type: List[GroupFunctionArgsNode]
        """
        if arguments is None:
            raise ValueError("Invalid value for `arguments`, must not be `None`")
        self._attrs["arguments"] = arguments

    @property
    def function_id(self) -> "str":
        """ Gets the function_id of this GroupFunctionArgsMappingNode.
        The function id to map to a group function argument.
        """
        return self._attrs.get("functionId")

    @function_id.setter
    def function_id(self, function_id: "str"):
        """Sets the function_id of this GroupFunctionArgsMappingNode.

        The function id to map to a group function argument.

        :param function_id: The function_id of this GroupFunctionArgsMappingNode.
        :type: str
        """
        if function_id is None:
            raise ValueError("Invalid value for `function_id`, must not be `None`")
        self._attrs["functionId"] = function_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupFunctionArguments(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupFunctionArguments":
        instance = GroupFunctionArguments.__new__(GroupFunctionArguments)
        instance._attrs = model
        return instance

    def __init__(self, names: "List[str]" = None, ordered_names: "List[str]" = None, positions: "Dict[str, int]" = None, **extra):
        """GroupFunctionArguments"""

        self._attrs = dict()
        if names is not None:
            self._attrs["names"] = names
        if ordered_names is not None:
            self._attrs["orderedNames"] = ordered_names
        if positions is not None:
            self._attrs["positions"] = positions
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def names(self) -> "List[str]":
        """ Gets the names of this GroupFunctionArguments.
        """
        return self._attrs.get("names")

    @names.setter
    def names(self, names: "List[str]"):
        """Sets the names of this GroupFunctionArguments.


        :param names: The names of this GroupFunctionArguments.
        :type: List[str]
        """
        self._attrs["names"] = names

    @property
    def ordered_names(self) -> "List[str]":
        """ Gets the ordered_names of this GroupFunctionArguments.
        """
        return self._attrs.get("orderedNames")

    @ordered_names.setter
    def ordered_names(self, ordered_names: "List[str]"):
        """Sets the ordered_names of this GroupFunctionArguments.


        :param ordered_names: The ordered_names of this GroupFunctionArguments.
        :type: List[str]
        """
        self._attrs["orderedNames"] = ordered_names

    @property
    def positions(self) -> "Dict[str, int]":
        """ Gets the positions of this GroupFunctionArguments.
        """
        return self._attrs.get("positions")

    @positions.setter
    def positions(self, positions: "Dict[str, int]"):
        """Sets the positions of this GroupFunctionArguments.


        :param positions: The positions of this GroupFunctionArguments.
        :type: Dict[str, int]
        """
        self._attrs["positions"] = positions

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupFunctionMappings(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupFunctionMappings":
        instance = GroupFunctionMappings.__new__(GroupFunctionMappings)
        instance._attrs = model
        return instance

    def __init__(self, mappings: "Dict[str, Dict[str, str]]" = None, **extra):
        """GroupFunctionMappings"""

        self._attrs = dict()
        if mappings is not None:
            self._attrs["mappings"] = mappings
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def mappings(self) -> "Dict[str, Dict[str, str]]":
        """ Gets the mappings of this GroupFunctionMappings.
        """
        return self._attrs.get("mappings")

    @mappings.setter
    def mappings(self, mappings: "Dict[str, Dict[str, str]]"):
        """Sets the mappings of this GroupFunctionMappings.


        :param mappings: The mappings of this GroupFunctionMappings.
        :type: Dict[str, Dict[str, str]]
        """
        self._attrs["mappings"] = mappings

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupPatchRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupPatchRequest":
        instance = GroupPatchRequest.__new__(GroupPatchRequest)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "List[GroupArgumentsNode]" = None, ast: "UplPipeline" = None, attributes: "object" = None, categories: "List[int]" = None, group_function_arguments: "GroupFunctionArguments" = None, group_function_mappings: "GroupFunctionMappings" = None, mappings: "List[GroupFunctionArgsMappingNode]" = None, name: "str" = None, output_type: "str" = None, scalar: "bool" = None, variadic: "bool" = None, **extra):
        """GroupPatchRequest"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if ast is not None:
            self._attrs["ast"] = ast.to_dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if categories is not None:
            self._attrs["categories"] = categories
        if group_function_arguments is not None:
            self._attrs["groupFunctionArguments"] = group_function_arguments.to_dict()
        if group_function_mappings is not None:
            self._attrs["groupFunctionMappings"] = group_function_mappings.to_dict()
        if mappings is not None:
            self._attrs["mappings"] = mappings
        if name is not None:
            self._attrs["name"] = name
        if output_type is not None:
            self._attrs["outputType"] = output_type
        if scalar is not None:
            self._attrs["scalar"] = scalar
        if variadic is not None:
            self._attrs["variadic"] = variadic
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "List[GroupArgumentsNode]":
        """ Gets the arguments of this GroupPatchRequest.
        Group function arguments list.
        """
        return [GroupArgumentsNode._from_dict(i) for i in self._attrs.get("arguments")]

    @arguments.setter
    def arguments(self, arguments: "List[GroupArgumentsNode]"):
        """Sets the arguments of this GroupPatchRequest.

        Group function arguments list.

        :param arguments: The arguments of this GroupPatchRequest.
        :type: List[GroupArgumentsNode]
        """
        self._attrs["arguments"] = arguments

    @property
    def ast(self) -> "UplPipeline":
        """ Gets the ast of this GroupPatchRequest.
        """
        return UplPipeline._from_dict(self._attrs["ast"])

    @ast.setter
    def ast(self, ast: "UplPipeline"):
        """Sets the ast of this GroupPatchRequest.


        :param ast: The ast of this GroupPatchRequest.
        :type: UplPipeline
        """
        self._attrs["ast"] = ast.to_dict()

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this GroupPatchRequest.
        Attributes map for function.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this GroupPatchRequest.

        Attributes map for function.

        :param attributes: The attributes of this GroupPatchRequest.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def categories(self) -> "List[int]":
        """ Gets the categories of this GroupPatchRequest.
        Categories for this function.
        """
        return self._attrs.get("categories")

    @categories.setter
    def categories(self, categories: "List[int]"):
        """Sets the categories of this GroupPatchRequest.

        Categories for this function.

        :param categories: The categories of this GroupPatchRequest.
        :type: List[int]
        """
        self._attrs["categories"] = categories

    @property
    def group_function_arguments(self) -> "GroupFunctionArguments":
        """ Gets the group_function_arguments of this GroupPatchRequest.
        """
        return GroupFunctionArguments._from_dict(self._attrs["groupFunctionArguments"])

    @group_function_arguments.setter
    def group_function_arguments(self, group_function_arguments: "GroupFunctionArguments"):
        """Sets the group_function_arguments of this GroupPatchRequest.


        :param group_function_arguments: The group_function_arguments of this GroupPatchRequest.
        :type: GroupFunctionArguments
        """
        self._attrs["groupFunctionArguments"] = group_function_arguments.to_dict()

    @property
    def group_function_mappings(self) -> "GroupFunctionMappings":
        """ Gets the group_function_mappings of this GroupPatchRequest.
        """
        return GroupFunctionMappings._from_dict(self._attrs["groupFunctionMappings"])

    @group_function_mappings.setter
    def group_function_mappings(self, group_function_mappings: "GroupFunctionMappings"):
        """Sets the group_function_mappings of this GroupPatchRequest.


        :param group_function_mappings: The group_function_mappings of this GroupPatchRequest.
        :type: GroupFunctionMappings
        """
        self._attrs["groupFunctionMappings"] = group_function_mappings.to_dict()

    @property
    def mappings(self) -> "List[GroupFunctionArgsMappingNode]":
        """ Gets the mappings of this GroupPatchRequest.
        Group function mappings list.
        """
        return [GroupFunctionArgsMappingNode._from_dict(i) for i in self._attrs.get("mappings")]

    @mappings.setter
    def mappings(self, mappings: "List[GroupFunctionArgsMappingNode]"):
        """Sets the mappings of this GroupPatchRequest.

        Group function mappings list.

        :param mappings: The mappings of this GroupPatchRequest.
        :type: List[GroupFunctionArgsMappingNode]
        """
        self._attrs["mappings"] = mappings

    @property
    def name(self) -> "str":
        """ Gets the name of this GroupPatchRequest.
        The name for the group function.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this GroupPatchRequest.

        The name for the group function.

        :param name: The name of this GroupPatchRequest.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def output_type(self) -> "str":
        """ Gets the output_type of this GroupPatchRequest.
        The data type of the output of your function.
        """
        return self._attrs.get("outputType")

    @output_type.setter
    def output_type(self, output_type: "str"):
        """Sets the output_type of this GroupPatchRequest.

        The data type of the output of your function.

        :param output_type: The output_type of this GroupPatchRequest.
        :type: str
        """
        self._attrs["outputType"] = output_type

    @property
    def scalar(self) -> "bool":
        """ Gets the scalar of this GroupPatchRequest.
        """
        return self._attrs.get("scalar")

    @scalar.setter
    def scalar(self, scalar: "bool"):
        """Sets the scalar of this GroupPatchRequest.


        :param scalar: The scalar of this GroupPatchRequest.
        :type: bool
        """
        self._attrs["scalar"] = scalar

    @property
    def variadic(self) -> "bool":
        """ Gets the variadic of this GroupPatchRequest.
        """
        return self._attrs.get("variadic")

    @variadic.setter
    def variadic(self, variadic: "bool"):
        """Sets the variadic of this GroupPatchRequest.


        :param variadic: The variadic of this GroupPatchRequest.
        :type: bool
        """
        self._attrs["variadic"] = variadic

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupPutRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupPutRequest":
        instance = GroupPutRequest.__new__(GroupPutRequest)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "List[GroupArgumentsNode]", ast: "UplPipeline", attributes: "object", categories: "List[int]", mappings: "List[GroupFunctionArgsMappingNode]", name: "str", output_type: "str", group_function_arguments: "GroupFunctionArguments" = None, group_function_mappings: "GroupFunctionMappings" = None, scalar: "bool" = None, variadic: "bool" = None, **extra):
        """GroupPutRequest"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if ast is not None:
            self._attrs["ast"] = ast.to_dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if categories is not None:
            self._attrs["categories"] = categories
        if mappings is not None:
            self._attrs["mappings"] = mappings
        if name is not None:
            self._attrs["name"] = name
        if output_type is not None:
            self._attrs["outputType"] = output_type
        if group_function_arguments is not None:
            self._attrs["groupFunctionArguments"] = group_function_arguments.to_dict()
        if group_function_mappings is not None:
            self._attrs["groupFunctionMappings"] = group_function_mappings.to_dict()
        if scalar is not None:
            self._attrs["scalar"] = scalar
        if variadic is not None:
            self._attrs["variadic"] = variadic
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "List[GroupArgumentsNode]":
        """ Gets the arguments of this GroupPutRequest.
        The group function arguments list.
        """
        return [GroupArgumentsNode._from_dict(i) for i in self._attrs.get("arguments")]

    @arguments.setter
    def arguments(self, arguments: "List[GroupArgumentsNode]"):
        """Sets the arguments of this GroupPutRequest.

        The group function arguments list.

        :param arguments: The arguments of this GroupPutRequest.
        :type: List[GroupArgumentsNode]
        """
        if arguments is None:
            raise ValueError("Invalid value for `arguments`, must not be `None`")
        self._attrs["arguments"] = arguments

    @property
    def ast(self) -> "UplPipeline":
        """ Gets the ast of this GroupPutRequest.
        """
        return UplPipeline._from_dict(self._attrs["ast"])

    @ast.setter
    def ast(self, ast: "UplPipeline"):
        """Sets the ast of this GroupPutRequest.


        :param ast: The ast of this GroupPutRequest.
        :type: UplPipeline
        """
        if ast is None:
            raise ValueError("Invalid value for `ast`, must not be `None`")
        self._attrs["ast"] = ast.to_dict()

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this GroupPutRequest.
        The attributes map for function.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this GroupPutRequest.

        The attributes map for function.

        :param attributes: The attributes of this GroupPutRequest.
        :type: object
        """
        if attributes is None:
            raise ValueError("Invalid value for `attributes`, must not be `None`")
        self._attrs["attributes"] = attributes

    @property
    def categories(self) -> "List[int]":
        """ Gets the categories of this GroupPutRequest.
        The categories for this function.
        """
        return self._attrs.get("categories")

    @categories.setter
    def categories(self, categories: "List[int]"):
        """Sets the categories of this GroupPutRequest.

        The categories for this function.

        :param categories: The categories of this GroupPutRequest.
        :type: List[int]
        """
        if categories is None:
            raise ValueError("Invalid value for `categories`, must not be `None`")
        self._attrs["categories"] = categories

    @property
    def mappings(self) -> "List[GroupFunctionArgsMappingNode]":
        """ Gets the mappings of this GroupPutRequest.
        The group function mappings list.
        """
        return [GroupFunctionArgsMappingNode._from_dict(i) for i in self._attrs.get("mappings")]

    @mappings.setter
    def mappings(self, mappings: "List[GroupFunctionArgsMappingNode]"):
        """Sets the mappings of this GroupPutRequest.

        The group function mappings list.

        :param mappings: The mappings of this GroupPutRequest.
        :type: List[GroupFunctionArgsMappingNode]
        """
        if mappings is None:
            raise ValueError("Invalid value for `mappings`, must not be `None`")
        self._attrs["mappings"] = mappings

    @property
    def name(self) -> "str":
        """ Gets the name of this GroupPutRequest.
        The group function name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this GroupPutRequest.

        The group function name.

        :param name: The name of this GroupPutRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def output_type(self) -> "str":
        """ Gets the output_type of this GroupPutRequest.
        The data type of the function's output.
        """
        return self._attrs.get("outputType")

    @output_type.setter
    def output_type(self, output_type: "str"):
        """Sets the output_type of this GroupPutRequest.

        The data type of the function's output.

        :param output_type: The output_type of this GroupPutRequest.
        :type: str
        """
        if output_type is None:
            raise ValueError("Invalid value for `output_type`, must not be `None`")
        self._attrs["outputType"] = output_type

    @property
    def group_function_arguments(self) -> "GroupFunctionArguments":
        """ Gets the group_function_arguments of this GroupPutRequest.
        """
        return GroupFunctionArguments._from_dict(self._attrs["groupFunctionArguments"])

    @group_function_arguments.setter
    def group_function_arguments(self, group_function_arguments: "GroupFunctionArguments"):
        """Sets the group_function_arguments of this GroupPutRequest.


        :param group_function_arguments: The group_function_arguments of this GroupPutRequest.
        :type: GroupFunctionArguments
        """
        self._attrs["groupFunctionArguments"] = group_function_arguments.to_dict()

    @property
    def group_function_mappings(self) -> "GroupFunctionMappings":
        """ Gets the group_function_mappings of this GroupPutRequest.
        """
        return GroupFunctionMappings._from_dict(self._attrs["groupFunctionMappings"])

    @group_function_mappings.setter
    def group_function_mappings(self, group_function_mappings: "GroupFunctionMappings"):
        """Sets the group_function_mappings of this GroupPutRequest.


        :param group_function_mappings: The group_function_mappings of this GroupPutRequest.
        :type: GroupFunctionMappings
        """
        self._attrs["groupFunctionMappings"] = group_function_mappings.to_dict()

    @property
    def scalar(self) -> "bool":
        """ Gets the scalar of this GroupPutRequest.
        """
        return self._attrs.get("scalar")

    @scalar.setter
    def scalar(self, scalar: "bool"):
        """Sets the scalar of this GroupPutRequest.


        :param scalar: The scalar of this GroupPutRequest.
        :type: bool
        """
        self._attrs["scalar"] = scalar

    @property
    def variadic(self) -> "bool":
        """ Gets the variadic of this GroupPutRequest.
        """
        return self._attrs.get("variadic")

    @variadic.setter
    def variadic(self, variadic: "bool"):
        """Sets the variadic of this GroupPutRequest.


        :param variadic: The variadic of this GroupPutRequest.
        :type: bool
        """
        self._attrs["variadic"] = variadic

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupRequest":
        instance = GroupRequest.__new__(GroupRequest)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "List[GroupArgumentsNode]", ast: "UplPipeline", attributes: "object", categories: "List[int]", mappings: "List[GroupFunctionArgsMappingNode]", name: "str", output_type: "str", group_function_arguments: "GroupFunctionArguments" = None, group_function_mappings: "GroupFunctionMappings" = None, scalar: "bool" = None, variadic: "bool" = None, **extra):
        """GroupRequest"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if ast is not None:
            self._attrs["ast"] = ast.to_dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if categories is not None:
            self._attrs["categories"] = categories
        if mappings is not None:
            self._attrs["mappings"] = mappings
        if name is not None:
            self._attrs["name"] = name
        if output_type is not None:
            self._attrs["outputType"] = output_type
        if group_function_arguments is not None:
            self._attrs["groupFunctionArguments"] = group_function_arguments.to_dict()
        if group_function_mappings is not None:
            self._attrs["groupFunctionMappings"] = group_function_mappings.to_dict()
        if scalar is not None:
            self._attrs["scalar"] = scalar
        if variadic is not None:
            self._attrs["variadic"] = variadic
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "List[GroupArgumentsNode]":
        """ Gets the arguments of this GroupRequest.
        The group function arguments list.
        """
        return [GroupArgumentsNode._from_dict(i) for i in self._attrs.get("arguments")]

    @arguments.setter
    def arguments(self, arguments: "List[GroupArgumentsNode]"):
        """Sets the arguments of this GroupRequest.

        The group function arguments list.

        :param arguments: The arguments of this GroupRequest.
        :type: List[GroupArgumentsNode]
        """
        if arguments is None:
            raise ValueError("Invalid value for `arguments`, must not be `None`")
        self._attrs["arguments"] = arguments

    @property
    def ast(self) -> "UplPipeline":
        """ Gets the ast of this GroupRequest.
        """
        return UplPipeline._from_dict(self._attrs["ast"])

    @ast.setter
    def ast(self, ast: "UplPipeline"):
        """Sets the ast of this GroupRequest.


        :param ast: The ast of this GroupRequest.
        :type: UplPipeline
        """
        if ast is None:
            raise ValueError("Invalid value for `ast`, must not be `None`")
        self._attrs["ast"] = ast.to_dict()

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this GroupRequest.
        The attributes map for function.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this GroupRequest.

        The attributes map for function.

        :param attributes: The attributes of this GroupRequest.
        :type: object
        """
        if attributes is None:
            raise ValueError("Invalid value for `attributes`, must not be `None`")
        self._attrs["attributes"] = attributes

    @property
    def categories(self) -> "List[int]":
        """ Gets the categories of this GroupRequest.
        The categories for this function.
        """
        return self._attrs.get("categories")

    @categories.setter
    def categories(self, categories: "List[int]"):
        """Sets the categories of this GroupRequest.

        The categories for this function.

        :param categories: The categories of this GroupRequest.
        :type: List[int]
        """
        if categories is None:
            raise ValueError("Invalid value for `categories`, must not be `None`")
        self._attrs["categories"] = categories

    @property
    def mappings(self) -> "List[GroupFunctionArgsMappingNode]":
        """ Gets the mappings of this GroupRequest.
        The group function mappings list.
        """
        return [GroupFunctionArgsMappingNode._from_dict(i) for i in self._attrs.get("mappings")]

    @mappings.setter
    def mappings(self, mappings: "List[GroupFunctionArgsMappingNode]"):
        """Sets the mappings of this GroupRequest.

        The group function mappings list.

        :param mappings: The mappings of this GroupRequest.
        :type: List[GroupFunctionArgsMappingNode]
        """
        if mappings is None:
            raise ValueError("Invalid value for `mappings`, must not be `None`")
        self._attrs["mappings"] = mappings

    @property
    def name(self) -> "str":
        """ Gets the name of this GroupRequest.
        The group function name.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this GroupRequest.

        The group function name.

        :param name: The name of this GroupRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def output_type(self) -> "str":
        """ Gets the output_type of this GroupRequest.
        The data type of the function's output.
        """
        return self._attrs.get("outputType")

    @output_type.setter
    def output_type(self, output_type: "str"):
        """Sets the output_type of this GroupRequest.

        The data type of the function's output.

        :param output_type: The output_type of this GroupRequest.
        :type: str
        """
        if output_type is None:
            raise ValueError("Invalid value for `output_type`, must not be `None`")
        self._attrs["outputType"] = output_type

    @property
    def group_function_arguments(self) -> "GroupFunctionArguments":
        """ Gets the group_function_arguments of this GroupRequest.
        """
        return GroupFunctionArguments._from_dict(self._attrs["groupFunctionArguments"])

    @group_function_arguments.setter
    def group_function_arguments(self, group_function_arguments: "GroupFunctionArguments"):
        """Sets the group_function_arguments of this GroupRequest.


        :param group_function_arguments: The group_function_arguments of this GroupRequest.
        :type: GroupFunctionArguments
        """
        self._attrs["groupFunctionArguments"] = group_function_arguments.to_dict()

    @property
    def group_function_mappings(self) -> "GroupFunctionMappings":
        """ Gets the group_function_mappings of this GroupRequest.
        """
        return GroupFunctionMappings._from_dict(self._attrs["groupFunctionMappings"])

    @group_function_mappings.setter
    def group_function_mappings(self, group_function_mappings: "GroupFunctionMappings"):
        """Sets the group_function_mappings of this GroupRequest.


        :param group_function_mappings: The group_function_mappings of this GroupRequest.
        :type: GroupFunctionMappings
        """
        self._attrs["groupFunctionMappings"] = group_function_mappings.to_dict()

    @property
    def scalar(self) -> "bool":
        """ Gets the scalar of this GroupRequest.
        """
        return self._attrs.get("scalar")

    @scalar.setter
    def scalar(self, scalar: "bool"):
        """Sets the scalar of this GroupRequest.


        :param scalar: The scalar of this GroupRequest.
        :type: bool
        """
        self._attrs["scalar"] = scalar

    @property
    def variadic(self) -> "bool":
        """ Gets the variadic of this GroupRequest.
        """
        return self._attrs.get("variadic")

    @variadic.setter
    def variadic(self, variadic: "bool"):
        """Sets the variadic of this GroupRequest.


        :param variadic: The variadic of this GroupRequest.
        :type: bool
        """
        self._attrs["variadic"] = variadic

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GroupResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GroupResponse":
        instance = GroupResponse.__new__(GroupResponse)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "List[GroupArgumentsNode]" = None, ast: "UplPipeline" = None, attributes: "object" = None, categories: "List[int]" = None, create_date: "int" = None, create_user_id: "str" = None, group_id: "str" = None, last_update_date: "int" = None, last_update_user_id: "str" = None, mappings: "List[GroupFunctionArgsMappingNode]" = None, name: "str" = None, output_type: "str" = None, scalar: "bool" = None, tenant_id: "str" = None, variadic: "bool" = None, **extra):
        """GroupResponse"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if ast is not None:
            self._attrs["ast"] = ast.to_dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if categories is not None:
            self._attrs["categories"] = categories
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if group_id is not None:
            self._attrs["groupId"] = group_id
        if last_update_date is not None:
            self._attrs["lastUpdateDate"] = last_update_date
        if last_update_user_id is not None:
            self._attrs["lastUpdateUserId"] = last_update_user_id
        if mappings is not None:
            self._attrs["mappings"] = mappings
        if name is not None:
            self._attrs["name"] = name
        if output_type is not None:
            self._attrs["outputType"] = output_type
        if scalar is not None:
            self._attrs["scalar"] = scalar
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        if variadic is not None:
            self._attrs["variadic"] = variadic
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "List[GroupArgumentsNode]":
        """ Gets the arguments of this GroupResponse.
        """
        return [GroupArgumentsNode._from_dict(i) for i in self._attrs.get("arguments")]

    @arguments.setter
    def arguments(self, arguments: "List[GroupArgumentsNode]"):
        """Sets the arguments of this GroupResponse.


        :param arguments: The arguments of this GroupResponse.
        :type: List[GroupArgumentsNode]
        """
        self._attrs["arguments"] = arguments

    @property
    def ast(self) -> "UplPipeline":
        """ Gets the ast of this GroupResponse.
        """
        return UplPipeline._from_dict(self._attrs["ast"])

    @ast.setter
    def ast(self, ast: "UplPipeline"):
        """Sets the ast of this GroupResponse.


        :param ast: The ast of this GroupResponse.
        :type: UplPipeline
        """
        self._attrs["ast"] = ast.to_dict()

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this GroupResponse.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this GroupResponse.


        :param attributes: The attributes of this GroupResponse.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def categories(self) -> "List[int]":
        """ Gets the categories of this GroupResponse.
        """
        return self._attrs.get("categories")

    @categories.setter
    def categories(self, categories: "List[int]"):
        """Sets the categories of this GroupResponse.


        :param categories: The categories of this GroupResponse.
        :type: List[int]
        """
        self._attrs["categories"] = categories

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this GroupResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this GroupResponse.


        :param create_date: The create_date of this GroupResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this GroupResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this GroupResponse.


        :param create_user_id: The create_user_id of this GroupResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def group_id(self) -> "str":
        """ Gets the group_id of this GroupResponse.
        """
        return self._attrs.get("groupId")

    @group_id.setter
    def group_id(self, group_id: "str"):
        """Sets the group_id of this GroupResponse.


        :param group_id: The group_id of this GroupResponse.
        :type: str
        """
        self._attrs["groupId"] = group_id

    @property
    def last_update_date(self) -> "int":
        """ Gets the last_update_date of this GroupResponse.
        """
        return self._attrs.get("lastUpdateDate")

    @last_update_date.setter
    def last_update_date(self, last_update_date: "int"):
        """Sets the last_update_date of this GroupResponse.


        :param last_update_date: The last_update_date of this GroupResponse.
        :type: int
        """
        self._attrs["lastUpdateDate"] = last_update_date

    @property
    def last_update_user_id(self) -> "str":
        """ Gets the last_update_user_id of this GroupResponse.
        """
        return self._attrs.get("lastUpdateUserId")

    @last_update_user_id.setter
    def last_update_user_id(self, last_update_user_id: "str"):
        """Sets the last_update_user_id of this GroupResponse.


        :param last_update_user_id: The last_update_user_id of this GroupResponse.
        :type: str
        """
        self._attrs["lastUpdateUserId"] = last_update_user_id

    @property
    def mappings(self) -> "List[GroupFunctionArgsMappingNode]":
        """ Gets the mappings of this GroupResponse.
        """
        return [GroupFunctionArgsMappingNode._from_dict(i) for i in self._attrs.get("mappings")]

    @mappings.setter
    def mappings(self, mappings: "List[GroupFunctionArgsMappingNode]"):
        """Sets the mappings of this GroupResponse.


        :param mappings: The mappings of this GroupResponse.
        :type: List[GroupFunctionArgsMappingNode]
        """
        self._attrs["mappings"] = mappings

    @property
    def name(self) -> "str":
        """ Gets the name of this GroupResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this GroupResponse.


        :param name: The name of this GroupResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def output_type(self) -> "str":
        """ Gets the output_type of this GroupResponse.
        """
        return self._attrs.get("outputType")

    @output_type.setter
    def output_type(self, output_type: "str"):
        """Sets the output_type of this GroupResponse.


        :param output_type: The output_type of this GroupResponse.
        :type: str
        """
        self._attrs["outputType"] = output_type

    @property
    def scalar(self) -> "bool":
        """ Gets the scalar of this GroupResponse.
        """
        return self._attrs.get("scalar")

    @scalar.setter
    def scalar(self, scalar: "bool"):
        """Sets the scalar of this GroupResponse.


        :param scalar: The scalar of this GroupResponse.
        :type: bool
        """
        self._attrs["scalar"] = scalar

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this GroupResponse.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this GroupResponse.


        :param tenant_id: The tenant_id of this GroupResponse.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    @property
    def variadic(self) -> "bool":
        """ Gets the variadic of this GroupResponse.
        """
        return self._attrs.get("variadic")

    @variadic.setter
    def variadic(self, variadic: "bool"):
        """Sets the variadic of this GroupResponse.


        :param variadic: The variadic of this GroupResponse.
        :type: bool
        """
        self._attrs["variadic"] = variadic

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class NodeMetrics(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "NodeMetrics":
        instance = NodeMetrics.__new__(NodeMetrics)
        instance._attrs = model
        return instance

    def __init__(self, metrics: "object" = None, **extra):
        """NodeMetrics"""

        self._attrs = dict()
        if metrics is not None:
            self._attrs["metrics"] = metrics
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def metrics(self) -> "dict":
        """ Gets the metrics of this NodeMetrics.
        """
        return self._attrs.get("metrics")

    @metrics.setter
    def metrics(self, metrics: "dict"):
        """Sets the metrics of this NodeMetrics.


        :param metrics: The metrics of this NodeMetrics.
        :type: object
        """
        self._attrs["metrics"] = metrics

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MetricsResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "MetricsResponse":
        instance = MetricsResponse.__new__(MetricsResponse)
        instance._attrs = model
        return instance

    def __init__(self, nodes: "Dict[str, NodeMetrics]" = None, **extra):
        """MetricsResponse"""

        self._attrs = dict()
        if nodes is not None:
            self._attrs["nodes"] = nodes
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def nodes(self) -> "Dict[str, NodeMetrics]":
        """ Gets the nodes of this MetricsResponse.
        """
        return self._attrs.get("nodes")

    @nodes.setter
    def nodes(self, nodes: "Dict[str, NodeMetrics]"):
        """Sets the nodes of this MetricsResponse.


        :param nodes: The nodes of this MetricsResponse.
        :type: Dict[str, NodeMetrics]
        """
        self._attrs["nodes"] = nodes

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfConnectionResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfConnectionResponse":
        instance = PaginatedResponseOfConnectionResponse.__new__(PaginatedResponseOfConnectionResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[ConnectionResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfConnectionResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[ConnectionResponse]":
        """ Gets the items of this PaginatedResponseOfConnectionResponse.
        """
        return [ConnectionResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[ConnectionResponse]"):
        """Sets the items of this PaginatedResponseOfConnectionResponse.


        :param items: The items of this PaginatedResponseOfConnectionResponse.
        :type: List[ConnectionResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfConnectionResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfConnectionResponse.


        :param total: The total of this PaginatedResponseOfConnectionResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfConnectorResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfConnectorResponse":
        instance = PaginatedResponseOfConnectorResponse.__new__(PaginatedResponseOfConnectorResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[ConnectorResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfConnectorResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[ConnectorResponse]":
        """ Gets the items of this PaginatedResponseOfConnectorResponse.
        """
        return [ConnectorResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[ConnectorResponse]"):
        """Sets the items of this PaginatedResponseOfConnectorResponse.


        :param items: The items of this PaginatedResponseOfConnectorResponse.
        :type: List[ConnectorResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfConnectorResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfConnectorResponse.


        :param total: The total of this PaginatedResponseOfConnectorResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineJobStatus(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineJobStatus":
        instance = PipelineJobStatus.__new__(PipelineJobStatus)
        instance._attrs = model
        return instance

    def __init__(self, job_id: "str" = None, job_status: "str" = None, pipeline_id: "str" = None, **extra):
        """PipelineJobStatus"""

        self._attrs = dict()
        if job_id is not None:
            self._attrs["jobId"] = job_id
        if job_status is not None:
            self._attrs["jobStatus"] = job_status
        if pipeline_id is not None:
            self._attrs["pipelineId"] = pipeline_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def job_id(self) -> "str":
        """ Gets the job_id of this PipelineJobStatus.
        """
        return self._attrs.get("jobId")

    @job_id.setter
    def job_id(self, job_id: "str"):
        """Sets the job_id of this PipelineJobStatus.


        :param job_id: The job_id of this PipelineJobStatus.
        :type: str
        """
        self._attrs["jobId"] = job_id

    @property
    def job_status(self) -> "str":
        """ Gets the job_status of this PipelineJobStatus.
        """
        return self._attrs.get("jobStatus")

    @job_status.setter
    def job_status(self, job_status: "str"):
        """Sets the job_status of this PipelineJobStatus.


        :param job_status: The job_status of this PipelineJobStatus.
        :type: str
        """
        self._attrs["jobStatus"] = job_status

    @property
    def pipeline_id(self) -> "str":
        """ Gets the pipeline_id of this PipelineJobStatus.
        """
        return self._attrs.get("pipelineId")

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id: "str"):
        """Sets the pipeline_id of this PipelineJobStatus.


        :param pipeline_id: The pipeline_id of this PipelineJobStatus.
        :type: str
        """
        self._attrs["pipelineId"] = pipeline_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfPipelineJobStatus(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfPipelineJobStatus":
        instance = PaginatedResponseOfPipelineJobStatus.__new__(PaginatedResponseOfPipelineJobStatus)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[PipelineJobStatus]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfPipelineJobStatus"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[PipelineJobStatus]":
        """ Gets the items of this PaginatedResponseOfPipelineJobStatus.
        """
        return [PipelineJobStatus._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[PipelineJobStatus]"):
        """Sets the items of this PaginatedResponseOfPipelineJobStatus.


        :param items: The items of this PaginatedResponseOfPipelineJobStatus.
        :type: List[PipelineJobStatus]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfPipelineJobStatus.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfPipelineJobStatus.


        :param total: The total of this PaginatedResponseOfPipelineJobStatus.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    CREATED = "CREATED"
    ACTIVATED = "ACTIVATED"
    FAILED = "FAILED"
    RESTARTING = "RESTARTING"
    FINISHED = "FINISHED"

    @staticmethod
    def from_value(value: str):
        if value == "CREATED":
            return StatusEnum.CREATED
        if value == "ACTIVATED":
            return StatusEnum.ACTIVATED
        if value == "FAILED":
            return StatusEnum.FAILED
        if value == "RESTARTING":
            return StatusEnum.RESTARTING
        if value == "FINISHED":
            return StatusEnum.FINISHED


class PipelineResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineResponse":
        instance = PipelineResponse.__new__(PipelineResponse)
        instance._attrs = model
        return instance

    def __init__(self, activated_date: "int" = None, activated_user_id: "str" = None, activated_version: "int" = None, complexity: "float" = None, create_date: "int" = None, create_user_id: "str" = None, current_version: "int" = None, data: "UplPipeline" = None, description: "str" = None, id: "str" = None, last_update_date: "int" = None, last_update_user_id: "str" = None, name: "str" = None, status: "str" = None, status_message: "str" = None, streaming_configuration_id: "int" = None, tenant_id: "str" = None, validation_messages: "List[str]" = None, version: "int" = None, **extra):
        """PipelineResponse"""

        self._attrs = dict()
        if activated_date is not None:
            self._attrs["activatedDate"] = activated_date
        if activated_user_id is not None:
            self._attrs["activatedUserId"] = activated_user_id
        if activated_version is not None:
            self._attrs["activatedVersion"] = activated_version
        if complexity is not None:
            self._attrs["complexity"] = complexity
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if current_version is not None:
            self._attrs["currentVersion"] = current_version
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if id is not None:
            self._attrs["id"] = id
        if last_update_date is not None:
            self._attrs["lastUpdateDate"] = last_update_date
        if last_update_user_id is not None:
            self._attrs["lastUpdateUserId"] = last_update_user_id
        if name is not None:
            self._attrs["name"] = name
        if status is not None:
            self._attrs["status"] = status
        if status_message is not None:
            self._attrs["statusMessage"] = status_message
        if streaming_configuration_id is not None:
            self._attrs["streamingConfigurationId"] = streaming_configuration_id
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        if validation_messages is not None:
            self._attrs["validationMessages"] = validation_messages
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activated_date(self) -> "int":
        """ Gets the activated_date of this PipelineResponse.
        """
        return self._attrs.get("activatedDate")

    @activated_date.setter
    def activated_date(self, activated_date: "int"):
        """Sets the activated_date of this PipelineResponse.


        :param activated_date: The activated_date of this PipelineResponse.
        :type: int
        """
        self._attrs["activatedDate"] = activated_date

    @property
    def activated_user_id(self) -> "str":
        """ Gets the activated_user_id of this PipelineResponse.
        """
        return self._attrs.get("activatedUserId")

    @activated_user_id.setter
    def activated_user_id(self, activated_user_id: "str"):
        """Sets the activated_user_id of this PipelineResponse.


        :param activated_user_id: The activated_user_id of this PipelineResponse.
        :type: str
        """
        self._attrs["activatedUserId"] = activated_user_id

    @property
    def activated_version(self) -> "int":
        """ Gets the activated_version of this PipelineResponse.
        """
        return self._attrs.get("activatedVersion")

    @activated_version.setter
    def activated_version(self, activated_version: "int"):
        """Sets the activated_version of this PipelineResponse.


        :param activated_version: The activated_version of this PipelineResponse.
        :type: int
        """
        self._attrs["activatedVersion"] = activated_version

    @property
    def complexity(self) -> "float":
        """ Gets the complexity of this PipelineResponse.
        """
        return self._attrs.get("complexity")

    @complexity.setter
    def complexity(self, complexity: "float"):
        """Sets the complexity of this PipelineResponse.


        :param complexity: The complexity of this PipelineResponse.
        :type: float
        """
        self._attrs["complexity"] = complexity

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this PipelineResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this PipelineResponse.


        :param create_date: The create_date of this PipelineResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this PipelineResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this PipelineResponse.


        :param create_user_id: The create_user_id of this PipelineResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def current_version(self) -> "int":
        """ Gets the current_version of this PipelineResponse.
        """
        return self._attrs.get("currentVersion")

    @current_version.setter
    def current_version(self, current_version: "int"):
        """Sets the current_version of this PipelineResponse.


        :param current_version: The current_version of this PipelineResponse.
        :type: int
        """
        self._attrs["currentVersion"] = current_version

    @property
    def data(self) -> "UplPipeline":
        """ Gets the data of this PipelineResponse.
        """
        return UplPipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "UplPipeline"):
        """Sets the data of this PipelineResponse.


        :param data: The data of this PipelineResponse.
        :type: UplPipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this PipelineResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this PipelineResponse.


        :param description: The description of this PipelineResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def id(self) -> "str":
        """ Gets the id of this PipelineResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this PipelineResponse.


        :param id: The id of this PipelineResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def last_update_date(self) -> "int":
        """ Gets the last_update_date of this PipelineResponse.
        """
        return self._attrs.get("lastUpdateDate")

    @last_update_date.setter
    def last_update_date(self, last_update_date: "int"):
        """Sets the last_update_date of this PipelineResponse.


        :param last_update_date: The last_update_date of this PipelineResponse.
        :type: int
        """
        self._attrs["lastUpdateDate"] = last_update_date

    @property
    def last_update_user_id(self) -> "str":
        """ Gets the last_update_user_id of this PipelineResponse.
        """
        return self._attrs.get("lastUpdateUserId")

    @last_update_user_id.setter
    def last_update_user_id(self, last_update_user_id: "str"):
        """Sets the last_update_user_id of this PipelineResponse.


        :param last_update_user_id: The last_update_user_id of this PipelineResponse.
        :type: str
        """
        self._attrs["lastUpdateUserId"] = last_update_user_id

    @property
    def name(self) -> "str":
        """ Gets the name of this PipelineResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this PipelineResponse.


        :param name: The name of this PipelineResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this PipelineResponse.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this PipelineResponse.


        :param status: The status of this PipelineResponse.
        :type: str
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    @property
    def status_message(self) -> "str":
        """ Gets the status_message of this PipelineResponse.
        """
        return self._attrs.get("statusMessage")

    @status_message.setter
    def status_message(self, status_message: "str"):
        """Sets the status_message of this PipelineResponse.


        :param status_message: The status_message of this PipelineResponse.
        :type: str
        """
        self._attrs["statusMessage"] = status_message

    @property
    def streaming_configuration_id(self) -> "int":
        """ Gets the streaming_configuration_id of this PipelineResponse.
        """
        return self._attrs.get("streamingConfigurationId")

    @streaming_configuration_id.setter
    def streaming_configuration_id(self, streaming_configuration_id: "int"):
        """Sets the streaming_configuration_id of this PipelineResponse.


        :param streaming_configuration_id: The streaming_configuration_id of this PipelineResponse.
        :type: int
        """
        self._attrs["streamingConfigurationId"] = streaming_configuration_id

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this PipelineResponse.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this PipelineResponse.


        :param tenant_id: The tenant_id of this PipelineResponse.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    @property
    def validation_messages(self) -> "List[str]":
        """ Gets the validation_messages of this PipelineResponse.
        """
        return self._attrs.get("validationMessages")

    @validation_messages.setter
    def validation_messages(self, validation_messages: "List[str]"):
        """Sets the validation_messages of this PipelineResponse.


        :param validation_messages: The validation_messages of this PipelineResponse.
        :type: List[str]
        """
        self._attrs["validationMessages"] = validation_messages

    @property
    def version(self) -> "int":
        """ Gets the version of this PipelineResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this PipelineResponse.


        :param version: The version of this PipelineResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfPipelineResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfPipelineResponse":
        instance = PaginatedResponseOfPipelineResponse.__new__(PaginatedResponseOfPipelineResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[PipelineResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfPipelineResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[PipelineResponse]":
        """ Gets the items of this PaginatedResponseOfPipelineResponse.
        """
        return [PipelineResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[PipelineResponse]"):
        """Sets the items of this PaginatedResponseOfPipelineResponse.


        :param items: The items of this PaginatedResponseOfPipelineResponse.
        :type: List[PipelineResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfPipelineResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfPipelineResponse.


        :param total: The total of this PaginatedResponseOfPipelineResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplateResponse":
        instance = TemplateResponse.__new__(TemplateResponse)
        instance._attrs = model
        return instance

    def __init__(self, create_date: "int" = None, create_user_id: "str" = None, data: "UplPipeline" = None, description: "str" = None, name: "str" = None, owner_tenant_id: "str" = None, template_id: "str" = None, version: "int" = None, **extra):
        """TemplateResponse"""

        self._attrs = dict()
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        if owner_tenant_id is not None:
            self._attrs["ownerTenantId"] = owner_tenant_id
        if template_id is not None:
            self._attrs["templateId"] = template_id
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this TemplateResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this TemplateResponse.


        :param create_date: The create_date of this TemplateResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this TemplateResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this TemplateResponse.


        :param create_user_id: The create_user_id of this TemplateResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "UplPipeline":
        """ Gets the data of this TemplateResponse.
        """
        return UplPipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "UplPipeline"):
        """Sets the data of this TemplateResponse.


        :param data: The data of this TemplateResponse.
        :type: UplPipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplateResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplateResponse.


        :param description: The description of this TemplateResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplateResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplateResponse.


        :param name: The name of this TemplateResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner_tenant_id(self) -> "str":
        """ Gets the owner_tenant_id of this TemplateResponse.
        """
        return self._attrs.get("ownerTenantId")

    @owner_tenant_id.setter
    def owner_tenant_id(self, owner_tenant_id: "str"):
        """Sets the owner_tenant_id of this TemplateResponse.


        :param owner_tenant_id: The owner_tenant_id of this TemplateResponse.
        :type: str
        """
        self._attrs["ownerTenantId"] = owner_tenant_id

    @property
    def template_id(self) -> "str":
        """ Gets the template_id of this TemplateResponse.
        """
        return self._attrs.get("templateId")

    @template_id.setter
    def template_id(self, template_id: "str"):
        """Sets the template_id of this TemplateResponse.


        :param template_id: The template_id of this TemplateResponse.
        :type: str
        """
        self._attrs["templateId"] = template_id

    @property
    def version(self) -> "int":
        """ Gets the version of this TemplateResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this TemplateResponse.


        :param version: The version of this TemplateResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfTemplateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfTemplateResponse":
        instance = PaginatedResponseOfTemplateResponse.__new__(PaginatedResponseOfTemplateResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[TemplateResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfTemplateResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[TemplateResponse]":
        """ Gets the items of this PaginatedResponseOfTemplateResponse.
        """
        return [TemplateResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[TemplateResponse]"):
        """Sets the items of this PaginatedResponseOfTemplateResponse.


        :param items: The items of this PaginatedResponseOfTemplateResponse.
        :type: List[TemplateResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfTemplateResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfTemplateResponse.


        :param total: The total of this PaginatedResponseOfTemplateResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineDeleteResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineDeleteResponse":
        instance = PipelineDeleteResponse.__new__(PipelineDeleteResponse)
        instance._attrs = model
        return instance

    def __init__(self, could_deactivate: "bool" = None, running: "bool" = None, **extra):
        """PipelineDeleteResponse"""

        self._attrs = dict()
        if could_deactivate is not None:
            self._attrs["couldDeactivate"] = could_deactivate
        if running is not None:
            self._attrs["running"] = running
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def could_deactivate(self) -> "bool":
        """ Gets the could_deactivate of this PipelineDeleteResponse.
        """
        return self._attrs.get("couldDeactivate")

    @could_deactivate.setter
    def could_deactivate(self, could_deactivate: "bool"):
        """Sets the could_deactivate of this PipelineDeleteResponse.


        :param could_deactivate: The could_deactivate of this PipelineDeleteResponse.
        :type: bool
        """
        self._attrs["couldDeactivate"] = could_deactivate

    @property
    def running(self) -> "bool":
        """ Gets the running of this PipelineDeleteResponse.
        """
        return self._attrs.get("running")

    @running.setter
    def running(self, running: "bool"):
        """Sets the running of this PipelineDeleteResponse.


        :param running: The running of this PipelineDeleteResponse.
        :type: bool
        """
        self._attrs["running"] = running

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelinePatchRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelinePatchRequest":
        instance = PipelinePatchRequest.__new__(PipelinePatchRequest)
        instance._attrs = model
        return instance

    def __init__(self, bypass_validation: "bool" = None, create_user_id: "str" = None, data: "UplPipeline" = None, description: "str" = None, name: "str" = None, **extra):
        """PipelinePatchRequest"""

        self._attrs = dict()
        if bypass_validation is not None:
            self._attrs["bypassValidation"] = bypass_validation
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def bypass_validation(self) -> "bool":
        """ Gets the bypass_validation of this PipelinePatchRequest.
        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.
        """
        return self._attrs.get("bypassValidation")

    @bypass_validation.setter
    def bypass_validation(self, bypass_validation: "bool"):
        """Sets the bypass_validation of this PipelinePatchRequest.

        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.

        :param bypass_validation: The bypass_validation of this PipelinePatchRequest.
        :type: bool
        """
        self._attrs["bypassValidation"] = bypass_validation

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this PipelinePatchRequest.
        The user that created the pipeline. Deprecated.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this PipelinePatchRequest.

        The user that created the pipeline. Deprecated.

        :param create_user_id: The create_user_id of this PipelinePatchRequest.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "UplPipeline":
        """ Gets the data of this PipelinePatchRequest.
        """
        return UplPipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "UplPipeline"):
        """Sets the data of this PipelinePatchRequest.


        :param data: The data of this PipelinePatchRequest.
        :type: UplPipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this PipelinePatchRequest.
        The description of the pipeline. Defaults to null.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this PipelinePatchRequest.

        The description of the pipeline. Defaults to null.

        :param description: The description of this PipelinePatchRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this PipelinePatchRequest.
        The name of the pipeline.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this PipelinePatchRequest.

        The name of the pipeline.

        :param name: The name of this PipelinePatchRequest.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Pipeline_reactivation_statusEnum(str, Enum):
    ACTIVATED = "activated"
    CURRENTVERSIONINVALID = "currentVersionInvalid"
    FAILEDTODEACTIVATECURRENTVERSION = "failedToDeactivateCurrentVersion"
    NOTACTIVATED = "notActivated"
    ROLLEDBACK = "rolledBack"
    ROLLEDBACKERROR = "rolledBackError"

    @staticmethod
    def from_value(value: str):
        if value == "activated":
            return Pipeline_reactivation_statusEnum.ACTIVATED
        if value == "currentVersionInvalid":
            return Pipeline_reactivation_statusEnum.CURRENTVERSIONINVALID
        if value == "failedToDeactivateCurrentVersion":
            return Pipeline_reactivation_statusEnum.FAILEDTODEACTIVATECURRENTVERSION
        if value == "notActivated":
            return Pipeline_reactivation_statusEnum.NOTACTIVATED
        if value == "rolledBack":
            return Pipeline_reactivation_statusEnum.ROLLEDBACK
        if value == "rolledBackError":
            return Pipeline_reactivation_statusEnum.ROLLEDBACKERROR


class PipelineReactivateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineReactivateResponse":
        instance = PipelineReactivateResponse.__new__(PipelineReactivateResponse)
        instance._attrs = model
        return instance

    def __init__(self, currently_active_version: "int" = None, pipeline_id: "str" = None, pipeline_reactivation_status: "str" = None, status_description: "Dict[str, str]" = None, **extra):
        """PipelineReactivateResponse"""

        self._attrs = dict()
        if currently_active_version is not None:
            self._attrs["currentlyActiveVersion"] = currently_active_version
        if pipeline_id is not None:
            self._attrs["pipelineId"] = pipeline_id
        if pipeline_reactivation_status is not None:
            self._attrs["pipelineReactivationStatus"] = pipeline_reactivation_status
        if status_description is not None:
            self._attrs["statusDescription"] = status_description
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def currently_active_version(self) -> "int":
        """ Gets the currently_active_version of this PipelineReactivateResponse.
        """
        return self._attrs.get("currentlyActiveVersion")

    @currently_active_version.setter
    def currently_active_version(self, currently_active_version: "int"):
        """Sets the currently_active_version of this PipelineReactivateResponse.


        :param currently_active_version: The currently_active_version of this PipelineReactivateResponse.
        :type: int
        """
        self._attrs["currentlyActiveVersion"] = currently_active_version

    @property
    def pipeline_id(self) -> "str":
        """ Gets the pipeline_id of this PipelineReactivateResponse.
        """
        return self._attrs.get("pipelineId")

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id: "str"):
        """Sets the pipeline_id of this PipelineReactivateResponse.


        :param pipeline_id: The pipeline_id of this PipelineReactivateResponse.
        :type: str
        """
        self._attrs["pipelineId"] = pipeline_id

    @property
    def pipeline_reactivation_status(self) -> "Pipeline_reactivation_statusEnum":
        """ Gets the pipeline_reactivation_status of this PipelineReactivateResponse.
        """
        return Pipeline_reactivation_statusEnum.from_value(self._attrs.get("pipelineReactivationStatus"))

    @pipeline_reactivation_status.setter
    def pipeline_reactivation_status(self, pipeline_reactivation_status: "str"):
        """Sets the pipeline_reactivation_status of this PipelineReactivateResponse.


        :param pipeline_reactivation_status: The pipeline_reactivation_status of this PipelineReactivateResponse.
        :type: str
        """
        if isinstance(pipeline_reactivation_status, Enum):
            self._attrs["pipelineReactivationStatus"] = pipeline_reactivation_status.value
        else:
            self._attrs["pipelineReactivationStatus"] = pipeline_reactivation_status  # If you supply a string, we presume you know the service will take it.

    @property
    def status_description(self) -> "Dict[str, str]":
        """ Gets the status_description of this PipelineReactivateResponse.
        """
        return self._attrs.get("statusDescription")

    @status_description.setter
    def status_description(self, status_description: "Dict[str, str]"):
        """Sets the status_description of this PipelineReactivateResponse.


        :param status_description: The status_description of this PipelineReactivateResponse.
        :type: Dict[str, str]
        """
        self._attrs["statusDescription"] = status_description

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineRequest":
        instance = PipelineRequest.__new__(PipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "UplPipeline", name: "str", bypass_validation: "bool" = None, description: "str" = None, **extra):
        """PipelineRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if name is not None:
            self._attrs["name"] = name
        if bypass_validation is not None:
            self._attrs["bypassValidation"] = bypass_validation
        if description is not None:
            self._attrs["description"] = description
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "UplPipeline":
        """ Gets the data of this PipelineRequest.
        """
        return UplPipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "UplPipeline"):
        """Sets the data of this PipelineRequest.


        :param data: The data of this PipelineRequest.
        :type: UplPipeline
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data.to_dict()

    @property
    def name(self) -> "str":
        """ Gets the name of this PipelineRequest.
        The name of the pipeline.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this PipelineRequest.

        The name of the pipeline.

        :param name: The name of this PipelineRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def bypass_validation(self) -> "bool":
        """ Gets the bypass_validation of this PipelineRequest.
        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.
        """
        return self._attrs.get("bypassValidation")

    @bypass_validation.setter
    def bypass_validation(self, bypass_validation: "bool"):
        """Sets the bypass_validation of this PipelineRequest.

        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.

        :param bypass_validation: The bypass_validation of this PipelineRequest.
        :type: bool
        """
        self._attrs["bypassValidation"] = bypass_validation

    @property
    def description(self) -> "str":
        """ Gets the description of this PipelineRequest.
        The description of the pipeline. Defaults to null.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this PipelineRequest.

        The description of the pipeline. Defaults to null.

        :param description: The description of this PipelineRequest.
        :type: str
        """
        self._attrs["description"] = description

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelinesMergeRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelinesMergeRequest":
        instance = PipelinesMergeRequest.__new__(PipelinesMergeRequest)
        instance._attrs = model
        return instance

    def __init__(self, input_tree: "UplPipeline", main_tree: "UplPipeline", target_node: "str", target_port: "str", **extra):
        """PipelinesMergeRequest"""

        self._attrs = dict()
        if input_tree is not None:
            self._attrs["inputTree"] = input_tree.to_dict()
        if main_tree is not None:
            self._attrs["mainTree"] = main_tree.to_dict()
        if target_node is not None:
            self._attrs["targetNode"] = target_node
        if target_port is not None:
            self._attrs["targetPort"] = target_port
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def input_tree(self) -> "UplPipeline":
        """ Gets the input_tree of this PipelinesMergeRequest.
        """
        return UplPipeline._from_dict(self._attrs["inputTree"])

    @input_tree.setter
    def input_tree(self, input_tree: "UplPipeline"):
        """Sets the input_tree of this PipelinesMergeRequest.


        :param input_tree: The input_tree of this PipelinesMergeRequest.
        :type: UplPipeline
        """
        if input_tree is None:
            raise ValueError("Invalid value for `input_tree`, must not be `None`")
        self._attrs["inputTree"] = input_tree.to_dict()

    @property
    def main_tree(self) -> "UplPipeline":
        """ Gets the main_tree of this PipelinesMergeRequest.
        """
        return UplPipeline._from_dict(self._attrs["mainTree"])

    @main_tree.setter
    def main_tree(self, main_tree: "UplPipeline"):
        """Sets the main_tree of this PipelinesMergeRequest.


        :param main_tree: The main_tree of this PipelinesMergeRequest.
        :type: UplPipeline
        """
        if main_tree is None:
            raise ValueError("Invalid value for `main_tree`, must not be `None`")
        self._attrs["mainTree"] = main_tree.to_dict()

    @property
    def target_node(self) -> "str":
        """ Gets the target_node of this PipelinesMergeRequest.
        The function ID of the merge target in the main pipeline.
        """
        return self._attrs.get("targetNode")

    @target_node.setter
    def target_node(self, target_node: "str"):
        """Sets the target_node of this PipelinesMergeRequest.

        The function ID of the merge target in the main pipeline.

        :param target_node: The target_node of this PipelinesMergeRequest.
        :type: str
        """
        if target_node is None:
            raise ValueError("Invalid value for `target_node`, must not be `None`")
        self._attrs["targetNode"] = target_node

    @property
    def target_port(self) -> "str":
        """ Gets the target_port of this PipelinesMergeRequest.
        The input port of the merge target in the main pipeline.
        """
        return self._attrs.get("targetPort")

    @target_port.setter
    def target_port(self, target_port: "str"):
        """Sets the target_port of this PipelinesMergeRequest.

        The input port of the merge target in the main pipeline.

        :param target_port: The target_port of this PipelinesMergeRequest.
        :type: str
        """
        if target_port is None:
            raise ValueError("Invalid value for `target_port`, must not be `None`")
        self._attrs["targetPort"] = target_port

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewNode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewNode":
        instance = PreviewNode.__new__(PreviewNode)
        instance._attrs = model
        return instance

    def __init__(self, node_name: "str" = None, records: "List[object]" = None, **extra):
        """PreviewNode"""

        self._attrs = dict()
        if node_name is not None:
            self._attrs["nodeName"] = node_name
        if records is not None:
            self._attrs["records"] = records
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def node_name(self) -> "str":
        """ Gets the node_name of this PreviewNode.
        """
        return self._attrs.get("nodeName")

    @node_name.setter
    def node_name(self, node_name: "str"):
        """Sets the node_name of this PreviewNode.


        :param node_name: The node_name of this PreviewNode.
        :type: str
        """
        self._attrs["nodeName"] = node_name

    @property
    def records(self) -> "List[object]":
        """ Gets the records of this PreviewNode.
        """
        return self._attrs.get("records")

    @records.setter
    def records(self, records: "List[object]"):
        """Sets the records of this PreviewNode.


        :param records: The records of this PreviewNode.
        :type: List[object]
        """
        self._attrs["records"] = records

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewData(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewData":
        instance = PreviewData.__new__(PreviewData)
        instance._attrs = model
        return instance

    def __init__(self, current_number_of_records: "int" = None, nodes: "Dict[str, PreviewNode]" = None, preview_id: "str" = None, records_per_pipeline: "int" = None, tenant_id: "str" = None, **extra):
        """PreviewData"""

        self._attrs = dict()
        if current_number_of_records is not None:
            self._attrs["currentNumberOfRecords"] = current_number_of_records
        if nodes is not None:
            self._attrs["nodes"] = nodes
        if preview_id is not None:
            self._attrs["previewId"] = preview_id
        if records_per_pipeline is not None:
            self._attrs["recordsPerPipeline"] = records_per_pipeline
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def current_number_of_records(self) -> "int":
        """ Gets the current_number_of_records of this PreviewData.
        """
        return self._attrs.get("currentNumberOfRecords")

    @current_number_of_records.setter
    def current_number_of_records(self, current_number_of_records: "int"):
        """Sets the current_number_of_records of this PreviewData.


        :param current_number_of_records: The current_number_of_records of this PreviewData.
        :type: int
        """
        self._attrs["currentNumberOfRecords"] = current_number_of_records

    @property
    def nodes(self) -> "Dict[str, PreviewNode]":
        """ Gets the nodes of this PreviewData.
        """
        return self._attrs.get("nodes")

    @nodes.setter
    def nodes(self, nodes: "Dict[str, PreviewNode]"):
        """Sets the nodes of this PreviewData.


        :param nodes: The nodes of this PreviewData.
        :type: Dict[str, PreviewNode]
        """
        self._attrs["nodes"] = nodes

    @property
    def preview_id(self) -> "str":
        """ Gets the preview_id of this PreviewData.
        """
        return self._attrs.get("previewId")

    @preview_id.setter
    def preview_id(self, preview_id: "str"):
        """Sets the preview_id of this PreviewData.


        :param preview_id: The preview_id of this PreviewData.
        :type: str
        """
        self._attrs["previewId"] = preview_id

    @property
    def records_per_pipeline(self) -> "int":
        """ Gets the records_per_pipeline of this PreviewData.
        """
        return self._attrs.get("recordsPerPipeline")

    @records_per_pipeline.setter
    def records_per_pipeline(self, records_per_pipeline: "int"):
        """Sets the records_per_pipeline of this PreviewData.


        :param records_per_pipeline: The records_per_pipeline of this PreviewData.
        :type: int
        """
        self._attrs["recordsPerPipeline"] = records_per_pipeline

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this PreviewData.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this PreviewData.


        :param tenant_id: The tenant_id of this PreviewData.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewSessionStartRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewSessionStartRequest":
        instance = PreviewSessionStartRequest.__new__(PreviewSessionStartRequest)
        instance._attrs = model
        return instance

    def __init__(self, upl: "UplPipeline", records_limit: "int" = None, records_per_pipeline: "int" = None, session_lifetime_ms: "int" = None, **extra):
        """PreviewSessionStartRequest"""

        self._attrs = dict()
        if upl is not None:
            self._attrs["upl"] = upl.to_dict()
        if records_limit is not None:
            self._attrs["recordsLimit"] = records_limit
        if records_per_pipeline is not None:
            self._attrs["recordsPerPipeline"] = records_per_pipeline
        if session_lifetime_ms is not None:
            self._attrs["sessionLifetimeMs"] = session_lifetime_ms
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def upl(self) -> "UplPipeline":
        """ Gets the upl of this PreviewSessionStartRequest.
        """
        return UplPipeline._from_dict(self._attrs["upl"])

    @upl.setter
    def upl(self, upl: "UplPipeline"):
        """Sets the upl of this PreviewSessionStartRequest.


        :param upl: The upl of this PreviewSessionStartRequest.
        :type: UplPipeline
        """
        if upl is None:
            raise ValueError("Invalid value for `upl`, must not be `None`")
        self._attrs["upl"] = upl.to_dict()

    @property
    def records_limit(self) -> "int":
        """ Gets the records_limit of this PreviewSessionStartRequest.
        The maximum number of events per function. Defaults to 100.
        """
        return self._attrs.get("recordsLimit")

    @records_limit.setter
    def records_limit(self, records_limit: "int"):
        """Sets the records_limit of this PreviewSessionStartRequest.

        The maximum number of events per function. Defaults to 100.

        :param records_limit: The records_limit of this PreviewSessionStartRequest.
        :type: int
        """
        self._attrs["recordsLimit"] = records_limit

    @property
    def records_per_pipeline(self) -> "int":
        """ Gets the records_per_pipeline of this PreviewSessionStartRequest.
        The maximum number of events per pipeline. Defaults to 10000.
        """
        return self._attrs.get("recordsPerPipeline")

    @records_per_pipeline.setter
    def records_per_pipeline(self, records_per_pipeline: "int"):
        """Sets the records_per_pipeline of this PreviewSessionStartRequest.

        The maximum number of events per pipeline. Defaults to 10000.

        :param records_per_pipeline: The records_per_pipeline of this PreviewSessionStartRequest.
        :type: int
        """
        self._attrs["recordsPerPipeline"] = records_per_pipeline

    @property
    def session_lifetime_ms(self) -> "int":
        """ Gets the session_lifetime_ms of this PreviewSessionStartRequest.
        The maximum lifetime of a session, in milliseconds. Defaults to 300,000.
        """
        return self._attrs.get("sessionLifetimeMs")

    @session_lifetime_ms.setter
    def session_lifetime_ms(self, session_lifetime_ms: "int"):
        """Sets the session_lifetime_ms of this PreviewSessionStartRequest.

        The maximum lifetime of a session, in milliseconds. Defaults to 300,000.

        :param session_lifetime_ms: The session_lifetime_ms of this PreviewSessionStartRequest.
        :type: int
        """
        self._attrs["sessionLifetimeMs"] = session_lifetime_ms

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewStartResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewStartResponse":
        instance = PreviewStartResponse.__new__(PreviewStartResponse)
        instance._attrs = model
        return instance

    def __init__(self, preview_id: "int" = None, **extra):
        """PreviewStartResponse"""

        self._attrs = dict()
        if preview_id is not None:
            self._attrs["previewId"] = preview_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def preview_id(self) -> "int":
        """ Gets the preview_id of this PreviewStartResponse.
        """
        return self._attrs.get("previewId")

    @preview_id.setter
    def preview_id(self, preview_id: "int"):
        """Sets the preview_id of this PreviewStartResponse.


        :param preview_id: The preview_id of this PreviewStartResponse.
        :type: int
        """
        self._attrs["previewId"] = preview_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewState(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewState":
        instance = PreviewState.__new__(PreviewState)
        instance._attrs = model
        return instance

    def __init__(self, activated_date: "int" = None, created_date: "int" = None, current_number_of_records: "int" = None, job_id: "str" = None, preview_id: "int" = None, records_per_pipeline: "int" = None, **extra):
        """PreviewState"""

        self._attrs = dict()
        if activated_date is not None:
            self._attrs["activatedDate"] = activated_date
        if created_date is not None:
            self._attrs["createdDate"] = created_date
        if current_number_of_records is not None:
            self._attrs["currentNumberOfRecords"] = current_number_of_records
        if job_id is not None:
            self._attrs["jobId"] = job_id
        if preview_id is not None:
            self._attrs["previewId"] = preview_id
        if records_per_pipeline is not None:
            self._attrs["recordsPerPipeline"] = records_per_pipeline
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activated_date(self) -> "int":
        """ Gets the activated_date of this PreviewState.
        """
        return self._attrs.get("activatedDate")

    @activated_date.setter
    def activated_date(self, activated_date: "int"):
        """Sets the activated_date of this PreviewState.


        :param activated_date: The activated_date of this PreviewState.
        :type: int
        """
        self._attrs["activatedDate"] = activated_date

    @property
    def created_date(self) -> "int":
        """ Gets the created_date of this PreviewState.
        """
        return self._attrs.get("createdDate")

    @created_date.setter
    def created_date(self, created_date: "int"):
        """Sets the created_date of this PreviewState.


        :param created_date: The created_date of this PreviewState.
        :type: int
        """
        self._attrs["createdDate"] = created_date

    @property
    def current_number_of_records(self) -> "int":
        """ Gets the current_number_of_records of this PreviewState.
        """
        return self._attrs.get("currentNumberOfRecords")

    @current_number_of_records.setter
    def current_number_of_records(self, current_number_of_records: "int"):
        """Sets the current_number_of_records of this PreviewState.


        :param current_number_of_records: The current_number_of_records of this PreviewState.
        :type: int
        """
        self._attrs["currentNumberOfRecords"] = current_number_of_records

    @property
    def job_id(self) -> "str":
        """ Gets the job_id of this PreviewState.
        """
        return self._attrs.get("jobId")

    @job_id.setter
    def job_id(self, job_id: "str"):
        """Sets the job_id of this PreviewState.


        :param job_id: The job_id of this PreviewState.
        :type: str
        """
        self._attrs["jobId"] = job_id

    @property
    def preview_id(self) -> "int":
        """ Gets the preview_id of this PreviewState.
        """
        return self._attrs.get("previewId")

    @preview_id.setter
    def preview_id(self, preview_id: "int"):
        """Sets the preview_id of this PreviewState.


        :param preview_id: The preview_id of this PreviewState.
        :type: int
        """
        self._attrs["previewId"] = preview_id

    @property
    def records_per_pipeline(self) -> "int":
        """ Gets the records_per_pipeline of this PreviewState.
        """
        return self._attrs.get("recordsPerPipeline")

    @records_per_pipeline.setter
    def records_per_pipeline(self, records_per_pipeline: "int"):
        """Sets the records_per_pipeline of this PreviewState.


        :param records_per_pipeline: The records_per_pipeline of this PreviewState.
        :type: int
        """
        self._attrs["recordsPerPipeline"] = records_per_pipeline

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ReactivatePipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ReactivatePipelineRequest":
        instance = ReactivatePipelineRequest.__new__(ReactivatePipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, activate_latest_version: "bool" = None, allow_non_restored_state: "bool" = None, skip_restore_state: "bool" = None, **extra):
        """ReactivatePipelineRequest"""

        self._attrs = dict()
        if activate_latest_version is not None:
            self._attrs["activateLatestVersion"] = activate_latest_version
        if allow_non_restored_state is not None:
            self._attrs["allowNonRestoredState"] = allow_non_restored_state
        if skip_restore_state is not None:
            self._attrs["skipRestoreState"] = skip_restore_state
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activate_latest_version(self) -> "bool":
        """ Gets the activate_latest_version of this ReactivatePipelineRequest.
        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.
        """
        return self._attrs.get("activateLatestVersion")

    @activate_latest_version.setter
    def activate_latest_version(self, activate_latest_version: "bool"):
        """Sets the activate_latest_version of this ReactivatePipelineRequest.

        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.

        :param activate_latest_version: The activate_latest_version of this ReactivatePipelineRequest.
        :type: bool
        """
        self._attrs["activateLatestVersion"] = activate_latest_version

    @property
    def allow_non_restored_state(self) -> "bool":
        """ Gets the allow_non_restored_state of this ReactivatePipelineRequest.
        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to reactivate a pipeline in this state. Defaults to false.
        """
        return self._attrs.get("allowNonRestoredState")

    @allow_non_restored_state.setter
    def allow_non_restored_state(self, allow_non_restored_state: "bool"):
        """Sets the allow_non_restored_state of this ReactivatePipelineRequest.

        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to reactivate a pipeline in this state. Defaults to false.

        :param allow_non_restored_state: The allow_non_restored_state of this ReactivatePipelineRequest.
        :type: bool
        """
        self._attrs["allowNonRestoredState"] = allow_non_restored_state

    @property
    def skip_restore_state(self) -> "bool":
        """ Gets the skip_restore_state of this ReactivatePipelineRequest.
        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.
        """
        return self._attrs.get("skipRestoreState")

    @skip_restore_state.setter
    def skip_restore_state(self, skip_restore_state: "bool"):
        """Sets the skip_restore_state of this ReactivatePipelineRequest.

        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.

        :param skip_restore_state: The skip_restore_state of this ReactivatePipelineRequest.
        :type: bool
        """
        self._attrs["skipRestoreState"] = skip_restore_state

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Response(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Response":
        instance = Response.__new__(Response)
        instance._attrs = model
        return instance

    def __init__(self, activated: "str" = None, deactivated: "str" = None, **extra):
        """Response"""

        self._attrs = dict()
        if activated is not None:
            self._attrs["activated"] = activated
        if deactivated is not None:
            self._attrs["deactivated"] = deactivated
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activated(self) -> "str":
        """ Gets the activated of this Response.
        Only set for /activate endpoint
        """
        return self._attrs.get("activated")

    @activated.setter
    def activated(self, activated: "str"):
        """Sets the activated of this Response.

        Only set for /activate endpoint

        :param activated: The activated of this Response.
        :type: str
        """
        self._attrs["activated"] = activated

    @property
    def deactivated(self) -> "str":
        """ Gets the deactivated of this Response.
        Only set for /deactivate endpoint
        """
        return self._attrs.get("deactivated")

    @deactivated.setter
    def deactivated(self, deactivated: "str"):
        """Sets the deactivated of this Response.

        Only set for /deactivate endpoint

        :param deactivated: The deactivated of this Response.
        :type: str
        """
        self._attrs["deactivated"] = deactivated

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SyntaxEnum(str, Enum):
    UPL = "UPL"
    DSL = "DSL"
    SPL = "SPL"
    EVAL = "EVAL"
    WHERE = "WHERE"
    TIMECHART = "TIMECHART"
    FIELDS = "FIELDS"
    MVEXPAND = "MVEXPAND"
    REX = "REX"
    BIN = "BIN"
    RENAME = "RENAME"
    STATS = "STATS"
    STATS_BY = "STATS_BY"
    SELECT = "SELECT"
    EXPRESSION = "EXPRESSION"
    FUNCTION = "FUNCTION"
    LITERAL = "LITERAL"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def from_value(value: str):
        if value == "UPL":
            return SyntaxEnum.UPL
        if value == "DSL":
            return SyntaxEnum.DSL
        if value == "SPL":
            return SyntaxEnum.SPL
        if value == "EVAL":
            return SyntaxEnum.EVAL
        if value == "WHERE":
            return SyntaxEnum.WHERE
        if value == "TIMECHART":
            return SyntaxEnum.TIMECHART
        if value == "FIELDS":
            return SyntaxEnum.FIELDS
        if value == "MVEXPAND":
            return SyntaxEnum.MVEXPAND
        if value == "REX":
            return SyntaxEnum.REX
        if value == "BIN":
            return SyntaxEnum.BIN
        if value == "RENAME":
            return SyntaxEnum.RENAME
        if value == "STATS":
            return SyntaxEnum.STATS
        if value == "STATS_BY":
            return SyntaxEnum.STATS_BY
        if value == "SELECT":
            return SyntaxEnum.SELECT
        if value == "EXPRESSION":
            return SyntaxEnum.EXPRESSION
        if value == "FUNCTION":
            return SyntaxEnum.FUNCTION
        if value == "LITERAL":
            return SyntaxEnum.LITERAL
        if value == "UNKNOWN":
            return SyntaxEnum.UNKNOWN


class SplCompileRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SplCompileRequest":
        instance = SplCompileRequest.__new__(SplCompileRequest)
        instance._attrs = model
        return instance

    def __init__(self, spl: "str", syntax: "str" = None, validate: "bool" = None, **extra):
        """SplCompileRequest"""

        self._attrs = dict()
        if spl is not None:
            self._attrs["spl"] = spl
        if syntax is not None:
            self._attrs["syntax"] = syntax
        if validate is not None:
            self._attrs["validate"] = validate
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def spl(self) -> "str":
        """ Gets the spl of this SplCompileRequest.
        The SPL2 representation of a pipeline or function parameters.
        """
        return self._attrs.get("spl")

    @spl.setter
    def spl(self, spl: "str"):
        """Sets the spl of this SplCompileRequest.

        The SPL2 representation of a pipeline or function parameters.

        :param spl: The spl of this SplCompileRequest.
        :type: str
        """
        if spl is None:
            raise ValueError("Invalid value for `spl`, must not be `None`")
        self._attrs["spl"] = spl

    @property
    def syntax(self) -> "SyntaxEnum":
        """ Gets the syntax of this SplCompileRequest.
        The parse parameters as arguments to this SPL2 command
        """
        return SyntaxEnum.from_value(self._attrs.get("syntax"))

    @syntax.setter
    def syntax(self, syntax: "str"):
        """Sets the syntax of this SplCompileRequest.

        The parse parameters as arguments to this SPL2 command

        :param syntax: The syntax of this SplCompileRequest.
        :type: str
        """
        if isinstance(syntax, Enum):
            self._attrs["syntax"] = syntax.value
        else:
            self._attrs["syntax"] = syntax  # If you supply a string, we presume you know the service will take it.

    @property
    def validate(self) -> "bool":
        """ Gets the validate of this SplCompileRequest.
        A boolean flag to indicate whether the pipeline should be validated.
        """
        return self._attrs.get("validate")

    @validate.setter
    def validate(self, validate: "bool"):
        """Sets the validate of this SplCompileRequest.

        A boolean flag to indicate whether the pipeline should be validated.

        :param validate: The validate of this SplCompileRequest.
        :type: bool
        """
        self._attrs["validate"] = validate

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplatePatchRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplatePatchRequest":
        instance = TemplatePatchRequest.__new__(TemplatePatchRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "UplPipeline" = None, description: "str" = None, name: "str" = None, **extra):
        """TemplatePatchRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "UplPipeline":
        """ Gets the data of this TemplatePatchRequest.
        """
        return UplPipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "UplPipeline"):
        """Sets the data of this TemplatePatchRequest.


        :param data: The data of this TemplatePatchRequest.
        :type: UplPipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplatePatchRequest.
        Template description
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplatePatchRequest.

        Template description

        :param description: The description of this TemplatePatchRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplatePatchRequest.
        Template name
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplatePatchRequest.

        Template name

        :param name: The name of this TemplatePatchRequest.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplatePutRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplatePutRequest":
        instance = TemplatePutRequest.__new__(TemplatePutRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "UplPipeline", description: "str", name: "str", **extra):
        """TemplatePutRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "UplPipeline":
        """ Gets the data of this TemplatePutRequest.
        """
        return UplPipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "UplPipeline"):
        """Sets the data of this TemplatePutRequest.


        :param data: The data of this TemplatePutRequest.
        :type: UplPipeline
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplatePutRequest.
        Template description
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplatePutRequest.

        Template description

        :param description: The description of this TemplatePutRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplatePutRequest.
        Template name
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplatePutRequest.

        Template name

        :param name: The name of this TemplatePutRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplateRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplateRequest":
        instance = TemplateRequest.__new__(TemplateRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "UplPipeline", description: "str", name: "str", **extra):
        """TemplateRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "UplPipeline":
        """ Gets the data of this TemplateRequest.
        """
        return UplPipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "UplPipeline"):
        """Sets the data of this TemplateRequest.


        :param data: The data of this TemplateRequest.
        :type: UplPipeline
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplateRequest.
        Template description
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplateRequest.

        Template description

        :param description: The description of this TemplateRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplateRequest.
        Template name
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplateRequest.

        Template name

        :param name: The name of this TemplateRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplArgument(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplArgument":
        instance = UplArgument.__new__(UplArgument)
        instance._attrs = model
        return instance

    def __init__(self, type: "str", element_type: "object" = None, optional: "bool" = None, position: "int" = None, **extra):
        """UplArgument"""

        self._attrs = dict()
        if type is not None:
            self._attrs["type"] = type
        if element_type is not None:
            self._attrs["elementType"] = element_type
        if optional is not None:
            self._attrs["optional"] = optional
        if position is not None:
            self._attrs["position"] = position
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def type(self) -> "str":
        """ Gets the type of this UplArgument.
        """
        return self._attrs.get("type")

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this UplArgument.


        :param type: The type of this UplArgument.
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")
        self._attrs["type"] = type

    @property
    def element_type(self) -> "object":
        """ Gets the element_type of this UplArgument.
        """
        return self._attrs.get("elementType")

    @element_type.setter
    def element_type(self, element_type: "object"):
        """Sets the element_type of this UplArgument.


        :param element_type: The element_type of this UplArgument.
        :type: object
        """
        self._attrs["elementType"] = element_type

    @property
    def optional(self) -> "bool":
        """ Gets the optional of this UplArgument.
        """
        return self._attrs.get("optional")

    @optional.setter
    def optional(self, optional: "bool"):
        """Sets the optional of this UplArgument.


        :param optional: The optional of this UplArgument.
        :type: bool
        """
        self._attrs["optional"] = optional

    @property
    def position(self) -> "int":
        """ Gets the position of this UplArgument.
        """
        return self._attrs.get("position")

    @position.setter
    def position(self, position: "int"):
        """Sets the position of this UplArgument.


        :param position: The position of this UplArgument.
        :type: int
        """
        self._attrs["position"] = position

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplCategory(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplCategory":
        instance = UplCategory.__new__(UplCategory)
        instance._attrs = model
        return instance

    def __init__(self, id: "int", name: "str", **extra):
        """UplCategory"""

        self._attrs = dict()
        if id is not None:
            self._attrs["id"] = id
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def id(self) -> "int":
        """ Gets the id of this UplCategory.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "int"):
        """Sets the id of this UplCategory.


        :param id: The id of this UplCategory.
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def name(self) -> "str":
        """ Gets the name of this UplCategory.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this UplCategory.


        :param name: The name of this UplCategory.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplFunction(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplFunction":
        instance = UplFunction.__new__(UplFunction)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "Dict[str, UplArgument]" = None, attributes: "object" = None, categories: "List[int]" = None, id: "str" = None, is_variadic: "bool" = None, op: "str" = None, output: "UplArgument" = None, resolved_id: "str" = None, **extra):
        """UplFunction"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if categories is not None:
            self._attrs["categories"] = categories
        if id is not None:
            self._attrs["id"] = id
        if is_variadic is not None:
            self._attrs["isVariadic"] = is_variadic
        if op is not None:
            self._attrs["op"] = op
        if output is not None:
            self._attrs["output"] = output.to_dict()
        if resolved_id is not None:
            self._attrs["resolvedId"] = resolved_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "Dict[str, UplArgument]":
        """ Gets the arguments of this UplFunction.
        """
        return self._attrs.get("arguments")

    @arguments.setter
    def arguments(self, arguments: "Dict[str, UplArgument]"):
        """Sets the arguments of this UplFunction.


        :param arguments: The arguments of this UplFunction.
        :type: Dict[str, UplArgument]
        """
        self._attrs["arguments"] = arguments

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this UplFunction.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this UplFunction.


        :param attributes: The attributes of this UplFunction.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def categories(self) -> "List[int]":
        """ Gets the categories of this UplFunction.
        """
        return self._attrs.get("categories")

    @categories.setter
    def categories(self, categories: "List[int]"):
        """Sets the categories of this UplFunction.


        :param categories: The categories of this UplFunction.
        :type: List[int]
        """
        self._attrs["categories"] = categories

    @property
    def id(self) -> "str":
        """ Gets the id of this UplFunction.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this UplFunction.


        :param id: The id of this UplFunction.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def is_variadic(self) -> "bool":
        """ Gets the is_variadic of this UplFunction.
        """
        return self._attrs.get("isVariadic")

    @is_variadic.setter
    def is_variadic(self, is_variadic: "bool"):
        """Sets the is_variadic of this UplFunction.


        :param is_variadic: The is_variadic of this UplFunction.
        :type: bool
        """
        self._attrs["isVariadic"] = is_variadic

    @property
    def op(self) -> "str":
        """ Gets the op of this UplFunction.
        """
        return self._attrs.get("op")

    @op.setter
    def op(self, op: "str"):
        """Sets the op of this UplFunction.


        :param op: The op of this UplFunction.
        :type: str
        """
        self._attrs["op"] = op

    @property
    def output(self) -> "UplArgument":
        """ Gets the output of this UplFunction.
        """
        return UplArgument._from_dict(self._attrs["output"])

    @output.setter
    def output(self, output: "UplArgument"):
        """Sets the output of this UplFunction.


        :param output: The output of this UplFunction.
        :type: UplArgument
        """
        self._attrs["output"] = output.to_dict()

    @property
    def resolved_id(self) -> "str":
        """ Gets the resolved_id of this UplFunction.
        """
        return self._attrs.get("resolvedId")

    @resolved_id.setter
    def resolved_id(self, resolved_id: "str"):
        """Sets the resolved_id of this UplFunction.


        :param resolved_id: The resolved_id of this UplFunction.
        :type: str
        """
        self._attrs["resolvedId"] = resolved_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplType(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplType":
        instance = UplType.__new__(UplType)
        instance._attrs = model
        return instance

    def __init__(self, field_name: "str" = None, parameters: "List[UplType]" = None, type: "str" = None, **extra):
        """UplType"""

        self._attrs = dict()
        if field_name is not None:
            self._attrs["fieldName"] = field_name
        if parameters is not None:
            self._attrs["parameters"] = parameters
        if type is not None:
            self._attrs["type"] = type
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def field_name(self) -> "str":
        """ Gets the field_name of this UplType.
        """
        return self._attrs.get("fieldName")

    @field_name.setter
    def field_name(self, field_name: "str"):
        """Sets the field_name of this UplType.


        :param field_name: The field_name of this UplType.
        :type: str
        """
        self._attrs["fieldName"] = field_name

    @property
    def parameters(self) -> "List[UplType]":
        """ Gets the parameters of this UplType.
        """
        return [UplType._from_dict(i) for i in self._attrs.get("parameters")]

    @parameters.setter
    def parameters(self, parameters: "List[UplType]"):
        """Sets the parameters of this UplType.


        :param parameters: The parameters of this UplType.
        :type: List[UplType]
        """
        self._attrs["parameters"] = parameters

    @property
    def type(self) -> "str":
        """ Gets the type of this UplType.
        """
        return self._attrs.get("type")

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this UplType.


        :param type: The type of this UplType.
        :type: str
        """
        self._attrs["type"] = type

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplRegistry(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplRegistry":
        instance = UplRegistry.__new__(UplRegistry)
        instance._attrs = model
        return instance

    def __init__(self, categories: "List[UplCategory]" = None, functions: "List[UplFunction]" = None, types: "List[UplType]" = None, **extra):
        """UplRegistry"""

        self._attrs = dict()
        if categories is not None:
            self._attrs["categories"] = categories
        if functions is not None:
            self._attrs["functions"] = functions
        if types is not None:
            self._attrs["types"] = types
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def categories(self) -> "List[UplCategory]":
        """ Gets the categories of this UplRegistry.
        """
        return [UplCategory._from_dict(i) for i in self._attrs.get("categories")]

    @categories.setter
    def categories(self, categories: "List[UplCategory]"):
        """Sets the categories of this UplRegistry.


        :param categories: The categories of this UplRegistry.
        :type: List[UplCategory]
        """
        self._attrs["categories"] = categories

    @property
    def functions(self) -> "List[UplFunction]":
        """ Gets the functions of this UplRegistry.
        """
        return [UplFunction._from_dict(i) for i in self._attrs.get("functions")]

    @functions.setter
    def functions(self, functions: "List[UplFunction]"):
        """Sets the functions of this UplRegistry.


        :param functions: The functions of this UplRegistry.
        :type: List[UplFunction]
        """
        self._attrs["functions"] = functions

    @property
    def types(self) -> "List[UplType]":
        """ Gets the types of this UplRegistry.
        """
        return [UplType._from_dict(i) for i in self._attrs.get("types")]

    @types.setter
    def types(self, types: "List[UplType]"):
        """Sets the types of this UplRegistry.


        :param types: The types of this UplRegistry.
        :type: List[UplType]
        """
        self._attrs["types"] = types

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ValidateRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ValidateRequest":
        instance = ValidateRequest.__new__(ValidateRequest)
        instance._attrs = model
        return instance

    def __init__(self, upl: "UplPipeline", **extra):
        """ValidateRequest"""

        self._attrs = dict()
        if upl is not None:
            self._attrs["upl"] = upl.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def upl(self) -> "UplPipeline":
        """ Gets the upl of this ValidateRequest.
        """
        return UplPipeline._from_dict(self._attrs["upl"])

    @upl.setter
    def upl(self, upl: "UplPipeline"):
        """Sets the upl of this ValidateRequest.


        :param upl: The upl of this ValidateRequest.
        :type: UplPipeline
        """
        if upl is None:
            raise ValueError("Invalid value for `upl`, must not be `None`")
        self._attrs["upl"] = upl.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ValidateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ValidateResponse":
        instance = ValidateResponse.__new__(ValidateResponse)
        instance._attrs = model
        return instance

    def __init__(self, node_id: "str" = None, spl: "str" = None, success: "bool" = None, validation_messages: "List[str]" = None, **extra):
        """ValidateResponse"""

        self._attrs = dict()
        if node_id is not None:
            self._attrs["nodeId"] = node_id
        if spl is not None:
            self._attrs["spl"] = spl
        if success is not None:
            self._attrs["success"] = success
        if validation_messages is not None:
            self._attrs["validationMessages"] = validation_messages
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def node_id(self) -> "str":
        """ Gets the node_id of this ValidateResponse.
        """
        return self._attrs.get("nodeId")

    @node_id.setter
    def node_id(self, node_id: "str"):
        """Sets the node_id of this ValidateResponse.


        :param node_id: The node_id of this ValidateResponse.
        :type: str
        """
        self._attrs["nodeId"] = node_id

    @property
    def spl(self) -> "str":
        """ Gets the spl of this ValidateResponse.
        """
        return self._attrs.get("spl")

    @spl.setter
    def spl(self, spl: "str"):
        """Sets the spl of this ValidateResponse.


        :param spl: The spl of this ValidateResponse.
        :type: str
        """
        self._attrs["spl"] = spl

    @property
    def success(self) -> "bool":
        """ Gets the success of this ValidateResponse.
        """
        return self._attrs.get("success")

    @success.setter
    def success(self, success: "bool"):
        """Sets the success of this ValidateResponse.


        :param success: The success of this ValidateResponse.
        :type: bool
        """
        self._attrs["success"] = success

    @property
    def validation_messages(self) -> "List[str]":
        """ Gets the validation_messages of this ValidateResponse.
        """
        return self._attrs.get("validationMessages")

    @validation_messages.setter
    def validation_messages(self, validation_messages: "List[str]"):
        """Sets the validation_messages of this ValidateResponse.


        :param validation_messages: The validation_messages of this ValidateResponse.
        :type: List[str]
        """
        self._attrs["validationMessages"] = validation_messages

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
