# Copyright © 2021 Splunk, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# [http://www.apache.org/licenses/LICENSE-2.0]
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

############# This file is auto-generated.  Do not edit! #############

"""
    SDC Service: Data Stream Processing REST API

    Use the Streams service to perform create, read, update, and delete (CRUD) operations on your data pipeline. The Streams service also has metrics and preview session endpoints and gives you full control over your data pipeline.

    OpenAPI spec version: v3beta1.1 (recommended default)
    Generated by: https://openapi-generator.tech
"""


from datetime import datetime
from typing import List, Dict
from splunk_sdk.common.sscmodel import SSCModel
from splunk_sdk.base_client import dictify, inflate
from enum import Enum



class ActivatePipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ActivatePipelineRequest":
        instance = ActivatePipelineRequest.__new__(ActivatePipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, activate_latest_version: "bool" = None, allow_non_restored_state: "bool" = None, skip_restore_state: "bool" = None, **extra):
        """ActivatePipelineRequest"""

        self._attrs = dict()
        if activate_latest_version is not None:
            self._attrs["activateLatestVersion"] = activate_latest_version
        if allow_non_restored_state is not None:
            self._attrs["allowNonRestoredState"] = allow_non_restored_state
        if skip_restore_state is not None:
            self._attrs["skipRestoreState"] = skip_restore_state
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activate_latest_version(self) -> "bool":
        """ Gets the activate_latest_version of this ActivatePipelineRequest.
        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.
        """
        return self._attrs.get("activateLatestVersion")

    @activate_latest_version.setter
    def activate_latest_version(self, activate_latest_version: "bool"):
        """Sets the activate_latest_version of this ActivatePipelineRequest.

        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.

        :param activate_latest_version: The activate_latest_version of this ActivatePipelineRequest.
        :type: bool
        """
        self._attrs["activateLatestVersion"] = activate_latest_version

    @property
    def allow_non_restored_state(self) -> "bool":
        """ Gets the allow_non_restored_state of this ActivatePipelineRequest.
        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to activate a pipeline in this state. Defaults to false.
        """
        return self._attrs.get("allowNonRestoredState")

    @allow_non_restored_state.setter
    def allow_non_restored_state(self, allow_non_restored_state: "bool"):
        """Sets the allow_non_restored_state of this ActivatePipelineRequest.

        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to activate a pipeline in this state. Defaults to false.

        :param allow_non_restored_state: The allow_non_restored_state of this ActivatePipelineRequest.
        :type: bool
        """
        self._attrs["allowNonRestoredState"] = allow_non_restored_state

    @property
    def skip_restore_state(self) -> "bool":
        """ Gets the skip_restore_state of this ActivatePipelineRequest.
        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.
        """
        return self._attrs.get("skipRestoreState")

    @skip_restore_state.setter
    def skip_restore_state(self, skip_restore_state: "bool"):
        """Sets the skip_restore_state of this ActivatePipelineRequest.

        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.

        :param skip_restore_state: The skip_restore_state of this ActivatePipelineRequest.
        :type: bool
        """
        self._attrs["skipRestoreState"] = skip_restore_state

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ArgumentModel(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ArgumentModel":
        instance = ArgumentModel.__new__(ArgumentModel)
        instance._attrs = model
        return instance

    def __init__(self, name: "str" = None, optional: "bool" = None, type: "str" = None, **extra):
        """ArgumentModel"""

        self._attrs = dict()
        if name is not None:
            self._attrs["name"] = name
        if optional is not None:
            self._attrs["optional"] = optional
        if type is not None:
            self._attrs["type"] = type
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def name(self) -> "str":
        """ Gets the name of this ArgumentModel.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ArgumentModel.


        :param name: The name of this ArgumentModel.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def optional(self) -> "bool":
        """ Gets the optional of this ArgumentModel.
        """
        return self._attrs.get("optional")

    @optional.setter
    def optional(self, optional: "bool"):
        """Sets the optional of this ArgumentModel.


        :param optional: The optional of this ArgumentModel.
        :type: bool
        """
        self._attrs["optional"] = optional

    @property
    def type(self) -> "str":
        """ Gets the type of this ArgumentModel.
        """
        return self._attrs.get("type")

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this ArgumentModel.


        :param type: The type of this ArgumentModel.
        :type: str
        """
        self._attrs["type"] = type

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionPatchRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionPatchRequest":
        instance = ConnectionPatchRequest.__new__(ConnectionPatchRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "object" = None, description: "str" = None, name: "str" = None, **extra):
        """ConnectionPatchRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionPatchRequest.
        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionPatchRequest.

        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.

        :param data: The data of this ConnectionPatchRequest.
        :type: object
        """
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionPatchRequest.
        The description of the connection.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionPatchRequest.

        The description of the connection.

        :param description: The description of this ConnectionPatchRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionPatchRequest.
        The name of the connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionPatchRequest.

        The name of the connection.

        :param name: The name of this ConnectionPatchRequest.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionPutRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionPutRequest":
        instance = ConnectionPutRequest.__new__(ConnectionPutRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "object", description: "str", name: "str", **extra):
        """ConnectionPutRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionPutRequest.
        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionPutRequest.

        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.

        :param data: The data of this ConnectionPutRequest.
        :type: object
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionPutRequest.
        The description of the connection.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionPutRequest.

        The description of the connection.

        :param description: The description of this ConnectionPutRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionPutRequest.
        The name of the connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionPutRequest.

        The name of the connection.

        :param name: The name of this ConnectionPutRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionRequest":
        instance = ConnectionRequest.__new__(ConnectionRequest)
        instance._attrs = model
        return instance

    def __init__(self, connector_id: "str", data: "object", description: "str", name: "str", **extra):
        """ConnectionRequest"""

        self._attrs = dict()
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this ConnectionRequest.
        The ID of the parent connector.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this ConnectionRequest.

        The ID of the parent connector.

        :param connector_id: The connector_id of this ConnectionRequest.
        :type: str
        """
        if connector_id is None:
            raise ValueError("Invalid value for `connector_id`, must not be `None`")
        self._attrs["connectorId"] = connector_id

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionRequest.
        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionRequest.

        The key-value pairs of configurations for this connection. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.

        :param data: The data of this ConnectionRequest.
        :type: object
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionRequest.
        The description of the connection.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionRequest.

        The description of the connection.

        :param description: The description of this ConnectionRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionRequest.
        The name of the connection.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionRequest.

        The name of the connection.

        :param name: The name of this ConnectionRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Source(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Source":
        instance = Source.__new__(Source)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "object" = None, connection_id: "str" = None, connection_version: "int" = None, connector_id: "str" = None, create_date: "int" = None, create_user_id: "str" = None, data_stream_id: "str" = None, description: "str" = None, enabled: "bool" = None, event_attributes: "object" = None, id: "str" = None, last_update_date: "int" = None, last_update_user_id: "str" = None, name: "str" = None, parallelism: "int" = None, schedule: "str" = None, tenant_id: "str" = None, version: "int" = None, **extra):
        """Source"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if connection_id is not None:
            self._attrs["connectionId"] = connection_id
        if connection_version is not None:
            self._attrs["connectionVersion"] = connection_version
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data_stream_id is not None:
            self._attrs["dataStreamId"] = data_stream_id
        if description is not None:
            self._attrs["description"] = description
        if enabled is not None:
            self._attrs["enabled"] = enabled
        if event_attributes is not None:
            self._attrs["eventAttributes"] = event_attributes
        if id is not None:
            self._attrs["id"] = id
        if last_update_date is not None:
            self._attrs["lastUpdateDate"] = last_update_date
        if last_update_user_id is not None:
            self._attrs["lastUpdateUserId"] = last_update_user_id
        if name is not None:
            self._attrs["name"] = name
        if parallelism is not None:
            self._attrs["parallelism"] = parallelism
        if schedule is not None:
            self._attrs["schedule"] = schedule
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "dict":
        """ Gets the arguments of this Source.
        """
        return self._attrs.get("arguments")

    @arguments.setter
    def arguments(self, arguments: "dict"):
        """Sets the arguments of this Source.


        :param arguments: The arguments of this Source.
        :type: object
        """
        self._attrs["arguments"] = arguments

    @property
    def connection_id(self) -> "str":
        """ Gets the connection_id of this Source.
        """
        return self._attrs.get("connectionId")

    @connection_id.setter
    def connection_id(self, connection_id: "str"):
        """Sets the connection_id of this Source.


        :param connection_id: The connection_id of this Source.
        :type: str
        """
        self._attrs["connectionId"] = connection_id

    @property
    def connection_version(self) -> "int":
        """ Gets the connection_version of this Source.
        """
        return self._attrs.get("connectionVersion")

    @connection_version.setter
    def connection_version(self, connection_version: "int"):
        """Sets the connection_version of this Source.


        :param connection_version: The connection_version of this Source.
        :type: int
        """
        self._attrs["connectionVersion"] = connection_version

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this Source.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this Source.


        :param connector_id: The connector_id of this Source.
        :type: str
        """
        self._attrs["connectorId"] = connector_id

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this Source.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this Source.


        :param create_date: The create_date of this Source.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this Source.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this Source.


        :param create_user_id: The create_user_id of this Source.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data_stream_id(self) -> "str":
        """ Gets the data_stream_id of this Source.
        """
        return self._attrs.get("dataStreamId")

    @data_stream_id.setter
    def data_stream_id(self, data_stream_id: "str"):
        """Sets the data_stream_id of this Source.


        :param data_stream_id: The data_stream_id of this Source.
        :type: str
        """
        self._attrs["dataStreamId"] = data_stream_id

    @property
    def description(self) -> "str":
        """ Gets the description of this Source.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this Source.


        :param description: The description of this Source.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def enabled(self) -> "bool":
        """ Gets the enabled of this Source.
        """
        return self._attrs.get("enabled")

    @enabled.setter
    def enabled(self, enabled: "bool"):
        """Sets the enabled of this Source.


        :param enabled: The enabled of this Source.
        :type: bool
        """
        self._attrs["enabled"] = enabled

    @property
    def event_attributes(self) -> "dict":
        """ Gets the event_attributes of this Source.
        """
        return self._attrs.get("eventAttributes")

    @event_attributes.setter
    def event_attributes(self, event_attributes: "dict"):
        """Sets the event_attributes of this Source.


        :param event_attributes: The event_attributes of this Source.
        :type: object
        """
        self._attrs["eventAttributes"] = event_attributes

    @property
    def id(self) -> "str":
        """ Gets the id of this Source.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this Source.


        :param id: The id of this Source.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def last_update_date(self) -> "int":
        """ Gets the last_update_date of this Source.
        """
        return self._attrs.get("lastUpdateDate")

    @last_update_date.setter
    def last_update_date(self, last_update_date: "int"):
        """Sets the last_update_date of this Source.


        :param last_update_date: The last_update_date of this Source.
        :type: int
        """
        self._attrs["lastUpdateDate"] = last_update_date

    @property
    def last_update_user_id(self) -> "str":
        """ Gets the last_update_user_id of this Source.
        """
        return self._attrs.get("lastUpdateUserId")

    @last_update_user_id.setter
    def last_update_user_id(self, last_update_user_id: "str"):
        """Sets the last_update_user_id of this Source.


        :param last_update_user_id: The last_update_user_id of this Source.
        :type: str
        """
        self._attrs["lastUpdateUserId"] = last_update_user_id

    @property
    def name(self) -> "str":
        """ Gets the name of this Source.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this Source.


        :param name: The name of this Source.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def parallelism(self) -> "int":
        """ Gets the parallelism of this Source.
        """
        return self._attrs.get("parallelism")

    @parallelism.setter
    def parallelism(self, parallelism: "int"):
        """Sets the parallelism of this Source.


        :param parallelism: The parallelism of this Source.
        :type: int
        """
        self._attrs["parallelism"] = parallelism

    @property
    def schedule(self) -> "str":
        """ Gets the schedule of this Source.
        """
        return self._attrs.get("schedule")

    @schedule.setter
    def schedule(self, schedule: "str"):
        """Sets the schedule of this Source.


        :param schedule: The schedule of this Source.
        :type: str
        """
        self._attrs["schedule"] = schedule

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this Source.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this Source.


        :param tenant_id: The tenant_id of this Source.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    @property
    def version(self) -> "int":
        """ Gets the version of this Source.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this Source.


        :param version: The version of this Source.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionVersionResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionVersionResponse":
        instance = ConnectionVersionResponse.__new__(ConnectionVersionResponse)
        instance._attrs = model
        return instance

    def __init__(self, create_date: "int" = None, create_user_id: "str" = None, data: "object" = None, description: "str" = None, name: "str" = None, version: "int" = None, **extra):
        """ConnectionVersionResponse"""

        self._attrs = dict()
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this ConnectionVersionResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this ConnectionVersionResponse.


        :param create_date: The create_date of this ConnectionVersionResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this ConnectionVersionResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this ConnectionVersionResponse.


        :param create_user_id: The create_user_id of this ConnectionVersionResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionVersionResponse.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionVersionResponse.


        :param data: The data of this ConnectionVersionResponse.
        :type: object
        """
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionVersionResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionVersionResponse.


        :param description: The description of this ConnectionVersionResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionVersionResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionVersionResponse.


        :param name: The name of this ConnectionVersionResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this ConnectionVersionResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ConnectionVersionResponse.


        :param version: The version of this ConnectionVersionResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionResponse":
        instance = ConnectionResponse.__new__(ConnectionResponse)
        instance._attrs = model
        return instance

    def __init__(self, active_pipelines_using: "List[object]" = None, active_sources_using: "List[Source]" = None, connector_id: "str" = None, connector_name: "str" = None, create_date: "int" = None, create_user_id: "str" = None, id: "str" = None, last_update_date: "int" = None, last_update_user_id: "str" = None, versions: "List[ConnectionVersionResponse]" = None, **extra):
        """ConnectionResponse"""

        self._attrs = dict()
        if active_pipelines_using is not None:
            self._attrs["activePipelinesUsing"] = active_pipelines_using
        if active_sources_using is not None:
            self._attrs["activeSourcesUsing"] = active_sources_using
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if connector_name is not None:
            self._attrs["connectorName"] = connector_name
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if id is not None:
            self._attrs["id"] = id
        if last_update_date is not None:
            self._attrs["lastUpdateDate"] = last_update_date
        if last_update_user_id is not None:
            self._attrs["lastUpdateUserId"] = last_update_user_id
        if versions is not None:
            self._attrs["versions"] = versions
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def active_pipelines_using(self) -> "List[object]":
        """ Gets the active_pipelines_using of this ConnectionResponse.
        """
        return self._attrs.get("activePipelinesUsing")

    @active_pipelines_using.setter
    def active_pipelines_using(self, active_pipelines_using: "List[object]"):
        """Sets the active_pipelines_using of this ConnectionResponse.


        :param active_pipelines_using: The active_pipelines_using of this ConnectionResponse.
        :type: List[object]
        """
        self._attrs["activePipelinesUsing"] = active_pipelines_using

    @property
    def active_sources_using(self) -> "List[Source]":
        """ Gets the active_sources_using of this ConnectionResponse.
        """
        return [Source._from_dict(i) for i in self._attrs.get("activeSourcesUsing")]

    @active_sources_using.setter
    def active_sources_using(self, active_sources_using: "List[Source]"):
        """Sets the active_sources_using of this ConnectionResponse.


        :param active_sources_using: The active_sources_using of this ConnectionResponse.
        :type: List[Source]
        """
        self._attrs["activeSourcesUsing"] = active_sources_using

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this ConnectionResponse.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this ConnectionResponse.


        :param connector_id: The connector_id of this ConnectionResponse.
        :type: str
        """
        self._attrs["connectorId"] = connector_id

    @property
    def connector_name(self) -> "str":
        """ Gets the connector_name of this ConnectionResponse.
        """
        return self._attrs.get("connectorName")

    @connector_name.setter
    def connector_name(self, connector_name: "str"):
        """Sets the connector_name of this ConnectionResponse.


        :param connector_name: The connector_name of this ConnectionResponse.
        :type: str
        """
        self._attrs["connectorName"] = connector_name

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this ConnectionResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this ConnectionResponse.


        :param create_date: The create_date of this ConnectionResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this ConnectionResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this ConnectionResponse.


        :param create_user_id: The create_user_id of this ConnectionResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def id(self) -> "str":
        """ Gets the id of this ConnectionResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ConnectionResponse.


        :param id: The id of this ConnectionResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def last_update_date(self) -> "int":
        """ Gets the last_update_date of this ConnectionResponse.
        """
        return self._attrs.get("lastUpdateDate")

    @last_update_date.setter
    def last_update_date(self, last_update_date: "int"):
        """Sets the last_update_date of this ConnectionResponse.


        :param last_update_date: The last_update_date of this ConnectionResponse.
        :type: int
        """
        self._attrs["lastUpdateDate"] = last_update_date

    @property
    def last_update_user_id(self) -> "str":
        """ Gets the last_update_user_id of this ConnectionResponse.
        """
        return self._attrs.get("lastUpdateUserId")

    @last_update_user_id.setter
    def last_update_user_id(self, last_update_user_id: "str"):
        """Sets the last_update_user_id of this ConnectionResponse.


        :param last_update_user_id: The last_update_user_id of this ConnectionResponse.
        :type: str
        """
        self._attrs["lastUpdateUserId"] = last_update_user_id

    @property
    def versions(self) -> "List[ConnectionVersionResponse]":
        """ Gets the versions of this ConnectionResponse.
        """
        return [ConnectionVersionResponse._from_dict(i) for i in self._attrs.get("versions")]

    @versions.setter
    def versions(self, versions: "List[ConnectionVersionResponse]"):
        """Sets the versions of this ConnectionResponse.


        :param versions: The versions of this ConnectionResponse.
        :type: List[ConnectionVersionResponse]
        """
        self._attrs["versions"] = versions

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectionSaveResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectionSaveResponse":
        instance = ConnectionSaveResponse.__new__(ConnectionSaveResponse)
        instance._attrs = model
        return instance

    def __init__(self, connector_id: "str" = None, create_date: "int" = None, create_user_id: "str" = None, data: "object" = None, description: "str" = None, id: "str" = None, messages: "List[str]" = None, name: "str" = None, version: "int" = None, **extra):
        """ConnectionSaveResponse"""

        self._attrs = dict()
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data
        if description is not None:
            self._attrs["description"] = description
        if id is not None:
            self._attrs["id"] = id
        if messages is not None:
            self._attrs["messages"] = messages
        if name is not None:
            self._attrs["name"] = name
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this ConnectionSaveResponse.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this ConnectionSaveResponse.


        :param connector_id: The connector_id of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["connectorId"] = connector_id

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this ConnectionSaveResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this ConnectionSaveResponse.


        :param create_date: The create_date of this ConnectionSaveResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this ConnectionSaveResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this ConnectionSaveResponse.


        :param create_user_id: The create_user_id of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "dict":
        """ Gets the data of this ConnectionSaveResponse.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ConnectionSaveResponse.


        :param data: The data of this ConnectionSaveResponse.
        :type: object
        """
        self._attrs["data"] = data

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectionSaveResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectionSaveResponse.


        :param description: The description of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def id(self) -> "str":
        """ Gets the id of this ConnectionSaveResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ConnectionSaveResponse.


        :param id: The id of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def messages(self) -> "List[str]":
        """ Gets the messages of this ConnectionSaveResponse.
        """
        return self._attrs.get("messages")

    @messages.setter
    def messages(self, messages: "List[str]"):
        """Sets the messages of this ConnectionSaveResponse.


        :param messages: The messages of this ConnectionSaveResponse.
        :type: List[str]
        """
        self._attrs["messages"] = messages

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectionSaveResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectionSaveResponse.


        :param name: The name of this ConnectionSaveResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def version(self) -> "int":
        """ Gets the version of this ConnectionSaveResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this ConnectionSaveResponse.


        :param version: The version of this ConnectionSaveResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ConnectorResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ConnectorResponse":
        instance = ConnectorResponse.__new__(ConnectorResponse)
        instance._attrs = model
        return instance

    def __init__(self, attributes: "object" = None, config: "object" = None, connector_type: "str" = None, description: "str" = None, functions: "List[object]" = None, hidden: "bool" = None, id: "str" = None, metadata: "object" = None, name: "str" = None, panel_url: "str" = None, tag: "str" = None, **extra):
        """ConnectorResponse"""

        self._attrs = dict()
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if config is not None:
            self._attrs["config"] = config
        if connector_type is not None:
            self._attrs["connectorType"] = connector_type
        if description is not None:
            self._attrs["description"] = description
        if functions is not None:
            self._attrs["functions"] = functions
        if hidden is not None:
            self._attrs["hidden"] = hidden
        if id is not None:
            self._attrs["id"] = id
        if metadata is not None:
            self._attrs["metadata"] = metadata
        if name is not None:
            self._attrs["name"] = name
        if panel_url is not None:
            self._attrs["panelUrl"] = panel_url
        if tag is not None:
            self._attrs["tag"] = tag
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this ConnectorResponse.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this ConnectorResponse.


        :param attributes: The attributes of this ConnectorResponse.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def config(self) -> "dict":
        """ Gets the config of this ConnectorResponse.
        """
        return self._attrs.get("config")

    @config.setter
    def config(self, config: "dict"):
        """Sets the config of this ConnectorResponse.


        :param config: The config of this ConnectorResponse.
        :type: object
        """
        self._attrs["config"] = config

    @property
    def connector_type(self) -> "str":
        """ Gets the connector_type of this ConnectorResponse.
        """
        return self._attrs.get("connectorType")

    @connector_type.setter
    def connector_type(self, connector_type: "str"):
        """Sets the connector_type of this ConnectorResponse.


        :param connector_type: The connector_type of this ConnectorResponse.
        :type: str
        """
        self._attrs["connectorType"] = connector_type

    @property
    def description(self) -> "str":
        """ Gets the description of this ConnectorResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this ConnectorResponse.


        :param description: The description of this ConnectorResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def functions(self) -> "List[object]":
        """ Gets the functions of this ConnectorResponse.
        """
        return self._attrs.get("functions")

    @functions.setter
    def functions(self, functions: "List[object]"):
        """Sets the functions of this ConnectorResponse.


        :param functions: The functions of this ConnectorResponse.
        :type: List[object]
        """
        self._attrs["functions"] = functions

    @property
    def hidden(self) -> "bool":
        """ Gets the hidden of this ConnectorResponse.
        """
        return self._attrs.get("hidden")

    @hidden.setter
    def hidden(self, hidden: "bool"):
        """Sets the hidden of this ConnectorResponse.


        :param hidden: The hidden of this ConnectorResponse.
        :type: bool
        """
        self._attrs["hidden"] = hidden

    @property
    def id(self) -> "str":
        """ Gets the id of this ConnectorResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this ConnectorResponse.


        :param id: The id of this ConnectorResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def metadata(self) -> "dict":
        """ Gets the metadata of this ConnectorResponse.
        """
        return self._attrs.get("metadata")

    @metadata.setter
    def metadata(self, metadata: "dict"):
        """Sets the metadata of this ConnectorResponse.


        :param metadata: The metadata of this ConnectorResponse.
        :type: object
        """
        self._attrs["metadata"] = metadata

    @property
    def name(self) -> "str":
        """ Gets the name of this ConnectorResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this ConnectorResponse.


        :param name: The name of this ConnectorResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def panel_url(self) -> "str":
        """ Gets the panel_url of this ConnectorResponse.
        """
        return self._attrs.get("panelUrl")

    @panel_url.setter
    def panel_url(self, panel_url: "str"):
        """Sets the panel_url of this ConnectorResponse.


        :param panel_url: The panel_url of this ConnectorResponse.
        :type: str
        """
        self._attrs["panelUrl"] = panel_url

    @property
    def tag(self) -> "str":
        """ Gets the tag of this ConnectorResponse.
        """
        return self._attrs.get("tag")

    @tag.setter
    def tag(self, tag: "str"):
        """Sets the tag of this ConnectorResponse.


        :param tag: The tag of this ConnectorResponse.
        :type: str
        """
        self._attrs["tag"] = tag

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DeactivatePipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DeactivatePipelineRequest":
        instance = DeactivatePipelineRequest.__new__(DeactivatePipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, skip_savepoint: "bool" = None, **extra):
        """DeactivatePipelineRequest"""

        self._attrs = dict()
        if skip_savepoint is not None:
            self._attrs["skipSavepoint"] = skip_savepoint
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def skip_savepoint(self) -> "bool":
        """ Gets the skip_savepoint of this DeactivatePipelineRequest.
        Set to true to skip saving the state of a deactivated pipeline. When the pipeline is later activated, it will start with the newest data and skip any data that arrived after this deactivation, which can cause data loss. Defaults to false.
        """
        return self._attrs.get("skipSavepoint")

    @skip_savepoint.setter
    def skip_savepoint(self, skip_savepoint: "bool"):
        """Sets the skip_savepoint of this DeactivatePipelineRequest.

        Set to true to skip saving the state of a deactivated pipeline. When the pipeline is later activated, it will start with the newest data and skip any data that arrived after this deactivation, which can cause data loss. Defaults to false.

        :param skip_savepoint: The skip_savepoint of this DeactivatePipelineRequest.
        :type: bool
        """
        self._attrs["skipSavepoint"] = skip_savepoint

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Pipeline(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Pipeline":
        instance = Pipeline.__new__(Pipeline)
        instance._attrs = model
        return instance

    def __init__(self, edges: "List[PipelineEdge]", nodes: "List[PipelineNode]", attributes: "object" = None, migration_info: "PipelineMigrationInfo" = None, **extra):
        """Pipeline"""

        self._attrs = dict()
        if edges is not None:
            self._attrs["edges"] = edges
        if nodes is not None:
            self._attrs["nodes"] = nodes
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if migration_info is not None:
            self._attrs["migrationInfo"] = migration_info.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def edges(self) -> "List[PipelineEdge]":
        """ Gets the edges of this Pipeline.
        A list of links between the output of one pipeline function and the input of another pipeline function.
        """
        return [PipelineEdge._from_dict(i) for i in self._attrs.get("edges")]

    @edges.setter
    def edges(self, edges: "List[PipelineEdge]"):
        """Sets the edges of this Pipeline.

        A list of links between the output of one pipeline function and the input of another pipeline function.

        :param edges: The edges of this Pipeline.
        :type: List[PipelineEdge]
        """
        if edges is None:
            raise ValueError("Invalid value for `edges`, must not be `None`")
        self._attrs["edges"] = edges

    @property
    def nodes(self) -> "List[PipelineNode]":
        """ Gets the nodes of this Pipeline.
        The functions in your entire pipeline, including each function's operations, attributes, and properties.
        """
        return [PipelineNode._from_dict(i) for i in self._attrs.get("nodes")]

    @nodes.setter
    def nodes(self, nodes: "List[PipelineNode]"):
        """Sets the nodes of this Pipeline.

        The functions in your entire pipeline, including each function's operations, attributes, and properties.

        :param nodes: The nodes of this Pipeline.
        :type: List[PipelineNode]
        """
        if nodes is None:
            raise ValueError("Invalid value for `nodes`, must not be `None`")
        self._attrs["nodes"] = nodes

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this Pipeline.
        Optional metadata specified by client. Not to be interpreted by the platform
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this Pipeline.

        Optional metadata specified by client. Not to be interpreted by the platform

        :param attributes: The attributes of this Pipeline.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def migration_info(self) -> "PipelineMigrationInfo":
        """ Gets the migration_info of this Pipeline.
        """
        return PipelineMigrationInfo._from_dict(self._attrs["migrationInfo"])

    @migration_info.setter
    def migration_info(self, migration_info: "PipelineMigrationInfo"):
        """Sets the migration_info of this Pipeline.


        :param migration_info: The migration_info of this Pipeline.
        :type: PipelineMigrationInfo
        """
        self._attrs["migrationInfo"] = migration_info.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineEdge(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineEdge":
        instance = PipelineEdge.__new__(PipelineEdge)
        instance._attrs = model
        return instance

    def __init__(self, source_node: "str" = None, source_port: "str" = None, target_node: "str" = None, target_port: "str" = None, **extra):
        """PipelineEdge"""

        self._attrs = dict()
        if source_node is not None:
            self._attrs["sourceNode"] = source_node
        if source_port is not None:
            self._attrs["sourcePort"] = source_port
        if target_node is not None:
            self._attrs["targetNode"] = target_node
        if target_port is not None:
            self._attrs["targetPort"] = target_port
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def source_node(self) -> "str":
        """ Gets the source_node of this PipelineEdge.
        """
        return self._attrs.get("sourceNode")

    @source_node.setter
    def source_node(self, source_node: "str"):
        """Sets the source_node of this PipelineEdge.


        :param source_node: The source_node of this PipelineEdge.
        :type: str
        """
        self._attrs["sourceNode"] = source_node

    @property
    def source_port(self) -> "str":
        """ Gets the source_port of this PipelineEdge.
        """
        return self._attrs.get("sourcePort")

    @source_port.setter
    def source_port(self, source_port: "str"):
        """Sets the source_port of this PipelineEdge.


        :param source_port: The source_port of this PipelineEdge.
        :type: str
        """
        self._attrs["sourcePort"] = source_port

    @property
    def target_node(self) -> "str":
        """ Gets the target_node of this PipelineEdge.
        """
        return self._attrs.get("targetNode")

    @target_node.setter
    def target_node(self, target_node: "str"):
        """Sets the target_node of this PipelineEdge.


        :param target_node: The target_node of this PipelineEdge.
        :type: str
        """
        self._attrs["targetNode"] = target_node

    @property
    def target_port(self) -> "str":
        """ Gets the target_port of this PipelineEdge.
        """
        return self._attrs.get("targetPort")

    @target_port.setter
    def target_port(self, target_port: "str"):
        """Sets the target_port of this PipelineEdge.


        :param target_port: The target_port of this PipelineEdge.
        :type: str
        """
        self._attrs["targetPort"] = target_port

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineNode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineNode":
        instance = PipelineNode.__new__(PipelineNode)
        instance._attrs = model
        return instance

    def __init__(self, id: "str", op: "str", arguments: "object" = None, attributes: "object" = None, resolved_id: "str" = None, statement_name: "str" = None, **extra):
        """PipelineNode"""

        self._attrs = dict()
        if id is not None:
            self._attrs["id"] = id
        if op is not None:
            self._attrs["op"] = op
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if resolved_id is not None:
            self._attrs["resolvedId"] = resolved_id
        if statement_name is not None:
            self._attrs["statementName"] = statement_name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def id(self) -> "str":
        """ Gets the id of this PipelineNode.
        A unique identifier for the function.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this PipelineNode.

        A unique identifier for the function.

        :param id: The id of this PipelineNode.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")
        self._attrs["id"] = id

    @property
    def op(self) -> "str":
        """ Gets the op of this PipelineNode.
        The operation name.
        """
        return self._attrs.get("op")

    @op.setter
    def op(self, op: "str"):
        """Sets the op of this PipelineNode.

        The operation name.

        :param op: The op of this PipelineNode.
        :type: str
        """
        if op is None:
            raise ValueError("Invalid value for `op`, must not be `None`")
        self._attrs["op"] = op

    @property
    def arguments(self) -> "dict":
        """ Gets the arguments of this PipelineNode.
        Function arguments keyed by argument name.
        """
        return self._attrs.get("arguments")

    @arguments.setter
    def arguments(self, arguments: "dict"):
        """Sets the arguments of this PipelineNode.

        Function arguments keyed by argument name.

        :param arguments: The arguments of this PipelineNode.
        :type: object
        """
        self._attrs["arguments"] = arguments

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this PipelineNode.
        For internal use only. This field is ignored.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this PipelineNode.

        For internal use only. This field is ignored.

        :param attributes: The attributes of this PipelineNode.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def resolved_id(self) -> "str":
        """ Gets the resolved_id of this PipelineNode.
        The identifier describing the operation name and required argument types. This field is ignored.
        """
        return self._attrs.get("resolvedId")

    @resolved_id.setter
    def resolved_id(self, resolved_id: "str"):
        """Sets the resolved_id of this PipelineNode.

        The identifier describing the operation name and required argument types. This field is ignored.

        :param resolved_id: The resolved_id of this PipelineNode.
        :type: str
        """
        self._attrs["resolvedId"] = resolved_id

    @property
    def statement_name(self) -> "str":
        """ Gets the statement_name of this PipelineNode.
        If present, creates a named statement when decompiling to SPL2. For example, \"$events = | from splunk_firehose();\".
        """
        return self._attrs.get("statementName")

    @statement_name.setter
    def statement_name(self, statement_name: "str"):
        """Sets the statement_name of this PipelineNode.

        If present, creates a named statement when decompiling to SPL2. For example, \"$events = | from splunk_firehose();\".

        :param statement_name: The statement_name of this PipelineNode.
        :type: str
        """
        self._attrs["statementName"] = statement_name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineMigrationInfo(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineMigrationInfo":
        instance = PipelineMigrationInfo.__new__(PipelineMigrationInfo)
        instance._attrs = model
        return instance

    def __init__(self, can_migrate: "bool" = None, create_api_version: "int" = None, target_api_version: "int" = None, **extra):
        """PipelineMigrationInfo"""

        self._attrs = dict()
        if can_migrate is not None:
            self._attrs["canMigrate"] = can_migrate
        if create_api_version is not None:
            self._attrs["createApiVersion"] = create_api_version
        if target_api_version is not None:
            self._attrs["targetApiVersion"] = target_api_version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def can_migrate(self) -> "bool":
        """ Gets the can_migrate of this PipelineMigrationInfo.
        """
        return self._attrs.get("canMigrate")

    @can_migrate.setter
    def can_migrate(self, can_migrate: "bool"):
        """Sets the can_migrate of this PipelineMigrationInfo.


        :param can_migrate: The can_migrate of this PipelineMigrationInfo.
        :type: bool
        """
        self._attrs["canMigrate"] = can_migrate

    @property
    def create_api_version(self) -> "int":
        """ Gets the create_api_version of this PipelineMigrationInfo.
        """
        return self._attrs.get("createApiVersion")

    @create_api_version.setter
    def create_api_version(self, create_api_version: "int"):
        """Sets the create_api_version of this PipelineMigrationInfo.


        :param create_api_version: The create_api_version of this PipelineMigrationInfo.
        :type: int
        """
        self._attrs["createApiVersion"] = create_api_version

    @property
    def target_api_version(self) -> "int":
        """ Gets the target_api_version of this PipelineMigrationInfo.
        """
        return self._attrs.get("targetApiVersion")

    @target_api_version.setter
    def target_api_version(self, target_api_version: "int"):
        """Sets the target_api_version of this PipelineMigrationInfo.


        :param target_api_version: The target_api_version of this PipelineMigrationInfo.
        :type: int
        """
        self._attrs["targetApiVersion"] = target_api_version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DecompileRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DecompileRequest":
        instance = DecompileRequest.__new__(DecompileRequest)
        instance._attrs = model
        return instance

    def __init__(self, upl: "Pipeline", **extra):
        """DecompileRequest"""

        self._attrs = dict()
        if upl is not None:
            self._attrs["upl"] = upl.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def upl(self) -> "Pipeline":
        """ Gets the upl of this DecompileRequest.
        """
        return Pipeline._from_dict(self._attrs["upl"])

    @upl.setter
    def upl(self, upl: "Pipeline"):
        """Sets the upl of this DecompileRequest.


        :param upl: The upl of this DecompileRequest.
        :type: Pipeline
        """
        if upl is None:
            raise ValueError("Invalid value for `upl`, must not be `None`")
        self._attrs["upl"] = upl.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class DecompileResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "DecompileResponse":
        instance = DecompileResponse.__new__(DecompileResponse)
        instance._attrs = model
        return instance

    def __init__(self, spl: "str" = None, **extra):
        """DecompileResponse"""

        self._attrs = dict()
        if spl is not None:
            self._attrs["spl"] = spl
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def spl(self) -> "str":
        """ Gets the spl of this DecompileResponse.
        """
        return self._attrs.get("spl")

    @spl.setter
    def spl(self, spl: "str"):
        """Sets the spl of this DecompileResponse.


        :param spl: The spl of this DecompileResponse.
        :type: str
        """
        self._attrs["spl"] = spl

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ErrorResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ErrorResponse":
        instance = ErrorResponse.__new__(ErrorResponse)
        instance._attrs = model
        return instance

    def __init__(self, code: "str" = None, details: "List[Dict]" = None, message: "str" = None, more_info: "str" = None, **extra):
        """ErrorResponse"""

        self._attrs = dict()
        if code is not None:
            self._attrs["code"] = code
        if details is not None:
            self._attrs["details"] = details
        if message is not None:
            self._attrs["message"] = message
        if more_info is not None:
            self._attrs["moreInfo"] = more_info
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def code(self) -> "str":
        """ Gets the code of this ErrorResponse.
        """
        return self._attrs.get("code")

    @code.setter
    def code(self, code: "str"):
        """Sets the code of this ErrorResponse.


        :param code: The code of this ErrorResponse.
        :type: str
        """
        self._attrs["code"] = code

    @property
    def details(self) -> "List[Dict]":
        """ Gets the details of this ErrorResponse.
        """
        return [Dict._from_dict(i) for i in self._attrs.get("details")]

    @details.setter
    def details(self, details: "List[Dict]"):
        """Sets the details of this ErrorResponse.


        :param details: The details of this ErrorResponse.
        :type: List[Dict]
        """
        self._attrs["details"] = details

    @property
    def message(self) -> "str":
        """ Gets the message of this ErrorResponse.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this ErrorResponse.


        :param message: The message of this ErrorResponse.
        :type: str
        """
        self._attrs["message"] = message

    @property
    def more_info(self) -> "str":
        """ Gets the more_info of this ErrorResponse.
        """
        return self._attrs.get("moreInfo")

    @more_info.setter
    def more_info(self, more_info: "str"):
        """Sets the more_info of this ErrorResponse.


        :param more_info: The more_info of this ErrorResponse.
        :type: str
        """
        self._attrs["moreInfo"] = more_info

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UploadFileResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UploadFileResponse":
        instance = UploadFileResponse.__new__(UploadFileResponse)
        instance._attrs = model
        return instance

    def __init__(self, created_date: "int" = None, created_user_id: "str" = None, filename: "str" = None, id: "str" = None, sha256: "str" = None, tenant_id: "str" = None, **extra):
        """UploadFileResponse"""

        self._attrs = dict()
        if created_date is not None:
            self._attrs["createdDate"] = created_date
        if created_user_id is not None:
            self._attrs["createdUserId"] = created_user_id
        if filename is not None:
            self._attrs["filename"] = filename
        if id is not None:
            self._attrs["id"] = id
        if sha256 is not None:
            self._attrs["sha256"] = sha256
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def created_date(self) -> "int":
        """ Gets the created_date of this UploadFileResponse.
        """
        return self._attrs.get("createdDate")

    @created_date.setter
    def created_date(self, created_date: "int"):
        """Sets the created_date of this UploadFileResponse.


        :param created_date: The created_date of this UploadFileResponse.
        :type: int
        """
        self._attrs["createdDate"] = created_date

    @property
    def created_user_id(self) -> "str":
        """ Gets the created_user_id of this UploadFileResponse.
        """
        return self._attrs.get("createdUserId")

    @created_user_id.setter
    def created_user_id(self, created_user_id: "str"):
        """Sets the created_user_id of this UploadFileResponse.


        :param created_user_id: The created_user_id of this UploadFileResponse.
        :type: str
        """
        self._attrs["createdUserId"] = created_user_id

    @property
    def filename(self) -> "str":
        """ Gets the filename of this UploadFileResponse.
        """
        return self._attrs.get("filename")

    @filename.setter
    def filename(self, filename: "str"):
        """Sets the filename of this UploadFileResponse.


        :param filename: The filename of this UploadFileResponse.
        :type: str
        """
        self._attrs["filename"] = filename

    @property
    def id(self) -> "str":
        """ Gets the id of this UploadFileResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this UploadFileResponse.


        :param id: The id of this UploadFileResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def sha256(self) -> "str":
        """ Gets the sha256 of this UploadFileResponse.
        """
        return self._attrs.get("sha256")

    @sha256.setter
    def sha256(self, sha256: "str"):
        """Sets the sha256 of this UploadFileResponse.


        :param sha256: The sha256 of this UploadFileResponse.
        :type: str
        """
        self._attrs["sha256"] = sha256

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this UploadFileResponse.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this UploadFileResponse.


        :param tenant_id: The tenant_id of this UploadFileResponse.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FilesMetaDataResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FilesMetaDataResponse":
        instance = FilesMetaDataResponse.__new__(FilesMetaDataResponse)
        instance._attrs = model
        return instance

    def __init__(self, files: "List[UploadFileResponse]" = None, **extra):
        """FilesMetaDataResponse"""

        self._attrs = dict()
        if files is not None:
            self._attrs["files"] = files
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def files(self) -> "List[UploadFileResponse]":
        """ Gets the files of this FilesMetaDataResponse.
        """
        return [UploadFileResponse._from_dict(i) for i in self._attrs.get("files")]

    @files.setter
    def files(self, files: "List[UploadFileResponse]"):
        """Sets the files of this FilesMetaDataResponse.


        :param files: The files of this FilesMetaDataResponse.
        :type: List[UploadFileResponse]
        """
        self._attrs["files"] = files

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class FunctionModel(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "FunctionModel":
        instance = FunctionModel.__new__(FunctionModel)
        instance._attrs = model
        return instance

    def __init__(self, arguments: "List[ArgumentModel]" = None, attributes: "object" = None, op: "str" = None, outputs: "List[ArgumentModel]" = None, resolved_id: "str" = None, **extra):
        """FunctionModel"""

        self._attrs = dict()
        if arguments is not None:
            self._attrs["arguments"] = arguments
        if attributes is not None:
            self._attrs["attributes"] = attributes
        if op is not None:
            self._attrs["op"] = op
        if outputs is not None:
            self._attrs["outputs"] = outputs
        if resolved_id is not None:
            self._attrs["resolvedId"] = resolved_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def arguments(self) -> "List[ArgumentModel]":
        """ Gets the arguments of this FunctionModel.
        """
        return [ArgumentModel._from_dict(i) for i in self._attrs.get("arguments")]

    @arguments.setter
    def arguments(self, arguments: "List[ArgumentModel]"):
        """Sets the arguments of this FunctionModel.


        :param arguments: The arguments of this FunctionModel.
        :type: List[ArgumentModel]
        """
        self._attrs["arguments"] = arguments

    @property
    def attributes(self) -> "dict":
        """ Gets the attributes of this FunctionModel.
        """
        return self._attrs.get("attributes")

    @attributes.setter
    def attributes(self, attributes: "dict"):
        """Sets the attributes of this FunctionModel.


        :param attributes: The attributes of this FunctionModel.
        :type: object
        """
        self._attrs["attributes"] = attributes

    @property
    def op(self) -> "str":
        """ Gets the op of this FunctionModel.
        """
        return self._attrs.get("op")

    @op.setter
    def op(self, op: "str"):
        """Sets the op of this FunctionModel.


        :param op: The op of this FunctionModel.
        :type: str
        """
        self._attrs["op"] = op

    @property
    def outputs(self) -> "List[ArgumentModel]":
        """ Gets the outputs of this FunctionModel.
        """
        return [ArgumentModel._from_dict(i) for i in self._attrs.get("outputs")]

    @outputs.setter
    def outputs(self, outputs: "List[ArgumentModel]"):
        """Sets the outputs of this FunctionModel.


        :param outputs: The outputs of this FunctionModel.
        :type: List[ArgumentModel]
        """
        self._attrs["outputs"] = outputs

    @property
    def resolved_id(self) -> "str":
        """ Gets the resolved_id of this FunctionModel.
        """
        return self._attrs.get("resolvedId")

    @resolved_id.setter
    def resolved_id(self, resolved_id: "str"):
        """Sets the resolved_id of this FunctionModel.


        :param resolved_id: The resolved_id of this FunctionModel.
        :type: str
        """
        self._attrs["resolvedId"] = resolved_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GetInputSchemaRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GetInputSchemaRequest":
        instance = GetInputSchemaRequest.__new__(GetInputSchemaRequest)
        instance._attrs = model
        return instance

    def __init__(self, node_uuid: "str", target_port_name: "str", upl_json: "Pipeline", **extra):
        """GetInputSchemaRequest"""

        self._attrs = dict()
        if node_uuid is not None:
            self._attrs["nodeUuid"] = node_uuid
        if target_port_name is not None:
            self._attrs["targetPortName"] = target_port_name
        if upl_json is not None:
            self._attrs["uplJson"] = upl_json.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def node_uuid(self) -> "str":
        """ Gets the node_uuid of this GetInputSchemaRequest.
        The function ID.
        """
        return self._attrs.get("nodeUuid")

    @node_uuid.setter
    def node_uuid(self, node_uuid: "str"):
        """Sets the node_uuid of this GetInputSchemaRequest.

        The function ID.

        :param node_uuid: The node_uuid of this GetInputSchemaRequest.
        :type: str
        """
        if node_uuid is None:
            raise ValueError("Invalid value for `node_uuid`, must not be `None`")
        self._attrs["nodeUuid"] = node_uuid

    @property
    def target_port_name(self) -> "str":
        """ Gets the target_port_name of this GetInputSchemaRequest.
        The name of the input port.
        """
        return self._attrs.get("targetPortName")

    @target_port_name.setter
    def target_port_name(self, target_port_name: "str"):
        """Sets the target_port_name of this GetInputSchemaRequest.

        The name of the input port.

        :param target_port_name: The target_port_name of this GetInputSchemaRequest.
        :type: str
        """
        if target_port_name is None:
            raise ValueError("Invalid value for `target_port_name`, must not be `None`")
        self._attrs["targetPortName"] = target_port_name

    @property
    def upl_json(self) -> "Pipeline":
        """ Gets the upl_json of this GetInputSchemaRequest.
        """
        return Pipeline._from_dict(self._attrs["uplJson"])

    @upl_json.setter
    def upl_json(self, upl_json: "Pipeline"):
        """Sets the upl_json of this GetInputSchemaRequest.


        :param upl_json: The upl_json of this GetInputSchemaRequest.
        :type: Pipeline
        """
        if upl_json is None:
            raise ValueError("Invalid value for `upl_json`, must not be `None`")
        self._attrs["uplJson"] = upl_json.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class GetOutputSchemaRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "GetOutputSchemaRequest":
        instance = GetOutputSchemaRequest.__new__(GetOutputSchemaRequest)
        instance._attrs = model
        return instance

    def __init__(self, upl_json: "Pipeline", node_uuid: "str" = None, source_port_name: "str" = None, **extra):
        """GetOutputSchemaRequest"""

        self._attrs = dict()
        if upl_json is not None:
            self._attrs["uplJson"] = upl_json.to_dict()
        if node_uuid is not None:
            self._attrs["nodeUuid"] = node_uuid
        if source_port_name is not None:
            self._attrs["sourcePortName"] = source_port_name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def upl_json(self) -> "Pipeline":
        """ Gets the upl_json of this GetOutputSchemaRequest.
        """
        return Pipeline._from_dict(self._attrs["uplJson"])

    @upl_json.setter
    def upl_json(self, upl_json: "Pipeline"):
        """Sets the upl_json of this GetOutputSchemaRequest.


        :param upl_json: The upl_json of this GetOutputSchemaRequest.
        :type: Pipeline
        """
        if upl_json is None:
            raise ValueError("Invalid value for `upl_json`, must not be `None`")
        self._attrs["uplJson"] = upl_json.to_dict()

    @property
    def node_uuid(self) -> "str":
        """ Gets the node_uuid of this GetOutputSchemaRequest.
        The function ID. If omitted, returns the output schema for all functions.
        """
        return self._attrs.get("nodeUuid")

    @node_uuid.setter
    def node_uuid(self, node_uuid: "str"):
        """Sets the node_uuid of this GetOutputSchemaRequest.

        The function ID. If omitted, returns the output schema for all functions.

        :param node_uuid: The node_uuid of this GetOutputSchemaRequest.
        :type: str
        """
        self._attrs["nodeUuid"] = node_uuid

    @property
    def source_port_name(self) -> "str":
        """ Gets the source_port_name of this GetOutputSchemaRequest.
        The name of the output port. Deprecated.
        """
        return self._attrs.get("sourcePortName")

    @source_port_name.setter
    def source_port_name(self, source_port_name: "str"):
        """Sets the source_port_name of this GetOutputSchemaRequest.

        The name of the output port. Deprecated.

        :param source_port_name: The source_port_name of this GetOutputSchemaRequest.
        :type: str
        """
        self._attrs["sourcePortName"] = source_port_name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class LookupTableResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "LookupTableResponse":
        instance = LookupTableResponse.__new__(LookupTableResponse)
        instance._attrs = model
        return instance

    def __init__(self, data: "List[object]" = None, types: "Dict[str, str]" = None, **extra):
        """LookupTableResponse"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data
        if types is not None:
            self._attrs["types"] = types
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "List[object]":
        """ Gets the data of this LookupTableResponse.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "List[object]"):
        """Sets the data of this LookupTableResponse.


        :param data: The data of this LookupTableResponse.
        :type: List[object]
        """
        self._attrs["data"] = data

    @property
    def types(self) -> "Dict[str, str]":
        """ Gets the types of this LookupTableResponse.
        """
        return self._attrs.get("types")

    @types.setter
    def types(self, types: "Dict[str, str]"):
        """Sets the types of this LookupTableResponse.


        :param types: The types of this LookupTableResponse.
        :type: Dict[str, str]
        """
        self._attrs["types"] = types

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class NodeMetrics(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "NodeMetrics":
        instance = NodeMetrics.__new__(NodeMetrics)
        instance._attrs = model
        return instance

    def __init__(self, metrics: "object" = None, **extra):
        """NodeMetrics"""

        self._attrs = dict()
        if metrics is not None:
            self._attrs["metrics"] = metrics
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def metrics(self) -> "dict":
        """ Gets the metrics of this NodeMetrics.
        """
        return self._attrs.get("metrics")

    @metrics.setter
    def metrics(self, metrics: "dict"):
        """Sets the metrics of this NodeMetrics.


        :param metrics: The metrics of this NodeMetrics.
        :type: object
        """
        self._attrs["metrics"] = metrics

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class MetricsResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "MetricsResponse":
        instance = MetricsResponse.__new__(MetricsResponse)
        instance._attrs = model
        return instance

    def __init__(self, nodes: "Dict[str, NodeMetrics]" = None, **extra):
        """MetricsResponse"""

        self._attrs = dict()
        if nodes is not None:
            self._attrs["nodes"] = nodes
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def nodes(self) -> "Dict[str, NodeMetrics]":
        """ Gets the nodes of this MetricsResponse.
        """
        return self._attrs.get("nodes")

    @nodes.setter
    def nodes(self, nodes: "Dict[str, NodeMetrics]"):
        """Sets the nodes of this MetricsResponse.


        :param nodes: The nodes of this MetricsResponse.
        :type: Dict[str, NodeMetrics]
        """
        self._attrs["nodes"] = nodes

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfConnectionResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfConnectionResponse":
        instance = PaginatedResponseOfConnectionResponse.__new__(PaginatedResponseOfConnectionResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[ConnectionResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfConnectionResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[ConnectionResponse]":
        """ Gets the items of this PaginatedResponseOfConnectionResponse.
        """
        return [ConnectionResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[ConnectionResponse]"):
        """Sets the items of this PaginatedResponseOfConnectionResponse.


        :param items: The items of this PaginatedResponseOfConnectionResponse.
        :type: List[ConnectionResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfConnectionResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfConnectionResponse.


        :param total: The total of this PaginatedResponseOfConnectionResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfConnectorResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfConnectorResponse":
        instance = PaginatedResponseOfConnectorResponse.__new__(PaginatedResponseOfConnectorResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[ConnectorResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfConnectorResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[ConnectorResponse]":
        """ Gets the items of this PaginatedResponseOfConnectorResponse.
        """
        return [ConnectorResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[ConnectorResponse]"):
        """Sets the items of this PaginatedResponseOfConnectorResponse.


        :param items: The items of this PaginatedResponseOfConnectorResponse.
        :type: List[ConnectorResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfConnectorResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfConnectorResponse.


        :param total: The total of this PaginatedResponseOfConnectorResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineJobStatus(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineJobStatus":
        instance = PipelineJobStatus.__new__(PipelineJobStatus)
        instance._attrs = model
        return instance

    def __init__(self, job_id: "str" = None, job_status: "str" = None, pipeline_id: "str" = None, **extra):
        """PipelineJobStatus"""

        self._attrs = dict()
        if job_id is not None:
            self._attrs["jobId"] = job_id
        if job_status is not None:
            self._attrs["jobStatus"] = job_status
        if pipeline_id is not None:
            self._attrs["pipelineId"] = pipeline_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def job_id(self) -> "str":
        """ Gets the job_id of this PipelineJobStatus.
        """
        return self._attrs.get("jobId")

    @job_id.setter
    def job_id(self, job_id: "str"):
        """Sets the job_id of this PipelineJobStatus.


        :param job_id: The job_id of this PipelineJobStatus.
        :type: str
        """
        self._attrs["jobId"] = job_id

    @property
    def job_status(self) -> "str":
        """ Gets the job_status of this PipelineJobStatus.
        """
        return self._attrs.get("jobStatus")

    @job_status.setter
    def job_status(self, job_status: "str"):
        """Sets the job_status of this PipelineJobStatus.


        :param job_status: The job_status of this PipelineJobStatus.
        :type: str
        """
        self._attrs["jobStatus"] = job_status

    @property
    def pipeline_id(self) -> "str":
        """ Gets the pipeline_id of this PipelineJobStatus.
        """
        return self._attrs.get("pipelineId")

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id: "str"):
        """Sets the pipeline_id of this PipelineJobStatus.


        :param pipeline_id: The pipeline_id of this PipelineJobStatus.
        :type: str
        """
        self._attrs["pipelineId"] = pipeline_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfPipelineJobStatus(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfPipelineJobStatus":
        instance = PaginatedResponseOfPipelineJobStatus.__new__(PaginatedResponseOfPipelineJobStatus)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[PipelineJobStatus]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfPipelineJobStatus"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[PipelineJobStatus]":
        """ Gets the items of this PaginatedResponseOfPipelineJobStatus.
        """
        return [PipelineJobStatus._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[PipelineJobStatus]"):
        """Sets the items of this PaginatedResponseOfPipelineJobStatus.


        :param items: The items of this PaginatedResponseOfPipelineJobStatus.
        :type: List[PipelineJobStatus]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfPipelineJobStatus.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfPipelineJobStatus.


        :param total: The total of this PaginatedResponseOfPipelineJobStatus.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class StatusEnum(str, Enum):
    CREATED = "CREATED"
    ACTIVATED = "ACTIVATED"
    FAILED = "FAILED"
    RESTARTING = "RESTARTING"
    FINISHED = "FINISHED"
    ACTIVATING = "ACTIVATING"
    DEACTIVATING = "DEACTIVATING"

    @staticmethod
    def from_value(value: str):
        if value == "CREATED":
            return StatusEnum.CREATED
        if value == "ACTIVATED":
            return StatusEnum.ACTIVATED
        if value == "FAILED":
            return StatusEnum.FAILED
        if value == "RESTARTING":
            return StatusEnum.RESTARTING
        if value == "FINISHED":
            return StatusEnum.FINISHED
        if value == "ACTIVATING":
            return StatusEnum.ACTIVATING
        if value == "DEACTIVATING":
            return StatusEnum.DEACTIVATING


class PipelineResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineResponse":
        instance = PipelineResponse.__new__(PipelineResponse)
        instance._attrs = model
        return instance

    def __init__(self, activated_date: "int" = None, activated_user_id: "str" = None, activated_version: "int" = None, complexity: "float" = None, create_date: "int" = None, create_user_id: "str" = None, current_version: "int" = None, data: "Pipeline" = None, description: "str" = None, id: "str" = None, labels: "Dict[str, str]" = None, last_update_date: "int" = None, last_update_user_id: "str" = None, name: "str" = None, status: "str" = None, status_message: "str" = None, streaming_configuration_id: "int" = None, tenant_id: "str" = None, uber_jar_sha256: "str" = None, validation_messages: "List[str]" = None, version: "int" = None, **extra):
        """PipelineResponse"""

        self._attrs = dict()
        if activated_date is not None:
            self._attrs["activatedDate"] = activated_date
        if activated_user_id is not None:
            self._attrs["activatedUserId"] = activated_user_id
        if activated_version is not None:
            self._attrs["activatedVersion"] = activated_version
        if complexity is not None:
            self._attrs["complexity"] = complexity
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if current_version is not None:
            self._attrs["currentVersion"] = current_version
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if id is not None:
            self._attrs["id"] = id
        if labels is not None:
            self._attrs["labels"] = labels
        if last_update_date is not None:
            self._attrs["lastUpdateDate"] = last_update_date
        if last_update_user_id is not None:
            self._attrs["lastUpdateUserId"] = last_update_user_id
        if name is not None:
            self._attrs["name"] = name
        if status is not None:
            self._attrs["status"] = status
        if status_message is not None:
            self._attrs["statusMessage"] = status_message
        if streaming_configuration_id is not None:
            self._attrs["streamingConfigurationId"] = streaming_configuration_id
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        if uber_jar_sha256 is not None:
            self._attrs["uberJarSha256"] = uber_jar_sha256
        if validation_messages is not None:
            self._attrs["validationMessages"] = validation_messages
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activated_date(self) -> "int":
        """ Gets the activated_date of this PipelineResponse.
        """
        return self._attrs.get("activatedDate")

    @activated_date.setter
    def activated_date(self, activated_date: "int"):
        """Sets the activated_date of this PipelineResponse.


        :param activated_date: The activated_date of this PipelineResponse.
        :type: int
        """
        self._attrs["activatedDate"] = activated_date

    @property
    def activated_user_id(self) -> "str":
        """ Gets the activated_user_id of this PipelineResponse.
        """
        return self._attrs.get("activatedUserId")

    @activated_user_id.setter
    def activated_user_id(self, activated_user_id: "str"):
        """Sets the activated_user_id of this PipelineResponse.


        :param activated_user_id: The activated_user_id of this PipelineResponse.
        :type: str
        """
        self._attrs["activatedUserId"] = activated_user_id

    @property
    def activated_version(self) -> "int":
        """ Gets the activated_version of this PipelineResponse.
        """
        return self._attrs.get("activatedVersion")

    @activated_version.setter
    def activated_version(self, activated_version: "int"):
        """Sets the activated_version of this PipelineResponse.


        :param activated_version: The activated_version of this PipelineResponse.
        :type: int
        """
        self._attrs["activatedVersion"] = activated_version

    @property
    def complexity(self) -> "float":
        """ Gets the complexity of this PipelineResponse.
        """
        return self._attrs.get("complexity")

    @complexity.setter
    def complexity(self, complexity: "float"):
        """Sets the complexity of this PipelineResponse.


        :param complexity: The complexity of this PipelineResponse.
        :type: float
        """
        self._attrs["complexity"] = complexity

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this PipelineResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this PipelineResponse.


        :param create_date: The create_date of this PipelineResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this PipelineResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this PipelineResponse.


        :param create_user_id: The create_user_id of this PipelineResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def current_version(self) -> "int":
        """ Gets the current_version of this PipelineResponse.
        """
        return self._attrs.get("currentVersion")

    @current_version.setter
    def current_version(self, current_version: "int"):
        """Sets the current_version of this PipelineResponse.


        :param current_version: The current_version of this PipelineResponse.
        :type: int
        """
        self._attrs["currentVersion"] = current_version

    @property
    def data(self) -> "Pipeline":
        """ Gets the data of this PipelineResponse.
        """
        return Pipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "Pipeline"):
        """Sets the data of this PipelineResponse.


        :param data: The data of this PipelineResponse.
        :type: Pipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this PipelineResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this PipelineResponse.


        :param description: The description of this PipelineResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def id(self) -> "str":
        """ Gets the id of this PipelineResponse.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this PipelineResponse.


        :param id: The id of this PipelineResponse.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def labels(self) -> "Dict[str, str]":
        """ Gets the labels of this PipelineResponse.
        """
        return self._attrs.get("labels")

    @labels.setter
    def labels(self, labels: "Dict[str, str]"):
        """Sets the labels of this PipelineResponse.


        :param labels: The labels of this PipelineResponse.
        :type: Dict[str, str]
        """
        self._attrs["labels"] = labels

    @property
    def last_update_date(self) -> "int":
        """ Gets the last_update_date of this PipelineResponse.
        """
        return self._attrs.get("lastUpdateDate")

    @last_update_date.setter
    def last_update_date(self, last_update_date: "int"):
        """Sets the last_update_date of this PipelineResponse.


        :param last_update_date: The last_update_date of this PipelineResponse.
        :type: int
        """
        self._attrs["lastUpdateDate"] = last_update_date

    @property
    def last_update_user_id(self) -> "str":
        """ Gets the last_update_user_id of this PipelineResponse.
        """
        return self._attrs.get("lastUpdateUserId")

    @last_update_user_id.setter
    def last_update_user_id(self, last_update_user_id: "str"):
        """Sets the last_update_user_id of this PipelineResponse.


        :param last_update_user_id: The last_update_user_id of this PipelineResponse.
        :type: str
        """
        self._attrs["lastUpdateUserId"] = last_update_user_id

    @property
    def name(self) -> "str":
        """ Gets the name of this PipelineResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this PipelineResponse.


        :param name: The name of this PipelineResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def status(self) -> "StatusEnum":
        """ Gets the status of this PipelineResponse.
        """
        return StatusEnum.from_value(self._attrs.get("status"))

    @status.setter
    def status(self, status: "str"):
        """Sets the status of this PipelineResponse.


        :param status: The status of this PipelineResponse.
        :type: str
        """
        if isinstance(status, Enum):
            self._attrs["status"] = status.value
        else:
            self._attrs["status"] = status  # If you supply a string, we presume you know the service will take it.

    @property
    def status_message(self) -> "str":
        """ Gets the status_message of this PipelineResponse.
        """
        return self._attrs.get("statusMessage")

    @status_message.setter
    def status_message(self, status_message: "str"):
        """Sets the status_message of this PipelineResponse.


        :param status_message: The status_message of this PipelineResponse.
        :type: str
        """
        self._attrs["statusMessage"] = status_message

    @property
    def streaming_configuration_id(self) -> "int":
        """ Gets the streaming_configuration_id of this PipelineResponse.
        """
        return self._attrs.get("streamingConfigurationId")

    @streaming_configuration_id.setter
    def streaming_configuration_id(self, streaming_configuration_id: "int"):
        """Sets the streaming_configuration_id of this PipelineResponse.


        :param streaming_configuration_id: The streaming_configuration_id of this PipelineResponse.
        :type: int
        """
        self._attrs["streamingConfigurationId"] = streaming_configuration_id

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this PipelineResponse.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this PipelineResponse.


        :param tenant_id: The tenant_id of this PipelineResponse.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    @property
    def uber_jar_sha256(self) -> "str":
        """ Gets the uber_jar_sha256 of this PipelineResponse.
        Null prior to initial activation. After deactivation, this field will be set to the SHA at the time of the last activation.
        """
        return self._attrs.get("uberJarSha256")

    @uber_jar_sha256.setter
    def uber_jar_sha256(self, uber_jar_sha256: "str"):
        """Sets the uber_jar_sha256 of this PipelineResponse.

        Null prior to initial activation. After deactivation, this field will be set to the SHA at the time of the last activation.

        :param uber_jar_sha256: The uber_jar_sha256 of this PipelineResponse.
        :type: str
        """
        self._attrs["uberJarSha256"] = uber_jar_sha256

    @property
    def validation_messages(self) -> "List[str]":
        """ Gets the validation_messages of this PipelineResponse.
        """
        return self._attrs.get("validationMessages")

    @validation_messages.setter
    def validation_messages(self, validation_messages: "List[str]"):
        """Sets the validation_messages of this PipelineResponse.


        :param validation_messages: The validation_messages of this PipelineResponse.
        :type: List[str]
        """
        self._attrs["validationMessages"] = validation_messages

    @property
    def version(self) -> "int":
        """ Gets the version of this PipelineResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this PipelineResponse.


        :param version: The version of this PipelineResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfPipelineResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfPipelineResponse":
        instance = PaginatedResponseOfPipelineResponse.__new__(PaginatedResponseOfPipelineResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[PipelineResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfPipelineResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[PipelineResponse]":
        """ Gets the items of this PaginatedResponseOfPipelineResponse.
        """
        return [PipelineResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[PipelineResponse]"):
        """Sets the items of this PaginatedResponseOfPipelineResponse.


        :param items: The items of this PaginatedResponseOfPipelineResponse.
        :type: List[PipelineResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfPipelineResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfPipelineResponse.


        :param total: The total of this PaginatedResponseOfPipelineResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplateResponse":
        instance = TemplateResponse.__new__(TemplateResponse)
        instance._attrs = model
        return instance

    def __init__(self, create_date: "int" = None, create_user_id: "str" = None, data: "Pipeline" = None, description: "str" = None, learn_more_location: "str" = None, name: "str" = None, owner_tenant_id: "str" = None, template_id: "str" = None, version: "int" = None, **extra):
        """TemplateResponse"""

        self._attrs = dict()
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if learn_more_location is not None:
            self._attrs["learnMoreLocation"] = learn_more_location
        if name is not None:
            self._attrs["name"] = name
        if owner_tenant_id is not None:
            self._attrs["ownerTenantId"] = owner_tenant_id
        if template_id is not None:
            self._attrs["templateId"] = template_id
        if version is not None:
            self._attrs["version"] = version
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this TemplateResponse.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this TemplateResponse.


        :param create_date: The create_date of this TemplateResponse.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this TemplateResponse.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this TemplateResponse.


        :param create_user_id: The create_user_id of this TemplateResponse.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "Pipeline":
        """ Gets the data of this TemplateResponse.
        """
        return Pipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "Pipeline"):
        """Sets the data of this TemplateResponse.


        :param data: The data of this TemplateResponse.
        :type: Pipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplateResponse.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplateResponse.


        :param description: The description of this TemplateResponse.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def learn_more_location(self) -> "str":
        """ Gets the learn_more_location of this TemplateResponse.
        """
        return self._attrs.get("learnMoreLocation")

    @learn_more_location.setter
    def learn_more_location(self, learn_more_location: "str"):
        """Sets the learn_more_location of this TemplateResponse.


        :param learn_more_location: The learn_more_location of this TemplateResponse.
        :type: str
        """
        self._attrs["learnMoreLocation"] = learn_more_location

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplateResponse.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplateResponse.


        :param name: The name of this TemplateResponse.
        :type: str
        """
        self._attrs["name"] = name

    @property
    def owner_tenant_id(self) -> "str":
        """ Gets the owner_tenant_id of this TemplateResponse.
        """
        return self._attrs.get("ownerTenantId")

    @owner_tenant_id.setter
    def owner_tenant_id(self, owner_tenant_id: "str"):
        """Sets the owner_tenant_id of this TemplateResponse.


        :param owner_tenant_id: The owner_tenant_id of this TemplateResponse.
        :type: str
        """
        self._attrs["ownerTenantId"] = owner_tenant_id

    @property
    def template_id(self) -> "str":
        """ Gets the template_id of this TemplateResponse.
        """
        return self._attrs.get("templateId")

    @template_id.setter
    def template_id(self, template_id: "str"):
        """Sets the template_id of this TemplateResponse.


        :param template_id: The template_id of this TemplateResponse.
        :type: str
        """
        self._attrs["templateId"] = template_id

    @property
    def version(self) -> "int":
        """ Gets the version of this TemplateResponse.
        """
        return self._attrs.get("version")

    @version.setter
    def version(self, version: "int"):
        """Sets the version of this TemplateResponse.


        :param version: The version of this TemplateResponse.
        :type: int
        """
        self._attrs["version"] = version

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PaginatedResponseOfTemplateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PaginatedResponseOfTemplateResponse":
        instance = PaginatedResponseOfTemplateResponse.__new__(PaginatedResponseOfTemplateResponse)
        instance._attrs = model
        return instance

    def __init__(self, items: "List[TemplateResponse]" = None, total: "int" = None, **extra):
        """PaginatedResponseOfTemplateResponse"""

        self._attrs = dict()
        if items is not None:
            self._attrs["items"] = items
        if total is not None:
            self._attrs["total"] = total
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def items(self) -> "List[TemplateResponse]":
        """ Gets the items of this PaginatedResponseOfTemplateResponse.
        """
        return [TemplateResponse._from_dict(i) for i in self._attrs.get("items")]

    @items.setter
    def items(self, items: "List[TemplateResponse]"):
        """Sets the items of this PaginatedResponseOfTemplateResponse.


        :param items: The items of this PaginatedResponseOfTemplateResponse.
        :type: List[TemplateResponse]
        """
        self._attrs["items"] = items

    @property
    def total(self) -> "int":
        """ Gets the total of this PaginatedResponseOfTemplateResponse.
        """
        return self._attrs.get("total")

    @total.setter
    def total(self, total: "int"):
        """Sets the total of this PaginatedResponseOfTemplateResponse.


        :param total: The total of this PaginatedResponseOfTemplateResponse.
        :type: int
        """
        self._attrs["total"] = total

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelinePatchRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelinePatchRequest":
        instance = PipelinePatchRequest.__new__(PipelinePatchRequest)
        instance._attrs = model
        return instance

    def __init__(self, bypass_validation: "bool" = None, create_user_id: "str" = None, data: "Pipeline" = None, description: "str" = None, labels: "Dict[str, str]" = None, name: "str" = None, **extra):
        """PipelinePatchRequest"""

        self._attrs = dict()
        if bypass_validation is not None:
            self._attrs["bypassValidation"] = bypass_validation
        if create_user_id is not None:
            self._attrs["createUserId"] = create_user_id
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if labels is not None:
            self._attrs["labels"] = labels
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def bypass_validation(self) -> "bool":
        """ Gets the bypass_validation of this PipelinePatchRequest.
        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.
        """
        return self._attrs.get("bypassValidation")

    @bypass_validation.setter
    def bypass_validation(self, bypass_validation: "bool"):
        """Sets the bypass_validation of this PipelinePatchRequest.

        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.

        :param bypass_validation: The bypass_validation of this PipelinePatchRequest.
        :type: bool
        """
        self._attrs["bypassValidation"] = bypass_validation

    @property
    def create_user_id(self) -> "str":
        """ Gets the create_user_id of this PipelinePatchRequest.
        The user that created the pipeline. Deprecated.
        """
        return self._attrs.get("createUserId")

    @create_user_id.setter
    def create_user_id(self, create_user_id: "str"):
        """Sets the create_user_id of this PipelinePatchRequest.

        The user that created the pipeline. Deprecated.

        :param create_user_id: The create_user_id of this PipelinePatchRequest.
        :type: str
        """
        self._attrs["createUserId"] = create_user_id

    @property
    def data(self) -> "Pipeline":
        """ Gets the data of this PipelinePatchRequest.
        """
        return Pipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "Pipeline"):
        """Sets the data of this PipelinePatchRequest.


        :param data: The data of this PipelinePatchRequest.
        :type: Pipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this PipelinePatchRequest.
        The description of the pipeline. Defaults to null.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this PipelinePatchRequest.

        The description of the pipeline. Defaults to null.

        :param description: The description of this PipelinePatchRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def labels(self) -> "Dict[str, str]":
        """ Gets the labels of this PipelinePatchRequest.
        Optional labels in associated with the pipeline. A label is represented by a key and a value.
        """
        return self._attrs.get("labels")

    @labels.setter
    def labels(self, labels: "Dict[str, str]"):
        """Sets the labels of this PipelinePatchRequest.

        Optional labels in associated with the pipeline. A label is represented by a key and a value.

        :param labels: The labels of this PipelinePatchRequest.
        :type: Dict[str, str]
        """
        self._attrs["labels"] = labels

    @property
    def name(self) -> "str":
        """ Gets the name of this PipelinePatchRequest.
        The name of the pipeline.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this PipelinePatchRequest.

        The name of the pipeline.

        :param name: The name of this PipelinePatchRequest.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Pipeline_reactivation_statusEnum(str, Enum):
    ACTIVATED = "activated"
    CURRENTVERSIONINVALID = "currentVersionInvalid"
    FAILEDTODEACTIVATECURRENTVERSION = "failedToDeactivateCurrentVersion"
    NOTACTIVATED = "notActivated"
    ROLLEDBACK = "rolledBack"
    ROLLEDBACKERROR = "rolledBackError"

    @staticmethod
    def from_value(value: str):
        if value == "activated":
            return Pipeline_reactivation_statusEnum.ACTIVATED
        if value == "currentVersionInvalid":
            return Pipeline_reactivation_statusEnum.CURRENTVERSIONINVALID
        if value == "failedToDeactivateCurrentVersion":
            return Pipeline_reactivation_statusEnum.FAILEDTODEACTIVATECURRENTVERSION
        if value == "notActivated":
            return Pipeline_reactivation_statusEnum.NOTACTIVATED
        if value == "rolledBack":
            return Pipeline_reactivation_statusEnum.ROLLEDBACK
        if value == "rolledBackError":
            return Pipeline_reactivation_statusEnum.ROLLEDBACKERROR


class PipelineReactivateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineReactivateResponse":
        instance = PipelineReactivateResponse.__new__(PipelineReactivateResponse)
        instance._attrs = model
        return instance

    def __init__(self, currently_active_version: "int" = None, pipeline_id: "str" = None, pipeline_reactivation_status: "str" = None, status_description: "Dict[str, str]" = None, **extra):
        """PipelineReactivateResponse"""

        self._attrs = dict()
        if currently_active_version is not None:
            self._attrs["currentlyActiveVersion"] = currently_active_version
        if pipeline_id is not None:
            self._attrs["pipelineId"] = pipeline_id
        if pipeline_reactivation_status is not None:
            self._attrs["pipelineReactivationStatus"] = pipeline_reactivation_status
        if status_description is not None:
            self._attrs["statusDescription"] = status_description
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def currently_active_version(self) -> "int":
        """ Gets the currently_active_version of this PipelineReactivateResponse.
        """
        return self._attrs.get("currentlyActiveVersion")

    @currently_active_version.setter
    def currently_active_version(self, currently_active_version: "int"):
        """Sets the currently_active_version of this PipelineReactivateResponse.


        :param currently_active_version: The currently_active_version of this PipelineReactivateResponse.
        :type: int
        """
        self._attrs["currentlyActiveVersion"] = currently_active_version

    @property
    def pipeline_id(self) -> "str":
        """ Gets the pipeline_id of this PipelineReactivateResponse.
        """
        return self._attrs.get("pipelineId")

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id: "str"):
        """Sets the pipeline_id of this PipelineReactivateResponse.


        :param pipeline_id: The pipeline_id of this PipelineReactivateResponse.
        :type: str
        """
        self._attrs["pipelineId"] = pipeline_id

    @property
    def pipeline_reactivation_status(self) -> "Pipeline_reactivation_statusEnum":
        """ Gets the pipeline_reactivation_status of this PipelineReactivateResponse.
        """
        return Pipeline_reactivation_statusEnum.from_value(self._attrs.get("pipelineReactivationStatus"))

    @pipeline_reactivation_status.setter
    def pipeline_reactivation_status(self, pipeline_reactivation_status: "str"):
        """Sets the pipeline_reactivation_status of this PipelineReactivateResponse.


        :param pipeline_reactivation_status: The pipeline_reactivation_status of this PipelineReactivateResponse.
        :type: str
        """
        if isinstance(pipeline_reactivation_status, Enum):
            self._attrs["pipelineReactivationStatus"] = pipeline_reactivation_status.value
        else:
            self._attrs["pipelineReactivationStatus"] = pipeline_reactivation_status  # If you supply a string, we presume you know the service will take it.

    @property
    def status_description(self) -> "Dict[str, str]":
        """ Gets the status_description of this PipelineReactivateResponse.
        """
        return self._attrs.get("statusDescription")

    @status_description.setter
    def status_description(self, status_description: "Dict[str, str]"):
        """Sets the status_description of this PipelineReactivateResponse.


        :param status_description: The status_description of this PipelineReactivateResponse.
        :type: Dict[str, str]
        """
        self._attrs["statusDescription"] = status_description

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Requested_actionEnum(str, Enum):
    ACTIVATE = "ACTIVATE"
    DEACTIVATE = "DEACTIVATE"
    REACTIVATE = "REACTIVATE"

    @staticmethod
    def from_value(value: str):
        if value == "ACTIVATE":
            return Requested_actionEnum.ACTIVATE
        if value == "DEACTIVATE":
            return Requested_actionEnum.DEACTIVATE
        if value == "REACTIVATE":
            return Requested_actionEnum.REACTIVATE


class PipelineReactivateResponseAsync(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineReactivateResponseAsync":
        instance = PipelineReactivateResponseAsync.__new__(PipelineReactivateResponseAsync)
        instance._attrs = model
        return instance

    def __init__(self, pipeline_id: "str" = None, reactivation_request_id: "str" = None, requested_action: "str" = None, **extra):
        """PipelineReactivateResponseAsync"""

        self._attrs = dict()
        if pipeline_id is not None:
            self._attrs["pipelineId"] = pipeline_id
        if reactivation_request_id is not None:
            self._attrs["reactivationRequestId"] = reactivation_request_id
        if requested_action is not None:
            self._attrs["requestedAction"] = requested_action
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def pipeline_id(self) -> "str":
        """ Gets the pipeline_id of this PipelineReactivateResponseAsync.
        """
        return self._attrs.get("pipelineId")

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id: "str"):
        """Sets the pipeline_id of this PipelineReactivateResponseAsync.


        :param pipeline_id: The pipeline_id of this PipelineReactivateResponseAsync.
        :type: str
        """
        self._attrs["pipelineId"] = pipeline_id

    @property
    def reactivation_request_id(self) -> "str":
        """ Gets the reactivation_request_id of this PipelineReactivateResponseAsync.
        """
        return self._attrs.get("reactivationRequestId")

    @reactivation_request_id.setter
    def reactivation_request_id(self, reactivation_request_id: "str"):
        """Sets the reactivation_request_id of this PipelineReactivateResponseAsync.


        :param reactivation_request_id: The reactivation_request_id of this PipelineReactivateResponseAsync.
        :type: str
        """
        self._attrs["reactivationRequestId"] = reactivation_request_id

    @property
    def requested_action(self) -> "Requested_actionEnum":
        """ Gets the requested_action of this PipelineReactivateResponseAsync.
        """
        return Requested_actionEnum.from_value(self._attrs.get("requestedAction"))

    @requested_action.setter
    def requested_action(self, requested_action: "str"):
        """Sets the requested_action of this PipelineReactivateResponseAsync.


        :param requested_action: The requested_action of this PipelineReactivateResponseAsync.
        :type: str
        """
        if isinstance(requested_action, Enum):
            self._attrs["requestedAction"] = requested_action.value
        else:
            self._attrs["requestedAction"] = requested_action  # If you supply a string, we presume you know the service will take it.

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Exit_statusEnum(str, Enum):
    SUCCESS = "SUCCESS"
    FAILED = "FAILED"
    PENDING = "PENDING"

    @staticmethod
    def from_value(value: str):
        if value == "SUCCESS":
            return Exit_statusEnum.SUCCESS
        if value == "FAILED":
            return Exit_statusEnum.FAILED
        if value == "PENDING":
            return Exit_statusEnum.PENDING


class Pipeline_deployment_statusEnum(str, Enum):
    CREATED = "CREATED"
    ACTIVATED = "ACTIVATED"
    FAILED = "FAILED"
    RESTARTING = "RESTARTING"
    FINISHED = "FINISHED"
    ACTIVATING = "ACTIVATING"
    DEACTIVATING = "DEACTIVATING"

    @staticmethod
    def from_value(value: str):
        if value == "CREATED":
            return Pipeline_deployment_statusEnum.CREATED
        if value == "ACTIVATED":
            return Pipeline_deployment_statusEnum.ACTIVATED
        if value == "FAILED":
            return Pipeline_deployment_statusEnum.FAILED
        if value == "RESTARTING":
            return Pipeline_deployment_statusEnum.RESTARTING
        if value == "FINISHED":
            return Pipeline_deployment_statusEnum.FINISHED
        if value == "ACTIVATING":
            return Pipeline_deployment_statusEnum.ACTIVATING
        if value == "DEACTIVATING":
            return Pipeline_deployment_statusEnum.DEACTIVATING


class Requested_actionEnum(str, Enum):
    ACTIVATE = "ACTIVATE"
    DEACTIVATE = "DEACTIVATE"
    REACTIVATE = "REACTIVATE"

    @staticmethod
    def from_value(value: str):
        if value == "ACTIVATE":
            return Requested_actionEnum.ACTIVATE
        if value == "DEACTIVATE":
            return Requested_actionEnum.DEACTIVATE
        if value == "REACTIVATE":
            return Requested_actionEnum.REACTIVATE


class PipelineReactivationStatus(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineReactivationStatus":
        instance = PipelineReactivationStatus.__new__(PipelineReactivationStatus)
        instance._attrs = model
        return instance

    def __init__(self, create_date: "int" = None, current_uber_jar: "str" = None, exit_status: "str" = None, flink_job_status: "str" = None, id: "str" = None, message: "str" = None, pipeline_deployment_status: "str" = None, pipeline_id: "str" = None, requested_action: "str" = None, requested_uber_jar: "str" = None, **extra):
        """PipelineReactivationStatus"""

        self._attrs = dict()
        if create_date is not None:
            self._attrs["createDate"] = create_date
        if current_uber_jar is not None:
            self._attrs["currentUberJar"] = current_uber_jar
        if exit_status is not None:
            self._attrs["exitStatus"] = exit_status
        if flink_job_status is not None:
            self._attrs["flinkJobStatus"] = flink_job_status
        if id is not None:
            self._attrs["id"] = id
        if message is not None:
            self._attrs["message"] = message
        if pipeline_deployment_status is not None:
            self._attrs["pipelineDeploymentStatus"] = pipeline_deployment_status
        if pipeline_id is not None:
            self._attrs["pipelineId"] = pipeline_id
        if requested_action is not None:
            self._attrs["requestedAction"] = requested_action
        if requested_uber_jar is not None:
            self._attrs["requestedUberJar"] = requested_uber_jar
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def create_date(self) -> "int":
        """ Gets the create_date of this PipelineReactivationStatus.
        """
        return self._attrs.get("createDate")

    @create_date.setter
    def create_date(self, create_date: "int"):
        """Sets the create_date of this PipelineReactivationStatus.


        :param create_date: The create_date of this PipelineReactivationStatus.
        :type: int
        """
        self._attrs["createDate"] = create_date

    @property
    def current_uber_jar(self) -> "str":
        """ Gets the current_uber_jar of this PipelineReactivationStatus.
        """
        return self._attrs.get("currentUberJar")

    @current_uber_jar.setter
    def current_uber_jar(self, current_uber_jar: "str"):
        """Sets the current_uber_jar of this PipelineReactivationStatus.


        :param current_uber_jar: The current_uber_jar of this PipelineReactivationStatus.
        :type: str
        """
        self._attrs["currentUberJar"] = current_uber_jar

    @property
    def exit_status(self) -> "Exit_statusEnum":
        """ Gets the exit_status of this PipelineReactivationStatus.
        """
        return Exit_statusEnum.from_value(self._attrs.get("exitStatus"))

    @exit_status.setter
    def exit_status(self, exit_status: "str"):
        """Sets the exit_status of this PipelineReactivationStatus.


        :param exit_status: The exit_status of this PipelineReactivationStatus.
        :type: str
        """
        if isinstance(exit_status, Enum):
            self._attrs["exitStatus"] = exit_status.value
        else:
            self._attrs["exitStatus"] = exit_status  # If you supply a string, we presume you know the service will take it.

    @property
    def flink_job_status(self) -> "str":
        """ Gets the flink_job_status of this PipelineReactivationStatus.
        """
        return self._attrs.get("flinkJobStatus")

    @flink_job_status.setter
    def flink_job_status(self, flink_job_status: "str"):
        """Sets the flink_job_status of this PipelineReactivationStatus.


        :param flink_job_status: The flink_job_status of this PipelineReactivationStatus.
        :type: str
        """
        self._attrs["flinkJobStatus"] = flink_job_status

    @property
    def id(self) -> "str":
        """ Gets the id of this PipelineReactivationStatus.
        """
        return self._attrs.get("id")

    @id.setter
    def id(self, id: "str"):
        """Sets the id of this PipelineReactivationStatus.


        :param id: The id of this PipelineReactivationStatus.
        :type: str
        """
        self._attrs["id"] = id

    @property
    def message(self) -> "str":
        """ Gets the message of this PipelineReactivationStatus.
        """
        return self._attrs.get("message")

    @message.setter
    def message(self, message: "str"):
        """Sets the message of this PipelineReactivationStatus.


        :param message: The message of this PipelineReactivationStatus.
        :type: str
        """
        self._attrs["message"] = message

    @property
    def pipeline_deployment_status(self) -> "Pipeline_deployment_statusEnum":
        """ Gets the pipeline_deployment_status of this PipelineReactivationStatus.
        """
        return Pipeline_deployment_statusEnum.from_value(self._attrs.get("pipelineDeploymentStatus"))

    @pipeline_deployment_status.setter
    def pipeline_deployment_status(self, pipeline_deployment_status: "str"):
        """Sets the pipeline_deployment_status of this PipelineReactivationStatus.


        :param pipeline_deployment_status: The pipeline_deployment_status of this PipelineReactivationStatus.
        :type: str
        """
        if isinstance(pipeline_deployment_status, Enum):
            self._attrs["pipelineDeploymentStatus"] = pipeline_deployment_status.value
        else:
            self._attrs["pipelineDeploymentStatus"] = pipeline_deployment_status  # If you supply a string, we presume you know the service will take it.

    @property
    def pipeline_id(self) -> "str":
        """ Gets the pipeline_id of this PipelineReactivationStatus.
        """
        return self._attrs.get("pipelineId")

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id: "str"):
        """Sets the pipeline_id of this PipelineReactivationStatus.


        :param pipeline_id: The pipeline_id of this PipelineReactivationStatus.
        :type: str
        """
        self._attrs["pipelineId"] = pipeline_id

    @property
    def requested_action(self) -> "Requested_actionEnum":
        """ Gets the requested_action of this PipelineReactivationStatus.
        """
        return Requested_actionEnum.from_value(self._attrs.get("requestedAction"))

    @requested_action.setter
    def requested_action(self, requested_action: "str"):
        """Sets the requested_action of this PipelineReactivationStatus.


        :param requested_action: The requested_action of this PipelineReactivationStatus.
        :type: str
        """
        if isinstance(requested_action, Enum):
            self._attrs["requestedAction"] = requested_action.value
        else:
            self._attrs["requestedAction"] = requested_action  # If you supply a string, we presume you know the service will take it.

    @property
    def requested_uber_jar(self) -> "str":
        """ Gets the requested_uber_jar of this PipelineReactivationStatus.
        """
        return self._attrs.get("requestedUberJar")

    @requested_uber_jar.setter
    def requested_uber_jar(self, requested_uber_jar: "str"):
        """Sets the requested_uber_jar of this PipelineReactivationStatus.


        :param requested_uber_jar: The requested_uber_jar of this PipelineReactivationStatus.
        :type: str
        """
        self._attrs["requestedUberJar"] = requested_uber_jar

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PipelineRequest":
        instance = PipelineRequest.__new__(PipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "Pipeline", name: "str", bypass_validation: "bool" = None, description: "str" = None, labels: "Dict[str, str]" = None, **extra):
        """PipelineRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if name is not None:
            self._attrs["name"] = name
        if bypass_validation is not None:
            self._attrs["bypassValidation"] = bypass_validation
        if description is not None:
            self._attrs["description"] = description
        if labels is not None:
            self._attrs["labels"] = labels
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "Pipeline":
        """ Gets the data of this PipelineRequest.
        """
        return Pipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "Pipeline"):
        """Sets the data of this PipelineRequest.


        :param data: The data of this PipelineRequest.
        :type: Pipeline
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data.to_dict()

    @property
    def name(self) -> "str":
        """ Gets the name of this PipelineRequest.
        The name of the pipeline.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this PipelineRequest.

        The name of the pipeline.

        :param name: The name of this PipelineRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    @property
    def bypass_validation(self) -> "bool":
        """ Gets the bypass_validation of this PipelineRequest.
        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.
        """
        return self._attrs.get("bypassValidation")

    @bypass_validation.setter
    def bypass_validation(self, bypass_validation: "bool"):
        """Sets the bypass_validation of this PipelineRequest.

        Set to true to bypass initial pipeline validation upon creation. The pipeline still needs to be validated before activation. Defaults to false.

        :param bypass_validation: The bypass_validation of this PipelineRequest.
        :type: bool
        """
        self._attrs["bypassValidation"] = bypass_validation

    @property
    def description(self) -> "str":
        """ Gets the description of this PipelineRequest.
        The description of the pipeline. Defaults to null.
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this PipelineRequest.

        The description of the pipeline. Defaults to null.

        :param description: The description of this PipelineRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def labels(self) -> "Dict[str, str]":
        """ Gets the labels of this PipelineRequest.
        Optional labels in associated with the pipeline. A label is represented by a key and a value.
        """
        return self._attrs.get("labels")

    @labels.setter
    def labels(self, labels: "Dict[str, str]"):
        """Sets the labels of this PipelineRequest.

        Optional labels in associated with the pipeline. A label is represented by a key and a value.

        :param labels: The labels of this PipelineRequest.
        :type: Dict[str, str]
        """
        self._attrs["labels"] = labels

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewNode(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewNode":
        instance = PreviewNode.__new__(PreviewNode)
        instance._attrs = model
        return instance

    def __init__(self, node_name: "str" = None, records: "List[object]" = None, **extra):
        """PreviewNode"""

        self._attrs = dict()
        if node_name is not None:
            self._attrs["nodeName"] = node_name
        if records is not None:
            self._attrs["records"] = records
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def node_name(self) -> "str":
        """ Gets the node_name of this PreviewNode.
        """
        return self._attrs.get("nodeName")

    @node_name.setter
    def node_name(self, node_name: "str"):
        """Sets the node_name of this PreviewNode.


        :param node_name: The node_name of this PreviewNode.
        :type: str
        """
        self._attrs["nodeName"] = node_name

    @property
    def records(self) -> "List[object]":
        """ Gets the records of this PreviewNode.
        """
        return self._attrs.get("records")

    @records.setter
    def records(self, records: "List[object]"):
        """Sets the records of this PreviewNode.


        :param records: The records of this PreviewNode.
        :type: List[object]
        """
        self._attrs["records"] = records

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RuleMetrics(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RuleMetrics":
        instance = RuleMetrics.__new__(RuleMetrics)
        instance._attrs = model
        return instance

    def __init__(self, match_count: "int" = None, match_percentage: "int" = None, name: "str" = None, **extra):
        """RuleMetrics"""

        self._attrs = dict()
        if match_count is not None:
            self._attrs["matchCount"] = match_count
        if match_percentage is not None:
            self._attrs["matchPercentage"] = match_percentage
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def match_count(self) -> "int":
        """ Gets the match_count of this RuleMetrics.
        """
        return self._attrs.get("matchCount")

    @match_count.setter
    def match_count(self, match_count: "int"):
        """Sets the match_count of this RuleMetrics.


        :param match_count: The match_count of this RuleMetrics.
        :type: int
        """
        self._attrs["matchCount"] = match_count

    @property
    def match_percentage(self) -> "int":
        """ Gets the match_percentage of this RuleMetrics.
        """
        return self._attrs.get("matchPercentage")

    @match_percentage.setter
    def match_percentage(self, match_percentage: "int"):
        """Sets the match_percentage of this RuleMetrics.


        :param match_percentage: The match_percentage of this RuleMetrics.
        :type: int
        """
        self._attrs["matchPercentage"] = match_percentage

    @property
    def name(self) -> "str":
        """ Gets the name of this RuleMetrics.
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this RuleMetrics.


        :param name: The name of this RuleMetrics.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewData(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewData":
        instance = PreviewData.__new__(PreviewData)
        instance._attrs = model
        return instance

    def __init__(self, current_number_of_records: "int" = None, nodes: "Dict[str, PreviewNode]" = None, preview_id: "str" = None, records_per_pipeline: "int" = None, rule_metrics: "List[RuleMetrics]" = None, tenant_id: "str" = None, **extra):
        """PreviewData"""

        self._attrs = dict()
        if current_number_of_records is not None:
            self._attrs["currentNumberOfRecords"] = current_number_of_records
        if nodes is not None:
            self._attrs["nodes"] = nodes
        if preview_id is not None:
            self._attrs["previewId"] = preview_id
        if records_per_pipeline is not None:
            self._attrs["recordsPerPipeline"] = records_per_pipeline
        if rule_metrics is not None:
            self._attrs["ruleMetrics"] = rule_metrics
        if tenant_id is not None:
            self._attrs["tenantId"] = tenant_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def current_number_of_records(self) -> "int":
        """ Gets the current_number_of_records of this PreviewData.
        """
        return self._attrs.get("currentNumberOfRecords")

    @current_number_of_records.setter
    def current_number_of_records(self, current_number_of_records: "int"):
        """Sets the current_number_of_records of this PreviewData.


        :param current_number_of_records: The current_number_of_records of this PreviewData.
        :type: int
        """
        self._attrs["currentNumberOfRecords"] = current_number_of_records

    @property
    def nodes(self) -> "Dict[str, PreviewNode]":
        """ Gets the nodes of this PreviewData.
        """
        return self._attrs.get("nodes")

    @nodes.setter
    def nodes(self, nodes: "Dict[str, PreviewNode]"):
        """Sets the nodes of this PreviewData.


        :param nodes: The nodes of this PreviewData.
        :type: Dict[str, PreviewNode]
        """
        self._attrs["nodes"] = nodes

    @property
    def preview_id(self) -> "str":
        """ Gets the preview_id of this PreviewData.
        """
        return self._attrs.get("previewId")

    @preview_id.setter
    def preview_id(self, preview_id: "str"):
        """Sets the preview_id of this PreviewData.


        :param preview_id: The preview_id of this PreviewData.
        :type: str
        """
        self._attrs["previewId"] = preview_id

    @property
    def records_per_pipeline(self) -> "int":
        """ Gets the records_per_pipeline of this PreviewData.
        """
        return self._attrs.get("recordsPerPipeline")

    @records_per_pipeline.setter
    def records_per_pipeline(self, records_per_pipeline: "int"):
        """Sets the records_per_pipeline of this PreviewData.


        :param records_per_pipeline: The records_per_pipeline of this PreviewData.
        :type: int
        """
        self._attrs["recordsPerPipeline"] = records_per_pipeline

    @property
    def rule_metrics(self) -> "List[RuleMetrics]":
        """ Gets the rule_metrics of this PreviewData.
        """
        return [RuleMetrics._from_dict(i) for i in self._attrs.get("ruleMetrics")]

    @rule_metrics.setter
    def rule_metrics(self, rule_metrics: "List[RuleMetrics]"):
        """Sets the rule_metrics of this PreviewData.


        :param rule_metrics: The rule_metrics of this PreviewData.
        :type: List[RuleMetrics]
        """
        self._attrs["ruleMetrics"] = rule_metrics

    @property
    def tenant_id(self) -> "str":
        """ Gets the tenant_id of this PreviewData.
        """
        return self._attrs.get("tenantId")

    @tenant_id.setter
    def tenant_id(self, tenant_id: "str"):
        """Sets the tenant_id of this PreviewData.


        :param tenant_id: The tenant_id of this PreviewData.
        :type: str
        """
        self._attrs["tenantId"] = tenant_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewSessionStartRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewSessionStartRequest":
        instance = PreviewSessionStartRequest.__new__(PreviewSessionStartRequest)
        instance._attrs = model
        return instance

    def __init__(self, upl: "Pipeline", records_limit: "int" = None, records_per_pipeline: "int" = None, session_lifetime_ms: "int" = None, **extra):
        """PreviewSessionStartRequest"""

        self._attrs = dict()
        if upl is not None:
            self._attrs["upl"] = upl.to_dict()
        if records_limit is not None:
            self._attrs["recordsLimit"] = records_limit
        if records_per_pipeline is not None:
            self._attrs["recordsPerPipeline"] = records_per_pipeline
        if session_lifetime_ms is not None:
            self._attrs["sessionLifetimeMs"] = session_lifetime_ms
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def upl(self) -> "Pipeline":
        """ Gets the upl of this PreviewSessionStartRequest.
        """
        return Pipeline._from_dict(self._attrs["upl"])

    @upl.setter
    def upl(self, upl: "Pipeline"):
        """Sets the upl of this PreviewSessionStartRequest.


        :param upl: The upl of this PreviewSessionStartRequest.
        :type: Pipeline
        """
        if upl is None:
            raise ValueError("Invalid value for `upl`, must not be `None`")
        self._attrs["upl"] = upl.to_dict()

    @property
    def records_limit(self) -> "int":
        """ Gets the records_limit of this PreviewSessionStartRequest.
        The maximum number of events per function. Defaults to 100.
        """
        return self._attrs.get("recordsLimit")

    @records_limit.setter
    def records_limit(self, records_limit: "int"):
        """Sets the records_limit of this PreviewSessionStartRequest.

        The maximum number of events per function. Defaults to 100.

        :param records_limit: The records_limit of this PreviewSessionStartRequest.
        :type: int
        """
        self._attrs["recordsLimit"] = records_limit

    @property
    def records_per_pipeline(self) -> "int":
        """ Gets the records_per_pipeline of this PreviewSessionStartRequest.
        The maximum number of events per pipeline. Defaults to 10000.
        """
        return self._attrs.get("recordsPerPipeline")

    @records_per_pipeline.setter
    def records_per_pipeline(self, records_per_pipeline: "int"):
        """Sets the records_per_pipeline of this PreviewSessionStartRequest.

        The maximum number of events per pipeline. Defaults to 10000.

        :param records_per_pipeline: The records_per_pipeline of this PreviewSessionStartRequest.
        :type: int
        """
        self._attrs["recordsPerPipeline"] = records_per_pipeline

    @property
    def session_lifetime_ms(self) -> "int":
        """ Gets the session_lifetime_ms of this PreviewSessionStartRequest.
        The maximum lifetime of a session, in milliseconds. Defaults to 300,000.
        """
        return self._attrs.get("sessionLifetimeMs")

    @session_lifetime_ms.setter
    def session_lifetime_ms(self, session_lifetime_ms: "int"):
        """Sets the session_lifetime_ms of this PreviewSessionStartRequest.

        The maximum lifetime of a session, in milliseconds. Defaults to 300,000.

        :param session_lifetime_ms: The session_lifetime_ms of this PreviewSessionStartRequest.
        :type: int
        """
        self._attrs["sessionLifetimeMs"] = session_lifetime_ms

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewStartResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewStartResponse":
        instance = PreviewStartResponse.__new__(PreviewStartResponse)
        instance._attrs = model
        return instance

    def __init__(self, preview_id: "int" = None, **extra):
        """PreviewStartResponse"""

        self._attrs = dict()
        if preview_id is not None:
            self._attrs["previewId"] = preview_id
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def preview_id(self) -> "int":
        """ Gets the preview_id of this PreviewStartResponse.
        """
        return self._attrs.get("previewId")

    @preview_id.setter
    def preview_id(self, preview_id: "int"):
        """Sets the preview_id of this PreviewStartResponse.


        :param preview_id: The preview_id of this PreviewStartResponse.
        :type: int
        """
        self._attrs["previewId"] = preview_id

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class PreviewState(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "PreviewState":
        instance = PreviewState.__new__(PreviewState)
        instance._attrs = model
        return instance

    def __init__(self, activated_date: "int" = None, created_date: "int" = None, current_number_of_records: "int" = None, job_id: "str" = None, preview_id: "int" = None, records_per_pipeline: "int" = None, **extra):
        """PreviewState"""

        self._attrs = dict()
        if activated_date is not None:
            self._attrs["activatedDate"] = activated_date
        if created_date is not None:
            self._attrs["createdDate"] = created_date
        if current_number_of_records is not None:
            self._attrs["currentNumberOfRecords"] = current_number_of_records
        if job_id is not None:
            self._attrs["jobId"] = job_id
        if preview_id is not None:
            self._attrs["previewId"] = preview_id
        if records_per_pipeline is not None:
            self._attrs["recordsPerPipeline"] = records_per_pipeline
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activated_date(self) -> "int":
        """ Gets the activated_date of this PreviewState.
        """
        return self._attrs.get("activatedDate")

    @activated_date.setter
    def activated_date(self, activated_date: "int"):
        """Sets the activated_date of this PreviewState.


        :param activated_date: The activated_date of this PreviewState.
        :type: int
        """
        self._attrs["activatedDate"] = activated_date

    @property
    def created_date(self) -> "int":
        """ Gets the created_date of this PreviewState.
        """
        return self._attrs.get("createdDate")

    @created_date.setter
    def created_date(self, created_date: "int"):
        """Sets the created_date of this PreviewState.


        :param created_date: The created_date of this PreviewState.
        :type: int
        """
        self._attrs["createdDate"] = created_date

    @property
    def current_number_of_records(self) -> "int":
        """ Gets the current_number_of_records of this PreviewState.
        """
        return self._attrs.get("currentNumberOfRecords")

    @current_number_of_records.setter
    def current_number_of_records(self, current_number_of_records: "int"):
        """Sets the current_number_of_records of this PreviewState.


        :param current_number_of_records: The current_number_of_records of this PreviewState.
        :type: int
        """
        self._attrs["currentNumberOfRecords"] = current_number_of_records

    @property
    def job_id(self) -> "str":
        """ Gets the job_id of this PreviewState.
        """
        return self._attrs.get("jobId")

    @job_id.setter
    def job_id(self, job_id: "str"):
        """Sets the job_id of this PreviewState.


        :param job_id: The job_id of this PreviewState.
        :type: str
        """
        self._attrs["jobId"] = job_id

    @property
    def preview_id(self) -> "int":
        """ Gets the preview_id of this PreviewState.
        """
        return self._attrs.get("previewId")

    @preview_id.setter
    def preview_id(self, preview_id: "int"):
        """Sets the preview_id of this PreviewState.


        :param preview_id: The preview_id of this PreviewState.
        :type: int
        """
        self._attrs["previewId"] = preview_id

    @property
    def records_per_pipeline(self) -> "int":
        """ Gets the records_per_pipeline of this PreviewState.
        """
        return self._attrs.get("recordsPerPipeline")

    @records_per_pipeline.setter
    def records_per_pipeline(self, records_per_pipeline: "int"):
        """Sets the records_per_pipeline of this PreviewState.


        :param records_per_pipeline: The records_per_pipeline of this PreviewState.
        :type: int
        """
        self._attrs["recordsPerPipeline"] = records_per_pipeline

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ReactivatePipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ReactivatePipelineRequest":
        instance = ReactivatePipelineRequest.__new__(ReactivatePipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, activate_latest_version: "bool" = None, allow_non_restored_state: "bool" = None, skip_restore_state: "bool" = None, **extra):
        """ReactivatePipelineRequest"""

        self._attrs = dict()
        if activate_latest_version is not None:
            self._attrs["activateLatestVersion"] = activate_latest_version
        if allow_non_restored_state is not None:
            self._attrs["allowNonRestoredState"] = allow_non_restored_state
        if skip_restore_state is not None:
            self._attrs["skipRestoreState"] = skip_restore_state
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activate_latest_version(self) -> "bool":
        """ Gets the activate_latest_version of this ReactivatePipelineRequest.
        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.
        """
        return self._attrs.get("activateLatestVersion")

    @activate_latest_version.setter
    def activate_latest_version(self, activate_latest_version: "bool"):
        """Sets the activate_latest_version of this ReactivatePipelineRequest.

        Set to true to activate the latest version of the pipeline. Set to false to use the previously activated version of the pipeline. Defaults to true.

        :param activate_latest_version: The activate_latest_version of this ReactivatePipelineRequest.
        :type: bool
        """
        self._attrs["activateLatestVersion"] = activate_latest_version

    @property
    def allow_non_restored_state(self) -> "bool":
        """ Gets the allow_non_restored_state of this ReactivatePipelineRequest.
        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to reactivate a pipeline in this state. Defaults to false.
        """
        return self._attrs.get("allowNonRestoredState")

    @allow_non_restored_state.setter
    def allow_non_restored_state(self, allow_non_restored_state: "bool"):
        """Sets the allow_non_restored_state of this ReactivatePipelineRequest.

        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to reactivate a pipeline in this state. Defaults to false.

        :param allow_non_restored_state: The allow_non_restored_state of this ReactivatePipelineRequest.
        :type: bool
        """
        self._attrs["allowNonRestoredState"] = allow_non_restored_state

    @property
    def skip_restore_state(self) -> "bool":
        """ Gets the skip_restore_state of this ReactivatePipelineRequest.
        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.
        """
        return self._attrs.get("skipRestoreState")

    @skip_restore_state.setter
    def skip_restore_state(self, skip_restore_state: "bool"):
        """Sets the skip_restore_state of this ReactivatePipelineRequest.

        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.

        :param skip_restore_state: The skip_restore_state of this ReactivatePipelineRequest.
        :type: bool
        """
        self._attrs["skipRestoreState"] = skip_restore_state

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class RegistryModel(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "RegistryModel":
        instance = RegistryModel.__new__(RegistryModel)
        instance._attrs = model
        return instance

    def __init__(self, categories: "List[str]" = None, functions: "List[FunctionModel]" = None, **extra):
        """RegistryModel"""

        self._attrs = dict()
        if categories is not None:
            self._attrs["categories"] = categories
        if functions is not None:
            self._attrs["functions"] = functions
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def categories(self) -> "List[str]":
        """ Gets the categories of this RegistryModel.
        """
        return self._attrs.get("categories")

    @categories.setter
    def categories(self, categories: "List[str]"):
        """Sets the categories of this RegistryModel.


        :param categories: The categories of this RegistryModel.
        :type: List[str]
        """
        self._attrs["categories"] = categories

    @property
    def functions(self) -> "List[FunctionModel]":
        """ Gets the functions of this RegistryModel.
        """
        return [FunctionModel._from_dict(i) for i in self._attrs.get("functions")]

    @functions.setter
    def functions(self, functions: "List[FunctionModel]"):
        """Sets the functions of this RegistryModel.


        :param functions: The functions of this RegistryModel.
        :type: List[FunctionModel]
        """
        self._attrs["functions"] = functions

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class Response(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "Response":
        instance = Response.__new__(Response)
        instance._attrs = model
        return instance

    def __init__(self, activated: "str" = None, deactivated: "str" = None, **extra):
        """Response"""

        self._attrs = dict()
        if activated is not None:
            self._attrs["activated"] = activated
        if deactivated is not None:
            self._attrs["deactivated"] = deactivated
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def activated(self) -> "str":
        """ Gets the activated of this Response.
        Only set for /activate endpoint
        """
        return self._attrs.get("activated")

    @activated.setter
    def activated(self, activated: "str"):
        """Sets the activated of this Response.

        Only set for /activate endpoint

        :param activated: The activated of this Response.
        :type: str
        """
        self._attrs["activated"] = activated

    @property
    def deactivated(self) -> "str":
        """ Gets the deactivated of this Response.
        Only set for /deactivate endpoint
        """
        return self._attrs.get("deactivated")

    @deactivated.setter
    def deactivated(self, deactivated: "str"):
        """Sets the deactivated of this Response.

        Only set for /deactivate endpoint

        :param deactivated: The deactivated of this Response.
        :type: str
        """
        self._attrs["deactivated"] = deactivated

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class SplCompileRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "SplCompileRequest":
        instance = SplCompileRequest.__new__(SplCompileRequest)
        instance._attrs = model
        return instance

    def __init__(self, spl: "str", validate: "bool" = None, **extra):
        """SplCompileRequest"""

        self._attrs = dict()
        if spl is not None:
            self._attrs["spl"] = spl
        if validate is not None:
            self._attrs["validate"] = validate
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def spl(self) -> "str":
        """ Gets the spl of this SplCompileRequest.
        The SPL2 representation of a pipeline or function parameters.
        """
        return self._attrs.get("spl")

    @spl.setter
    def spl(self, spl: "str"):
        """Sets the spl of this SplCompileRequest.

        The SPL2 representation of a pipeline or function parameters.

        :param spl: The spl of this SplCompileRequest.
        :type: str
        """
        if spl is None:
            raise ValueError("Invalid value for `spl`, must not be `None`")
        self._attrs["spl"] = spl

    @property
    def validate(self) -> "bool":
        """ Gets the validate of this SplCompileRequest.
        A boolean flag to indicate whether the pipeline should be validated.
        """
        return self._attrs.get("validate")

    @validate.setter
    def validate(self, validate: "bool"):
        """Sets the validate of this SplCompileRequest.

        A boolean flag to indicate whether the pipeline should be validated.

        :param validate: The validate of this SplCompileRequest.
        :type: bool
        """
        self._attrs["validate"] = validate

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplatePatchRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplatePatchRequest":
        instance = TemplatePatchRequest.__new__(TemplatePatchRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "Pipeline" = None, description: "str" = None, name: "str" = None, **extra):
        """TemplatePatchRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "Pipeline":
        """ Gets the data of this TemplatePatchRequest.
        """
        return Pipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "Pipeline"):
        """Sets the data of this TemplatePatchRequest.


        :param data: The data of this TemplatePatchRequest.
        :type: Pipeline
        """
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplatePatchRequest.
        Template description
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplatePatchRequest.

        Template description

        :param description: The description of this TemplatePatchRequest.
        :type: str
        """
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplatePatchRequest.
        Template name
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplatePatchRequest.

        Template name

        :param name: The name of this TemplatePatchRequest.
        :type: str
        """
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplatePutRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplatePutRequest":
        instance = TemplatePutRequest.__new__(TemplatePutRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "Pipeline", description: "str", name: "str", **extra):
        """TemplatePutRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "Pipeline":
        """ Gets the data of this TemplatePutRequest.
        """
        return Pipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "Pipeline"):
        """Sets the data of this TemplatePutRequest.


        :param data: The data of this TemplatePutRequest.
        :type: Pipeline
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplatePutRequest.
        Template description
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplatePutRequest.

        Template description

        :param description: The description of this TemplatePutRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplatePutRequest.
        Template name
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplatePutRequest.

        Template name

        :param name: The name of this TemplatePutRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class TemplateRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "TemplateRequest":
        instance = TemplateRequest.__new__(TemplateRequest)
        instance._attrs = model
        return instance

    def __init__(self, data: "Pipeline", description: "str", name: "str", **extra):
        """TemplateRequest"""

        self._attrs = dict()
        if data is not None:
            self._attrs["data"] = data.to_dict()
        if description is not None:
            self._attrs["description"] = description
        if name is not None:
            self._attrs["name"] = name
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def data(self) -> "Pipeline":
        """ Gets the data of this TemplateRequest.
        """
        return Pipeline._from_dict(self._attrs["data"])

    @data.setter
    def data(self, data: "Pipeline"):
        """Sets the data of this TemplateRequest.


        :param data: The data of this TemplateRequest.
        :type: Pipeline
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data.to_dict()

    @property
    def description(self) -> "str":
        """ Gets the description of this TemplateRequest.
        Template description
        """
        return self._attrs.get("description")

    @description.setter
    def description(self, description: "str"):
        """Sets the description of this TemplateRequest.

        Template description

        :param description: The description of this TemplateRequest.
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")
        self._attrs["description"] = description

    @property
    def name(self) -> "str":
        """ Gets the name of this TemplateRequest.
        Template name
        """
        return self._attrs.get("name")

    @name.setter
    def name(self, name: "str"):
        """Sets the name of this TemplateRequest.

        Template name

        :param name: The name of this TemplateRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        self._attrs["name"] = name

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UpgradePipelineRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UpgradePipelineRequest":
        instance = UpgradePipelineRequest.__new__(UpgradePipelineRequest)
        instance._attrs = model
        return instance

    def __init__(self, allow_non_restored_state: "bool" = None, cancel_with_save_point: "bool" = None, skip_restore_state: "bool" = None, **extra):
        """UpgradePipelineRequest"""

        self._attrs = dict()
        if allow_non_restored_state is not None:
            self._attrs["allowNonRestoredState"] = allow_non_restored_state
        if cancel_with_save_point is not None:
            self._attrs["cancelWithSavePoint"] = cancel_with_save_point
        if skip_restore_state is not None:
            self._attrs["skipRestoreState"] = skip_restore_state
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def allow_non_restored_state(self) -> "bool":
        """ Gets the allow_non_restored_state of this UpgradePipelineRequest.
        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to reactivate a pipeline in this state. Defaults to false.
        """
        return self._attrs.get("allowNonRestoredState")

    @allow_non_restored_state.setter
    def allow_non_restored_state(self, allow_non_restored_state: "bool"):
        """Sets the allow_non_restored_state of this UpgradePipelineRequest.

        Set to true to allow the pipeline to ignore any unused progress states. In some cases, when a data pipeline is changed, the progress state will be stored for functions that no longer exist, so this must be set to reactivate a pipeline in this state. Defaults to false.

        :param allow_non_restored_state: The allow_non_restored_state of this UpgradePipelineRequest.
        :type: bool
        """
        self._attrs["allowNonRestoredState"] = allow_non_restored_state

    @property
    def cancel_with_save_point(self) -> "bool":
        """ Gets the cancel_with_save_point of this UpgradePipelineRequest.
        Set to true to deactivate a pipeline with a savepoint. Defaults to false.
        """
        return self._attrs.get("cancelWithSavePoint")

    @cancel_with_save_point.setter
    def cancel_with_save_point(self, cancel_with_save_point: "bool"):
        """Sets the cancel_with_save_point of this UpgradePipelineRequest.

        Set to true to deactivate a pipeline with a savepoint. Defaults to false.

        :param cancel_with_save_point: The cancel_with_save_point of this UpgradePipelineRequest.
        :type: bool
        """
        self._attrs["cancelWithSavePoint"] = cancel_with_save_point

    @property
    def skip_restore_state(self) -> "bool":
        """ Gets the skip_restore_state of this UpgradePipelineRequest.
        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.
        """
        return self._attrs.get("skipRestoreState")

    @skip_restore_state.setter
    def skip_restore_state(self, skip_restore_state: "bool"):
        """Sets the skip_restore_state of this UpgradePipelineRequest.

        Set to true to start reading from the latest input rather than from where the pipeline's previous run left off, which can cause data loss. Defaults to false.

        :param skip_restore_state: The skip_restore_state of this UpgradePipelineRequest.
        :type: bool
        """
        self._attrs["skipRestoreState"] = skip_restore_state

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class UplType(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "UplType":
        instance = UplType.__new__(UplType)
        instance._attrs = model
        return instance

    def __init__(self, field_name: "str" = None, parameters: "List[UplType]" = None, type: "str" = None, **extra):
        """UplType"""

        self._attrs = dict()
        if field_name is not None:
            self._attrs["fieldName"] = field_name
        if parameters is not None:
            self._attrs["parameters"] = parameters
        if type is not None:
            self._attrs["type"] = type
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def field_name(self) -> "str":
        """ Gets the field_name of this UplType.
        """
        return self._attrs.get("fieldName")

    @field_name.setter
    def field_name(self, field_name: "str"):
        """Sets the field_name of this UplType.


        :param field_name: The field_name of this UplType.
        :type: str
        """
        self._attrs["fieldName"] = field_name

    @property
    def parameters(self) -> "List[UplType]":
        """ Gets the parameters of this UplType.
        """
        return [UplType._from_dict(i) for i in self._attrs.get("parameters")]

    @parameters.setter
    def parameters(self, parameters: "List[UplType]"):
        """Sets the parameters of this UplType.


        :param parameters: The parameters of this UplType.
        :type: List[UplType]
        """
        self._attrs["parameters"] = parameters

    @property
    def type(self) -> "str":
        """ Gets the type of this UplType.
        """
        return self._attrs.get("type")

    @type.setter
    def type(self, type: "str"):
        """Sets the type of this UplType.


        :param type: The type of this UplType.
        :type: str
        """
        self._attrs["type"] = type

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ValidateConnectionRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ValidateConnectionRequest":
        instance = ValidateConnectionRequest.__new__(ValidateConnectionRequest)
        instance._attrs = model
        return instance

    def __init__(self, connector_id: "str", data: "object", **extra):
        """ValidateConnectionRequest"""

        self._attrs = dict()
        if connector_id is not None:
            self._attrs["connectorId"] = connector_id
        if data is not None:
            self._attrs["data"] = data
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def connector_id(self) -> "str":
        """ Gets the connector_id of this ValidateConnectionRequest.
        The ID of the parent connector.
        """
        return self._attrs.get("connectorId")

    @connector_id.setter
    def connector_id(self, connector_id: "str"):
        """Sets the connector_id of this ValidateConnectionRequest.

        The ID of the parent connector.

        :param connector_id: The connector_id of this ValidateConnectionRequest.
        :type: str
        """
        if connector_id is None:
            raise ValueError("Invalid value for `connector_id`, must not be `None`")
        self._attrs["connectorId"] = connector_id

    @property
    def data(self) -> "dict":
        """ Gets the data of this ValidateConnectionRequest.
        The key-value pairs of connection configurations to be validated. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.
        """
        return self._attrs.get("data")

    @data.setter
    def data(self, data: "dict"):
        """Sets the data of this ValidateConnectionRequest.

        The key-value pairs of connection configurations to be validated. Connectors may have some configurations that are required, which all connections must provide values for. For configuration values of type BYTES, the provided values must be Base64 encoded.

        :param data: The data of this ValidateConnectionRequest.
        :type: object
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")
        self._attrs["data"] = data

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ValidateRequest(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ValidateRequest":
        instance = ValidateRequest.__new__(ValidateRequest)
        instance._attrs = model
        return instance

    def __init__(self, upl: "Pipeline", **extra):
        """ValidateRequest"""

        self._attrs = dict()
        if upl is not None:
            self._attrs["upl"] = upl.to_dict()
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def upl(self) -> "Pipeline":
        """ Gets the upl of this ValidateRequest.
        """
        return Pipeline._from_dict(self._attrs["upl"])

    @upl.setter
    def upl(self, upl: "Pipeline"):
        """Sets the upl of this ValidateRequest.


        :param upl: The upl of this ValidateRequest.
        :type: Pipeline
        """
        if upl is None:
            raise ValueError("Invalid value for `upl`, must not be `None`")
        self._attrs["upl"] = upl.to_dict()

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}


class ValidateResponse(SSCModel):

    @staticmethod
    def _from_dict(model: dict) -> "ValidateResponse":
        instance = ValidateResponse.__new__(ValidateResponse)
        instance._attrs = model
        return instance

    def __init__(self, node_id: "str" = None, spl: "str" = None, success: "bool" = None, validation_messages: "List[str]" = None, **extra):
        """ValidateResponse"""

        self._attrs = dict()
        if node_id is not None:
            self._attrs["nodeId"] = node_id
        if spl is not None:
            self._attrs["spl"] = spl
        if success is not None:
            self._attrs["success"] = success
        if validation_messages is not None:
            self._attrs["validationMessages"] = validation_messages
        for k, v in extra.items():
            self._attrs[k] = v

    @property
    def node_id(self) -> "str":
        """ Gets the node_id of this ValidateResponse.
        """
        return self._attrs.get("nodeId")

    @node_id.setter
    def node_id(self, node_id: "str"):
        """Sets the node_id of this ValidateResponse.


        :param node_id: The node_id of this ValidateResponse.
        :type: str
        """
        self._attrs["nodeId"] = node_id

    @property
    def spl(self) -> "str":
        """ Gets the spl of this ValidateResponse.
        """
        return self._attrs.get("spl")

    @spl.setter
    def spl(self, spl: "str"):
        """Sets the spl of this ValidateResponse.


        :param spl: The spl of this ValidateResponse.
        :type: str
        """
        self._attrs["spl"] = spl

    @property
    def success(self) -> "bool":
        """ Gets the success of this ValidateResponse.
        """
        return self._attrs.get("success")

    @success.setter
    def success(self, success: "bool"):
        """Sets the success of this ValidateResponse.


        :param success: The success of this ValidateResponse.
        :type: bool
        """
        self._attrs["success"] = success

    @property
    def validation_messages(self) -> "List[str]":
        """ Gets the validation_messages of this ValidateResponse.
        """
        return self._attrs.get("validationMessages")

    @validation_messages.setter
    def validation_messages(self, validation_messages: "List[str]"):
        """Sets the validation_messages of this ValidateResponse.


        :param validation_messages: The validation_messages of this ValidateResponse.
        :type: List[str]
        """
        self._attrs["validationMessages"] = validation_messages

    def to_dict(self):
        return {k: v for (k, v) in self._attrs.items() if v is not None}
