"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.jumphost_common_fields import CommonJumphostFields
from reconcile.gql_definitions.skupper_network.site_controller_template import SkupperSiteControllerTemplate
from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment CommonJumphostFields on ClusterJumpHost_v1 {
  hostname
  knownHosts
  user
  port
  remotePort
  identity {
    ...VaultSecret
  }
}

fragment SkupperSiteControllerTemplate on SkupperSiteControllerTemplate_v1 {
  path
  variables
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query SkupperNetworks {
  skupper_networks: skupper_network_v1 {
    identifier
    siteControllerTemplates {
      ...SkupperSiteControllerTemplate
    }
    namespaces {
      name
      delete
      skupperSite {
        delete
        siteControllerTemplates {
          ...SkupperSiteControllerTemplate
        }
      }
      clusterAdmin
      cluster {
        name
        serverUrl
        insecureSkipTLSVerify
        jumpHost {
          ...CommonJumphostFields
        }
        spec {
          private
        }
        automationToken {
          ...VaultSecret
        }
        clusterAdminAutomationToken {
          ...VaultSecret
        }
        internal
        disable {
          integrations
        }
        peering {
          connections {
            provider
            ... on ClusterPeeringConnectionClusterRequester_v1 {
              cluster {
                name
              }
            }
            ... on ClusterPeeringConnectionClusterAccepter_v1 {
              cluster {
                name
              }
            }
          }
        }
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class NamespaceSkupperSiteConfigV1(ConfiguredBaseModel):
    delete: Optional[bool] = Field(..., alias="delete")
    site_controller_templates: Optional[list[SkupperSiteControllerTemplate]] = Field(..., alias="siteControllerTemplates")


class ClusterSpecV1(ConfiguredBaseModel):
    private: bool = Field(..., alias="private")


class DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class ClusterPeeringConnectionV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class ClusterPeeringConnectionClusterRequesterV1_ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class ClusterPeeringConnectionClusterRequesterV1(ClusterPeeringConnectionV1):
    cluster: ClusterPeeringConnectionClusterRequesterV1_ClusterV1 = Field(..., alias="cluster")


class ClusterPeeringConnectionClusterAccepterV1_ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class ClusterPeeringConnectionClusterAccepterV1(ClusterPeeringConnectionV1):
    cluster: ClusterPeeringConnectionClusterAccepterV1_ClusterV1 = Field(..., alias="cluster")


class ClusterPeeringV1(ConfiguredBaseModel):
    connections: list[Union[ClusterPeeringConnectionClusterRequesterV1, ClusterPeeringConnectionClusterAccepterV1, ClusterPeeringConnectionV1]] = Field(..., alias="connections")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    server_url: str = Field(..., alias="serverUrl")
    insecure_skip_tls_verify: Optional[bool] = Field(..., alias="insecureSkipTLSVerify")
    jump_host: Optional[CommonJumphostFields] = Field(..., alias="jumpHost")
    spec: Optional[ClusterSpecV1] = Field(..., alias="spec")
    automation_token: Optional[VaultSecret] = Field(..., alias="automationToken")
    cluster_admin_automation_token: Optional[VaultSecret] = Field(..., alias="clusterAdminAutomationToken")
    internal: Optional[bool] = Field(..., alias="internal")
    disable: Optional[DisableClusterAutomationsV1] = Field(..., alias="disable")
    peering: Optional[ClusterPeeringV1] = Field(..., alias="peering")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    delete: Optional[bool] = Field(..., alias="delete")
    skupper_site: Optional[NamespaceSkupperSiteConfigV1] = Field(..., alias="skupperSite")
    cluster_admin: Optional[bool] = Field(..., alias="clusterAdmin")
    cluster: ClusterV1 = Field(..., alias="cluster")


class SkupperNetworkV1(ConfiguredBaseModel):
    identifier: str = Field(..., alias="identifier")
    site_controller_templates: list[SkupperSiteControllerTemplate] = Field(..., alias="siteControllerTemplates")
    namespaces: list[NamespaceV1] = Field(..., alias="namespaces")


class SkupperNetworksQueryData(ConfiguredBaseModel):
    skupper_networks: Optional[list[SkupperNetworkV1]] = Field(..., alias="skupper_networks")


def query(query_func: Callable, **kwargs: Any) -> SkupperNetworksQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        SkupperNetworksQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return SkupperNetworksQueryData(**raw_data)
