import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type REGISTRY::TEST::RESOURCE::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * Name for the bucket.
     *
     * @schema CfnModulePropsParameters#BucketName
     */
    readonly bucketName?: CfnModulePropsParametersBucketName;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#S3Bucket
     */
    readonly s3Bucket?: CfnModulePropsResourcesS3Bucket;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Name for the bucket.
 *
 * @schema CfnModulePropsParametersBucketName
 */
export interface CfnModulePropsParametersBucketName {
    /**
     * @schema CfnModulePropsParametersBucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersBucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersBucketName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersBucketName(obj: CfnModulePropsParametersBucketName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesS3Bucket
 */
export interface CfnModulePropsResourcesS3Bucket {
    /**
     * @schema CfnModulePropsResourcesS3Bucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesS3Bucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesS3Bucket' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesS3Bucket(obj: CfnModulePropsResourcesS3Bucket | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `REGISTRY::TEST::RESOURCE1::MODULE`.
 *
 * @external
 * @cloudformationResource REGISTRY::TEST::RESOURCE1::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "REGISTRY::TEST::RESOURCE1::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `REGISTRY::TEST::RESOURCE1::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
