from __future__ import annotations

from dataclasses import dataclass
from typing import Any, Dict

from rasa.dialogue_understanding.stack.frames import PatternFlowStackFrame
from rasa.shared.constants import RASA_DEFAULT_FLOW_PATTERN_PREFIX

FLOW_PATTERN_HUMAN_HANDOFF = RASA_DEFAULT_FLOW_PATTERN_PREFIX + "human_handoff"


@dataclass
class HumanHandoffPatternFlowStackFrame(PatternFlowStackFrame):
    """A pattern flow stack frame which hands off to a human."""

    flow_id: str = FLOW_PATTERN_HUMAN_HANDOFF
    """The ID of the flow."""

    @classmethod
    def type(cls) -> str:
        """Returns the type of the frame."""
        return FLOW_PATTERN_HUMAN_HANDOFF

    @staticmethod
    def from_dict(data: Dict[str, Any]) -> HumanHandoffPatternFlowStackFrame:
        """Creates a `DialogueStackFrame` from a dictionary.

        Args:
            data: The dictionary to create the `DialogueStackFrame` from.

        Returns:
            The created `DialogueStackFrame`.
        """
        return HumanHandoffPatternFlowStackFrame(
            frame_id=data["frame_id"],
            step_id=data["step_id"],
        )
