# Plugins list

## Official plugins

- [@semantic-release/commit-analyzer](https://github.com/semantic-release/commit-analyzer)
  - **Note**: this is already part of semantic-release and does not have to be installed separately
  - `analyzeCommits`: Determine the type of release by analyzing commits with [conventional-changelog](https://github.com/conventional-changelog/conventional-changelog)
- [@semantic-release/release-notes-generator](https://github.com/semantic-release/release-notes-generator)
  - **Note**: this is already part of semantic-release and does not have to be installed separately
  - `generateNotes`: Generate release notes for the commits added since the last release with [conventional-changelog](https://github.com/conventional-changelog/conventional-changelog)
- [@semantic-release/github](https://github.com/semantic-release/github)
  - **Note**: this is already part of semantic-release and does not have to be installed separately
  - `verifyConditions`: Verify the presence and the validity of the GitHub authentication and release configuration
  - `publish`: Publish a [GitHub release](https://help.github.com/articles/about-releases)
  - `success`: Add a comment to GitHub issues and pull requests resolved in the release
  - `fail`: Open a GitHub issue when a release fails
- [@semantic-release/npm](https://github.com/semantic-release/npm)
  - **Note**: this is already part of semantic-release and does not have to be installed separately
  - `verifyConditions`: Verify the presence and the validity of the npm authentication and release configuration
  - `prepare`: Update the package.json version and create the npm package tarball
  - `publish`: Publish the package on the npm registry
- [@semantic-release/gitlab](https://github.com/semantic-release/gitlab)
  - `verifyConditions`: Verify the presence and the validity of the GitLab authentication and release configuration
  - `publish`: Publish a [GitLab release](https://docs.gitlab.com/ee/user/project/releases/)
- [@semantic-release/git](https://github.com/semantic-release/git)
  - `verifyConditions`: Verify the presence and the validity of the Git authentication and release configuration
  - `prepare`: Push a release commit and tag, including configurable files
- [@semantic-release/changelog](https://github.com/semantic-release/changelog)
  - `verifyConditions`: Verify the presence and the validity of the configuration
  - `prepare`: Create or update the changelog file in the local project repository
- [@semantic-release/exec](https://github.com/semantic-release/exec)
  - `verifyConditions`: Execute a shell command to verify if the release should happen
  - `analyzeCommits`: Execute a shell command to determine the type of release
  - `verifyRelease`: Execute a shell command to verifying a release that was determined before and is about to be published
  - `generateNotes`: Execute a shell command to generate the release note
  - `prepare`: Execute a shell command to prepare the release
  - `publish`: Execute a shell command to publish the release
  - `success`: Execute a shell command to notify of a new release
  - `fail`: Execute a shell command to notify of a failed release
- [@semantic-release/apm](https://github.com/semantic-release/apm)
  - `verifyConditions`: Verify the presence of the `ATOM_ACCESS_TOKEN` environment variable and the [`apm`](https://github.com/atom/apm) CLI
  - `prepare`: Update the `package.json` version with [`npm version`](https://docs.npmjs.com/cli/version)
  - `publish`: Publish the [Atom package](https://flight-manual.atom.io/hacking-atom/sections/publishing)

## Community plugins

[Open a Pull Request](https://github.com/semantic-release/semantic-release/blob/master/CONTRIBUTING.md#submitting-a-pull-request) to add your plugin to the list.

- [semantic-release-slack-bot](https://github.com/juliuscc/semantic-release-slack-bot)
  - `verifyConditions`: Verify that the environment variable `SLACK_WEBHOOK` has been defined.
  - `success`: Publish a message about the success to a slack channel.
  - `fail`: Optionally publish a message about failure to a slack channel.
- [semantic-release-docker](https://github.com/felixfbecker/semantic-release-docker)
  - `verifyConditions`: Verify that all needed configuration is present and login to the Docker registry.
  - `publish`: Tag the image specified by `name` with the new version, push it to Docker Hub and update the latest tag
- [@semantic-release-plus/docker](https://github.com/semantic-release-plus/semantic-release-plus/tree/master/packages/plugins/docker)
  - `verifyConditions`: Verify that all needed configuration is present and login to the configured docker registry.
  - `publish`: Tag the image specified by `name` with the new version and channel and push it to the configured docker registry.
  - `addChannel`: Updates a release published on one channel with the destinations channel tag and pushes to the registry i.e.: next to latest.
- [semantic-release-gcr](https://github.com/carlos-cubas/semantic-release-gcr)
  - `verifyConditions`: Verify that all needed configuration is present and login to the Docker registry
  - `publish`: Tag the image specified by `name` with the new version, push it to Docker Hub and update the latest tag
- [semantic-release-vsce](https://github.com/raix/semantic-release-vsce)
  - `verifyConditions`: Verify the presence and the validity of the "VS Code extension" authentication and release configuration
  - `prepare`: Create a `.vsix` for distribution
  - `publish`: Publish the package to the Visual Studio Code marketplace
- [semantic-release-verify-deps](https://github.com/piercus/semantic-release-verify-deps)
  - `verifyConditions`: Check the dependencies format against a regexp before a release
- [semantic-release-openapi](https://github.com/aensley/semantic-release-openapi)
  - `verifyConditions`: Verify `apiSpecFiles` is specified with at least one file name and all matching files have a .json, .yaml, or .yml extension.
  - `prepare`: Write the correct version to all OpenAPI / Swagger files specified in `apiSpecFiles`.
- [semantic-release-chrome](https://github.com/GabrielDuarteM/semantic-release-chrome)
  - `verifyConditions`: Verify the presence of the authentication (set via environment variables)
  - `prepare`: Write the correct version to the `manifest.json` and creates a zip file of the whole dist folder
  - `publish`: Uploads the generated zip file to the webstore, and publish the item
- [semantic-release-firefox-add-on](https://github.com/tophat/semantic-release-firefox-add-on)
  - `verifyConditions`: Verify that all required options are present and authentication is set via environment variables
  - `prepare`: Write the correct version to the `manifest.json`
  - `publish`: Creates an unsigned `.xpi` file, and submits it to the Mozilla Add On store for signing. Once the package is signed, downloads the signed `.xpi` to a local directory
- [semantic-release-gerrit](https://github.com/pascalMN/semantic-release-gerrit)
  - `generateNotes`: Generate release notes with Gerrit reviews URL
- [semantic-release-expo](https://github.com/bycedric/semantic-release-expo)
  - `verifyConditions`: Verify Expo manifest(s) are readable and valid.
  - `prepare`: Update version, ios build number and android version code in the Expo manifest(s).
- [maven-semantic-release](https://github.com/conveyal/maven-semantic-release)
  - `verifyConditions`: Verifies that the `pom.xml` file and other files exist and are setup to allow releases
  - `verifyRelease`: Checks and warns (does not error by default) if the version numbers found on maven central and within the Git project differ by quite a bit
  - `prepare`: Changes the version number in the `pom.xml` (or all `pom.xml` files in maven projects with multiple `pom.xml` files) and optionally creates a commit with this version number and pushes it to `master`
  - `publish`: Runs `mvn deploy` to deploy to maven central and optionally will update to next snapshot version and merge changes to development branch
- [maven-semantic-release](https://github.com/terrestris/maven-semantic-release) (alternative version)
  - `verifyConditions`: Verifies that the `mvn` command exists.
  - `prepare`: Changes version number in `pom.xml` and optionally in all child modules.
  - `publish`: Runs one of the mvn targets `deploy`, `package jib:build` or `deploy jib:build`.
  - `success`: Optionally sets new snapshot version and commits it.
- [semantic-release-ado](https://github.com/lluchmk/semantic-release-ado)
  - `prepare`: Stores the version number as an Azure DevOps pipeline variable available to downstream steps on the job
- [gradle-semantic-release](https://github.com/KengoTODA/gradle-semantic-release-plugin)
  - `verifyConditions`: Verify that project has a Gradle wrapper script, and `build.gradle` contains a task to publish artifacts.
  - `prepare`: Changes the version number in the `gradle.properties`
  - `publish`: Triggers Gradle to publish artifacts.
- [semantic-release-circleci-orb](https://github.com/matt-oakes/semantic-release-circleci-orb)
  - `verifyConditions`: Verify the presence of the `CIRCLECI_API_TOKEN` environment variable, `orbName` option, and the `circleci` CLI.
  - `publish`: Publish the CircleCI orb.
- [semantic-release-github-pages](https://github.com/qiwi/semantic-release-gh-pages-plugin)
  - `verifyConditions`: Verify the presence of the auth token set via environment variables.
  - `publish`: Pushes commit to the documentation branch.
- [semantic-release-github-pullrequest](https://github.com/asbiin/semantic-release-github-pullrequest)
  - `verifyConditions`: Verify the presence and the validity of the GitHub authentication and other configuration.
  - `publish`: Create a branch to upload all assets and create the pull request on the base branch on GitHub.
- [leiningen-semantic-release](https://github.com/NoxHarmonium/leiningen-semantic-release)
  - `verifyConditions`: Checks the project.clj is syntactically valid.
  - `prepare`: Update the project.clj version and package the output jar file.
  - `publish`: Publish the jar (and generated Maven metadata) to a maven repository (or clojars).
- [@saithodev/semantic-release-gitea](https://github.com/saitho/semantic-release-gitea)
  - `verifyConditions`: Verify the presence and the validity of the authentication and the assets option configuration.
  - `publish`: Publish a Gitea release, optionally uploading file assets.
  - `addChannel`: Update a Gitea release's pre-release field.
- [semantic-release-replace-plugin](https://github.com/jpoehnelt/semantic-release-replace-plugin)
  - `prepare`: Replace version strings in files using regex and glob.
- [semantic-release-rubygem](https://github.com/Gusto/semantic-release-rubygem)
  - `verifyConditions`: Locate and validate a `.gemspec` file, locate and validate a `lib/**/version.rb` file, verify the presence of the `GEM_HOST_API_KEY` environment variable, and create a credentials file with the API key.
  - `prepare`: Update the version in the `lib/**/version.rb` version file and [build](https://guides.rubygems.org/command-reference/#gem-build) the gem.
  - `publish`: [Push the Ruby gem](https://guides.rubygems.org/command-reference/#gem-push) to the gem server.
- [semantic-release-npm-deprecate-old-versions](https://github.com/ghusse/semantic-release-npm-deprecate-old-versions)
  - `verifyConditions`: Validates configuration.
  - `publish`: Deprecates old versions, based on the declaration of supported versions in the config.
- [amanda-mitchell/semantic-release-npm-multiple](https://github.com/amanda-mitchell/semantic-release-npm-multiple)
  - **Note**: this is a thin wrapper around the built-in npm plugin that can target multiple registries
  - `verifyConditions`: Verify the presence and the validity of the npm authentication and release configuration for multiple registries
  - `prepare`: Update the package.json version and create the npm package tarball
  - `publish`: Publish the package on the npm registry for multiple registries
- [semantic-release-license](https://github.com/cbhq/semantic-release-license) Automatically update dates and more in your license file for new releases.
  - `verifyConditions`: Verify the presence of a license file
  - `prepare`: Update the license file based on its type
- [semantic-release-pypi](https://github.com/abichinger/semantic-release-pypi)
  - `verifyConditions`: Verify the environment variable `PYPI_TOKEN` and installation of build tools
  - `prepare`: Update the version in `setup.cfg` and create the distribution packages
  - `publish`: Publish the python package to a repository (default: pypi)
- [@covage/semantic-release-poetry-plugin](https://github.com/covage/semantic-release-poetry-plugin)
  - `verifyConditions`: Verify the presence and validity of `pyproject.toml` file.
  - `prepare`: Update the version in `pyproject.toml`.
- [semantic-release-codeartifact](https://github.com/ryansonshine/semantic-release-codeartifact)
  - `verifyConditions`: Validate configuration, get AWS CodeArtifact authentication and repository, validate `publishConfig` or `.npmrc` (if they exist), then pass the configuration to the associated plugins.
- [semantic-release-telegram](https://github.com/pustovitDmytro/semantic-release-telegram)
  - `verifyConditions`: Validate configuration and verify `TELEGRAM_BOT_ID` and `TELEGRAM_BOT_TOKEN`
  - `success`: Publish a message about the successful release to a telegram chat
  - `fail`: publish a message about failure to a telegram chat
- [semantic-release-heroku](https://github.com/pustovitDmytro/semantic-release-heroku)
  - `verifyConditions`: Validate configuration and verify `HEROKU_API_KEY`
  - `prepare`: Update the package.json version and create release tarball
  - `publish`: Publish version to heroku
- [semantic-release-mattermost](https://github.com/ttrobisch/semantic-release-mattermost)
  - `verifyConditions`: Verify that the webhook is setup and release-notes-generator is present.
  - `success`: Send a message about the new release and its notes to a [mattermost](https://mattermost.com/) webhook.
- [semantic-release-github-milestones](https://github.com/nitzano/semantic-release-github-milestones)
  - `verifyConditions`: Verify github tokens are present and valid.
  - `verifyRelease`: Display information regarding the matching github milestone.
- [semantic-release-telegram-bot](https://github.com/skoropadas/semantic-release-telegram-bot)
  - `verifyConditions`: Validate configuration and verify `TELEGRAM_BOT_TOKEN` and package name
  - `success`: Publish a success message to certain telegram chats
  - `fail`: Publish a fail message to certain telegram chats
- [semantic-release-npm-deprecate](https://github.com/jpoehnelt/semantic-release-npm-deprecate)
  - `publish`: Automatically mark old versions as deprecated.
- [semantic-release-mirror-version](https://github.com/GarthDB/semantic-release-mirror-version)
  - `prepare`: Update the version number in any file that matches the defined [file glob](https://github.com/isaacs/node-glob).
- [semantic-release-space](https://github.com/123FLO321/semantic-release-space)
  - `verifyConditions` Verifies that all required options are set.
  - `prepare` Creates a JetBrains Space Deployment Target if it does not yet exist.
  - `publish` Starts a JetBrains Space Deployment.
  - `success` Marks the JetBrains Space Deployment as completed.
  - `fail` Marks the JetBrains Space Deployment as failed.
- [semantic-release-react-native](https://github.com/alexandermendes/semantic-release-react-native)
  - `verifyConditions` Validate configuration.
  - `prepare` Version native iOS and Android files.
- [semantic-release-cargo](https://github.com/buehler/semantic-release-cargo)
  - `verifyConditions` Validate configuration, `Cargo.toml`, and local cargo executable. Also, logs in into `crates.io`.
  - `prepare` Write the new version number into `Cargo.toml` file and perform `cargo check` if configured.
  - `publish` Publish the Rust crate to `crates.io`
- [semantic-release-coralogix](https://github.com/adobe/semantic-release-coralogix)
  - `verifyConditions` Verified that required credentials are provided and API is accessible
  - `publish` add a release tag to Coralogix
- [semantic-release-jira-notes](https://github.com/iamludal/semantic-release-jira-notes)
  - `verifyConditions`: Validate the config options.
  - `generateNotes`: Generate the release notes with links to JIRA issues.
- [semantic-release-major-tag](https://github.com/doteric/semantic-release-major-tag)
  - `success` Create major version tag, for example `v1`.
- [semantic-release-yarn](https://github.com/hongaar/semantic-release-yarn)
  - **Note**: this is an alternative to the default `@semantic-release/npm` plugin and adds support for monorepos.
  - `verifyConditions` Verify Yarn 2 or higher is installed, verify the presence of a NPM auth token (either in an environment variable or a `.yarnrc.yml` file) and verify the authentication method is valid.
  - `prepare` Update the `package.json` version and create the package tarball.
  - `addChannel` Add a tag for the release.
  - `publish` Publish to the npm registry.
- [semantic-release-pub](https://github.com/zeshuaro/semantic-release-pub)
  - `verifyConditions`: Verify the presence of the `pub.dev` authentication and release configuration
  - `prepare`: Update the `pubspec.yaml` version
  - `publish`: Publish the package onto the `pub.dev` registry
- [semantic-release-hackage](https://github.com/stackbuilders/semantic-release-hackage)
  - `verifyConditions`: Verify the environment variable `HACKAGE_TOKEN`
  - `prepare`: Update the version of .cabal file and create the distribution package (.tar)
  - `publish`: Publish the release candidate to the specified repository in Hackage
- [semantic-release-pull-request-analyzer](https://github.com/bobvanderlinden/semantic-release-pull-request-analyzer)
  - `verifyConditions` Verify configuration options and existance of GitHub token.
  - `analyzeCommits` Determine the type of release by analyzing merged GitHub pull requests and their labels.
  - `generateNotes` Generates release notes using [GitHub release notes generator](https://docs.github.com/en/repositories/releasing-projects-on-github/automatically-generated-release-notes).
- [semantic-release-commits-lint](https://github.com/BondarenkoAlex/semantic-release-commits-lint)
  - `analyzeCommits` Analyzing commit messages by [commitlint](https://github.com/conventional-changelog/commitlint).
- [semantic-release-kaniko](https://github.com/brendangeck/semantic-release-kaniko)
  - `verifyConditions`: Verify that all needed configuration is present and login to the Docker registry.
  - `publish`: Build a container image using [Kaniko](https://github.com/GoogleContainerTools/kaniko) and (optionally) push it to a Docker registry.
