# bivital

[![PyPI - Version](https://img.shields.io/pypi/v/bivital)](https://pypi.org/project/bivital/)
[![Python Versions](https://img.shields.io/pypi/pyversions/bivital.svg)](https://pypi.org/project/bivital/)
[![License](https://img.shields.io/pypi/l/bivital)](https://pypi.org/project/bivital/)

**bivital** is the official Python library for the BI-Vital data workflow.  
It helps you organize, preprocess, and manage measurement projects, series, and raw data collected via BI-Vital systems.

---

## 🚀 Features

- Project structure setup
- Series and data import
- Label management
- Command-line tool (`bvtool`) for fast interaction
- Optional Jupyter workflow extras (`[notebook]`)

---

## 📦 Installation

> **Requires Python ≥ 3.10**  
> (3.11/3.12 recommended)

### Stable release (PyPI)
```bash
pip install bivital
```

### With notebook extras
```bash
pip install "bivital[notebook]"
```

### From source (local checkout)
```bash
# in the repo root
pip install .
# or in editable/development mode (plus notebook extras)
pip install -e ".[notebook]"
```

---

## 🛠 Usage

### Command-Line Interface (CLI)
```bash
bvtool -h
bvtool project -p PATH -n NAME
bvtool series  -p PATH -n NAME
bvtool data    -p PATH -s pc
bvtool label   -p PATH
```

### Python (minimal check)
```python
import bivital
print("bivital version:", getattr(bivital, "__version__", "unknown"))
```

---

## 📂 Example Project Structure
```
BiVitalProject/
├── Series1/
│   └── MAC_01/
│       └── log_01.csv
└── Series2/
    └── ...
```

---

## 💬 Support & Contributing

- Issues & feature requests: https://gitlab.ub.uni-bielefeld.de/bi-vital-open-source/py_bivital/-/issues  
- Homepage: https://bivital.eu/

Contributions are welcome—please open an issue to discuss changes first.

---

## 📜 License

MIT © University Bielefeld
