# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Iterable
from typing_extensions import Required, Annotated, TypedDict

from .._types import SequenceNotStr
from .._utils import PropertyInfo

__all__ = ["CampaignBuilderCreateParams"]


class CampaignBuilderCreateParams(TypedDict, total=False):
    brand_id: Required[Annotated[str, PropertyInfo(alias="brandId")]]
    """Alphanumeric identifier of the brand associated with this campaign."""

    description: Required[str]
    """Summary description of this campaign."""

    usecase: Required[str]
    """Campaign usecase.

    Must be of defined valid types. Use `/registry/enum/usecase` operation to
    retrieve usecases available for given brand.
    """

    age_gated: Annotated[bool, PropertyInfo(alias="ageGated")]
    """Age gated message content in campaign."""

    auto_renewal: Annotated[bool, PropertyInfo(alias="autoRenewal")]
    """Campaign subscription auto-renewal option.

    If set to true, then campaign will automatically renewal at end of billing
    cycle.
    """

    direct_lending: Annotated[bool, PropertyInfo(alias="directLending")]
    """Direct lending or loan arrangement"""

    embedded_link: Annotated[bool, PropertyInfo(alias="embeddedLink")]
    """Does message generated by the campaign include URL link in SMS?"""

    embedded_link_sample: Annotated[str, PropertyInfo(alias="embeddedLinkSample")]
    """Sample of an embedded link that will be sent to subscribers."""

    embedded_phone: Annotated[bool, PropertyInfo(alias="embeddedPhone")]
    """Does message generated by the campaign include phone number in SMS?"""

    help_keywords: Annotated[str, PropertyInfo(alias="helpKeywords")]
    """Subscriber help keywords. Multiple keywords are comma separated without space."""

    help_message: Annotated[str, PropertyInfo(alias="helpMessage")]
    """Help message of the campaign."""

    message_flow: Annotated[str, PropertyInfo(alias="messageFlow")]
    """Message flow description."""

    mno_ids: Annotated[Iterable[int], PropertyInfo(alias="mnoIds")]
    """Submit campaign to given list of MNOs by MNO's network ID.

    Default is all MNOs if no value provided.
    """

    number_pool: Annotated[bool, PropertyInfo(alias="numberPool")]
    """Does campaign utilize pool of phone numbers?"""

    optin_keywords: Annotated[str, PropertyInfo(alias="optinKeywords")]
    """Subscriber opt-in keywords.

    Multiple keywords are comma separated without space.
    """

    optin_message: Annotated[str, PropertyInfo(alias="optinMessage")]
    """Subscriber opt-in message."""

    optout_keywords: Annotated[str, PropertyInfo(alias="optoutKeywords")]
    """Subscriber opt-out keywords.

    Multiple keywords are comma separated without space.
    """

    optout_message: Annotated[str, PropertyInfo(alias="optoutMessage")]
    """Subscriber opt-out message."""

    privacy_policy_link: Annotated[str, PropertyInfo(alias="privacyPolicyLink")]
    """Link to the campaign's privacy policy."""

    reference_id: Annotated[str, PropertyInfo(alias="referenceId")]
    """Caller supplied campaign reference ID.

    If supplied, the value must be unique across all submitted campaigns. Can be
    used to prevent duplicate campaign registrations.
    """

    reseller_id: Annotated[str, PropertyInfo(alias="resellerId")]
    """
    Alphanumeric identifier of the reseller that you want to associate with this
    campaign.
    """

    sample1: str
    """Message sample. Some campaign tiers require 1 or more message samples."""

    sample2: str
    """Message sample. Some campaign tiers require 2 or more message samples."""

    sample3: str
    """Message sample. Some campaign tiers require 3 or more message samples."""

    sample4: str
    """Message sample. Some campaign tiers require 4 or more message samples."""

    sample5: str
    """Message sample. Some campaign tiers require 5 or more message samples."""

    subscriber_help: Annotated[bool, PropertyInfo(alias="subscriberHelp")]
    """Does campaign responds to help keyword(s)?"""

    subscriber_optin: Annotated[bool, PropertyInfo(alias="subscriberOptin")]
    """Does campaign require subscriber to opt-in before SMS is sent to subscriber?"""

    subscriber_optout: Annotated[bool, PropertyInfo(alias="subscriberOptout")]
    """Does campaign support subscriber opt-out keyword(s)?"""

    sub_usecases: Annotated[SequenceNotStr[str], PropertyInfo(alias="subUsecases")]
    """Campaign sub-usecases.

    Must be of defined valid sub-usecase types. Use `/registry/enum/usecase`
    operation to retrieve list of valid sub-usecases
    """

    tag: SequenceNotStr[str]
    """Tags to be set on the Campaign."""

    terms_and_conditions: Annotated[bool, PropertyInfo(alias="termsAndConditions")]
    """Is terms and conditions accepted?"""

    terms_and_conditions_link: Annotated[str, PropertyInfo(alias="termsAndConditionsLink")]
    """Link to the campaign's terms and conditions."""

    webhook_failover_url: Annotated[str, PropertyInfo(alias="webhookFailoverURL")]
    """Failover webhook to which campaign status updates are sent."""

    webhook_url: Annotated[str, PropertyInfo(alias="webhookURL")]
    """Webhook to which campaign status updates are sent."""
