# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from datetime import datetime
from typing_extensions import Literal

from .._models import BaseModel
from .number_pool_settings import NumberPoolSettings
from .url_shortener_settings import URLShortenerSettings

__all__ = ["MessagingProfile"]


class MessagingProfile(BaseModel):
    id: Optional[str] = None
    """Identifies the type of resource."""

    alpha_sender: Optional[str] = None
    """
    The alphanumeric sender ID to use when sending to destinations that require an
    alphanumeric sender ID.
    """

    created_at: Optional[datetime] = None
    """ISO 8601 formatted date indicating when the resource was created."""

    daily_spend_limit: Optional[str] = None
    """
    The maximum amount of money (in USD) that can be spent by this profile before
    midnight UTC.
    """

    daily_spend_limit_enabled: Optional[bool] = None
    """Whether to enforce the value configured by `daily_spend_limit`."""

    enabled: Optional[bool] = None
    """Specifies whether the messaging profile is enabled or not."""

    mms_fall_back_to_sms: Optional[bool] = None
    """enables SMS fallback for MMS messages."""

    mms_transcoding: Optional[bool] = None
    """enables automated resizing of MMS media."""

    name: Optional[str] = None
    """A user friendly name for the messaging profile."""

    number_pool_settings: Optional[NumberPoolSettings] = None
    """
    Number Pool allows you to send messages from a pool of numbers of different
    types, assigning weights to each type. The pool consists of all the long code
    and toll free numbers assigned to the messaging profile.

    To disable this feature, set the object field to `null`.
    """

    record_type: Optional[Literal["messaging_profile"]] = None
    """Identifies the type of the resource."""

    updated_at: Optional[datetime] = None
    """ISO 8601 formatted date indicating when the resource was updated."""

    url_shortener_settings: Optional[URLShortenerSettings] = None
    """
    The URL shortener feature allows automatic replacement of URLs that were
    generated using a public URL shortener service. Some examples include bit.do,
    bit.ly, goo.gl, ht.ly, is.gd, ow.ly, rebrand.ly, t.co, tiny.cc, and tinyurl.com.
    Such URLs are replaced with with links generated by Telnyx. The use of custom
    links can improve branding and message deliverability.

    To disable this feature, set the object field to `null`.
    """

    v1_secret: Optional[str] = None
    """Secret used to authenticate with v1 endpoints."""

    webhook_api_version: Optional[Literal["1", "2", "2010-04-01"]] = None
    """
    Determines which webhook format will be used, Telnyx API v1, v2, or a legacy
    2010-04-01 format.
    """

    webhook_failover_url: Optional[str] = None
    """
    The failover URL where webhooks related to this messaging profile will be sent
    if sending to the primary URL fails.
    """

    webhook_url: Optional[str] = None
    """The URL where webhooks related to this messaging profile will be sent."""

    whitelisted_destinations: Optional[List[str]] = None
    """Destinations to which the messaging profile is allowed to send.

    The elements in the list must be valid ISO 3166-1 alpha-2 country codes. If set
    to `["*"]`, all destinations will be allowed.
    """
