# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Optional
from typing_extensions import Literal, Required, TypedDict

from .._types import SequenceNotStr
from .number_pool_settings_param import NumberPoolSettingsParam
from .url_shortener_settings_param import URLShortenerSettingsParam

__all__ = ["MessagingProfileCreateParams"]


class MessagingProfileCreateParams(TypedDict, total=False):
    name: Required[str]
    """A user friendly name for the messaging profile."""

    whitelisted_destinations: Required[SequenceNotStr[str]]
    """Destinations to which the messaging profile is allowed to send.

    The elements in the list must be valid ISO 3166-1 alpha-2 country codes. If set
    to `["*"]` all destinations will be allowed.
    """

    alpha_sender: Optional[str]
    """
    The alphanumeric sender ID to use when sending to destinations that require an
    alphanumeric sender ID.
    """

    daily_spend_limit: str
    """
    The maximum amount of money (in USD) that can be spent by this profile before
    midnight UTC.
    """

    daily_spend_limit_enabled: bool
    """Whether to enforce the value configured by `daily_spend_limit`."""

    enabled: bool
    """Specifies whether the messaging profile is enabled or not."""

    mms_fall_back_to_sms: bool
    """enables SMS fallback for MMS messages."""

    mms_transcoding: bool
    """enables automated resizing of MMS media."""

    number_pool_settings: Optional[NumberPoolSettingsParam]
    """
    Number Pool allows you to send messages from a pool of numbers of different
    types, assigning weights to each type. The pool consists of all the long code
    and toll free numbers assigned to the messaging profile.

    To disable this feature, set the object field to `null`.
    """

    url_shortener_settings: Optional[URLShortenerSettingsParam]
    """
    The URL shortener feature allows automatic replacement of URLs that were
    generated using a public URL shortener service. Some examples include bit.do,
    bit.ly, goo.gl, ht.ly, is.gd, ow.ly, rebrand.ly, t.co, tiny.cc, and tinyurl.com.
    Such URLs are replaced with with links generated by Telnyx. The use of custom
    links can improve branding and message deliverability.

    To disable this feature, set the object field to `null`.
    """

    webhook_api_version: Literal["1", "2", "2010-04-01"]
    """
    Determines which webhook format will be used, Telnyx API v1, v2, or a legacy
    2010-04-01 format.
    """

    webhook_failover_url: Optional[str]
    """
    The failover URL where webhooks related to this messaging profile will be sent
    if sending to the primary URL fails.
    """

    webhook_url: Optional[str]
    """The URL where webhooks related to this messaging profile will be sent."""
